/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import org.jrobin.core.RrdException;
import org.jrobin.graph.GridRange;
import org.jrobin.graph.ValueAxisUnit;
import org.jrobin.graph.ValueMarker;

class ValueGrid {
    private boolean rigid;
    private double lower;
    private double upper;
    private double baseValue = 1000.0;
    private double[] scaleValues = new double[]{1.0E18, 1.0E15, 1.0E12, 1.0E9, 1000000.0, 1000.0, 1.0, 0.001, 1.0E-6, 1.0E-9, 1.0E-12, 1.0E-15};
    private ValueAxisUnit vAxis;

    ValueGrid(GridRange gridRange, double d, double d2, ValueAxisUnit valueAxisUnit, double d3) throws RrdException {
        double d4 = Double.MAX_VALUE;
        double d5 = Double.MIN_VALUE;
        if (gridRange != null) {
            this.rigid = gridRange.isRigid();
            d4 = gridRange.getLowerValue();
            d5 = gridRange.getUpperValue();
        }
        this.lower = d;
        this.upper = d2;
        this.vAxis = valueAxisUnit;
        if (d3 != this.baseValue) {
            int n;
            this.baseValue = d3;
            double d6 = 1.0;
            for (n = 1; n < 7; ++n) {
                this.scaleValues[6 - n] = d6 *= this.baseValue;
            }
            d6 = 1.0;
            for (n = 7; n < this.scaleValues.length; ++n) {
                this.scaleValues[n] = 1.0 / (d6 *= this.baseValue);
            }
        }
        this.setValueAxis();
        if (!this.rigid) {
            this.lower = this.lower == d4 ? d4 : this.vAxis.getNiceLower(this.lower);
            this.upper = this.upper == d5 ? d5 : this.vAxis.getNiceHigher(this.upper);
        }
    }

    double getLowerValue() {
        return this.lower;
    }

    double getUpperValue() {
        return this.upper;
    }

    ValueMarker[] getValueMarkers() {
        return this.vAxis.getValueMarkers(this.lower, this.upper);
    }

    private void setValueAxis() throws RrdException {
        int n;
        double d;
        if (this.vAxis != null) {
            return;
        }
        if (Double.isNaN(this.upper) || this.upper == Double.MIN_VALUE || this.upper == Double.MAX_VALUE) {
            this.upper = 0.9;
        }
        if (Double.isNaN(this.lower) || this.lower == Double.MAX_VALUE || this.lower == Double.MIN_VALUE) {
            this.lower = 0.0;
        }
        if (!this.rigid && this.upper == 0.0 && this.upper == this.lower) {
            this.upper = 0.9;
        }
        if ((d = Math.abs(this.upper - this.lower)) == 0.0) {
            d = this.upper;
        }
        double d2 = 1.0;
        for (n = this.scaleValues.length - 1; n >= 0 && this.scaleValues[n] < d; --n) {
        }
        if (this.scaleValues[++n] != 0.0) {
            d /= this.scaleValues[n];
        }
        if (Double.isInfinite(d)) {
            throw new RrdException("ValueGrid failure: u=" + this.upper + " l=" + this.lower + " sv=" + this.scaleValues[n]);
        }
        while (d > 10.0) {
            d /= 10.0;
            d2 *= 10.0;
        }
        while (d < 1.0) {
            d *= 10.0;
            d2 /= 10.0;
        }
        this.vAxis = d <= 2.0 ? new ValueAxisUnit(0.1 * d2 * this.scaleValues[n], 0.5 * d2 * this.scaleValues[n]) : (d <= 4.0 ? new ValueAxisUnit(0.2 * d2 * this.scaleValues[n], 1.0 * d2 * this.scaleValues[n]) : (d <= 6.0 ? new ValueAxisUnit(0.5 * d2 * this.scaleValues[n], 1.0 * d2 * this.scaleValues[n]) : new ValueAxisUnit(1.0 * d2 * this.scaleValues[n], 2.0 * d2 * this.scaleValues[n])));
    }
}

