/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;
import java.util.StringTokenizer;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;

public class Sample {
    private RrdDb parentDb;
    private long time;
    private String[] dsNames;
    private double[] values;

    Sample(RrdDb rrdDb, long l) throws IOException {
        this.parentDb = rrdDb;
        this.time = l;
        this.dsNames = rrdDb.getDsNames();
        this.values = new double[this.dsNames.length];
        this.clearCurrentValues();
    }

    private void clearCurrentValues() {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = Double.NaN;
        }
    }

    public void setValue(String string, double d) throws RrdException {
        for (int i = 0; i < this.values.length; ++i) {
            if (!this.dsNames[i].equals(string)) continue;
            this.values[i] = d;
            return;
        }
        throw new RrdException("Datasource " + string + " not found");
    }

    public void setValue(int n, double d) throws RrdException {
        if (n < this.values.length) {
            this.values[n] = d;
            return;
        }
        throw new RrdException("Sample datasource index " + n + " out of bounds");
    }

    public void setValues(double[] dArray) throws RrdException {
        if (dArray.length <= this.values.length) {
            for (int i = 0; i < dArray.length; ++i) {
                this.values[i] = dArray[i];
            }
        } else {
            throw new RrdException("Invalid number of values specified (found " + dArray.length + ", only " + this.dsNames.length + " allowed)");
        }
    }

    public double[] getValues() {
        return this.values;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long l) {
        this.time = l;
    }

    public String[] getDsNames() {
        return this.dsNames;
    }

    public void set(String string) throws RrdException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":", false);
        int n = stringTokenizer.countTokens();
        if (n > this.values.length + 1) {
            throw new RrdException("Invalid number of values specified (found " + this.values.length + ", " + this.dsNames.length + " allowed)");
        }
        String string2 = stringTokenizer.nextToken();
        try {
            this.time = Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            if (string2.equalsIgnoreCase("N") || string2.equalsIgnoreCase("NOW")) {
                this.time = Util.getTime();
            }
            throw new RrdException("Invalid sample timestamp: " + string2);
        }
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            try {
                this.values[n2] = Double.parseDouble(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n2;
        }
    }

    public void update() throws IOException, RrdException {
        this.parentDb.store(this);
        this.clearCurrentValues();
    }

    public void setAndUpdate(String string) throws IOException, RrdException {
        this.set(string);
        this.update();
    }

    public String dump() {
        StringBuffer stringBuffer = new StringBuffer("update \"");
        stringBuffer.append(this.parentDb.getRrdBackend().getPath() + "\" " + this.time);
        for (int i = 0; i < this.values.length; ++i) {
            stringBuffer.append(":");
            stringBuffer.append(Util.formatDouble(this.values[i], "U", false));
        }
        return stringBuffer.toString();
    }

    String getRrdToolCommand() {
        return this.dump();
    }
}

