/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma.model;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.videolan.vlma.model.Adapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Server
implements Serializable {
    private static final long serialVersionUID = -5390025642339613011L;
    private Integer id;
    private List<Adapter> adapters = new ArrayList<Adapter>();
    private InetAddress ip;
    private boolean isUp;
    private String name;

    public Server() {
        this.setUp(true);
        try {
            this.ip = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public Server(String name, InetAddress ip) {
        this();
        this.name = name;
        this.ip = ip;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Server)) {
            return false;
        }
        Server server = (Server)o;
        return server.getIp().equals(this.getIp());
    }

    public List<Adapter> getAdapters() {
        return this.adapters;
    }

    public void addAdapter(Adapter adapter) {
        this.adapters.add(adapter);
    }

    public void removeAdapter(Adapter adapter) {
        this.adapters.remove(adapter);
    }

    public int getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public InetAddress getIp() {
        return this.ip;
    }

    public String getName() {
        return this.name;
    }

    public boolean getUp() {
        return this.isUp();
    }

    public int hashCode() {
        return this.ip.hashCode();
    }

    public boolean isUp() {
        return this.isUp;
    }

    public void setIp(InetAddress ip) {
        this.ip = ip;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUp(boolean isUp) {
        this.isUp = isUp;
    }
}

