/*
 * Decompiled with CFR 0.152.
 */
package rath.msnm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import rath.msnm.entity.MsnFriend;

public class BuddyList {
    private final String name;
    private List list = null;
    private Map map = null;
    private Map codeMap = null;

    public BuddyList(String name) {
        this.name = name;
        this.list = Collections.synchronizedList(new ArrayList());
        this.map = Collections.synchronizedMap(new HashMap());
        this.codeMap = Collections.synchronizedMap(new HashMap());
    }

    public String getName() {
        return this.name;
    }

    public void add(MsnFriend friend) {
        String loginName = friend.getLoginName();
        Object o = null;
        Object v = this.map.get(loginName);
        o = v;
        if (v != null) {
            MsnFriend old = o;
            old.setFriendlyName(friend.getFriendlyName());
            old.setStatus(friend.getStatus());
        } else {
            this.list.add(friend);
            this.map.put(loginName, friend);
            this.codeMap.put(friend.getCode(), friend);
        }
    }

    public void remove(MsnFriend friend) {
        this.list.remove(friend);
        this.map.remove(friend.getLoginName());
        this.codeMap.remove(friend.getCode());
    }

    public void remove(String loginName) {
        Object o = this.map.remove(loginName);
        if (o != null) {
            this.list.remove(o);
            this.codeMap.remove(((MsnFriend)o).getCode());
        }
    }

    public void removeAsCode(String code) {
        Object o = this.codeMap.remove(code);
        if (o != null) {
            this.list.remove(o);
            this.map.remove(((MsnFriend)o).getLoginName());
        }
    }

    public MsnFriend get(int index) {
        return (MsnFriend)this.list.get(index);
    }

    public MsnFriend getAsCode(String code) {
        return (MsnFriend)this.codeMap.get(code);
    }

    public MsnFriend get(String loginName) {
        return (MsnFriend)this.map.get(loginName);
    }

    public void set(MsnFriend friend) {
        MsnFriend mf = this.get(friend.getLoginName());
        if (mf == null) {
            throw new IllegalArgumentException(friend.getLoginName() + " not found on " + this.getName());
        }
        mf.setFriendlyName(friend.getFriendlyName());
        mf.setStatus(friend.getStatus());
    }

    public void setOffline(String loginName) {
        MsnFriend mf = this.get(loginName);
        if (mf != null) {
            mf.setStatus("FLN");
        }
    }

    public Iterator iterator() {
        return this.list.iterator();
    }

    public int size() {
        return this.list.size();
    }

    public synchronized void sort(Comparator comp) {
        Collections.sort(this.list, comp);
    }

    public void clear() {
        this.list.clear();
        this.map.clear();
        this.codeMap.clear();
    }
}

