/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma.watcher;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.videolan.vlma.model.Program;
import org.videolan.vlma.watcher.StreamWatcher;

public class ExtremeStreamWatcher
implements StreamWatcher,
Serializable {
    private static final long serialVersionUID = -9218318159140960961L;
    private static final Logger logger = Logger.getLogger(ExtremeStreamWatcher.class);
    private static final int TELNET_DEFAULT_WAIT = 100;
    private static final int TELNET_DEFAULT_DELAY = 1000;
    private static final String ROUTER_HOST = "138.195.131.126";
    private static final int ROUTER_PORT = 23;
    private static final String ROUTER_USER = "user";
    private static final String ROUTER_PASSWORD = "via";
    private static final String ROUTER_VLAN = "vlip-videolan";

    public boolean isPlayed(Program program) {
        boolean result = false;
        StringBuilder toParse = new StringBuilder();
        logger.debug((Object)"Connect to the router to get the stream state.");
        try {
            Socket socket = new Socket(ROUTER_HOST, 23);
            PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            out.println(ROUTER_USER);
            out.println(ROUTER_PASSWORD);
            out.println("show igmp snooping vlip-videolan");
            out.println("          ");
            Thread.sleep(100L);
            int m = 1000;
            while (!in.ready() && (m -= 100) > 0) {
                Thread.sleep(100L);
            }
            while (in.ready()) {
                toParse.append((char)in.read());
            }
            out.close();
            in.close();
            socket.close();
        }
        catch (UnknownHostException e) {
            logger.error((Object)"Error while querying the router.", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"Error while querying the router.", (Throwable)e);
        }
        catch (InterruptedException e) {
            logger.error((Object)"Thread has been interrupted.", (Throwable)e);
        }
        Matcher m = Pattern.compile("\\s+\\w+\\s+(\\d+\\.\\d+\\.\\d+\\.\\d+)\\s+(\\d+\\.\\d+\\.\\d+\\.\\d+)").matcher(toParse);
        while (m.find()) {
            try {
                InetAddress ip1 = InetAddress.getByName(m.group(1));
                InetAddress ip2 = InetAddress.getByName(m.group(2));
                if (!ip1.isMulticastAddress() || ip2.isMulticastAddress()) continue;
                if (ip2.equals(program.getIp())) {
                    result = true;
                    break;
                }
                logger.debug((Object)("Server " + ip2.getHostName() + " streams " + ip1.getHostName()));
            }
            catch (UnknownHostException e) {
                logger.error((Object)"Name resolution error.", (Throwable)e);
            }
        }
        return result;
    }
}

