/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;
import org.jrobin.core.RrdBackend;
import org.jrobin.core.RrdCacher;
import org.jrobin.core.RrdUpdater;

abstract class RrdPrimitive {
    static final int STRING_LENGTH = 20;
    static final int RRD_INT = 0;
    static final int RRD_LONG = 1;
    static final int RRD_DOUBLE = 2;
    static final int RRD_STRING = 3;
    static final int[] RRD_PRIM_SIZES;
    private RrdBackend backend;
    private int byteCount;
    private final long pointer;
    protected RrdCacher cache = new RrdCacher();
    static final /* synthetic */ boolean $assertionsDisabled;

    RrdPrimitive(RrdUpdater rrdUpdater, int n) throws IOException {
        this(rrdUpdater, n, 1);
    }

    RrdPrimitive(RrdUpdater rrdUpdater, int n, int n2) throws IOException {
        this.backend = rrdUpdater.getRrdBackend();
        this.byteCount = RRD_PRIM_SIZES[n] * n2;
        this.pointer = rrdUpdater.getRrdAllocator().allocate(this.byteCount);
    }

    byte[] readBytes() throws IOException {
        byte[] byArray = new byte[this.byteCount];
        this.backend.read(this.pointer, byArray);
        return byArray;
    }

    void writeBytes(byte[] byArray) throws IOException {
        if (!$assertionsDisabled && byArray.length != this.byteCount) {
            throw new AssertionError((Object)"Invalid number of bytes supplied to RrdPrimitive.write method");
        }
        this.backend.write(this.pointer, byArray);
    }

    int readInt() throws IOException {
        return this.backend.readInt(this.pointer);
    }

    void writeInt(int n) throws IOException {
        this.backend.writeInt(this.pointer, n);
    }

    long readLong() throws IOException {
        return this.backend.readLong(this.pointer);
    }

    void writeLong(long l) throws IOException {
        this.backend.writeLong(this.pointer, l);
    }

    double readDouble() throws IOException {
        return this.backend.readDouble(this.pointer);
    }

    double readDouble(int n) throws IOException {
        long l = this.pointer + (long)(n * RRD_PRIM_SIZES[2]);
        return this.backend.readDouble(l);
    }

    double[] readDouble(int n, int n2) throws IOException {
        long l = this.pointer + (long)(n * RRD_PRIM_SIZES[2]);
        return this.backend.readDouble(l, n2);
    }

    void writeDouble(double d) throws IOException {
        this.backend.writeDouble(this.pointer, d);
    }

    void writeDouble(int n, double d, int n2) throws IOException {
        long l = this.pointer + (long)(n * RRD_PRIM_SIZES[2]);
        this.backend.writeDouble(l, d, n2);
    }

    void writeDouble(int n, double[] dArray) throws IOException {
        long l = this.pointer + (long)(n * RRD_PRIM_SIZES[2]);
        this.backend.writeDouble(l, dArray);
    }

    String readString() throws IOException {
        return this.backend.readString(this.pointer);
    }

    void writeString(String string) throws IOException {
        this.backend.writeString(this.pointer, string);
    }

    void clearCache() {
        this.cache.clearCache();
    }

    static {
        $assertionsDisabled = !RrdPrimitive.class.desiredAssertionStatus();
        RRD_PRIM_SIZES = new int[]{4, 8, 8, 40};
    }
}

