/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.jaxrpc;

import javax.xml.rpc.ServiceException;
import org.aopalliance.intercept.Interceptor;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.remoting.jaxrpc.JaxRpcPortClientInterceptor;
import org.springframework.util.ClassUtils;

public class JaxRpcPortProxyFactoryBean
extends JaxRpcPortClientInterceptor
implements FactoryBean,
BeanClassLoaderAware {
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private Object serviceProxy;

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void afterPropertiesSet() throws ServiceException {
        if (this.getServiceInterface() == null) {
            if (this.getPortInterface() != null) {
                this.setServiceInterface(this.getPortInterface());
            } else {
                throw new IllegalArgumentException("Property 'serviceInterface' is required");
            }
        }
        super.afterPropertiesSet();
        this.serviceProxy = new ProxyFactory(this.getServiceInterface(), (Interceptor)this).getProxy(this.beanClassLoader);
    }

    public Object getObject() {
        return this.serviceProxy;
    }

    public Class getObjectType() {
        return this.getServiceInterface();
    }

    public boolean isSingleton() {
        return true;
    }
}

