
<%@ include file="/WEB-INF/jsp/include.jsp" %>

<h1><fmt:message key="medias.list" /></h1>

<!-- Tableau des chanes TNT -->

<h2><fmt:message key="medias.listTNT" /></h2>

<table width="100%">
    <tr>
        <th><fmt:message key="medias.list.frequency" /></th>
        <th><fmt:message key="medias.list.sid" /></th>
        <th><fmt:message key="medias.list.name" /></th>
        <th><fmt:message key="medias.list.status" /></th>
        <th><fmt:message key="medias.list.action" /></th>
    </tr>
    
    <c:set var="frequency" value="0" />    

    <c:forEach items="${channelsTNT}" var="channelTNT">
    <tr>
        <td><small>
        <c:if test="${frequency != channelTNT.frequency}">
            <c:out value="${channelTNT.frequency}" />
        </c:if>
        </small></td>
        <td><small>
            <c:out value="${channelTNT.sid}" />
        </small></td>
        <c:set var="frequency" value="${channelTNT.frequency}" />
        <td>
            <strong>
                <a name="<c:out value="${channelTNT.id}" />">
                    <c:out value="${channelTNT.name}" />
                </a>    
            </strong>
        </td>
        <!-- Construction de l'URL pour supprimer la chane  de la liste -->
        <c:url value="tntchannelremove.htm" var="tntChannelRemoveUrl">
            <c:param name="Id" value="${channelTNT.id}" />
        </c:url>
        <c:choose>
            <c:when test="${channelTNT.program == null}">
                <td><fmt:message key="medias.list.status.non-programmed" /></td>
                <c:url value="mediasprogramadd.htm" var="programAddUrl">
                <c:param name="media" value="${channelTNT.id}" />
                </c:url>
                <td>
                    <p class="lien"><a href="${programAddUrl}"><fmt:message key="medias.list.action.run" /></a></p>
                    <p class="lien"><a href="${tntChannelRemoveUrl}"><fmt:message key="medias.list.action.removechannel" /></a></p>
                </td>
            </c:when>
            <c:otherwise>
                <td>
                <c:choose>
                    <c:when test="${channel.program.player == null}">
                        <fmt:message key="medias.list.status.programmed-nonrunning">
                            <fmt:param value="${channelTNT.program.priority}" />
                        </fmt:message>
                    </c:when>
                    <c:otherwise>
                        <c:choose>
                            <c:when test="${channelTNT.program.broadcastState}">
                                <fmt:message key="medias.list.status.programmed-running">
                                    <fmt:param value="${channelTNT.program.priority}" />
                                    <fmt:param value="${channelTNT.program.playerHostName}" />
                                </fmt:message>
                            </c:when>
                            <c:otherwise>
                                <fmt:message key="medias.list.status.programmed-assigned">
                                    <fmt:param value="${channelTNT.program.priority}" />
                                    <fmt:param value="${channelTNT.program.playerHostName}" />
                                </fmt:message>
                            </c:otherwise>
                        </c:choose>
                    </c:otherwise>
                </c:choose>
                </td>
                <c:url value="mediasprogramremove.htm" var="programRemoveUrl">
                    <c:param name="media" value="${channelTNT.id}" />
                </c:url>
                <td><a href="${programRemoveUrl}"><fmt:message key="medias.list.action.stop" /></a></td>            
            </c:otherwise>
        </c:choose>
    </tr>
    <tr>
            <td></td>
    <tr>
    </c:forEach>
</table>


<!-- Tableau des chanes Satellites -->
<h2>
    <c:choose>
        <c:when test="${shortList}">
            <fmt:message key="medias.shortlistSat" />
        </c:when>
        <c:otherwise>
            <fmt:message key="medias.fulllistSat" />
        </c:otherwise>
    </c:choose>
</h2>

<table width="100%">
    <tr>
        <th colspan="2"><fmt:message key="medias.list.frequency" /></th>
        <th><fmt:message key="medias.list.name" /></th>
        <th><fmt:message key="medias.list.status" /></th>
        <th><fmt:message key="medias.list.action" /></th>
    </tr>
    
    <c:set var="frequency" value="0" />    

    <c:forEach items="${channelsSat}" var="channelSat">
    <tr>
        <td><small>
            <c:if test="${frequency != channelSat.frequency}">
                <c:out value="${channelSat.coverage}" />
            </c:if>
        </small></td>
        <td><small>
            <c:if test="${frequency != channelSat.frequency}">
                <c:out value="${channelSat.frequency}" />
            </c:if>
        </small></td>
        <c:set var="frequency" value="${channelSat.frequency}" />
        <td>
            <strong>
                <a name="<c:out value="${channelSat.id}" />">
                    <font color="<c:choose><c:when test="${channelSat.isCrypted}">#808080</c:when><c:when test="${channelSat.isRadio}">#900000</c:when><c:otherwise>#0000F0</c:otherwise></c:choose>">
                        <c:out value="${channelSat.name}" />
                    </font>
                </a>    
            </strong>
        </td>
        <c:choose><c:when test="${channelSat.program == null}">
            <td><fmt:message key="medias.list.status.non-programmed" /></td>
            <c:url value="mediasprogramadd.htm" var="programAddUrl">
                <c:param name="media" value="${channelSat.id}" />
            </c:url>
            <td><a href="${programAddUrl}"><fmt:message key="medias.list.action.run" /></a></td></c:when>
            <c:otherwise><td>
                <c:choose>
                    <c:when test="${channelSat.program.player == null}">
                        <fmt:message key="medias.list.status.programmed-nonrunning">
                            <fmt:param value="${channelSat.program.priority}" />
                        </fmt:message>
                    </c:when>
                    <c:otherwise>
                        <c:choose>
                            <c:when test="${channelSat.program.broadcastState}">
                                <fmt:message key="medias.list.status.programmed-running">
                                    <fmt:param value="${channelSat.program.priority}" />
                                    <fmt:param value="${channelSat.program.playerHostName}" />
                                </fmt:message>
                            </c:when>
                            <c:otherwise>
                                <fmt:message key="medias.list.status.programmed-assigned">
                                    <fmt:param value="${channelSat.program.priority}" />
                                    <fmt:param value="${channelSat.program.playerHostName}" />
                                </fmt:message>
                            </c:otherwise>
                        </c:choose>
                    </c:otherwise>
                </c:choose></td>
            <c:url value="mediasprogramremove.htm" var="programRemoveUrl">
                <c:param name="media" value="${channelSat.id}" />
            </c:url>
            <td><a href="${programRemoveUrl}"><fmt:message key="medias.list.action.stop" /></a></td>            
            </c:otherwise>
        </c:choose>
    </tr>
    </c:forEach>
</table>
