/*
 * Copyright (C) 2006-2008 the VideoLAN team
 *
 * This file is part of VLMa.
 * 
 * VLMa is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * VLMa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with VLMa. If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.videolan.vlma.web.satellites;

import java.net.UnknownHostException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.SimpleFormController;
import org.springframework.web.servlet.view.RedirectView;
import org.videolan.vlma.common.IVlData;

public class SatellitesAddFormController extends SimpleFormController {

    private IVlData data;

    public IVlData getData() {
        return data;
    }

    public void setData(IVlData data) {
        this.data = data;
    }

    public ModelAndView onSubmit(Object command) throws ServletException,
            UnknownHostException {
        String satelliteName = ((SatellitesAdd) command).getName();
        String satelliteCoverage = ((SatellitesAdd) command).getCoverage();
        int satellite = data.addSatellite(satelliteName);
        data.addSatelliteCoverage(satellite, satelliteCoverage);
        return new ModelAndView(new RedirectView(getSuccessView()));
    }

    protected Object formBackingObject(HttpServletRequest request)
            throws ServletException {
        SatellitesAdd satellitesAdd = new SatellitesAdd();
        satellitesAdd.setName("");
        satellitesAdd.setCoverage("");
        satellitesAdd.setData(data);
        satellitesAdd.setId(0);
        return satellitesAdd;
    }

    @Override
    protected ModelAndView handleRequestInternal(HttpServletRequest arg0,
            HttpServletResponse arg1) throws Exception {
        return super.handleRequestInternal(arg0, arg1);
    }

}
