/*
 * Copyright (C) 2006-2008 the VideoLAN team
 *
 * This file is part of VLMa.
 * 
 * VLMa is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * VLMa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with VLMa. If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.videolan.vlma.common.adapters;

import org.videolan.vlma.common.IVlData;
import org.videolan.vlma.common.exceptions.AdapterParameterDoesNotExistException;
import org.videolan.vlma.common.medias.IVlMedia;
import org.videolan.vlma.common.medias.VlTNTChannel;

/**
 * A DVB-T card.
 * 
 * @author SylV
 * 
 */
public class VlDVBT extends VlAdapter {

    /**
     * Returns the name describing the adapter type.
     *
     * @return the adapter type name
     */
    public String getType() {
        return "DVB-T";
    }

    public void setParameter(String parameter, String value, IVlData data)
            throws AdapterParameterDoesNotExistException {
        {
            throw new AdapterParameterDoesNotExistException("Parameter "
                    + parameter
                    + " doesn't exist among adapters whose type is "
                    + this.getClass().getSimpleName());
        }
    }
    
    public boolean canRead(IVlMedia media) {
        return media.getClass().equals(VlTNTChannel.class);
    }
    
    public int hashType() {
        return VlTNTChannel.class.hashCode();
    }
}
