/*
 * Decompiled with CFR 0.152.
 */
package org.havi.ui;

import java.awt.Dimension;
import org.blurayx.s3d.ui.HGraphicsConfigTemplateS3D;
import org.blurayx.uhd.ui.HGraphicsConfigurationTemplateUHD;
import org.havi.ui.HConfigurationException;
import org.havi.ui.HGraphicsConfigTemplate;
import org.havi.ui.HGraphicsConfiguration;
import org.havi.ui.HPermissionDeniedException;
import org.havi.ui.HScreenConfigTemplate;
import org.havi.ui.HScreenDevice;
import org.videolan.GUIManager;
import org.videolan.Logger;

public class HGraphicsDevice
extends HScreenDevice {
    private HGraphicsConfiguration[] hgcArray;
    private HGraphicsConfiguration hgc;
    private static final Logger logger = Logger.getLogger(HGraphicsDevice.class.getName());

    protected HGraphicsDevice() {
        boolean is_p6 = this.isProfile6();
        boolean is_p5 = this.isProfile5();
        int length = HScreenConfigTemplate.defaultConfig.length;
        this.hgcArray = new HGraphicsConfiguration[length];
        for (int i = 0; i < length; ++i) {
            HGraphicsConfigTemplate hgct = is_p6 ? new HGraphicsConfigurationTemplateUHD() : (is_p5 ? new HGraphicsConfigTemplateS3D() : new HGraphicsConfigTemplate());
            HScreenConfigTemplate.initDefaultConfigTemplate(hgct, i);
            this.hgcArray[i] = new HGraphicsConfiguration(hgct);
        }
        this.hgc = this.hgcArray[0];
    }

    public HGraphicsConfiguration[] getConfigurations() {
        return this.hgcArray;
    }

    public HGraphicsConfiguration getDefaultConfiguration() {
        return this.hgcArray[0];
    }

    public HGraphicsConfiguration getBestConfiguration(HGraphicsConfigTemplate hgct) {
        int score = -1;
        HGraphicsConfiguration hgc = null;
        for (int i = 0; i < this.hgcArray.length; ++i) {
            if (hgct.match(this.hgcArray[i]) <= score) continue;
            hgc = this.hgcArray[i];
        }
        return hgc;
    }

    public HGraphicsConfiguration getBestConfiguration(HGraphicsConfigTemplate[] hgcta) {
        int score = -1;
        HGraphicsConfiguration hgc = null;
        for (int i = 0; i < this.hgcArray.length; ++i) {
            for (int j = 0; j < hgcta.length; ++j) {
                if (hgcta[j].match(this.hgcArray[i]) <= score) continue;
                hgc = this.hgcArray[i];
            }
        }
        return hgc;
    }

    public HGraphicsConfiguration getCurrentConfiguration() {
        return this.hgc;
    }

    public boolean setGraphicsConfiguration(HGraphicsConfiguration hgc) throws SecurityException, HPermissionDeniedException, HConfigurationException {
        logger.unimplemented("setGraphicsConfiguration");
        GUIManager mgr = GUIManager.getInstance();
        Dimension d = hgc.getPixelResolution();
        int curWidth = mgr.getWidth();
        int curHeight = mgr.getHeight();
        if (curWidth != d.width || curHeight != d.height) {
            logger.info("Request to switch graphics resolution from " + curWidth + "x" + curHeight + " to " + d.width + "x" + d.height);
            if (mgr.isVisible()) {
                mgr.setVisible(false);
                mgr.setBounds(0, 0, d.width, d.height);
                mgr.setVisible(true);
            } else {
                mgr.setBounds(0, 0, d.width, d.height);
            }
            curWidth = mgr.getWidth();
            curHeight = mgr.getHeight();
            if (curWidth != d.width || curHeight != d.height) {
                logger.error("Request to switch graphics resolution from " + curWidth + "x" + curHeight + " to " + d.width + "x" + d.height + " FAILED");
                return false;
            }
        }
        this.hgc = hgc;
        return true;
    }
}

