/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTError;
import java.awt.BDGraphics;
import java.awt.Font;
import java.awt.FontMetrics;
import java.io.File;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.videolan.Logger;

public class BDFontMetrics
extends FontMetrics {
    static final long serialVersionUID = -4956160226949100590L;
    private static long ftLib = 0L;
    private static long fcLib = 0L;
    private static Map systemFontNameMap = null;
    private static final Logger logger = Logger.getLogger(BDFontMetrics.class.getName());
    private static Map fontMetricsMap = new HashMap();
    private long ftFace = 0L;
    private int ascent = 0;
    private int descent = 0;
    private int leading = 0;
    private int maxAdvance = 0;
    private int[] widths;

    private static native long initN();

    private static native void destroyN(long var0);

    private static native String[] getFontFamilyAndStyleN(long var0, String var2);

    protected static synchronized String[] getFontFamilyAndStyle(String fontFile) {
        return BDFontMetrics.getFontFamilyAndStyleN(ftLib, fontFile);
    }

    private static native String resolveFontN(String var0, int var1);

    private static native void unloadFontConfigN();

    private static void addSystemFont(String alias, int style, String family, String defaultPath) {
        alias = alias + "." + style;
        if (new File(defaultPath).exists()) {
            logger.info("mapping " + alias + " (" + family + ") to " + defaultPath);
            systemFontNameMap.put(alias, defaultPath);
            return;
        }
        String path = BDFontMetrics.resolveFontN(family, style);
        if (path != null) {
            logger.info("fontconfig: mapping " + alias + " (" + family + ") to " + path);
            systemFontNameMap.put(alias, path);
            return;
        }
        logger.error("Can't resolve font " + alias + ": file " + defaultPath + " does not exist");
        systemFontNameMap.put(alias, defaultPath);
    }

    private static void initSystemFonts() {
        String javaHome = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("java.home");
            }
        });
        File f = new File(javaHome, "lib" + File.separator + "fonts");
        String defaultFontPath = f.getAbsolutePath() + File.separator;
        Object[][] sfd = new Object[][]{{"serif", "Arial", new String[]{"LucidaBrightRegular.ttf", "LucidaBrightDemiBold.ttf", "LucidaBrightItalic.ttf", "LucidaBrightDemiItalic.ttf"}}, {"sansserif", "Times New Roman", new String[]{"LucidaSansRegular.ttf", "LucidaSansDemiBold.ttf", "LucidaSansOblique.ttf", "LucidaSansDemiOblique.ttf"}}, {"monospaced", "Courier New", new String[]{"LucidaTypewriterRegular.ttf", "LucidaTypewriterBold.ttf", "LucidaTypewriterOblique.ttf", "LucidaTypewriterBoldOblique.ttf"}}, {"dialog", "Times New Roman", new String[]{"LucidaSansRegular.ttf", "LucidaSansDemiBold.ttf", "LucidaSansOblique.ttf", "LucidaSansDemiOblique.ttf"}}, {"dialoginput", "Courier New", new String[]{"LucidaTypewriterRegular.ttf", "LucidaTypewriterBold.ttf", "LucidaTypewriterOblique.ttf", "LucidaTypewriterBoldOblique.ttf"}}, {"default", "Times New Roman", new String[]{"LucidaSansRegular.ttf", "LucidaSansDemiBold.ttf", "LucidaSansOblique.ttf", "LucidaSansDemiOblique.ttf"}}};
        systemFontNameMap = new HashMap(24);
        for (int type = 0; type < sfd.length; ++type) {
            for (int style = 0; style < 4; ++style) {
                BDFontMetrics.addSystemFont((String)sfd[type][0], style, (String)sfd[type][1], defaultFontPath + ((String[])sfd[type][2])[style]);
            }
        }
        BDFontMetrics.unloadFontConfigN();
    }

    public static synchronized void init() {
        if (ftLib == 0L) {
            ftLib = BDFontMetrics.initN();
        }
        if (ftLib == 0L) {
            logger.error("freetype library not loaded");
            throw new AWTError("freetype lib not loaded");
        }
        if (systemFontNameMap == null) {
            BDFontMetrics.initSystemFonts();
        }
    }

    public static synchronized void shutdown() {
        Iterator it = fontMetricsMap.values().iterator();
        while (it.hasNext()) {
            try {
                WeakReference ref = (WeakReference)it.next();
                BDFontMetrics fm = (BDFontMetrics)ref.get();
                it.remove();
                if (fm == null) continue;
                fm.destroy();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        BDFontMetrics.destroyN(ftLib);
        ftLib = 0L;
    }

    static synchronized BDFontMetrics getFontMetrics(Font font) {
        BDFontMetrics fm = (BDFontMetrics)font.metrics;
        if (fm == null || fm.ftFace == 0L) {
            String nativeName;
            if (font.fontFile != null) {
                nativeName = font.fontFile.getPath();
            } else {
                nativeName = (String)systemFontNameMap.get(font.getName().toLowerCase() + "." + font.getStyle());
                if (nativeName == null) {
                    nativeName = (String)systemFontNameMap.get("default." + font.getStyle());
                }
            }
            String key = nativeName + "." + font.getSize();
            WeakReference ref = (WeakReference)fontMetricsMap.get(key);
            if (ref != null) {
                fm = (BDFontMetrics)ref.get();
            }
            if (fm == null) {
                fm = new BDFontMetrics(font, nativeName);
                fontMetricsMap.put(key, new WeakReference<BDFontMetrics>(fm));
            }
            font.metrics = fm;
        }
        return fm;
    }

    static String stripAttributes(String fontname) {
        int dotidx = fontname.indexOf(46);
        if (dotidx == -1) {
            return fontname;
        }
        return fontname.substring(0, dotidx);
    }

    static synchronized String[] getFontList() {
        BDFontMetrics.init();
        ArrayList<String> fontNames = new ArrayList<String>();
        Iterator fonts = systemFontNameMap.keySet().iterator();
        while (fonts.hasNext()) {
            String fontname = BDFontMetrics.stripAttributes((String)fonts.next());
            if (fontNames.contains(fontname)) continue;
            fontNames.add(fontname);
        }
        return fontNames.toArray(new String[fontNames.size()]);
    }

    private BDFontMetrics(Font font, String nativeName) {
        super(font);
        this.ftFace = this.loadFontN(ftLib, nativeName, font.getSize());
        if (this.ftFace == 0L) {
            throw new AWTError("font face:" + nativeName + " not loaded");
        }
        this.widths = null;
    }

    private native long loadFontN(long var1, String var3, int var4);

    private native void destroyFontN(long var1);

    private native int charWidthN(long var1, char var3);

    private native int stringWidthN(long var1, String var3);

    private native int charsWidthN(long var1, char[] var3, int var4, int var5);

    private synchronized void loadWidths() {
        if (this.widths == null) {
            this.widths = new int[256];
            for (int i = 0; i < 256; ++i) {
                this.widths[i] = this.charWidthN(this.ftFace, (char)i);
            }
        }
    }

    protected synchronized void drawString(BDGraphics g, String string, int x, int y, int rgb) {
        g.drawStringN(this.ftFace, string, x, y, rgb);
    }

    public int getAscent() {
        return this.ascent;
    }

    public int getDescent() {
        return this.descent;
    }

    public int getLeading() {
        return this.leading;
    }

    public int getMaxAdvance() {
        return this.maxAdvance;
    }

    public synchronized int charWidth(char c) {
        if (c < '\u0100') {
            this.loadWidths();
            return this.widths[c];
        }
        return this.charWidthN(this.ftFace, c);
    }

    public synchronized int stringWidth(String string) {
        return this.stringWidthN(this.ftFace, string);
    }

    public synchronized int charsWidth(char[] chars, int offset, int length) {
        return this.charsWidthN(this.ftFace, chars, offset, length);
    }

    public int[] getWidths() {
        this.loadWidths();
        int[] newWidths = new int[this.widths.length];
        System.arraycopy(this.widths, 0, newWidths, 0, this.widths.length);
        return newWidths;
    }

    private void destroy() {
        if (this.ftFace != 0L) {
            this.destroyFontN(this.ftFace);
            this.ftFace = 0L;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.destroy();
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            super.finalize();
        }
    }
}

