/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.media.content;

import java.awt.Component;
import java.io.IOException;
import javax.media.Clock;
import javax.media.ClockStoppedException;
import javax.media.Control;
import javax.media.Controller;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DeallocateEvent;
import javax.media.EndOfMediaEvent;
import javax.media.GainControl;
import javax.media.IncompatibleSourceException;
import javax.media.IncompatibleTimeBaseException;
import javax.media.Manager;
import javax.media.NotPrefetchedError;
import javax.media.NotRealizedError;
import javax.media.Player;
import javax.media.PrefetchCompleteEvent;
import javax.media.RateChangeEvent;
import javax.media.RealizeCompleteEvent;
import javax.media.ResourceUnavailableEvent;
import javax.media.StartEvent;
import javax.media.StopByRequestEvent;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.TransitionEvent;
import javax.media.protocol.DataSource;
import javax.tv.locator.Locator;
import javax.tv.service.selection.ServiceContentHandler;
import org.bluray.media.OverallGainControl;
import org.bluray.net.BDLocator;
import org.videolan.BDJAction;
import org.videolan.BDJActionManager;
import org.videolan.BDJActionQueue;
import org.videolan.BDJListeners;
import org.videolan.BDJXletContext;
import org.videolan.media.content.PlayerManager;

public abstract class BDHandler
implements Player,
ServiceContentHandler {
    protected int state = 100;
    protected int targetState = 100;
    protected Time stopTime = Clock.RESET;
    protected long baseMediaTime = 0L;
    protected long baseTime;
    protected float rate = 1.0f;
    protected Control[] controls = null;
    protected BDLocator locator = null;
    private BDJListeners listeners = new BDJListeners();
    private BDJXletContext ownerContext = BDJXletContext.getCurrentContext();
    boolean isClosed = false;
    protected BDJActionQueue commandQueue;
    public static final double TO_SECONDS = 1.1111111111111112E-5;
    public static final double FROM_SECONDS = 90000.0;
    public static final double TO_NAROSECONDS = 11111.111111111111;
    public static final double FROM_NAROSECONDS = 9.0E-5;

    public BDHandler() {
        PlayerAction action = new PlayerAction(this, 1, null);
        BDJActionManager.getInstance().putCommand(action);
        action.waitEnd();
    }

    private void doInitAction() {
        this.commandQueue = new BDJActionQueue("MediaPlayer");
        PlayerManager.getInstance().registerPlayer(this);
    }

    protected BDJXletContext getOwnerContext() {
        return this.ownerContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkUnrealized() {
        BDHandler bDHandler = this;
        synchronized (bDHandler) {
            if (this.state == 100) {
                throw new NotRealizedError("Player Unrealized");
            }
        }
    }

    public abstract void setSource(DataSource var1) throws IOException, IncompatibleSourceException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getState() {
        BDHandler bDHandler = this;
        synchronized (bDHandler) {
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTargetState() {
        BDHandler bDHandler = this;
        synchronized (bDHandler) {
            return this.targetState;
        }
    }

    public Control[] getControls() {
        return this.controls;
    }

    public Control getControl(String forName) {
        try {
            Class<?> cls = Class.forName(forName);
            for (int i = 0; i < this.controls.length; ++i) {
                if (!cls.isInstance(this.controls[i])) continue;
                return this.controls[i];
            }
            return null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public GainControl getGainControl() {
        this.checkUnrealized();
        for (int i = 0; i < this.controls.length; ++i) {
            if (!(this.controls[i] instanceof OverallGainControl)) continue;
            return (GainControl)this.controls[i];
        }
        return null;
    }

    public void addController(Controller newController) throws IncompatibleTimeBaseException {
        this.checkUnrealized();
    }

    public void removeController(Controller oldController) {
        this.checkUnrealized();
    }

    public Component getControlPanelComponent() {
        this.checkUnrealized();
        return null;
    }

    public Component getVisualComponent() {
        this.checkUnrealized();
        return null;
    }

    public void addControllerListener(ControllerListener listener) {
        this.listeners.add(listener);
    }

    public void removeControllerListener(ControllerListener listener) {
        this.listeners.remove(listener);
    }

    public Time getStartLatency() {
        this.checkUnrealized();
        return new Time(0.1);
    }

    public TimeBase getTimeBase() {
        this.checkUnrealized();
        return Manager.getSystemTimeBase();
    }

    public void setTimeBase(TimeBase master) throws IncompatibleTimeBaseException {
        this.checkUnrealized();
        throw new IncompatibleTimeBaseException();
    }

    public Time getStopTime() {
        return this.stopTime;
    }

    public void setStopTime(Time stopTime) {
        this.checkUnrealized();
        this.stopTime = stopTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getMediaTime() {
        BDHandler bDHandler = this;
        synchronized (bDHandler) {
            if (this.state == 600) {
                return new Time((double)(this.baseMediaTime + (this.getTimeBase().getNanoseconds() - this.baseTime)) / 1.0E9);
            }
            return new Time((double)this.baseMediaTime / 1.0E9);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMediaNanoseconds() {
        BDHandler bDHandler = this;
        synchronized (bDHandler) {
            if (this.state == 600 && this.rate != 0.0f) {
                return this.baseMediaTime + (this.getTimeBase().getNanoseconds() - this.baseTime);
            }
            return this.baseMediaTime;
        }
    }

    public Time getSyncTime() {
        return this.getMediaTime();
    }

    public void setMediaTime(Time now) {
        this.checkUnrealized();
        if (this.isClosed) {
            return;
        }
        PlayerAction action = new PlayerAction(this, 8, now);
        this.commandQueue.put(action);
        action.waitEnd();
    }

    public Time mapToTimeBase(Time t) throws ClockStoppedException {
        if (this.state != 600) {
            throw new ClockStoppedException();
        }
        return this.getMediaTime();
    }

    public abstract Time getDuration();

    protected void updateTime(Time now) {
        this.baseMediaTime = now.getNanoseconds();
        this.baseTime = this.getTimeBase().getNanoseconds();
    }

    public float getRate() {
        return this.rate;
    }

    public float setRate(float factor) {
        this.checkUnrealized();
        PlayerAction action = new PlayerAction(this, 9, new Float(factor));
        this.commandQueue.put(action);
        action.waitEnd();
        return this.rate;
    }

    public Locator[] getServiceContentLocators() {
        if (this.locator == null) {
            return new Locator[0];
        }
        Locator[] locators = new Locator[]{this.locator};
        return locators;
    }

    public void realize() {
        if (this.isClosed) {
            return;
        }
        PlayerAction action = new PlayerAction(this, 2, null);
        this.commandQueue.put(action);
    }

    public void prefetch() {
        if (this.isClosed) {
            return;
        }
        PlayerAction action = new PlayerAction(this, 3, null);
        this.commandQueue.put(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncStart(Time at) {
        BDHandler bDHandler = this;
        synchronized (bDHandler) {
            if (this.state != 500) {
                throw new NotPrefetchedError("syncStart");
            }
        }
        if (this.isClosed) {
            return;
        }
        PlayerAction action = new PlayerAction(this, 4, at);
        this.commandQueue.put(action);
    }

    public void start() {
        if (this.isClosed) {
            return;
        }
        PlayerAction action = new PlayerAction(this, 4, null);
        this.commandQueue.put(action);
    }

    public void stop() {
        if (this.isClosed) {
            return;
        }
        PlayerAction action = new PlayerAction(this, 5, null);
        this.commandQueue.put(action);
        action.waitEnd();
    }

    public void deallocate() {
        if (this.isClosed) {
            return;
        }
        if (this.state == 600) {
            // empty if block
        }
        PlayerAction action = new PlayerAction(this, 6, null);
        this.commandQueue.put(action);
        action.waitEnd();
        PlayerManager.getInstance().releaseResource(this);
    }

    public void close() {
        if (this.isClosed) {
            return;
        }
        this.stop();
        this.deallocate();
        PlayerAction action = new PlayerAction(this, 7, null);
        this.commandQueue.put(action);
        action.waitEnd();
        this.isClosed = true;
        this.commandQueue.shutdown();
    }

    protected void timeChanged(int time) {
        if (this.isClosed) {
            return;
        }
        PlayerAction action = new PlayerAction(this, 12, new Integer(time));
        this.commandQueue.put(action);
    }

    protected void playlistEndReached(int playlist) {
        if (this.isClosed) {
            return;
        }
        PlayerAction action = new PlayerAction(this, 10, new Integer(playlist));
        this.commandQueue.put(action);
    }

    protected void rateChanged(float rate) {
        if (this.isClosed) {
            return;
        }
        PlayerAction action = new PlayerAction(this, 11, new Float(rate));
        this.commandQueue.put(action);
    }

    protected void playlistStarted(int param) {
        if (this.isClosed) {
            return;
        }
        PlayerAction action = new PlayerAction(this, 13, new Integer(param));
        this.commandQueue.put(action);
    }

    protected void chapterReached(int param) {
        if (this.isClosed) {
            return;
        }
        PlayerAction action = new PlayerAction(this, 15, new Integer(param));
        this.commandQueue.put(action);
    }

    protected void markReached(int param) {
        if (this.isClosed) {
            return;
        }
        PlayerAction action = new PlayerAction(this, 16, new Integer(param));
        this.commandQueue.put(action);
    }

    protected void playItemReached(int param) {
        if (this.isClosed) {
            return;
        }
        PlayerAction action = new PlayerAction(this, 14, new Integer(param));
        this.commandQueue.put(action);
    }

    protected void angleChanged(int param) {
        if (this.isClosed) {
            return;
        }
        PlayerAction action = new PlayerAction(this, 17, new Integer(param));
        this.commandQueue.put(action);
    }

    protected void subtitleChanged(int param) {
        if (this.isClosed) {
            return;
        }
        PlayerAction action = new PlayerAction(this, 18, new Integer(param));
        this.commandQueue.put(action);
    }

    protected void pipChanged(int param) {
        if (this.isClosed) {
            return;
        }
        PlayerAction action = new PlayerAction(this, 19, new Integer(param));
        this.commandQueue.put(action);
    }

    protected void doRateChanged(float rate) {
        if (this.rate != rate) {
            this.rate = rate;
            this.notifyListeners(new RateChangeEvent(this, rate));
        }
    }

    protected void doTimeChanged(int time) {
    }

    protected void doEndOfMediaReached(int playlist) {
        if (this.state == 600) {
            ControllerErrorEvent error = this.doStop();
            if (error == null) {
                this.state = 500;
                this.notifyListeners(new EndOfMediaEvent(this, 600, 500, 500, this.getMediaTime()));
            } else {
                this.notifyListeners(error);
            }
        }
    }

    protected void doPlaylistStarted(int playlist) {
    }

    protected void doChapterReached(int chapter) {
    }

    protected void doMarkReached(int playmark) {
    }

    protected void doPlayItemReached(int playitem) {
    }

    protected void doAngleChanged(int angle) {
    }

    protected void doSubtitleChanged(int param) {
    }

    protected void doPiPChanged(int param) {
    }

    protected ControllerErrorEvent doRealize() {
        return null;
    }

    protected ControllerErrorEvent doPrefetch() {
        return null;
    }

    protected ControllerErrorEvent doStart(Time at) {
        if (at != null) {
            this.baseMediaTime = at.getNanoseconds();
        }
        this.baseTime = this.getTimeBase().getNanoseconds();
        return null;
    }

    protected ControllerErrorEvent doStop() {
        this.baseMediaTime = this.getMediaNanoseconds();
        return null;
    }

    protected ControllerErrorEvent doDeallocate() {
        return null;
    }

    protected ControllerErrorEvent doClose() {
        return null;
    }

    protected void doSeekTime(Time at) {
        this.updateTime(at);
    }

    protected void doSetRate(Float factor) {
        if (this.rate != factor.floatValue()) {
            this.rate = factor.floatValue();
            this.notifyListeners(new RateChangeEvent(this, this.rate));
        }
    }

    private void notifyListeners(ControllerEvent event) {
        this.listeners.putCallback(event);
    }

    private boolean doRealizeAction() {
        switch (this.state) {
            case 100: {
                this.state = 200;
                this.notifyListeners(new TransitionEvent(this, 100, 200, 300));
            }
            case 200: {
                ControllerErrorEvent error = this.doRealize();
                if (error == null) {
                    this.state = 300;
                    this.notifyListeners(new RealizeCompleteEvent(this, 200, 300, 300));
                    break;
                }
                this.notifyListeners(error);
                return false;
            }
            default: {
                this.notifyListeners(new RealizeCompleteEvent(this, this.state, this.state, this.state));
            }
        }
        return true;
    }

    private boolean doPrefetchAction() {
        switch (this.state) {
            case 100: 
            case 200: {
                if (!this.doRealizeAction()) {
                    return false;
                }
            }
            case 300: {
                this.state = 400;
                this.notifyListeners(new TransitionEvent(this, 300, 400, 500));
            }
            case 400: {
                if (!PlayerManager.getInstance().allocateResource(this)) {
                    this.notifyListeners(new ResourceUnavailableEvent(this));
                    return false;
                }
                ControllerErrorEvent error = this.doPrefetch();
                if (error == null) {
                    this.state = 500;
                    this.notifyListeners(new PrefetchCompleteEvent(this, 400, 500, 500));
                    break;
                }
                this.notifyListeners(error);
                return false;
            }
            default: {
                this.notifyListeners(new PrefetchCompleteEvent(this, this.state, this.state, this.state));
            }
        }
        return true;
    }

    private boolean doStartAction(Time at) {
        switch (this.state) {
            case 100: 
            case 200: {
                if (!this.doRealizeAction()) {
                    return false;
                }
            }
            case 300: 
            case 400: {
                if (!this.doPrefetchAction()) {
                    return false;
                }
            }
            case 500: {
                ControllerErrorEvent error = this.doStart(at);
                if (error == null) {
                    this.state = 600;
                    this.notifyListeners(new StartEvent(this, 500, 600, 600, at, this.getMediaTime()));
                    break;
                }
                this.notifyListeners(error);
                return false;
            }
            default: {
                this.notifyListeners(new StartEvent(this, this.state, this.state, this.state, at, this.getMediaTime()));
            }
        }
        return true;
    }

    private boolean doStopAction() {
        switch (this.state) {
            case 600: {
                ControllerErrorEvent error = this.doStop();
                if (error == null) {
                    this.state = 500;
                    this.notifyListeners(new StopByRequestEvent(this, 600, 500, 500, this.getMediaTime()));
                    break;
                }
                this.notifyListeners(error);
                return false;
            }
            default: {
                this.notifyListeners(new StopByRequestEvent(this, this.state, this.state, this.state, this.getMediaTime()));
            }
        }
        return true;
    }

    private boolean doDeallocateAction() {
        switch (this.state) {
            case 200: {
                ControllerErrorEvent error = this.doDeallocate();
                if (error == null) {
                    this.state = 100;
                    this.notifyListeners(new DeallocateEvent(this, 200, 100, 100, this.getMediaTime()));
                    break;
                }
                this.notifyListeners(error);
                return false;
            }
            case 100: 
            case 300: {
                this.notifyListeners(new DeallocateEvent(this, this.state, this.state, this.state, this.getMediaTime()));
                break;
            }
            default: {
                ControllerErrorEvent error = this.doDeallocate();
                if (error == null) {
                    int previous = this.state;
                    this.state = 300;
                    this.notifyListeners(new DeallocateEvent(this, previous, 300, 300, this.getMediaTime()));
                    break;
                }
                this.notifyListeners(error);
                return false;
            }
        }
        return true;
    }

    private void doCloseAction() {
        this.doClose();
        this.notifyListeners(new ControllerClosedEvent(this));
        PlayerManager.getInstance().unregisterPlayer(this);
    }

    private class PlayerAction
    extends BDJAction {
        private BDHandler player;
        private int action;
        private Object param;
        public static final int ACTION_INIT = 1;
        public static final int ACTION_REALIZE = 2;
        public static final int ACTION_PREFETCH = 3;
        public static final int ACTION_START = 4;
        public static final int ACTION_STOP = 5;
        public static final int ACTION_DEALLOCATE = 6;
        public static final int ACTION_CLOSE = 7;
        public static final int ACTION_SEEK_TIME = 8;
        public static final int ACTION_SET_RATE = 9;
        public static final int ACTION_END_OF_MEDIA_REACHED = 10;
        public static final int ACTION_RATE_CHANGED = 11;
        public static final int ACTION_TIME_CHANGED = 12;
        public static final int ACTION_PLAYLIST_STARTED = 13;
        public static final int ACTION_PLAYITEM_REACHED = 14;
        public static final int ACTION_CHAPTER_REACHED = 15;
        public static final int ACTION_MARK_REACHED = 16;
        public static final int ACTION_ANGLE_CHANGED = 17;
        public static final int ACTION_SUBTITLE_CHANGED = 18;
        public static final int ACTION_PIP_CHANGED = 19;

        private PlayerAction(BDHandler player, int action, Object param) {
            this.player = player;
            this.action = action;
            this.param = param;
        }

        protected void doAction() {
            switch (this.action) {
                case 1: {
                    this.player.doInitAction();
                    break;
                }
                case 2: {
                    this.player.doRealizeAction();
                    break;
                }
                case 3: {
                    this.player.doPrefetchAction();
                    break;
                }
                case 4: {
                    this.player.doStartAction(this.param == null ? null : (Time)this.param);
                    break;
                }
                case 5: {
                    this.player.doStopAction();
                    break;
                }
                case 6: {
                    this.player.doDeallocateAction();
                    break;
                }
                case 7: {
                    this.player.doCloseAction();
                    break;
                }
                case 8: {
                    this.player.doSeekTime((Time)this.param);
                    break;
                }
                case 9: {
                    this.player.doSetRate((Float)this.param);
                    break;
                }
                case 10: {
                    this.player.doEndOfMediaReached((Integer)this.param);
                    break;
                }
                case 12: {
                    this.player.doTimeChanged((Integer)this.param);
                    break;
                }
                case 11: {
                    this.player.doRateChanged(((Float)this.param).floatValue());
                    break;
                }
                case 13: {
                    this.player.doPlaylistStarted((Integer)this.param);
                    break;
                }
                case 14: {
                    this.player.doPlayItemReached((Integer)this.param);
                    break;
                }
                case 15: {
                    this.player.doChapterReached((Integer)this.param);
                    break;
                }
                case 16: {
                    this.player.doMarkReached((Integer)this.param);
                    break;
                }
                case 17: {
                    this.player.doAngleChanged((Integer)this.param);
                    break;
                }
                case 18: {
                    this.player.doSubtitleChanged((Integer)this.param);
                    break;
                }
                case 19: {
                    this.player.doPiPChanged((Integer)this.param);
                }
            }
        }
    }
}

