/*
 * Decompiled with CFR 0.152.
 */
package vlcskineditor.items;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Node;
import vlcskineditor.Helper;
import vlcskineditor.Item;
import vlcskineditor.Language;
import vlcskineditor.Main;
import vlcskineditor.NumbersOnlyDocument;
import vlcskineditor.Resource;
import vlcskineditor.Skin;
import vlcskineditor.XML;
import vlcskineditor.history.HistoryEvent;
import vlcskineditor.history.ItemAddEvent;
import vlcskineditor.history.TextEditEvent;
import vlcskineditor.resources.ResourceChangeListener;
import vlcskineditor.resources.ResourceChangedEvent;

public class Text
extends Item
implements ActionListener,
ResourceChangeListener {
    public final String TEXT_DEFAULT = "";
    public final String COLOR_DEFAULT = "#000000";
    public final int WIDTH_DEFAULT = 0;
    public final String ALIGNMENT_DEFAULT = "left";
    public final String SCROLLING_DEFAULT = "auto";
    public String font;
    public String text = "";
    public String color = "#000000";
    public int width = 0;
    public String alignment = "left";
    public String scrolling = "auto";
    JFrame frame = null;
    JTextField id_tf;
    JTextField x_tf;
    JTextField y_tf;
    JTextField help_tf;
    JTextField visible_tf;
    JTextField text_tf;
    JTextField font_tf;
    JTextField color_tf;
    JTextField width_tf;
    JComboBox lefttop_cb;
    JComboBox rightbottom_cb;
    JComboBox xkeepratio_cb;
    JComboBox ykeepratio_cb;
    JComboBox alignment_cb;
    JComboBox scrolling_cb;
    JButton visible_btn;
    JButton color_btn;
    JButton ok_btn;
    JButton cancel_btn;
    JButton help_btn;
    private vlcskineditor.resources.Font font_res;

    public Text(Node node, Skin skin) {
        this.type = Language.get("TEXT");
        this.s = skin;
        this.id = XML.getStringAttributeValue(node, "id", Language.get("UNNAMED").replaceAll("%t", this.type).replaceAll("%i", String.valueOf(this.s.getNewId())));
        this.font = XML.getStringAttributeValue(node, "font", this.font);
        this.text = XML.getStringAttributeValue(node, "text", this.text);
        this.alignment = XML.getStringAttributeValue(node, "alignment", this.alignment);
        this.scrolling = XML.getStringAttributeValue(node, "scrolling", this.scrolling);
        this.color = XML.getStringAttributeValue(node, "color", this.color);
        this.width = XML.getIntAttributeValue(node, "width", this.width);
        this.x = XML.getIntAttributeValue(node, "x", this.x);
        this.y = XML.getIntAttributeValue(node, "y", this.y);
        this.lefttop = XML.getStringAttributeValue(node, "lefttop", this.lefttop);
        this.rightbottom = XML.getStringAttributeValue(node, "rightbottom", this.rightbottom);
        this.xkeepratio = XML.getBoolAttributeValue(node, "xkeepratio", this.xkeepratio);
        this.ykeepratio = XML.getBoolAttributeValue(node, "ykeepratio", this.ykeepratio);
        this.visible = XML.getStringAttributeValue(node, "visible", this.visible);
        this.help = XML.getStringAttributeValue(node, "help", this.help);
        this.created = true;
        try {
            this.font_res = (vlcskineditor.resources.Font)this.s.getResource(this.font);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.font_res != null) {
            this.font_res.addResourceChangeListener(this);
        }
    }

    public Text(Skin skin) {
        this.type = Language.get("TEXT");
        this.s = skin;
        this.font = "defaultfont";
        this.id = Language.get("UNNAMED").replaceAll("%t", this.type).replaceAll("%i", String.valueOf(this.s.getNewId()));
        this.showOptions();
    }

    public Text(Text text) {
        super(text);
        this.type = Language.get("TEXT");
        this.font = text.font;
        this.text = text.text;
        this.width = text.width;
        this.alignment = text.alignment;
        this.scrolling = text.scrolling;
        this.color = text.color;
        try {
            this.font_res = (vlcskineditor.resources.Font)this.s.getResource(this.font);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.font_res != null) {
            this.font_res.addResourceChangeListener(this);
        }
    }

    @Override
    public void update() {
        HistoryEvent historyEvent;
        if (this.font_res != null) {
            this.font_res.removeResourceChangeListener(this);
        }
        if (!this.created) {
            this.id = this.id_tf.getText();
            this.x = Integer.parseInt(this.x_tf.getText());
            this.y = Integer.parseInt(this.y_tf.getText());
            this.lefttop = this.lefttop_cb.getSelectedItem().toString();
            this.rightbottom = this.rightbottom_cb.getSelectedItem().toString();
            this.xkeepratio = Boolean.parseBoolean(this.xkeepratio_cb.getSelectedItem().toString());
            this.ykeepratio = Boolean.parseBoolean(this.ykeepratio_cb.getSelectedItem().toString());
            this.visible = this.visible_tf.getText();
            this.help = this.help_tf.getText();
            this.text = this.text_tf.getText();
            this.font = this.font_tf.getText();
            this.color = this.color_tf.getText();
            this.width = Integer.parseInt(this.width_tf.getText());
            this.alignment = this.alignment_cb.getSelectedItem().toString();
            this.scrolling = this.scrolling_cb.getSelectedItem().toString();
            this.s.updateItems();
            this.s.expandItem(this.id);
            this.frame.setDefaultCloseOperation(2);
            this.created = true;
            historyEvent = new ItemAddEvent(this.s.getParentListOf(this.id), this);
            this.s.m.hist.addEvent(historyEvent);
        } else {
            historyEvent = new TextEditEvent(this);
            this.id = this.id_tf.getText();
            this.x = Integer.parseInt(this.x_tf.getText());
            this.y = Integer.parseInt(this.y_tf.getText());
            this.lefttop = this.lefttop_cb.getSelectedItem().toString();
            this.rightbottom = this.rightbottom_cb.getSelectedItem().toString();
            this.xkeepratio = Boolean.parseBoolean(this.xkeepratio_cb.getSelectedItem().toString());
            this.ykeepratio = Boolean.parseBoolean(this.ykeepratio_cb.getSelectedItem().toString());
            this.visible = this.visible_tf.getText();
            this.help = this.help_tf.getText();
            this.text = this.text_tf.getText();
            this.font = this.font_tf.getText();
            this.color = this.color_tf.getText();
            this.width = Integer.parseInt(this.width_tf.getText());
            this.alignment = this.alignment_cb.getSelectedItem().toString();
            this.scrolling = this.scrolling_cb.getSelectedItem().toString();
            this.s.updateItems();
            this.s.expandItem(this.id);
            historyEvent.setNew();
            this.s.m.hist.addEvent(historyEvent);
        }
        this.updateToGlobalVariables();
        try {
            this.font_res = (vlcskineditor.resources.Font)this.s.getResource(this.font);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.font_res != null) {
            this.font_res.addResourceChangeListener(this);
        }
    }

    @Override
    public void showOptions() {
        if (this.frame == null) {
            this.frame = new JFrame(Language.get("WIN_TEXT_TITLE"));
            this.frame.setIconImage(Main.edit_icon.getImage());
            this.frame.setResizable(false);
            if (!this.created) {
                this.frame.setDefaultCloseOperation(0);
            }
            JLabel jLabel = new JLabel(Language.get("WIN_ITEM_ID"));
            this.id_tf = new JTextField();
            JLabel jLabel2 = new JLabel(Language.get("WIN_ITEM_X"));
            this.x_tf = new JTextField();
            this.x_tf.setDocument(new NumbersOnlyDocument());
            JLabel jLabel3 = new JLabel(Language.get("WIN_ITEM_Y"));
            this.y_tf = new JTextField();
            this.y_tf.setDocument(new NumbersOnlyDocument());
            String[] stringArray = new String[]{"lefttop", "leftbottom", "righttop", "rightbottom"};
            JLabel jLabel4 = new JLabel(Language.get("WIN_ITEM_LEFTTOP"));
            this.lefttop_cb = new JComboBox<String>(stringArray);
            this.lefttop_cb.setToolTipText(Language.get("WIN_ITEM_LEFTTOP_TIP"));
            JLabel jLabel5 = new JLabel(Language.get("WIN_ITEM_RIGHTBOTTOM"));
            this.rightbottom_cb = new JComboBox<String>(stringArray);
            this.rightbottom_cb.setToolTipText(Language.get("WIN_ITEM_RIGHTBOTTOM_TIP"));
            Object[] objectArray = new Object[]{true, false};
            JLabel jLabel6 = new JLabel(Language.get("WIN_ITEM_XKEEPRATIO"));
            this.xkeepratio_cb = new JComboBox<Object>(objectArray);
            this.xkeepratio_cb.setToolTipText(Language.get("WIN_ITEM_XKEEPRATIO_TIP"));
            JLabel jLabel7 = new JLabel(Language.get("WIN_ITEM_YKEEPRATIO"));
            this.ykeepratio_cb = new JComboBox<Object>(objectArray);
            this.ykeepratio_cb.setToolTipText(Language.get("WIN_ITEM_YKEEPRATIO_TIP"));
            JLabel jLabel8 = new JLabel(Language.get("WIN_ITEM_VISIBLE"));
            this.visible_tf = new JTextField();
            this.visible_btn = new JButton("", Main.help_icon);
            this.visible_btn.addActionListener(this);
            JLabel jLabel9 = new JLabel(Language.get("WIN_ITEM_HELP"));
            this.help_tf = new JTextField();
            this.help_tf.setToolTipText(Language.get("WIN_ITEM_HELP_TIP"));
            JLabel jLabel10 = new JLabel(Language.get("WIN_TEXT_TEXT"));
            this.text_tf = new JTextField();
            JLabel jLabel11 = new JLabel(Language.get("WIN_TEXT_FONT"));
            this.font_tf = new JTextField();
            JLabel jLabel12 = new JLabel(Language.get("WIN_TEXT_COLOR"));
            this.color_tf = new JTextField();
            this.color_btn = new JButton(Language.get("WIN_TEXT_CHOOSE"));
            this.color_btn.addActionListener(this);
            JLabel jLabel13 = new JLabel(Language.get("WIN_ITEM_WIDTH"));
            this.width_tf = new JTextField();
            this.width_tf.setDocument(new NumbersOnlyDocument());
            JLabel jLabel14 = new JLabel(Language.get("WIN_TEXT_ALIGNMENT"));
            String[] stringArray2 = new String[]{"left", "center", "right"};
            this.alignment_cb = new JComboBox<String>(stringArray2);
            JLabel jLabel15 = new JLabel(Language.get("WIN_TEXT_SCROLLING"));
            String[] stringArray3 = new String[]{"none", "auto", "manual"};
            this.scrolling_cb = new JComboBox<String>(stringArray3);
            JLabel jLabel16 = new JLabel(Language.get("NOTE_STARRED"));
            this.ok_btn = new JButton(Language.get("BUTTON_OK"));
            this.ok_btn.addActionListener(this);
            this.cancel_btn = new JButton(Language.get("BUTTON_CANCEL"));
            this.cancel_btn.addActionListener(this);
            this.help_btn = new JButton(Language.get("BUTTON_HELP"));
            this.help_btn.addActionListener(this);
            Component[] componentArray = new Component[]{jLabel, jLabel2, jLabel3, jLabel4, jLabel5, jLabel6, jLabel7, jLabel8, jLabel9, jLabel10, jLabel11, jLabel12, jLabel13, jLabel14, jLabel15};
            int n = Helper.maxWidth(componentArray) + 10;
            int n2 = 200;
            JPanel jPanel = new JPanel(null);
            jPanel.add(jLabel);
            jPanel.add(this.id_tf);
            this.id_tf.setPreferredSize(new Dimension(n2, this.id_tf.getPreferredSize().height));
            jPanel.add(jLabel2);
            jPanel.add(this.x_tf);
            jPanel.add(jLabel3);
            jPanel.add(this.y_tf);
            jPanel.add(jLabel4);
            jPanel.add(this.lefttop_cb);
            jPanel.add(jLabel5);
            jPanel.add(this.rightbottom_cb);
            jPanel.add(jLabel6);
            jPanel.add(this.xkeepratio_cb);
            jPanel.add(jLabel7);
            jPanel.add(this.ykeepratio_cb);
            jPanel.add(jLabel8);
            jPanel.add(this.visible_tf);
            jPanel.add(this.visible_btn);
            jPanel.add(jLabel9);
            jPanel.add(this.help_tf);
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Language.get("WIN_ITEM_GENERAL")));
            SpringLayout springLayout = new SpringLayout();
            jPanel.setLayout(springLayout);
            springLayout.putConstraint("North", (Component)jLabel, 5, "North", (Component)jPanel);
            springLayout.putConstraint("West", (Component)jLabel, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.id_tf, 0, "VerticalCenter", (Component)jLabel);
            springLayout.putConstraint("West", (Component)this.id_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("North", (Component)jLabel2, 10, "South", (Component)this.id_tf);
            springLayout.putConstraint("West", (Component)jLabel2, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.x_tf, 0, "VerticalCenter", (Component)jLabel2);
            springLayout.putConstraint("West", (Component)this.x_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.x_tf, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel3, 10, "South", (Component)this.x_tf);
            springLayout.putConstraint("West", (Component)jLabel3, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.y_tf, 0, "VerticalCenter", (Component)jLabel3);
            springLayout.putConstraint("West", (Component)this.y_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.y_tf, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel4, 10, "South", (Component)this.y_tf);
            springLayout.putConstraint("West", (Component)jLabel4, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.lefttop_cb, 0, "VerticalCenter", (Component)jLabel4);
            springLayout.putConstraint("West", (Component)this.lefttop_cb, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.lefttop_cb, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel5, 10, "South", (Component)this.lefttop_cb);
            springLayout.putConstraint("West", (Component)jLabel5, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.rightbottom_cb, 0, "VerticalCenter", (Component)jLabel5);
            springLayout.putConstraint("West", (Component)this.rightbottom_cb, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.rightbottom_cb, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel6, 10, "South", (Component)this.rightbottom_cb);
            springLayout.putConstraint("West", (Component)jLabel6, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.xkeepratio_cb, 0, "VerticalCenter", (Component)jLabel6);
            springLayout.putConstraint("West", (Component)this.xkeepratio_cb, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.xkeepratio_cb, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel7, 10, "South", (Component)this.xkeepratio_cb);
            springLayout.putConstraint("West", (Component)jLabel7, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.ykeepratio_cb, 0, "VerticalCenter", (Component)jLabel7);
            springLayout.putConstraint("West", (Component)this.ykeepratio_cb, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.ykeepratio_cb, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel8, 10, "South", (Component)this.ykeepratio_cb);
            springLayout.putConstraint("West", (Component)jLabel8, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.visible_tf, 0, "VerticalCenter", (Component)jLabel8);
            springLayout.putConstraint("West", (Component)this.visible_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.visible_tf, -5, "West", (Component)this.visible_btn);
            springLayout.putConstraint("VerticalCenter", (Component)this.visible_btn, 0, "VerticalCenter", (Component)jLabel8);
            springLayout.putConstraint("East", (Component)this.visible_btn, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel9, 10, "South", (Component)this.visible_btn);
            springLayout.putConstraint("West", (Component)jLabel9, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.help_tf, 0, "VerticalCenter", (Component)jLabel9);
            springLayout.putConstraint("West", (Component)this.help_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.help_tf, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("East", (Component)jPanel, 5, "East", (Component)this.id_tf);
            springLayout.putConstraint("South", (Component)jPanel, 10, "South", (Component)this.help_tf);
            this.frame.add(jPanel);
            JPanel jPanel2 = new JPanel(null);
            jPanel2.add(jLabel10);
            jPanel2.add(this.text_tf);
            this.text_tf.setPreferredSize(new Dimension(n2, this.text_tf.getPreferredSize().height));
            jPanel2.add(jLabel11);
            jPanel2.add(this.font_tf);
            jPanel2.add(jLabel12);
            jPanel2.add(this.color_tf);
            this.color_tf.setPreferredSize(new Dimension(n2 / 2, this.color_tf.getPreferredSize().height));
            jPanel2.add(this.color_btn);
            jPanel2.add(jLabel13);
            jPanel2.add(this.width_tf);
            jPanel2.add(jLabel14);
            jPanel2.add(this.alignment_cb);
            jPanel2.add(jLabel15);
            jPanel2.add(this.scrolling_cb);
            jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Language.get("WIN_TEXT_ATTR")));
            SpringLayout springLayout2 = new SpringLayout();
            jPanel2.setLayout(springLayout2);
            springLayout2.putConstraint("North", (Component)jLabel10, 5, "North", (Component)jPanel2);
            springLayout2.putConstraint("West", (Component)jLabel10, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.text_tf, 0, "VerticalCenter", (Component)jLabel10);
            springLayout2.putConstraint("West", (Component)this.text_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("North", (Component)jLabel11, 10, "South", (Component)this.text_tf);
            springLayout2.putConstraint("West", (Component)jLabel11, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.font_tf, 0, "VerticalCenter", (Component)jLabel11);
            springLayout2.putConstraint("West", (Component)this.font_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("East", (Component)this.font_tf, 0, "East", (Component)this.text_tf);
            springLayout2.putConstraint("North", (Component)jLabel12, 10, "South", (Component)this.font_tf);
            springLayout2.putConstraint("West", (Component)jLabel12, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.color_tf, 0, "VerticalCenter", (Component)jLabel12);
            springLayout2.putConstraint("West", (Component)this.color_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.color_btn, 0, "VerticalCenter", (Component)jLabel12);
            springLayout2.putConstraint("West", (Component)this.color_btn, 5, "East", (Component)this.color_tf);
            springLayout2.putConstraint("East", (Component)this.color_btn, 0, "East", (Component)this.text_tf);
            springLayout2.putConstraint("North", (Component)jLabel13, 10, "South", (Component)this.color_btn);
            springLayout2.putConstraint("West", (Component)jLabel13, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.width_tf, 0, "VerticalCenter", (Component)jLabel13);
            springLayout2.putConstraint("West", (Component)this.width_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("East", (Component)this.width_tf, 0, "East", (Component)this.text_tf);
            springLayout2.putConstraint("North", (Component)jLabel14, 10, "South", (Component)this.width_tf);
            springLayout2.putConstraint("West", (Component)jLabel14, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.alignment_cb, 0, "VerticalCenter", (Component)jLabel14);
            springLayout2.putConstraint("West", (Component)this.alignment_cb, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("East", (Component)this.alignment_cb, 0, "East", (Component)this.text_tf);
            springLayout2.putConstraint("North", (Component)jLabel15, 10, "South", (Component)this.alignment_cb);
            springLayout2.putConstraint("West", (Component)jLabel15, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.scrolling_cb, 0, "VerticalCenter", (Component)jLabel15);
            springLayout2.putConstraint("West", (Component)this.scrolling_cb, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("East", (Component)this.scrolling_cb, 0, "East", (Component)this.text_tf);
            springLayout2.putConstraint("East", (Component)jPanel2, 5, "East", (Component)this.text_tf);
            springLayout2.putConstraint("South", (Component)jPanel2, 10, "South", (Component)this.scrolling_cb);
            this.frame.add(jPanel2);
            this.frame.add(this.ok_btn);
            this.frame.add(this.cancel_btn);
            this.frame.add(this.help_btn);
            this.frame.add(jLabel16);
            SpringLayout springLayout3 = new SpringLayout();
            springLayout3.putConstraint("North", (Component)jPanel, 5, "North", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("West", (Component)jPanel, 5, "West", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("North", (Component)jPanel2, 10, "South", (Component)jPanel);
            springLayout3.putConstraint("West", (Component)jPanel2, 5, "West", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("North", (Component)jLabel16, 10, "South", (Component)jPanel2);
            springLayout3.putConstraint("West", (Component)jLabel16, 5, "West", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("North", (Component)this.ok_btn, 10, "South", (Component)jLabel16);
            springLayout3.putConstraint("West", (Component)this.ok_btn, 5, "West", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("North", (Component)this.cancel_btn, 0, "North", (Component)this.ok_btn);
            springLayout3.putConstraint("West", (Component)this.cancel_btn, 5, "East", (Component)this.ok_btn);
            springLayout3.putConstraint("North", (Component)this.help_btn, 0, "North", (Component)this.cancel_btn);
            springLayout3.putConstraint("West", (Component)this.help_btn, 5, "East", (Component)this.cancel_btn);
            springLayout3.putConstraint("South", (Component)this.frame.getContentPane(), 10, "South", (Component)this.ok_btn);
            springLayout3.putConstraint("East", (Component)this.frame.getContentPane(), 5, "East", (Component)jPanel);
            this.frame.setLayout(springLayout3);
            this.frame.pack();
            this.frame.getRootPane().setDefaultButton(this.ok_btn);
        }
        this.id_tf.setText(this.id);
        this.x_tf.setText(String.valueOf(this.x));
        this.y_tf.setText(String.valueOf(this.y));
        this.lefttop_cb.setSelectedItem(this.lefttop);
        this.rightbottom_cb.setSelectedItem(this.rightbottom);
        this.xkeepratio_cb.setSelectedItem(this.xkeepratio);
        this.ykeepratio_cb.setSelectedItem(this.ykeepratio);
        this.visible_tf.setText(this.visible);
        this.help_tf.setText(this.help);
        this.text_tf.setText(this.text);
        this.font_tf.setText(this.font);
        this.color_tf.setText(this.color);
        this.width_tf.setText(String.valueOf(this.width));
        this.alignment_cb.setSelectedItem(this.alignment);
        this.scrolling_cb.setSelectedItem(this.scrolling);
        this.frame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.ok_btn)) {
            if (this.id_tf.getText().equals("")) {
                JOptionPane.showMessageDialog(this.frame, Language.get("ERROR_ID_INVALID_MSG"), Language.get("ERROR_ID_INVALID_TITLE"), 1);
                return;
            }
            if (!this.id_tf.getText().equals(this.id) && this.s.idExists(this.id_tf.getText())) {
                JOptionPane.showMessageDialog(this.frame, Language.get("ERROR_ID_EXISTS_MSG").replaceAll("%i", this.id_tf.getText()), Language.get("ERROR_ID_INVALID_TITLE"), 1);
                return;
            }
            if (!this.font_tf.getText().equals("defaultfont") && this.s.getResource(this.font_tf.getText()) == null) {
                JOptionPane.showMessageDialog(this.frame, Language.get("ERROR_FONT_NEXIST").replaceAll("%i", this.font_tf.getText()), Language.get("ERROR_FONT_NEXIST_TITLE"), 1);
                return;
            }
            this.update();
            this.frame.setVisible(false);
            this.frame.dispose();
            this.frame = null;
        } else if (actionEvent.getSource().equals(this.help_btn)) {
            Helper.browse("http://www.videolan.org/vlc/skinedhlp/i-text.html");
        } else if (actionEvent.getSource().equals(this.color_btn)) {
            Color color = JColorChooser.showDialog(this.frame, Language.get("WIN_TEXT_CHOOSER_TITLE"), Color.decode(this.color_tf.getText()));
            if (color != null) {
                String string = "#";
                if (color.getRed() < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(color.getRed()).toUpperCase();
                if (color.getGreen() < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(color.getGreen()).toUpperCase();
                if (color.getBlue() < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(color.getBlue()).toUpperCase();
                this.color_tf.setText(string);
            }
        } else if (actionEvent.getSource().equals(this.visible_btn)) {
            Helper.browse("http://www.videolan.org/vlc/skinedhlp/boolexpr.html");
        } else if (actionEvent.getSource().equals(this.cancel_btn)) {
            List<Item> list;
            if (!this.created && (list = this.s.getParentListOf(this.id)) != null) {
                list.remove(this);
            }
            this.frame.setVisible(false);
            this.frame.dispose();
            this.frame = null;
        }
    }

    @Override
    public String returnCode(String string) {
        String string2 = string + "<Text";
        string2 = string2 + " text=\"" + this.text + "\"";
        string2 = string2 + " font=\"" + this.font + "\"";
        if (!this.alignment.equals("left")) {
            string2 = string2 + " alignment=\"" + this.alignment + "\"";
        }
        if (!this.color.equals("#000000")) {
            string2 = string2 + " color=\"" + this.color + "\"";
        }
        if (!this.id.equals("Unnamed")) {
            string2 = string2 + " id=\"" + this.id + "\"";
        }
        if (this.x != 0) {
            string2 = string2 + " x=\"" + String.valueOf(this.x) + "\"";
        }
        if (this.y != 0) {
            string2 = string2 + " y=\"" + String.valueOf(this.y) + "\"";
        }
        if (this.width != 0) {
            string2 = string2 + " width=\"" + String.valueOf(this.width) + "\"";
        }
        if (!this.lefttop.equals("lefttop")) {
            string2 = string2 + " lefttop=\"" + this.lefttop + "\"";
        }
        if (!this.rightbottom.equals("lefttop")) {
            string2 = string2 + " rightbottom=\"" + this.rightbottom + "\"";
        }
        if (this.xkeepratio) {
            string2 = string2 + " xkeepratio=\"" + String.valueOf(this.xkeepratio) + "\"";
        }
        if (this.ykeepratio) {
            string2 = string2 + " ykeepratio=\"" + String.valueOf(this.ykeepratio) + "\"";
        }
        if (!this.help.equals("")) {
            string2 = string2 + " help=\"" + this.help + "\"";
        }
        if (!this.visible.equals("true")) {
            string2 = string2 + " visible=\"" + this.visible + "\"";
        }
        string2 = string2 + "/>";
        return string2;
    }

    @Override
    public void draw(Graphics2D graphics2D, int n) {
        this.draw(graphics2D, 0, 0, n);
    }

    @Override
    public void draw(Graphics2D graphics2D, int n, int n2, int n3) {
        Object object;
        Object object2;
        if (!this.created || this.font == null) {
            return;
        }
        Font font = this.s.getFont(this.font);
        if (font == null) {
            object2 = this.s.getResource(this.font);
            if (((Resource)object2).type.equals("Font")) {
                object = (vlcskineditor.resources.Font)object2;
                font = new Font("SansSerif", 0, ((vlcskineditor.resources.Font)object).size);
            } else {
                font = new Font("SansSerif", 0, 12);
            }
        }
        if (this.vis) {
            object = this.s.gvars.parseString(this.text);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setFont(font);
            object2 = this.width == 0 ? new BufferedImage((int)graphics2D.getFontMetrics().getStringBounds((String)object, graphics2D).getWidth(), graphics2D.getFontMetrics().getHeight(), 2) : new BufferedImage(this.width, graphics2D.getFontMetrics().getHeight(), 2);
            Graphics2D graphics2D2 = ((BufferedImage)object2).createGraphics();
            graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D2.setFont(font);
            graphics2D2.setColor(Color.decode(this.color));
            if (this.width != 0 && this.alignment.equals("right")) {
                graphics2D2.drawString((String)object, (int)((double)this.width - graphics2D2.getFontMetrics().getStringBounds((String)object, graphics2D).getWidth()), 0 + graphics2D2.getFontMetrics().getAscent());
            } else if (this.width != 0 && this.alignment.equals("center")) {
                graphics2D2.drawString((String)object, (int)(((double)this.width - graphics2D2.getFontMetrics().getStringBounds((String)object, graphics2D).getWidth()) / 2.0), 0 + graphics2D2.getFontMetrics().getAscent());
            } else {
                graphics2D2.drawString((String)object, 0, 0 + graphics2D2.getFontMetrics().getAscent());
            }
            graphics2D.drawImage((Image)object2, (this.x + n) * n3, (this.y + n2) * n3, ((BufferedImage)object2).getWidth() * n3, ((BufferedImage)object2).getHeight() * n3, null);
        }
        if (this.selected) {
            graphics2D.setColor(Color.RED);
            graphics2D.drawRect((this.x + n) * n3, (this.y + n2) * n3, this.width * n3, font.getSize() * n3);
        }
    }

    @Override
    public boolean contains(int n, int n2) {
        Font font = this.s.getFont(this.font);
        return n >= this.x + this.offsetx && n <= this.x + this.width + this.offsetx && n2 >= this.y + this.offsety && n2 <= this.y + font.getSize() + this.offsety;
    }

    @Override
    public DefaultMutableTreeNode getTreeNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Text: " + this.id);
        return defaultMutableTreeNode;
    }

    @Override
    public boolean uses(String string) {
        return this.font.equals(string);
    }

    @Override
    public void onResourceChanged(ResourceChangedEvent resourceChangedEvent) {
        if (this.font.equals(resourceChangedEvent.getOldID())) {
            this.font = resourceChangedEvent.getResource().id;
        }
    }
}

