/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (C) Marvell International Ltd. and its affiliates
 */

#ifndef __DDR3_PATTERNS_64_H
#define __DDR3_PATTERNS_64_H

/*
 * Patterns Declerations
 */

u32 wl_sup_pattern[LEN_WL_SUP_PATTERN] __aligned(32) = {
	0x04030201, 0x08070605, 0x0c0b0a09, 0x100f0e0d,
	0x14131211, 0x18171615, 0x1c1b1a19, 0x201f1e1d,
	0x24232221, 0x28272625, 0x2c2b2a29, 0x302f2e2d,
	0x34333231, 0x38373635, 0x3c3b3a39, 0x403f3e3d,
	0x44434241, 0x48474645, 0x4c4b4a49, 0x504f4e4d,
	0x54535251, 0x58575655, 0x5c5b5a59, 0x605f5e5d,
	0x64636261, 0x68676665, 0x6c6b6a69, 0x706f6e6d,
	0x74737271, 0x78777675, 0x7c7b7a79, 0x807f7e7d
};

u32 pbs_pattern_32b[2][LEN_PBS_PATTERN] __aligned(32) = {
	{
		0xaaaaaaaa, 0x55555555, 0xaaaaaaaa, 0x55555555,
		0xaaaaaaaa, 0x55555555, 0xaaaaaaaa, 0x55555555,
		0xaaaaaaaa, 0x55555555, 0xaaaaaaaa, 0x55555555,
		0xaaaaaaaa, 0x55555555, 0xaaaaaaaa, 0x55555555
	},
	{
		0x55555555, 0xaaaaaaaa, 0x55555555, 0xaaaaaaaa,
		0x55555555, 0xaaaaaaaa, 0x55555555, 0xaaaaaaaa,
		0x55555555, 0xaaaaaaaa, 0x55555555, 0xaaaaaaaa,
		0x55555555, 0xaaaaaaaa, 0x55555555, 0xaaaaaaaa
	}
};

u32 pbs_pattern_64b[2][LEN_PBS_PATTERN] __aligned(32) = {
	{
		0xaaaaaaaa, 0xaaaaaaaa, 0x55555555, 0x55555555,
		0xaaaaaaaa, 0xaaaaaaaa, 0x55555555, 0x55555555,
		0xaaaaaaaa, 0xaaaaaaaa, 0x55555555, 0x55555555,
		0xaaaaaaaa, 0xaaaaaaaa, 0x55555555, 0x55555555
	},
	{
		0x55555555, 0x55555555, 0xaaaaaaaa, 0xaaaaaaaa,
		0x55555555, 0x55555555, 0xaaaaaaaa, 0xaaaaaaaa,
		0x55555555, 0x55555555, 0xaaaaaaaa, 0xaaaaaaaa,
		0x55555555, 0x55555555, 0xaaaaaaaa, 0xaaaaaaaa
	}
};

u32 rl_pattern[LEN_STD_PATTERN] __aligned(32) = {
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x01010101, 0x01010101, 0x01010101, 0x01010101
};

u32 killer_pattern_32b[DQ_NUM][LEN_KILLER_PATTERN] __aligned(32) = {
	{
		0x01010101, 0x00000000, 0x01010101, 0xffffffff,
		0x01010101, 0x00000000, 0x01010101, 0xffffffff,
		0xfefefefe, 0xfefefefe, 0x01010101, 0xfefefefe,
		0xfefefefe, 0xfefefefe, 0x01010101, 0xfefefefe,
		0x01010101, 0xfefefefe, 0x01010101, 0x01010101,
		0x01010101, 0xfefefefe, 0x01010101, 0x01010101,
		0xfefefefe, 0x01010101, 0xfefefefe, 0x00000000,
		0xfefefefe, 0x01010101, 0xfefefefe, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x01010101,
		0xffffffff, 0x00000000, 0xffffffff, 0x01010101,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0xfefefefe,
		0x00000000, 0x00000000, 0x00000000, 0xfefefefe,
		0xfefefefe, 0xffffffff, 0x00000000, 0x00000000,
		0xfefefefe, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0xffffffff, 0x00000000,
		0x00000000, 0xffffffff, 0xffffffff, 0x00000000,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0xfefefefe, 0x00000000, 0xfefefefe, 0x00000000,
		0xfefefefe, 0x00000000, 0xfefefefe, 0x00000000,
		0x00000000, 0xffffffff, 0xffffffff, 0x01010101,
		0x00000000, 0xffffffff, 0xffffffff, 0x01010101,
		0xffffffff, 0xffffffff, 0x01010101, 0x00000000,
		0xffffffff, 0xffffffff, 0x01010101, 0x00000000,
		0x01010101, 0xffffffff, 0xfefefefe, 0xfefefefe,
		0x01010101, 0xffffffff, 0xfefefefe, 0xfefefefe
	},
	{
		0x02020202, 0x00000000, 0x02020202, 0xffffffff,
		0x02020202, 0x00000000, 0x02020202, 0xffffffff,
		0xfdfdfdfd, 0xfdfdfdfd, 0x02020202, 0xfdfdfdfd,
		0xfdfdfdfd, 0xfdfdfdfd, 0x02020202, 0xfdfdfdfd,
		0x02020202, 0xfdfdfdfd, 0x02020202, 0x02020202,
		0x02020202, 0xfdfdfdfd, 0x02020202, 0x02020202,
		0xfdfdfdfd, 0x02020202, 0xfdfdfdfd, 0x00000000,
		0xfdfdfdfd, 0x02020202, 0xfdfdfdfd, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x02020202,
		0xffffffff, 0x00000000, 0xffffffff, 0x02020202,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0xfdfdfdfd,
		0x00000000, 0x00000000, 0x00000000, 0xfdfdfdfd,
		0xfdfdfdfd, 0xffffffff, 0x00000000, 0x00000000,
		0xfdfdfdfd, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0xffffffff, 0x00000000,
		0x00000000, 0xffffffff, 0xffffffff, 0x00000000,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0xfdfdfdfd, 0x00000000, 0xfdfdfdfd, 0x00000000,
		0xfdfdfdfd, 0x00000000, 0xfdfdfdfd, 0x00000000,
		0x00000000, 0xffffffff, 0xffffffff, 0x02020202,
		0x00000000, 0xffffffff, 0xffffffff, 0x02020202,
		0xffffffff, 0xffffffff, 0x02020202, 0x00000000,
		0xffffffff, 0xffffffff, 0x02020202, 0x00000000,
		0x02020202, 0xffffffff, 0xfdfdfdfd, 0xfdfdfdfd,
		0x02020202, 0xffffffff, 0xfdfdfdfd, 0xfdfdfdfd
	},
	{
		0x04040404, 0x00000000, 0x04040404, 0xffffffff,
		0x04040404, 0x00000000, 0x04040404, 0xffffffff,
		0xfbfbfbfb, 0xfbfbfbfb, 0x04040404, 0xfbfbfbfb,
		0xfbfbfbfb, 0xfbfbfbfb, 0x04040404, 0xfbfbfbfb,
		0x04040404, 0xfbfbfbfb, 0x04040404, 0x04040404,
		0x04040404, 0xfbfbfbfb, 0x04040404, 0x04040404,
		0xfbfbfbfb, 0x04040404, 0xfbfbfbfb, 0x00000000,
		0xfbfbfbfb, 0x04040404, 0xfbfbfbfb, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x04040404,
		0xffffffff, 0x00000000, 0xffffffff, 0x04040404,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0xfbfbfbfb,
		0x00000000, 0x00000000, 0x00000000, 0xfbfbfbfb,
		0xfbfbfbfb, 0xffffffff, 0x00000000, 0x00000000,
		0xfbfbfbfb, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0xffffffff, 0x00000000,
		0x00000000, 0xffffffff, 0xffffffff, 0x00000000,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0xfbfbfbfb, 0x00000000, 0xfbfbfbfb, 0x00000000,
		0xfbfbfbfb, 0x00000000, 0xfbfbfbfb, 0x00000000,
		0x00000000, 0xffffffff, 0xffffffff, 0x04040404,
		0x00000000, 0xffffffff, 0xffffffff, 0x04040404,
		0xffffffff, 0xffffffff, 0x04040404, 0x00000000,
		0xffffffff, 0xffffffff, 0x04040404, 0x00000000,
		0x04040404, 0xffffffff, 0xfbfbfbfb, 0xfbfbfbfb,
		0x04040404, 0xffffffff, 0xfbfbfbfb, 0xfbfbfbfb
	},
	{
		0x08080808, 0x00000000, 0x08080808, 0xffffffff,
		0x08080808, 0x00000000, 0x08080808, 0xffffffff,
		0xf7f7f7f7, 0xf7f7f7f7, 0x08080808, 0xf7f7f7f7,
		0xf7f7f7f7, 0xf7f7f7f7, 0x08080808, 0xf7f7f7f7,
		0x08080808, 0xf7f7f7f7, 0x08080808, 0x08080808,
		0x08080808, 0xf7f7f7f7, 0x08080808, 0x08080808,
		0xf7f7f7f7, 0x08080808, 0xf7f7f7f7, 0x00000000,
		0xf7f7f7f7, 0x08080808, 0xf7f7f7f7, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x08080808,
		0xffffffff, 0x00000000, 0xffffffff, 0x08080808,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0xf7f7f7f7,
		0x00000000, 0x00000000, 0x00000000, 0xf7f7f7f7,
		0xf7f7f7f7, 0xffffffff, 0x00000000, 0x00000000,
		0xf7f7f7f7, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0xffffffff, 0x00000000,
		0x00000000, 0xffffffff, 0xffffffff, 0x00000000,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0xf7f7f7f7, 0x00000000, 0xf7f7f7f7, 0x00000000,
		0xf7f7f7f7, 0x00000000, 0xf7f7f7f7, 0x00000000,
		0x00000000, 0xffffffff, 0xffffffff, 0x08080808,
		0x00000000, 0xffffffff, 0xffffffff, 0x08080808,
		0xffffffff, 0xffffffff, 0x08080808, 0x00000000,
		0xffffffff, 0xffffffff, 0x08080808, 0x00000000,
		0x08080808, 0xffffffff, 0xf7f7f7f7, 0xf7f7f7f7,
		0x08080808, 0xffffffff, 0xf7f7f7f7, 0xf7f7f7f7
	},
	{
		0x10101010, 0x00000000, 0x10101010, 0xffffffff,
		0x10101010, 0x00000000, 0x10101010, 0xffffffff,
		0xefefefef, 0xefefefef, 0x10101010, 0xefefefef,
		0xefefefef, 0xefefefef, 0x10101010, 0xefefefef,
		0x10101010, 0xefefefef, 0x10101010, 0x10101010,
		0x10101010, 0xefefefef, 0x10101010, 0x10101010,
		0xefefefef, 0x10101010, 0xefefefef, 0x00000000,
		0xefefefef, 0x10101010, 0xefefefef, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x10101010,
		0xffffffff, 0x00000000, 0xffffffff, 0x10101010,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0xefefefef,
		0x00000000, 0x00000000, 0x00000000, 0xefefefef,
		0xefefefef, 0xffffffff, 0x00000000, 0x00000000,
		0xefefefef, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0xffffffff, 0x00000000,
		0x00000000, 0xffffffff, 0xffffffff, 0x00000000,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0xefefefef, 0x00000000, 0xefefefef, 0x00000000,
		0xefefefef, 0x00000000, 0xefefefef, 0x00000000,
		0x00000000, 0xffffffff, 0xffffffff, 0x10101010,
		0x00000000, 0xffffffff, 0xffffffff, 0x10101010,
		0xffffffff, 0xffffffff, 0x10101010, 0x00000000,
		0xffffffff, 0xffffffff, 0x10101010, 0x00000000,
		0x10101010, 0xffffffff, 0xefefefef, 0xefefefef,
		0x10101010, 0xffffffff, 0xefefefef, 0xefefefef
	},
	{
		0x20202020, 0x00000000, 0x20202020, 0xffffffff,
		0x20202020, 0x00000000, 0x20202020, 0xffffffff,
		0xdfdfdfdf, 0xdfdfdfdf, 0x20202020, 0xdfdfdfdf,
		0xdfdfdfdf, 0xdfdfdfdf, 0x20202020, 0xdfdfdfdf,
		0x20202020, 0xdfdfdfdf, 0x20202020, 0x20202020,
		0x20202020, 0xdfdfdfdf, 0x20202020, 0x20202020,
		0xdfdfdfdf, 0x20202020, 0xdfdfdfdf, 0x00000000,
		0xdfdfdfdf, 0x20202020, 0xdfdfdfdf, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x20202020,
		0xffffffff, 0x00000000, 0xffffffff, 0x20202020,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0xdfdfdfdf,
		0x00000000, 0x00000000, 0x00000000, 0xdfdfdfdf,
		0xdfdfdfdf, 0xffffffff, 0x00000000, 0x00000000,
		0xdfdfdfdf, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0xffffffff, 0x00000000,
		0x00000000, 0xffffffff, 0xffffffff, 0x00000000,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0xdfdfdfdf, 0x00000000, 0xdfdfdfdf, 0x00000000,
		0xdfdfdfdf, 0x00000000, 0xdfdfdfdf, 0x00000000,
		0x00000000, 0xffffffff, 0xffffffff, 0x20202020,
		0x00000000, 0xffffffff, 0xffffffff, 0x20202020,
		0xffffffff, 0xffffffff, 0x20202020, 0x00000000,
		0xffffffff, 0xffffffff, 0x20202020, 0x00000000,
		0x20202020, 0xffffffff, 0xdfdfdfdf, 0xdfdfdfdf,
		0x20202020, 0xffffffff, 0xdfdfdfdf, 0xdfdfdfdf
	},
	{
		0x40404040, 0x00000000, 0x40404040, 0xffffffff,
		0x40404040, 0x00000000, 0x40404040, 0xffffffff,
		0xbfbfbfbf, 0xbfbfbfbf, 0x40404040, 0xbfbfbfbf,
		0xbfbfbfbf, 0xbfbfbfbf, 0x40404040, 0xbfbfbfbf,
		0x40404040, 0xbfbfbfbf, 0x40404040, 0x40404040,
		0x40404040, 0xbfbfbfbf, 0x40404040, 0x40404040,
		0xbfbfbfbf, 0x40404040, 0xbfbfbfbf, 0x00000000,
		0xbfbfbfbf, 0x40404040, 0xbfbfbfbf, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x40404040,
		0xffffffff, 0x00000000, 0xffffffff, 0x40404040,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0xbfbfbfbf,
		0x00000000, 0x00000000, 0x00000000, 0xbfbfbfbf,
		0xbfbfbfbf, 0xffffffff, 0x00000000, 0x00000000,
		0xbfbfbfbf, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0xffffffff, 0x00000000,
		0x00000000, 0xffffffff, 0xffffffff, 0x00000000,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0xbfbfbfbf, 0x00000000, 0xbfbfbfbf, 0x00000000,
		0xbfbfbfbf, 0x00000000, 0xbfbfbfbf, 0x00000000,
		0x00000000, 0xffffffff, 0xffffffff, 0x40404040,
		0x00000000, 0xffffffff, 0xffffffff, 0x40404040,
		0xffffffff, 0xffffffff, 0x40404040, 0x00000000,
		0xffffffff, 0xffffffff, 0x40404040, 0x00000000,
		0x40404040, 0xffffffff, 0xbfbfbfbf, 0xbfbfbfbf,
		0x40404040, 0xffffffff, 0xbfbfbfbf, 0xbfbfbfbf
	},
	{
		0x80808080, 0x00000000, 0x80808080, 0xffffffff,
		0x80808080, 0x00000000, 0x80808080, 0xffffffff,
		0x7f7f7f7f, 0x7f7f7f7f, 0x80808080, 0x7f7f7f7f,
		0x7f7f7f7f, 0x7f7f7f7f, 0x80808080, 0x7f7f7f7f,
		0x80808080, 0x7f7f7f7f, 0x80808080, 0x80808080,
		0x80808080, 0x7f7f7f7f, 0x80808080, 0x80808080,
		0x7f7f7f7f, 0x80808080, 0x7f7f7f7f, 0x00000000,
		0x7f7f7f7f, 0x80808080, 0x7f7f7f7f, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x00000000,
		0xffffffff, 0x00000000, 0xffffffff, 0x80808080,
		0xffffffff, 0x00000000, 0xffffffff, 0x80808080,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x7f7f7f7f,
		0x00000000, 0x00000000, 0x00000000, 0x7f7f7f7f,
		0x7f7f7f7f, 0xffffffff, 0x00000000, 0x00000000,
		0x7f7f7f7f, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0xffffffff, 0x00000000,
		0x00000000, 0xffffffff, 0xffffffff, 0x00000000,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
		0x7f7f7f7f, 0x00000000, 0x7f7f7f7f, 0x00000000,
		0x7f7f7f7f, 0x00000000, 0x7f7f7f7f, 0x00000000,
		0x00000000, 0xffffffff, 0xffffffff, 0x80808080,
		0x00000000, 0xffffffff, 0xffffffff, 0x80808080,
		0xffffffff, 0xffffffff, 0x80808080, 0x00000000,
		0xffffffff, 0xffffffff, 0x80808080, 0x00000000,
		0x80808080, 0xffffffff, 0x7f7f7f7f, 0x7f7f7f7f,
		0x80808080, 0xffffffff, 0x7f7f7f7f, 0x7f7f7f7f
	}
};

u32 killer_pattern_64b[DQ_NUM][LEN_KILLER_PATTERN] __aligned(32) = {
	{
		0x01010101, 0x01010101, 0x00000000, 0x00000000,
		0x01010101, 0x01010101, 0xffffffff, 0xffffffff,
		0xfefefefe, 0xfefefefe, 0xfefefefe, 0xfefefefe,
		0x01010101, 0x01010101, 0xfefefefe, 0xfefefefe,
		0x01010101, 0x01010101, 0xfefefefe, 0xfefefefe,
		0x01010101, 0x01010101, 0x01010101, 0x01010101,
		0xfefefefe, 0xfefefefe, 0x01010101, 0x01010101,
		0xfefefefe, 0xfefefefe, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x01010101, 0x01010101,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xfefefefe, 0xfefefefe,
		0xfefefefe, 0xfefefefe, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xfefefefe, 0xfefefefe, 0x00000000, 0x00000000,
		0xfefefefe, 0xfefefefe, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x01010101, 0x01010101,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x01010101, 0x01010101, 0x00000000, 0x00000000,
		0x01010101, 0x01010101, 0xffffffff, 0xffffffff,
		0xfefefefe, 0xfefefefe, 0xfefefefe, 0xfefefefe
	},
	{
		0x02020202, 0x02020202, 0x00000000, 0x00000000,
		0x02020202, 0x02020202, 0xffffffff, 0xffffffff,
		0xfdfdfdfd, 0xfdfdfdfd, 0xfdfdfdfd, 0xfdfdfdfd,
		0x02020202, 0x02020202, 0xfdfdfdfd, 0xfdfdfdfd,
		0x02020202, 0x02020202, 0xfdfdfdfd, 0xfdfdfdfd,
		0x02020202, 0x02020202, 0x02020202, 0x02020202,
		0xfdfdfdfd, 0xfdfdfdfd, 0x02020202, 0x02020202,
		0xfdfdfdfd, 0xfdfdfdfd, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x02020202, 0x02020202,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xfdfdfdfd, 0xfdfdfdfd,
		0xfdfdfdfd, 0xfdfdfdfd, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xfdfdfdfd, 0xfdfdfdfd, 0x00000000, 0x00000000,
		0xfdfdfdfd, 0xfdfdfdfd, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x02020202, 0x02020202,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x02020202, 0x02020202, 0x00000000, 0x00000000,
		0x02020202, 0x02020202, 0xffffffff, 0xffffffff,
		0xfdfdfdfd, 0xfdfdfdfd, 0xfdfdfdfd, 0xfdfdfdfd
	},
	{
		0x04040404, 0x04040404, 0x00000000, 0x00000000,
		0x04040404, 0x04040404, 0xffffffff, 0xffffffff,
		0xfbfbfbfb, 0xfbfbfbfb, 0xfbfbfbfb, 0xfbfbfbfb,
		0x04040404, 0x04040404, 0xfbfbfbfb, 0xfbfbfbfb,
		0x04040404, 0x04040404, 0xfbfbfbfb, 0xfbfbfbfb,
		0x04040404, 0x04040404, 0x04040404, 0x04040404,
		0xfbfbfbfb, 0xfbfbfbfb, 0x04040404, 0x04040404,
		0xfbfbfbfb, 0xfbfbfbfb, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x04040404, 0x04040404,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xfbfbfbfb, 0xfbfbfbfb,
		0xfbfbfbfb, 0xfbfbfbfb, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xfbfbfbfb, 0xfbfbfbfb, 0x00000000, 0x00000000,
		0xfbfbfbfb, 0xfbfbfbfb, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x04040404, 0x04040404,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x04040404, 0x04040404, 0x00000000, 0x00000000,
		0x04040404, 0x04040404, 0xffffffff, 0xffffffff,
		0xfbfbfbfb, 0xfbfbfbfb, 0xfbfbfbfb, 0xfbfbfbfb
	},
	{
		0x08080808, 0x08080808, 0x00000000, 0x00000000,
		0x08080808, 0x08080808, 0xffffffff, 0xffffffff,
		0xf7f7f7f7, 0xf7f7f7f7, 0xf7f7f7f7, 0xf7f7f7f7,
		0x08080808, 0x08080808, 0xf7f7f7f7, 0xf7f7f7f7,
		0x08080808, 0x08080808, 0xf7f7f7f7, 0xf7f7f7f7,
		0x08080808, 0x08080808, 0x08080808, 0x08080808,
		0xf7f7f7f7, 0xf7f7f7f7, 0x08080808, 0x08080808,
		0xf7f7f7f7, 0xf7f7f7f7, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x08080808, 0x08080808,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xf7f7f7f7, 0xf7f7f7f7,
		0xf7f7f7f7, 0xf7f7f7f7, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xf7f7f7f7, 0xf7f7f7f7, 0x00000000, 0x00000000,
		0xf7f7f7f7, 0xf7f7f7f7, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x08080808, 0x08080808,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x08080808, 0x08080808, 0x00000000, 0x00000000,
		0x08080808, 0x08080808, 0xffffffff, 0xffffffff,
		0xf7f7f7f7, 0xf7f7f7f7, 0xf7f7f7f7, 0xf7f7f7f7
	},
	{
		0x10101010, 0x10101010, 0x00000000, 0x00000000,
		0x10101010, 0x10101010, 0xffffffff, 0xffffffff,
		0xefefefef, 0xefefefef, 0xefefefef, 0xefefefef,
		0x10101010, 0x10101010, 0xefefefef, 0xefefefef,
		0x10101010, 0x10101010, 0xefefefef, 0xefefefef,
		0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0xefefefef, 0xefefefef, 0x10101010, 0x10101010,
		0xefefefef, 0xefefefef, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xefefefef, 0xefefefef,
		0xefefefef, 0xefefefef, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xefefefef, 0xefefefef, 0x00000000, 0x00000000,
		0xefefefef, 0xefefefef, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x10101010, 0x10101010,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x10101010, 0x10101010, 0x00000000, 0x00000000,
		0x10101010, 0x10101010, 0xffffffff, 0xffffffff,
		0xefefefef, 0xefefefef, 0xefefefef, 0xefefefef
	},
	{
		0x20202020, 0x20202020, 0x00000000, 0x00000000,
		0x20202020, 0x20202020, 0xffffffff, 0xffffffff,
		0xdfdfdfdf, 0xdfdfdfdf, 0xdfdfdfdf, 0xdfdfdfdf,
		0x20202020, 0x20202020, 0xdfdfdfdf, 0xdfdfdfdf,
		0x20202020, 0x20202020, 0xdfdfdfdf, 0xdfdfdfdf,
		0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xdfdfdfdf, 0xdfdfdfdf, 0x20202020, 0x20202020,
		0xdfdfdfdf, 0xdfdfdfdf, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x20202020, 0x20202020,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xdfdfdfdf, 0xdfdfdfdf,
		0xdfdfdfdf, 0xdfdfdfdf, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xdfdfdfdf, 0xdfdfdfdf, 0x00000000, 0x00000000,
		0xdfdfdfdf, 0xdfdfdfdf, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x20202020, 0x20202020,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x20202020, 0x20202020, 0x00000000, 0x00000000,
		0x20202020, 0x20202020, 0xffffffff, 0xffffffff,
		0xdfdfdfdf, 0xdfdfdfdf, 0xdfdfdfdf, 0xdfdfdfdf
	},
	{
		0x40404040, 0x40404040, 0x00000000, 0x00000000,
		0x40404040, 0x40404040, 0xffffffff, 0xffffffff,
		0xbfbfbfbf, 0xbfbfbfbf, 0xbfbfbfbf, 0xbfbfbfbf,
		0x40404040, 0x40404040, 0xbfbfbfbf, 0xbfbfbfbf,
		0x40404040, 0x40404040, 0xbfbfbfbf, 0xbfbfbfbf,
		0x40404040, 0x40404040, 0x40404040, 0x40404040,
		0xbfbfbfbf, 0xbfbfbfbf, 0x40404040, 0x40404040,
		0xbfbfbfbf, 0xbfbfbfbf, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x40404040, 0x40404040,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xbfbfbfbf, 0xbfbfbfbf,
		0xbfbfbfbf, 0xbfbfbfbf, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xbfbfbfbf, 0xbfbfbfbf, 0x00000000, 0x00000000,
		0xbfbfbfbf, 0xbfbfbfbf, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x40404040, 0x40404040,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x40404040, 0x40404040, 0x00000000, 0x00000000,
		0x40404040, 0x40404040, 0xffffffff, 0xffffffff,
		0xbfbfbfbf, 0xbfbfbfbf, 0xbfbfbfbf, 0xbfbfbfbf
	},
	{
		0x80808080, 0x80808080, 0x00000000, 0x00000000,
		0x80808080, 0x80808080, 0xffffffff, 0xffffffff,
		0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
		0x80808080, 0x80808080, 0x7f7f7f7f, 0x7f7f7f7f,
		0x80808080, 0x80808080, 0x7f7f7f7f, 0x7f7f7f7f,
		0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x7f7f7f7f, 0x7f7f7f7f, 0x80808080, 0x80808080,
		0x7f7f7f7f, 0x7f7f7f7f, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x80808080, 0x80808080,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x7f7f7f7f, 0x7f7f7f7f,
		0x7f7f7f7f, 0x7f7f7f7f, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x7f7f7f7f, 0x7f7f7f7f, 0x00000000, 0x00000000,
		0x7f7f7f7f, 0x7f7f7f7f, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x80808080, 0x80808080,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x80808080, 0x80808080, 0x00000000, 0x00000000,
		0x80808080, 0x80808080, 0xffffffff, 0xffffffff,
		0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f
	}
};

u32 special_pattern[DQ_NUM][LEN_SPECIAL_PATTERN] __aligned(32) = {
	{
		0x00000000, 0x00000000, 0x01010101, 0x01010101,
		0xffffffff, 0xffffffff, 0xfefefefe, 0xfefefefe,
		0xfefefefe, 0xfefefefe, 0x01010101, 0x01010101,
		0xfefefefe, 0xfefefefe, 0x01010101, 0x01010101,
		0xfefefefe, 0xfefefefe, 0x01010101, 0x01010101,
		0x01010101, 0x01010101, 0xfefefefe, 0xfefefefe,
		0x01010101, 0x01010101, 0xfefefefe, 0xfefefefe,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x01010101, 0x01010101, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xfefefefe, 0xfefefefe, 0xfefefefe, 0xfefefefe,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xfefefefe, 0xfefefefe,
		0x00000000, 0x00000000, 0xfefefefe, 0xfefefefe,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x01010101, 0x01010101, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x01010101, 0x01010101,
		0x00000000, 0x00000000, 0x01010101, 0x01010101,
		0xffffffff, 0xffffffff, 0xfefefefe, 0xfefefefe,
		0xfefefefe, 0xfefefefe, 0x00000000, 0x00000000
	},
	{
		0x00000000, 0x00000000, 0x02020202, 0x02020202,
		0xffffffff, 0xffffffff, 0xfdfdfdfd, 0xfdfdfdfd,
		0xfdfdfdfd, 0xfdfdfdfd, 0x02020202, 0x02020202,
		0xfdfdfdfd, 0xfdfdfdfd, 0x02020202, 0x02020202,
		0xfdfdfdfd, 0xfdfdfdfd, 0x02020202, 0x02020202,
		0x02020202, 0x02020202, 0xfdfdfdfd, 0xfdfdfdfd,
		0x02020202, 0x02020202, 0xfdfdfdfd, 0xfdfdfdfd,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x02020202, 0x02020202, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xfdfdfdfd, 0xfdfdfdfd, 0xfdfdfdfd, 0xfdfdfdfd,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xfdfdfdfd, 0xfdfdfdfd,
		0x00000000, 0x00000000, 0xfdfdfdfd, 0xfdfdfdfd,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x02020202, 0x02020202, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x02020202, 0x02020202,
		0x00000000, 0x00000000, 0x02020202, 0x02020202,
		0xffffffff, 0xffffffff, 0xfdfdfdfd, 0xfdfdfdfd,
		0xfdfdfdfd, 0xfdfdfdfd, 0x00000000, 0x00000000
	},
	{
		0x00000000, 0x00000000, 0x04040404, 0x04040404,
		0xffffffff, 0xffffffff, 0xfbfbfbfb, 0xfbfbfbfb,
		0xfbfbfbfb, 0xfbfbfbfb, 0x04040404, 0x04040404,
		0xfbfbfbfb, 0xfbfbfbfb, 0x04040404, 0x04040404,
		0xfbfbfbfb, 0xfbfbfbfb, 0x04040404, 0x04040404,
		0x04040404, 0x04040404, 0xfbfbfbfb, 0xfbfbfbfb,
		0x04040404, 0x04040404, 0xfbfbfbfb, 0xfbfbfbfb,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x04040404, 0x04040404, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xfbfbfbfb, 0xfbfbfbfb, 0xfbfbfbfb, 0xfbfbfbfb,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xfbfbfbfb, 0xfbfbfbfb,
		0x00000000, 0x00000000, 0xfbfbfbfb, 0xfbfbfbfb,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x04040404, 0x04040404, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x04040404, 0x04040404,
		0x00000000, 0x00000000, 0x04040404, 0x04040404,
		0xffffffff, 0xffffffff, 0xfbfbfbfb, 0xfbfbfbfb,
		0xfbfbfbfb, 0xfbfbfbfb, 0x00000000, 0x00000000
	},
	{
		0x00000000, 0x00000000, 0x08080808, 0x08080808,
		0xffffffff, 0xffffffff, 0xf7f7f7f7, 0xf7f7f7f7,
		0xf7f7f7f7, 0xf7f7f7f7, 0x08080808, 0x08080808,
		0xf7f7f7f7, 0xf7f7f7f7, 0x08080808, 0x08080808,
		0xf7f7f7f7, 0xf7f7f7f7, 0x08080808, 0x08080808,
		0x08080808, 0x08080808, 0xf7f7f7f7, 0xf7f7f7f7,
		0x08080808, 0x08080808, 0xf7f7f7f7, 0xf7f7f7f7,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x08080808, 0x08080808, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xf7f7f7f7, 0xf7f7f7f7, 0xf7f7f7f7, 0xf7f7f7f7,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xf7f7f7f7, 0xf7f7f7f7,
		0x00000000, 0x00000000, 0xf7f7f7f7, 0xf7f7f7f7,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x08080808, 0x08080808, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x08080808, 0x08080808,
		0x00000000, 0x00000000, 0x08080808, 0x08080808,
		0xffffffff, 0xffffffff, 0xf7f7f7f7, 0xf7f7f7f7,
		0xf7f7f7f7, 0xf7f7f7f7, 0x00000000, 0x00000000
	},
	{
		0x00000000, 0x00000000, 0x10101010, 0x10101010,
		0xffffffff, 0xffffffff, 0xefefefef, 0xefefefef,
		0xefefefef, 0xefefefef, 0x10101010, 0x10101010,
		0xefefefef, 0xefefefef, 0x10101010, 0x10101010,
		0xefefefef, 0xefefefef, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0xefefefef, 0xefefefef,
		0x10101010, 0x10101010, 0xefefefef, 0xefefefef,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x10101010, 0x10101010, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xefefefef, 0xefefefef, 0xefefefef, 0xefefefef,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xefefefef, 0xefefefef,
		0x00000000, 0x00000000, 0xefefefef, 0xefefefef,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x10101010, 0x10101010, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x10101010, 0x10101010,
		0xffffffff, 0xffffffff, 0xefefefef, 0xefefefef,
		0xefefefef, 0xefefefef, 0x00000000, 0x00000000
	},
	{
		0x00000000, 0x00000000, 0x20202020, 0x20202020,
		0xffffffff, 0xffffffff, 0xdfdfdfdf, 0xdfdfdfdf,
		0xdfdfdfdf, 0xdfdfdfdf, 0x20202020, 0x20202020,
		0xdfdfdfdf, 0xdfdfdfdf, 0x20202020, 0x20202020,
		0xdfdfdfdf, 0xdfdfdfdf, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0xdfdfdfdf, 0xdfdfdfdf,
		0x20202020, 0x20202020, 0xdfdfdfdf, 0xdfdfdfdf,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x20202020, 0x20202020, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xdfdfdfdf, 0xdfdfdfdf, 0xdfdfdfdf, 0xdfdfdfdf,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xdfdfdfdf, 0xdfdfdfdf,
		0x00000000, 0x00000000, 0xdfdfdfdf, 0xdfdfdfdf,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x20202020, 0x20202020, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x20202020, 0x20202020,
		0x00000000, 0x00000000, 0x20202020, 0x20202020,
		0xffffffff, 0xffffffff, 0xdfdfdfdf, 0xdfdfdfdf,
		0xdfdfdfdf, 0xdfdfdfdf, 0x00000000, 0x00000000
	},
	{
		0x00000000, 0x00000000, 0x40404040, 0x40404040,
		0xffffffff, 0xffffffff, 0xbfbfbfbf, 0xbfbfbfbf,
		0xbfbfbfbf, 0xbfbfbfbf, 0x40404040, 0x40404040,
		0xbfbfbfbf, 0xbfbfbfbf, 0x40404040, 0x40404040,
		0xbfbfbfbf, 0xbfbfbfbf, 0x40404040, 0x40404040,
		0x40404040, 0x40404040, 0xbfbfbfbf, 0xbfbfbfbf,
		0x40404040, 0x40404040, 0xbfbfbfbf, 0xbfbfbfbf,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x40404040, 0x40404040, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xbfbfbfbf, 0xbfbfbfbf, 0xbfbfbfbf, 0xbfbfbfbf,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xbfbfbfbf, 0xbfbfbfbf,
		0x00000000, 0x00000000, 0xbfbfbfbf, 0xbfbfbfbf,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x40404040, 0x40404040, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x40404040, 0x40404040,
		0x00000000, 0x00000000, 0x40404040, 0x40404040,
		0xffffffff, 0xffffffff, 0xbfbfbfbf, 0xbfbfbfbf,
		0xbfbfbfbf, 0xbfbfbfbf, 0x00000000, 0x00000000
	},
	{
		0x00000000, 0x00000000, 0x80808080, 0x80808080,
		0xffffffff, 0xffffffff, 0x7f7f7f7f, 0x7f7f7f7f,
		0x7f7f7f7f, 0x7f7f7f7f, 0x80808080, 0x80808080,
		0x7f7f7f7f, 0x7f7f7f7f, 0x80808080, 0x80808080,
		0x7f7f7f7f, 0x7f7f7f7f, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x7f7f7f7f, 0x7f7f7f7f,
		0x80808080, 0x80808080, 0x7f7f7f7f, 0x7f7f7f7f,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0x80808080, 0x80808080, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0x7f7f7f7f, 0x7f7f7f7f,
		0x00000000, 0x00000000, 0x7f7f7f7f, 0x7f7f7f7f,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
		0x80808080, 0x80808080, 0xffffffff, 0xffffffff,
		0xffffffff, 0xffffffff, 0x80808080, 0x80808080,
		0x00000000, 0x00000000, 0x80808080, 0x80808080,
		0xffffffff, 0xffffffff, 0x7f7f7f7f, 0x7f7f7f7f,
		0x7f7f7f7f, 0x7f7f7f7f, 0x00000000, 0x00000000
	}
};

/* Fabric ratios table */
u32 fabric_ratio[FAB_OPT] = {
	0x04010204,
	0x04020202,
	0x08020306,
	0x08020303,
	0x04020303,
	0x04020204,
	0x04010202,
	0x08030606,
	0x08030505,
	0x04020306,
	0x0804050a,
	0x04030606,
	0x04020404,
	0x04030306,
	0x04020505,
	0x08020505,
	0x04010303,
	0x08050a0a,
	0x04030408,
	0x04010102,
	0x08030306
};

u32 pbs_dq_mapping[PUP_NUM_64BIT + 1][DQ_NUM] = {
	{3, 2, 5, 7, 1, 0, 6, 4},
	{2, 3, 6, 7, 1, 0, 4, 5},
	{1, 3, 5, 6, 0, 2, 4, 7},
	{0, 2, 4, 7, 1, 3, 5, 6},
	{3, 0, 4, 6, 1, 2, 5, 7},
	{0, 3, 5, 7, 1, 2, 4, 6},
	{2, 3, 5, 7, 1, 0, 4, 6},
	{0, 2, 5, 4, 1, 3, 6, 7},
	{2, 3, 4, 7, 0, 1, 5, 6}
};

#endif /* __DDR3_PATTERNS_64_H */
