/*
 * Copyright (C) Marvell International Ltd. and its affiliates
 *
 * SPDX-License-Identifier:	GPL-2.0
 */

#ifndef __DDR3_PATTERNS_64_H
#define __DDR3_PATTERNS_64_H

/*
 * Patterns Declerations
 */

u32 wl_sup_pattern[LEN_WL_SUP_PATTERN] __aligned(32) = {
	0x04030201, 0x08070605, 0x0c0b0a09, 0x100f0e0d,
	0x14131211, 0x18171615, 0x1c1b1a19, 0x201f1e1d,
	0x24232221, 0x28272625, 0x2c2b2a29, 0x302f2e2d,
	0x34333231, 0x38373635, 0x3c3b3a39, 0x403f3e3d,
	0x44434241, 0x48474645, 0x4c4b4a49, 0x504f4e4d,
	0x54535251, 0x58575655, 0x5c5b5a59, 0x605f5e5d,
	0x64636261, 0x68676665, 0x6c6b6a69, 0x706f6e6d,
	0x74737271, 0x78777675, 0x7c7b7a79, 0x807f7e7d
};

u32 pbs_pattern_32b[2][LEN_PBS_PATTERN] __aligned(32) = {
	{
		0xAAAAAAAA, 0x55555555, 0xAAAAAAAA, 0x55555555,
		0xAAAAAAAA, 0x55555555, 0xAAAAAAAA, 0x55555555,
		0xAAAAAAAA, 0x55555555, 0xAAAAAAAA, 0x55555555,
		0xAAAAAAAA, 0x55555555, 0xAAAAAAAA, 0x55555555
	},
	{
		0x55555555, 0xAAAAAAAA, 0x55555555, 0xAAAAAAAA,
		0x55555555, 0xAAAAAAAA, 0x55555555, 0xAAAAAAAA,
		0x55555555, 0xAAAAAAAA, 0x55555555, 0xAAAAAAAA,
		0x55555555, 0xAAAAAAAA, 0x55555555, 0xAAAAAAAA
	}
};

u32 pbs_pattern_64b[2][LEN_PBS_PATTERN] __aligned(32) = {
	{
		0xAAAAAAAA, 0xAAAAAAAA, 0x55555555, 0x55555555,
		0xAAAAAAAA, 0xAAAAAAAA, 0x55555555, 0x55555555,
		0xAAAAAAAA, 0xAAAAAAAA, 0x55555555, 0x55555555,
		0xAAAAAAAA, 0xAAAAAAAA, 0x55555555, 0x55555555
	},
	{
		0x55555555, 0x55555555, 0xAAAAAAAA, 0xAAAAAAAA,
		0x55555555, 0x55555555, 0xAAAAAAAA, 0xAAAAAAAA,
		0x55555555, 0x55555555, 0xAAAAAAAA, 0xAAAAAAAA,
		0x55555555, 0x55555555, 0xAAAAAAAA, 0xAAAAAAAA
	}
};

u32 rl_pattern[LEN_STD_PATTERN] __aligned(32) = {
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x01010101, 0x01010101, 0x01010101, 0x01010101
};

u32 killer_pattern_32b[DQ_NUM][LEN_KILLER_PATTERN] __aligned(32) = {
	{
		0x01010101, 0x00000000, 0x01010101, 0xFFFFFFFF,
		0x01010101, 0x00000000, 0x01010101, 0xFFFFFFFF,
		0xFEFEFEFE, 0xFEFEFEFE, 0x01010101, 0xFEFEFEFE,
		0xFEFEFEFE, 0xFEFEFEFE, 0x01010101, 0xFEFEFEFE,
		0x01010101, 0xFEFEFEFE, 0x01010101, 0x01010101,
		0x01010101, 0xFEFEFEFE, 0x01010101, 0x01010101,
		0xFEFEFEFE, 0x01010101, 0xFEFEFEFE, 0x00000000,
		0xFEFEFEFE, 0x01010101, 0xFEFEFEFE, 0x00000000,
		0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0x00000000,
		0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0x00000000,
		0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0x01010101,
		0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0x01010101,
		0x00000000, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0x00000000, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0x00000000, 0xFEFEFEFE,
		0x00000000, 0x00000000, 0x00000000, 0xFEFEFEFE,
		0xFEFEFEFE, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFEFEFEFE, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0x00000000, 0xFFFFFFFF, 0xFFFFFFFF, 0x00000000,
		0x00000000, 0xFFFFFFFF, 0xFFFFFFFF, 0x00000000,
		0x00000000, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0x00000000, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0xFEFEFEFE, 0x00000000, 0xFEFEFEFE, 0x00000000,
		0xFEFEFEFE, 0x00000000, 0xFEFEFEFE, 0x00000000,
		0x00000000, 0xFFFFFFFF, 0xFFFFFFFF, 0x01010101,
		0x00000000, 0xFFFFFFFF, 0xFFFFFFFF, 0x01010101,
		0xFFFFFFFF, 0xFFFFFFFF, 0x01010101, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x01010101, 0x00000000,
		0x01010101, 0xFFFFFFFF, 0xFEFEFEFE, 0xFEFEFEFE,
		0x01010101, 0xFFFFFFFF, 0xFEFEFEFE, 0xFEFEFEFE
	},
	{
		0x02020202, 0x00000000, 0x02020202, 0xFFFFFFFF,
		0x02020202, 0x00000000, 0x02020202, 0xFFFFFFFF,
		0xFDFDFDFD, 0xFDFDFDFD, 0x02020202, 0xFDFDFDFD,
		0xFDFDFDFD, 0xFDFDFDFD, 0x02020202, 0xFDFDFDFD,
		0x02020202, 0xFDFDFDFD, 0x02020202, 0x02020202,
		0x02020202, 0xFDFDFDFD, 0x02020202, 0x02020202,
		0xFDFDFDFD, 0x02020202, 0xFDFDFDFD, 0x00000000,
		0xFDFDFDFD, 0x02020202, 0xFDFDFDFD, 0x00000000,
		0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0x00000000,
		0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0x00000000,
		0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0x02020202,
		0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0x02020202,
		0x00000000, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0x00000000, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0x00000000, 0xFDFDFDFD,
		0x00000000, 0x00000000, 0x00000000, 0xFDFDFDFD,
		0xFDFDFDFD, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFDFDFDFD, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0x00000000, 0xFFFFFFFF, 0xFFFFFFFF, 0x00000000,
		0x00000000, 0xFFFFFFFF, 0xFFFFFFFF, 0x00000000,
		0x00000000, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0x00000000, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0xFDFDFDFD, 0x00000000, 0xFDFDFDFD, 0x00000000,
		0xFDFDFDFD, 0x00000000, 0xFDFDFDFD, 0x00000000,
		0x00000000, 0xFFFFFFFF, 0xFFFFFFFF, 0x02020202,
		0x00000000, 0xFFFFFFFF, 0xFFFFFFFF, 0x02020202,
		0xFFFFFFFF, 0xFFFFFFFF, 0x02020202, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x02020202, 0x00000000,
		0x02020202, 0xFFFFFFFF, 0xFDFDFDFD, 0xFDFDFDFD,
		0x02020202, 0xFFFFFFFF, 0xFDFDFDFD, 0xFDFDFDFD
	},
	{
		0x04040404, 0x00000000, 0x04040404, 0xFFFFFFFF,
		0x04040404, 0x00000000, 0x04040404, 0xFFFFFFFF,
		0xFBFBFBFB, 0xFBFBFBFB, 0x04040404, 0xFBFBFBFB,
		0xFBFBFBFB, 0xFBFBFBFB, 0x04040404, 0xFBFBFBFB,
		0x04040404, 0xFBFBFBFB, 0x04040404, 0x04040404,
		0x04040404, 0xFBFBFBFB, 0x04040404, 0x04040404,
		0xFBFBFBFB, 0x04040404, 0xFBFBFBFB, 0x00000000,
		0xFBFBFBFB, 0x04040404, 0xFBFBFBFB, 0x00000000,
		0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0x00000000,
		0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0x00000000,
		0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0x04040404,
		0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0x04040404,
		0x00000000, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0x00000000, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0x00000000, 0xFBFBFBFB,
		0x00000000, 0x00000000, 0x00000000, 0xFBFBFBFB,
		0xFBFBFBFB, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFBFBFBFB, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0x00000000, 0xFFFFFFFF, 0xFFFFFFFF, 0x00000000,
		0x00000000, 0xFFFFFFFF, 0xFFFFFFFF, 0x00000000,
		0x00000000, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0x00000000, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0xFBFBFBFB, 0x00000000, 0xFBFBFBFB, 0x00000000,
		0xFBFBFBFB, 0x00000000, 0xFBFBFBFB, 0x00000000,
		0x00000000, 0xFFFFFFFF, 0xFFFFFFFF, 0x04040404,
		0x00000000, 0xFFFFFFFF, 0xFFFFFFFF, 0x04040404,
		0xFFFFFFFF, 0xFFFFFFFF, 0x04040404, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x04040404, 0x00000000,
		0x04040404, 0xFFFFFFFF, 0xFBFBFBFB, 0xFBFBFBFB,
		0x04040404, 0xFFFFFFFF, 0xFBFBFBFB, 0xFBFBFBFB
	},
	{
		0x08080808, 0x00000000, 0x08080808, 0xFFFFFFFF,
		0x08080808, 0x00000000, 0x08080808, 0xFFFFFFFF,
		0xF7F7F7F7, 0xF7F7F7F7, 0x08080808, 0xF7F7F7F7,
		0xF7F7F7F7, 0xF7F7F7F7, 0x08080808, 0xF7F7F7F7,
		0x08080808, 0xF7F7F7F7, 0x08080808, 0x08080808,
		0x08080808, 0xF7F7F7F7, 0x08080808, 0x08080808,
		0xF7F7F7F7, 0x08080808, 0xF7F7F7F7, 0x00000000,
		0xF7F7F7F7, 0x08080808, 0xF7F7F7F7, 0x00000000,
		0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0x00000000,
		0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0x00000000,
		0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0x08080808,
		0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0x08080808,
		0x00000000, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0x00000000, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0x00000000, 0xF7F7F7F7,
		0x00000000, 0x00000000, 0x00000000, 0xF7F7F7F7,
		0xF7F7F7F7, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xF7F7F7F7, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0x00000000, 0xFFFFFFFF, 0xFFFFFFFF, 0x00000000,
		0x00000000, 0xFFFFFFFF, 0xFFFFFFFF, 0x00000000,
		0x00000000, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0x00000000, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0xF7F7F7F7, 0x00000000, 0xF7F7F7F7, 0x00000000,
		0xF7F7F7F7, 0x00000000, 0xF7F7F7F7, 0x00000000,
		0x00000000, 0xFFFFFFFF, 0xFFFFFFFF, 0x08080808,
		0x00000000, 0xFFFFFFFF, 0xFFFFFFFF, 0x08080808,
		0xFFFFFFFF, 0xFFFFFFFF, 0x08080808, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x08080808, 0x00000000,
		0x08080808, 0xFFFFFFFF, 0xF7F7F7F7, 0xF7F7F7F7,
		0x08080808, 0xFFFFFFFF, 0xF7F7F7F7, 0xF7F7F7F7
	},
	{
		0x10101010, 0x00000000, 0x10101010, 0xFFFFFFFF,
		0x10101010, 0x00000000, 0x10101010, 0xFFFFFFFF,
		0xEFEFEFEF, 0xEFEFEFEF, 0x10101010, 0xEFEFEFEF,
		0xEFEFEFEF, 0xEFEFEFEF, 0x10101010, 0xEFEFEFEF,
		0x10101010, 0xEFEFEFEF, 0x10101010, 0x10101010,
		0x10101010, 0xEFEFEFEF, 0x10101010, 0x10101010,
		0xEFEFEFEF, 0x10101010, 0xEFEFEFEF, 0x00000000,
		0xEFEFEFEF, 0x10101010, 0xEFEFEFEF, 0x00000000,
		0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0x00000000,
		0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0x00000000,
		0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0x10101010,
		0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0x10101010,
		0x00000000, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0x00000000, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0x00000000, 0xEFEFEFEF,
		0x00000000, 0x00000000, 0x00000000, 0xEFEFEFEF,
		0xEFEFEFEF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xEFEFEFEF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0x00000000, 0xFFFFFFFF, 0xFFFFFFFF, 0x00000000,
		0x00000000, 0xFFFFFFFF, 0xFFFFFFFF, 0x00000000,
		0x00000000, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0x00000000, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0xEFEFEFEF, 0x00000000, 0xEFEFEFEF, 0x00000000,
		0xEFEFEFEF, 0x00000000, 0xEFEFEFEF, 0x00000000,
		0x00000000, 0xFFFFFFFF, 0xFFFFFFFF, 0x10101010,
		0x00000000, 0xFFFFFFFF, 0xFFFFFFFF, 0x10101010,
		0xFFFFFFFF, 0xFFFFFFFF, 0x10101010, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x10101010, 0x00000000,
		0x10101010, 0xFFFFFFFF, 0xEFEFEFEF, 0xEFEFEFEF,
		0x10101010, 0xFFFFFFFF, 0xEFEFEFEF, 0xEFEFEFEF
	},
	{
		0x20202020, 0x00000000, 0x20202020, 0xFFFFFFFF,
		0x20202020, 0x00000000, 0x20202020, 0xFFFFFFFF,
		0xDFDFDFDF, 0xDFDFDFDF, 0x20202020, 0xDFDFDFDF,
		0xDFDFDFDF, 0xDFDFDFDF, 0x20202020, 0xDFDFDFDF,
		0x20202020, 0xDFDFDFDF, 0x20202020, 0x20202020,
		0x20202020, 0xDFDFDFDF, 0x20202020, 0x20202020,
		0xDFDFDFDF, 0x20202020, 0xDFDFDFDF, 0x00000000,
		0xDFDFDFDF, 0x20202020, 0xDFDFDFDF, 0x00000000,
		0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0x00000000,
		0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0x00000000,
		0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0x20202020,
		0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0x20202020,
		0x00000000, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0x00000000, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0x00000000, 0xDFDFDFDF,
		0x00000000, 0x00000000, 0x00000000, 0xDFDFDFDF,
		0xDFDFDFDF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xDFDFDFDF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0x00000000, 0xFFFFFFFF, 0xFFFFFFFF, 0x00000000,
		0x00000000, 0xFFFFFFFF, 0xFFFFFFFF, 0x00000000,
		0x00000000, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0x00000000, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0xDFDFDFDF, 0x00000000, 0xDFDFDFDF, 0x00000000,
		0xDFDFDFDF, 0x00000000, 0xDFDFDFDF, 0x00000000,
		0x00000000, 0xFFFFFFFF, 0xFFFFFFFF, 0x20202020,
		0x00000000, 0xFFFFFFFF, 0xFFFFFFFF, 0x20202020,
		0xFFFFFFFF, 0xFFFFFFFF, 0x20202020, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x20202020, 0x00000000,
		0x20202020, 0xFFFFFFFF, 0xDFDFDFDF, 0xDFDFDFDF,
		0x20202020, 0xFFFFFFFF, 0xDFDFDFDF, 0xDFDFDFDF
	},
	{
		0x40404040, 0x00000000, 0x40404040, 0xFFFFFFFF,
		0x40404040, 0x00000000, 0x40404040, 0xFFFFFFFF,
		0xBFBFBFBF, 0xBFBFBFBF, 0x40404040, 0xBFBFBFBF,
		0xBFBFBFBF, 0xBFBFBFBF, 0x40404040, 0xBFBFBFBF,
		0x40404040, 0xBFBFBFBF, 0x40404040, 0x40404040,
		0x40404040, 0xBFBFBFBF, 0x40404040, 0x40404040,
		0xBFBFBFBF, 0x40404040, 0xBFBFBFBF, 0x00000000,
		0xBFBFBFBF, 0x40404040, 0xBFBFBFBF, 0x00000000,
		0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0x00000000,
		0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0x00000000,
		0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0x40404040,
		0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0x40404040,
		0x00000000, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0x00000000, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0x00000000, 0xBFBFBFBF,
		0x00000000, 0x00000000, 0x00000000, 0xBFBFBFBF,
		0xBFBFBFBF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xBFBFBFBF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0x00000000, 0xFFFFFFFF, 0xFFFFFFFF, 0x00000000,
		0x00000000, 0xFFFFFFFF, 0xFFFFFFFF, 0x00000000,
		0x00000000, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0x00000000, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0xBFBFBFBF, 0x00000000, 0xBFBFBFBF, 0x00000000,
		0xBFBFBFBF, 0x00000000, 0xBFBFBFBF, 0x00000000,
		0x00000000, 0xFFFFFFFF, 0xFFFFFFFF, 0x40404040,
		0x00000000, 0xFFFFFFFF, 0xFFFFFFFF, 0x40404040,
		0xFFFFFFFF, 0xFFFFFFFF, 0x40404040, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x40404040, 0x00000000,
		0x40404040, 0xFFFFFFFF, 0xBFBFBFBF, 0xBFBFBFBF,
		0x40404040, 0xFFFFFFFF, 0xBFBFBFBF, 0xBFBFBFBF
	},
	{
		0x80808080, 0x00000000, 0x80808080, 0xFFFFFFFF,
		0x80808080, 0x00000000, 0x80808080, 0xFFFFFFFF,
		0x7F7F7F7F, 0x7F7F7F7F, 0x80808080, 0x7F7F7F7F,
		0x7F7F7F7F, 0x7F7F7F7F, 0x80808080, 0x7F7F7F7F,
		0x80808080, 0x7F7F7F7F, 0x80808080, 0x80808080,
		0x80808080, 0x7F7F7F7F, 0x80808080, 0x80808080,
		0x7F7F7F7F, 0x80808080, 0x7F7F7F7F, 0x00000000,
		0x7F7F7F7F, 0x80808080, 0x7F7F7F7F, 0x00000000,
		0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0x00000000,
		0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0x00000000,
		0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0x80808080,
		0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0x80808080,
		0x00000000, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0x00000000, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0x00000000, 0x7F7F7F7F,
		0x00000000, 0x00000000, 0x00000000, 0x7F7F7F7F,
		0x7F7F7F7F, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0x7F7F7F7F, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0x00000000, 0xFFFFFFFF, 0xFFFFFFFF, 0x00000000,
		0x00000000, 0xFFFFFFFF, 0xFFFFFFFF, 0x00000000,
		0x00000000, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0x00000000, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF,
		0x7F7F7F7F, 0x00000000, 0x7F7F7F7F, 0x00000000,
		0x7F7F7F7F, 0x00000000, 0x7F7F7F7F, 0x00000000,
		0x00000000, 0xFFFFFFFF, 0xFFFFFFFF, 0x80808080,
		0x00000000, 0xFFFFFFFF, 0xFFFFFFFF, 0x80808080,
		0xFFFFFFFF, 0xFFFFFFFF, 0x80808080, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x80808080, 0x00000000,
		0x80808080, 0xFFFFFFFF, 0x7F7F7F7F, 0x7F7F7F7F,
		0x80808080, 0xFFFFFFFF, 0x7F7F7F7F, 0x7F7F7F7F
	}
};

u32 killer_pattern_64b[DQ_NUM][LEN_KILLER_PATTERN] __aligned(32) = {
	{
		0x01010101, 0x01010101, 0x00000000, 0x00000000,
		0x01010101, 0x01010101, 0xFFFFFFFF, 0xFFFFFFFF,
		0xFEFEFEFE, 0xFEFEFEFE, 0xFEFEFEFE, 0xFEFEFEFE,
		0x01010101, 0x01010101, 0xFEFEFEFE, 0xFEFEFEFE,
		0x01010101, 0x01010101, 0xFEFEFEFE, 0xFEFEFEFE,
		0x01010101, 0x01010101, 0x01010101, 0x01010101,
		0xFEFEFEFE, 0xFEFEFEFE, 0x01010101, 0x01010101,
		0xFEFEFEFE, 0xFEFEFEFE, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x01010101, 0x01010101,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xFEFEFEFE, 0xFEFEFEFE,
		0xFEFEFEFE, 0xFEFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0xFEFEFEFE, 0xFEFEFEFE, 0x00000000, 0x00000000,
		0xFEFEFEFE, 0xFEFEFEFE, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0xFFFFFFFF, 0xFFFFFFFF, 0x01010101, 0x01010101,
		0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
		0x01010101, 0x01010101, 0x00000000, 0x00000000,
		0x01010101, 0x01010101, 0xFFFFFFFF, 0xFFFFFFFF,
		0xFEFEFEFE, 0xFEFEFEFE, 0xFEFEFEFE, 0xFEFEFEFE
	},
	{
		0x02020202, 0x02020202, 0x00000000, 0x00000000,
		0x02020202, 0x02020202, 0xFFFFFFFF, 0xFFFFFFFF,
		0xFDFDFDFD, 0xFDFDFDFD, 0xFDFDFDFD, 0xFDFDFDFD,
		0x02020202, 0x02020202, 0xFDFDFDFD, 0xFDFDFDFD,
		0x02020202, 0x02020202, 0xFDFDFDFD, 0xFDFDFDFD,
		0x02020202, 0x02020202, 0x02020202, 0x02020202,
		0xFDFDFDFD, 0xFDFDFDFD, 0x02020202, 0x02020202,
		0xFDFDFDFD, 0xFDFDFDFD, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x02020202, 0x02020202,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xFDFDFDFD, 0xFDFDFDFD,
		0xFDFDFDFD, 0xFDFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0xFDFDFDFD, 0xFDFDFDFD, 0x00000000, 0x00000000,
		0xFDFDFDFD, 0xFDFDFDFD, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0xFFFFFFFF, 0xFFFFFFFF, 0x02020202, 0x02020202,
		0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
		0x02020202, 0x02020202, 0x00000000, 0x00000000,
		0x02020202, 0x02020202, 0xFFFFFFFF, 0xFFFFFFFF,
		0xFDFDFDFD, 0xFDFDFDFD, 0xFDFDFDFD, 0xFDFDFDFD
	},
	{
		0x04040404, 0x04040404, 0x00000000, 0x00000000,
		0x04040404, 0x04040404, 0xFFFFFFFF, 0xFFFFFFFF,
		0xFBFBFBFB, 0xFBFBFBFB, 0xFBFBFBFB, 0xFBFBFBFB,
		0x04040404, 0x04040404, 0xFBFBFBFB, 0xFBFBFBFB,
		0x04040404, 0x04040404, 0xFBFBFBFB, 0xFBFBFBFB,
		0x04040404, 0x04040404, 0x04040404, 0x04040404,
		0xFBFBFBFB, 0xFBFBFBFB, 0x04040404, 0x04040404,
		0xFBFBFBFB, 0xFBFBFBFB, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x04040404, 0x04040404,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xFBFBFBFB, 0xFBFBFBFB,
		0xFBFBFBFB, 0xFBFBFBFB, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0xFBFBFBFB, 0xFBFBFBFB, 0x00000000, 0x00000000,
		0xFBFBFBFB, 0xFBFBFBFB, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0xFFFFFFFF, 0xFFFFFFFF, 0x04040404, 0x04040404,
		0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
		0x04040404, 0x04040404, 0x00000000, 0x00000000,
		0x04040404, 0x04040404, 0xFFFFFFFF, 0xFFFFFFFF,
		0xFBFBFBFB, 0xFBFBFBFB, 0xFBFBFBFB, 0xFBFBFBFB
	},
	{
		0x08080808, 0x08080808, 0x00000000, 0x00000000,
		0x08080808, 0x08080808, 0xFFFFFFFF, 0xFFFFFFFF,
		0xF7F7F7F7, 0xF7F7F7F7, 0xF7F7F7F7, 0xF7F7F7F7,
		0x08080808, 0x08080808, 0xF7F7F7F7, 0xF7F7F7F7,
		0x08080808, 0x08080808, 0xF7F7F7F7, 0xF7F7F7F7,
		0x08080808, 0x08080808, 0x08080808, 0x08080808,
		0xF7F7F7F7, 0xF7F7F7F7, 0x08080808, 0x08080808,
		0xF7F7F7F7, 0xF7F7F7F7, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x08080808, 0x08080808,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xF7F7F7F7, 0xF7F7F7F7,
		0xF7F7F7F7, 0xF7F7F7F7, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0xF7F7F7F7, 0xF7F7F7F7, 0x00000000, 0x00000000,
		0xF7F7F7F7, 0xF7F7F7F7, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0xFFFFFFFF, 0xFFFFFFFF, 0x08080808, 0x08080808,
		0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
		0x08080808, 0x08080808, 0x00000000, 0x00000000,
		0x08080808, 0x08080808, 0xFFFFFFFF, 0xFFFFFFFF,
		0xF7F7F7F7, 0xF7F7F7F7, 0xF7F7F7F7, 0xF7F7F7F7
	},
	{
		0x10101010, 0x10101010, 0x00000000, 0x00000000,
		0x10101010, 0x10101010, 0xFFFFFFFF, 0xFFFFFFFF,
		0xEFEFEFEF, 0xEFEFEFEF, 0xEFEFEFEF, 0xEFEFEFEF,
		0x10101010, 0x10101010, 0xEFEFEFEF, 0xEFEFEFEF,
		0x10101010, 0x10101010, 0xEFEFEFEF, 0xEFEFEFEF,
		0x10101010, 0x10101010, 0x10101010, 0x10101010,
		0xEFEFEFEF, 0xEFEFEFEF, 0x10101010, 0x10101010,
		0xEFEFEFEF, 0xEFEFEFEF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xEFEFEFEF, 0xEFEFEFEF,
		0xEFEFEFEF, 0xEFEFEFEF, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0xEFEFEFEF, 0xEFEFEFEF, 0x00000000, 0x00000000,
		0xEFEFEFEF, 0xEFEFEFEF, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0xFFFFFFFF, 0xFFFFFFFF, 0x10101010, 0x10101010,
		0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
		0x10101010, 0x10101010, 0x00000000, 0x00000000,
		0x10101010, 0x10101010, 0xFFFFFFFF, 0xFFFFFFFF,
		0xEFEFEFEF, 0xEFEFEFEF, 0xEFEFEFEF, 0xEFEFEFEF
	},
	{
		0x20202020, 0x20202020, 0x00000000, 0x00000000,
		0x20202020, 0x20202020, 0xFFFFFFFF, 0xFFFFFFFF,
		0xDFDFDFDF, 0xDFDFDFDF, 0xDFDFDFDF, 0xDFDFDFDF,
		0x20202020, 0x20202020, 0xDFDFDFDF, 0xDFDFDFDF,
		0x20202020, 0x20202020, 0xDFDFDFDF, 0xDFDFDFDF,
		0x20202020, 0x20202020, 0x20202020, 0x20202020,
		0xDFDFDFDF, 0xDFDFDFDF, 0x20202020, 0x20202020,
		0xDFDFDFDF, 0xDFDFDFDF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x20202020, 0x20202020,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xDFDFDFDF, 0xDFDFDFDF,
		0xDFDFDFDF, 0xDFDFDFDF, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0xDFDFDFDF, 0xDFDFDFDF, 0x00000000, 0x00000000,
		0xDFDFDFDF, 0xDFDFDFDF, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0xFFFFFFFF, 0xFFFFFFFF, 0x20202020, 0x20202020,
		0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
		0x20202020, 0x20202020, 0x00000000, 0x00000000,
		0x20202020, 0x20202020, 0xFFFFFFFF, 0xFFFFFFFF,
		0xDFDFDFDF, 0xDFDFDFDF, 0xDFDFDFDF, 0xDFDFDFDF
	},
	{
		0x40404040, 0x40404040, 0x00000000, 0x00000000,
		0x40404040, 0x40404040, 0xFFFFFFFF, 0xFFFFFFFF,
		0xBFBFBFBF, 0xBFBFBFBF, 0xBFBFBFBF, 0xBFBFBFBF,
		0x40404040, 0x40404040, 0xBFBFBFBF, 0xBFBFBFBF,
		0x40404040, 0x40404040, 0xBFBFBFBF, 0xBFBFBFBF,
		0x40404040, 0x40404040, 0x40404040, 0x40404040,
		0xBFBFBFBF, 0xBFBFBFBF, 0x40404040, 0x40404040,
		0xBFBFBFBF, 0xBFBFBFBF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x40404040, 0x40404040,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xBFBFBFBF, 0xBFBFBFBF,
		0xBFBFBFBF, 0xBFBFBFBF, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0xBFBFBFBF, 0xBFBFBFBF, 0x00000000, 0x00000000,
		0xBFBFBFBF, 0xBFBFBFBF, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0xFFFFFFFF, 0xFFFFFFFF, 0x40404040, 0x40404040,
		0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
		0x40404040, 0x40404040, 0x00000000, 0x00000000,
		0x40404040, 0x40404040, 0xFFFFFFFF, 0xFFFFFFFF,
		0xBFBFBFBF, 0xBFBFBFBF, 0xBFBFBFBF, 0xBFBFBFBF
	},
	{
		0x80808080, 0x80808080, 0x00000000, 0x00000000,
		0x80808080, 0x80808080, 0xFFFFFFFF, 0xFFFFFFFF,
		0x7F7F7F7F, 0x7F7F7F7F, 0x7F7F7F7F, 0x7F7F7F7F,
		0x80808080, 0x80808080, 0x7F7F7F7F, 0x7F7F7F7F,
		0x80808080, 0x80808080, 0x7F7F7F7F, 0x7F7F7F7F,
		0x80808080, 0x80808080, 0x80808080, 0x80808080,
		0x7F7F7F7F, 0x7F7F7F7F, 0x80808080, 0x80808080,
		0x7F7F7F7F, 0x7F7F7F7F, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x80808080, 0x80808080,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x7F7F7F7F, 0x7F7F7F7F,
		0x7F7F7F7F, 0x7F7F7F7F, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x7F7F7F7F, 0x7F7F7F7F, 0x00000000, 0x00000000,
		0x7F7F7F7F, 0x7F7F7F7F, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0xFFFFFFFF, 0xFFFFFFFF, 0x80808080, 0x80808080,
		0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
		0x80808080, 0x80808080, 0x00000000, 0x00000000,
		0x80808080, 0x80808080, 0xFFFFFFFF, 0xFFFFFFFF,
		0x7F7F7F7F, 0x7F7F7F7F, 0x7F7F7F7F, 0x7F7F7F7F
	}
};

u32 special_pattern[DQ_NUM][LEN_SPECIAL_PATTERN] __aligned(32) = {
	{
		0x00000000, 0x00000000, 0x01010101, 0x01010101,
		0xFFFFFFFF, 0xFFFFFFFF, 0xFEFEFEFE, 0xFEFEFEFE,
		0xFEFEFEFE, 0xFEFEFEFE, 0x01010101, 0x01010101,
		0xFEFEFEFE, 0xFEFEFEFE, 0x01010101, 0x01010101,
		0xFEFEFEFE, 0xFEFEFEFE, 0x01010101, 0x01010101,
		0x01010101, 0x01010101, 0xFEFEFEFE, 0xFEFEFEFE,
		0x01010101, 0x01010101, 0xFEFEFEFE, 0xFEFEFEFE,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x01010101, 0x01010101, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xFEFEFEFE, 0xFEFEFEFE, 0xFEFEFEFE, 0xFEFEFEFE,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0xFEFEFEFE, 0xFEFEFEFE,
		0x00000000, 0x00000000, 0xFEFEFEFE, 0xFEFEFEFE,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
		0x01010101, 0x01010101, 0xFFFFFFFF, 0xFFFFFFFF,
		0xFFFFFFFF, 0xFFFFFFFF, 0x01010101, 0x01010101,
		0x00000000, 0x00000000, 0x01010101, 0x01010101,
		0xFFFFFFFF, 0xFFFFFFFF, 0xFEFEFEFE, 0xFEFEFEFE,
		0xFEFEFEFE, 0xFEFEFEFE, 0x00000000, 0x00000000
	},
	{
		0x00000000, 0x00000000, 0x02020202, 0x02020202,
		0xFFFFFFFF, 0xFFFFFFFF, 0xFDFDFDFD, 0xFDFDFDFD,
		0xFDFDFDFD, 0xFDFDFDFD, 0x02020202, 0x02020202,
		0xFDFDFDFD, 0xFDFDFDFD, 0x02020202, 0x02020202,
		0xFDFDFDFD, 0xFDFDFDFD, 0x02020202, 0x02020202,
		0x02020202, 0x02020202, 0xFDFDFDFD, 0xFDFDFDFD,
		0x02020202, 0x02020202, 0xFDFDFDFD, 0xFDFDFDFD,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x02020202, 0x02020202, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xFDFDFDFD, 0xFDFDFDFD, 0xFDFDFDFD, 0xFDFDFDFD,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0xFDFDFDFD, 0xFDFDFDFD,
		0x00000000, 0x00000000, 0xFDFDFDFD, 0xFDFDFDFD,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
		0x02020202, 0x02020202, 0xFFFFFFFF, 0xFFFFFFFF,
		0xFFFFFFFF, 0xFFFFFFFF, 0x02020202, 0x02020202,
		0x00000000, 0x00000000, 0x02020202, 0x02020202,
		0xFFFFFFFF, 0xFFFFFFFF, 0xFDFDFDFD, 0xFDFDFDFD,
		0xFDFDFDFD, 0xFDFDFDFD, 0x00000000, 0x00000000
	},
	{
		0x00000000, 0x00000000, 0x04040404, 0x04040404,
		0xFFFFFFFF, 0xFFFFFFFF, 0xFBFBFBFB, 0xFBFBFBFB,
		0xFBFBFBFB, 0xFBFBFBFB, 0x04040404, 0x04040404,
		0xFBFBFBFB, 0xFBFBFBFB, 0x04040404, 0x04040404,
		0xFBFBFBFB, 0xFBFBFBFB, 0x04040404, 0x04040404,
		0x04040404, 0x04040404, 0xFBFBFBFB, 0xFBFBFBFB,
		0x04040404, 0x04040404, 0xFBFBFBFB, 0xFBFBFBFB,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x04040404, 0x04040404, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xFBFBFBFB, 0xFBFBFBFB, 0xFBFBFBFB, 0xFBFBFBFB,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0xFBFBFBFB, 0xFBFBFBFB,
		0x00000000, 0x00000000, 0xFBFBFBFB, 0xFBFBFBFB,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
		0x04040404, 0x04040404, 0xFFFFFFFF, 0xFFFFFFFF,
		0xFFFFFFFF, 0xFFFFFFFF, 0x04040404, 0x04040404,
		0x00000000, 0x00000000, 0x04040404, 0x04040404,
		0xFFFFFFFF, 0xFFFFFFFF, 0xFBFBFBFB, 0xFBFBFBFB,
		0xFBFBFBFB, 0xFBFBFBFB, 0x00000000, 0x00000000
	},
	{
		0x00000000, 0x00000000, 0x08080808, 0x08080808,
		0xFFFFFFFF, 0xFFFFFFFF, 0xF7F7F7F7, 0xF7F7F7F7,
		0xF7F7F7F7, 0xF7F7F7F7, 0x08080808, 0x08080808,
		0xF7F7F7F7, 0xF7F7F7F7, 0x08080808, 0x08080808,
		0xF7F7F7F7, 0xF7F7F7F7, 0x08080808, 0x08080808,
		0x08080808, 0x08080808, 0xF7F7F7F7, 0xF7F7F7F7,
		0x08080808, 0x08080808, 0xF7F7F7F7, 0xF7F7F7F7,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x08080808, 0x08080808, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xF7F7F7F7, 0xF7F7F7F7, 0xF7F7F7F7, 0xF7F7F7F7,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0xF7F7F7F7, 0xF7F7F7F7,
		0x00000000, 0x00000000, 0xF7F7F7F7, 0xF7F7F7F7,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
		0x08080808, 0x08080808, 0xFFFFFFFF, 0xFFFFFFFF,
		0xFFFFFFFF, 0xFFFFFFFF, 0x08080808, 0x08080808,
		0x00000000, 0x00000000, 0x08080808, 0x08080808,
		0xFFFFFFFF, 0xFFFFFFFF, 0xF7F7F7F7, 0xF7F7F7F7,
		0xF7F7F7F7, 0xF7F7F7F7, 0x00000000, 0x00000000
	},
	{
		0x00000000, 0x00000000, 0x10101010, 0x10101010,
		0xFFFFFFFF, 0xFFFFFFFF, 0xEFEFEFEF, 0xEFEFEFEF,
		0xEFEFEFEF, 0xEFEFEFEF, 0x10101010, 0x10101010,
		0xEFEFEFEF, 0xEFEFEFEF, 0x10101010, 0x10101010,
		0xEFEFEFEF, 0xEFEFEFEF, 0x10101010, 0x10101010,
		0x10101010, 0x10101010, 0xEFEFEFEF, 0xEFEFEFEF,
		0x10101010, 0x10101010, 0xEFEFEFEF, 0xEFEFEFEF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x10101010, 0x10101010, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xEFEFEFEF, 0xEFEFEFEF, 0xEFEFEFEF, 0xEFEFEFEF,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0xEFEFEFEF, 0xEFEFEFEF,
		0x00000000, 0x00000000, 0xEFEFEFEF, 0xEFEFEFEF,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
		0x10101010, 0x10101010, 0xFFFFFFFF, 0xFFFFFFFF,
		0xFFFFFFFF, 0xFFFFFFFF, 0x10101010, 0x10101010,
		0x00000000, 0x00000000, 0x10101010, 0x10101010,
		0xFFFFFFFF, 0xFFFFFFFF, 0xEFEFEFEF, 0xEFEFEFEF,
		0xEFEFEFEF, 0xEFEFEFEF, 0x00000000, 0x00000000
	},
	{
		0x00000000, 0x00000000, 0x20202020, 0x20202020,
		0xFFFFFFFF, 0xFFFFFFFF, 0xDFDFDFDF, 0xDFDFDFDF,
		0xDFDFDFDF, 0xDFDFDFDF, 0x20202020, 0x20202020,
		0xDFDFDFDF, 0xDFDFDFDF, 0x20202020, 0x20202020,
		0xDFDFDFDF, 0xDFDFDFDF, 0x20202020, 0x20202020,
		0x20202020, 0x20202020, 0xDFDFDFDF, 0xDFDFDFDF,
		0x20202020, 0x20202020, 0xDFDFDFDF, 0xDFDFDFDF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x20202020, 0x20202020, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xDFDFDFDF, 0xDFDFDFDF, 0xDFDFDFDF, 0xDFDFDFDF,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0xDFDFDFDF, 0xDFDFDFDF,
		0x00000000, 0x00000000, 0xDFDFDFDF, 0xDFDFDFDF,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
		0x20202020, 0x20202020, 0xFFFFFFFF, 0xFFFFFFFF,
		0xFFFFFFFF, 0xFFFFFFFF, 0x20202020, 0x20202020,
		0x00000000, 0x00000000, 0x20202020, 0x20202020,
		0xFFFFFFFF, 0xFFFFFFFF, 0xDFDFDFDF, 0xDFDFDFDF,
		0xDFDFDFDF, 0xDFDFDFDF, 0x00000000, 0x00000000
	},
	{
		0x00000000, 0x00000000, 0x40404040, 0x40404040,
		0xFFFFFFFF, 0xFFFFFFFF, 0xBFBFBFBF, 0xBFBFBFBF,
		0xBFBFBFBF, 0xBFBFBFBF, 0x40404040, 0x40404040,
		0xBFBFBFBF, 0xBFBFBFBF, 0x40404040, 0x40404040,
		0xBFBFBFBF, 0xBFBFBFBF, 0x40404040, 0x40404040,
		0x40404040, 0x40404040, 0xBFBFBFBF, 0xBFBFBFBF,
		0x40404040, 0x40404040, 0xBFBFBFBF, 0xBFBFBFBF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x40404040, 0x40404040, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xBFBFBFBF, 0xBFBFBFBF, 0xBFBFBFBF, 0xBFBFBFBF,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0xBFBFBFBF, 0xBFBFBFBF,
		0x00000000, 0x00000000, 0xBFBFBFBF, 0xBFBFBFBF,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
		0x40404040, 0x40404040, 0xFFFFFFFF, 0xFFFFFFFF,
		0xFFFFFFFF, 0xFFFFFFFF, 0x40404040, 0x40404040,
		0x00000000, 0x00000000, 0x40404040, 0x40404040,
		0xFFFFFFFF, 0xFFFFFFFF, 0xBFBFBFBF, 0xBFBFBFBF,
		0xBFBFBFBF, 0xBFBFBFBF, 0x00000000, 0x00000000
	},
	{
		0x00000000, 0x00000000, 0x80808080, 0x80808080,
		0xFFFFFFFF, 0xFFFFFFFF, 0x7F7F7F7F, 0x7F7F7F7F,
		0x7F7F7F7F, 0x7F7F7F7F, 0x80808080, 0x80808080,
		0x7F7F7F7F, 0x7F7F7F7F, 0x80808080, 0x80808080,
		0x7F7F7F7F, 0x7F7F7F7F, 0x80808080, 0x80808080,
		0x80808080, 0x80808080, 0x7F7F7F7F, 0x7F7F7F7F,
		0x80808080, 0x80808080, 0x7F7F7F7F, 0x7F7F7F7F,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0x80808080, 0x80808080, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0x7F7F7F7F, 0x7F7F7F7F, 0x7F7F7F7F, 0x7F7F7F7F,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0x7F7F7F7F, 0x7F7F7F7F,
		0x00000000, 0x00000000, 0x7F7F7F7F, 0x7F7F7F7F,
		0x00000000, 0x00000000, 0x00000000, 0x00000000,
		0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
		0x80808080, 0x80808080, 0xFFFFFFFF, 0xFFFFFFFF,
		0xFFFFFFFF, 0xFFFFFFFF, 0x80808080, 0x80808080,
		0x00000000, 0x00000000, 0x80808080, 0x80808080,
		0xFFFFFFFF, 0xFFFFFFFF, 0x7F7F7F7F, 0x7F7F7F7F,
		0x7F7F7F7F, 0x7F7F7F7F, 0x00000000, 0x00000000
	}
};

/* Fabric ratios table */
u32 fabric_ratio[FAB_OPT] = {
	0x04010204,
	0x04020202,
	0x08020306,
	0x08020303,
	0x04020303,
	0x04020204,
	0x04010202,
	0x08030606,
	0x08030505,
	0x04020306,
	0x0804050A,
	0x04030606,
	0x04020404,
	0x04030306,
	0x04020505,
	0x08020505,
	0x04010303,
	0x08050A0A,
	0x04030408,
	0x04010102,
	0x08030306
};

u32 pbs_dq_mapping[PUP_NUM_64BIT + 1][DQ_NUM] = {
	{3, 2, 5, 7, 1, 0, 6, 4},
	{2, 3, 6, 7, 1, 0, 4, 5},
	{1, 3, 5, 6, 0, 2, 4, 7},
	{0, 2, 4, 7, 1, 3, 5, 6},
	{3, 0, 4, 6, 1, 2, 5, 7},
	{0, 3, 5, 7, 1, 2, 4, 6},
	{2, 3, 5, 7, 1, 0, 4, 6},
	{0, 2, 5, 4, 1, 3, 6, 7},
	{2, 3, 4, 7, 0, 1, 5, 6}
};

#endif /* __DDR3_PATTERNS_64_H */
