/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#ifndef INCLUDED_SFX2_PAGEIDS_HXX
#define INCLUDED_SFX2_PAGEIDS_HXX

#include <svl/solar.hrc>

#define RID_OPTIONS_START           (SID_LIB_START +    2000)
//      RID_OPTIONS_END             (RID_OPTIONS_START + 100)

// ResId's ------------------------------------------------------------------

#define RID_SFXPAGE_SAVE            (RID_OPTIONS_START +  0)
#define RID_SFXPAGE_GENERAL         (RID_OPTIONS_START +  1)
#define RID_SFXPAGE_PATH            (RID_OPTIONS_START +  6)
#define RID_SFXPAGE_LINGU           (RID_OPTIONS_START +  7)

#define RID_SFXPAGE_PRINTOPTIONS    (RID_OPTIONS_START + 12)

// treeopt
#define RID_SVXPAGE_COLOR                   (RID_SVX_START +  60)
#define OFA_TP_LANGUAGES_FOR_SET_DOCUMENT_LANGUAGE      ( RID_OFA_START + 256 )

// options
#define RID_SVXPAGE_ONLINEUPDATE            (RID_SVX_START + 298)
#define RID_SVXPAGE_INET_SECURITY           (RID_SVX_START + 200)
#define RID_SVXPAGE_INET_PROXY              (RID_SVX_START + 157)
#define RID_SVXPAGE_INET_MAIL               (RID_SVX_START + 155)
#define RID_OFAPAGE_HTMLOPT             (RID_OFA_START + 100)
#define OFA_TP_LANGUAGES                (RID_OFA_START + 205)
#define OFA_TP_MISC                     (RID_OFA_START + 200)
#define OFA_TP_VIEW                     (RID_OFA_START + 202)
#define RID_OFAPAGE_MSFILTEROPT2        (RID_OFA_START + 121)
#define RID_SVXPAGE_OPTIONS_CTL             (RID_SVX_START + 252)
#define RID_SVXPAGE_OPTIONS_JAVA            (RID_SVX_START + 253)
#define RID_SVXPAGE_ACCESSIBILITYCONFIG     (RID_SVX_START + 250)
#define RID_SVXPAGE_ASIAN_LAYOUT            (RID_SVX_START + 246)
#define RID_OPTPAGE_CHART_DEFCOLORS         (RID_SVX_START + 299)
#define RID_SVXPAGE_PERSONALIZATION         (RID_SVX_START + 247)
#define RID_SVXPAGE_COLORCONFIG             (RID_SVX_START + 249)
#define RID_SVXPAGE_BASICIDE_OPTIONS        (RID_SVX_START + 209)
#define RID_SVXPAGE_LANGTOOL_OPTIONS        (RID_SVX_START + 210)
#define RID_SVXPAGE_DEEPL_OPTIONS           (RID_SVX_START + 211)

// Resource-Id's ------------------------------------------------------------

// options
#define RID_SVXPAGE_JSEARCH_OPTIONS         (RID_SVX_START +  840)
#define RID_SVX_FONT_SUBSTITUTION           (RID_SVX_START + 18)

#define RID_SVXPAGE_OPENCL                                  (RID_SVX_START + 254)

#endif

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
