/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#ifndef INCLUDED_SVX_XMLEXCHG_HXX
#define INCLUDED_SVX_XMLEXCHG_HXX

#include <rtl/ustring.hxx>
#include <vcl/transfer.hxx>
#include <svx/svxdllapi.h>

namespace com::sun::star::beans {
    class SAL_NO_VTABLE XPropertySet;
}


namespace svx
{


    //= OXFormsDescriptor


    struct SVXCORE_DLLPUBLIC OXFormsDescriptor {

        OUString szName;
        OUString szServiceName;
        css::uno::Reference< css::beans::XPropertySet >   xPropSet;

        OXFormsDescriptor() {}
        OXFormsDescriptor( const OXFormsDescriptor &rhs ) { *this=rhs; }
        OXFormsDescriptor &operator = ( const OXFormsDescriptor &rhs ) {
            szName = rhs.szName;
            szServiceName = rhs.szServiceName;
            xPropSet = rhs.xPropSet;
            return (*this);
        }
    };


    //= OXFormsTransferable

    class SVXCORE_DLLPUBLIC OXFormsTransferable final : public TransferDataContainer {

            // TransferableHelper overridables
            virtual void        AddSupportedFormats() override;
            virtual bool GetData( const css::datatransfer::DataFlavor& rFlavor, const OUString& rDestDoc ) override;

            OXFormsDescriptor m_aDescriptor;

        public:

            /** construct the transferable
            */
            OXFormsTransferable( const OXFormsDescriptor &rhs );

            /** extracts an xform descriptor from the transferable given
            */
            static const OXFormsDescriptor &extractDescriptor( const TransferableDataHelper& _rData );
    };


}


#endif // INCLUDED_SVX_XMLEXCHG_HXX

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
