/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * Based on LLVM/Clang.
 *
 * This file is distributed under the University of Illinois Open Source
 * License. See LICENSE.TXT for details.
 *
 */

#ifndef DUMMYPLUGIN_H
#define DUMMYPLUGIN_H

#include "../plugin.hxx"

using namespace clang;
using namespace llvm;

namespace loplugin
{

// These classes are used as base classes when building with LO_CLANG_SHARED_PLUGINS.
// Since plugin classes in that case should use just one shared RecursiveASTVisitor,
// sharedvisitor/generator.cxx will make these to be the base classes used, so that
// compiling the code doesn't spend a several minutes optimizing instances
// of RecursiveASTVisitor that will never get used.

template<typename T>
class DummyRecursiveASTVisitor
{
public:
    // These need to be reimplemented, because plugins contain calls to them,
    // but they should actually never get called in the shared-visitor mode.
    // This could be autogenerated too, but it's probably simpler to just extend
    // manually as needed.
    bool TraverseDecl( Decl* ) { return complain(); }
    bool TraverseLinkageSpecDecl( LinkageSpecDecl* ) { return complain(); }
    bool TraverseStmt( Stmt* ) { return complain(); }
    bool TraverseIfStmt( IfStmt* ) { return complain(); }
    bool TraverseWhileStmt( WhileStmt* ) { return complain(); }
    bool TraverseDoStmt( DoStmt* ) { return complain(); }
    bool TraverseForStmt( ForStmt* ) { return complain(); }
    bool TraverseParenExpr( ParenExpr* ) { return complain(); }
    bool TraverseUnaryLNot( UnaryOperator* ) { return complain(); }
    bool TraverseBinLAnd( BinaryOperator* ) { return complain(); }
    bool TraverseBinLOr( BinaryOperator* ) { return complain(); }
    bool TraverseConditionalOperator( ConditionalOperator* ) { return complain(); }
    bool TraverseCXXCatchStmt( CXXCatchStmt* ) { return complain(); }
    bool TraverseCXXDestructorDecl( CXXDestructorDecl* ) { return complain(); }
    bool TraverseFunctionDecl( FunctionDecl* ) { return complain(); }
    bool TraverseSwitchStmt( SwitchStmt* ) { return complain(); }
    bool TraverseImplicitCastExpr( ImplicitCastExpr* ) { return complain(); }
    bool TraverseCStyleCastExpr( CStyleCastExpr* ) { return complain(); }
    bool TraverseCXXStaticCastExpr( CXXStaticCastExpr* ) { return complain(); }
    bool TraverseCXXFunctionalCastExpr( CXXFunctionalCastExpr* ) { return complain(); }
    bool TraverseFriendDecl( FriendDecl* ) { return complain(); }
    bool TraverseTypeLoc( TypeLoc ) { return complain(); }
    bool TraverseAlignedAttr( AlignedAttr* ) { return complain(); }
private:
    bool complain() { assert(false && "should not be calling this in sharedplugin mode"); abort(); return false; }
};

template<typename Derived>
class DummyFilteringPlugin : public DummyRecursiveASTVisitor<Derived>, public Plugin
{
public:
    explicit DummyFilteringPlugin( const InstantiationData& data ) : Plugin(data) {}
};

template<typename Derived>
class DummyFilteringRewritePlugin : public DummyRecursiveASTVisitor<Derived>, public RewritePlugin
{
public:
    explicit DummyFilteringRewritePlugin( const InstantiationData& data ) : RewritePlugin(data) {}
};

} // namespace

#endif // DUMMYPLUGIN_H

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
