/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef INCLUDED_WRITERFILTER_SOURCE_RTFTOK_RTFCONTROLWORDS_HXX
#define INCLUDED_WRITERFILTER_SOURCE_RTFTOK_RTFCONTROLWORDS_HXX

namespace writerfilter
{
namespace rtftok
{
/**
 * An RTF destination state is the last open destination control word.
 *
 * Note that this is not a 1:1 mapping between destination control
 * words, e.g. RTF_PICT gets mapped to Destination::PICT or
 * Destination::SHAPEPROPERTYVALUEPICT.
 */
enum class Destination
{
    NORMAL,
    SKIP,
    FONTTABLE,
    FONTENTRY,
    COLORTABLE,
    STYLESHEET,
    STYLEENTRY,
    FIELD,
    FIELDINSTRUCTION,
    FIELDRESULT,
    LISTTABLE,
    LISTPICTURE,
    LISTENTRY,
    LISTNAME,
    LISTOVERRIDETABLE,
    LISTOVERRIDEENTRY,
    LISTLEVEL,
    LEVELTEXT,
    LEVELNUMBERS,
    SHPPICT,
    PICT,
    PICPROP,
    SHAPEPROPERTY,
    SHAPEPROPERTYNAME,
    SHAPEPROPERTYVALUE,
    SHAPE,
    SHAPEINSTRUCTION,
    SHAPEPROPERTYVALUEPICT,
    NESTEDTABLEPROPERTIES,
    FOOTNOTE,
    BOOKMARKSTART,
    BOOKMARKEND,
    REVISIONTABLE,
    REVISIONENTRY,
    SHAPETEXT,
    FORMFIELD,
    FORMFIELDNAME,
    FORMFIELDLIST,
    DATAFIELD,
    INFO,
    CREATIONTIME,
    REVISIONTIME,
    PRINTTIME,
    AUTHOR,
    KEYWORDS,
    OPERATOR,
    COMPANY,
    COMMENT,
    OBJECT,
    OBJDATA,
    OBJCLASS,
    RESULT,
    ANNOTATIONDATE,
    ANNOTATIONAUTHOR,
    ANNOTATIONREFERENCE,
    FALT,
    FLYMAINCONTENT,
    DRAWINGOBJECT,
    PARAGRAPHNUMBERING,
    PARAGRAPHNUMBERING_TEXTBEFORE,
    PARAGRAPHNUMBERING_TEXTAFTER,
    TITLE,
    SUBJECT,
    DOCCOMM,
    ATNID,
    ANNOTATIONREFERENCESTART,
    ANNOTATIONREFERENCEEND,
    MOMATH,
    MR,
    MF,
    MFPR,
    MCTRLPR,
    MNUM,
    MDEN,
    MACC,
    MACCPR,
    MCHR,
    MPOS,
    MVERTJC,
    MSTRIKEH,
    MDEGHIDE,
    ME,
    MBAR,
    MBARPR,
    MD,
    MDPR,
    MBEGCHR,
    MSEPCHR,
    MENDCHR,
    MFUNC,
    MFUNCPR,
    MFNAME,
    MLIMLOW,
    MLIMLOWPR,
    MLIM,
    MM,
    MMPR,
    MMR,
    MNARY,
    MNARYPR,
    MSUB,
    MSUP,
    MSUBHIDE,
    MSUPHIDE,
    MLIMUPP,
    MLIMUPPPR,
    MGROUPCHR,
    MGROUPCHRPR,
    MBORDERBOX,
    MBORDERBOXPR,
    MRAD,
    MRADPR,
    MDEG,
    MSSUB,
    MSSUBPR,
    MSSUP,
    MSSUPPR,
    MSSUBSUP,
    MSSUBSUPPR,
    MSPRE,
    MSPREPR,
    MTYPE,
    MGROW,
    MBOX,
    MEQARR,
    UPR,
    LFOLEVEL,
    BACKGROUND,
    SHAPEGROUP,
    FOOTNOTESEPARATOR,
    INDEXENTRY,
    TOCENTRY,
    USERPROPS,
    PROPNAME,
    STATICVAL,
};

enum RTFKeyword
{
    RTF_invalid = -1,
    RTF_HEXCHAR,
    RTF_OPTHYPH,
    RTF_IGNORE,
    RTF_SUBENTRY,
    RTF_BACKSLASH,
    RTF_NOBRKHYPH,
    RTF_LBRACE,
    RTF_FORMULA,
    RTF_RBRACE,
    RTF_NOBREAK,
    RTF_AB,
    RTF_ABSH,
    RTF_ABSLOCK,
    RTF_ABSNOOVRLP,
    RTF_ABSW,
    RTF_ACAPS,
    RTF_ACCCIRCLE,
    RTF_ACCCOMMA,
    RTF_ACCDOT,
    RTF_ACCNONE,
    RTF_ACCUNDERDOT,
    RTF_ACF,
    RTF_ADEFF,
    RTF_ADDITIVE,
    RTF_ADEFLANG,
    RTF_ADJUSTRIGHT,
    RTF_ADN,
    RTF_AENDDOC,
    RTF_AENDNOTES,
    RTF_AEXPND,
    RTF_AF,
    RTF_AFELEV,
    RTF_AFS,
    RTF_AFTNBJ,
    RTF_AFTNCN,
    RTF_AFTNNALC,
    RTF_AFTNNAR,
    RTF_AFTNNAUC,
    RTF_AFTNNCHI,
    RTF_AFTNNCHOSUNG,
    RTF_AFTNNCNUM,
    RTF_AFTNNDBAR,
    RTF_AFTNNDBNUM,
    RTF_AFTNNDBNUMD,
    RTF_AFTNNDBNUMK,
    RTF_AFTNNDBNUMT,
    RTF_AFTNNGANADA,
    RTF_AFTNNGBNUM,
    RTF_AFTNNGBNUMD,
    RTF_AFTNNGBNUMK,
    RTF_AFTNNGBNUML,
    RTF_AFTNNRLC,
    RTF_AFTNNRUC,
    RTF_AFTNNZODIAC,
    RTF_AFTNNZODIACD,
    RTF_AFTNNZODIACL,
    RTF_AFTNRESTART,
    RTF_AFTNRSTCONT,
    RTF_AFTNSEP,
    RTF_AFTNSEPC,
    RTF_AFTNSTART,
    RTF_AFTNTJ,
    RTF_AI,
    RTF_ALANG,
    RTF_ALLOWFIELDENDSEL,
    RTF_ALLPROT,
    RTF_ALNTBLIND,
    RTF_ALT,
    RTF_ANIMTEXT,
    RTF_ANNOTATION,
    RTF_ANNOTPROT,
    RTF_ANSI,
    RTF_ANSICPG,
    RTF_AOUTL,
    RTF_APPLYBRKRULES,
    RTF_ASCAPS,
    RTF_ASHAD,
    RTF_ASIANBRKRULE,
    RTF_ASPALPHA,
    RTF_ASPNUM,
    RTF_ASTRIKE,
    RTF_ATNAUTHOR,
    RTF_ATNDATE,
    RTF_ATNICN,
    RTF_ATNID,
    RTF_ATNPARENT,
    RTF_ATNREF,
    RTF_ATNTIME,
    RTF_ATRFEND,
    RTF_ATRFSTART,
    RTF_AUL,
    RTF_AULD,
    RTF_AULDB,
    RTF_AULNONE,
    RTF_AULW,
    RTF_AUP,
    RTF_AUTHOR,
    RTF_AUTOFMTOVERRIDE,
    RTF_B,
    RTF_BACKGROUND,
    RTF_BDBFHDR,
    RTF_BDRRLSWSIX,
    RTF_BGBDIAG,
    RTF_BGCROSS,
    RTF_BGDCROSS,
    RTF_BGDKBDIAG,
    RTF_BGDKCROSS,
    RTF_BGDKDCROSS,
    RTF_BGDKFDIAG,
    RTF_BGDKHORIZ,
    RTF_BGDKVERT,
    RTF_BGFDIAG,
    RTF_BGHORIZ,
    RTF_BGVERT,
    RTF_BIN,
    RTF_BINFSXN,
    RTF_BINSXN,
    RTF_BKMKCOLF,
    RTF_BKMKCOLL,
    RTF_BKMKEND,
    RTF_BKMKPUB,
    RTF_BKMKSTART,
    RTF_BLIPTAG,
    RTF_BLIPUID,
    RTF_BLIPUPI,
    RTF_BLUE,
    RTF_BOOKFOLD,
    RTF_BOOKFOLDREV,
    RTF_BOOKFOLDSHEETS,
    RTF_BOX,
    RTF_BRDRART,
    RTF_BRDRB,
    RTF_BRDRBAR,
    RTF_BRDRBTW,
    RTF_BRDRCF,
    RTF_BRDRDASH,
    RTF_BRDRDASHD,
    RTF_BRDRDASHDD,
    RTF_BRDRDASHDOTSTR,
    RTF_BRDRDASHSM,
    RTF_BRDRDB,
    RTF_BRDRDOT,
    RTF_BRDREMBOSS,
    RTF_BRDRENGRAVE,
    RTF_BRDRFRAME,
    RTF_BRDRHAIR,
    RTF_BRDRINSET,
    RTF_BRDRL,
    RTF_BRDRNIL,
    RTF_BRDRNONE,
    RTF_BRDROUTSET,
    RTF_BRDRR,
    RTF_BRDRS,
    RTF_BRDRSH,
    RTF_BRDRT,
    RTF_BRDRTBL,
    RTF_BRDRTH,
    RTF_BRDRTHTNLG,
    RTF_BRDRTHTNMG,
    RTF_BRDRTHTNSG,
    RTF_BRDRTNTHLG,
    RTF_BRDRTNTHMG,
    RTF_BRDRTNTHSG,
    RTF_BRDRTNTHTNLG,
    RTF_BRDRTNTHTNMG,
    RTF_BRDRTNTHTNSG,
    RTF_BRDRTRIPLE,
    RTF_BRDRW,
    RTF_BRDRWAVY,
    RTF_BRDRWAVYDB,
    RTF_BRKFRM,
    RTF_BRSP,
    RTF_BULLET,
    RTF_BUPTIM,
    RTF_BXE,
    RTF_CACCENTFIVE,
    RTF_CACCENTFOUR,
    RTF_CACCENTONE,
    RTF_CACCENTSIX,
    RTF_CACCENTTHREE,
    RTF_CACCENTTWO,
    RTF_CACHEDCOLBAL,
    RTF_CAPS,
    RTF_CATEGORY,
    RTF_CB,
    RTF_CBACKGROUNDONE,
    RTF_CBACKGROUNDTWO,
    RTF_CBPAT,
    RTF_CCHS,
    RTF_CELL,
    RTF_CELLX,
    RTF_CF,
    RTF_CFOLLOWEDHYPERLINK,
    RTF_CFPAT,
    RTF_CGRID,
    RTF_CHARRSID,
    RTF_CHARSCALEX,
    RTF_CHATN,
    RTF_CHBGBDIAG,
    RTF_CHBGCROSS,
    RTF_CHBGDCROSS,
    RTF_CHBGDKBDIAG,
    RTF_CHBGDKCROSS,
    RTF_CHBGDKDCROSS,
    RTF_CHBGDKFDIAG,
    RTF_CHBGDKHORIZ,
    RTF_CHBGDKVERT,
    RTF_CHBGFDIAG,
    RTF_CHBGHORIZ,
    RTF_CHBGVERT,
    RTF_CHBRDR,
    RTF_CHCBPAT,
    RTF_CHCFPAT,
    RTF_CHDATE,
    RTF_CHDPA,
    RTF_CHDPL,
    RTF_CHFTN,
    RTF_CHFTNSEP,
    RTF_CHFTNSEPC,
    RTF_CHPGN,
    RTF_CHHRES,
    RTF_CHSHDNG,
    RTF_CHTIME,
    RTF_CHYPERLINK,
    RTF_CLBGBDIAG,
    RTF_CLBGCROSS,
    RTF_CLBGDCROSS,
    RTF_CLBGDKBDIAG,
    RTF_CLBGDKCROSS,
    RTF_CLBGDKDCROSS,
    RTF_CLBGDKFDIAG,
    RTF_CLBGDKHOR,
    RTF_CLBGDKVERT,
    RTF_CLBGFDIAG,
    RTF_CLBGHORIZ,
    RTF_CLBGVERT,
    RTF_CLBRDRB,
    RTF_CLBRDRL,
    RTF_CLBRDRR,
    RTF_CLBRDRT,
    RTF_CLCBPAT,
    RTF_CLCBPATRAW,
    RTF_CLCFPAT,
    RTF_CLCFPATRAW,
    RTF_CLDEL,
    RTF_CLDELAUTH,
    RTF_CLDELDTTM,
    RTF_CLDGLL,
    RTF_CLDGLU,
    RTF_CLFITTEXT,
    RTF_CLFTSWIDTH,
    RTF_CLHIDEMARK,
    RTF_CLINS,
    RTF_CLINSAUTH,
    RTF_CLINSDTTM,
    RTF_CLMGF,
    RTF_CLMRG,
    RTF_CLMRGD,
    RTF_CLMRGDAUTH,
    RTF_CLMRGDDTTM,
    RTF_CLMRGDR,
    RTF_CLNOWRAP,
    RTF_CLPADB,
    RTF_CLPADFB,
    RTF_CLPADFL,
    RTF_CLPADFR,
    RTF_CLPADFT,
    RTF_CLPADL,
    RTF_CLPADR,
    RTF_CLPADT,
    RTF_CLSPB,
    RTF_CLSPFB,
    RTF_CLSPFL,
    RTF_CLSPFR,
    RTF_CLSPFT,
    RTF_CLSPL,
    RTF_CLSPR,
    RTF_CLSPT,
    RTF_CLSHDNG,
    RTF_CLSHDNGRAW,
    RTF_CLSHDRAWNIL,
    RTF_CLSPLIT,
    RTF_CLSPLITR,
    RTF_CLTXBTLR,
    RTF_CLTXLRTB,
    RTF_CLTXLRTBV,
    RTF_CLTXTBRL,
    RTF_CLTXTBRLV,
    RTF_CLVERTALB,
    RTF_CLVERTALC,
    RTF_CLVERTALT,
    RTF_CLVMGF,
    RTF_CLVMRG,
    RTF_CLWWIDTH,
    RTF_CMAINDARKONE,
    RTF_CMAINDARKTWO,
    RTF_CMAINLIGHTONE,
    RTF_CMAINLIGHTTWO,
    RTF_COLLAPSED,
    RTF_COLNO,
    RTF_COLORSCHEMEMAPPING,
    RTF_COLORTBL,
    RTF_COLS,
    RTF_COLSR,
    RTF_COLSX,
    RTF_COLUMN,
    RTF_COLW,
    RTF_COMMENT,
    RTF_COMPANY,
    RTF_CONTEXTUALSPACE,
    RTF_CPG,
    RTF_CRAUTH,
    RTF_CRDATE,
    RTF_CREATIM,
    RTF_CS,
    RTF_CSHADE,
    RTF_CTEXTONE,
    RTF_CTEXTTWO,
    RTF_CTINT,
    RTF_CTRL,
    RTF_CTS,
    RTF_CUFI,
    RTF_CULI,
    RTF_CURI,
    RTF_CVMME,
    RTF_DATAFIELD,
    RTF_DATASTORE,
    RTF_DATE,
    RTF_DBCH,
    RTF_DEFCHP,
    RTF_DEFF,
    RTF_DEFFORMAT,
    RTF_DEFLANG,
    RTF_DEFLANGFE,
    RTF_DEFPAP,
    RTF_DEFSHP,
    RTF_DEFTAB,
    RTF_DELETED,
    RTF_DELRSID,
    RTF_DFRAUTH,
    RTF_DFRDATE,
    RTF_DFRMTXTX,
    RTF_DFRMTXTY,
    RTF_DFRSTART,
    RTF_DFRSTOP,
    RTF_DFRXST,
    RTF_DGHORIGIN,
    RTF_DGHSHOW,
    RTF_DGHSPACE,
    RTF_DGMARGIN,
    RTF_DGSNAP,
    RTF_DGVORIGIN,
    RTF_DGVSHOW,
    RTF_DGVSPACE,
    RTF_DIBITMAP,
    RTF_DISABLED,
    RTF_DN,
    RTF_DNTBLNSBDB,
    RTF_DO,
    RTF_DOBXCOLUMN,
    RTF_DOBXMARGIN,
    RTF_DOBXPAGE,
    RTF_DOBYMARGIN,
    RTF_DOBYPAGE,
    RTF_DOBYPARA,
    RTF_DOCCOMM,
    RTF_DOCTEMP,
    RTF_DOCTYPE,
    RTF_DOCVAR,
    RTF_DODHGT,
    RTF_DOLOCK,
    RTF_DONOTEMBEDLINGDATA,
    RTF_DONOTEMBEDSYSFONT,
    RTF_DONOTSHOWCOMMENTS,
    RTF_DONOTSHOWINSDEL,
    RTF_DONOTSHOWMARKUP,
    RTF_DONOTSHOWPROPS,
    RTF_DPAENDHOL,
    RTF_DPAENDL,
    RTF_DPAENDSOL,
    RTF_DPAENDW,
    RTF_DPARC,
    RTF_DPARCFLIPX,
    RTF_DPARCFLIPY,
    RTF_DPASTARTHOL,
    RTF_DPASTARTL,
    RTF_DPASTARTSOL,
    RTF_DPASTARTW,
    RTF_DPCALLOUT,
    RTF_DPCOA,
    RTF_DPCOACCENT,
    RTF_DPCOBESTFIT,
    RTF_DPCOBORDER,
    RTF_DPCODABS,
    RTF_DPCODBOTTOM,
    RTF_DPCODCENTER,
    RTF_DPCODESCENT,
    RTF_DPCODTOP,
    RTF_DPCOLENGTH,
    RTF_DPCOMINUSX,
    RTF_DPCOMINUSY,
    RTF_DPCOOFFSET,
    RTF_DPCOSMARTA,
    RTF_DPCOTDOUBLE,
    RTF_DPCOTRIGHT,
    RTF_DPCOTSINGLE,
    RTF_DPCOTTRIPLE,
    RTF_DPCOUNT,
    RTF_DPELLIPSE,
    RTF_DPENDGROUP,
    RTF_DPFILLBGCB,
    RTF_DPFILLBGCG,
    RTF_DPFILLBGCR,
    RTF_DPFILLBGGRAY,
    RTF_DPFILLBGPAL,
    RTF_DPFILLFGCB,
    RTF_DPFILLFGCG,
    RTF_DPFILLFGCR,
    RTF_DPFILLFGGRAY,
    RTF_DPFILLFGPAL,
    RTF_DPFILLPAT,
    RTF_DPGROUP,
    RTF_DPLINE,
    RTF_DPLINECOB,
    RTF_DPLINECOG,
    RTF_DPLINECOR,
    RTF_DPLINEDADO,
    RTF_DPLINEDADODO,
    RTF_DPLINEDASH,
    RTF_DPLINEDOT,
    RTF_DPLINEGRAY,
    RTF_DPLINEHOLLOW,
    RTF_DPLINEPAL,
    RTF_DPLINESOLID,
    RTF_DPLINEW,
    RTF_DPPOLYCOUNT,
    RTF_DPPOLYGON,
    RTF_DPPOLYLINE,
    RTF_DPPTX,
    RTF_DPPTY,
    RTF_DPRECT,
    RTF_DPROUNDR,
    RTF_DPSHADOW,
    RTF_DPSHADX,
    RTF_DPSHADY,
    RTF_DPTXBTLR,
    RTF_DPTXBX,
    RTF_DPTXBXMAR,
    RTF_DPTXBXTEXT,
    RTF_DPTXLRTB,
    RTF_DPTXLRTBV,
    RTF_DPTXTBRL,
    RTF_DPTXTBRLV,
    RTF_DPX,
    RTF_DPXSIZE,
    RTF_DPY,
    RTF_DPYSIZE,
    RTF_DROPCAPLI,
    RTF_DROPCAPT,
    RTF_DS,
    RTF_DXFRTEXT,
    RTF_DY,
    RTF_EBCEND,
    RTF_EBCSTART,
    RTF_EDMINS,
    RTF_EMBO,
    RTF_EMDASH,
    RTF_EMFBLIP,
    RTF_EMSPACE,
    RTF_ENDASH,
    RTF_ENDDOC,
    RTF_ENDNHERE,
    RTF_ENDNOTES,
    RTF_ENFORCEPROT,
    RTF_ENSPACE,
    RTF_EXPND,
    RTF_EXPNDTW,
    RTF_EXPSHRTN,
    RTF_F,
    RTF_FAAUTO,
    RTF_FACENTER,
    RTF_FACINGP,
    RTF_FACTOIDNAME,
    RTF_FAFIXED,
    RTF_FAHANG,
    RTF_FALT,
    RTF_FAROMAN,
    RTF_FAVAR,
    RTF_FBIAS,
    RTF_FBIDI,
    RTF_FBIDIS,
    RTF_FBIMAJOR,
    RTF_FBIMINOR,
    RTF_FCHARS,
    RTF_FCHARSET,
    RTF_FCS,
    RTF_FDBMAJOR,
    RTF_FDBMINOR,
    RTF_FDECOR,
    RTF_FELNBRELEV,
    RTF_FET,
    RTF_FETCH,
    RTF_FFDEFRES,
    RTF_FFDEFTEXT,
    RTF_FFENTRYMCR,
    RTF_FFEXITMCR,
    RTF_FFFORMAT,
    RTF_FFHASLISTBOX,
    RTF_FFHELPTEXT,
    RTF_FFHPS,
    RTF_FFL,
    RTF_FFMAXLEN,
    RTF_FFNAME,
    RTF_FFOWNHELP,
    RTF_FFOWNSTAT,
    RTF_FFPROT,
    RTF_FFRECALC,
    RTF_FFRES,
    RTF_FFSIZE,
    RTF_FFSTATTEXT,
    RTF_FFTYPE,
    RTF_FFTYPETXT,
    RTF_FHIMAJOR,
    RTF_FHIMINOR,
    RTF_FI,
    RTF_FID,
    RTF_FIELD,
    RTF_FILE,
    RTF_FILETBL,
    RTF_FITTEXT,
    RTF_FJGOTHIC,
    RTF_FJMINCHOU,
    RTF_FLDALT,
    RTF_FLDDIRTY,
    RTF_FLDEDIT,
    RTF_FLDINST,
    RTF_FLDLOCK,
    RTF_FLDPRIV,
    RTF_FLDRSLT,
    RTF_FLDTYPE,
    RTF_FLOMAJOR,
    RTF_FLOMINOR,
    RTF_FMODERN,
    RTF_FN,
    RTF_FNAME,
    RTF_FNETWORK,
    RTF_FNIL,
    RTF_FNONFILESYS,
    RTF_FONTEMB,
    RTF_FONTFILE,
    RTF_FONTTBL,
    RTF_FOOTER,
    RTF_FOOTERF,
    RTF_FOOTERL,
    RTF_FOOTERR,
    RTF_FOOTERY,
    RTF_FOOTNOTE,
    RTF_FORCEUPGRADE,
    RTF_FORMDISP,
    RTF_FORMFIELD,
    RTF_FORMPROT,
    RTF_FORMSHADE,
    RTF_FOSNUM,
    RTF_FPRQ,
    RTF_FRACWIDTH,
    RTF_FRELATIVE,
    RTF_FRMTXBTLR,
    RTF_FRMTXLRTB,
    RTF_FRMTXLRTBV,
    RTF_FRMTXTBRL,
    RTF_FRMTXTBRLV,
    RTF_FROMAN,
    RTF_FROMHTML,
    RTF_FROMTEXT,
    RTF_FS,
    RTF_FSCRIPT,
    RTF_FSWISS,
    RTF_FTECH,
    RTF_FTNALT,
    RTF_FTNBJ,
    RTF_FTNCN,
    RTF_FTNIL,
    RTF_FTNLYTWNINE,
    RTF_FTNNALC,
    RTF_FTNNAR,
    RTF_FTNNAUC,
    RTF_FTNNCHI,
    RTF_FTNNCHOSUNG,
    RTF_FTNNCNUM,
    RTF_FTNNDBAR,
    RTF_FTNNDBNUM,
    RTF_FTNNDBNUMD,
    RTF_FTNNDBNUMK,
    RTF_FTNNDBNUMT,
    RTF_FTNNGANADA,
    RTF_FTNNGBNUM,
    RTF_FTNNGBNUMD,
    RTF_FTNNGBNUMK,
    RTF_FTNNGBNUML,
    RTF_FTNNRLC,
    RTF_FTNNRUC,
    RTF_FTNNZODIAC,
    RTF_FTNNZODIACD,
    RTF_FTNNZODIACL,
    RTF_FTNRESTART,
    RTF_FTNRSTCONT,
    RTF_FTNRSTPG,
    RTF_FTNSEP,
    RTF_FTNSEPC,
    RTF_FTNSTART,
    RTF_FTNTJ,
    RTF_FTTRUETYPE,
    RTF_FVALIDDOS,
    RTF_FVALIDHPFS,
    RTF_FVALIDMAC,
    RTF_FVALIDNTFS,
    RTF_G,
    RTF_GCW,
    RTF_GENERATOR,
    RTF_GREEN,
    RTF_GRFDOCEVENTS,
    RTF_GRIDTBL,
    RTF_GUTTER,
    RTF_GUTTERPRL,
    RTF_GUTTERSXN,
    RTF_HEADER,
    RTF_HEADERF,
    RTF_HEADERL,
    RTF_HEADERR,
    RTF_HEADERY,
    RTF_HICH,
    RTF_HIGHLIGHT,
    RTF_HL,
    RTF_HLFR,
    RTF_HLINKBASE,
    RTF_HLLOC,
    RTF_HLSRC,
    RTF_HORZDOC,
    RTF_HORZSECT,
    RTF_HORZVERT,
    RTF_HR,
    RTF_HRES,
    RTF_HRULE,
    RTF_HSV,
    RTF_HTMAUTSP,
    RTF_HTMLBASE,
    RTF_HTMLRTF,
    RTF_HTMLTAG,
    RTF_HWELEV,
    RTF_HYPHAUTO,
    RTF_HYPHCAPS,
    RTF_HYPHCONSEC,
    RTF_HYPHHOTZ,
    RTF_HYPHPAR,
    RTF_I,
    RTF_ID,
    RTF_IGNOREMIXEDCONTENT,
    RTF_ILFOMACATCLNUP,
    RTF_ILVL,
    RTF_IMPR,
    RTF_INDMIRROR,
    RTF_INDRLSWELEVEN,
    RTF_INFO,
    RTF_INSRSID,
    RTF_INTBL,
    RTF_IPGP,
    RTF_IROWBAND,
    RTF_IROW,
    RTF_ITAP,
    RTF_IXE,
    RTF_JCOMPRESS,
    RTF_JEXPAND,
    RTF_JIS,
    RTF_JPEGBLIP,
    RTF_JSKSU,
    RTF_KEEP,
    RTF_KEEPN,
    RTF_KERNING,
    RTF_KEYCODE,
    RTF_KEYWORDS,
    RTF_KRNPRSNET,
    RTF_KSULANG,
    RTF_JCLISTTAB,
    RTF_LANDSCAPE,
    RTF_LANG,
    RTF_LANGFE,
    RTF_LANGFENP,
    RTF_LANGNP,
    RTF_LASTROW,
    RTF_LATENTSTYLES,
    RTF_LBR,
    RTF_LCHARS,
    RTF_LDBLQUOTE,
    RTF_LEVEL,
    RTF_LEVELFOLLOW,
    RTF_LEVELINDENT,
    RTF_LEVELJC,
    RTF_LEVELJCN,
    RTF_LEVELLEGAL,
    RTF_LEVELNFC,
    RTF_LEVELNFCN,
    RTF_LEVELNORESTART,
    RTF_LEVELNUMBERS,
    RTF_LEVELOLD,
    RTF_LEVELPICTURE,
    RTF_LEVELPICTURENOSIZE,
    RTF_LEVELPREV,
    RTF_LEVELPREVSPACE,
    RTF_LEVELSPACE,
    RTF_LEVELSTARTAT,
    RTF_LEVELTEMPLATEID,
    RTF_LEVELTEXT,
    RTF_LFOLEVEL,
    RTF_LI,
    RTF_LINE,
    RTF_LINEBETCOL,
    RTF_LINECONT,
    RTF_LINEMOD,
    RTF_LINEPPAGE,
    RTF_LINERESTART,
    RTF_LINESTART,
    RTF_LINESTARTS,
    RTF_LINEX,
    RTF_LINKSELF,
    RTF_LINKSTYLES,
    RTF_LINKVAL,
    RTF_LIN,
    RTF_LISA,
    RTF_LISB,
    RTF_LIST,
    RTF_LISTHYBRID,
    RTF_LISTID,
    RTF_LISTLEVEL,
    RTF_LISTNAME,
    RTF_LISTOVERRIDE,
    RTF_LISTOVERRIDECOUNT,
    RTF_LISTOVERRIDEFORMAT,
    RTF_LISTOVERRIDESTARTAT,
    RTF_LISTOVERRIDETABLE,
    RTF_LISTPICTURE,
    RTF_LISTRESTARTHDN,
    RTF_LISTSIMPLE,
    RTF_LISTSTYLEID,
    RTF_LISTSTYLENAME,
    RTF_LISTTABLE,
    RTF_LISTTEMPLATEID,
    RTF_LISTTEXT,
    RTF_LNBRKRULE,
    RTF_LNDSCPSXN,
    RTF_LNONGRID,
    RTF_LOCH,
    RTF_LQUOTE,
    RTF_LS,
    RTF_LSDLOCKED,
    RTF_LSDLOCKEDDEF,
    RTF_LSDLOCKEDEXCEPT,
    RTF_LSDPRIORITY,
    RTF_LSDPRIORITYDEF,
    RTF_LSDQFORMAT,
    RTF_LSDQFORMATDEF,
    RTF_LSDSEMIHIDDEN,
    RTF_LSDSEMIHIDDENDEF,
    RTF_LSDSTIMAX,
    RTF_LSDUNHIDEUSED,
    RTF_LSDUNHIDEUSEDDEF,
    RTF_LTRCH,
    RTF_LTRDOC,
    RTF_LTRMARK,
    RTF_LTRPAR,
    RTF_LTRROW,
    RTF_LTRSECT,
    RTF_LVLTENTATIVE,
    RTF_LYTCALCTBLWD,
    RTF_LYTEXCTTP,
    RTF_LYTPRTMET,
    RTF_LYTTBLRTGR,
    RTF_MAC,
    RTF_MACC,
    RTF_MACCPR,
    RTF_MACPICT,
    RTF_MAILMERGE,
    RTF_MAKEBACKUP,
    RTF_MALN,
    RTF_MALNSCR,
    RTF_MANAGER,
    RTF_MARGB,
    RTF_MARGBSXN,
    RTF_MARGL,
    RTF_MARGLSXN,
    RTF_MARGMIRROR,
    RTF_MARGMIRSXN,
    RTF_MARGPR,
    RTF_MARGR,
    RTF_MARGRSXN,
    RTF_MARGSZ,
    RTF_MARGT,
    RTF_MARGTSXN,
    RTF_MBAR,
    RTF_MBARPR,
    RTF_MBASEJC,
    RTF_MBEGCHR,
    RTF_MBORDERBOX,
    RTF_MBORDERBOXPR,
    RTF_MBOX,
    RTF_MBOXPR,
    RTF_MBRK,
    RTF_MBRKBIN,
    RTF_MBRKBINSUB,
    RTF_MCGP,
    RTF_MCGPRULE,
    RTF_MCHR,
    RTF_MCOUNT,
    RTF_MCSP,
    RTF_MCTRLPR,
    RTF_MD,
    RTF_MDEFJC,
    RTF_MDEG,
    RTF_MDEGHIDE,
    RTF_MDEN,
    RTF_MDIFF,
    RTF_MDIFFSTY,
    RTF_MDISPDEF,
    RTF_MDPR,
    RTF_ME,
    RTF_MENDCHR,
    RTF_MEQARR,
    RTF_MEQARRPR,
    RTF_MF,
    RTF_MFNAME,
    RTF_MFPR,
    RTF_MFUNC,
    RTF_MFUNCPR,
    RTF_MGROUPCHR,
    RTF_MGROUPCHRPR,
    RTF_MGROW,
    RTF_MHIDEBOT,
    RTF_MHIDELEFT,
    RTF_MHIDERIGHT,
    RTF_MHIDETOP,
    RTF_MHTMLTAG,
    RTF_MIN,
    RTF_MINTERSP,
    RTF_MINTLIM,
    RTF_MINTRASP,
    RTF_MJC,
    RTF_MLIM,
    RTF_MLIMLOC,
    RTF_MLIMLOW,
    RTF_MLIMLOWPR,
    RTF_MLIMUPP,
    RTF_MLIMUPPPR,
    RTF_MLIT,
    RTF_MLMARGIN,
    RTF_MM,
    RTF_MMADDFIELDNAME,
    RTF_MMATH,
    RTF_MMATHFONT,
    RTF_MMATHPICT,
    RTF_MMATHPR,
    RTF_MMATTACH,
    RTF_MMAXDIST,
    RTF_MMBLANKLINES,
    RTF_MMC,
    RTF_MMCJC,
    RTF_MMCONNECTSTR,
    RTF_MMCONNECTSTRDATA,
    RTF_MMCPR,
    RTF_MMCS,
    RTF_MMDATASOURCE,
    RTF_MMDATATYPEACCESS,
    RTF_MMDATATYPEEXCEL,
    RTF_MMDATATYPEFILE,
    RTF_MMDATATYPEODBC,
    RTF_MMDATATYPEODSO,
    RTF_MMDATATYPEQT,
    RTF_MMDEFAULTSQL,
    RTF_MMDESTEMAIL,
    RTF_MMDESTFAX,
    RTF_MMDESTNEWDOC,
    RTF_MMDESTPRINTER,
    RTF_MMERRORS,
    RTF_MMFTTYPEADDRESS,
    RTF_MMFTTYPEBARCODE,
    RTF_MMFTTYPEDBCOLUMN,
    RTF_MMFTTYPEMAPPED,
    RTF_MMFTTYPENULL,
    RTF_MMFTTYPESALUTATION,
    RTF_MMHEADERSOURCE,
    RTF_MMJDSOTYPE,
    RTF_MMLINKTOQUERY,
    RTF_MMMAILSUBJECT,
    RTF_MMMAINTYPECATALOG,
    RTF_MMMAINTYPEEMAIL,
    RTF_MMMAINTYPEENVELOPES,
    RTF_MMMAINTYPEFAX,
    RTF_MMMAINTYPELABELS,
    RTF_MMMAINTYPELETTERS,
    RTF_MMODSO,
    RTF_MMODSOACTIVE,
    RTF_MMODSOCOLDELIM,
    RTF_MMODSOCOLUMN,
    RTF_MMODSODYNADDR,
    RTF_MMODSOFHDR,
    RTF_MMODSOFILTER,
    RTF_MMODSOFLDMPDATA,
    RTF_MMODSOFMCOLUMN,
    RTF_MMODSOHASH,
    RTF_MMODSOLID,
    RTF_MMODSOMAPPEDNAME,
    RTF_MMODSONAME,
    RTF_MMODSORECIPDATA,
    RTF_MMODSOSORT,
    RTF_MMODSOSRC,
    RTF_MMODSOTABLE,
    RTF_MMODSOUDL,
    RTF_MMODSOUDLDATA,
    RTF_MMODSOUNIQUETAG,
    RTF_MMPR,
    RTF_MMQUERY,
    RTF_MMR,
    RTF_MMRECCUR,
    RTF_MMSHOWDATA,
    RTF_MNARY,
    RTF_MNARYLIM,
    RTF_MNARYPR,
    RTF_MNOBREAK,
    RTF_MNOR,
    RTF_MNUM,
    RTF_MO,
    RTF_MOBJDIST,
    RTF_MOMATH,
    RTF_MOMATHPARA,
    RTF_MOMATHPARAPR,
    RTF_MOPEMU,
    RTF_MPHANT,
    RTF_MPHANTPR,
    RTF_MPLCHIDE,
    RTF_MPOS,
    RTF_MPOSTSP,
    RTF_MPRESP,
    RTF_MR,
    RTF_MRAD,
    RTF_MRADPR,
    RTF_MRMARGIN,
    RTF_MRPR,
    RTF_MRSP,
    RTF_MRSPRULE,
    RTF_MSCR,
    RTF_MSEPCHR,
    RTF_MSHOW,
    RTF_MSHP,
    RTF_MSMALLFRAC,
    RTF_MSMCAP,
    RTF_MSPRE,
    RTF_MSPREPR,
    RTF_MSSUB,
    RTF_MSSUBPR,
    RTF_MSSUBSUP,
    RTF_MSSUBSUPPR,
    RTF_MSSUP,
    RTF_MSSUPPR,
    RTF_MSTRIKEBLTR,
    RTF_MSTRIKEH,
    RTF_MSTRIKETLBR,
    RTF_MSTRIKEV,
    RTF_MSTY,
    RTF_MSUB,
    RTF_MSUBHIDE,
    RTF_MSUP,
    RTF_MSUPHIDE,
    RTF_MTRANSP,
    RTF_MTYPE,
    RTF_MUSER,
    RTF_MVAUTH,
    RTF_MVDATE,
    RTF_MVERTJC,
    RTF_MVF,
    RTF_MVFMF,
    RTF_MVFML,
    RTF_MVT,
    RTF_MVTOF,
    RTF_MVTOL,
    RTF_MWRAPINDENT,
    RTF_MWRAPRIGHT,
    RTF_MZEROASC,
    RTF_MZERODESC,
    RTF_MZEROWID,
    RTF_NESTCELL,
    RTF_NESTROW,
    RTF_NESTTABLEPROPS,
    RTF_NEWTBLSTYRULS,
    RTF_NEXTFILE,
    RTF_NOAFCNSTTBL,
    RTF_NOBRKWRPTBL,
    RTF_NOCOLBAL,
    RTF_NOCOMPATOPTIONS,
    RTF_NOCWRAP,
    RTF_NOCXSPTABLE,
    RTF_NOEXTRASPRL,
    RTF_NOFCHARS,
    RTF_NOFCHARSWS,
    RTF_NOFEATURETHROTTLE,
    RTF_NOFPAGES,
    RTF_NOFWORDS,
    RTF_NOGROWAUTOFIT,
    RTF_NOINDNMBRTS,
    RTF_NOJKERNPUNCT,
    RTF_NOLEAD,
    RTF_NOLINE,
    RTF_NOLNHTADJTBL,
    RTF_NONESTTABLES,
    RTF_NONSHPPICT,
    RTF_NOOVERFLOW,
    RTF_NOPROOF,
    RTF_NOQFPROMOTE,
    RTF_NOSECTEXPAND,
    RTF_NOSNAPLINEGRID,
    RTF_NOSPACEFORUL,
    RTF_NOSUPERSUB,
    RTF_NOTABIND,
    RTF_NOTBRKCNSTFRCTBL,
    RTF_NOTCVASP,
    RTF_NOTVATXBX,
    RTF_NOUICOMPAT,
    RTF_NOULTRLSPC,
    RTF_NOWIDCTLPAR,
    RTF_NOWRAP,
    RTF_NOWWRAP,
    RTF_NOXLATTOYEN,
    RTF_OBJALIAS,
    RTF_OBJALIGN,
    RTF_OBJATTPH,
    RTF_OBJAUTLINK,
    RTF_OBJCLASS,
    RTF_OBJCROPB,
    RTF_OBJCROPL,
    RTF_OBJCROPR,
    RTF_OBJCROPT,
    RTF_OBJDATA,
    RTF_OBJECT,
    RTF_OBJEMB,
    RTF_OBJH,
    RTF_OBJHTML,
    RTF_OBJICEMB,
    RTF_OBJLINK,
    RTF_OBJLOCK,
    RTF_OBJNAME,
    RTF_OBJOCX,
    RTF_OBJPUB,
    RTF_OBJSCALEX,
    RTF_OBJSCALEY,
    RTF_OBJSECT,
    RTF_OBJSETSIZE,
    RTF_OBJSUB,
    RTF_OBJTIME,
    RTF_OBJTRANSY,
    RTF_OBJUPDATE,
    RTF_OBJW,
    RTF_OGUTTER,
    RTF_OLDAS,
    RTF_OLDCPROPS,
    RTF_OLDLINEWRAP,
    RTF_OLDPPROPS,
    RTF_OLDSPROPS,
    RTF_OLDTPROPS,
    RTF_OLECLSID,
    RTF_OPERATOR,
    RTF_OTBLRUL,
    RTF_OUTL,
    RTF_OUTLINELEVEL,
    RTF_OVERLAY,
    RTF_PAGE,
    RTF_PAGEBB,
    RTF_PANOSE,
    RTF_PAPERH,
    RTF_PAPERW,
    RTF_PAR,
    RTF_PARARSID,
    RTF_PARD,
    RTF_PASSWORD,
    RTF_PASSWORDHASH,
    RTF_PC,
    RTF_PCA,
    RTF_PGBRDRB,
    RTF_PGBRDRFOOT,
    RTF_PGBRDRHEAD,
    RTF_PGBRDRL,
    RTF_PGBRDROPT,
    RTF_PGBRDRR,
    RTF_PGBRDRSNAP,
    RTF_PGBRDRT,
    RTF_PGHSXN,
    RTF_PGNBIDIA,
    RTF_PGNBIDIB,
    RTF_PGNCHOSUNG,
    RTF_PGNCNUM,
    RTF_PGNCONT,
    RTF_PGNDBNUM,
    RTF_PGNDBNUMD,
    RTF_PGNDBNUMK,
    RTF_PGNDBNUMT,
    RTF_PGNDEC,
    RTF_PGNDECD,
    RTF_PGNGANADA,
    RTF_PGNGBNUM,
    RTF_PGNGBNUMD,
    RTF_PGNGBNUMK,
    RTF_PGNGBNUML,
    RTF_PGNHINDIA,
    RTF_PGNHINDIB,
    RTF_PGNHINDIC,
    RTF_PGNHINDID,
    RTF_PGNHN,
    RTF_PGNHNSC,
    RTF_PGNHNSH,
    RTF_PGNHNSM,
    RTF_PGNHNSN,
    RTF_PGNHNSP,
    RTF_PGNID,
    RTF_PGNLCLTR,
    RTF_PGNLCRM,
    RTF_PGNRESTART,
    RTF_PGNSTART,
    RTF_PGNSTARTS,
    RTF_PGNTHAIA,
    RTF_PGNTHAIB,
    RTF_PGNTHAIC,
    RTF_PGNUCLTR,
    RTF_PGNUCRM,
    RTF_PGNVIETA,
    RTF_PGNX,
    RTF_PGNY,
    RTF_PGNZODIAC,
    RTF_PGNZODIACD,
    RTF_PGNZODIACL,
    RTF_PGP,
    RTF_PGPTBL,
    RTF_PGWSXN,
    RTF_PHCOL,
    RTF_PHMRG,
    RTF_PHPG,
    RTF_PICBMP,
    RTF_PICBPP,
    RTF_PICCROPB,
    RTF_PICCROPL,
    RTF_PICCROPR,
    RTF_PICCROPT,
    RTF_PICH,
    RTF_PICHGOAL,
    RTF_PICPROP,
    RTF_PICSCALED,
    RTF_PICSCALEX,
    RTF_PICSCALEY,
    RTF_PICT,
    RTF_PICW,
    RTF_PICWGOAL,
    RTF_PINDTABQC,
    RTF_PINDTABQL,
    RTF_PINDTABQR,
    RTF_PLAIN,
    RTF_PMARTABQC,
    RTF_PMARTABQL,
    RTF_PMARTABQR,
    RTF_PMMETAFILE,
    RTF_PN,
    RTF_PNACROSS,
    RTF_PNAIU,
    RTF_PNAIUD,
    RTF_PNAIUEO,
    RTF_PNAIUEOD,
    RTF_PNB,
    RTF_PNBIDIA,
    RTF_PNBIDIB,
    RTF_PNCAPS,
    RTF_PNCARD,
    RTF_PNCF,
    RTF_PNCHOSUNG,
    RTF_PNCNUM,
    RTF_PNDBNUM,
    RTF_PNDBNUMD,
    RTF_PNDBNUMK,
    RTF_PNDBNUML,
    RTF_PNDBNUMT,
    RTF_PNDEC,
    RTF_PNDECD,
    RTF_PNF,
    RTF_PNFS,
    RTF_PNGANADA,
    RTF_PNGBLIP,
    RTF_PNGBNUM,
    RTF_PNGBNUMD,
    RTF_PNGBNUMK,
    RTF_PNGBNUML,
    RTF_PNHANG,
    RTF_PNI,
    RTF_PNINDENT,
    RTF_PNIROHA,
    RTF_PNIROHAD,
    RTF_PNLCLTR,
    RTF_PNLCRM,
    RTF_PNLVL,
    RTF_PNLVLBLT,
    RTF_PNLVLBODY,
    RTF_PNLVLCONT,
    RTF_PNNUMONCE,
    RTF_PNORD,
    RTF_PNORDT,
    RTF_PNPREV,
    RTF_PNQC,
    RTF_PNQL,
    RTF_PNQR,
    RTF_PNRAUTH,
    RTF_PNRDATE,
    RTF_PNRESTART,
    RTF_PNRNFC,
    RTF_PNRNOT,
    RTF_PNRPNBR,
    RTF_PNRRGB,
    RTF_PNRSTART,
    RTF_PNRSTOP,
    RTF_PNRXST,
    RTF_PNSCAPS,
    RTF_PNSECLVL,
    RTF_PNSP,
    RTF_PNSTART,
    RTF_PNSTRIKE,
    RTF_PNTEXT,
    RTF_PNTXTA,
    RTF_PNTXTB,
    RTF_PNUCLTR,
    RTF_PNUCRM,
    RTF_PNUL,
    RTF_PNULD,
    RTF_PNULDASH,
    RTF_PNULDASHD,
    RTF_PNULDASHDD,
    RTF_PNULDB,
    RTF_PNULHAIR,
    RTF_PNULNONE,
    RTF_PNULTH,
    RTF_PNULW,
    RTF_PNULWAVE,
    RTF_PNZODIAC,
    RTF_PNZODIACD,
    RTF_PNZODIACL,
    RTF_POSNEGX,
    RTF_POSNEGY,
    RTF_POSX,
    RTF_POSXC,
    RTF_POSXI,
    RTF_POSXL,
    RTF_POSXO,
    RTF_POSXR,
    RTF_POSY,
    RTF_POSYB,
    RTF_POSYC,
    RTF_POSYIL,
    RTF_POSYIN,
    RTF_POSYOUT,
    RTF_POSYT,
    RTF_PRAUTH,
    RTF_PRCOLBL,
    RTF_PRDATE,
    RTF_PRINTDATA,
    RTF_PRINTIM,
    RTF_PRIVATE,
    RTF_PROPNAME,
    RTF_PROPTYPE,
    RTF_PROTECT,
    RTF_PROTEND,
    RTF_PROTLEVEL,
    RTF_PROTSTART,
    RTF_PROTUSERTBL,
    RTF_PSOVER,
    RTF_PSZ,
    RTF_PTABLDOT,
    RTF_PTABLMDOT,
    RTF_PTABLMINUS,
    RTF_PTABLNONE,
    RTF_PTABLUSCORE,
    RTF_PUBAUTO,
    RTF_PVMRG,
    RTF_PVPARA,
    RTF_PVPG,
    RTF_PWD,
    RTF_PXE,
    RTF_QC,
    RTF_QD,
    RTF_QJ,
    RTF_QK,
    RTF_QL,
    RTF_QMSPACE,
    RTF_QR,
    RTF_QT,
    RTF_RAWCLBGDKBDIAG,
    RTF_RAWCLBGBDIAG,
    RTF_RAWCLBGCROSS,
    RTF_RAWCLBGDCROSS,
    RTF_RAWCLBGDKCROSS,
    RTF_RAWCLBGDKDCROSS,
    RTF_RAWCLBGDKFDIAG,
    RTF_RAWCLBGDKHOR,
    RTF_RAWCLBGDKVERT,
    RTF_RAWCLBGFDIAG,
    RTF_RAWCLBGHORIZ,
    RTF_RAWCLBGVERT,
    RTF_RDBLQUOTE,
    RTF_READONLYRECOMMENDED,
    RTF_READPROT,
    RTF_RED,
    RTF_RELYONVML,
    RTF_REMDTTM,
    RTF_REMPERSONALINFO,
    RTF_RESULT,
    RTF_REVAUTH,
    RTF_REVAUTHDEL,
    RTF_REVBAR,
    RTF_REVDTTM,
    RTF_REVDTTMDEL,
    RTF_REVISED,
    RTF_REVISIONS,
    RTF_REVPROP,
    RTF_REVPROT,
    RTF_REVTBL,
    RTF_REVTIM,
    RTF_RI,
    RTF_RIN,
    RTF_ROW,
    RTF_RQUOTE,
    RTF_RSID,
    RTF_RSIDROOT,
    RTF_RSIDTBL,
    RTF_RSLTBMP,
    RTF_RSLTHTML,
    RTF_RSLTMERGE,
    RTF_RSLTPICT,
    RTF_RSLTRTF,
    RTF_RSLTTXT,
    RTF_RTF,
    RTF_RTLCH,
    RTF_RTLDOC,
    RTF_RTLGUTTER,
    RTF_RTLMARK,
    RTF_RTLPAR,
    RTF_RTLROW,
    RTF_RTLSECT,
    RTF_RXE,
    RTF_S,
    RTF_SA,
    RTF_SAAUTO,
    RTF_SAFTNNALC,
    RTF_SAFTNNAR,
    RTF_SAFTNNAUC,
    RTF_SAFTNNCHI,
    RTF_SAFTNNCHOSUNG,
    RTF_SAFTNNCNUM,
    RTF_SAFTNNDBAR,
    RTF_SAFTNNDBNUM,
    RTF_SAFTNNDBNUMD,
    RTF_SAFTNNDBNUMK,
    RTF_SAFTNNDBNUMT,
    RTF_SAFTNNGANADA,
    RTF_SAFTNNGBNUM,
    RTF_SAFTNNGBNUMD,
    RTF_SAFTNNGBNUMK,
    RTF_SAFTNNGBNUML,
    RTF_SAFTNNRLC,
    RTF_SAFTNNRUC,
    RTF_SAFTNNZODIAC,
    RTF_SAFTNNZODIACD,
    RTF_SAFTNNZODIACL,
    RTF_SAFTNRESTART,
    RTF_SAFTNRSTCONT,
    RTF_SAFTNSTART,
    RTF_SAUTOUPD,
    RTF_SAVEINVALIDXML,
    RTF_SAVEPREVPICT,
    RTF_SB,
    RTF_SBASEDON,
    RTF_SBAUTO,
    RTF_SBKCOL,
    RTF_SBKEVEN,
    RTF_SBKNONE,
    RTF_SBKODD,
    RTF_SBKPAGE,
    RTF_SBYS,
    RTF_SCAPS,
    RTF_SCOMPOSE,
    RTF_SEC,
    RTF_SECT,
    RTF_SECTD,
    RTF_SECTDEFAULTCL,
    RTF_SECTEXPAND,
    RTF_SECTLINEGRID,
    RTF_SECTNUM,
    RTF_SECTRSID,
    RTF_SECTSPECIFYCL,
    RTF_SECTSPECIFYGENN,
    RTF_SECTSPECIFYL,
    RTF_SECTUNLOCKED,
    RTF_SFTNBJ,
    RTF_SFTNNALC,
    RTF_SFTNNAR,
    RTF_SFTNNAUC,
    RTF_SFTNNCHI,
    RTF_SFTNNCHOSUNG,
    RTF_SFTNNCNUM,
    RTF_SFTNNDBAR,
    RTF_SFTNNDBNUM,
    RTF_SFTNNDBNUMD,
    RTF_SFTNNDBNUMK,
    RTF_SFTNNDBNUMT,
    RTF_SFTNNGANADA,
    RTF_SFTNNGBNUM,
    RTF_SFTNNGBNUMD,
    RTF_SFTNNGBNUMK,
    RTF_SFTNNGBNUML,
    RTF_SFTNNRLC,
    RTF_SFTNNRUC,
    RTF_SFTNNZODIAC,
    RTF_SFTNNZODIACD,
    RTF_SFTNNZODIACL,
    RTF_SFTNRESTART,
    RTF_SFTNRSTCONT,
    RTF_SFTNRSTPG,
    RTF_SFTNSTART,
    RTF_SFTNTJ,
    RTF_SHAD,
    RTF_SHADING,
    RTF_SHIDDEN,
    RTF_SHIFT,
    RTF_SHOWPLACEHOLDTEXT,
    RTF_SHOWXMLERRORS,
    RTF_SHP,
    RTF_SHPBOTTOM,
    RTF_SHPBXCOLUMN,
    RTF_SHPBXIGNORE,
    RTF_SHPBXMARGIN,
    RTF_SHPBXPAGE,
    RTF_SHPBYIGNORE,
    RTF_SHPBYMARGIN,
    RTF_SHPBYPAGE,
    RTF_SHPBYPARA,
    RTF_SHPFBLWTXT,
    RTF_SHPFHDR,
    RTF_SHPGRP,
    RTF_SHPINST,
    RTF_SHPLEFT,
    RTF_SHPLID,
    RTF_SHPLOCKANCHOR,
    RTF_SHPPICT,
    RTF_SHPRIGHT,
    RTF_SHPRSLT,
    RTF_SHPTOP,
    RTF_SHPTXT,
    RTF_SHPWRK,
    RTF_SHPWR,
    RTF_SHPZ,
    RTF_SL,
    RTF_SLINK,
    RTF_SLMULT,
    RTF_SLOCKED,
    RTF_SN,
    RTF_SNAPTOGRIDINCELL,
    RTF_SNEXT,
    RTF_SOFTCOL,
    RTF_SOFTLHEIGHT,
    RTF_SOFTLINE,
    RTF_SOFTPAGE,
    RTF_SP,
    RTF_SPERSONAL,
    RTF_SPLTPGPAR,
    RTF_SPLYTWNINE,
    RTF_SPRIORITY,
    RTF_SPRSBSP,
    RTF_SPRSLNSP,
    RTF_SPRSSPBF,
    RTF_SPRSTSM,
    RTF_SPRSTSP,
    RTF_SPV,
    RTF_SQFORMAT,
    RTF_SRAUTH,
    RTF_SRDATE,
    RTF_SREPLY,
    RTF_SSEMIHIDDEN,
    RTF_STATICVAL,
    RTF_STEXTFLOW,
    RTF_STRIKE,
    RTF_STRIKED,
    RTF_STSHFBI,
    RTF_STSHFDBCH,
    RTF_STSHFHICH,
    RTF_STSHFLOCH,
    RTF_STYLELOCK,
    RTF_STYLELOCKBACKCOMP,
    RTF_STYLELOCKENFORCED,
    RTF_STYLELOCKQFSET,
    RTF_STYLELOCKTHEME,
    RTF_STYLESHEET,
    RTF_STYLESORTMETHOD,
    RTF_STYRSID,
    RTF_SUB,
    RTF_SUBDOCUMENT,
    RTF_SUBFONTBYSIZE,
    RTF_SUBJECT,
    RTF_SUNHIDEUSED,
    RTF_SUPER,
    RTF_SV,
    RTF_SVB,
    RTF_SWPBDR,
    RTF_TAB,
    RTF_TABSNOOVRLP,
    RTF_TAPRTL,
    RTF_TB,
    RTF_TBLIND,
    RTF_TBLINDTYPE,
    RTF_TBLLKBESTFIT,
    RTF_TBLLKBORDER,
    RTF_TBLLKCOLOR,
    RTF_TBLLKFONT,
    RTF_TBLLKHDRCOLS,
    RTF_TBLLKHDRROWS,
    RTF_TBLLKLASTCOL,
    RTF_TBLLKLASTROW,
    RTF_TBLLKNOCOLBAND,
    RTF_TBLLKNOROWBAND,
    RTF_TBLLKSHADING,
    RTF_TBLRSID,
    RTF_TC,
    RTF_TCELLD,
    RTF_TCF,
    RTF_TCL,
    RTF_TCN,
    RTF_TDFRMTXTBOTTOM,
    RTF_TDFRMTXTLEFT,
    RTF_TDFRMTXTRIGHT,
    RTF_TDFRMTXTTOP,
    RTF_TEMPLATE,
    RTF_THEMEDATA,
    RTF_THEMELANG,
    RTF_THEMELANGCS,
    RTF_THEMELANGFE,
    RTF_TIME,
    RTF_TITLE,
    RTF_TITLEPG,
    RTF_TLDOT,
    RTF_TLEQ,
    RTF_TLHYPH,
    RTF_TLMDOT,
    RTF_TLTH,
    RTF_TLUL,
    RTF_TOPLINEPUNCT,
    RTF_TPHCOL,
    RTF_TPHMRG,
    RTF_TPHPG,
    RTF_TPOSNEGX,
    RTF_TPOSNEGY,
    RTF_TPOSXC,
    RTF_TPOSXI,
    RTF_TPOSXL,
    RTF_TPOSX,
    RTF_TPOSXO,
    RTF_TPOSXR,
    RTF_TPOSY,
    RTF_TPOSYB,
    RTF_TPOSYC,
    RTF_TPOSYIL,
    RTF_TPOSYIN,
    RTF_TPOSYOUT,
    RTF_TPOSYT,
    RTF_TPVMRG,
    RTF_TPVPARA,
    RTF_TPVPG,
    RTF_TQC,
    RTF_TQDEC,
    RTF_TQR,
    RTF_TRACKFORMATTING,
    RTF_TRACKMOVES,
    RTF_TRANSMF,
    RTF_TRAUTH,
    RTF_TRAUTOFIT,
    RTF_TRBGBDIAG,
    RTF_TRBGCROSS,
    RTF_TRBGDCROSS,
    RTF_TRBGDKBDIAG,
    RTF_TRBGDKCROSS,
    RTF_TRBGDKDCROSS,
    RTF_TRBGDKFDIAG,
    RTF_TRBGDKHOR,
    RTF_TRBGDKVERT,
    RTF_TRBGFDIAG,
    RTF_TRBGHORIZ,
    RTF_TRBGVERT,
    RTF_TRBRDRB,
    RTF_TRBRDRH,
    RTF_TRBRDRL,
    RTF_TRBRDRR,
    RTF_TRBRDRT,
    RTF_TRBRDRV,
    RTF_TRCBPAT,
    RTF_TRCFPAT,
    RTF_TRDATE,
    RTF_TRFTSWIDTHA,
    RTF_TRFTSWIDTHB,
    RTF_TRFTSWIDTH,
    RTF_TRGAPH,
    RTF_TRHDR,
    RTF_TRKEEP,
    RTF_TRKEEPFOLLOW,
    RTF_TRLEFT,
    RTF_TROWD,
    RTF_TRPADDB,
    RTF_TRPADDFB,
    RTF_TRPADDFL,
    RTF_TRPADDFR,
    RTF_TRPADDFT,
    RTF_TRPADDL,
    RTF_TRPADDR,
    RTF_TRPADDT,
    RTF_TRPADOB,
    RTF_TRPADOFB,
    RTF_TRPADOFL,
    RTF_TRPADOFR,
    RTF_TRPADOFT,
    RTF_TRPADOL,
    RTF_TRPADOR,
    RTF_TRPADOT,
    RTF_TRPAT,
    RTF_TRQC,
    RTF_TRQL,
    RTF_TRQR,
    RTF_TRRH,
    RTF_TRSHDNG,
    RTF_TRSPDB,
    RTF_TRSPDFB,
    RTF_TRSPDFL,
    RTF_TRSPDFR,
    RTF_TRSPDFT,
    RTF_TRSPDL,
    RTF_TRSPDR,
    RTF_TRSPDT,
    RTF_TRSPOB,
    RTF_TRSPOFB,
    RTF_TRSPOFL,
    RTF_TRSPOFR,
    RTF_TRSPOFT,
    RTF_TRSPOL,
    RTF_TRSPOR,
    RTF_TRSPOT,
    RTF_TRUNCATEFONTHEIGHT,
    RTF_TRUNCEX,
    RTF_TRWWIDTHA,
    RTF_TRWWIDTHB,
    RTF_TRWWIDTH,
    RTF_TS,
    RTF_TSBGBDIAG,
    RTF_TSBGCROSS,
    RTF_TSBGDCROSS,
    RTF_TSBGDKBDIAG,
    RTF_TSBGDKCROSS,
    RTF_TSBGDKDCROSS,
    RTF_TSBGDKFDIAG,
    RTF_TSBGDKHOR,
    RTF_TSBGDKVERT,
    RTF_TSBGFDIAG,
    RTF_TSBGHORIZ,
    RTF_TSBGVERT,
    RTF_TSBRDRB,
    RTF_TSBRDRDGL,
    RTF_TSBRDRDGR,
    RTF_TSBRDRH,
    RTF_TSBRDRL,
    RTF_TSBRDRR,
    RTF_TSBRDRT,
    RTF_TSBRDRV,
    RTF_TSCBANDHORZEVEN,
    RTF_TSCBANDHORZODD,
    RTF_TSCBANDSH,
    RTF_TSCBANDSV,
    RTF_TSCBANDVERTEVEN,
    RTF_TSCBANDVERTODD,
    RTF_TSCELLCBPAT,
    RTF_TSCELLCFPAT,
    RTF_TSCELLPADDB,
    RTF_TSCELLPADDFB,
    RTF_TSCELLPADDFL,
    RTF_TSCELLPADDFR,
    RTF_TSCELLPADDFT,
    RTF_TSCELLPADDL,
    RTF_TSCELLPADDR,
    RTF_TSCELLPADDT,
    RTF_TSCELLPCT,
    RTF_TSCELLWIDTH,
    RTF_TSCELLWIDTHFTS,
    RTF_TSCFIRSTCOL,
    RTF_TSCFIRSTROW,
    RTF_TSCLASTCOL,
    RTF_TSCLASTROW,
    RTF_TSCNECELL,
    RTF_TSCNWCELL,
    RTF_TSCSECELL,
    RTF_TSCSWCELL,
    RTF_TSD,
    RTF_TSNOWRAP,
    RTF_TSROWD,
    RTF_TSVERTALB,
    RTF_TSVERTALC,
    RTF_TSVERTALT,
    RTF_TWOINONE,
    RTF_TWOONONE,
    RTF_TX,
    RTF_TXBXTWALWAYS,
    RTF_TXBXTWFIRST,
    RTF_TXBXTWFIRSTLAST,
    RTF_TXBXTWLAST,
    RTF_TXBXTWNO,
    RTF_TXE,
    RTF_U,
    RTF_UC,
    RTF_UD,
    RTF_UL,
    RTF_ULC,
    RTF_ULD,
    RTF_ULDASH,
    RTF_ULDASHD,
    RTF_ULDASHDD,
    RTF_ULDB,
    RTF_ULHAIR,
    RTF_ULHWAVE,
    RTF_ULLDASH,
    RTF_ULNONE,
    RTF_ULTH,
    RTF_ULTHD,
    RTF_ULTHDASH,
    RTF_ULTHDASHD,
    RTF_ULTHDASHDD,
    RTF_ULTHLDASH,
    RTF_ULULDBWAVE,
    RTF_ULW,
    RTF_ULWAVE,
    RTF_UP,
    RTF_UPR,
    RTF_URTF,
    RTF_USELTBALN,
    RTF_USENORMSTYFORLIST,
    RTF_USERPROPS,
    RTF_USEXFORM,
    RTF_UTINL,
    RTF_V,
    RTF_VALIDATEXML,
    RTF_VERN,
    RTF_VERSION,
    RTF_VERTAL,
    RTF_VERTALB,
    RTF_VERTALC,
    RTF_VERTALJ,
    RTF_VERTALT,
    RTF_VERTDOC,
    RTF_VERTSECT,
    RTF_VIEWBKSP,
    RTF_VIEWKIND,
    RTF_VIEWNOBOUND,
    RTF_VIEWSCALE,
    RTF_VIEWZK,
    RTF_WBITMAP,
    RTF_WBMBITSPIXEL,
    RTF_WBMPLANES,
    RTF_WBMWIDTHBYTE,
    RTF_WEBHIDDEN,
    RTF_WGRFFMTFILTER,
    RTF_WIDCTLPAR,
    RTF_WIDOWCTRL,
    RTF_WINDOWCAPTION,
    RTF_WMETAFILE,
    RTF_WPEQN,
    RTF_WPJST,
    RTF_WPSP,
    RTF_WRAPAROUND,
    RTF_WRAPDEFAULT,
    RTF_WRAPTHROUGH,
    RTF_WRAPTIGHT,
    RTF_WRAPTRSP,
    RTF_WRITERESERVATION,
    RTF_WRITERESERVHASH,
    RTF_WRPPUNCT,
    RTF_XE,
    RTF_XEF,
    RTF_XFORM,
    RTF_XMLATTR,
    RTF_XMLATTRNAME,
    RTF_XMLATTRNS,
    RTF_XMLATTRVALUE,
    RTF_XMLCLOSE,
    RTF_XMLNAME,
    RTF_XMLNS,
    RTF_XMLNSTBL,
    RTF_XMLOPEN,
    RTF_XMLSDTTCELL,
    RTF_XMLSDTTPARA,
    RTF_XMLSDTTREGULAR,
    RTF_XMLSDTTROW,
    RTF_XMLSDTTUNKNOWN,
    RTF_YR,
    RTF_YTS,
    RTF_YXE,
    RTF_ZWBO,
    RTF_ZWJ,
    RTF_ZWNBO,
    RTF_ZWNJ,
    RTF_FLYMAINCNT,
    RTF_FLYVERT,
    RTF_FLYHORZ,
    RTF_FLYANCHOR
};
const char* keywordToString(RTFKeyword nKeyword);

/// Types of an RTF Control Word
enum RTFControlTypes
{
    CONTROL_FLAG, // eg \sbknone takes no parameter
    CONTROL_DESTINATION, // eg \fonttbl, if ignored, the whole group should be skipped
    CONTROL_SYMBOL, // eg \tab
    CONTROL_TOGGLE, // eg \b (between on and off)
    CONTROL_VALUE // eg \fs (requires parameter)
};

/// Represents an RTF Control Word
class RTFSymbol
{
    const char* m_sKeyword;
    int m_nControlType;
    RTFKeyword m_nIndex;

    int m_nDefValue; ///< Most of the control words default to 0.

public:
    RTFSymbol() = default;
    RTFSymbol(const char* sKeyword, int nControlType = 0, RTFKeyword nIndex = RTF_invalid,
              int nDefValue = 0)
        : m_sKeyword(sKeyword)
        , m_nControlType(nControlType)
        , m_nIndex(nIndex)
        , m_nDefValue(nDefValue)
    {
    }

    const char* GetKeyword() const { return m_sKeyword; }

    int GetControlType() const { return m_nControlType; }

    RTFKeyword GetIndex() const { return m_nIndex; }

    int GetDefValue() const { return m_nDefValue; }

    bool operator<(const RTFSymbol& rOther) const;
};

extern RTFSymbol const aRTFControlWords[];
extern int nRTFControlWords;

/// Represents an RTF Math Control Word
class RTFMathSymbol
{
    RTFKeyword m_eKeyword;
    int m_nToken; ///< This is the OOXML token equivalent.
    Destination m_eDestination;

public:
    RTFMathSymbol(RTFKeyword eKeyword, int nToken = 0,
                  Destination eDestination = Destination::NORMAL)
        : m_eKeyword(eKeyword)
        , m_nToken(nToken)
        , m_eDestination(eDestination)
    {
    }

    int GetToken() const { return m_nToken; }

    Destination GetDestination() const { return m_eDestination; }

    bool operator<(const RTFMathSymbol& rOther) const;
};

extern RTFMathSymbol const aRTFMathControlWords[];
extern int nRTFMathControlWords;

} // namespace rtftok
} // namespace writerfilter

#endif // INCLUDED_WRITERFILTER_SOURCE_RTFTOK_RTFCONTROLWORDS_HXX

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
