/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#ifndef INCLUDED_I18NUTIL_SOURCE_UTILITY_UNICODE_DATA_H
#define INCLUDED_I18NUTIL_SOURCE_UTILITY_UNICODE_DATA_H

#include <sal/types.h>


#define UnicodeTypeNumberBlock  5

static const sal_Int8 UnicodeTypeIndex[] = {
    0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, // 0000 - 07ff
    0x00, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13, // 0800 - 0fff
    0x14, 0x15, 0x16, 0x17, 0x18, 0x01, 0x19, 0x1a, // 1000 - 17ff
    0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x1d, // 1800 - 1fff
    0x1e, 0x1f, 0x20, 0x21, 0x22, 0x23, 0x24, 0x25, // 2000 - 27ff
    0x04, 0x00, 0x00, 0x00, 0x26, 0x00, 0x27, 0x28, // 2800 - 2fff  (Coptic inserted)
    0x29, 0x2a, 0x2b, 0x2c, 0x01, 0x01, 0x01, 0x01, // 3000 - 37ff
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, // 3800 - 3fff
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, // 4000 - 47ff
    0x01, 0x01, 0x01, 0x01, 0x01, 0x2d, 0x01, 0x01, // 4800 - 4fff
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, // 5000 - 57ff
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, // 5800 - 5fff
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, // 6000 - 67ff
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, // 6800 - 6fff
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, // 7000 - 77ff
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, // 7800 - 7fff
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, // 8000 - 87ff
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, // 8800 - 8fff
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, // 9000 - 97ff
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x2e, // 9800 - 9fff
    0x01, 0x01, 0x01, 0x01, 0x2f, 0x00, 0x00, 0x00, // a000 - a7ff
    0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, // a800 - afff
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, // b000 - b7ff
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, // b800 - bfff
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, // c000 - c7ff
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, // c800 - cfff
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x30, // d000 - d7ff
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, // d800 - dfff
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, // e000 - e7ff
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, // e800 - efff
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, // f000 - f7ff
    0x02, 0x01, 0x31, 0x32, 0x01, 0x33, 0x34, 0x35, // f800 - ffff
};


static const sal_Int8 UnicodeTypeBlockValue[] = {
     0,  5, 17, 18, 27,
};


static const sal_Int8 UnicodeTypeValue[] = {
    15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,// 0000 - 000f
    15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,// 0010 - 001f
    12,23,23,23,25,23,23,23,20,21,23,24,23,19,23,23,// 0020 - 002f
     9, 9, 9, 9, 9, 9, 9, 9, 9, 9,23,23,24,24,24,23,// 0030 - 003f
    23, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,// 0040 - 004f
     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,20,23,21,26,22,// 0050 - 005f
    26, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,// 0060 - 006f
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,20,24,21,24,15,// 0070 - 007f
    15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,// 0080 - 008f
    15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,// 0090 - 009f
    12,23,25,25,25,25,27,27,26,27, 2,28,24,19,27,26,// 00a0 - 00af
    27,24,11,11,26, 2,27,23,26,11, 2,29,11,11,11,23,// 00b0 - 00bf
     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,// 00c0 - 00cf
     1, 1, 1, 1, 1, 1, 1,24, 1, 1, 1, 1, 1, 1, 1, 2,// 00d0 - 00df
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,// 00e0 - 00ef
     2, 2, 2, 2, 2, 2, 2,24, 2, 2, 2, 2, 2, 2, 2, 2,// 00f0 - 00ff

     1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,// 0100 - 010f
     1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,// 0110 - 011f
     1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,// 0120 - 012f
     1, 2, 1, 2, 1, 2, 1, 2, 2, 1, 2, 1, 2, 1, 2, 1,// 0130 - 013f
     2, 1, 2, 1, 2, 1, 2, 1, 2, 2, 1, 2, 1, 2, 1, 2,// 0140 - 014f
     1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,// 0150 - 015f
     1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,// 0160 - 016f
     1, 2, 1, 2, 1, 2, 1, 2, 1, 1, 2, 1, 2, 1, 2, 2,// 0170 - 017f
     2, 1, 1, 2, 1, 2, 1, 1, 2, 1, 1, 1, 2, 2, 1, 1,// 0180 - 018f
     1, 1, 2, 1, 1, 2, 1, 1, 1, 2, 2, 2, 1, 1, 2, 1,// 0190 - 019f
     1, 2, 1, 2, 1, 2, 1, 1, 2, 1, 2, 2, 1, 2, 1, 1,// 01a0 - 01af
     2, 1, 1, 1, 2, 1, 2, 1, 1, 2, 2, 5, 1, 2, 2, 2,// 01b0 - 01bf
     5, 5, 5, 5, 1, 3, 2, 1, 3, 2, 1, 3, 2, 1, 2, 1,// 01c0 - 01cf
     2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 2, 1, 2,// 01d0 - 01df
     1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,// 01e0 - 01ef
     2, 1, 3, 2, 1, 2, 1, 1, 1, 2, 1, 2, 1, 2, 1, 2,// 01f0 - 01ff

     1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,// 0200 - 020f
     1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,// 0210 - 021f
     0, 0, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,// 0220 - 022f
     1, 2, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0230 - 023f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0240 - 024f
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,// 0250 - 025f
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,// 0260 - 026f
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,// 0270 - 027f
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,// 0280 - 028f
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,// 0290 - 029f
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0,// 02a0 - 02af
     4, 4, 4, 4, 4, 4, 4, 4, 4,26,26, 4, 4, 4, 4, 4,// 02b0 - 02bf
     4, 4,26,26,26,26,26,26,26,26,26,26,26,26,26,26,// 02c0 - 02cf
     4, 4,26,26,26,26,26,26,26,26,26,26,26,26,26,26,// 02d0 - 02df
     4, 4, 4, 4, 4,26,26,26,26,26,26,26,26,26, 4, 0,// 02e0 - 02ef
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 02f0 - 02ff

     6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,// 0300 - 030f
     6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,// 0310 - 031f
     6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,// 0320 - 032f
     6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,// 0330 - 033f
     6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 0,// 0340 - 034f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0350 - 035f
     6, 6, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0360 - 036f
     0, 0, 0, 0,26,26, 0, 0, 0, 0, 4, 0, 0, 0,23, 0,// 0370 - 037f
     0, 0, 0, 0,26,26, 1,23, 1, 1, 1, 0, 1, 0, 1, 1,// 0380 - 038f
     2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,// 0390 - 039f
     1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2,// 03a0 - 03af
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,// 03b0 - 03bf
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0,// 03c0 - 03cf
     2, 2, 1, 1, 1, 2, 2, 2, 0, 0, 1, 2, 1, 2, 1, 2,// 03d0 - 03df
     1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,// 03e0 - 03ef
     2, 2, 2, 2, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 03f0 - 03ff

     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,// 0400 - 040f
     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,// 0410 - 041f
     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,// 0420 - 042f
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,// 0430 - 043f
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,// 0440 - 044f
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,// 0450 - 045f
     1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,// 0460 - 046f
     1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,// 0470 - 047f
     1, 2,27, 6, 6, 6, 6, 0, 7, 7, 0, 0, 1, 2, 1, 2,// 0480 - 048f
     1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,// 0490 - 049f
     1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,// 04a0 - 04af
     1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,// 04b0 - 04bf
     1, 1, 2, 1, 2, 0, 0, 1, 2, 0, 0, 1, 2, 0, 0, 0,// 04c0 - 04cf
     1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,// 04d0 - 04df
     1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,// 04e0 - 04ef
     1, 2, 1, 2, 1, 2, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0,// 04f0 - 04ff

     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0500 - 050f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0510 - 051f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0520 - 052f
     0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,// 0530 - 053f
     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,// 0540 - 054f
     1, 1, 1, 1, 1, 1, 1, 0, 0, 4,23,23,23,23,23,23,// 0550 - 055f
     0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,// 0560 - 056f
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,// 0570 - 057f
     2, 2, 2, 2, 2, 2, 2, 2, 0,23,19, 0, 0, 0, 0, 0,// 0580 - 058f
     0, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,// 0590 - 059f
     6, 6, 0, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,// 05a0 - 05af
     6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 0, 6, 6, 6,23, 6,// 05b0 - 05bf
    23, 6, 6,23, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 05c0 - 05cf
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 05d0 - 05df
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0,// 05e0 - 05ef
     5, 5, 5,23,23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 05f0 - 05ff

     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,23, 0, 0, 0,// 0600 - 060f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,23, 0, 0, 0,23,// 0610 - 061f
     0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 0620 - 062f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0,// 0630 - 063f
     4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6,// 0640 - 064f
     6, 6, 6, 6, 6, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0650 - 065f
     9, 9, 9, 9, 9, 9, 9, 9, 9, 9,23,23,23,23, 0, 0,// 0660 - 066f
     6, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 0670 - 067f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 0680 - 068f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 0690 - 069f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 06a0 - 06af
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 06b0 - 06bf
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 06c0 - 06cf
     5, 5, 5, 5,23, 5, 6, 6, 6, 6, 6, 6, 6, 7, 7, 6,// 06d0 - 06df
     6, 6, 6, 6, 6, 4, 4, 6, 6,27, 6, 6, 6, 6, 0, 0,// 06e0 - 06ef
     9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 5, 5, 5,27,27, 0,// 06f0 - 06ff

    23,23,23,23,23,23,23,23,23,23,23,23,23,23, 0,16,// 0700 - 070f
     5, 6, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 0710 - 071f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0,// 0720 - 072f
     6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,// 0730 - 073f
     6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 0, 0, 0, 0, 0,// 0740 - 074f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0750 - 075f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0760 - 076f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0770 - 077f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 0780 - 078f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 0790 - 079f
     5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,// 07a0 - 07af
     6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 07b0 - 07bf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 07c0 - 07cf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 07d0 - 07df
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 07e0 - 07ef
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 07f0 - 07ff

     0, 6, 6, 8, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 0900 - 090f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 0910 - 091f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 0920 - 092f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 6, 5, 8, 8,// 0930 - 093f
     8, 6, 6, 6, 6, 6, 6, 6, 6, 8, 8, 8, 8, 6, 0, 0,// 0940 - 094f
     5, 6, 6, 6, 6, 0, 0, 0, 5, 5, 5, 5, 5, 5, 5, 5,// 0950 - 095f
     5, 5, 6, 6,23,23, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,// 0960 - 096f
    23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0970 - 097f
     0, 6, 8, 8, 0, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 5,// 0980 - 098f
     5, 0, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 0990 - 099f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 5, 5, 5, 5, 5, 5,// 09a0 - 09af
     5, 0, 5, 0, 0, 0, 5, 5, 5, 5, 0, 0, 6, 0, 8, 8,// 09b0 - 09bf
     8, 6, 6, 6, 6, 0, 0, 8, 8, 0, 0, 8, 8, 6, 0, 0,// 09c0 - 09cf
     0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 5, 5, 0, 5,// 09d0 - 09df
     5, 5, 6, 6, 0, 0, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,// 09e0 - 09ef
     5, 5,25,25,11,11,11,11,11,11,27, 0, 0, 0, 0, 0,// 09f0 - 09ff

     0, 0, 6, 0, 0, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 5,// 0a00 - 0a0f
     5, 0, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 0a10 - 0a1f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 5, 5, 5, 5, 5, 5,// 0a20 - 0a2f
     5, 0, 5, 5, 0, 5, 5, 0, 5, 5, 0, 0, 6, 0, 8, 8,// 0a30 - 0a3f
     8, 6, 6, 0, 0, 0, 0, 6, 6, 0, 0, 6, 6, 6, 0, 0,// 0a40 - 0a4f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 5, 5, 0, 5, 0,// 0a50 - 0a5f
     0, 0, 0, 0, 0, 0, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,// 0a60 - 0a6f
     6, 6, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0a70 - 0a7f
     0, 6, 6, 8, 0, 5, 5, 5, 5, 5, 5, 5, 0, 5, 0, 5,// 0a80 - 0a8f
     5, 5, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 0a90 - 0a9f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 5, 5, 5, 5, 5, 5,// 0aa0 - 0aaf
     5, 0, 5, 5, 0, 5, 5, 5, 5, 5, 0, 0, 6, 5, 8, 8,// 0ab0 - 0abf
     8, 6, 6, 6, 6, 6, 0, 6, 6, 8, 0, 8, 8, 6, 0, 0,// 0ac0 - 0acf
     5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0ad0 - 0adf
     5, 0, 0, 0, 0, 0, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,// 0ae0 - 0aef
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0af0 - 0aff

     0, 6, 8, 8, 0, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 5,// 0b00 - 0b0f
     5, 0, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 0b10 - 0b1f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 5, 5, 5, 5, 5, 5,// 0b20 - 0b2f
     5, 0, 5, 5, 0, 0, 5, 5, 5, 5, 0, 0, 6, 5, 8, 6,// 0b30 - 0b3f
     8, 6, 6, 6, 0, 0, 0, 8, 8, 0, 0, 8, 8, 6, 0, 0,// 0b40 - 0b4f
     0, 0, 0, 0, 0, 0, 6, 8, 0, 0, 0, 0, 5, 5, 0, 5,// 0b50 - 0b5f
     5, 5, 0, 0, 0, 0, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,// 0b60 - 0b6f
    27, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0b70 - 0b7f
     0, 0, 6, 8, 0, 5, 5, 5, 5, 5, 5, 0, 0, 0, 5, 5,// 0b80 - 0b8f
     5, 0, 5, 5, 5, 5, 0, 0, 0, 5, 5, 0, 5, 0, 5, 5,// 0b90 - 0b9f
     0, 0, 0, 5, 5, 0, 0, 0, 5, 5, 5, 0, 0, 0, 5, 5,// 0ba0 - 0baf
     5, 5, 5, 5, 5, 5, 0, 5, 5, 5, 0, 0, 0, 0, 8, 8,// 0bb0 - 0bbf
     6, 8, 8, 0, 0, 0, 8, 8, 8, 0, 8, 8, 8, 6, 0, 0,// 0bc0 - 0bcf
     0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0,// 0bd0 - 0bdf
     0, 0, 0, 0, 0, 0, 0, 9, 9, 9, 9, 9, 9, 9, 9, 9,// 0be0 - 0bef
    11,11,11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0bf0 - 0bff

     0, 8, 8, 8, 0, 5, 5, 5, 5, 5, 5, 5, 5, 0, 5, 5,// 0c00 - 0c0f
     5, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 0c10 - 0c1f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 5, 5, 5, 5, 5, 5,// 0c20 - 0c2f
     5, 5, 5, 5, 0, 5, 5, 5, 5, 5, 0, 0, 0, 0, 6, 6,// 0c30 - 0c3f
     6, 8, 8, 8, 8, 0, 6, 6, 6, 0, 6, 6, 6, 6, 0, 0,// 0c40 - 0c4f
     0, 0, 0, 0, 0, 6, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0c50 - 0c5f
     5, 5, 0, 0, 0, 0, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,// 0c60 - 0c6f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0c70 - 0c7f
     0, 0, 8, 8, 0, 5, 5, 5, 5, 5, 5, 5, 5, 0, 5, 5,// 0c80 - 0c8f
     5, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 0c90 - 0c9f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 5, 5, 5, 5, 5, 5,// 0ca0 - 0caf
     5, 5, 5, 5, 0, 5, 5, 5, 5, 5, 0, 0, 0, 0, 8, 6,// 0cb0 - 0cbf
     8, 8, 8, 8, 8, 0, 6, 8, 8, 0, 8, 8, 6, 6, 0, 0,// 0cc0 - 0ccf
     0, 0, 0, 0, 0, 8, 8, 0, 0, 0, 0, 0, 0, 0, 5, 0,// 0cd0 - 0cdf
     5, 5, 0, 0, 0, 0, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,// 0ce0 - 0cef
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0cf0 - 0cff

     0, 0, 8, 8, 0, 5, 5, 5, 5, 5, 5, 5, 5, 0, 5, 5,// 0d00 - 0d0f
     5, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 0d10 - 0d1f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 5, 5, 5, 5, 5, 5,// 0d20 - 0d2f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 8, 8,// 0d30 - 0d3f
     8, 6, 6, 6, 0, 0, 8, 8, 8, 0, 8, 8, 8, 6, 0, 0,// 0d40 - 0d4f
     0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0,// 0d50 - 0d5f
     5, 5, 0, 0, 0, 0, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,// 0d60 - 0d6f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0d70 - 0d7f
     0, 0, 8, 8, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 0d80 - 0d8f
     5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 5, 5, 5, 5, 5, 5,// 0d90 - 0d9f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 0da0 - 0daf
     5, 5, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 5, 0, 0,// 0db0 - 0dbf
     5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 6, 0, 0, 0, 0, 8,// 0dc0 - 0dcf
     8, 8, 6, 6, 6, 0, 6, 0, 8, 8, 8, 8, 8, 8, 8, 8,// 0dd0 - 0ddf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0de0 - 0def
     0, 0, 8, 8,23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0df0 - 0dff

     0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 0e00 - 0e0f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 0e10 - 0e1f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 0e20 - 0e2f
     5, 6, 5, 5, 6, 6, 6, 6, 6, 6, 6, 0, 0, 0, 0,25,// 0e30 - 0e3f
     5, 5, 5, 5, 5, 5, 4, 6, 6, 6, 6, 6, 6, 6, 6,23,// 0e40 - 0e4f
     9, 9, 9, 9, 9, 9, 9, 9, 9, 9,23,23, 0, 0, 0, 0,// 0e50 - 0e5f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0e60 - 0e6f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0e70 - 0e7f
     0, 5, 5, 0, 5, 0, 0, 5, 5, 0, 5, 0, 0, 5, 0, 0,// 0e80 - 0e8f
     0, 0, 0, 0, 5, 5, 5, 5, 0, 5, 5, 5, 5, 5, 5, 5,// 0e90 - 0e9f
     0, 5, 5, 5, 0, 5, 0, 5, 0, 0, 5, 5, 0, 5, 5, 5,// 0ea0 - 0eaf
     5, 6, 5, 5, 6, 6, 6, 6, 6, 6, 0, 6, 6, 5, 0, 0,// 0eb0 - 0ebf
     5, 5, 5, 5, 5, 0, 4, 0, 6, 6, 6, 6, 6, 6, 0, 0,// 0ec0 - 0ecf
     9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 0, 0, 5, 5, 0, 0,// 0ed0 - 0edf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0ee0 - 0eef
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0ef0 - 0eff

     5,27,27,27,23,23,23,23,23,23,23,23,23,23,23,23,// 0f00 - 0f0f
    23,23,23,27,27,27,27,27, 6, 6,27,27,27,27,27,27,// 0f10 - 0f1f
     9, 9, 9, 9, 9, 9, 9, 9, 9, 9,11,11,11,11,11,11,// 0f20 - 0f2f
    11,11,11,11,27, 6,27, 6,27, 6,20,21,20,21, 8, 8,// 0f30 - 0f3f
     5, 5, 5, 5, 5, 5, 5, 5, 0, 5, 5, 5, 5, 5, 5, 5,// 0f40 - 0f4f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 0f50 - 0f5f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0,// 0f60 - 0f6f
     0, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 8,// 0f70 - 0f7f
     6, 6, 6, 6, 6,23, 6, 6, 5, 5, 5, 5, 0, 0, 0, 0,// 0f80 - 0f8f
     6, 6, 6, 6, 6, 6, 6, 6, 0, 6, 6, 6, 6, 6, 6, 6,// 0f90 - 0f9f
     6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,// 0fa0 - 0faf
     6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 0,27,27,// 0fb0 - 0fbf
    27,27,27,27,27,27, 6,27,27,27,27,27,27, 0, 0,27,// 0fc0 - 0fcf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0fd0 - 0fdf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0fe0 - 0fef
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0ff0 - 0fff

     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 1000 - 100f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 1010 - 101f
     5, 5, 0, 5, 5, 5, 5, 5, 0, 5, 5, 0, 8, 6, 6, 6,// 1020 - 102f
     6, 8, 6, 0, 0, 0, 6, 6, 8, 6, 0, 0, 0, 0, 0, 0,// 1030 - 103f
     9, 9, 9, 9, 9, 9, 9, 9, 9, 9,23,23,23,23,23,23,// 1040 - 104f
     5, 5, 5, 5, 5, 5, 8, 8, 6, 6, 0, 0, 0, 0, 0, 0,// 1050 - 105f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1060 - 106f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1070 - 107f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1080 - 108f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1090 - 109f
     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,// 10a0 - 10af
     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,// 10b0 - 10bf
     1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 10c0 - 10cf
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 10d0 - 10df
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 10e0 - 10ef
     5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0,23, 0, 0, 0, 0,// 10f0 - 10ff

     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 1100 - 110f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 1110 - 111f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 1120 - 112f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 1130 - 113f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 1140 - 114f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 5,// 1150 - 115f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 1160 - 116f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 1170 - 117f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 1180 - 118f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 1190 - 119f
     5, 5, 5, 0, 0, 0, 0, 0, 5, 5, 5, 5, 5, 5, 5, 5,// 11a0 - 11af
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 11b0 - 11bf
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 11c0 - 11cf
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 11d0 - 11df
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 11e0 - 11ef
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0,// 11f0 - 11ff

     5, 5, 5, 5, 5, 5, 5, 0, 5, 5, 5, 5, 5, 5, 5, 5,// 1200 - 120f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 1210 - 121f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 1220 - 122f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 1230 - 123f
     5, 5, 5, 5, 5, 5, 5, 0, 5, 0, 5, 5, 5, 5, 0, 0,// 1240 - 124f
     5, 5, 5, 5, 5, 5, 5, 0, 5, 0, 5, 5, 5, 5, 0, 0,// 1250 - 125f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 1260 - 126f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 1270 - 127f
     5, 5, 5, 5, 5, 5, 5, 0, 5, 0, 5, 5, 5, 5, 0, 0,// 1280 - 128f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 1290 - 129f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0,// 12a0 - 12af
     5, 0, 5, 5, 5, 5, 0, 0, 5, 5, 5, 5, 5, 5, 5, 0,// 12b0 - 12bf
     5, 0, 5, 5, 5, 5, 0, 0, 5, 5, 5, 5, 5, 5, 5, 0,// 12c0 - 12cf
     5, 5, 5, 5, 5, 5, 5, 0, 5, 5, 5, 5, 5, 5, 5, 5,// 12d0 - 12df
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0,// 12e0 - 12ef
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 12f0 - 12ff

     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0,// 1300 - 130f
     5, 0, 5, 5, 5, 5, 0, 0, 5, 5, 5, 5, 5, 5, 5, 0,// 1310 - 131f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 1320 - 132f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 1330 - 133f
     5, 5, 5, 5, 5, 5, 5, 0, 5, 5, 5, 5, 5, 5, 5, 5,// 1340 - 134f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0,// 1350 - 135f
     0,23,23,23,23,23,23,23,23, 9, 9, 9, 9, 9, 9, 9,// 1360 - 136f
     9, 9,11,11,11,11,11,11,11,11,11,11,11, 0, 0, 0,// 1370 - 137f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1380 - 138f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1390 - 139f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 13a0 - 13af
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 13b0 - 13bf
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 13c0 - 13cf
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 13d0 - 13df
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 13e0 - 13ef
     5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 13f0 - 13ff

     0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 1400 - 140f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 1410 - 141f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 1420 - 142f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 1430 - 143f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 1440 - 144f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 1450 - 145f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 1460 - 146f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 1470 - 147f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 1480 - 148f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 1490 - 149f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 14a0 - 14af
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 14b0 - 14bf
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 14c0 - 14cf
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 14d0 - 14df
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 14e0 - 14ef
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 14f0 - 14ff

     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 1600 - 160f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 1610 - 161f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 1620 - 162f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 1630 - 163f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 1640 - 164f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 1650 - 165f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,23,23, 5,// 1660 - 166f
     5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1670 - 167f
    12, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 1680 - 168f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,20,21, 0, 0, 0,// 1690 - 169f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 16a0 - 16af
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 16b0 - 16bf
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 16c0 - 16cf
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 16d0 - 16df
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,23,23,23,10,10,// 16e0 - 16ef
    10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 16f0 - 16ff

     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1700 - 170f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1710 - 171f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1720 - 172f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1730 - 173f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1740 - 174f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1750 - 175f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1760 - 176f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1770 - 177f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 1780 - 178f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 1790 - 179f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 17a0 - 17af
     5, 5, 5, 5, 8, 8, 8, 6, 6, 6, 6, 6, 6, 6, 8, 8,// 17b0 - 17bf
     8, 8, 8, 8, 8, 8, 6, 8, 8, 6, 6, 6, 6, 6, 6, 6,// 17c0 - 17cf
     6, 6, 6, 6,23,23,23,23,23,23,23,25,23, 0, 0, 0,// 17d0 - 17df
     9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 0, 0, 0, 0, 0, 0,// 17e0 - 17ef
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 17f0 - 17ff

    23,23,23,23,23,23,19,23,23,23,23,16,16,16,16, 0,// 1800 - 180f
     9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 0, 0, 0, 0, 0, 0,// 1810 - 181f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 1820 - 182f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 1830 - 183f
     5, 5, 5, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 1840 - 184f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 1850 - 185f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 1860 - 186f
     5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0,// 1870 - 187f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 1880 - 188f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 1890 - 189f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 0, 0, 0, 0, 0, 0,// 18a0 - 18af
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 18b0 - 18bf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 18c0 - 18cf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 18d0 - 18df
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 18e0 - 18ef
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 18f0 - 18ff

     1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,// 1e00 - 1e0f
     1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,// 1e10 - 1e1f
     1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,// 1e20 - 1e2f
     1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,// 1e30 - 1e3f
     1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,// 1e40 - 1e4f
     1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,// 1e50 - 1e5f
     1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,// 1e60 - 1e6f
     1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,// 1e70 - 1e7f
     1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,// 1e80 - 1e8f
     1, 2, 1, 2, 1, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0,// 1e90 - 1e9f
     1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,// 1ea0 - 1eaf
     1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,// 1eb0 - 1ebf
     1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,// 1ec0 - 1ecf
     1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,// 1ed0 - 1edf
     1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,// 1ee0 - 1eef
     1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 0, 0, 0, 0, 0, 0,// 1ef0 - 1eff

     2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1,// 1f00 - 1f0f
     2, 2, 2, 2, 2, 2, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0,// 1f10 - 1f1f
     2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1,// 1f20 - 1f2f
     2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1,// 1f30 - 1f3f
     2, 2, 2, 2, 2, 2, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0,// 1f40 - 1f4f
     2, 2, 2, 2, 2, 2, 2, 2, 0, 1, 0, 1, 0, 1, 0, 1,// 1f50 - 1f5f
     2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1,// 1f60 - 1f6f
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0,// 1f70 - 1f7f
     2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3,// 1f80 - 1f8f
     2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3,// 1f90 - 1f9f
     2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3,// 1fa0 - 1faf
     2, 2, 2, 2, 2, 0, 2, 2, 1, 1, 1, 1, 3,26, 2,26,// 1fb0 - 1fbf
    26,26, 2, 2, 2, 0, 2, 2, 1, 1, 1, 1, 3,26,26,26,// 1fc0 - 1fcf
     2, 2, 2, 2, 0, 0, 2, 2, 1, 1, 1, 1, 0,26,26,26,// 1fd0 - 1fdf
     2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1,26,26,26,// 1fe0 - 1fef
     0, 0, 2, 2, 2, 0, 2, 2, 1, 1, 1, 1, 3,26,26, 0,// 1ff0 - 1fff

    12,12,12,12,12,12,12,12,12,12,12,12,16,16,16,16,// 2000 - 200f
    19,19,19,19,19,19,23,23,28,29,20,28,28,29,20,28,// 2010 - 201f
    23,23,23,23,23,23,23,23,13,14,16,16,16,16,16,12,// 2020 - 202f
    23,23,23,23,23,23,23,23,23,28,29,23,23,23,23,22,// 2030 - 203f
    22,23,23,23,24,20,21, 0,23,23,23,23,23,23, 0, 0,// 2040 - 204f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2050 - 205f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0,16,16,16,16,16,16,// 2060 - 206f
    11, 0, 0, 0,11,11,11,11,11,11,24,24,24,20,21, 2,// 2070 - 207f
    11,11,11,11,11,11,11,11,11,11,24,24,24,20,21, 0,// 2080 - 208f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2090 - 209f
    25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,// 20a0 - 20af
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 20b0 - 20bf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 20c0 - 20cf
     6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7,// 20d0 - 20df
     7, 6, 7, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 20e0 - 20ef
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 20f0 - 20ff

    27,27, 1,27,27,27,27, 1,27,27, 2, 1, 1, 1, 2, 2,// 2100 - 210f
     1, 1, 1, 2,27, 1,27,27,27, 1, 1, 1, 1, 1,27,27,// 2110 - 211f
    27,27,27,27, 1,27, 1,27, 1,27, 1, 1, 1, 1,27, 2,// 2120 - 212f
     1, 1,27, 1, 2, 5, 5, 5, 5, 2,27, 0, 0, 0, 0, 0,// 2130 - 213f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2140 - 214f
     0, 0, 0,11,11,11,11,11,11,11,11,11,11,11,11,11,// 2150 - 215f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2160 - 216f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2170 - 217f
    10,10,10,10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2180 - 218f
    24,24,24,24,24,27,27,27,27,27,24,24,27,27,27,27,// 2190 - 219f
    24,27,27,24,27,27,24,27,27,27,27,27,27,27,24,27,// 21a0 - 21af
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 21b0 - 21bf
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,24,24,// 21c0 - 21cf
    27,27,24,27,24,27,27,27,27,27,27,27,27,27,27,27,// 21d0 - 21df
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 21e0 - 21ef
    27,27,27,27, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 21f0 - 21ff

    24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,// 2200 - 220f
    24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,// 2210 - 221f
    24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,// 2220 - 222f
    24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,// 2230 - 223f
    24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,// 2240 - 224f
    24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,// 2250 - 225f
    24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,// 2260 - 226f
    24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,// 2270 - 227f
    24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,// 2280 - 228f
    24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,// 2290 - 229f
    24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,// 22a0 - 22af
    24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,// 22b0 - 22bf
    24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,// 22c0 - 22cf
    24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,// 22d0 - 22df
    24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,// 22e0 - 22ef
    24,24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 22f0 - 22ff

    27,27,27,27,27,27,27,27,24,24,24,24,27,27,27,27,// 2300 - 230f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 2310 - 231f
    24,24,27,27,27,27,27,27,27,20,21,27,27,27,27,27,// 2320 - 232f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 2330 - 233f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 2340 - 234f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 2350 - 235f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 2360 - 236f
    27,27,27,27,27,27,27,27,27,27,27,27, 0,27,27,27,// 2370 - 237f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 2380 - 238f
    27,27,27,27,27,27,27,27,27,27,27, 0, 0, 0, 0, 0,// 2390 - 239f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 23a0 - 23af
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 23b0 - 23bf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 23c0 - 23cf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 23d0 - 23df
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 23e0 - 23ef
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 23f0 - 23ff

    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 2400 - 240f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 2410 - 241f
    27,27,27,27,27,27,27, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2420 - 242f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2430 - 243f
    27,27,27,27,27,27,27,27,27,27,27, 0, 0, 0, 0, 0,// 2440 - 244f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2450 - 245f
    11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,// 2460 - 246f
    11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,// 2470 - 247f
    11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,// 2480 - 248f
    11,11,11,11,11,11,11,11,11,11,11,11,27,27,27,27,// 2490 - 249f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 24a0 - 24af
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 24b0 - 24bf
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 24c0 - 24cf
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 24d0 - 24df
    27,27,27,27,27,27,27,27,27,27,11, 0, 0, 0, 0, 0,// 24e0 - 24ef
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 24f0 - 24ff

    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 2500 - 250f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 2510 - 251f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 2520 - 252f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 2530 - 253f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 2540 - 254f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 2550 - 255f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 2560 - 256f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 2570 - 257f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 2580 - 258f
    27,27,27,27,27,27, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2590 - 259f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 25a0 - 25af
    27,27,27,27,27,27,27,24,27,27,27,27,27,27,27,27,// 25b0 - 25bf
    27,24,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 25c0 - 25cf
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 25d0 - 25df
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 25e0 - 25ef
    27,27,27,27,27,27,27,27, 0, 0, 0, 0, 0, 0, 0, 0,// 25f0 - 25ff

    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 2600 - 260f
    27,27,27,27, 0, 0, 0, 0, 0,27,27,27,27,27,27,27,// 2610 - 261f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 2620 - 262f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 2630 - 263f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 2640 - 264f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 2650 - 265f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,24,// 2660 - 266f
    27,27, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2670 - 267f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2680 - 268f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2690 - 269f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 26a0 - 26af
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 26b0 - 26bf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 26c0 - 26cf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 26d0 - 26df
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 26e0 - 26ef
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 26f0 - 26ff

     0,27,27,27,27, 0,27,27,27,27, 0, 0,27,27,27,27,// 2700 - 270f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 2710 - 271f
    27,27,27,27,27,27,27,27, 0,27,27,27,27,27,27,27,// 2720 - 272f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 2730 - 273f
    27,27,27,27,27,27,27,27,27,27,27,27, 0,27, 0,27,// 2740 - 274f
    27,27,27, 0, 0, 0,27, 0,27,27,27,27,27,27,27, 0,// 2750 - 275f
     0,27,27,27,27,27,27,27, 0, 0, 0, 0, 0, 0, 0, 0,// 2760 - 276f
     0, 0, 0, 0, 0, 0,11,11,11,11,11,11,11,11,11,11,// 2770 - 277f
    11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,// 2780 - 278f
    11,11,11,11,27, 0, 0, 0,27,27,27,27,27,27,27,27,// 2790 - 279f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 27a0 - 27af
     0,27,27,27,27,27,27,27,27,27,27,27,27,27,27, 0,// 27b0 - 27bf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 27c0 - 27cf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 27d0 - 27df
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 27e0 - 27ef
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 27f0 - 27ff

     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2c00 - 2c0f      Block index 0x26
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2c10 - 2c1f      (Coptic inserted)
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2c20 - 2c2f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2c30 - 2c3f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2c40 - 2c4f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2c50 - 2c5f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2c60 - 2c6f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2c70 - 2c7f
     1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,// 2c80 - 2c8f
     1, 2, 1, 2, 1, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0,// 2c90 - 2c9f
     1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,// 2ca0 - 2caf
     1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,// 2cb0 - 2cbf
     1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,// 2cc0 - 2ccf
     1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,// 2cd0 - 2cdf
     1, 2, 1, 2,27,27,27,27,27,27,27, 0, 0, 0, 0, 0,// 2ce0 - 2cef
     0, 0, 0, 0, 0, 0, 0, 0, 0,21,21,21,21,11,21,21,// 2cf0 - 2cff

     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2e00 - 2e0f  Block index 0x27
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2e10 - 2e1f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2e20 - 2e2f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2e30 - 2e3f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2e40 - 2e4f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2e50 - 2e5f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2e60 - 2e6f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2e70 - 2e7f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 2e80 - 2e8f
    27,27,27,27,27,27,27,27,27,27, 0,27,27,27,27,27,// 2e90 - 2e9f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 2ea0 - 2eaf
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 2eb0 - 2ebf
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 2ec0 - 2ecf
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 2ed0 - 2edf
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 2ee0 - 2eef
    27,27,27,27, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2ef0 - 2eff

    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 2f00 - 2f0f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 2f10 - 2f1f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 2f20 - 2f2f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 2f30 - 2f3f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 2f40 - 2f4f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 2f50 - 2f5f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 2f60 - 2f6f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 2f70 - 2f7f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 2f80 - 2f8f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 2f90 - 2f9f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 2fa0 - 2faf
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 2fb0 - 2fbf
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 2fc0 - 2fcf
    27,27,27,27,27,27, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2fd0 - 2fdf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2fe0 - 2fef
    27,27,27,27,27,27,27,27,27,27,27,27, 0, 0, 0, 0,// 2ff0 - 2fff

    12,23,23,23,27, 4, 5,10,20,21,20,21,20,21,20,21,// 3000 - 300f
    20,21,27,27,20,21,20,21,20,21,20,21,19,20,21,21,// 3010 - 301f
    27,10,10,10,10,10,10,10,10,10, 6, 6, 6, 6, 6, 6,// 3020 - 302f
    19, 4, 4, 4, 4, 4,27,27,10,10,10, 0, 0, 0,27,27,// 3030 - 303f
     0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 3040 - 304f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 3050 - 305f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 3060 - 306f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 3070 - 307f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 3080 - 308f
     5, 5, 5, 5, 5, 0, 0, 0, 0, 6, 6,26,26, 4, 4, 0,// 3090 - 309f
     0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 30a0 - 30af
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 30b0 - 30bf
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 30c0 - 30cf
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 30d0 - 30df
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 30e0 - 30ef
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,22, 4, 4, 4, 0,// 30f0 - 30ff

     0, 0, 0, 0, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 3100 - 310f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 3110 - 311f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0,// 3120 - 312f
     0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 3130 - 313f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 3140 - 314f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 3150 - 315f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 3160 - 316f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 3170 - 317f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0,// 3180 - 318f
    27,27,11,11,11,11,27,27,27,27,27,27,27,27,27,27,// 3190 - 319f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 31a0 - 31af
     5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0,// 31b0 - 31bf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 31c0 - 31cf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 31d0 - 31df
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 31e0 - 31ef
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 31f0 - 31ff

    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 3200 - 320f
    27,27,27,27,27,27,27,27,27,27,27,27,27, 0, 0, 0,// 3210 - 321f
    11,11,11,11,11,11,11,11,11,11,27,27,27,27,27,27,// 3220 - 322f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 3230 - 323f
    27,27,27,27, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 3240 - 324f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 3250 - 325f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 3260 - 326f
    27,27,27,27,27,27,27,27,27,27,27,27, 0, 0, 0,27,// 3270 - 327f
    11,11,11,11,11,11,11,11,11,11,27,27,27,27,27,27,// 3280 - 328f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 3290 - 329f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 32a0 - 32af
    27, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 32b0 - 32bf
    27,27,27,27,27,27,27,27,27,27,27,27, 0, 0, 0, 0,// 32c0 - 32cf
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 32d0 - 32df
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 32e0 - 32ef
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27, 0,// 32f0 - 32ff

    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 3300 - 330f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 3310 - 331f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 3320 - 332f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 3330 - 333f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 3340 - 334f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 3350 - 335f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 3360 - 336f
    27,27,27,27,27,27,27, 0, 0, 0, 0,27,27,27,27,27,// 3370 - 337f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 3380 - 338f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 3390 - 339f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 33a0 - 33af
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 33b0 - 33bf
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 33c0 - 33cf
    27,27,27,27,27,27,27,27,27,27,27,27,27,27, 0, 0,// 33d0 - 33df
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// 33e0 - 33ef
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27, 0,// 33f0 - 33ff

     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 4d00 - 4d0f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 4d10 - 4d1f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 4d20 - 4d2f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 4d30 - 4d3f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 4d40 - 4d4f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 4d50 - 4d5f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 4d60 - 4d6f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 4d70 - 4d7f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 4d80 - 4d8f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 4d90 - 4d9f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 4da0 - 4daf
     5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 4db0 - 4dbf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 4dc0 - 4dcf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 4dd0 - 4ddf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 4de0 - 4def
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 4df0 - 4dff

     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 9f00 - 9f0f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 9f10 - 9f1f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 9f20 - 9f2f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 9f30 - 9f3f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 9f40 - 9f4f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 9f50 - 9f5f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 9f60 - 9f6f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 9f70 - 9f7f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 9f80 - 9f8f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// 9f90 - 9f9f
     5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 9fa0 - 9faf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 9fb0 - 9fbf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 9fc0 - 9fcf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 9fd0 - 9fdf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 9fe0 - 9fef
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 9ff0 - 9fff

     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// a400 - a40f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// a410 - a41f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// a420 - a42f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// a430 - a43f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// a440 - a44f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// a450 - a45f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// a460 - a46f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// a470 - a47f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0,// a480 - a48f
    27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,// a490 - a49f
    27,27, 0, 0,27,27,27,27,27,27,27,27,27,27,27,27,// a4a0 - a4af
    27,27,27,27, 0,27,27,27,27,27,27,27,27,27,27,27,// a4b0 - a4bf
    27, 0,27,27,27, 0,27, 0, 0, 0, 0, 0, 0, 0, 0, 0,// a4c0 - a4cf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// a4d0 - a4df
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// a4e0 - a4ef
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// a4f0 - a4ff

     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// d700 - d70f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// d710 - d71f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// d720 - d72f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// d730 - d73f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// d740 - d74f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// d750 - d75f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// d760 - d76f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// d770 - d77f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// d780 - d78f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// d790 - d79f
     5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// d7a0 - d7af
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// d7b0 - d7bf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// d7c0 - d7cf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// d7d0 - d7df
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// d7e0 - d7ef
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// d7f0 - d7ff

     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// fa00 - fa0f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// fa10 - fa1f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0,// fa20 - fa2f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// fa30 - fa3f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// fa40 - fa4f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// fa50 - fa5f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// fa60 - fa6f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// fa70 - fa7f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// fa80 - fa8f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// fa90 - fa9f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// faa0 - faaf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// fab0 - fabf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// fac0 - facf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// fad0 - fadf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// fae0 - faef
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// faf0 - faff

     2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0,// fb00 - fb0f
     0, 0, 0, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 5, 6, 5,// fb10 - fb1f
     5, 5, 5, 5, 5, 5, 5, 5, 5,24, 5, 5, 5, 5, 5, 5,// fb20 - fb2f
     5, 5, 5, 5, 5, 5, 5, 0, 5, 5, 5, 5, 5, 0, 5, 0,// fb30 - fb3f
     5, 5, 0, 5, 5, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// fb40 - fb4f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// fb50 - fb5f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// fb60 - fb6f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// fb70 - fb7f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// fb80 - fb8f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// fb90 - fb9f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// fba0 - fbaf
     5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// fbb0 - fbbf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// fbc0 - fbcf
     0, 0, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// fbd0 - fbdf
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// fbe0 - fbef
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// fbf0 - fbff

     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// fd00 - fd0f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// fd10 - fd1f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// fd20 - fd2f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,20,21,// fd30 - fd3f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// fd40 - fd4f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// fd50 - fd5f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// fd60 - fd6f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// fd70 - fd7f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// fd80 - fd8f
     0, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// fd90 - fd9f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// fda0 - fdaf
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// fdb0 - fdbf
     5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0,// fdc0 - fdcf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// fdd0 - fddf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// fde0 - fdef
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0,// fdf0 - fdff

     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// fe00 - fe0f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// fe10 - fe1f
     6, 6, 6, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// fe20 - fe2f
    23,19,19,22,22,20,21,20,21,20,21,20,21,20,21,20,// fe30 - fe3f
    21,20,21,20,21, 0, 0, 0, 0,23,23,23,23,22,22,22,// fe40 - fe4f
    23,23,23, 0,23,23,23,23,19,20,21,20,21,20,21,23,// fe50 - fe5f
    23,23,24,19,24,24,24, 0,23,25,23,23, 0, 0, 0, 0,// fe60 - fe6f
     5, 5, 5, 0, 5, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// fe70 - fe7f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// fe80 - fe8f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// fe90 - fe9f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// fea0 - feaf
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// feb0 - febf
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// fec0 - fecf
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// fed0 - fedf
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// fee0 - feef
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0,16,// fef0 - feff

     0,23,23,23,25,23,23,23,20,21,23,24,23,19,23,23,// ff00 - ff0f
     9, 9, 9, 9, 9, 9, 9, 9, 9, 9,23,23,24,24,24,23,// ff10 - ff1f
    23, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,// ff20 - ff2f
     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,20,23,21,26,22,// ff30 - ff3f
    26, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,// ff40 - ff4f
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,20,24,21,24, 0,// ff50 - ff5f
     0,23,20,21,23,22, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// ff60 - ff6f
     4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// ff70 - ff7f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// ff80 - ff8f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 4, 4,// ff90 - ff9f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,// ffa0 - ffaf
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0,// ffb0 - ffbf
     0, 0, 5, 5, 5, 5, 5, 5, 0, 0, 5, 5, 5, 5, 5, 5,// ffc0 - ffcf
     0, 0, 5, 5, 5, 5, 5, 5, 0, 0, 5, 5, 5, 0, 0, 0,// ffd0 - ffdf
    25,25,24,26,27,25,25, 0,27,24,24,24,24,27,27, 0,// ffe0 - ffef
     0, 0, 0, 0, 0, 0, 0, 0, 0,16,16,16,27,27, 0, 0,// fff0 - ffff

};


#define UnicodeDirectionNumberBlock  3

static const sal_Int8 UnicodeDirectionIndex[] = {
    0x03, 0x00, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, // 0000 - 07ff
    0x00, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10, // 0800 - 0fff
    0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x13, // 1000 - 17ff
    0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, // 1800 - 1fff
    0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, // 2000 - 27ff
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x1f, // 2800 - 2fff
    0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 3000 - 37ff
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 3800 - 3fff
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 4000 - 47ff
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 4800 - 4fff
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 5000 - 57ff
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 5800 - 5fff
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 6000 - 67ff
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 6800 - 6fff
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 7000 - 77ff
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 7800 - 7fff
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 8000 - 87ff
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 8800 - 8fff
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 9000 - 97ff
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 9800 - 9fff
    0x00, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00, 0x00, // a000 - a7ff
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // a800 - afff
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // b000 - b7ff
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // b800 - bfff
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // c000 - c7ff
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // c800 - cfff
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // d000 - d7ff
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // d800 - dfff
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // e000 - e7ff
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // e800 - efff
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // f000 - f7ff
    0x00, 0x00, 0x00, 0x22, 0x02, 0x23, 0x24, 0x25, // f800 - ffff
};


static const sal_Int8 UnicodeDirectionBlockValue[] = {
     0, 10, 13,
};


static const sal_Int8 UnicodeDirectionValue[] = {
    18,18,18,18,18,18,18,18,18, 8, 7, 8, 9, 7,18,18,// 0000 - 000f
    18,18,18,18,18,18,18,18,18,18,18,18, 7, 7, 7, 8,// 0010 - 001f
     9,10,10, 4, 4, 4,10,10,10,10,10, 4, 6, 4, 6, 3,// 0020 - 002f
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 6,10,10,10,10,10,// 0030 - 003f
    10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0040 - 004f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,10,10,10,10,// 0050 - 005f
    10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0060 - 006f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,10,10,10,18,// 0070 - 007f
    18,18,18,18,18, 7,18,18,18,18,18,18,18,18,18,18,// 0080 - 008f
    18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,// 0090 - 009f
     6,10, 4, 4, 4, 4,10,10,10,10, 0,10,10,10,10,10,// 00a0 - 00af
     4, 4, 2, 2,10, 0,10,10,10, 2, 0,10,10,10,10,10,// 00b0 - 00bf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 00c0 - 00cf
     0, 0, 0, 0, 0, 0, 0,10, 0, 0, 0, 0, 0, 0, 0, 0,// 00d0 - 00df
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 00e0 - 00ef
     0, 0, 0, 0, 0, 0, 0,10, 0, 0, 0, 0, 0, 0, 0, 0,// 00f0 - 00ff

     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0200 - 020f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0210 - 021f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0220 - 022f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0230 - 023f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0240 - 024f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0250 - 025f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0260 - 026f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0270 - 027f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0280 - 028f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0290 - 029f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 02a0 - 02af
     0, 0, 0, 0, 0, 0, 0, 0, 0,10,10, 0, 0, 0, 0, 0,// 02b0 - 02bf
     0, 0,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 02c0 - 02cf
     0, 0,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 02d0 - 02df
     0, 0, 0, 0, 0,10,10,10,10,10,10,10,10,10, 0, 0,// 02e0 - 02ef
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 02f0 - 02ff

    17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,// 0300 - 030f
    17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,// 0310 - 031f
    17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,// 0320 - 032f
    17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,// 0330 - 033f
    17,17,17,17,17,17,17,17,17,17,17,17,17,17,17, 0,// 0340 - 034f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0350 - 035f
    17,17,17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0360 - 036f
     0, 0, 0, 0,10,10, 0, 0, 0, 0, 0, 0, 0, 0,10, 0,// 0370 - 037f
     0, 0, 0, 0,10,10, 0,10, 0, 0, 0, 0, 0, 0, 0, 0,// 0380 - 038f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0390 - 039f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 03a0 - 03af
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 03b0 - 03bf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 03c0 - 03cf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 03d0 - 03df
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 03e0 - 03ef
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 03f0 - 03ff

     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0400 - 040f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0410 - 041f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0420 - 042f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0430 - 043f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0440 - 044f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0450 - 045f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0460 - 046f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0470 - 047f
     0, 0, 0,17,17,17,17, 0,17,17, 0, 0, 0, 0, 0, 0,// 0480 - 048f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0490 - 049f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 04a0 - 04af
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 04b0 - 04bf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 04c0 - 04cf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 04d0 - 04df
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 04e0 - 04ef
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 04f0 - 04ff

     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0500 - 050f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0510 - 051f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0520 - 052f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0530 - 053f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0540 - 054f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0550 - 055f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0560 - 056f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0570 - 057f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10, 0, 0, 0, 0, 0,// 0580 - 058f
     0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,// 0590 - 059f
    17,17, 0,17,17,17,17,17,17,17,17,17,17,17,17,17,// 05a0 - 05af
    17,17,17,17,17,17,17,17,17,17, 0,17,17,17, 1,17,// 05b0 - 05bf
     1,17,17, 1,17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 05c0 - 05cf
     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,// 05d0 - 05df
     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,// 05e0 - 05ef
     1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 05f0 - 05ff

     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0,// 0600 - 060f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,13, 0, 0, 0,13,// 0610 - 061f
     0,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,// 0620 - 062f
    13,13,13,13,13,13,13,13,13,13,13, 0, 0, 0, 0, 0,// 0630 - 063f
    13,13,13,13,13,13,13,13,13,13,13,17,17,17,17,17,// 0640 - 064f
    17,17,17,17,17,17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0650 - 065f
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 4, 5, 5,13, 0, 0,// 0660 - 066f
    17,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,// 0670 - 067f
    13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,// 0680 - 068f
    13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,// 0690 - 069f
    13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,// 06a0 - 06af
    13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,// 06b0 - 06bf
    13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,// 06c0 - 06cf
    13,13,13,13,13,13,17,17,17,17,17,17,17,17,17,17,// 06d0 - 06df
    17,17,17,17,17,13,13,17,17,10,17,17,17,17, 0, 0,// 06e0 - 06ef
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2,13,13,13,13,13, 0,// 06f0 - 06ff

    13,13,13,13,13,13,13,13,13,13,13,13,13,13, 0,18,// 0700 - 070f
    13,17,13,13,13,13,13,13,13,13,13,13,13,13,13,13,// 0710 - 071f
    13,13,13,13,13,13,13,13,13,13,13,13,13, 0, 0, 0,// 0720 - 072f
    17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,// 0730 - 073f
    17,17,17,17,17,17,17,17,17,17,17, 0, 0, 0, 0, 0,// 0740 - 074f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0750 - 075f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0760 - 076f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0770 - 077f
    13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,// 0780 - 078f
    13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,// 0790 - 079f
    13,13,13,13,13,13,17,17,17,17,17,17,17,17,17,17,// 07a0 - 07af
    17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 07b0 - 07bf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 07c0 - 07cf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 07d0 - 07df
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 07e0 - 07ef
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 07f0 - 07ff

     0,17,17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0900 - 090f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0910 - 091f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0920 - 092f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,17, 0, 0, 0,// 0930 - 093f
     0,17,17,17,17,17,17,17,17, 0, 0, 0, 0,17, 0, 0,// 0940 - 094f
     0,17,17,17,17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0950 - 095f
     0, 0,17,17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0960 - 096f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0970 - 097f
     0,17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0980 - 098f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0990 - 099f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 09a0 - 09af
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,17, 0, 0, 0,// 09b0 - 09bf
     0,17,17,17,17, 0, 0, 0, 0, 0, 0, 0, 0,17, 0, 0,// 09c0 - 09cf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 09d0 - 09df
     0, 0,17,17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 09e0 - 09ef
     0, 0, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 09f0 - 09ff

     0, 0,17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0a00 - 0a0f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0a10 - 0a1f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0a20 - 0a2f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,17, 0, 0, 0,// 0a30 - 0a3f
     0,17,17, 0, 0, 0, 0,17,17, 0, 0,17,17,17, 0, 0,// 0a40 - 0a4f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0a50 - 0a5f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0a60 - 0a6f
    17,17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0a70 - 0a7f
     0,17,17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0a80 - 0a8f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0a90 - 0a9f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0aa0 - 0aaf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,17, 0, 0, 0,// 0ab0 - 0abf
     0,17,17,17,17,17, 0,17,17, 0, 0, 0, 0,17, 0, 0,// 0ac0 - 0acf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0ad0 - 0adf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0ae0 - 0aef
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0af0 - 0aff

     0,17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0b00 - 0b0f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0b10 - 0b1f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0b20 - 0b2f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,17, 0, 0,17,// 0b30 - 0b3f
     0,17,17,17, 0, 0, 0, 0, 0, 0, 0, 0, 0,17, 0, 0,// 0b40 - 0b4f
     0, 0, 0, 0, 0, 0,17, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0b50 - 0b5f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0b60 - 0b6f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0b70 - 0b7f
     0, 0,17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0b80 - 0b8f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0b90 - 0b9f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0ba0 - 0baf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0bb0 - 0bbf
    17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,17, 0, 0,// 0bc0 - 0bcf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0bd0 - 0bdf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0be0 - 0bef
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0bf0 - 0bff

     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0c00 - 0c0f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0c10 - 0c1f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0c20 - 0c2f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,17,17,// 0c30 - 0c3f
    17, 0, 0, 0, 0, 0,17,17,17, 0,17,17,17,17, 0, 0,// 0c40 - 0c4f
     0, 0, 0, 0, 0,17,17, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0c50 - 0c5f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0c60 - 0c6f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0c70 - 0c7f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0c80 - 0c8f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0c90 - 0c9f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0ca0 - 0caf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,17,// 0cb0 - 0cbf
     0, 0, 0, 0, 0, 0,17, 0, 0, 0, 0, 0,17,17, 0, 0,// 0cc0 - 0ccf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0cd0 - 0cdf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0ce0 - 0cef
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0cf0 - 0cff

     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0d00 - 0d0f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0d10 - 0d1f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0d20 - 0d2f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0d30 - 0d3f
     0,17,17,17, 0, 0, 0, 0, 0, 0, 0, 0, 0,17, 0, 0,// 0d40 - 0d4f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0d50 - 0d5f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0d60 - 0d6f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0d70 - 0d7f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0d80 - 0d8f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0d90 - 0d9f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0da0 - 0daf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0db0 - 0dbf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0,17, 0, 0, 0, 0, 0,// 0dc0 - 0dcf
     0, 0,17,17,17, 0,17, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0dd0 - 0ddf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0de0 - 0def
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0df0 - 0dff

     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0e00 - 0e0f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0e10 - 0e1f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0e20 - 0e2f
     0,17, 0, 0,17,17,17,17,17,17,17, 0, 0, 0, 0, 4,// 0e30 - 0e3f
     0, 0, 0, 0, 0, 0, 0,17,17,17,17,17,17,17,17, 0,// 0e40 - 0e4f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0e50 - 0e5f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0e60 - 0e6f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0e70 - 0e7f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0e80 - 0e8f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0e90 - 0e9f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0ea0 - 0eaf
     0,17, 0, 0,17,17,17,17,17,17, 0,17,17, 0, 0, 0,// 0eb0 - 0ebf
     0, 0, 0, 0, 0, 0, 0, 0,17,17,17,17,17,17, 0, 0,// 0ec0 - 0ecf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0ed0 - 0edf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0ee0 - 0eef
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0ef0 - 0eff

     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0f00 - 0f0f
     0, 0, 0, 0, 0, 0, 0, 0,17,17, 0, 0, 0, 0, 0, 0,// 0f10 - 0f1f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0f20 - 0f2f
     0, 0, 0, 0, 0,17, 0,17, 0,17,10,10,10,10, 0, 0,// 0f30 - 0f3f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0f40 - 0f4f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0f50 - 0f5f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0f60 - 0f6f
     0,17,17,17,17,17,17,17,17,17,17,17,17,17,17, 0,// 0f70 - 0f7f
    17,17,17,17,17, 0,17,17, 0, 0, 0, 0, 0, 0, 0, 0,// 0f80 - 0f8f
    17,17,17,17,17,17,17,17, 0,17,17,17,17,17,17,17,// 0f90 - 0f9f
    17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,// 0fa0 - 0faf
    17,17,17,17,17,17,17,17,17,17,17,17,17, 0, 0, 0,// 0fb0 - 0fbf
     0, 0, 0, 0, 0, 0,17, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0fc0 - 0fcf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0fd0 - 0fdf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0fe0 - 0fef
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 0ff0 - 0fff

     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1000 - 100f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1010 - 101f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,17,17,17,// 1020 - 102f
    17, 0,17, 0, 0, 0,17,17, 0,17, 0, 0, 0, 0, 0, 0,// 1030 - 103f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1040 - 104f
     0, 0, 0, 0, 0, 0, 0, 0,17,17, 0, 0, 0, 0, 0, 0,// 1050 - 105f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1060 - 106f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1070 - 107f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1080 - 108f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1090 - 109f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 10a0 - 10af
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 10b0 - 10bf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 10c0 - 10cf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 10d0 - 10df
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 10e0 - 10ef
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 10f0 - 10ff

     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1600 - 160f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1610 - 161f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1620 - 162f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1630 - 163f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1640 - 164f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1650 - 165f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1660 - 166f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1670 - 167f
     9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1680 - 168f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,10, 0, 0, 0,// 1690 - 169f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 16a0 - 16af
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 16b0 - 16bf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 16c0 - 16cf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 16d0 - 16df
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 16e0 - 16ef
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 16f0 - 16ff

     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1700 - 170f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1710 - 171f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1720 - 172f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1730 - 173f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1740 - 174f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1750 - 175f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1760 - 176f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1770 - 177f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1780 - 178f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1790 - 179f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 17a0 - 17af
     0, 0, 0, 0, 0, 0, 0,17,17,17,17,17,17,17, 0, 0,// 17b0 - 17bf
     0, 0, 0, 0, 0, 0,17, 0, 0,17,17,17,17,17,17,17,// 17c0 - 17cf
    17,17,17,17, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0,// 17d0 - 17df
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 17e0 - 17ef
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 17f0 - 17ff

    10,10,10,10,10,10,10,10,10,10,10,18,18,18,18, 0,// 1800 - 180f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1810 - 181f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1820 - 182f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1830 - 183f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1840 - 184f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1850 - 185f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1860 - 186f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1870 - 187f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1880 - 188f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1890 - 189f
     0, 0, 0, 0, 0, 0, 0, 0, 0,17, 0, 0, 0, 0, 0, 0,// 18a0 - 18af
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 18b0 - 18bf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 18c0 - 18cf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 18d0 - 18df
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 18e0 - 18ef
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 18f0 - 18ff

     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1f00 - 1f0f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1f10 - 1f1f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1f20 - 1f2f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1f30 - 1f3f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1f40 - 1f4f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1f50 - 1f5f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1f60 - 1f6f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1f70 - 1f7f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1f80 - 1f8f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1f90 - 1f9f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 1fa0 - 1faf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10, 0,10,// 1fb0 - 1fbf
    10,10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,10,10,// 1fc0 - 1fcf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,10,10,// 1fd0 - 1fdf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,10,10,// 1fe0 - 1fef
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,10, 0,// 1ff0 - 1fff

     9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,18,18,18, 0, 1,// 2000 - 200f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2010 - 201f
    10,10,10,10,10,10,10,10, 9, 7,11,14,16,12,15, 9,// 2020 - 202f
     4, 4, 4, 4, 4,10,10,10,10,10,10,10,10,10,10,10,// 2030 - 203f
    10,10,10,10,10,10,10, 0,10,10,10,10,10,10, 0, 0,// 2040 - 204f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2050 - 205f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0,18,18,18,18,18,18,// 2060 - 206f
     2, 0, 0, 0, 2, 2, 2, 2, 2, 2, 4, 4,10,10,10, 0,// 2070 - 207f
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4,10,10,10, 0,// 2080 - 208f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2090 - 209f
     4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,// 20a0 - 20af
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 20b0 - 20bf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 20c0 - 20cf
    17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,// 20d0 - 20df
    17,17,17,17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 20e0 - 20ef
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 20f0 - 20ff

    10,10, 0,10,10,10,10, 0,10,10, 0, 0, 0, 0, 0, 0,// 2100 - 210f
     0, 0, 0, 0,10, 0,10,10,10, 0, 0, 0, 0, 0,10,10,// 2110 - 211f
    10,10,10,10, 0,10, 0,10, 0,10, 0, 0, 0, 0, 4, 0,// 2120 - 212f
     0, 0,10, 0, 0, 0, 0, 0, 0, 0,10, 0, 0, 0, 0, 0,// 2130 - 213f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2140 - 214f
     0, 0, 0,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2150 - 215f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2160 - 216f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2170 - 217f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2180 - 218f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2190 - 219f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 21a0 - 21af
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 21b0 - 21bf
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 21c0 - 21cf
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 21d0 - 21df
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 21e0 - 21ef
    10,10,10,10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 21f0 - 21ff

    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2200 - 220f
    10,10, 4, 4,10,10,10,10,10,10,10,10,10,10,10,10,// 2210 - 221f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2220 - 222f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2230 - 223f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2240 - 224f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2250 - 225f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2260 - 226f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2270 - 227f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2280 - 228f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2290 - 229f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 22a0 - 22af
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 22b0 - 22bf
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 22c0 - 22cf
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 22d0 - 22df
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 22e0 - 22ef
    10,10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 22f0 - 22ff

    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2300 - 230f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2310 - 231f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2320 - 232f
    10,10,10,10,10,10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2330 - 233f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2340 - 234f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2350 - 235f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2360 - 236f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10, 0,10,10,10,// 2370 - 237f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2380 - 238f
    10,10,10,10,10, 0,10,10,10,10,10, 0, 0, 0, 0, 0,// 2390 - 239f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 23a0 - 23af
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 23b0 - 23bf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 23c0 - 23cf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 23d0 - 23df
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 23e0 - 23ef
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 23f0 - 23ff

    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2400 - 240f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2410 - 241f
    10,10,10,10,10,10,10, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2420 - 242f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2430 - 243f
    10,10,10,10,10,10,10,10,10,10,10, 0, 0, 0, 0, 0,// 2440 - 244f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2450 - 245f
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,// 2460 - 246f
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,// 2470 - 247f
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,// 2480 - 248f
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0,// 2490 - 249f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 24a0 - 24af
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 24b0 - 24bf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 24c0 - 24cf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 24d0 - 24df
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0,// 24e0 - 24ef
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 24f0 - 24ff

    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2500 - 250f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2510 - 251f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2520 - 252f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2530 - 253f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2540 - 254f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2550 - 255f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2560 - 256f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2570 - 257f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2580 - 258f
    10,10,10,10,10,10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2590 - 259f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 25a0 - 25af
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 25b0 - 25bf
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 25c0 - 25cf
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 25d0 - 25df
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 25e0 - 25ef
    10,10,10,10,10,10,10,10, 0, 0, 0, 0, 0, 0, 0, 0,// 25f0 - 25ff

    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2600 - 260f
    10,10,10,10, 0, 0, 0, 0, 0,10,10,10,10,10,10,10,// 2610 - 261f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2620 - 262f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2630 - 263f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2640 - 264f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2650 - 265f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2660 - 266f
    10,10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2670 - 267f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2680 - 268f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2690 - 269f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 26a0 - 26af
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 26b0 - 26bf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 26c0 - 26cf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 26d0 - 26df
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 26e0 - 26ef
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 26f0 - 26ff

     0,10,10,10,10, 0,10,10,10,10, 0, 0,10,10,10,10,// 2700 - 270f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2710 - 271f
    10,10,10,10,10,10,10,10, 0,10,10,10,10,10,10,10,// 2720 - 272f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2730 - 273f
    10,10,10,10,10,10,10,10,10,10,10,10, 0,10, 0,10,// 2740 - 274f
    10,10,10, 0, 0, 0,10, 0,10,10,10,10,10,10,10, 0,// 2750 - 275f
     0,10,10,10,10,10,10,10, 0, 0, 0, 0, 0, 0, 0, 0,// 2760 - 276f
     0, 0, 0, 0, 0, 0,10,10,10,10,10,10,10,10,10,10,// 2770 - 277f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2780 - 278f
    10,10,10,10,10, 0, 0, 0,10,10,10,10,10,10,10,10,// 2790 - 279f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 27a0 - 27af
     0,10,10,10,10,10,10,10,10,10,10,10,10,10,10, 0,// 27b0 - 27bf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 27c0 - 27cf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 27d0 - 27df
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 27e0 - 27ef
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 27f0 - 27ff

     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2e00 - 2e0f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2e10 - 2e1f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2e20 - 2e2f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2e30 - 2e3f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2e40 - 2e4f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2e50 - 2e5f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2e60 - 2e6f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2e70 - 2e7f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2e80 - 2e8f
    10,10,10,10,10,10,10,10,10,10, 0,10,10,10,10,10,// 2e90 - 2e9f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2ea0 - 2eaf
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2eb0 - 2ebf
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2ec0 - 2ecf
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2ed0 - 2edf
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2ee0 - 2eef
    10,10,10,10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2ef0 - 2eff

    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2f00 - 2f0f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2f10 - 2f1f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2f20 - 2f2f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2f30 - 2f3f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2f40 - 2f4f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2f50 - 2f5f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2f60 - 2f6f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2f70 - 2f7f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2f80 - 2f8f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2f90 - 2f9f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2fa0 - 2faf
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2fb0 - 2fbf
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 2fc0 - 2fcf
    10,10,10,10,10,10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2fd0 - 2fdf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 2fe0 - 2fef
    10,10,10,10,10,10,10,10,10,10,10,10, 0, 0, 0, 0,// 2ff0 - 2fff

     9,10,10,10,10, 0, 0, 0,10,10,10,10,10,10,10,10,// 3000 - 300f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// 3010 - 301f
    10, 0, 0, 0, 0, 0, 0, 0, 0, 0,17,17,17,17,17,17,// 3020 - 302f
    10, 0, 0, 0, 0, 0,10,10, 0, 0, 0, 0, 0, 0,10,10,// 3030 - 303f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 3040 - 304f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 3050 - 305f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 3060 - 306f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 3070 - 307f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 3080 - 308f
     0, 0, 0, 0, 0, 0, 0, 0, 0,17,17,10,10, 0, 0, 0,// 3090 - 309f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 30a0 - 30af
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 30b0 - 30bf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 30c0 - 30cf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 30d0 - 30df
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// 30e0 - 30ef
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10, 0, 0, 0, 0,// 30f0 - 30ff

     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// a400 - a40f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// a410 - a41f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// a420 - a42f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// a430 - a43f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// a440 - a44f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// a450 - a45f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// a460 - a46f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// a470 - a47f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// a480 - a48f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// a490 - a49f
    10,10, 0, 0,10,10,10,10,10,10,10,10,10,10,10,10,// a4a0 - a4af
    10,10,10,10, 0,10,10,10,10,10,10,10,10,10,10,10,// a4b0 - a4bf
    10, 0,10,10,10, 0,10, 0, 0, 0, 0, 0, 0, 0, 0, 0,// a4c0 - a4cf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// a4d0 - a4df
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// a4e0 - a4ef
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// a4f0 - a4ff

     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// fb00 - fb0f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,17, 1,// fb10 - fb1f
     1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1,// fb20 - fb2f
     1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 0,// fb30 - fb3f
     1, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,// fb40 - fb4f
    13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,// fb50 - fb5f
    13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,// fb60 - fb6f
    13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,// fb70 - fb7f
    13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,// fb80 - fb8f
    13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,// fb90 - fb9f
    13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,// fba0 - fbaf
    13,13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// fbb0 - fbbf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// fbc0 - fbcf
     0, 0, 0,13,13,13,13,13,13,13,13,13,13,13,13,13,// fbd0 - fbdf
    13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,// fbe0 - fbef
    13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,// fbf0 - fbff

    13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,// fd00 - fd0f
    13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,// fd10 - fd1f
    13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,// fd20 - fd2f
    13,13,13,13,13,13,13,13,13,13,13,13,13,13,10,10,// fd30 - fd3f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// fd40 - fd4f
    13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,// fd50 - fd5f
    13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,// fd60 - fd6f
    13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,// fd70 - fd7f
    13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,// fd80 - fd8f
     0, 0,13,13,13,13,13,13,13,13,13,13,13,13,13,13,// fd90 - fd9f
    13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,// fda0 - fdaf
    13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,// fdb0 - fdbf
    13,13,13,13,13,13,13,13, 0, 0, 0, 0, 0, 0, 0, 0,// fdc0 - fdcf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// fdd0 - fddf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// fde0 - fdef
    13,13,13,13,13,13,13,13,13,13,13,13, 0, 0, 0, 0,// fdf0 - fdff

     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// fe00 - fe0f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// fe10 - fe1f
    17,17,17,17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// fe20 - fe2f
    10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,// fe30 - fe3f
    10,10,10,10,10, 0, 0, 0, 0,10,10,10,10,10,10,10,// fe40 - fe4f
     6,10, 6, 0,10, 6,10,10,10,10,10,10,10,10,10, 4,// fe50 - fe5f
    10,10, 4, 4,10,10,10, 0,10, 4, 4,10, 0, 0, 0, 0,// fe60 - fe6f
    13,13,13, 0,13, 0,13,13,13,13,13,13,13,13,13,13,// fe70 - fe7f
    13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,// fe80 - fe8f
    13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,// fe90 - fe9f
    13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,// fea0 - feaf
    13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,// feb0 - febf
    13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,// fec0 - fecf
    13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,// fed0 - fedf
    13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,// fee0 - feef
    13,13,13,13,13,13,13,13,13,13,13,13,13, 0, 0,18,// fef0 - feff

     0,10,10, 4, 4, 4,10,10,10,10,10, 4, 6, 4, 6, 3,// ff00 - ff0f
     2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 6,10,10,10,10,10,// ff10 - ff1f
    10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// ff20 - ff2f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,10,10,10,10,// ff30 - ff3f
    10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// ff40 - ff4f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,10,10,10, 0,// ff50 - ff5f
     0,10,10,10,10,10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// ff60 - ff6f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// ff70 - ff7f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// ff80 - ff8f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// ff90 - ff9f
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// ffa0 - ffaf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// ffb0 - ffbf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// ffc0 - ffcf
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,// ffd0 - ffdf
     4, 4,10,10,10, 4, 4, 0,10,10,10,10,10,10,10, 0,// ffe0 - ffef
     0, 0, 0, 0, 0, 0, 0, 0, 0,18,18,18,10,10, 0, 0,// fff0 - ffff

};


#define UnicodeScriptTypeFrom    0
#define UnicodeScriptTypeTo      1

static const sal_Unicode UnicodeScriptType[][2] = {
    {0x0000, 0x007f}, //  0. Basic Latin
    {0x0080, 0x00ff}, //  1. Latin-1 Supplement
    {0x0100, 0x017f}, //  2. Latin Extended-A
    {0x0180, 0x024f}, //  3. Latin Extended-B
    {0x0250, 0x02af}, //  4. IPA Extensions
    {0x02b0, 0x02ff}, //  5. Spacing Modifier Letters
    {0x0300, 0x036f}, //  6. Combining Diacritical Marks
    {0x0370, 0x03ff}, //  7. Greek
    {0x0400, 0x04ff}, //  8. Cyrillic
    {0x0530, 0x058f}, //  9. Armenian
    {0x0590, 0x05ff}, // 10. Hebrew
    {0x0600, 0x06ff}, // 11. Arabic
    {0x0700, 0x074f}, // 12. Syriac
    {0x0780, 0x07bf}, // 13. Thaana
    {0x0900, 0x097f}, // 14. Devanagari
    {0x0980, 0x09ff}, // 15. Bengali
    {0x0a00, 0x0a7f}, // 16. Gurmukhi
    {0x0a80, 0x0aff}, // 17. Gujarati
    {0x0b00, 0x0b7f}, // 18. Odia
    {0x0b80, 0x0bff}, // 19. Tamil
    {0x0c00, 0x0c7f}, // 20. Telugu
    {0x0c80, 0x0cff}, // 21. Kannada
    {0x0d00, 0x0d7f}, // 22. Malayalam
    {0x0d80, 0x0dff}, // 23. Sinhala
    {0x0e00, 0x0e7f}, // 24. Thai
    {0x0e80, 0x0eff}, // 25. Lao
    {0x0f00, 0x0fff}, // 26. Tibetan
    {0x1000, 0x109f}, // 27. Myanmar
    {0x10a0, 0x10ff}, // 28. Georgian
    {0x1100, 0x11ff}, // 29. Hangul Jamo
    {0x1200, 0x137f}, // 30. Ethiopic
    {0x13a0, 0x13ff}, // 31. Cherokee
    {0x1400, 0x167f}, // 32. Unified Canadian Aboriginal Syllabics
    {0x1680, 0x169f}, // 33. Ogham
    {0x16a0, 0x16ff}, // 34. Runic
    {0x1780, 0x17ff}, // 35. Khmer
    {0x1800, 0x18af}, // 36. Mongolian
    {0x1e00, 0x1eff}, // 37. Latin Extended Additional
    {0x1f00, 0x1fff}, // 38. Greek Extended
    {0x2000, 0x206f}, // 39. General Punctuation
    {0x2070, 0x209f}, // 40. Superscripts and Subscripts
    {0x20a0, 0x20cf}, // 41. Currency Symbols
    {0x20d0, 0x20ff}, // 42. Combining Marks for Symbols
    {0x2100, 0x214f}, // 43. Letterlike Symbols
    {0x2150, 0x218f}, // 44. Number Forms
    {0x2190, 0x21ff}, // 45. Arrows
    {0x2200, 0x22ff}, // 46. Mathematical Operators
    {0x2300, 0x23ff}, // 47. Miscellaneous Technical
    {0x2400, 0x243f}, // 48. Control Pictures
    {0x2440, 0x245f}, // 49. Optical Character Recognition
    {0x2460, 0x24ff}, // 50. Enclosed Alphanumerics
    {0x2500, 0x257f}, // 51. Box Drawing
    {0x2580, 0x259f}, // 52. Block Elements
    {0x25a0, 0x25ff}, // 53. Geometric Shapes
    {0x2600, 0x26ff}, // 54. Miscellaneous Symbols
    {0x2700, 0x27bf}, // 55. Dingbats
    {0x2800, 0x28ff}, // 56. Braille Patterns
    {0x2e80, 0x2eff}, // 57. CJK Radicals Supplement
    {0x2f00, 0x2fdf}, // 58. Kangxi Radicals
    {0x2ff0, 0x2fff}, // 59. Ideographic Description Characters
    {0x3000, 0x303f}, // 60. CJK Symbols and Punctuation
    {0x3040, 0x309f}, // 61. Hiragana
    {0x30a0, 0x30ff}, // 62. Katakana
    {0x3100, 0x312f}, // 63. Bopomofo
    {0x3130, 0x318f}, // 64. Hangul Compatibility Jamo
    {0x3190, 0x319f}, // 65. Kanbun
    {0x31a0, 0x31bf}, // 66. Bopomofo Extended
    {0x3200, 0x32ff}, // 67. Enclosed CJK Letters and Months
    {0x3300, 0x33ff}, // 68. CJK Compatibility
    {0x3400, 0x4db5}, // 69. CJK Unified Ideographs Extension A
    {0x4e00, 0x9fff}, // 70. CJK Unified Ideographs
    {0xa000, 0xa48f}, // 71. Yi Syllables
    {0xa490, 0xa4cf}, // 72. Yi Radicals
    {0xac00, 0xd7a3}, // 73. Hangul Syllables
    {0xd800, 0xdb7f}, // 74. High Surrogates
    {0xdb80, 0xdbff}, // 75. High Private Use Surrogates
    {0xdc00, 0xdfff}, // 76. Low Surrogates
    {0xe000, 0xf8ff}, // 77. Private Use
    {0xf900, 0xfaff}, // 78. CJK Compatibility Ideographs
    {0xfb00, 0xfb4f}, // 79. Alphabetic Presentation Forms
    {0xfb50, 0xfdff}, // 80. Arabic Presentation Forms-A
    {0xfe20, 0xfe2f}, // 81. Combining Half Marks
    {0xfe30, 0xfe4f}, // 82. CJK Compatibility Forms
    {0xfe50, 0xfe6f}, // 83. Small Form Variants
    {0xfe70, 0xfefe}, // 84. Arabic Presentation Forms-B
    {0xfeff, 0xfeff}, // 85. kNoScript
    {0xff00, 0xffef}, // 85. Halfwidth and Fullwidth Forms
};

#endif

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
