/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

//as seen at http://www.microsoft.com/typography/otspec/name.htm

#ifndef INCLUDED_I18NLANGTAG_APPLELANGID_H
#define INCLUDED_I18NLANGTAG_APPLELANGID_H

#include <i18nlangtag/languagetag.hxx>

typedef unsigned short AppleLanguageId;

/** Init LanguageTag with Apple LanguageId */
I18NLANGTAG_DLLPUBLIC LanguageTag makeLanguageTagFromAppleLanguageId(AppleLanguageId nLanguage);

#define APPLE_LANG_ENGLISH 0
#define APPLE_LANG_FRENCH 1
#define APPLE_LANG_GERMAN 2
#define APPLE_LANG_ITALIAN 3
#define APPLE_LANG_DUTCH 4
#define APPLE_LANG_SWEDISH 5
#define APPLE_LANG_SPANISH 6
#define APPLE_LANG_DANISH 7
#define APPLE_LANG_PORTUGUESE 8
#define APPLE_LANG_NORWEGIAN 9
#define APPLE_LANG_HEBREW 10
#define APPLE_LANG_JAPANESE 11
#define APPLE_LANG_ARABIC 12
#define APPLE_LANG_FINNISH 13
#define APPLE_LANG_GREEK 14
#define APPLE_LANG_ICELANDIC 15
#define APPLE_LANG_MALTESE 16
#define APPLE_LANG_TURKISH 17
#define APPLE_LANG_CROATIAN 18
#define APPLE_LANG_CHINESE_TRADITIONAL 19
#define APPLE_LANG_URDU 20
#define APPLE_LANG_HINDI 21
#define APPLE_LANG_THAI 22
#define APPLE_LANG_KOREAN 23
#define APPLE_LANG_LITHUANIAN 24
#define APPLE_LANG_POLISH 25
#define APPLE_LANG_HUNGARIAN 26
#define APPLE_LANG_ESTONIAN 27
#define APPLE_LANG_LATVIAN 28
#define APPLE_LANG_SAMI 29
#define APPLE_LANG_FAROESE 30
#define APPLE_LANG_FARSI 31
#define APPLE_LANG_RUSSIAN 32
#define APPLE_LANG_CHINESE_SIMPLIFIED 33
#define APPLE_LANG_FLEMISH 34
#define APPLE_LANG_IRISH_GAELIC 35
#define APPLE_LANG_ALBANIAN 36
#define APPLE_LANG_ROMANIAN 37
#define APPLE_LANG_CZECH 38
#define APPLE_LANG_SLOVAK 39
#define APPLE_LANG_SLOVENIAN 40
#define APPLE_LANG_YIDDISH 41
#define APPLE_LANG_SERBIAN 42
#define APPLE_LANG_MACEDONIAN 43
#define APPLE_LANG_BULGARIAN 44
#define APPLE_LANG_UKRAINIAN 45
#define APPLE_LANG_BYELORUSSIAN 46
#define APPLE_LANG_UZBEK 47
#define APPLE_LANG_KAZAKH 48
#define APPLE_LANG_AZERI_CYRILLIC 49
#define APPLE_LANG_AZERI_ARABIC 50
#define APPLE_LANG_ARMENIAN 51
#define APPLE_LANG_GEORGIAN 52
#define APPLE_LANG_MOLDAVIAN 53
#define APPLE_LANG_KIRGHIZ 54
#define APPLE_LANG_TAJIKI 55
#define APPLE_LANG_TURKMEN 56
#define APPLE_LANG_MONGOLIAN_MONGOLIAN 57
#define APPLE_LANG_MONGOLIAN_CYRILLIC 58
#define APPLE_LANG_PASHTO 59
#define APPLE_LANG_KURDISH 60
#define APPLE_LANG_KASHMIRI 61
#define APPLE_LANG_SINDHI 62
#define APPLE_LANG_TIBETAN 63
#define APPLE_LANG_NEPALI 64
#define APPLE_LANG_SANSKRIT 65
#define APPLE_LANG_MARATHI 66
#define APPLE_LANG_BENGALI 67
#define APPLE_LANG_ASSAMESE 68
#define APPLE_LANG_GUJARATI 69
#define APPLE_LANG_PUNJABI 70
#define APPLE_LANG_ORIYA 71
#define APPLE_LANG_MALAYALAM 72
#define APPLE_LANG_KANNADA 73
#define APPLE_LANG_TAMIL 74
#define APPLE_LANG_TELUGU 75
#define APPLE_LANG_SINHALESE 76
#define APPLE_LANG_BURMESE 77
#define APPLE_LANG_KHMER 78
#define APPLE_LANG_LAO 79
#define APPLE_LANG_VIETNAMESE 80
#define APPLE_LANG_INDONESIAN 81
#define APPLE_LANG_TAGALONG 82
#define APPLE_LANG_MALAY_LATIN 83
#define APPLE_LANG_MALAY_ARABIC 84
#define APPLE_LANG_AMHARIC 85
#define APPLE_LANG_TIGRINYA 86
#define APPLE_LANG_GALLA 87
#define APPLE_LANG_SOMALI 88
#define APPLE_LANG_SWAHILI 89
#define APPLE_LANG_KINYARWANDA 90
#define APPLE_LANG_RUNDI 91
#define APPLE_LANG_NYANJA 92
#define APPLE_LANG_MALAGASY 93
#define APPLE_LANG_ESPERANTO 94
#define APPLE_LANG_WELSH 128
#define APPLE_LANG_BASQUE 129
#define APPLE_LANG_CATALAN 130
#define APPLE_LANG_LATIN 131
#define APPLE_LANG_QUENCHUA 132
#define APPLE_LANG_GUARANI 133
#define APPLE_LANG_AYMARA 134
#define APPLE_LANG_TATAR 135
#define APPLE_LANG_UIGHUR 136
#define APPLE_LANG_DZONGKHA 137
#define APPLE_LANG_JAVANESE_LATIN 138
#define APPLE_LANG_SUNDANESE_LATIN 139
#define APPLE_LANG_GALICIAN 140
#define APPLE_LANG_AFRIKAANS 141
#define APPLE_LANG_BRETON 142
#define APPLE_LANG_INUKTITUT 143
#define APPLE_LANG_SCOTTISH_GAELIC 144
#define APPLE_LANG_MANX_GAELIC 145
#define APPLE_LANG_IRISH_GAELIC_WITH_DOT_ABOVE 146
#define APPLE_LANG_TONGAN 147
#define APPLE_LANG_GREEK_POLYTONIC 148
#define APPLE_LANG_GREENLANDIC 149
#define APPLE_LANG_AZERI_LATIN 150

#endif /* INCLUDED_I18NLANGTAG_APPLELANGID_H */

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
