/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.xml.ParserException;
import org.apache.lucene.search.Query;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.SolrCoreParser;
import org.apache.solr.search.SyntaxError;

public class XmlQParserPlugin
extends QParserPlugin {
    public static final String NAME = "xmlparser";
    private NamedList args;

    @Override
    public void init(NamedList args) {
        super.init(args);
        this.args = args;
    }

    @Override
    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return new XmlQParser(qstr, localParams, params, req);
    }

    private class XmlQParser
    extends QParser {
        public XmlQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
            super(qstr, localParams, params, req);
        }

        @Override
        public Query parse() throws SyntaxError {
            String qstr = this.getString();
            if (qstr == null || qstr.isEmpty()) {
                return null;
            }
            IndexSchema schema = this.req.getSchema();
            String defaultField = QueryParsing.getDefaultField(schema, this.getParam("df"));
            Analyzer analyzer = schema.getQueryAnalyzer();
            SolrCoreParser solrParser = new SolrCoreParser(defaultField, analyzer, this.req);
            solrParser.init(XmlQParserPlugin.this.args);
            try {
                return solrParser.parse(new ByteArrayInputStream(qstr.getBytes(StandardCharsets.UTF_8)));
            }
            catch (ParserException e) {
                throw new SyntaxError(e.getMessage() + " in " + this.req.toString());
            }
        }
    }
}

