/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.wav;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.logging.Logger;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.CannotWriteException;
import org.jaudiotagger.audio.generic.TagWriter;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.iff.ChunkHeader;
import org.jaudiotagger.audio.iff.IffHeaderChunk;
import org.jaudiotagger.audio.wav.WavChunkType;
import org.jaudiotagger.audio.wav.WavSaveOptions;
import org.jaudiotagger.audio.wav.WavTagReader;
import org.jaudiotagger.audio.wav.chunk.WavInfoIdentifier;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.TagTextField;
import org.jaudiotagger.tag.id3.AbstractID3Tag;
import org.jaudiotagger.tag.id3.AbstractID3v2Tag;
import org.jaudiotagger.tag.wav.WavInfoTag;
import org.jaudiotagger.tag.wav.WavTag;

public class WavTagWriter
implements TagWriter {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.Wav");

    private WavTag getExistingMetadata(RandomAccessFile raf) throws IOException, CannotWriteException {
        try {
            WavTagReader im = new WavTagReader();
            return im.read(raf);
        }
        catch (CannotReadException ex) {
            throw new CannotWriteException("Failed to read file");
        }
    }

    private ChunkHeader seekToStartOfListInfoMetadata(RandomAccessFile raf, WavTag existingTag) throws IOException, CannotWriteException {
        raf.seek(existingTag.getInfoTag().getStartLocationInFile());
        ChunkHeader chunkHeader = new ChunkHeader(ByteOrder.LITTLE_ENDIAN);
        chunkHeader.readHeader(raf);
        raf.seek(raf.getFilePointer() - 8L);
        if (!WavChunkType.LIST.getCode().equals(chunkHeader.getID())) {
            throw new CannotWriteException("Unable to find List chunk at original location has file been modified externally");
        }
        return chunkHeader;
    }

    private ChunkHeader seekToStartOfId3Metadata(RandomAccessFile raf, WavTag existingTag) throws IOException, CannotWriteException {
        raf.seek(existingTag.getStartLocationInFileOfId3Chunk());
        ChunkHeader chunkHeader = new ChunkHeader(ByteOrder.LITTLE_ENDIAN);
        chunkHeader.readHeader(raf);
        raf.seek(raf.getFilePointer() - 8L);
        if (!WavChunkType.ID3.getCode().equals(chunkHeader.getID())) {
            throw new CannotWriteException("Unable to find ID3 chunk at original location has file been modified externally");
        }
        return chunkHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Tag tag, RandomAccessFile raf, RandomAccessFile tempRaf) throws IOException, CannotWriteException {
        logger.info("Deleting metadata from file");
        WavTag existingTag = this.getExistingMetadata(raf);
        try {
            if (existingTag.isExistingId3Tag() && existingTag.isExistingInfoTag()) {
                BothTagsFileStructure fs = this.checkExistingLocations(existingTag, raf);
                if (fs.isContiguous) {
                    if (fs.isAtEnd) {
                        if (fs.isInfoTagFirst) {
                            logger.info("Setting new length to:" + existingTag.getInfoTag().getStartLocationInFile());
                            raf.setLength(existingTag.getInfoTag().getStartLocationInFile());
                        } else {
                            logger.info("Setting new length to:" + existingTag.getStartLocationInFileOfId3Chunk());
                            raf.setLength(existingTag.getStartLocationInFileOfId3Chunk());
                        }
                    } else if (fs.isInfoTagFirst) {
                        int lengthTagChunk = (int)(existingTag.getEndLocationInFileOfId3Chunk() - existingTag.getInfoTag().getStartLocationInFile());
                        this.deleteTagChunk(raf, (int)existingTag.getEndLocationInFileOfId3Chunk(), lengthTagChunk);
                    } else {
                        int lengthTagChunk = (int)((long)existingTag.getInfoTag().getEndLocationInFile().intValue() - existingTag.getStartLocationInFileOfId3Chunk());
                        this.deleteTagChunk(raf, existingTag.getInfoTag().getEndLocationInFile().intValue(), lengthTagChunk);
                    }
                } else {
                    WavInfoTag existingInfoTag = existingTag.getInfoTag();
                    ChunkHeader infoChunkHeader = this.seekToStartOfListInfoMetadata(raf, existingTag);
                    AbstractID3v2Tag existingID3Tag = existingTag.getID3Tag();
                    ChunkHeader id3ChunkHeader = this.seekToStartOfId3Metadata(raf, existingTag);
                    if (existingInfoTag.getEndLocationInFile().longValue() == raf.length()) {
                        raf.setLength(existingInfoTag.getStartLocationInFile());
                        this.deleteId3TagChunk(raf, existingTag, id3ChunkHeader);
                    } else if (existingID3Tag.getEndLocationInFile().longValue() == raf.length()) {
                        raf.setLength(existingTag.getStartLocationInFileOfId3Chunk());
                        this.deleteInfoTagChunk(raf, existingTag, infoChunkHeader);
                    } else {
                        this.deleteId3TagChunk(raf, existingTag, id3ChunkHeader);
                        existingTag = this.getExistingMetadata(raf);
                        this.deleteInfoTagChunk(raf, existingTag, infoChunkHeader);
                    }
                }
            } else if (existingTag.isExistingInfoTag()) {
                WavInfoTag existingInfoTag = existingTag.getInfoTag();
                ChunkHeader chunkHeader = this.seekToStartOfListInfoMetadata(raf, existingTag);
                if (existingInfoTag.getEndLocationInFile().longValue() == raf.length()) {
                    logger.info("Setting new length to:" + existingInfoTag.getStartLocationInFile());
                    raf.setLength(existingInfoTag.getStartLocationInFile());
                } else {
                    this.deleteInfoTagChunk(raf, existingTag, chunkHeader);
                }
            } else if (existingTag.isExistingId3Tag()) {
                AbstractID3v2Tag existingID3Tag = existingTag.getID3Tag();
                ChunkHeader chunkHeader = this.seekToStartOfId3Metadata(raf, existingTag);
                if (existingID3Tag.getEndLocationInFile().longValue() == raf.length()) {
                    logger.info("Setting new length to:" + existingTag.getStartLocationInFileOfId3Chunk());
                    raf.setLength(existingTag.getStartLocationInFileOfId3Chunk());
                } else {
                    this.deleteId3TagChunk(raf, existingTag, chunkHeader);
                }
            }
        }
        finally {
            this.rewriteRiffHeaderSize(raf);
        }
    }

    private void deleteInfoTagChunk(RandomAccessFile raf, WavTag existingTag, ChunkHeader chunkHeader) throws IOException {
        WavInfoTag existingInfoTag = existingTag.getInfoTag();
        int lengthTagChunk = (int)chunkHeader.getSize() + 8;
        this.deleteTagChunk(raf, existingInfoTag.getEndLocationInFile().intValue(), lengthTagChunk);
    }

    private void deleteId3TagChunk(RandomAccessFile raf, WavTag existingTag, ChunkHeader chunkHeader) throws IOException {
        int lengthTagChunk = (int)chunkHeader.getSize() + 8;
        this.deleteTagChunk(raf, (int)existingTag.getEndLocationInFileOfId3Chunk(), lengthTagChunk);
    }

    private void deleteTagChunk(RandomAccessFile raf, int endOfExistingChunk, int lengthTagChunk) throws IOException {
        raf.seek(endOfExistingChunk);
        FileChannel channel = raf.getChannel();
        ByteBuffer buffer = ByteBuffer.allocate((int)TagOptionSingleton.getInstance().getWriteChunkSize());
        while (channel.read(buffer) >= 0 || buffer.position() != 0) {
            buffer.flip();
            long readPosition = channel.position();
            channel.position(readPosition - (long)lengthTagChunk - (long)buffer.limit());
            channel.write(buffer);
            channel.position(readPosition);
            buffer.compact();
        }
        long newLength = raf.length() - (long)lengthTagChunk;
        logger.config("Setting new length to:" + newLength);
        raf.setLength(newLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(AudioFile af, Tag tag, RandomAccessFile raf, RandomAccessFile rafTemp) throws CannotWriteException, IOException {
        logger.info("Writing tag to file");
        WavSaveOptions wso = TagOptionSingleton.getInstance().getWavSaveOptions();
        WavTag existingTag = this.getExistingMetadata(raf);
        try {
            WavTag wavTag = (WavTag)tag;
            if (wso == WavSaveOptions.SAVE_BOTH) {
                this.saveBoth(wavTag, raf, existingTag);
            } else if (wso == WavSaveOptions.SAVE_ACTIVE) {
                this.saveActive(wavTag, raf, existingTag);
            } else if (wso == WavSaveOptions.SAVE_EXISTING_AND_ACTIVE) {
                this.saveActiveExisting(wavTag, raf, existingTag);
            } else {
                throw new RuntimeException("No setting for:WavSaveOptions");
            }
            this.rewriteRiffHeaderSize(raf);
        }
        finally {
            raf.close();
        }
    }

    private void rewriteRiffHeaderSize(RandomAccessFile raf) throws IOException {
        raf.seek(IffHeaderChunk.SIGNATURE_LENGTH);
        raf.write(Utils.getSizeLEInt32((int)raf.length() - IffHeaderChunk.SIGNATURE_LENGTH - IffHeaderChunk.SIZE_LENGTH));
    }

    private void writeInfoDataToFile(RandomAccessFile raf, ByteBuffer bb, long chunkSize) throws IOException {
        ByteBuffer listBuffer = ByteBuffer.allocate(8);
        listBuffer.order(ByteOrder.LITTLE_ENDIAN);
        listBuffer.put(WavChunkType.LIST.getCode().getBytes(StandardCharsets.US_ASCII));
        listBuffer.putInt((int)chunkSize);
        listBuffer.flip();
        raf.getChannel().write(listBuffer);
        raf.getChannel().write(bb);
    }

    private void writeID3DataToFile(RandomAccessFile raf, ByteBuffer bb, long chunkSize) throws IOException {
        ByteBuffer listBuffer = ByteBuffer.allocate(8);
        listBuffer.order(ByteOrder.LITTLE_ENDIAN);
        listBuffer.put(WavChunkType.ID3.getCode().getBytes(StandardCharsets.US_ASCII));
        listBuffer.putInt((int)chunkSize);
        listBuffer.flip();
        raf.getChannel().write(listBuffer);
        raf.getChannel().write(bb);
    }

    private void writePaddingToFile(RandomAccessFile raf, int paddingSize) throws IOException {
        raf.write(new byte[paddingSize]);
    }

    public ByteBuffer convertInfoChunk(WavTag tag) throws UnsupportedEncodingException {
        try {
            byte[] contentConvertedToBytes;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            WavInfoTag wif = tag.getInfoTag();
            Iterator<TagField> i = wif.getFields();
            while (i.hasNext()) {
                TagTextField next = (TagTextField)i.next();
                WavInfoIdentifier wii = WavInfoIdentifier.getByByFieldKey(FieldKey.valueOf(next.getId()));
                baos.write(wii.getCode().getBytes(StandardCharsets.US_ASCII));
                logger.config("Writing:" + wii.getCode() + ":" + next.getContent());
                contentConvertedToBytes = next.getContent().getBytes(StandardCharsets.UTF_8);
                baos.write(Utils.getSizeLEInt32(contentConvertedToBytes.length));
                baos.write(contentConvertedToBytes);
                if ((contentConvertedToBytes.length & 1) == 0) continue;
                baos.write(0);
            }
            for (TagTextField next : wif.getUnrecognisedFields()) {
                baos.write(next.getId().getBytes(StandardCharsets.US_ASCII));
                logger.config("Writing:" + next.getId() + ":" + next.getContent());
                contentConvertedToBytes = next.getContent().getBytes(StandardCharsets.UTF_8);
                baos.write(Utils.getSizeLEInt32(contentConvertedToBytes.length));
                baos.write(contentConvertedToBytes);
                if ((contentConvertedToBytes.length & 1) == 0) continue;
                baos.write(0);
            }
            ByteBuffer infoBuffer = ByteBuffer.wrap(baos.toByteArray());
            infoBuffer.rewind();
            ByteBuffer infoHeaderBuffer = ByteBuffer.allocate(IffHeaderChunk.SIGNATURE_LENGTH);
            infoHeaderBuffer.put(WavChunkType.INFO.getCode().getBytes(StandardCharsets.US_ASCII));
            infoHeaderBuffer.flip();
            ByteBuffer listInfoBuffer = ByteBuffer.allocateDirect(infoHeaderBuffer.limit() + infoBuffer.limit());
            listInfoBuffer.put(infoHeaderBuffer);
            listInfoBuffer.put(infoBuffer);
            listInfoBuffer.flip();
            return listInfoBuffer;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public ByteBuffer convertID3Chunk(WavTag tag) throws UnsupportedEncodingException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            tag.getID3Tag().write(baos);
            ByteBuffer buf = ByteBuffer.wrap(baos.toByteArray());
            buf.rewind();
            return buf;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private BothTagsFileStructure checkExistingLocations(WavTag wavTag, RandomAccessFile raf) throws IOException {
        BothTagsFileStructure fs = new BothTagsFileStructure();
        if (wavTag.getInfoTag().getStartLocationInFile() < wavTag.getID3Tag().getStartLocationInFile()) {
            fs.isInfoTagFirst = true;
            if (Math.abs(wavTag.getInfoTag().getEndLocationInFile() - wavTag.getID3Tag().getStartLocationInFile()) <= 1L) {
                fs.isContiguous = true;
                if (wavTag.getID3Tag().getEndLocationInFile().longValue() == raf.length()) {
                    fs.isAtEnd = true;
                }
            }
        } else if (Math.abs(wavTag.getID3Tag().getEndLocationInFile() - wavTag.getInfoTag().getStartLocationInFile()) <= 1L) {
            fs.isContiguous = true;
            if (wavTag.getInfoTag().getEndLocationInFile().longValue() == raf.length()) {
                fs.isAtEnd = true;
            }
        }
        return fs;
    }

    private void writeInfoChunk(RandomAccessFile raf, WavInfoTag existingInfoTag, ByteBuffer newTagBuffer) throws CannotWriteException, IOException {
        long newInfoTagSize = newTagBuffer.limit();
        if (existingInfoTag.getSizeOfTag() >= newInfoTagSize) {
            this.writeInfoDataToFile(raf, newTagBuffer, existingInfoTag.getSizeOfTag());
            if (existingInfoTag.getSizeOfTag() > newInfoTagSize) {
                this.writePaddingToFile(raf, (int)(existingInfoTag.getSizeOfTag() - newInfoTagSize));
            }
        } else {
            this.writeInfoDataToFile(raf, newTagBuffer, newInfoTagSize);
        }
    }

    private void writeId3Chunk(RandomAccessFile raf, AbstractID3Tag existingTag, ByteBuffer newTagBuffer) throws CannotWriteException, IOException {
        long newId3TagSize = newTagBuffer.limit();
        if ((long)existingTag.getSize() >= newId3TagSize) {
            this.writeID3DataToFile(raf, newTagBuffer, existingTag.getSize());
            if ((long)existingTag.getSize() > newId3TagSize) {
                this.writePaddingToFile(raf, (int)((long)existingTag.getSize() - newId3TagSize));
            }
        } else {
            this.writeID3DataToFile(raf, newTagBuffer, newId3TagSize);
        }
    }

    private void seekAndWriteInfoChunk(RandomAccessFile raf, WavTag existingTag, ByteBuffer newTagBuffer) throws CannotWriteException, IOException {
        ChunkHeader infoChunkHeader = this.seekToStartOfListInfoMetadata(raf, existingTag);
        if (existingTag.getInfoTag().getEndLocationInFile().longValue() == raf.length()) {
            this.writeInfoChunk(raf, existingTag.getInfoTag(), newTagBuffer);
        } else {
            this.deleteInfoTagChunk(raf, existingTag, infoChunkHeader);
            raf.seek(raf.length());
            this.writeInfoDataToFile(raf, newTagBuffer, newTagBuffer.limit());
        }
    }

    private void seekAndWriteId3Chunk(RandomAccessFile raf, WavTag existingTag, ByteBuffer newTagBuffer) throws CannotWriteException, IOException {
        ChunkHeader id3ChunkHeader = this.seekToStartOfId3Metadata(raf, existingTag);
        if (existingTag.getID3Tag().getEndLocationInFile().longValue() == raf.length()) {
            this.writeId3Chunk(raf, existingTag.getID3Tag(), newTagBuffer);
        } else {
            this.deleteInfoTagChunk(raf, existingTag, id3ChunkHeader);
            raf.seek(raf.length());
            this.writeID3DataToFile(raf, newTagBuffer, newTagBuffer.limit());
        }
    }

    private void saveBoth(WavTag wavTag, RandomAccessFile raf, WavTag existingTag) throws CannotWriteException, IOException {
        ByteBuffer infoTagBuffer = this.convertInfoChunk(wavTag);
        long newInfoTagSize = infoTagBuffer.limit();
        WavInfoTag existingInfoTag = existingTag.getInfoTag();
        ByteBuffer id3TagBuffer = this.convertID3Chunk(wavTag);
        AbstractID3v2Tag existingId3Tag = existingTag.getID3Tag();
        if (existingTag.isExistingInfoTag() && existingTag.isExistingId3Tag()) {
            BothTagsFileStructure fs = this.checkExistingLocations(wavTag, raf);
            if (fs.isContiguous && fs.isAtEnd) {
                if (fs.isInfoTagFirst) {
                    this.seekToStartOfListInfoMetadata(raf, existingTag);
                    this.writeInfoChunk(raf, existingInfoTag, infoTagBuffer);
                    this.writeId3Chunk(raf, existingId3Tag, id3TagBuffer);
                } else {
                    this.seekToStartOfId3Metadata(raf, existingTag);
                    this.writeId3Chunk(raf, existingId3Tag, id3TagBuffer);
                    this.writeInfoChunk(raf, existingInfoTag, infoTagBuffer);
                }
            } else {
                raf.seek(raf.length());
                this.writeInfoDataToFile(raf, infoTagBuffer, newInfoTagSize);
                this.writeId3Chunk(raf, existingId3Tag, id3TagBuffer);
            }
        } else if (existingTag.isExistingInfoTag() && !existingTag.isExistingId3Tag()) {
            ChunkHeader infoChunkHeader = this.seekToStartOfListInfoMetadata(raf, existingTag);
            if (existingInfoTag.getEndLocationInFile().longValue() == raf.length()) {
                this.writeInfoChunk(raf, existingInfoTag, infoTagBuffer);
                this.writeId3Chunk(raf, existingId3Tag, id3TagBuffer);
            } else {
                this.deleteInfoTagChunk(raf, existingTag, infoChunkHeader);
                raf.seek(raf.length());
                this.writeInfoDataToFile(raf, infoTagBuffer, newInfoTagSize);
                this.writeId3Chunk(raf, existingId3Tag, id3TagBuffer);
            }
        } else if (!existingTag.isExistingInfoTag() && existingTag.isExistingId3Tag()) {
            ChunkHeader id3ChunkHeader = this.seekToStartOfId3Metadata(raf, existingTag);
            if (existingId3Tag.getEndLocationInFile().longValue() == raf.length()) {
                this.writeId3Chunk(raf, existingId3Tag, id3TagBuffer);
                this.writeInfoChunk(raf, existingInfoTag, infoTagBuffer);
            } else {
                this.deleteId3TagChunk(raf, existingTag, id3ChunkHeader);
                raf.seek(raf.length());
                this.writeId3Chunk(raf, existingId3Tag, id3TagBuffer);
                this.writeInfoDataToFile(raf, infoTagBuffer, newInfoTagSize);
            }
        } else {
            raf.seek(raf.length());
            this.writeInfoDataToFile(raf, infoTagBuffer, newInfoTagSize);
            this.writeId3Chunk(raf, existingId3Tag, id3TagBuffer);
        }
    }

    private void saveActive(WavTag wavTag, RandomAccessFile raf, WavTag existingTag) throws CannotWriteException, IOException {
        if (wavTag.getActiveTag() instanceof WavInfoTag) {
            ByteBuffer infoTagBuffer = this.convertInfoChunk(wavTag);
            long newInfoTagSize = infoTagBuffer.limit();
            if (existingTag.isExistingId3Tag()) {
                ChunkHeader id3ChunkHeader = this.seekToStartOfId3Metadata(raf, existingTag);
                if (existingTag.getEndLocationInFileOfId3Chunk() == raf.length()) {
                    raf.setLength(existingTag.getStartLocationInFileOfId3Chunk());
                    raf.seek(raf.length());
                    this.writeInfoDataToFile(raf, infoTagBuffer, newInfoTagSize);
                } else {
                    this.deleteId3TagChunk(raf, existingTag, id3ChunkHeader);
                    raf.seek(raf.length());
                    this.writeInfoDataToFile(raf, infoTagBuffer, newInfoTagSize);
                }
            } else if (existingTag.isExistingInfoTag()) {
                this.seekAndWriteInfoChunk(raf, existingTag, infoTagBuffer);
            } else {
                raf.seek(raf.length());
                this.writeInfoDataToFile(raf, infoTagBuffer, newInfoTagSize);
            }
        } else {
            ByteBuffer id3TagBuffer = this.convertID3Chunk(wavTag);
            long newInfoTagSize = id3TagBuffer.limit();
            if (existingTag.isExistingInfoTag()) {
                ChunkHeader infoChunkHeader = this.seekToStartOfListInfoMetadata(raf, existingTag);
                if (existingTag.getInfoTag().getEndLocationInFile().longValue() == raf.length()) {
                    raf.setLength(existingTag.getInfoTag().getStartLocationInFile());
                    raf.seek(raf.length());
                    this.writeID3DataToFile(raf, id3TagBuffer, newInfoTagSize);
                } else {
                    this.deleteInfoTagChunk(raf, existingTag, infoChunkHeader);
                    raf.seek(raf.length());
                    this.writeID3DataToFile(raf, id3TagBuffer, newInfoTagSize);
                }
            } else if (existingTag.isExistingId3Tag()) {
                this.seekAndWriteId3Chunk(raf, existingTag, id3TagBuffer);
            } else {
                raf.seek(raf.length());
                this.writeID3DataToFile(raf, id3TagBuffer, newInfoTagSize);
            }
        }
    }

    private void saveActiveExisting(WavTag wavTag, RandomAccessFile raf, WavTag existingTag) throws CannotWriteException, IOException {
        if (wavTag.getActiveTag() instanceof WavInfoTag) {
            if (existingTag.isExistingId3Tag()) {
                this.saveBoth(wavTag, raf, existingTag);
            } else {
                this.saveActive(wavTag, raf, existingTag);
            }
        } else if (existingTag.isExistingInfoTag()) {
            this.saveBoth(wavTag, raf, existingTag);
        } else {
            this.saveActive(wavTag, raf, existingTag);
        }
    }

    class BothTagsFileStructure {
        boolean isInfoTagFirst = false;
        boolean isContiguous = false;
        boolean isAtEnd = false;

        BothTagsFileStructure() {
        }
    }
}

