/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.aiff;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.util.logging.Logger;
import org.jaudiotagger.audio.aiff.AiffAudioHeader;
import org.jaudiotagger.audio.aiff.AiffFileHeader;
import org.jaudiotagger.audio.aiff.chunk.AiffChunkReader;
import org.jaudiotagger.audio.aiff.chunk.AnnotationChunk;
import org.jaudiotagger.audio.aiff.chunk.ApplicationChunk;
import org.jaudiotagger.audio.aiff.chunk.AuthorChunk;
import org.jaudiotagger.audio.aiff.chunk.ChunkType;
import org.jaudiotagger.audio.aiff.chunk.CommentsChunk;
import org.jaudiotagger.audio.aiff.chunk.CommonChunk;
import org.jaudiotagger.audio.aiff.chunk.CopyrightChunk;
import org.jaudiotagger.audio.aiff.chunk.FormatVersionChunk;
import org.jaudiotagger.audio.aiff.chunk.NameChunk;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.generic.GenericAudioHeader;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.iff.Chunk;
import org.jaudiotagger.audio.iff.ChunkHeader;
import org.jaudiotagger.audio.iff.IffHeaderChunk;
import org.jaudiotagger.logging.Hex;

public class AiffInfoReader
extends AiffChunkReader {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.aiff");

    protected GenericAudioHeader read(RandomAccessFile raf) throws CannotReadException, IOException {
        logger.config("Reading AIFF file size:" + raf.length() + " (" + Hex.asHex(raf.length()) + ")");
        AiffAudioHeader aiffAudioHeader = new AiffAudioHeader();
        AiffFileHeader fileHeader = new AiffFileHeader();
        fileHeader.readHeader(raf, aiffAudioHeader);
        while (raf.getFilePointer() < raf.length()) {
            if (this.readChunk(raf, aiffAudioHeader)) continue;
            logger.severe("UnableToReadProcessChunk");
            break;
        }
        this.calculateBitRate(aiffAudioHeader);
        return aiffAudioHeader;
    }

    private void calculateBitRate(GenericAudioHeader info) throws CannotReadException {
        if (info.getAudioDataLength() != null) {
            info.setBitRate((int)Math.round((double)(info.getAudioDataLength() * (long)Utils.BITS_IN_BYTE_MULTIPLIER) / (info.getPreciseTrackLength() * (double)Utils.KILOBYTE_MULTIPLIER)));
        }
    }

    private boolean readChunk(RandomAccessFile raf, AiffAudioHeader aiffAudioHeader) throws IOException {
        ChunkHeader chunkHeader = new ChunkHeader(ByteOrder.BIG_ENDIAN);
        if (!chunkHeader.readHeader(raf)) {
            return false;
        }
        logger.info("Reading Chunk:" + chunkHeader.getID() + ":starting at:" + chunkHeader.getStartLocationInFile() + ":sizeIncHeader:" + (chunkHeader.getSize() + 8L));
        Chunk chunk = this.createChunk(raf, chunkHeader, aiffAudioHeader);
        if (chunk != null) {
            if (!chunk.readChunk()) {
                logger.severe("ChunkReadFail:" + chunkHeader.getID());
                return false;
            }
        } else {
            raf.skipBytes((int)chunkHeader.getSize());
        }
        IffHeaderChunk.ensureOnEqualBoundary(raf, chunkHeader);
        return true;
    }

    private Chunk createChunk(RandomAccessFile raf, ChunkHeader chunkHeader, AiffAudioHeader aiffAudioHeader) throws IOException {
        Chunk chunk;
        ChunkType chunkType = ChunkType.get(chunkHeader.getID());
        if (chunkType != null) {
            switch (chunkType) {
                case FORMAT_VERSION: {
                    chunk = new FormatVersionChunk(chunkHeader, this.readChunkDataIntoBuffer(raf, chunkHeader), aiffAudioHeader);
                    break;
                }
                case APPLICATION: {
                    chunk = new ApplicationChunk(chunkHeader, this.readChunkDataIntoBuffer(raf, chunkHeader), aiffAudioHeader);
                    break;
                }
                case COMMON: {
                    chunk = new CommonChunk(chunkHeader, this.readChunkDataIntoBuffer(raf, chunkHeader), aiffAudioHeader);
                    break;
                }
                case COMMENTS: {
                    chunk = new CommentsChunk(chunkHeader, this.readChunkDataIntoBuffer(raf, chunkHeader), aiffAudioHeader);
                    break;
                }
                case NAME: {
                    chunk = new NameChunk(chunkHeader, this.readChunkDataIntoBuffer(raf, chunkHeader), aiffAudioHeader);
                    break;
                }
                case AUTHOR: {
                    chunk = new AuthorChunk(chunkHeader, this.readChunkDataIntoBuffer(raf, chunkHeader), aiffAudioHeader);
                    break;
                }
                case COPYRIGHT: {
                    chunk = new CopyrightChunk(chunkHeader, this.readChunkDataIntoBuffer(raf, chunkHeader), aiffAudioHeader);
                    break;
                }
                case ANNOTATION: {
                    chunk = new AnnotationChunk(chunkHeader, this.readChunkDataIntoBuffer(raf, chunkHeader), aiffAudioHeader);
                    break;
                }
                case SOUND: {
                    aiffAudioHeader.setAudioDataLength(chunkHeader.getSize());
                    aiffAudioHeader.setAudioDataStartPosition(raf.getFilePointer());
                    aiffAudioHeader.setAudioDataEndPosition(raf.getFilePointer() + chunkHeader.getSize());
                    chunk = null;
                    break;
                }
                default: {
                    chunk = null;
                    break;
                }
            }
        } else {
            chunk = null;
        }
        return chunk;
    }
}

