/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.text.NumberFormat;
import net.arnx.jsonic.Formatter;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.StringFormatter;
import net.arnx.jsonic.io.OutputSource;

final class DoubleArrayFormatter
implements Formatter {
    public static final DoubleArrayFormatter INSTANCE = new DoubleArrayFormatter();

    DoubleArrayFormatter() {
    }

    @Override
    public boolean accept(Object o) {
        return o instanceof double[];
    }

    @Override
    public boolean isStruct() {
        return true;
    }

    @Override
    public void format(JSON.Context context, Object src, Object o, OutputSource out) throws Exception {
        NumberFormat f = context.getNumberFormat();
        double[] array = (double[])o;
        out.append('[');
        for (int i = 0; i < array.length; ++i) {
            if (Double.isNaN(array[i]) || Double.isInfinite(array[i])) {
                if (context.getMode() != JSON.Mode.SCRIPT) {
                    out.append('\"');
                    out.append(Double.toString(array[i]));
                    out.append('\"');
                } else if (Double.isNaN(array[i])) {
                    out.append("Number.NaN");
                } else {
                    out.append("Number.");
                    out.append(array[i] > 0.0 ? "POSITIVE" : "NEGATIVE");
                    out.append("_INFINITY");
                }
            } else if (f != null) {
                StringFormatter.serialize(context, f.format(array[i]), out);
            } else {
                out.append(String.valueOf(array[i]));
            }
            if (i == array.length - 1) continue;
            out.append(',');
            if (!context.isPrettyPrint()) continue;
            out.append(' ');
        }
        out.append(']');
    }
}

