/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWakeLockSentinel.h"

#include "ActiveDOMObject.h"
#include "DOMPromiseProxy.h"
#include "EventNames.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "JSWakeLockType.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsWakeLockSentinelPrototypeFunction_release);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsWakeLockSentinelConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWakeLockSentinel_released);
static JSC_DECLARE_CUSTOM_GETTER(jsWakeLockSentinel_type);
static JSC_DECLARE_CUSTOM_GETTER(jsWakeLockSentinel_onrelease);
static JSC_DECLARE_CUSTOM_SETTER(setJSWakeLockSentinel_onrelease);

class JSWakeLockSentinelPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWakeLockSentinelPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWakeLockSentinelPrototype* ptr = new (NotNull, JSC::allocateCell<JSWakeLockSentinelPrototype>(vm)) JSWakeLockSentinelPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWakeLockSentinelPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWakeLockSentinelPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWakeLockSentinelPrototype, JSWakeLockSentinelPrototype::Base);

using JSWakeLockSentinelDOMConstructor = JSDOMConstructorNotConstructable<JSWakeLockSentinel>;

template<> const ClassInfo JSWakeLockSentinelDOMConstructor::s_info = { "WakeLockSentinel"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWakeLockSentinelDOMConstructor) };

template<> JSValue JSWakeLockSentinelDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSWakeLockSentinelDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "WakeLockSentinel"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSWakeLockSentinel::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSWakeLockSentinelPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWakeLockSentinelConstructor, 0 } },
    { "released"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWakeLockSentinel_released, 0 } },
    { "type"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWakeLockSentinel_type, 0 } },
    { "onrelease"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWakeLockSentinel_onrelease, setJSWakeLockSentinel_onrelease } },
    { "release"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWakeLockSentinelPrototypeFunction_release, 0 } },
};

const ClassInfo JSWakeLockSentinelPrototype::s_info = { "WakeLockSentinel"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWakeLockSentinelPrototype) };

void JSWakeLockSentinelPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWakeLockSentinel::info(), JSWakeLockSentinelPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWakeLockSentinel::s_info = { "WakeLockSentinel"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWakeLockSentinel) };

JSWakeLockSentinel::JSWakeLockSentinel(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WakeLockSentinel>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

Ref<WakeLockSentinel> JSWakeLockSentinel::protectedWrapped() const
{
    return wrapped();
}

static_assert(std::is_base_of<ActiveDOMObject, WakeLockSentinel>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSWakeLockSentinel::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWakeLockSentinelPrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSWakeLockSentinelPrototype::create(vm, &globalObject, structure);
}

JSObject* JSWakeLockSentinel::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWakeLockSentinel>(vm, globalObject);
}

JSValue JSWakeLockSentinel::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWakeLockSentinelDOMConstructor, DOMConstructorID::WakeLockSentinel>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsWakeLockSentinelConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWakeLockSentinelPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWakeLockSentinel::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsWakeLockSentinel_releasedGetter(JSGlobalObject& lexicalGlobalObject, JSWakeLockSentinel& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.released())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWakeLockSentinel_released, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWakeLockSentinel>::get<jsWakeLockSentinel_releasedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWakeLockSentinel_typeGetter(JSGlobalObject& lexicalGlobalObject, JSWakeLockSentinel& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<WakeLockType>>(lexicalGlobalObject, throwScope, impl.type())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWakeLockSentinel_type, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWakeLockSentinel>::get<jsWakeLockSentinel_typeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWakeLockSentinel_onreleaseGetter(JSGlobalObject& lexicalGlobalObject, JSWakeLockSentinel& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().releaseEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsWakeLockSentinel_onrelease, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWakeLockSentinel>::get<jsWakeLockSentinel_onreleaseGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSWakeLockSentinel_onreleaseSetter(JSGlobalObject& lexicalGlobalObject, JSWakeLockSentinel& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().releaseEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSWakeLockSentinel_onrelease, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSWakeLockSentinel>::set<setJSWakeLockSentinel_onreleaseSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsWakeLockSentinelPrototypeFunction_releaseBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSWakeLockSentinel>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLUndefined>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.release(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWakeLockSentinelPrototypeFunction_release, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSWakeLockSentinel>::call<jsWakeLockSentinelPrototypeFunction_releaseBody>(*lexicalGlobalObject, *callFrame, "release");
}

JSC::GCClient::IsoSubspace* JSWakeLockSentinel::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWakeLockSentinel, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWakeLockSentinel.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWakeLockSentinel = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWakeLockSentinel.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWakeLockSentinel = std::forward<decltype(space)>(space); }
    );
}

void JSWakeLockSentinel::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWakeLockSentinel*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSWakeLockSentinelOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    SUPPRESS_UNCOUNTED_LOCAL auto* jsWakeLockSentinel = jsCast<JSWakeLockSentinel*>(handle.slot()->asCell());
    auto& wrapped = jsWakeLockSentinel->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity"_s;
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSWakeLockSentinelOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWakeLockSentinel = static_cast<JSWakeLockSentinel*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsWakeLockSentinel->protectedWrapped().ptr(), jsWakeLockSentinel);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WakeLockSentinel@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore16WakeLockSentinelE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, WakeLockSentinel>, void>> static inline void verifyVTable(WakeLockSentinel* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7WakeLockSentinel@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore16WakeLockSentinelE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // WakeLockSentinel has subclasses. If WakeLockSentinel has subclasses that get passed
        // to toJS() we currently require WakeLockSentinel you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WakeLockSentinel>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<WakeLockSentinel>(impl.ptr());
#endif
    return createWrapper<WakeLockSentinel>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WakeLockSentinel& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WakeLockSentinel* JSWakeLockSentinel::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWakeLockSentinel*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
