/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSStorageManager.h"

#include "ActiveDOMObject.h"
#include "DOMPromiseProxy.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWindowBase.h"
#include "JSDOMWrapperCache.h"
#include "JSFileSystemDirectoryHandle.h"
#include "ScriptExecutionContext.h"
#include "StorageManagerFileSystemAccess.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const StorageManager::Estimate& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLUnsignedLongLong::isNullValue(dictionary.quota)) {
        auto quotaValue = toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, IDLUnsignedLongLong::extractValueFromNullable(dictionary.quota));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "quota"_s), quotaValue);
    }
    if (!IDLUnsignedLongLong::isNullValue(dictionary.usage)) {
        auto usageValue = toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, IDLUnsignedLongLong::extractValueFromNullable(dictionary.usage));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "usage"_s), usageValue);
    }
    return result;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsStorageManagerPrototypeFunction_persisted);
static JSC_DECLARE_HOST_FUNCTION(jsStorageManagerPrototypeFunction_persist);
static JSC_DECLARE_HOST_FUNCTION(jsStorageManagerPrototypeFunction_estimate);
static JSC_DECLARE_HOST_FUNCTION(jsStorageManagerPrototypeFunction_getDirectory);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsStorageManagerConstructor);

class JSStorageManagerPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSStorageManagerPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSStorageManagerPrototype* ptr = new (NotNull, JSC::allocateCell<JSStorageManagerPrototype>(vm)) JSStorageManagerPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSStorageManagerPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSStorageManagerPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSStorageManagerPrototype, JSStorageManagerPrototype::Base);

using JSStorageManagerDOMConstructor = JSDOMConstructorNotConstructable<JSStorageManager>;

template<> const ClassInfo JSStorageManagerDOMConstructor::s_info = { "StorageManager"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSStorageManagerDOMConstructor) };

template<> JSValue JSStorageManagerDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSStorageManagerDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "StorageManager"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSStorageManager::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSStorageManagerPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsStorageManagerConstructor, 0 } },
    { "persisted"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsStorageManagerPrototypeFunction_persisted, 0 } },
    { "persist"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsStorageManagerPrototypeFunction_persist, 0 } },
    { "estimate"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsStorageManagerPrototypeFunction_estimate, 0 } },
    { "getDirectory"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsStorageManagerPrototypeFunction_getDirectory, 0 } },
};

const ClassInfo JSStorageManagerPrototype::s_info = { "StorageManager"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSStorageManagerPrototype) };

void JSStorageManagerPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSStorageManager::info(), JSStorageManagerPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!(globalObject())->inherits<JSDOMWindowBase>()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "persist"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().storageAPIEstimateEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "estimate"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().fileSystemAccessEnabled)) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "getDirectory"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSStorageManager::s_info = { "StorageManager"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSStorageManager) };

JSStorageManager::JSStorageManager(Structure* structure, JSDOMGlobalObject& globalObject, Ref<StorageManager>&& impl)
    : JSDOMWrapper<StorageManager>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, StorageManager>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSStorageManager::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSStorageManagerPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSStorageManagerPrototype::create(vm, &globalObject, structure);
}

JSObject* JSStorageManager::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSStorageManager>(vm, globalObject);
}

JSValue JSStorageManager::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSStorageManagerDOMConstructor, DOMConstructorID::StorageManager>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSStorageManager::destroy(JSC::JSCell* cell)
{
    JSStorageManager* thisObject = static_cast<JSStorageManager*>(cell);
    thisObject->JSStorageManager::~JSStorageManager();
}

JSC_DEFINE_CUSTOM_GETTER(jsStorageManagerConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSStorageManagerPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSStorageManager::getConstructor(vm, prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsStorageManagerPrototypeFunction_persistedBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSStorageManager>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLBoolean>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.persisted(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsStorageManagerPrototypeFunction_persisted, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSStorageManager>::call<jsStorageManagerPrototypeFunction_persistedBody>(*lexicalGlobalObject, *callFrame, "persisted");
}

static inline JSC::EncodedJSValue jsStorageManagerPrototypeFunction_persistBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSStorageManager>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLBoolean>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.persist(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsStorageManagerPrototypeFunction_persist, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSStorageManager>::call<jsStorageManagerPrototypeFunction_persistBody>(*lexicalGlobalObject, *callFrame, "persist");
}

static inline JSC::EncodedJSValue jsStorageManagerPrototypeFunction_estimateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSStorageManager>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLDictionary<StorageManager::Estimate>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.estimate(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsStorageManagerPrototypeFunction_estimate, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSStorageManager>::call<jsStorageManagerPrototypeFunction_estimateBody>(*lexicalGlobalObject, *callFrame, "estimate");
}

static inline JSC::EncodedJSValue jsStorageManagerPrototypeFunction_getDirectoryBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSStorageManager>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLInterface<FileSystemDirectoryHandle>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return WebCore::StorageManagerFileSystemAccess::getDirectory(impl, WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsStorageManagerPrototypeFunction_getDirectory, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSStorageManager>::call<jsStorageManagerPrototypeFunction_getDirectoryBody>(*lexicalGlobalObject, *callFrame, "getDirectory");
}

JSC::GCClient::IsoSubspace* JSStorageManager::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSStorageManager, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForStorageManager.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForStorageManager = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForStorageManager.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForStorageManager = std::forward<decltype(space)>(space); }
    );
}

void JSStorageManager::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSStorageManager*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSStorageManagerOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSStorageManagerOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsStorageManager = static_cast<JSStorageManager*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsStorageManager->protectedWrapped().ptr(), jsStorageManager);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7StorageManager@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore14StorageManagerE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, StorageManager>, void>> static inline void verifyVTable(StorageManager* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7StorageManager@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore14StorageManagerE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // StorageManager has subclasses. If StorageManager has subclasses that get passed
        // to toJS() we currently require StorageManager you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<StorageManager>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<StorageManager>(impl.ptr());
#endif
    return createWrapper<StorageManager>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, StorageManager& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

StorageManager* JSStorageManager::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSStorageManager*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
