/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGScriptElement.h"

#include "ActiveDOMObject.h"
#include "ElementInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSSVGAnimatedString.h"
#include "SVGNames.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsSVGScriptElementConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGScriptElement_type);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGScriptElement_type);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGScriptElement_href);

class JSSVGScriptElementPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSVGScriptElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGScriptElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGScriptElementPrototype>(vm)) JSSVGScriptElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGScriptElementPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGScriptElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGScriptElementPrototype, JSSVGScriptElementPrototype::Base);

using JSSVGScriptElementDOMConstructor = JSDOMConstructorNotConstructable<JSSVGScriptElement>;

template<> const ClassInfo JSSVGScriptElementDOMConstructor::s_info = { "SVGScriptElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGScriptElementDOMConstructor) };

template<> JSValue JSSVGScriptElementDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSSVGElement::getConstructor(vm, &globalObject);
}

template<> void JSSVGScriptElementDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "SVGScriptElement"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSSVGScriptElement::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSSVGScriptElementPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGScriptElementConstructor, 0 } },
    { "type"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGScriptElement_type, setJSSVGScriptElement_type } },
    { "href"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGScriptElement_href, 0 } },
};

const ClassInfo JSSVGScriptElementPrototype::s_info = { "SVGScriptElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGScriptElementPrototype) };

void JSSVGScriptElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGScriptElement::info(), JSSVGScriptElementPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSSVGScriptElement::s_info = { "SVGScriptElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGScriptElement) };

JSSVGScriptElement::JSSVGScriptElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGScriptElement>&& impl)
    : JSSVGElement(structure, globalObject, WTFMove(impl))
{
}

Ref<SVGScriptElement> JSSVGScriptElement::protectedWrapped() const
{
    return wrapped();
}

JSObject* JSSVGScriptElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSSVGScriptElementPrototype::createStructure(vm, &globalObject, JSSVGElement::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSSVGScriptElementPrototype::create(vm, &globalObject, structure);
}

JSObject* JSSVGScriptElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSVGScriptElement>(vm, globalObject);
}

JSValue JSSVGScriptElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGScriptElementDOMConstructor, DOMConstructorID::SVGScriptElement>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGScriptElementConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGScriptElementPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSVGScriptElement::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsSVGScriptElement_typeGetter(JSGlobalObject& lexicalGlobalObject, JSSVGScriptElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::SVGNames::typeAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGScriptElement_type, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGScriptElement>::get<jsSVGScriptElement_typeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGScriptElement_typeSetter(JSGlobalObject& lexicalGlobalObject, JSSVGScriptElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::SVGNames::typeAttr, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGScriptElement_type, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGScriptElement>::set<setJSSVGScriptElement_typeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGScriptElement_hrefGetter(JSGlobalObject& lexicalGlobalObject, JSSVGScriptElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGAnimatedString>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.hrefAnimated())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGScriptElement_href, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGScriptElement>::get<jsSVGScriptElement_hrefGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSSVGScriptElement::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSSVGScriptElement, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForSVGScriptElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForSVGScriptElement = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForSVGScriptElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForSVGScriptElement = std::forward<decltype(space)>(space); }
    );
}

void JSSVGScriptElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSVGScriptElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}


}
