/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSPushSubscriptionJSON.h"

#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertRecord.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMGlobalObject.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <wtf/Vector.h>


namespace WebCore {
using namespace JSC;

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const PushSubscriptionJSON& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLUSVString::isNullValue(dictionary.endpoint)) {
        auto endpointValue = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, IDLUSVString::extractValueFromNullable(dictionary.endpoint));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "endpoint"_s), endpointValue);
    }
    if (!IDLNullable<IDLUnsignedLongLong>::isNullValue(dictionary.expirationTime)) {
        auto expirationTimeValue = toJS<IDLNullable<IDLUnsignedLongLong>>(lexicalGlobalObject, throwScope, IDLNullable<IDLUnsignedLongLong>::extractValueFromNullable(dictionary.expirationTime));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "expirationTime"_s), expirationTimeValue);
    }
    if (!IDLRecord<IDLDOMString, IDLUSVString>::isNullValue(dictionary.keys)) {
        auto keysValue = toJS<IDLRecord<IDLDOMString, IDLUSVString>>(lexicalGlobalObject, globalObject, throwScope, IDLRecord<IDLDOMString, IDLUSVString>::extractValueFromNullable(dictionary.keys));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "keys"_s), keysValue);
    }
    return result;
}

} // namespace WebCore
