/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCORPViolationReportBody.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSFetchRequestDestination.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsCORPViolationReportBodyPrototypeFunction_toJSON);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsCORPViolationReportBody_disposition);
static JSC_DECLARE_CUSTOM_GETTER(jsCORPViolationReportBody_type);
static JSC_DECLARE_CUSTOM_GETTER(jsCORPViolationReportBody_blockedURL);
static JSC_DECLARE_CUSTOM_GETTER(jsCORPViolationReportBody_destination);

class JSCORPViolationReportBodyPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCORPViolationReportBodyPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCORPViolationReportBodyPrototype* ptr = new (NotNull, JSC::allocateCell<JSCORPViolationReportBodyPrototype>(vm)) JSCORPViolationReportBodyPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCORPViolationReportBodyPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCORPViolationReportBodyPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCORPViolationReportBodyPrototype, JSCORPViolationReportBodyPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSCORPViolationReportBodyPrototypeTableValues[] =
{
    { "disposition"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCORPViolationReportBody_disposition, 0 } },
    { "type"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCORPViolationReportBody_type, 0 } },
    { "blockedURL"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCORPViolationReportBody_blockedURL, 0 } },
    { "destination"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCORPViolationReportBody_destination, 0 } },
    { "toJSON"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCORPViolationReportBodyPrototypeFunction_toJSON, 0 } },
};

const ClassInfo JSCORPViolationReportBodyPrototype::s_info = { "CORPViolationReportBody"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCORPViolationReportBodyPrototype) };

void JSCORPViolationReportBodyPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCORPViolationReportBody::info(), JSCORPViolationReportBodyPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSCORPViolationReportBody::s_info = { "CORPViolationReportBody"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCORPViolationReportBody) };

JSCORPViolationReportBody::JSCORPViolationReportBody(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CORPViolationReportBody>&& impl)
    : JSReportBody(structure, globalObject, WTFMove(impl))
{
}

Ref<CORPViolationReportBody> JSCORPViolationReportBody::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, CORPViolationReportBody>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSCORPViolationReportBody::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSCORPViolationReportBodyPrototype::createStructure(vm, &globalObject, JSReportBody::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSCORPViolationReportBodyPrototype::create(vm, &globalObject, structure);
}

JSObject* JSCORPViolationReportBody::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCORPViolationReportBody>(vm, globalObject);
}

static inline JSValue jsCORPViolationReportBody_dispositionGetter(JSGlobalObject& lexicalGlobalObject, JSCORPViolationReportBody& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.disposition())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCORPViolationReportBody_disposition, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCORPViolationReportBody>::get<jsCORPViolationReportBody_dispositionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsCORPViolationReportBody_typeGetter(JSGlobalObject& lexicalGlobalObject, JSCORPViolationReportBody& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.type())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCORPViolationReportBody_type, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCORPViolationReportBody>::get<jsCORPViolationReportBody_typeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsCORPViolationReportBody_blockedURLGetter(JSGlobalObject& lexicalGlobalObject, JSCORPViolationReportBody& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.blockedURL())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCORPViolationReportBody_blockedURL, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCORPViolationReportBody>::get<jsCORPViolationReportBody_blockedURLGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsCORPViolationReportBody_destinationGetter(JSGlobalObject& lexicalGlobalObject, JSCORPViolationReportBody& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<FetchRequestDestination>>(lexicalGlobalObject, throwScope, impl.destination())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCORPViolationReportBody_destination, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCORPViolationReportBody>::get<jsCORPViolationReportBody_destinationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline EncodedJSValue jsCORPViolationReportBodyPrototypeFunction_toJSONBody(JSGlobalObject* lexicalGlobalObject, CallFrame*, JSCORPViolationReportBody* castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto* result = constructEmptyObject(lexicalGlobalObject);
    auto dispositionValue = toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.disposition());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "disposition"_s), dispositionValue);
    auto typeValue = toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.type());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "type"_s), typeValue);
    auto blockedURLValue = toJS<IDLUSVString>(*lexicalGlobalObject, throwScope, impl.blockedURL());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "blockedURL"_s), blockedURLValue);
    auto destinationValue = toJS<IDLEnumeration<FetchRequestDestination>>(*lexicalGlobalObject, throwScope, impl.destination());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "destination"_s), destinationValue);
    return JSValue::encode(result);
}

JSC_DEFINE_HOST_FUNCTION(jsCORPViolationReportBodyPrototypeFunction_toJSON, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCORPViolationReportBody>::call<jsCORPViolationReportBodyPrototypeFunction_toJSONBody>(*lexicalGlobalObject, *callFrame, "toJSON");
}

JSC::GCClient::IsoSubspace* JSCORPViolationReportBody::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSCORPViolationReportBody, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForCORPViolationReportBody.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForCORPViolationReportBody = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForCORPViolationReportBody.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForCORPViolationReportBody = std::forward<decltype(space)>(space); }
    );
}

void JSCORPViolationReportBody::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCORPViolationReportBody*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}


}
