/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGRadialGradientElement.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSSVGAnimatedLength.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsSVGRadialGradientElementConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGRadialGradientElement_cx);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGRadialGradientElement_cy);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGRadialGradientElement_r);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGRadialGradientElement_fx);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGRadialGradientElement_fy);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGRadialGradientElement_fr);

class JSSVGRadialGradientElementPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSVGRadialGradientElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGRadialGradientElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGRadialGradientElementPrototype>(vm)) JSSVGRadialGradientElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGRadialGradientElementPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGRadialGradientElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGRadialGradientElementPrototype, JSSVGRadialGradientElementPrototype::Base);

using JSSVGRadialGradientElementDOMConstructor = JSDOMConstructorNotConstructable<JSSVGRadialGradientElement>;

template<> const ClassInfo JSSVGRadialGradientElementDOMConstructor::s_info = { "SVGRadialGradientElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGRadialGradientElementDOMConstructor) };

template<> JSValue JSSVGRadialGradientElementDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSSVGGradientElement::getConstructor(vm, &globalObject);
}

template<> void JSSVGRadialGradientElementDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "SVGRadialGradientElement"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSSVGRadialGradientElement::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSSVGRadialGradientElementPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGRadialGradientElementConstructor, 0 } },
    { "cx"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGRadialGradientElement_cx, 0 } },
    { "cy"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGRadialGradientElement_cy, 0 } },
    { "r"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGRadialGradientElement_r, 0 } },
    { "fx"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGRadialGradientElement_fx, 0 } },
    { "fy"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGRadialGradientElement_fy, 0 } },
    { "fr"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGRadialGradientElement_fr, 0 } },
};

const ClassInfo JSSVGRadialGradientElementPrototype::s_info = { "SVGRadialGradientElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGRadialGradientElementPrototype) };

void JSSVGRadialGradientElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGRadialGradientElement::info(), JSSVGRadialGradientElementPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSSVGRadialGradientElement::s_info = { "SVGRadialGradientElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGRadialGradientElement) };

JSSVGRadialGradientElement::JSSVGRadialGradientElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGRadialGradientElement>&& impl)
    : JSSVGGradientElement(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSSVGRadialGradientElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSSVGRadialGradientElementPrototype::createStructure(vm, &globalObject, JSSVGGradientElement::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSSVGRadialGradientElementPrototype::create(vm, &globalObject, structure);
}

JSObject* JSSVGRadialGradientElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSVGRadialGradientElement>(vm, globalObject);
}

JSValue JSSVGRadialGradientElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGRadialGradientElementDOMConstructor, DOMConstructorID::SVGRadialGradientElement>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGRadialGradientElementConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGRadialGradientElementPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSVGRadialGradientElement::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsSVGRadialGradientElement_cxGetter(JSGlobalObject& lexicalGlobalObject, JSSVGRadialGradientElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGAnimatedLength>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.cxAnimated())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGRadialGradientElement_cx, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGRadialGradientElement>::get<jsSVGRadialGradientElement_cxGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGRadialGradientElement_cyGetter(JSGlobalObject& lexicalGlobalObject, JSSVGRadialGradientElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGAnimatedLength>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.cyAnimated())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGRadialGradientElement_cy, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGRadialGradientElement>::get<jsSVGRadialGradientElement_cyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGRadialGradientElement_rGetter(JSGlobalObject& lexicalGlobalObject, JSSVGRadialGradientElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGAnimatedLength>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.rAnimated())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGRadialGradientElement_r, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGRadialGradientElement>::get<jsSVGRadialGradientElement_rGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGRadialGradientElement_fxGetter(JSGlobalObject& lexicalGlobalObject, JSSVGRadialGradientElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGAnimatedLength>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.fxAnimated())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGRadialGradientElement_fx, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGRadialGradientElement>::get<jsSVGRadialGradientElement_fxGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGRadialGradientElement_fyGetter(JSGlobalObject& lexicalGlobalObject, JSSVGRadialGradientElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGAnimatedLength>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.fyAnimated())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGRadialGradientElement_fy, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGRadialGradientElement>::get<jsSVGRadialGradientElement_fyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGRadialGradientElement_frGetter(JSGlobalObject& lexicalGlobalObject, JSSVGRadialGradientElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGAnimatedLength>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.frAnimated())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGRadialGradientElement_fr, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGRadialGradientElement>::get<jsSVGRadialGradientElement_frGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSSVGRadialGradientElement::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSSVGRadialGradientElement, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForSVGRadialGradientElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForSVGRadialGradientElement = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForSVGRadialGradientElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForSVGRadialGradientElement = std::forward<decltype(space)>(space); }
    );
}

void JSSVGRadialGradientElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSVGRadialGradientElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}
