/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SERVICE_WORKER)

#include "JSPushMessageData.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSBlob.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsPushMessageDataPrototypeFunction_arrayBuffer);
static JSC_DECLARE_HOST_FUNCTION(jsPushMessageDataPrototypeFunction_blob);
static JSC_DECLARE_HOST_FUNCTION(jsPushMessageDataPrototypeFunction_json);
static JSC_DECLARE_HOST_FUNCTION(jsPushMessageDataPrototypeFunction_text);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsPushMessageDataConstructor);

class JSPushMessageDataPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSPushMessageDataPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSPushMessageDataPrototype* ptr = new (NotNull, JSC::allocateCell<JSPushMessageDataPrototype>(vm)) JSPushMessageDataPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSPushMessageDataPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSPushMessageDataPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSPushMessageDataPrototype, JSPushMessageDataPrototype::Base);

using JSPushMessageDataDOMConstructor = JSDOMConstructorNotConstructable<JSPushMessageData>;

template<> const ClassInfo JSPushMessageDataDOMConstructor::s_info = { "PushMessageData"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPushMessageDataDOMConstructor) };

template<> JSValue JSPushMessageDataDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSPushMessageDataDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "PushMessageData"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSPushMessageData::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSPushMessageDataPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPushMessageDataConstructor, 0 } },
    { "arrayBuffer"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsPushMessageDataPrototypeFunction_arrayBuffer, 0 } },
    { "blob"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsPushMessageDataPrototypeFunction_blob, 0 } },
    { "json"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsPushMessageDataPrototypeFunction_json, 0 } },
    { "text"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsPushMessageDataPrototypeFunction_text, 0 } },
};

const ClassInfo JSPushMessageDataPrototype::s_info = { "PushMessageData"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPushMessageDataPrototype) };

void JSPushMessageDataPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSPushMessageData::info(), JSPushMessageDataPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSPushMessageData::s_info = { "PushMessageData"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPushMessageData) };

JSPushMessageData::JSPushMessageData(Structure* structure, JSDOMGlobalObject& globalObject, Ref<PushMessageData>&& impl)
    : JSDOMWrapper<PushMessageData>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, PushMessageData>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSPushMessageData::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSPushMessageDataPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSPushMessageDataPrototype::create(vm, &globalObject, structure);
}

JSObject* JSPushMessageData::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSPushMessageData>(vm, globalObject);
}

JSValue JSPushMessageData::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPushMessageDataDOMConstructor, DOMConstructorID::PushMessageData>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSPushMessageData::destroy(JSC::JSCell* cell)
{
    JSPushMessageData* thisObject = static_cast<JSPushMessageData*>(cell);
    thisObject->JSPushMessageData::~JSPushMessageData();
}

JSC_DEFINE_CUSTOM_GETTER(jsPushMessageDataConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSPushMessageDataPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSPushMessageData::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsPushMessageDataPrototypeFunction_arrayBufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPushMessageData>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLArrayBuffer>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.arrayBuffer())));
}

JSC_DEFINE_HOST_FUNCTION(jsPushMessageDataPrototypeFunction_arrayBuffer, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSPushMessageData>::call<jsPushMessageDataPrototypeFunction_arrayBufferBody>(*lexicalGlobalObject, *callFrame, "arrayBuffer");
}

static inline JSC::EncodedJSValue jsPushMessageDataPrototypeFunction_blobBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPushMessageData>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<Blob>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.blob(*context))));
}

JSC_DEFINE_HOST_FUNCTION(jsPushMessageDataPrototypeFunction_blob, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSPushMessageData>::call<jsPushMessageDataPrototypeFunction_blobBody>(*lexicalGlobalObject, *callFrame, "blob");
}

static inline JSC::EncodedJSValue jsPushMessageDataPrototypeFunction_jsonBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPushMessageData>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLAny>(*lexicalGlobalObject, throwScope, impl.json(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)))));
}

JSC_DEFINE_HOST_FUNCTION(jsPushMessageDataPrototypeFunction_json, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSPushMessageData>::call<jsPushMessageDataPrototypeFunction_jsonBody>(*lexicalGlobalObject, *callFrame, "json");
}

static inline JSC::EncodedJSValue jsPushMessageDataPrototypeFunction_textBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPushMessageData>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUSVString>(*lexicalGlobalObject, throwScope, impl.text())));
}

JSC_DEFINE_HOST_FUNCTION(jsPushMessageDataPrototypeFunction_text, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSPushMessageData>::call<jsPushMessageDataPrototypeFunction_textBody>(*lexicalGlobalObject, *callFrame, "text");
}

JSC::GCClient::IsoSubspace* JSPushMessageData::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSPushMessageData, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForPushMessageData.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForPushMessageData = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForPushMessageData.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForPushMessageData = std::forward<decltype(space)>(space); }
    );
}

void JSPushMessageData::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSPushMessageData*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSPushMessageDataOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSPushMessageDataOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsPushMessageData = static_cast<JSPushMessageData*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsPushMessageData->wrapped(), jsPushMessageData);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7PushMessageData@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore15PushMessageDataE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<PushMessageData>&& impl)
{

    if constexpr (std::is_polymorphic_v<PushMessageData>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7PushMessageData@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore15PushMessageDataE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // PushMessageData has subclasses. If PushMessageData has subclasses that get passed
        // to toJS() we currently require PushMessageData you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<PushMessageData>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, PushMessageData& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

PushMessageData* JSPushMessageData::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSPushMessageData*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(SERVICE_WORKER)
