/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SERVICE_WORKER)

#include "JSImageResource.h"

#include "JSDOMConvertStrings.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(SERVICE_WORKER)

template<> ImageResource convertDictionary<ImageResource>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    ImageResource result;
    JSValue labelValue;
    if (isNullOrUndefined)
        labelValue = jsUndefined();
    else {
        labelValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "label"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!labelValue.isUndefined()) {
        result.label = convert<IDLDOMString>(lexicalGlobalObject, labelValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue sizesValue;
    if (isNullOrUndefined)
        sizesValue = jsUndefined();
    else {
        sizesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sizes"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!sizesValue.isUndefined()) {
        result.sizes = convert<IDLDOMString>(lexicalGlobalObject, sizesValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue srcValue;
    if (isNullOrUndefined)
        srcValue = jsUndefined();
    else {
        srcValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "src"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!srcValue.isUndefined()) {
        result.src = convert<IDLUSVString>(lexicalGlobalObject, srcValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "src", "ImageResource", "USVString");
        return { };
    }
    JSValue typeValue;
    if (isNullOrUndefined)
        typeValue = jsUndefined();
    else {
        typeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "type"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!typeValue.isUndefined()) {
        result.type = convert<IDLDOMString>(lexicalGlobalObject, typeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(SERVICE_WORKER)
