/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUVertexBufferLayout.h"

#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSGPUVertexAttribute.h"
#include "JSGPUVertexStepMode.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> GPUVertexBufferLayout convertDictionary<GPUVertexBufferLayout>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    GPUVertexBufferLayout result;
    JSValue arrayStrideValue;
    if (isNullOrUndefined)
        arrayStrideValue = jsUndefined();
    else {
        arrayStrideValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "arrayStride"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!arrayStrideValue.isUndefined()) {
        result.arrayStride = convert<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(lexicalGlobalObject, arrayStrideValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "arrayStride", "GPUVertexBufferLayout", "unsigned long long");
        return { };
    }
    JSValue attributesValue;
    if (isNullOrUndefined)
        attributesValue = jsUndefined();
    else {
        attributesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "attributes"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!attributesValue.isUndefined()) {
        result.attributes = convert<IDLSequence<IDLDictionary<GPUVertexAttribute>>>(lexicalGlobalObject, attributesValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "attributes", "GPUVertexBufferLayout", "sequence");
        return { };
    }
    JSValue stepModeValue;
    if (isNullOrUndefined)
        stepModeValue = jsUndefined();
    else {
        stepModeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "stepMode"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!stepModeValue.isUndefined()) {
        result.stepMode = convert<IDLEnumeration<GPUVertexStepMode>>(lexicalGlobalObject, stepModeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.stepMode = GPUVertexStepMode::Vertex;
    return result;
}

} // namespace WebCore
