/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUBindGroupEntry.h"

#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertUnion.h"
#include "JSGPUBufferBinding.h"
#include "JSGPUExternalTexture.h"
#include "JSGPUSampler.h"
#include "JSGPUTextureView.h"
#include <JavaScriptCore/JSCInlines.h>
#include <variant>


namespace WebCore {
using namespace JSC;

template<> GPUBindGroupEntry convertDictionary<GPUBindGroupEntry>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    GPUBindGroupEntry result;
    JSValue bindingValue;
    if (isNullOrUndefined)
        bindingValue = jsUndefined();
    else {
        bindingValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "binding"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bindingValue.isUndefined()) {
        result.binding = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, bindingValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "binding", "GPUBindGroupEntry", "unsigned long");
        return { };
    }
    JSValue resourceValue;
    if (isNullOrUndefined)
        resourceValue = jsUndefined();
    else {
        resourceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "resource"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!resourceValue.isUndefined()) {
        result.resource = convert<IDLUnion<IDLInterface<GPUSampler>, IDLInterface<GPUTextureView>, IDLDictionary<GPUBufferBinding>, IDLInterface<GPUExternalTexture>>>(lexicalGlobalObject, resourceValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "resource", "GPUBindGroupEntry", "(GPUSampler or GPUTextureView or GPUBufferBinding or GPUExternalTexture)");
        return { };
    }
    return result;
}

} // namespace WebCore
