/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO)

#include "JSAudioTrackConfiguration.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsAudioTrackConfigurationConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsAudioTrackConfiguration_codec);
static JSC_DECLARE_CUSTOM_GETTER(jsAudioTrackConfiguration_sampleRate);
static JSC_DECLARE_CUSTOM_GETTER(jsAudioTrackConfiguration_numberOfChannels);
static JSC_DECLARE_CUSTOM_GETTER(jsAudioTrackConfiguration_bitrate);

class JSAudioTrackConfigurationPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSAudioTrackConfigurationPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSAudioTrackConfigurationPrototype* ptr = new (NotNull, JSC::allocateCell<JSAudioTrackConfigurationPrototype>(vm)) JSAudioTrackConfigurationPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSAudioTrackConfigurationPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSAudioTrackConfigurationPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSAudioTrackConfigurationPrototype, JSAudioTrackConfigurationPrototype::Base);

using JSAudioTrackConfigurationDOMConstructor = JSDOMConstructorNotConstructable<JSAudioTrackConfiguration>;

template<> const ClassInfo JSAudioTrackConfigurationDOMConstructor::s_info = { "AudioTrackConfiguration"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioTrackConfigurationDOMConstructor) };

template<> JSValue JSAudioTrackConfigurationDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSAudioTrackConfigurationDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "AudioTrackConfiguration"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSAudioTrackConfiguration::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSAudioTrackConfigurationPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsAudioTrackConfigurationConstructor, 0 } },
    { "codec"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsAudioTrackConfiguration_codec, 0 } },
    { "sampleRate"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsAudioTrackConfiguration_sampleRate, 0 } },
    { "numberOfChannels"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsAudioTrackConfiguration_numberOfChannels, 0 } },
    { "bitrate"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsAudioTrackConfiguration_bitrate, 0 } },
};

const ClassInfo JSAudioTrackConfigurationPrototype::s_info = { "AudioTrackConfiguration"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioTrackConfigurationPrototype) };

void JSAudioTrackConfigurationPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSAudioTrackConfiguration::info(), JSAudioTrackConfigurationPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSAudioTrackConfiguration::s_info = { "AudioTrackConfiguration"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioTrackConfiguration) };

JSAudioTrackConfiguration::JSAudioTrackConfiguration(Structure* structure, JSDOMGlobalObject& globalObject, Ref<AudioTrackConfiguration>&& impl)
    : JSDOMWrapper<AudioTrackConfiguration>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, AudioTrackConfiguration>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSAudioTrackConfiguration::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSAudioTrackConfigurationPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSAudioTrackConfigurationPrototype::create(vm, &globalObject, structure);
}

JSObject* JSAudioTrackConfiguration::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSAudioTrackConfiguration>(vm, globalObject);
}

JSValue JSAudioTrackConfiguration::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSAudioTrackConfigurationDOMConstructor, DOMConstructorID::AudioTrackConfiguration>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSAudioTrackConfiguration::destroy(JSC::JSCell* cell)
{
    JSAudioTrackConfiguration* thisObject = static_cast<JSAudioTrackConfiguration*>(cell);
    thisObject->JSAudioTrackConfiguration::~JSAudioTrackConfiguration();
}

JSC_DEFINE_CUSTOM_GETTER(jsAudioTrackConfigurationConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSAudioTrackConfigurationPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSAudioTrackConfiguration::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsAudioTrackConfiguration_codecGetter(JSGlobalObject& lexicalGlobalObject, JSAudioTrackConfiguration& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.codec())));
}

JSC_DEFINE_CUSTOM_GETTER(jsAudioTrackConfiguration_codec, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSAudioTrackConfiguration>::get<jsAudioTrackConfiguration_codecGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsAudioTrackConfiguration_sampleRateGetter(JSGlobalObject& lexicalGlobalObject, JSAudioTrackConfiguration& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.sampleRate())));
}

JSC_DEFINE_CUSTOM_GETTER(jsAudioTrackConfiguration_sampleRate, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSAudioTrackConfiguration>::get<jsAudioTrackConfiguration_sampleRateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsAudioTrackConfiguration_numberOfChannelsGetter(JSGlobalObject& lexicalGlobalObject, JSAudioTrackConfiguration& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.numberOfChannels())));
}

JSC_DEFINE_CUSTOM_GETTER(jsAudioTrackConfiguration_numberOfChannels, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSAudioTrackConfiguration>::get<jsAudioTrackConfiguration_numberOfChannelsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsAudioTrackConfiguration_bitrateGetter(JSGlobalObject& lexicalGlobalObject, JSAudioTrackConfiguration& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.bitrate())));
}

JSC_DEFINE_CUSTOM_GETTER(jsAudioTrackConfiguration_bitrate, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSAudioTrackConfiguration>::get<jsAudioTrackConfiguration_bitrateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSAudioTrackConfiguration::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSAudioTrackConfiguration, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForAudioTrackConfiguration.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForAudioTrackConfiguration = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForAudioTrackConfiguration.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForAudioTrackConfiguration = std::forward<decltype(space)>(space); }
    );
}

void JSAudioTrackConfiguration::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSAudioTrackConfiguration*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSAudioTrackConfigurationOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSAudioTrackConfigurationOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsAudioTrackConfiguration = static_cast<JSAudioTrackConfiguration*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsAudioTrackConfiguration->wrapped(), jsAudioTrackConfiguration);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7AudioTrackConfiguration@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore23AudioTrackConfigurationE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<AudioTrackConfiguration>&& impl)
{

    if constexpr (std::is_polymorphic_v<AudioTrackConfiguration>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7AudioTrackConfiguration@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore23AudioTrackConfigurationE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // AudioTrackConfiguration has subclasses. If AudioTrackConfiguration has subclasses that get passed
        // to toJS() we currently require AudioTrackConfiguration you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<AudioTrackConfiguration>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, AudioTrackConfiguration& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

AudioTrackConfiguration* JSAudioTrackConfiguration::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSAudioTrackConfiguration*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(VIDEO)
