/*
 * Copyright (C) 2021-2023 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#if USE(EGL)

#include "ArgumentCoders.h"
#include "Connection.h"
#include "MessageNames.h"
#include "ShareableBitmap.h"
#include <wtf/Forward.h>
#include <wtf/ThreadSafeRefCounted.h>

namespace WebCore {
class IntSize;
}

namespace Messages {
namespace AcceleratedBackingStoreDMABuf {

static inline IPC::ReceiverName messageReceiverName()
{
    return IPC::ReceiverName::AcceleratedBackingStoreDMABuf;
}

class Configure {
public:
    using Arguments = std::tuple<UnixFileDescriptor, UnixFileDescriptor, UnixFileDescriptor, WebCore::IntSize, uint32_t, uint32_t, uint32_t, uint64_t>;

    static IPC::MessageName name() { return IPC::MessageName::AcceleratedBackingStoreDMABuf_Configure; }
    static constexpr bool isSync = false;

    Configure(const UnixFileDescriptor& backFD, const UnixFileDescriptor& frontFD, const UnixFileDescriptor& displayFD, const WebCore::IntSize& size, uint32_t format, uint32_t offset, uint32_t stride, uint64_t modifier)
        : m_arguments(backFD, frontFD, displayFD, size, format, offset, stride, modifier)
    {
    }

    auto&& arguments()
    {
        return WTFMove(m_arguments);
    }

private:
    std::tuple<const UnixFileDescriptor&, const UnixFileDescriptor&, const UnixFileDescriptor&, const WebCore::IntSize&, uint32_t, uint32_t, uint32_t, uint64_t> m_arguments;
};

class ConfigureSHM {
public:
    using Arguments = std::tuple<WebKit::ShareableBitmap::Handle, WebKit::ShareableBitmap::Handle, WebKit::ShareableBitmap::Handle>;

    static IPC::MessageName name() { return IPC::MessageName::AcceleratedBackingStoreDMABuf_ConfigureSHM; }
    static constexpr bool isSync = false;

    ConfigureSHM(WebKit::ShareableBitmap::Handle&& backBufferHandle, WebKit::ShareableBitmap::Handle&& frontBufferHandle, WebKit::ShareableBitmap::Handle&& displayBufferHandle)
        : m_arguments(WTFMove(backBufferHandle), WTFMove(frontBufferHandle), WTFMove(displayBufferHandle))
    {
    }

    auto&& arguments()
    {
        return WTFMove(m_arguments);
    }

private:
    std::tuple<WebKit::ShareableBitmap::Handle&&, WebKit::ShareableBitmap::Handle&&, WebKit::ShareableBitmap::Handle&&> m_arguments;
};

class Frame {
public:
    using Arguments = std::tuple<>;

    static IPC::MessageName name() { return IPC::MessageName::AcceleratedBackingStoreDMABuf_Frame; }
    static constexpr bool isSync = false;

    auto&& arguments()
    {
        return WTFMove(m_arguments);
    }

private:
    std::tuple<> m_arguments;
};

} // namespace AcceleratedBackingStoreDMABuf
} // namespace Messages

#endif // USE(EGL)
