/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.image;

import VASSAL.Info;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.image.FallbackImageTypeConverter;
import VASSAL.tools.image.GeneralFilter;
import VASSAL.tools.image.ImageIOException;
import VASSAL.tools.image.ImageIOImageLoader;
import VASSAL.tools.image.ImageLoader;
import VASSAL.tools.image.ImageNotFoundException;
import VASSAL.tools.io.TemporaryFileFactory;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;

public class ImageUtils {
    private static final double DEGTORAD = -Math.PI / 180;
    private static final GeneralFilter.Filter upscale;
    private static final GeneralFilter.Filter downscale;
    @Deprecated
    public static final String SCALER_ALGORITHM = "scalerAlgorithm";
    private static final Map<RenderingHints.Key, Object> defaultHints;
    private static final TemporaryFileFactory tfac;
    private static final ImageLoader loader;
    protected static final boolean IS_MAC_RETINA;
    protected static final BufferedImage compatOpaqueImage;
    protected static final BufferedImage compatTransImage;
    protected static final int compatOpaqueImageType;
    protected static final int compatTranslImageType;
    public static final BufferedImage NULL_IMAGE;
    public static final String GIF_SUFFIX = ".gif";
    public static final String PNG_SUFFIX = ".png";
    public static final String SVG_SUFFIX = ".svg";
    public static final String JPG_SUFFIX = ".jpg";
    public static final String JPEG_SUFFIX = ".jpeg";
    public static final String[] IMAGE_SUFFIXES;

    private ImageUtils() {
    }

    @Deprecated
    public static void setHighQualityScaling(boolean bl) {
    }

    public static RenderingHints getDefaultHints() {
        return new RenderingHints(defaultHints);
    }

    public static Rectangle transform(Rectangle rectangle, double d, double d2) {
        AffineTransform affineTransform = AffineTransform.getRotateInstance(-Math.PI / 180 * d2, rectangle.getCenterX(), rectangle.getCenterY());
        affineTransform.scale(d, d);
        return affineTransform.createTransformedShape(rectangle).getBounds();
    }

    public static BufferedImage transform(BufferedImage bufferedImage, double d, double d2) {
        return ImageUtils.transform(bufferedImage, d, d2, ImageUtils.getDefaultHints());
    }

    public static BufferedImage transform(BufferedImage bufferedImage, double d, double d2, RenderingHints renderingHints) {
        Object object;
        Rectangle rectangle;
        if (bufferedImage == null) {
            return null;
        }
        if (d == 1.0 && d2 == 0.0) {
            return bufferedImage;
        }
        if ((double)bufferedImage.getWidth() * d == 0.0 || (double)bufferedImage.getHeight() * d == 0.0) {
            return NULL_IMAGE;
        }
        if (renderingHints == null) {
            renderingHints = ImageUtils.getDefaultHints();
        }
        if (d == 1.0 && d2 % 90.0 == 0.0) {
            renderingHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            Rectangle rectangle2 = ImageUtils.getBounds(bufferedImage);
            Rectangle rectangle3 = ImageUtils.transform(rectangle2, d, d2);
            BufferedImage bufferedImage2 = ImageUtils.createCompatibleImage(rectangle3.width, rectangle3.height, bufferedImage.getTransparency() != 1);
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(-rectangle3.x, -rectangle3.y);
            affineTransform.rotate(-Math.PI / 180 * d2, rectangle2.getCenterX(), rectangle2.getCenterY());
            affineTransform.scale(d, d);
            affineTransform.translate(rectangle2.x, rectangle2.y);
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.setRenderingHints(renderingHints);
            graphics2D.drawImage(bufferedImage, affineTransform, null);
            graphics2D.dispose();
            return bufferedImage2;
        }
        if (d2 != 0.0) {
            rectangle = ImageUtils.getBounds(bufferedImage);
            object = ImageUtils.transform(rectangle, 1.0, d2);
            BufferedImage bufferedImage3 = ImageUtils.createCompatibleImage(((Rectangle)object).width, ((Rectangle)object).height, bufferedImage.getTransparency() != 1 || d2 % 90.0 != 0.0);
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(-((Rectangle)object).x, -((Rectangle)object).y);
            affineTransform.rotate(-Math.PI / 180 * d2, rectangle.getCenterX(), rectangle.getCenterY());
            affineTransform.translate(rectangle.x, rectangle.y);
            Graphics2D graphics2D = bufferedImage3.createGraphics();
            graphics2D.setRenderingHints(renderingHints);
            graphics2D.drawImage(bufferedImage, affineTransform, null);
            graphics2D.dispose();
            bufferedImage = bufferedImage3;
        }
        if (d != 1.0) {
            bufferedImage = ImageUtils.coerceToIntType(bufferedImage);
            rectangle = ImageUtils.transform(ImageUtils.getBounds(bufferedImage), d, 0.0);
            if (rectangle.width == 0 || rectangle.height == 0) {
                return NULL_IMAGE;
            }
            object = GeneralFilter.zoom(rectangle, bufferedImage, d > 1.0 ? upscale : downscale);
            return ImageUtils.toCompatibleImage((BufferedImage)object);
        }
        return bufferedImage;
    }

    @Deprecated
    public static BufferedImage transform(BufferedImage bufferedImage, double d, double d2, RenderingHints renderingHints, int n) {
        return ImageUtils.transform(bufferedImage, d, d2, renderingHints);
    }

    public static BufferedImage coerceToIntType(BufferedImage bufferedImage) {
        switch (bufferedImage.getType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return bufferedImage;
            }
        }
        return ImageUtils.toType(bufferedImage, bufferedImage.getTransparency() == 1 ? 1 : (ImageUtils.getCompatibleTranslucentImageType() == 2 ? 2 : 3));
    }

    public static Rectangle getBounds(BufferedImage bufferedImage) {
        return new Rectangle(-bufferedImage.getWidth() / 2, -bufferedImage.getHeight() / 2, bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    public static Rectangle getBounds(Dimension dimension) {
        return new Rectangle(-dimension.width / 2, -dimension.height / 2, dimension.width, dimension.height);
    }

    @Deprecated
    public static Dimension getImageSize(InputStream inputStream) throws IOException {
        return ImageUtils.getImageSize("", inputStream);
    }

    public static Dimension getImageSize(String string, InputStream inputStream) throws ImageIOException {
        return loader.size(string, inputStream);
    }

    @Deprecated
    public static BufferedImage getImage(InputStream inputStream) throws IOException {
        return ImageUtils.getImage("", inputStream);
    }

    public static BufferedImage getImageResource(String string) throws ImageIOException {
        InputStream inputStream = ImageUtils.class.getResourceAsStream(string);
        if (inputStream == null) {
            throw new ImageNotFoundException(string);
        }
        return ImageUtils.getImage(string, inputStream);
    }

    public static BufferedImage getImage(String string, InputStream inputStream) throws ImageIOException {
        return loader.load(string, inputStream, compatOpaqueImageType, compatTranslImageType, true);
    }

    public static BufferedImage toType(BufferedImage bufferedImage, int n) {
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), n);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static Image forceLoad(Image image) {
        return new ImageIcon(image).getImage();
    }

    public static boolean isTransparent(Image image) {
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            ErrorDialog.bug(interruptedException);
        }
        return pixelGrabber.getColorModel().hasAlpha();
    }

    public static boolean isTransparent(BufferedImage bufferedImage) {
        return bufferedImage.getTransparency() != 1;
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image == null) {
            return null;
        }
        if (image instanceof BufferedImage) {
            return ImageUtils.toCompatibleImage((BufferedImage)image);
        }
        image = ImageUtils.forceLoad(image);
        BufferedImage bufferedImage = ImageUtils.createCompatibleImage(image.getWidth(null), image.getHeight(null), ImageUtils.isTransparent(image));
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static boolean isMacRetina() {
        return IS_MAC_RETINA;
    }

    private static boolean isHeadless() {
        return GraphicsEnvironment.isHeadless();
    }

    private static GraphicsConfiguration getGraphicsConfiguration() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    public static int getCompatibleImageType() {
        return compatOpaqueImageType;
    }

    public static int getCompatibleTranslucentImageType() {
        return compatTranslImageType;
    }

    public static int getCompatibleImageType(boolean bl) {
        return bl ? compatTranslImageType : compatOpaqueImageType;
    }

    public static int getCompatibleImageType(BufferedImage bufferedImage) {
        return ImageUtils.getCompatibleImageType(ImageUtils.isTransparent(bufferedImage));
    }

    public static BufferedImage createCompatibleImage(int n, int n2) {
        ColorModel colorModel = compatOpaqueImage.getColorModel();
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n, n2);
        return new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
    }

    public static BufferedImage createCompatibleImage(int n, int n2, boolean bl) {
        return bl ? ImageUtils.createCompatibleTranslucentImage(n, n2) : ImageUtils.createCompatibleImage(n, n2);
    }

    public static BufferedImage createCompatibleTranslucentImage(int n, int n2) {
        ColorModel colorModel = compatTransImage.getColorModel();
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n, n2);
        return new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
    }

    public static BufferedImage toCompatibleImage(BufferedImage bufferedImage) {
        if (bufferedImage.getColorModel().equals(compatOpaqueImage.getColorModel()) && bufferedImage.getTransparency() == compatOpaqueImage.getTransparency() || bufferedImage.getColorModel().equals(compatTransImage.getColorModel()) && bufferedImage.getTransparency() == compatTransImage.getTransparency()) {
            return bufferedImage;
        }
        BufferedImage bufferedImage2 = ImageUtils.createCompatibleImage(bufferedImage.getWidth(), bufferedImage.getHeight(), ImageUtils.isTransparent(bufferedImage));
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static boolean isCompatibleImage(BufferedImage bufferedImage) {
        return bufferedImage.getType() == ImageUtils.getCompatibleImageType(bufferedImage.getTransparency() != 1);
    }

    public static boolean hasImageSuffix(String string) {
        String string2 = string.toLowerCase();
        for (String string3 : IMAGE_SUFFIXES) {
            if (!string2.endsWith(string3)) continue;
            return true;
        }
        return false;
    }

    public static String stripImageSuffix(String string) {
        String string2 = string.toLowerCase();
        for (String string3 : IMAGE_SUFFIXES) {
            if (!string2.endsWith(string3)) continue;
            return string.substring(0, string.length() - string3.length());
        }
        return string;
    }

    static {
        BufferedImage bufferedImage;
        upscale = new GeneralFilter.MitchellFilter();
        downscale = new GeneralFilter.Lanczos3Filter();
        defaultHints = new HashMap<RenderingHints.Key, Object>();
        defaultHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        defaultHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        tfac = new TemporaryFileFactory(){

            public File create() throws IOException {
                return File.createTempFile("img", null, Info.getTempDir());
            }
        };
        loader = new ImageIOImageLoader(new FallbackImageTypeConverter(tfac));
        Object object = Toolkit.getDefaultToolkit().getDesktopProperty("apple.awt.contentScaleFactor");
        boolean bl = IS_MAC_RETINA = object instanceof Number && ((Number)object).doubleValue() == 2.0;
        if (ImageUtils.isHeadless()) {
            object = new BufferedImage(1, 1, 1);
            bufferedImage = new BufferedImage(1, 1, 2);
        } else {
            GraphicsConfiguration graphicsConfiguration = ImageUtils.getGraphicsConfiguration();
            object = graphicsConfiguration.createCompatibleImage(1, 1, 1);
            bufferedImage = graphicsConfiguration.createCompatibleImage(1, 1, 3);
            if (ImageUtils.isMacRetina()) {
                if (((BufferedImage)object).getType() == 3) {
                    object = new BufferedImage(1, 1, 2);
                }
                if (bufferedImage.getType() == 3) {
                    bufferedImage = new BufferedImage(1, 1, 2);
                }
            }
        }
        compatOpaqueImage = object;
        compatTransImage = bufferedImage;
        compatOpaqueImageType = compatOpaqueImage.getType();
        compatTranslImageType = compatTransImage.getType();
        NULL_IMAGE = ImageUtils.createCompatibleImage(1, 1);
        IMAGE_SUFFIXES = new String[]{GIF_SUFFIX, PNG_SUFFIX, SVG_SUFFIX, JPG_SUFFIX, JPEG_SUFFIX};
    }
}

