/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class HotkeySpecifier
extends JTextField
implements KeyListener {
    private static final long serialVersionUID = 1L;
    private int key;
    private KeyStroke stroke;

    public HotkeySpecifier() {
        this(0);
    }

    public HotkeySpecifier(int n) {
        this.key = n;
        this.setText(n == 0 ? "" : KeyEvent.getKeyText(n));
        this.stroke = KeyStroke.getKeyStroke((char)n);
        this.addKeyListener(this);
    }

    public int getKey() {
        return this.key;
    }

    public KeyStroke getKeyStroke() {
        return this.stroke;
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.stroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.setText(HotkeySpecifier.getString(this.stroke));
    }

    public static String getString(KeyStroke keyStroke) {
        String string = KeyEvent.getKeyText(keyStroke.getKeyCode());
        if ((keyStroke.getModifiers() & 1) > 0) {
            string = KeyEvent.getKeyText(16) + "+" + string;
        }
        if ((keyStroke.getModifiers() & 2) > 0) {
            string = KeyEvent.getKeyText(17) + "+" + string;
        }
        if ((keyStroke.getModifiers() & 4) > 0) {
            string = KeyEvent.getKeyText(157) + "+" + string;
        }
        if ((keyStroke.getModifiers() & 8) > 0) {
            string = KeyEvent.getKeyText(18) + "+" + string;
        }
        return string;
    }

    public static KeyStroke getStrokeForString(String string) {
        int n = string.indexOf(44);
        return KeyStroke.getKeyStroke(Integer.parseInt(string.substring(0, n)), Integer.parseInt(string.substring(n + 1)));
    }

    public static String getStringForStroke(KeyStroke keyStroke) {
        return keyStroke.getKeyCode() + "," + keyStroke.getModifiers();
    }
}

