/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.script.expression;

import VASSAL.build.BadDataReport;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceFilter;
import VASSAL.i18n.Resources;
import VASSAL.script.ExpressionInterpreter;
import VASSAL.script.expression.Expression;
import VASSAL.script.expression.ExpressionException;
import VASSAL.script.expression.IntExpression;
import VASSAL.script.expression.NullExpression;
import VASSAL.script.expression.StringExpression;
import VASSAL.tools.ErrorDialog;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanShellExpression
extends Expression {
    protected ExpressionInterpreter interpreter;

    public BeanShellExpression(String string) {
        this.setExpression("{" + string + "}");
    }

    @Override
    public String evaluate(PropertySource propertySource, Map<String, String> map, boolean bl) throws ExpressionException {
        if (this.interpreter == null) {
            this.interpreter = ExpressionInterpreter.createInterpreter(BeanShellExpression.strip(this.getExpression()));
        }
        return this.interpreter.evaluate(propertySource, bl);
    }

    @Override
    public String toBeanShellString() {
        return BeanShellExpression.strip(this.getExpression());
    }

    protected static String strip(String string) {
        String string2 = string.trim();
        if (string2.startsWith("{") && string2.endsWith("}")) {
            return string2.substring(1, string2.length() - 1);
        }
        return string;
    }

    @Override
    public PieceFilter getFilter(PropertySource propertySource) {
        return new PieceFilter(){

            public boolean accept(GamePiece gamePiece) {
                String string = null;
                try {
                    string = BeanShellExpression.this.evaluate(gamePiece);
                }
                catch (ExpressionException expressionException) {
                    ErrorDialog.dataError(new BadDataReport(Resources.getString("Error.expression_error"), "Expression=" + BeanShellExpression.this.getExpression() + ", Error=" + expressionException.getError(), expressionException));
                }
                return "true".equals(string);
            }
        };
    }

    public static String convertProperty(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        if (BeanShellExpression.isBeanShellExpression(string)) {
            return BeanShellExpression.strip(string);
        }
        boolean bl = Character.isJavaIdentifierStart(string.charAt(0));
        if (bl) {
            for (int i = 1; i < string.length() && bl; ++i) {
                bl = Character.isJavaIdentifierPart(string.charAt(i));
            }
        }
        return bl ? string : "GetProperty(\"" + string + "\")";
    }

    public static boolean isBeanShellExpression(String string) {
        return string.startsWith("{") && string.endsWith("}");
    }

    public static boolean isJavaIdentifier(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static Expression createExpression(String string) {
        String string2 = string.trim();
        String string3 = string2.startsWith("{") && string2.endsWith("}") ? string2.substring(1, string2.length() - 1).trim() : string2;
        if (string3.trim().length() == 0) {
            return new NullExpression();
        }
        try {
            return new IntExpression(Integer.parseInt(string3));
        }
        catch (NumberFormatException numberFormatException) {
            if (string3.length() > 1 && string3.startsWith("\"") && string3.endsWith("\"") && string3.indexOf(34, 1) == string3.length() - 1) {
                return new StringExpression(string3.substring(1, string3.length() - 1));
            }
            return new BeanShellExpression(string3);
        }
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }
}

