/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.AutoConfigurable;
import VASSAL.build.GameModule;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.DoubleConfigurer;
import VASSAL.configure.FileConfigurer;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.ImageConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.PropertyExpression;
import VASSAL.configure.PropertyExpressionConfigurer;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.StringEnum;
import VASSAL.configure.StringEnumConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.ReflectionUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoConfigurer
extends Configurer
implements PropertyChangeListener {
    protected JPanel p;
    protected AutoConfigurable target;
    protected List<Configurer> configurers = new ArrayList<Configurer>();
    protected Map<String, VisibilityCondition> conditions;

    public AutoConfigurer(AutoConfigurable autoConfigurable) {
        super(null, autoConfigurable.getConfigureName());
        this.target = autoConfigurable;
        this.setValue(this.target);
        this.target.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("name".equals(propertyChangeEvent.getPropertyName())) {
                    AutoConfigurer.this.setName((String)propertyChangeEvent.getNewValue());
                }
            }
        });
        this.p = new JPanel();
        this.p.setLayout(new BoxLayout(this.p, 1));
        String[] stringArray = autoConfigurable.getAttributeNames();
        String[] stringArray2 = autoConfigurable.getAttributeDescriptions();
        Class<?>[] classArray = autoConfigurable.getAttributeTypes();
        int n = Math.min(stringArray.length, Math.min(stringArray2.length, classArray.length));
        for (int i = 0; i < n; ++i) {
            if (classArray[i] == null) continue;
            Configurer configurer = AutoConfigurer.createConfigurer(classArray[i], stringArray[i], stringArray2[i], this.target);
            if (configurer != null) {
                configurer.addPropertyChangeListener(this);
                configurer.setValue(this.target.getAttributeValueString(stringArray[i]));
                Box box = Box.createHorizontalBox();
                box.add(configurer.getControls());
                box.add(Box.createHorizontalGlue());
                this.p.add(box);
                this.configurers.add(configurer);
            }
            this.setVisibility(stringArray[i], autoConfigurable.getAttributeVisibility(stringArray[i]));
        }
    }

    public static Configurer createConfigurer(Class<?> clazz, String string, String string2, AutoConfigurable autoConfigurable) {
        Configurer configurer = null;
        if (String.class.isAssignableFrom(clazz)) {
            configurer = new StringConfigurer(string, string2);
        } else if (Integer.class.isAssignableFrom(clazz)) {
            configurer = new IntConfigurer(string, string2);
        } else if (Double.class.isAssignableFrom(clazz)) {
            configurer = new DoubleConfigurer(string, string2);
        } else if (Boolean.class.isAssignableFrom(clazz)) {
            configurer = new BooleanConfigurer(string, string2);
        } else if (Image.class.isAssignableFrom(clazz)) {
            configurer = new ImageConfigurer(string, string2, GameModule.getGameModule().getArchiveWriter());
        } else if (Color.class.isAssignableFrom(clazz)) {
            configurer = new ColorConfigurer(string, string2);
        } else if (KeyStroke.class.isAssignableFrom(clazz)) {
            configurer = new HotKeyConfigurer(string, string2);
        } else if (NamedKeyStroke.class.isAssignableFrom(clazz)) {
            configurer = new NamedHotKeyConfigurer(string, string2);
        } else if (File.class.isAssignableFrom(clazz)) {
            configurer = new FileConfigurer(string, string2, GameModule.getGameModule().getArchiveWriter());
        } else if (String[].class.isAssignableFrom(clazz)) {
            configurer = new StringArrayConfigurer(string, string2);
        } else if (Icon.class.isAssignableFrom(clazz)) {
            configurer = new IconConfigurer(string, string2, null);
        } else if (PropertyExpression.class.isAssignableFrom(clazz)) {
            configurer = new PropertyExpressionConfigurer(string, string2);
        } else if (StringEnum.class.isAssignableFrom(clazz)) {
            StringEnum stringEnum = null;
            try {
                stringEnum = (StringEnum)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable throwable) {
                ReflectionUtils.handleNewInstanceFailure(throwable, clazz);
                configurer = new StringConfigurer(string, string2);
            }
            if (stringEnum != null) {
                String[] stringArray = stringEnum.getValidValues(autoConfigurable);
                configurer = new StringEnumConfigurer(string, string2, stringArray);
            }
        } else if (ConfigurerFactory.class.isAssignableFrom(clazz)) {
            ConfigurerFactory configurerFactory = null;
            try {
                configurerFactory = (ConfigurerFactory)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable throwable) {
                ReflectionUtils.handleNewInstanceFailure(throwable, clazz);
            }
            if (configurerFactory != null) {
                configurer = configurerFactory.getConfigurer(autoConfigurable, string, string2);
            }
        } else {
            throw new IllegalArgumentException("Invalid class " + clazz.getName());
        }
        return configurer;
    }

    public void reset() {
        String[] stringArray = this.target.getAttributeNames();
        for (int i = 0; i < stringArray.length; ++i) {
            Configurer configurer = this.getConfigurer(stringArray[i]);
            if (configurer == null) continue;
            configurer.setValue(this.target.getAttributeValueString(stringArray[i]));
        }
    }

    @Override
    public String getValueString() {
        return this.target.getConfigureName();
    }

    @Override
    public void setValue(String string) {
        throw new UnsupportedOperationException("Can't set Configurable from String");
    }

    @Override
    public Component getControls() {
        return this.p;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.target.setAttribute(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getNewValue());
        this.checkVisibility();
    }

    public void setVisibility(String string, VisibilityCondition visibilityCondition) {
        if (visibilityCondition != null) {
            if (this.conditions == null) {
                this.conditions = new HashMap<String, VisibilityCondition>();
            }
            this.conditions.put(string, visibilityCondition);
            this.checkVisibility();
        }
    }

    protected void checkVisibility() {
        boolean bl = false;
        if (this.conditions != null) {
            for (Configurer configurer : this.configurers) {
                VisibilityCondition visibilityCondition = this.conditions.get(configurer.getKey());
                if (visibilityCondition == null || configurer.getControls().isVisible() == visibilityCondition.shouldBeVisible()) continue;
                bl = true;
                configurer.getControls().setVisible(visibilityCondition.shouldBeVisible());
            }
            if (bl && this.p.getTopLevelAncestor() instanceof Window) {
                ((Window)this.p.getTopLevelAncestor()).pack();
            }
        }
    }

    public Configurer getConfigurer(String string) {
        for (Configurer configurer : this.configurers) {
            if (!string.equals(configurer.getKey())) continue;
            return configurer;
        }
        return null;
    }
}

