/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.janino.JaninoRuntimeException;
import org.codehaus.janino.Java;
import org.codehaus.janino.Mod;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.Visitor;
import org.codehaus.janino.util.AutoIndentWriter;

public class UnparseVisitor
implements Visitor.ComprehensiveVisitor {
    protected final AutoIndentWriter aiw;
    protected final PrintWriter pw;
    private static final Set LEFT_ASSOCIATIVE_OPERATORS = new HashSet();
    private static final Set RIGHT_ASSOCIATIVE_OPERATORS = new HashSet();
    private static final Set UNARY_OPERATORS = new HashSet();
    private static final Map OPERATOR_PRECEDENCE = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter(System.out));
        for (int i = 0; i < args.length; ++i) {
            Java.CompilationUnit cu;
            String fileName = args[i];
            FileReader r = new FileReader(fileName);
            try {
                cu = new Parser(new Scanner(fileName, r)).parseCompilationUnit();
            }
            finally {
                r.close();
            }
            UnparseVisitor.unparse(cu, w);
        }
        ((Writer)w).flush();
    }

    public static void unparse(Java.CompilationUnit cu, Writer w) {
        UnparseVisitor uv = new UnparseVisitor(w);
        uv.unparseCompilationUnit(cu);
        uv.close();
    }

    public UnparseVisitor(Writer w) {
        this.aiw = new AutoIndentWriter(w);
        this.pw = new PrintWriter((Writer)this.aiw, true);
    }

    public void close() {
        this.pw.close();
    }

    public void unparseCompilationUnit(Java.CompilationUnit cu) {
        Iterator it;
        if (cu.optionalPackageDeclaration != null) {
            this.pw.println();
            this.pw.println("package " + cu.optionalPackageDeclaration.packageName + ';');
        }
        if (!cu.importDeclarations.isEmpty()) {
            this.pw.println();
            it = cu.importDeclarations.iterator();
            while (it.hasNext()) {
                ((Java.CompilationUnit.ImportDeclaration)it.next()).accept(this);
            }
        }
        it = cu.packageMemberTypeDeclarations.iterator();
        while (it.hasNext()) {
            this.pw.println();
            this.unparseTypeDeclaration((Java.PackageMemberTypeDeclaration)it.next());
            this.pw.println();
        }
    }

    public void visitSingleTypeImportDeclaration(Java.CompilationUnit.SingleTypeImportDeclaration stid) {
        this.pw.println("import " + Java.join(stid.identifiers, ".") + ';');
    }

    public void visitTypeImportOnDemandDeclaration(Java.CompilationUnit.TypeImportOnDemandDeclaration tiodd) {
        this.pw.println("import " + Java.join(tiodd.identifiers, ".") + ".*;");
    }

    public void visitSingleStaticImportDeclaration(Java.CompilationUnit.SingleStaticImportDeclaration ssid) {
        this.pw.println("import static " + Java.join(ssid.identifiers, ".") + ';');
    }

    public void visitStaticImportOnDemandDeclaration(Java.CompilationUnit.StaticImportOnDemandDeclaration siodd) {
        this.pw.println("import static " + Java.join(siodd.identifiers, ".") + ".*;");
    }

    public void visitLocalClassDeclaration(Java.LocalClassDeclaration lcd) {
        this.unparseNamedClassDeclaration(lcd);
    }

    public void visitMemberClassDeclaration(Java.MemberClassDeclaration mcd) {
        this.unparseNamedClassDeclaration(mcd);
    }

    public void visitMemberInterfaceDeclaration(Java.MemberInterfaceDeclaration mid) {
        this.unparseInterfaceDeclaration(mid);
    }

    public void visitPackageMemberClassDeclaration(Java.PackageMemberClassDeclaration pmcd) {
        this.unparseNamedClassDeclaration(pmcd);
    }

    public void visitPackageMemberInterfaceDeclaration(Java.PackageMemberInterfaceDeclaration pmid) {
        this.unparseInterfaceDeclaration(pmid);
    }

    public void visitConstructorDeclarator(Java.ConstructorDeclarator cd) {
        this.unparseDocComment(cd);
        this.unparseModifiers(cd.modifiers);
        Java.ClassDeclaration declaringClass = cd.getDeclaringClass();
        this.pw.print(declaringClass instanceof Java.NamedClassDeclaration ? ((Java.NamedClassDeclaration)declaringClass).name : "UNNAMED");
        this.unparseFunctionDeclaratorRest(cd);
        this.pw.print(' ');
        if (cd.optionalConstructorInvocation != null) {
            this.pw.println('{');
            this.pw.print('\ufffd');
            this.unparseBlockStatement(cd.optionalConstructorInvocation);
            this.pw.println(';');
            if (!cd.optionalStatements.isEmpty()) {
                this.pw.println();
                this.unparseStatements(cd.optionalStatements);
            }
            this.pw.print("\ufffc}");
        } else if (cd.optionalStatements.isEmpty()) {
            this.pw.print("{}");
        } else {
            this.pw.println('{');
            this.pw.print('\ufffd');
            this.unparseStatements(cd.optionalStatements);
            this.pw.print("\ufffc}");
        }
    }

    public void visitMethodDeclarator(Java.MethodDeclarator md) {
        this.unparseDocComment(md);
        this.unparseModifiers(md.modifiers);
        this.unparseType(md.type);
        this.pw.print(' ' + md.name);
        this.unparseFunctionDeclaratorRest(md);
        if (md.optionalStatements == null) {
            this.pw.print(';');
        } else if (md.optionalStatements.isEmpty()) {
            this.pw.print(" {}");
        } else {
            this.pw.println(" {");
            this.pw.print('\ufffd');
            this.unparseStatements(md.optionalStatements);
            this.pw.print('\ufffc');
            this.pw.print('}');
        }
    }

    public void visitFieldDeclaration(Java.FieldDeclaration fd) {
        this.unparseDocComment(fd);
        this.unparseModifiers(fd.modifiers);
        this.unparseType(fd.type);
        this.pw.print(' ');
        for (int i = 0; i < fd.variableDeclarators.length; ++i) {
            if (i > 0) {
                this.pw.print(", ");
            }
            this.unparseVariableDeclarator(fd.variableDeclarators[i]);
        }
        this.pw.print(';');
    }

    public void visitInitializer(Java.Initializer i) {
        if (i.statiC) {
            this.pw.print("static ");
        }
        this.unparseBlockStatement(i.block);
    }

    public void visitBlock(Java.Block b) {
        if (b.statements.isEmpty()) {
            this.pw.print("{}");
            return;
        }
        this.pw.println('{');
        this.pw.print('\ufffd');
        this.unparseStatements(b.statements);
        this.pw.print("\ufffc}");
    }

    private void unparseStatements(List statements) {
        int state = -1;
        Iterator it = statements.iterator();
        while (it.hasNext()) {
            int x;
            Java.BlockStatement bs = (Java.BlockStatement)it.next();
            int n = bs instanceof Java.Block ? 1 : (bs instanceof Java.LocalClassDeclarationStatement ? 2 : (bs instanceof Java.LocalVariableDeclarationStatement ? 3 : (x = bs instanceof Java.SynchronizedStatement ? 4 : 99)));
            if (state != -1 && state != x) {
                this.pw.println('\ufffe');
            }
            state = x;
            this.unparseBlockStatement(bs);
            this.pw.println();
        }
    }

    public void visitBreakStatement(Java.BreakStatement bs) {
        this.pw.print("break");
        if (bs.optionalLabel != null) {
            this.pw.print(' ' + bs.optionalLabel);
        }
        this.pw.print(';');
    }

    public void visitContinueStatement(Java.ContinueStatement cs) {
        this.pw.print("continue");
        if (cs.optionalLabel != null) {
            this.pw.print(' ' + cs.optionalLabel);
        }
        this.pw.print(';');
    }

    public void visitDoStatement(Java.DoStatement ds) {
        this.pw.print("do ");
        this.unparseBlockStatement(ds.body);
        this.pw.print("while (");
        this.unparse(ds.condition);
        this.pw.print(");");
    }

    public void visitEmptyStatement(Java.EmptyStatement es) {
        this.pw.print(';');
    }

    public void visitExpressionStatement(Java.ExpressionStatement es) {
        this.unparse(es.rvalue);
        this.pw.print(';');
    }

    public void visitForStatement(Java.ForStatement fs) {
        this.pw.print("for (");
        if (fs.optionalInit != null) {
            this.unparseBlockStatement(fs.optionalInit);
        } else {
            this.pw.print(';');
        }
        if (fs.optionalCondition != null) {
            this.pw.print(' ');
            this.unparse(fs.optionalCondition);
        }
        this.pw.print(';');
        if (fs.optionalUpdate != null) {
            this.pw.print(' ');
            for (int i = 0; i < fs.optionalUpdate.length; ++i) {
                if (i > 0) {
                    this.pw.print(", ");
                }
                this.unparse(fs.optionalUpdate[i]);
            }
        }
        this.pw.print(") ");
        this.unparseBlockStatement(fs.body);
    }

    public void visitIfStatement(Java.IfStatement is) {
        this.pw.print("if (");
        this.unparse(is.condition);
        this.pw.print(") ");
        this.unparseBlockStatement(is.thenStatement);
        if (is.optionalElseStatement != null) {
            this.pw.println(" else");
            this.unparseBlockStatement(is.optionalElseStatement);
        }
    }

    public void visitLabeledStatement(Java.LabeledStatement ls) {
        this.pw.println(ls.label + ':');
        this.unparseBlockStatement(ls.body);
    }

    public void visitLocalClassDeclarationStatement(Java.LocalClassDeclarationStatement lcds) {
        this.unparseTypeDeclaration(lcds.lcd);
    }

    public void visitLocalVariableDeclarationStatement(Java.LocalVariableDeclarationStatement lvds) {
        this.unparseModifiers(lvds.modifiers);
        this.unparseType(lvds.type);
        this.pw.print(' ');
        this.pw.print('\uffff');
        this.unparseVariableDeclarator(lvds.variableDeclarators[0]);
        for (int i = 1; i < lvds.variableDeclarators.length; ++i) {
            this.pw.print(", ");
            this.unparseVariableDeclarator(lvds.variableDeclarators[i]);
        }
        this.pw.print(';');
    }

    public void visitReturnStatement(Java.ReturnStatement rs) {
        this.pw.print("return");
        if (rs.optionalReturnValue != null) {
            this.pw.print(' ');
            this.unparse(rs.optionalReturnValue);
        }
        this.pw.print(';');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitSwitchStatement(Java.SwitchStatement ss) {
        this.pw.print("switch (");
        this.unparse(ss.condition);
        this.pw.println(") {");
        Iterator it = ss.sbsgs.iterator();
        while (it.hasNext()) {
            Iterator it2;
            Java.SwitchStatement.SwitchBlockStatementGroup sbgs = (Java.SwitchStatement.SwitchBlockStatementGroup)it.next();
            this.pw.print('\ufffc');
            try {
                it2 = sbgs.caseLabels.iterator();
                while (it2.hasNext()) {
                    Java.Rvalue rv = (Java.Rvalue)it2.next();
                    this.pw.print("case ");
                    this.unparse(rv);
                    this.pw.println(':');
                }
                if (sbgs.hasDefaultLabel) {
                    this.pw.println("default:");
                }
            }
            finally {
                this.pw.print('\ufffd');
            }
            it2 = sbgs.blockStatements.iterator();
            while (it2.hasNext()) {
                this.unparseBlockStatement((Java.BlockStatement)it2.next());
                this.pw.println();
            }
        }
        this.pw.print('}');
    }

    public void visitSynchronizedStatement(Java.SynchronizedStatement ss) {
        this.pw.print("synchronized (");
        this.unparse(ss.expression);
        this.pw.print(") ");
        this.unparseBlockStatement(ss.body);
    }

    public void visitThrowStatement(Java.ThrowStatement ts) {
        this.pw.print("throw ");
        this.unparse(ts.expression);
        this.pw.print(';');
    }

    public void visitTryStatement(Java.TryStatement ts) {
        this.pw.print("try ");
        this.unparseBlockStatement(ts.body);
        Iterator it = ts.catchClauses.iterator();
        while (it.hasNext()) {
            Java.CatchClause cc = (Java.CatchClause)it.next();
            this.pw.print(" catch (");
            this.unparseFormalParameter(cc.caughtException);
            this.pw.print(") ");
            this.unparseBlockStatement(cc.body);
        }
        if (ts.optionalFinally != null) {
            this.pw.print(" finally ");
            this.unparseBlockStatement(ts.optionalFinally);
        }
    }

    public void visitWhileStatement(Java.WhileStatement ws) {
        this.pw.print("while (");
        this.unparse(ws.condition);
        this.pw.print(") ");
        this.unparseBlockStatement(ws.body);
    }

    public void unparseVariableDeclarator(Java.VariableDeclarator vd) {
        this.pw.print(vd.name);
        for (int i = 0; i < vd.brackets; ++i) {
            this.pw.print("[]");
        }
        if (vd.optionalInitializer != null) {
            this.pw.print(" = ");
            this.unparseArrayInitializerOrRvalue(vd.optionalInitializer);
        }
    }

    public void unparseFormalParameter(Java.FunctionDeclarator.FormalParameter fp) {
        if (fp.finaL) {
            this.pw.print("final ");
        }
        this.unparseType(fp.type);
        this.pw.print(" \uffff" + fp.name);
    }

    public void visitMethodInvocation(Java.MethodInvocation mi) {
        if (mi.optionalTarget != null) {
            this.unparseLhs(mi.optionalTarget, ".");
            this.pw.print('.');
        }
        this.pw.print(mi.methodName);
        this.unparseFunctionInvocationArguments(mi.arguments);
    }

    public void visitAlternateConstructorInvocation(Java.AlternateConstructorInvocation aci) {
        this.pw.print("this");
        this.unparseFunctionInvocationArguments(aci.arguments);
    }

    public void visitSuperConstructorInvocation(Java.SuperConstructorInvocation sci) {
        if (sci.optionalQualification != null) {
            this.unparseLhs(sci.optionalQualification, ".");
            this.pw.print('.');
        }
        this.pw.print("super");
        this.unparseFunctionInvocationArguments(sci.arguments);
    }

    public void visitNewClassInstance(Java.NewClassInstance nci) {
        if (nci.optionalQualification != null) {
            this.unparseLhs(nci.optionalQualification, ".");
            this.pw.print('.');
        }
        this.pw.print("new " + nci.type.toString());
        this.unparseFunctionInvocationArguments(nci.arguments);
    }

    public void visitAssignment(Java.Assignment a) {
        this.unparseLhs(a.lhs, a.operator);
        this.pw.print(' ' + a.operator + ' ');
        this.unparseRhs(a.rhs, a.operator);
    }

    public void visitAmbiguousName(Java.AmbiguousName an) {
        this.pw.print(an.toString());
    }

    public void visitArrayAccessExpression(Java.ArrayAccessExpression aae) {
        this.unparseLhs(aae.lhs, "[ ]");
        this.pw.print('[');
        this.unparse(aae.index);
        this.pw.print(']');
    }

    public void visitArrayLength(Java.ArrayLength al) {
        this.unparseLhs(al.lhs, ".");
        this.pw.print(".length");
    }

    public void visitArrayType(Java.ArrayType at) {
        this.unparseType(at.componentType);
        this.pw.print("[]");
    }

    public void visitBasicType(Java.BasicType bt) {
        this.pw.print(bt.toString());
    }

    public void visitBinaryOperation(Java.BinaryOperation bo) {
        this.unparseLhs(bo.lhs, bo.op);
        this.pw.print(' ' + bo.op + ' ');
        this.unparseRhs(bo.rhs, bo.op);
    }

    public void visitCast(Java.Cast c) {
        this.pw.print('(');
        this.unparseType(c.targetType);
        this.pw.print(") ");
        this.unparseRhs(c.value, "cast");
    }

    public void visitClassLiteral(Java.ClassLiteral cl) {
        this.unparseType(cl.type);
        this.pw.print(".class");
    }

    public void visitConditionalExpression(Java.ConditionalExpression ce) {
        this.unparseLhs(ce.lhs, "?:");
        this.pw.print(" ? ");
        this.unparseLhs(ce.mhs, "?:");
        this.pw.print(" : ");
        this.unparseRhs(ce.rhs, "?:");
    }

    public void visitCrement(Java.Crement c) {
        if (c.pre) {
            this.pw.print(c.operator);
            this.unparseUnaryOperation(c.operand, c.operator + "x");
        } else {
            this.unparseUnaryOperation(c.operand, "x" + c.operator);
            this.pw.print(c.operator);
        }
    }

    public void visitFieldAccess(Java.FieldAccess fa) {
        this.unparseLhs(fa.lhs, ".");
        this.pw.print('.' + fa.field.getName());
    }

    public void visitFieldAccessExpression(Java.FieldAccessExpression fae) {
        this.unparseLhs(fae.lhs, ".");
        this.pw.print('.' + fae.fieldName);
    }

    public void visitSuperclassFieldAccessExpression(Java.SuperclassFieldAccessExpression scfae) {
        if (scfae.optionalQualification != null) {
            this.unparseType(scfae.optionalQualification);
            this.pw.print(".super." + scfae.fieldName);
        } else {
            this.pw.print("super." + scfae.fieldName);
        }
    }

    public void visitInstanceof(Java.Instanceof io) {
        this.unparseLhs(io.lhs, "instanceof");
        this.pw.print(" instanceof ");
        this.unparseType(io.rhs);
    }

    public void visitLiteral(Java.Literal l) {
        this.pw.print(l.toString());
    }

    public void visitLocalVariableAccess(Java.LocalVariableAccess lva) {
        this.pw.print(lva.toString());
    }

    public void visitNewArray(Java.NewArray na) {
        int i;
        this.pw.print("new ");
        this.unparseType(na.type);
        for (i = 0; i < na.dimExprs.length; ++i) {
            this.pw.print('[');
            this.unparse(na.dimExprs[i]);
            this.pw.print(']');
        }
        for (i = 0; i < na.dims; ++i) {
            this.pw.print("[]");
        }
    }

    public void visitNewInitializedArray(Java.NewInitializedArray nai) {
        this.pw.print("new ");
        this.unparseType(nai.arrayType);
        this.pw.print(" ");
        this.unparseArrayInitializerOrRvalue(nai.arrayInitializer);
    }

    public void visitPackage(Java.Package p) {
        this.pw.print(p.toString());
    }

    public void visitParameterAccess(Java.ParameterAccess pa) {
        this.pw.print(pa.toString());
    }

    public void visitQualifiedThisReference(Java.QualifiedThisReference qtr) {
        this.unparseType(qtr.qualification);
        this.pw.print(".this");
    }

    public void visitReferenceType(Java.ReferenceType rt) {
        this.pw.print(rt.toString());
    }

    public void visitRvalueMemberType(Java.RvalueMemberType rmt) {
        this.pw.print(rmt.toString());
    }

    public void visitSimpleType(Java.SimpleType st) {
        this.pw.print(st.toString());
    }

    public void visitSuperclassMethodInvocation(Java.SuperclassMethodInvocation smi) {
        this.pw.print("super." + smi.methodName);
        this.unparseFunctionInvocationArguments(smi.arguments);
    }

    public void visitThisReference(Java.ThisReference tr) {
        this.pw.print("this");
    }

    public void visitUnaryOperation(Java.UnaryOperation uo) {
        this.pw.print(uo.operator);
        this.unparseUnaryOperation(uo.operand, uo.operator + "x");
    }

    public void visitParenthesizedExpression(Java.ParenthesizedExpression pe) {
        this.pw.print('(');
        this.unparse(pe.value);
        this.pw.print(')');
    }

    private void unparseBlockStatement(Java.BlockStatement blockStatement) {
        blockStatement.accept(this);
    }

    private void unparseTypeDeclaration(Java.TypeDeclaration typeDeclaration) {
        typeDeclaration.accept(this);
    }

    private void unparseType(Java.Type type) {
        type.accept(this);
    }

    private void unparse(Java.Atom operand) {
        operand.accept(this);
    }

    private void unparseUnaryOperation(Java.Rvalue operand, String unaryOperator) {
        int cmp = UnparseVisitor.comparePrecedence(unaryOperator, operand);
        this.unparse(operand, cmp < 0);
    }

    private void unparseLhs(Java.Atom lhs, String binaryOperator) {
        int cmp = UnparseVisitor.comparePrecedence(binaryOperator, lhs);
        this.unparse(lhs, cmp < 0 || cmp == 0 && UnparseVisitor.isLeftAssociate(binaryOperator));
    }

    private void unparseRhs(Java.Rvalue rhs, String binaryOperator) {
        int cmp = UnparseVisitor.comparePrecedence(binaryOperator, rhs);
        this.unparse(rhs, cmp < 0 || cmp == 0 && UnparseVisitor.isRightAssociate(binaryOperator));
    }

    private void unparse(Java.Atom operand, boolean natural) {
        if (!natural) {
            this.pw.print("((( ");
        }
        this.unparse(operand);
        if (!natural) {
            this.pw.print(" )))");
        }
    }

    private static boolean isRightAssociate(String op) {
        return RIGHT_ASSOCIATIVE_OPERATORS.contains(op);
    }

    private static boolean isLeftAssociate(String op) {
        return LEFT_ASSOCIATIVE_OPERATORS.contains(op);
    }

    private static int comparePrecedence(String operator, Java.Atom operand) {
        if (operand instanceof Java.BinaryOperation) {
            return UnparseVisitor.getOperatorPrecedence(operator) - UnparseVisitor.getOperatorPrecedence(((Java.BinaryOperation)operand).op);
        }
        if (operand instanceof Java.UnaryOperation) {
            return UnparseVisitor.getOperatorPrecedence(operator) - UnparseVisitor.getOperatorPrecedence(((Java.UnaryOperation)operand).operator + "x");
        }
        if (operand instanceof Java.ConditionalExpression) {
            return UnparseVisitor.getOperatorPrecedence(operator) - UnparseVisitor.getOperatorPrecedence("?:");
        }
        if (operand instanceof Java.Instanceof) {
            return UnparseVisitor.getOperatorPrecedence(operator) - UnparseVisitor.getOperatorPrecedence("instanceof");
        }
        if (operand instanceof Java.Cast) {
            return UnparseVisitor.getOperatorPrecedence(operator) - UnparseVisitor.getOperatorPrecedence("cast");
        }
        if (operand instanceof Java.MethodInvocation || operand instanceof Java.FieldAccess) {
            return UnparseVisitor.getOperatorPrecedence(operator) - UnparseVisitor.getOperatorPrecedence(".");
        }
        if (operand instanceof Java.NewArray) {
            return UnparseVisitor.getOperatorPrecedence(operator) - UnparseVisitor.getOperatorPrecedence("new");
        }
        if (operand instanceof Java.Crement) {
            Java.Crement c = (Java.Crement)operand;
            return UnparseVisitor.getOperatorPrecedence(operator) - UnparseVisitor.getOperatorPrecedence(c.pre ? c.operator + "x" : "x" + c.operator);
        }
        return -1;
    }

    private static int getOperatorPrecedence(String operator) {
        return (Integer)OPERATOR_PRECEDENCE.get(operator);
    }

    private void unparseNamedClassDeclaration(Java.NamedClassDeclaration ncd) {
        this.unparseDocComment(ncd);
        this.unparseModifiers(ncd.getModifiers());
        this.pw.print("class " + ncd.name);
        if (ncd.optionalExtendedType != null) {
            this.pw.print(" extends ");
            this.unparseType(ncd.optionalExtendedType);
        }
        if (ncd.implementedTypes.length > 0) {
            this.pw.print(" implements " + Java.join(ncd.implementedTypes, ", "));
        }
        this.pw.println(" {");
        this.pw.print('\ufffd');
        this.unparseClassDeclarationBody(ncd);
        this.pw.print("\ufffc}");
    }

    private void unparseArrayInitializerOrRvalue(Java.ArrayInitializerOrRvalue aiorv) {
        if (aiorv instanceof Java.Rvalue) {
            this.unparse((Java.Rvalue)aiorv);
        } else if (aiorv instanceof Java.ArrayInitializer) {
            Java.ArrayInitializer ai = (Java.ArrayInitializer)aiorv;
            if (ai.values.length == 0) {
                this.pw.print("{}");
            } else {
                this.pw.print("{ ");
                this.unparseArrayInitializerOrRvalue(ai.values[0]);
                for (int i = 1; i < ai.values.length; ++i) {
                    this.pw.print(", ");
                    this.unparseArrayInitializerOrRvalue(ai.values[i]);
                }
                this.pw.print(" }");
            }
        } else {
            throw new JaninoRuntimeException("Unexpected array initializer or rvalue class " + aiorv.getClass().getName());
        }
    }

    public void visitAnonymousClassDeclaration(Java.AnonymousClassDeclaration acd) {
        this.unparseType(acd.baseType);
        this.pw.println(" {");
        this.pw.print('\ufffd');
        this.unparseClassDeclarationBody(acd);
        this.pw.print("\ufffc}");
    }

    public void visitNewAnonymousClassInstance(Java.NewAnonymousClassInstance naci) {
        if (naci.optionalQualification != null) {
            this.unparseLhs(naci.optionalQualification, ".");
            this.pw.print('.');
        }
        this.pw.print("new " + naci.anonymousClassDeclaration.baseType.toString() + '(');
        for (int i = 0; i < naci.arguments.length; ++i) {
            if (i > 0) {
                this.pw.print(", ");
            }
            this.unparse(naci.arguments[i]);
        }
        this.pw.println(") {");
        this.pw.print('\ufffd');
        this.unparseClassDeclarationBody(naci.anonymousClassDeclaration);
        this.pw.print("\ufffc}");
    }

    private void unparseClassDeclarationBody(Java.ClassDeclaration cd) {
        Iterator it = cd.constructors.iterator();
        while (it.hasNext()) {
            this.pw.println();
            ((Java.ConstructorDeclarator)it.next()).accept(this);
            this.pw.println();
        }
        this.unparseAbstractTypeDeclarationBody(cd);
        it = cd.variableDeclaratorsAndInitializers.iterator();
        while (it.hasNext()) {
            this.pw.println();
            ((Java.TypeBodyDeclaration)it.next()).accept(this);
            this.pw.println();
        }
    }

    private void unparseInterfaceDeclaration(Java.InterfaceDeclaration id) {
        this.unparseDocComment(id);
        this.unparseModifiers(id.getModifiers());
        if ((id.getModifiers() & 0x200) == 0) {
            this.pw.print("interface ");
        }
        this.pw.print(id.name);
        if (id.extendedTypes.length > 0) {
            this.pw.print(" extends " + Java.join(id.extendedTypes, ", "));
        }
        this.pw.println(" {");
        this.pw.print('\ufffd');
        this.unparseAbstractTypeDeclarationBody(id);
        Iterator it = id.constantDeclarations.iterator();
        while (it.hasNext()) {
            ((Java.TypeBodyDeclaration)it.next()).accept(this);
            this.pw.println();
        }
        this.pw.print("\ufffc}");
    }

    private void unparseAbstractTypeDeclarationBody(Java.AbstractTypeDeclaration atd) {
        Iterator it = atd.getMethodDeclarations().iterator();
        while (it.hasNext()) {
            this.pw.println();
            ((Java.MethodDeclarator)it.next()).accept(this);
            this.pw.println();
        }
        it = atd.getMemberTypeDeclarations().iterator();
        while (it.hasNext()) {
            this.pw.println();
            ((Java.TypeBodyDeclaration)it.next()).accept(this);
            this.pw.println();
        }
    }

    private void unparseFunctionDeclaratorRest(Java.FunctionDeclarator fd) {
        boolean big = fd.formalParameters.length >= 4;
        this.pw.print('(');
        if (big) {
            this.pw.println();
            this.pw.print('\ufffd');
        }
        for (int i = 0; i < fd.formalParameters.length; ++i) {
            if (i > 0) {
                if (big) {
                    this.pw.println(',');
                } else {
                    this.pw.print(", ");
                }
            }
            this.unparseFormalParameter(fd.formalParameters[i]);
        }
        if (big) {
            this.pw.println();
            this.pw.print('\ufffc');
        }
        this.pw.print(')');
        if (fd.thrownExceptions.length > 0) {
            this.pw.print(" throws " + Java.join(fd.thrownExceptions, ", "));
        }
    }

    private void unparseDocComment(Java.DocCommentable dc) {
        String optionalDocComment = dc.getDocComment();
        if (optionalDocComment != null) {
            this.pw.print("/**");
            BufferedReader br = new BufferedReader(new StringReader(optionalDocComment));
            while (true) {
                String line;
                try {
                    line = br.readLine();
                }
                catch (IOException e) {
                    throw new JaninoRuntimeException();
                }
                if (line == null) break;
                this.pw.println(line);
                this.pw.print(" *");
            }
            this.pw.println("/");
        }
    }

    private void unparseModifiers(short modifiers) {
        if (modifiers != 0) {
            this.pw.print(Mod.shortToString(modifiers) + ' ');
        }
    }

    private void unparseFunctionInvocationArguments(Java.Rvalue[] arguments) {
        boolean big = arguments.length >= 5;
        this.pw.print('(');
        if (big) {
            this.pw.println();
            this.pw.print('\ufffd');
        }
        for (int i = 0; i < arguments.length; ++i) {
            if (i > 0) {
                if (big) {
                    this.pw.println(',');
                } else {
                    this.pw.print(", ");
                }
            }
            this.unparse(arguments[i]);
        }
        if (big) {
            this.pw.println();
            this.pw.print('\ufffc');
        }
        this.pw.print(')');
    }

    static {
        Object[] ops = new Object[]{RIGHT_ASSOCIATIVE_OPERATORS, "=", "*=", "/=", "%=", "+=", "-=", "<<=", ">>=", ">>>=", "&=", "^=", "|=", RIGHT_ASSOCIATIVE_OPERATORS, "?:", LEFT_ASSOCIATIVE_OPERATORS, "||", LEFT_ASSOCIATIVE_OPERATORS, "&&", LEFT_ASSOCIATIVE_OPERATORS, "|", LEFT_ASSOCIATIVE_OPERATORS, "^", LEFT_ASSOCIATIVE_OPERATORS, "&", LEFT_ASSOCIATIVE_OPERATORS, "==", "!=", LEFT_ASSOCIATIVE_OPERATORS, "<", ">", "<=", ">=", "instanceof", LEFT_ASSOCIATIVE_OPERATORS, "<<", ">>", ">>>", LEFT_ASSOCIATIVE_OPERATORS, "+", "-", LEFT_ASSOCIATIVE_OPERATORS, "*", "/", "%", RIGHT_ASSOCIATIVE_OPERATORS, "cast", UNARY_OPERATORS, "++x", "--x", "+x", "-x", "~x", "!x", UNARY_OPERATORS, "x++", "x--", LEFT_ASSOCIATIVE_OPERATORS, "new", LEFT_ASSOCIATIVE_OPERATORS, ".", "[ ]"};
        int precedence = 0;
        int i = 0;
        block0: while (true) {
            Set s = (Set)ops[i++];
            Integer pi = new Integer(++precedence);
            while (i != ops.length) {
                if (!(ops[i] instanceof String)) continue block0;
                String op = (String)ops[i++];
                s.add(op);
                OPERATOR_PRECEDENCE.put(op, pi);
            }
            break;
        }
    }
}

