/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.command;

import VASSAL.build.GameModule;
import VASSAL.command.Command;
import VASSAL.command.MovePiece;
import VASSAL.counters.GamePiece;
import java.awt.Point;

public class MoveTracker {
    private String oldMapId;
    private Point oldPosition;
    private String oldUnderneathId;
    private GamePiece piece;

    public MoveTracker(GamePiece gamePiece) {
        this.piece = gamePiece;
        this.oldMapId = this.getMapId();
        this.oldPosition = gamePiece.getPosition();
        this.oldUnderneathId = this.getUnderneathId();
    }

    private String getUnderneathId() {
        int n;
        String string = null;
        if (this.piece.getParent() != null && (n = this.piece.getParent().indexOf(this.piece)) > 0) {
            string = this.piece.getParent().getPieceAt(n - 1).getId();
        }
        return string;
    }

    private String getMapId() {
        return this.piece.getMap() == null ? null : this.piece.getMap().getIdentifier();
    }

    public Command getMoveCommand() {
        return new MovePiece(this.piece.getId(), this.getMapId(), this.piece.getPosition(), this.getUnderneathId(), this.oldMapId, this.oldPosition, this.oldUnderneathId, GameModule.getUserId());
    }
}

