/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat;

import VASSAL.Info;
import VASSAL.build.GameModule;
import VASSAL.chat.PlayerStatus;
import VASSAL.tools.SequenceEncoder;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class SimpleStatus
implements PlayerStatus {
    public static final String CRC = "crc";
    public static final String MODULE_VERSION = "moduleVersion";
    public static final String IP = "ip";
    public static final String CLIENT = "client";
    public static final String PROFILE = "profile";
    public static final String AWAY = "away";
    public static final String LOOKING = "looking";
    public static final String NAME = "name";
    private boolean looking;
    private boolean away;
    private String profile;
    private String client;
    private String ip;
    private String moduleVersion;
    private String crc;

    public SimpleStatus() {
        this(false, false, "");
    }

    public SimpleStatus(boolean bl, boolean bl2) {
        this(bl, bl2, "");
    }

    public SimpleStatus(boolean bl, boolean bl2, String string) {
        this(bl, bl2, string, "", "", "", "");
    }

    public SimpleStatus(boolean bl, boolean bl2, String string, String string2, String string3, String string4, String string5) {
        this.looking = bl;
        this.away = bl2;
        this.profile = string;
        this.client = string2;
        this.ip = string3;
        this.moduleVersion = string4;
        this.crc = string5;
    }

    public boolean isAway() {
        return this.away;
    }

    public boolean isLooking() {
        return this.looking;
    }

    public String getProfile() {
        return this.profile;
    }

    public String getClient() {
        return this.client;
    }

    public String getIp() {
        return this.ip;
    }

    public String getModuleVersion() {
        return this.moduleVersion;
    }

    public String getCrc() {
        return this.crc;
    }

    public static String encode(SimpleStatus simpleStatus) {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(',');
        sequenceEncoder.append(simpleStatus.looking);
        sequenceEncoder.append(simpleStatus.away);
        sequenceEncoder.append(simpleStatus.profile);
        sequenceEncoder.append(simpleStatus.client);
        sequenceEncoder.append(simpleStatus.ip);
        sequenceEncoder.append(simpleStatus.moduleVersion);
        sequenceEncoder.append(simpleStatus.crc);
        return sequenceEncoder.getValue();
    }

    public static SimpleStatus decode(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ',');
        return new SimpleStatus(decoder.nextBoolean(false), decoder.nextBoolean(false), decoder.nextToken(""), decoder.nextToken(""), decoder.nextToken(""), decoder.nextToken(""), decoder.nextToken(""));
    }

    public void updateStatus() {
        GameModule gameModule = GameModule.getGameModule();
        this.profile = (String)gameModule.getPrefs().getValue("Profile");
        this.client = Info.getVersion();
        this.ip = "";
        try {
            this.ip = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.moduleVersion = gameModule.getGameVersion() + (gameModule.getArchiveWriter() == null ? "" : " (Editing)");
        this.crc = Long.toHexString(gameModule.getCrc());
    }
}

