/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.gamepieceimage.ColorSwatch;
import VASSAL.configure.Configurer;
import VASSAL.configure.SingleChildInstance;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorManager
extends AbstractConfigurable {
    protected static ColorManager instance;
    public static final Color DEFAULT_COLOR;
    public static final String SELECT_COLOR = "Select...";
    protected static Color[] standardColors;
    protected static String[] standardColorNames;
    protected Map<String, ColorSwatch> userColors = new HashMap<String, ColorSwatch>();

    public static ColorManager getColorManager() {
        return instance;
    }

    protected static String getStandardColorName(Color color) {
        for (int i = 0; i < standardColors.length; ++i) {
            if (!standardColors[i].equals(color)) continue;
            return standardColorNames[i];
        }
        return null;
    }

    protected static Color getStandardColor(String string) {
        for (int i = 0; i < standardColors.length; ++i) {
            if (!standardColorNames[i].equals(string)) continue;
            return standardColors[i];
        }
        return null;
    }

    public ColorManager() {
        instance = this;
    }

    public ColorSwatch getColorSwatch(String string) {
        ColorSwatch colorSwatch = this.userColors.get(string);
        if (colorSwatch == null) {
            colorSwatch = new ColorSwatch(string, ColorManager.getStandardColor(string));
        }
        return colorSwatch;
    }

    public ColorSwatch getColorSwatch(Color color) {
        if (color == null) {
            return new ColorSwatch("CLEAR", null);
        }
        ColorSwatch colorSwatch = null;
        for (ColorSwatch colorSwatch2 : this.userColors.values()) {
            if (!color.equals(colorSwatch2.getColor())) continue;
            colorSwatch = colorSwatch2;
            break;
        }
        if (colorSwatch == null) {
            for (int i = 0; i < standardColors.length && colorSwatch == null; ++i) {
                if (standardColors[i] == null || !standardColors[i].equals(color)) continue;
                colorSwatch = new ColorSwatch(standardColorNames[i], standardColors[i]);
            }
        }
        if (colorSwatch == null) {
            colorSwatch = new ColorSwatch(SELECT_COLOR, color);
        }
        return colorSwatch;
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[0];
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[0];
    }

    @Override
    public String[] getAttributeNames() {
        return new String[0];
    }

    @Override
    public String getAttributeValueString(String string) {
        return null;
    }

    @Override
    public void setAttribute(String string, Object object) {
    }

    @Override
    public Configurer getConfigurer() {
        return null;
    }

    @Override
    public void addTo(Buildable buildable) {
        this.validator = new SingleChildInstance(GameModule.getGameModule(), this.getClass());
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{ColorSwatch.class};
    }

    public static String getConfigureTypeName() {
        return "Named Colors";
    }

    @Override
    public void add(Buildable buildable) {
        super.add(buildable);
        if (buildable instanceof ColorSwatch) {
            ColorSwatch colorSwatch = (ColorSwatch)buildable;
            this.userColors.put(colorSwatch.getConfigureName(), colorSwatch);
            colorSwatch.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("name".equals(propertyChangeEvent.getPropertyName())) {
                        ColorManager.this.userColors.remove((String)propertyChangeEvent.getOldValue());
                        ColorManager.this.userColors.put((String)propertyChangeEvent.getNewValue(), (ColorSwatch)propertyChangeEvent.getSource());
                    }
                }
            });
        }
    }

    @Override
    public void remove(Buildable buildable) {
        super.remove(buildable);
        if (buildable instanceof ColorSwatch) {
            this.userColors.remove(((ColorSwatch)buildable).getConfigureName());
        }
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GamePieceImageDefinitions.htm", "NamedColors");
    }

    @Override
    public void removeFrom(Buildable buildable) {
    }

    public Color getColorByName(String string) {
        ColorSwatch colorSwatch = this.getColorSwatch(string);
        if (colorSwatch != null) {
            Color color = colorSwatch.getColor();
            return color;
        }
        return DEFAULT_COLOR;
    }

    public String[] getColorNames() {
        ArrayList<ColorSwatch> arrayList = new ArrayList<ColorSwatch>(this.userColors.values());
        Collections.sort(arrayList);
        ArrayList<String> arrayList2 = new ArrayList<String>(arrayList.size() + standardColors.length);
        for (ColorSwatch colorSwatch : arrayList) {
            arrayList2.add(colorSwatch.getConfigureName());
        }
        arrayList2.addAll(Arrays.asList(standardColorNames));
        return arrayList2.toArray(new String[arrayList2.size()]);
    }

    static {
        DEFAULT_COLOR = Color.WHITE;
        standardColors = new Color[]{Color.WHITE, Color.GRAY, Color.BLACK, null, Color.RED, Color.GREEN, Color.BLUE, Color.ORANGE, Color.PINK, Color.CYAN, Color.MAGENTA, Color.YELLOW, Color.LIGHT_GRAY, Color.DARK_GRAY};
        standardColorNames = new String[]{"WHITE", "GRAY", "BLACK", "CLEAR", "RED", "GREEN", "BLUE", "ORANGE", "PINK", "CYAN", "MAGENTA", "YELLOW", "LIGHT GRAY", "DARK GRAY"};
    }
}

