TITLE("Creating OCX Controls using U++")
TOPIC_TEXT(
"[2 $$0,0#00000000000000000000000000000000:Default][l288;i1120;a17;O9;~~~.1408;2 "
"$$1,0#10431211400427159095818037425705:param][a83;*R6 $$2,5#31310162474203024125188417583966:caption][b83;*4 "
"$$3,5#07864147445237544204411237157677:title][i288;O9;C2 $$4,6#40027414424643823182269349404212:item][b42;a42;2 "
"$$5,5#45413000475342174754091244180557:text][l288;b17;a17;2 $$6,6#27521748481378242620020725143825:desc][l321;t246;C@5;1 "
"$$7,7#20902679421464641399138805415013:code][b2503; $$8,0#65142375456100023862071332075487:separator][*@(0.0.255)2 "
"$$9,0#83433469410354161042741608181528:base][t4167;C $$10,0#37138531426314131251341829483380:class][l288;a17;*1 "
"$$11,11#70004532496200323422659154056402:requirement][i417;b42;a42;O9;~~~.416;2 $$12,12#10566046415157235020018451313112:tparam][b167;C2 "
"$$13,13#92430459443460461911108080531343:item1][i288;a42;O9;C2 $$14,14#77422149456609303542238260500223:item2][*@2$(0.128.128) "
"$$15,15#34511555403152284025741354420178:NewsDate][l321;*C$7;2 $$16,16#03451589433145915344929335295360:result][l321;b83;a83;*C$7;2 "
"$$17,17#07531550463529505371228428965313:result`-line][l160;t4167;*C+117 $$18,5#88603949442205825958800053222425:package`-title][ "
"$$19,0#53580023442335529039900623488521:gap][t4167;C2 $$20,20#70211524482531209251820423858195:class`-nested][b50;2 "
"$$21,21#03324558446220344731010354752573:Par][{_}%EN-US [s2; Creating OCX Controls "
"using U`+`+&][s0; &][s0;i150;O9; 1.-|Use the U`+`+ version later than 2005`-11`-24. "
"There was a very nasty bug in the OCX registration routine, capable of deleting half "
"of CLSID registry keys and consequently nuking Windows installation. (Actually, this "
"was not a bug in the routine as such, it was a bug in one of the overloads of the "
"AsString routine).&][s0; &][s0;i150;O9; 2.-|Add DLL to the main configuration flags. "
"This is more or less all that`'s needed to build into aDLL (OCX is technically a "
"DLL).&][s0; &][s0;i150;O9; 3.-|You have to build the OCX interface using MIDL. You "
"can use a custom step to do this:&][s0; &")
TOPIC_TEXT(
"][s7; Custom step (extension `= idl), output files: `$(DIR)/`$(TITLE)`_idl.h,&][s7; "
"`$(DIR)/`$(TITLE)`_idl.cpp, `$(DIR)/`$(TITLE).tlb&][s7; &][s7; midl /newtlb `$(!/I) "
"/h `\"`$(DIR)/`$(TITLE)`_idl.h`\" /iid&][s7; `\"`$(DIR)/`$(TITLE)`_idl.cpp`\" /tlb "
"`\"`$(DIR)/`$(TITLE).tlb`\" `\"`$(PATH)`\"&][s0; &][s0;i150;O9; 4.-|You have to define "
"a def`-file to declare public exports, like this:&][s0; &][s7; LIBRARY `\"mycontrol.ocx`\"&][s7; "
"&][s7; EXPORTS&][s7; DllCanUnloadNow     PRIVATE&][s7; DllGetClassObject   PRIVATE&][s7; "
"DllRegisterServer   PRIVATE&][s7; DllUnregisterServer PRIVATE&][s0; &][s0;i150;O9; "
"5.-|You need to put the type library (the TLB file created by MIDL from the IDL file) "
"into your resources. Put this line on the beginning of your resource file:&][s0; "
"&][s7; 1 TYPELIB `\"mycontrol.tlb`\"&][s0; &][s0; Do not forget to manually add `\"mycontrol.tlb`\" "
"to the list of the resource file`'s dependencies. Otherwise next time you change "
"the IDL file and the MIDL recompiles your TLB, TheIDE builder won`'t find out it "
"needs to rebuild the resource script.&][s0; &][s0;i150;O9; 6.-|In the application, "
"#include <Ole/Ctrl/OleCtrl.h> and use OCX`_APP`_MAIN to declare the `\"main`\" initialization "
"routine. To be honest, the initialization routine is not really called during the "
"very startup (DllMain `-> DLL`_PROCESS`_ATTACH), its invocation is postponed until "
"1st object from the library is requested from the type factory. The reason for this "
"is that too heavy initializations tend to deadlock or crash the Windows DLL loader.&][s0; "
"&][s0;i150;O9; 7.-|To make an object an OCX control, derive it from OcxControl. You "
"should also use multiple inheritance to derive it from your custom interfaces, perhaps "
"like this:&][s0; &][s7; class MyViewOcx&][s7; : public OcxControl // handles OCX "
"control client functionality&][s7; , public DispatchInterface<IMyView> // custom "
"control`'s interface&][s7; , public OcxConnectionPointContainer // needed only for "
"callback (aka event) interface&][s0; &][s0;i150;")
TOPIC_TEXT(
"O9; 8.-|The whole project should be demonstrated in a simple project called Ole/Ctrl/Calc.&][s0;i150;O9; "
"]")
