/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.migrator.internal;

import java.io.File;
import java.io.IOException;
import org.slf4j.migrator.helper.Abbreviator;
import org.slf4j.migrator.internal.MigratorFrame;
import org.slf4j.migrator.internal.ProgressListener;

public class ProgressListenerImpl
implements ProgressListener {
    static final int TARGET_FILE_LENGTH = 85;
    static final int UPDATE_THRESHOLD = 100;
    int addFileCount = 0;
    int scanFileCount = 0;
    int inplaceConversionCount = 0;
    final MigratorFrame frame;
    Abbreviator abbr;
    long lastUpdate = 0L;

    public ProgressListenerImpl(File file, MigratorFrame migratorFrame) {
        this.frame = migratorFrame;
        this.abbr = new Abbreviator((int)file.length(), 85, File.separatorChar);
    }

    @Override
    public void onMigrationBegin() {
        this.frame.disableInput();
    }

    boolean isTooSoon() {
        long l = System.currentTimeMillis();
        if (l - this.lastUpdate < 100L) {
            return true;
        }
        this.lastUpdate = l;
        return false;
    }

    @Override
    public void onDirectory(File file) {
        if (this.isTooSoon()) {
            return;
        }
        String string = this.getShortName(file);
        this.frame.otherLabel.setText("<html><p>Searching folder [" + string + "]<p>Found " + this.addFileCount + " java files to scan.</html>");
    }

    @Override
    public void onDone() {
        this.frame.progressBar.setVisible(false);
        this.frame.otherLabel.setText("<html><font color='BLUE'>Scanned " + this.addFileCount + " java files, " + this.inplaceConversionCount + " files were modified.</font></html>");
        this.frame.migrateButton.setActionCommand("EXIT_COMMAND");
        this.frame.migrateButton.setText("Exit");
        this.frame.migrateButton.setToolTipText("Click on this button to exit this application.");
        this.frame.migrateButton.setEnabled(true);
    }

    @Override
    public void onFileAddition(File file) {
        ++this.addFileCount;
    }

    @Override
    public void onFileScan(File file) {
        ++this.scanFileCount;
        if (this.isTooSoon()) {
            return;
        }
        String string = this.getShortName(file);
        this.frame.otherLabel.setText("<html><p>Scanning file [" + string + "]<p></html>");
        this.frame.progressBar.setValue(this.scanFileCount);
    }

    @Override
    public void onInplaceConversion(File file) {
        ++this.inplaceConversionCount;
    }

    String getShortName(File file) {
        try {
            return this.abbr.abbreviate(file.getCanonicalPath());
        }
        catch (IOException iOException) {
            return file.toString();
        }
    }

    @Override
    public void onFileScanBegin() {
        this.frame.progressBar.setMaximum(this.addFileCount);
        this.frame.progressBar.setValue(0);
        this.frame.progressBar.setVisible(true);
    }
}

