/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.dmt;

import java.io.PrintStream;
import java.util.Vector;
import org.osgi.service.dmt.Uri;

public class DmtException
extends Exception {
    private static final long serialVersionUID = -63006267148118655L;
    public static final int UNAUTHORIZED = 401;
    public static final int NODE_NOT_FOUND = 404;
    public static final int COMMAND_NOT_ALLOWED = 405;
    public static final int FEATURE_NOT_SUPPORTED = 406;
    public static final int LIMIT_EXCEEDED = 413;
    public static final int URI_TOO_LONG = 414;
    public static final int NODE_ALREADY_EXISTS = 418;
    public static final int PERMISSION_DENIED = 425;
    public static final int COMMAND_FAILED = 500;
    public static final int DATA_STORE_FAILURE = 510;
    public static final int ROLLBACK_FAILED = 516;
    public static final int REMOTE_ERROR = 1;
    public static final int METADATA_MISMATCH = 2;
    public static final int INVALID_URI = 3;
    public static final int CONCURRENT_ACCESS = 4;
    public static final int ALERT_NOT_ROUTED = 5;
    public static final int TRANSACTION_ERROR = 6;
    public static final int SESSION_CREATION_TIMEOUT = 7;
    private final String uri;
    private final int code;
    private final String message;
    private final Throwable[] causes;
    private final boolean fatal;

    public DmtException(String string, int n, String string2) {
        this(string, n, string2, new Throwable[0], false);
    }

    public DmtException(String string, int n, String string2, Throwable throwable) {
        Throwable[] throwableArray;
        if (throwable == null) {
            throwableArray = new Throwable[]{};
        } else {
            Throwable[] throwableArray2 = new Throwable[1];
            throwableArray = throwableArray2;
            throwableArray2[0] = throwable;
        }
        this(string, n, string2, throwableArray, false);
    }

    public DmtException(String string, int n, String string2, Vector vector, boolean bl) {
        this(string, n, string2, vector == null ? new Throwable[]{} : vector.toArray(new Throwable[vector.size()]), bl);
    }

    private DmtException(String string, int n, String string2, Throwable[] throwableArray, boolean bl) {
        super((Throwable)null);
        this.uri = string;
        this.code = n;
        this.message = string2;
        this.causes = throwableArray;
        this.fatal = bl;
    }

    public DmtException(String[] stringArray, int n, String string) {
        this(DmtException.pathToUri(stringArray), n, string);
    }

    public DmtException(String[] stringArray, int n, String string, Throwable throwable) {
        this(DmtException.pathToUri(stringArray), n, string, throwable);
    }

    public DmtException(String[] stringArray, int n, String string, Vector vector, boolean bl) {
        this(DmtException.pathToUri(stringArray), n, string, vector, bl);
    }

    public String getURI() {
        return this.uri;
    }

    public int getCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        StringBuffer stringBuffer = new StringBuffer(DmtException.getCodeText(this.code));
        if (this.uri != null) {
            stringBuffer.append(": '").append(this.uri).append('\'');
        }
        if (this.message != null) {
            stringBuffer.append(": ").append(this.message);
        }
        return stringBuffer.toString();
    }

    @Override
    public Throwable getCause() {
        return this.causes.length == 0 ? null : this.causes[0];
    }

    public Throwable[] getCauses() {
        return (Throwable[])this.causes.clone();
    }

    public boolean isFatal() {
        return this.fatal;
    }

    @Override
    public void printStackTrace(PrintStream printStream) {
        super.printStackTrace(printStream);
        for (int i = 0; i < this.causes.length; ++i) {
            printStream.print("Caused by" + (i > 0 ? " (" + (i + 1) + ")" : "") + ": ");
            this.causes[i].printStackTrace(printStream);
        }
    }

    static String pathToUri(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        return Uri.toUri(stringArray);
    }

    private static String getCodeText(int n) {
        switch (n) {
            case 404: {
                return "NODE_NOT_FOUND";
            }
            case 405: {
                return "COMMAND_NOT_ALLOWED";
            }
            case 406: {
                return "FEATURE_NOT_SUPPORTED";
            }
            case 414: {
                return "URI_TOO_LONG";
            }
            case 418: {
                return "NODE_ALREADY_EXISTS";
            }
            case 425: {
                return "PERMISSION_DENIED";
            }
            case 500: {
                return "COMMAND_FAILED";
            }
            case 510: {
                return "DATA_STORE_FAILURE";
            }
            case 516: {
                return "ROLLBACK_FAILED";
            }
            case 1: {
                return "REMOTE_ERROR";
            }
            case 2: {
                return "METADATA_MISMATCH";
            }
            case 3: {
                return "INVALID_URI";
            }
            case 4: {
                return "CONCURRENT_ACCESS";
            }
            case 5: {
                return "ALERT_NOT_ROUTED";
            }
            case 6: {
                return "TRANSACTION_ERROR";
            }
            case 7: {
                return "SESSION_CREATION_TIMEOUT";
            }
        }
        return "<unknown code>";
    }
}

