//================================================================================
// AKAZE (Generic)
//================================================================================

// GetSet (AKAZE)



// Methods (AKAZE)

static PyObject* pyopencv_cv_AKAZE_create_static(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    PyObject* pyobj_descriptor_type = NULL;
    AKAZE_DescriptorType descriptor_type=AKAZE::DESCRIPTOR_MLDB;
    PyObject* pyobj_descriptor_size = NULL;
    int descriptor_size=0;
    PyObject* pyobj_descriptor_channels = NULL;
    int descriptor_channels=3;
    PyObject* pyobj_threshold = NULL;
    float threshold=0.001f;
    PyObject* pyobj_nOctaves = NULL;
    int nOctaves=4;
    PyObject* pyobj_nOctaveLayers = NULL;
    int nOctaveLayers=4;
    PyObject* pyobj_diffusivity = NULL;
    KAZE_DiffusivityType diffusivity=KAZE::DIFF_PM_G2;
    PyObject* pyobj_max_points = NULL;
    int max_points=-1;
    Ptr<AKAZE> retval;

    const char* keywords[] = { "descriptor_type", "descriptor_size", "descriptor_channels", "threshold", "nOctaves", "nOctaveLayers", "diffusivity", "max_points", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "|OOOOOOOO:AKAZE.create", (char**)keywords, &pyobj_descriptor_type, &pyobj_descriptor_size, &pyobj_descriptor_channels, &pyobj_threshold, &pyobj_nOctaves, &pyobj_nOctaveLayers, &pyobj_diffusivity, &pyobj_max_points) &&
        pyopencv_to_safe(pyobj_descriptor_type, descriptor_type, ArgInfo("descriptor_type", 0)) &&
        pyopencv_to_safe(pyobj_descriptor_size, descriptor_size, ArgInfo("descriptor_size", 0)) &&
        pyopencv_to_safe(pyobj_descriptor_channels, descriptor_channels, ArgInfo("descriptor_channels", 0)) &&
        pyopencv_to_safe(pyobj_threshold, threshold, ArgInfo("threshold", 0)) &&
        pyopencv_to_safe(pyobj_nOctaves, nOctaves, ArgInfo("nOctaves", 0)) &&
        pyopencv_to_safe(pyobj_nOctaveLayers, nOctaveLayers, ArgInfo("nOctaveLayers", 0)) &&
        pyopencv_to_safe(pyobj_diffusivity, diffusivity, ArgInfo("diffusivity", 0)) &&
        pyopencv_to_safe(pyobj_max_points, max_points, ArgInfo("max_points", 0)) )
    {
        ERRWRAP2(retval = cv::AKAZE::create(descriptor_type, descriptor_size, descriptor_channels, threshold, nOctaves, nOctaveLayers, diffusivity, max_points));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_AKAZE_getDefaultName(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::AKAZE> * self1 = 0;
    if (!pyopencv_AKAZE_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'AKAZE' or its derivative)");
    Ptr<cv::AKAZE> _self_ = *(self1);
    String retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getDefaultName());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_AKAZE_getDescriptorChannels(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::AKAZE> * self1 = 0;
    if (!pyopencv_AKAZE_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'AKAZE' or its derivative)");
    Ptr<cv::AKAZE> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getDescriptorChannels());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_AKAZE_getDescriptorSize(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::AKAZE> * self1 = 0;
    if (!pyopencv_AKAZE_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'AKAZE' or its derivative)");
    Ptr<cv::AKAZE> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getDescriptorSize());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_AKAZE_getDescriptorType(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::AKAZE> * self1 = 0;
    if (!pyopencv_AKAZE_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'AKAZE' or its derivative)");
    Ptr<cv::AKAZE> _self_ = *(self1);
    AKAZE::DescriptorType retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getDescriptorType());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_AKAZE_getDiffusivity(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::AKAZE> * self1 = 0;
    if (!pyopencv_AKAZE_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'AKAZE' or its derivative)");
    Ptr<cv::AKAZE> _self_ = *(self1);
    KAZE::DiffusivityType retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getDiffusivity());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_AKAZE_getMaxPoints(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::AKAZE> * self1 = 0;
    if (!pyopencv_AKAZE_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'AKAZE' or its derivative)");
    Ptr<cv::AKAZE> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getMaxPoints());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_AKAZE_getNOctaveLayers(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::AKAZE> * self1 = 0;
    if (!pyopencv_AKAZE_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'AKAZE' or its derivative)");
    Ptr<cv::AKAZE> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getNOctaveLayers());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_AKAZE_getNOctaves(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::AKAZE> * self1 = 0;
    if (!pyopencv_AKAZE_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'AKAZE' or its derivative)");
    Ptr<cv::AKAZE> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getNOctaves());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_AKAZE_getThreshold(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::AKAZE> * self1 = 0;
    if (!pyopencv_AKAZE_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'AKAZE' or its derivative)");
    Ptr<cv::AKAZE> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getThreshold());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_AKAZE_setDescriptorChannels(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::AKAZE> * self1 = 0;
    if (!pyopencv_AKAZE_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'AKAZE' or its derivative)");
    Ptr<cv::AKAZE> _self_ = *(self1);
    PyObject* pyobj_dch = NULL;
    int dch=0;

    const char* keywords[] = { "dch", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:AKAZE.setDescriptorChannels", (char**)keywords, &pyobj_dch) &&
        pyopencv_to_safe(pyobj_dch, dch, ArgInfo("dch", 0)) )
    {
        ERRWRAP2(_self_->setDescriptorChannels(dch));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_AKAZE_setDescriptorSize(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::AKAZE> * self1 = 0;
    if (!pyopencv_AKAZE_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'AKAZE' or its derivative)");
    Ptr<cv::AKAZE> _self_ = *(self1);
    PyObject* pyobj_dsize = NULL;
    int dsize=0;

    const char* keywords[] = { "dsize", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:AKAZE.setDescriptorSize", (char**)keywords, &pyobj_dsize) &&
        pyopencv_to_safe(pyobj_dsize, dsize, ArgInfo("dsize", 0)) )
    {
        ERRWRAP2(_self_->setDescriptorSize(dsize));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_AKAZE_setDescriptorType(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::AKAZE> * self1 = 0;
    if (!pyopencv_AKAZE_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'AKAZE' or its derivative)");
    Ptr<cv::AKAZE> _self_ = *(self1);
    PyObject* pyobj_dtype = NULL;
    AKAZE_DescriptorType dtype=static_cast<AKAZE_DescriptorType>(0);

    const char* keywords[] = { "dtype", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:AKAZE.setDescriptorType", (char**)keywords, &pyobj_dtype) &&
        pyopencv_to_safe(pyobj_dtype, dtype, ArgInfo("dtype", 0)) )
    {
        ERRWRAP2(_self_->setDescriptorType(dtype));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_AKAZE_setDiffusivity(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::AKAZE> * self1 = 0;
    if (!pyopencv_AKAZE_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'AKAZE' or its derivative)");
    Ptr<cv::AKAZE> _self_ = *(self1);
    PyObject* pyobj_diff = NULL;
    KAZE_DiffusivityType diff=static_cast<KAZE_DiffusivityType>(0);

    const char* keywords[] = { "diff", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:AKAZE.setDiffusivity", (char**)keywords, &pyobj_diff) &&
        pyopencv_to_safe(pyobj_diff, diff, ArgInfo("diff", 0)) )
    {
        ERRWRAP2(_self_->setDiffusivity(diff));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_AKAZE_setMaxPoints(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::AKAZE> * self1 = 0;
    if (!pyopencv_AKAZE_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'AKAZE' or its derivative)");
    Ptr<cv::AKAZE> _self_ = *(self1);
    PyObject* pyobj_max_points = NULL;
    int max_points=0;

    const char* keywords[] = { "max_points", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:AKAZE.setMaxPoints", (char**)keywords, &pyobj_max_points) &&
        pyopencv_to_safe(pyobj_max_points, max_points, ArgInfo("max_points", 0)) )
    {
        ERRWRAP2(_self_->setMaxPoints(max_points));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_AKAZE_setNOctaveLayers(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::AKAZE> * self1 = 0;
    if (!pyopencv_AKAZE_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'AKAZE' or its derivative)");
    Ptr<cv::AKAZE> _self_ = *(self1);
    PyObject* pyobj_octaveLayers = NULL;
    int octaveLayers=0;

    const char* keywords[] = { "octaveLayers", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:AKAZE.setNOctaveLayers", (char**)keywords, &pyobj_octaveLayers) &&
        pyopencv_to_safe(pyobj_octaveLayers, octaveLayers, ArgInfo("octaveLayers", 0)) )
    {
        ERRWRAP2(_self_->setNOctaveLayers(octaveLayers));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_AKAZE_setNOctaves(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::AKAZE> * self1 = 0;
    if (!pyopencv_AKAZE_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'AKAZE' or its derivative)");
    Ptr<cv::AKAZE> _self_ = *(self1);
    PyObject* pyobj_octaves = NULL;
    int octaves=0;

    const char* keywords[] = { "octaves", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:AKAZE.setNOctaves", (char**)keywords, &pyobj_octaves) &&
        pyopencv_to_safe(pyobj_octaves, octaves, ArgInfo("octaves", 0)) )
    {
        ERRWRAP2(_self_->setNOctaves(octaves));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_AKAZE_setThreshold(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::AKAZE> * self1 = 0;
    if (!pyopencv_AKAZE_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'AKAZE' or its derivative)");
    Ptr<cv::AKAZE> _self_ = *(self1);
    PyObject* pyobj_threshold = NULL;
    double threshold=0;

    const char* keywords[] = { "threshold", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:AKAZE.setThreshold", (char**)keywords, &pyobj_threshold) &&
        pyopencv_to_safe(pyobj_threshold, threshold, ArgInfo("threshold", 0)) )
    {
        ERRWRAP2(_self_->setThreshold(threshold));
        Py_RETURN_NONE;
    }

    return NULL;
}



// Tables (AKAZE)

static PyGetSetDef pyopencv_AKAZE_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_AKAZE_methods[] =
{
    {"create", CV_PY_FN_WITH_KW_(pyopencv_cv_AKAZE_create_static, METH_STATIC), "create([, descriptor_type[, descriptor_size[, descriptor_channels[, threshold[, nOctaves[, nOctaveLayers[, diffusivity[, max_points]]]]]]]]) -> retval\n.   @brief The AKAZE constructor\n.   \n.       @param descriptor_type Type of the extracted descriptor: DESCRIPTOR_KAZE,\n.       DESCRIPTOR_KAZE_UPRIGHT, DESCRIPTOR_MLDB or DESCRIPTOR_MLDB_UPRIGHT.\n.       @param descriptor_size Size of the descriptor in bits. 0 -\\> Full size\n.       @param descriptor_channels Number of channels in the descriptor (1, 2, 3)\n.       @param threshold Detector response threshold to accept point\n.       @param nOctaves Maximum octave evolution of the image\n.       @param nOctaveLayers Default number of sublevels per scale level\n.       @param diffusivity Diffusivity type. DIFF_PM_G1, DIFF_PM_G2, DIFF_WEICKERT or\n.       DIFF_CHARBONNIER\n.       @param max_points Maximum amount of returned points. In case if image contains\n.       more features, then the features with highest response are returned.\n.       Negative value means no limitation."},
    {"getDefaultName", CV_PY_FN_WITH_KW_(pyopencv_cv_AKAZE_getDefaultName, 0), "getDefaultName() -> retval\n."},
    {"getDescriptorChannels", CV_PY_FN_WITH_KW_(pyopencv_cv_AKAZE_getDescriptorChannels, 0), "getDescriptorChannels() -> retval\n."},
    {"getDescriptorSize", CV_PY_FN_WITH_KW_(pyopencv_cv_AKAZE_getDescriptorSize, 0), "getDescriptorSize() -> retval\n."},
    {"getDescriptorType", CV_PY_FN_WITH_KW_(pyopencv_cv_AKAZE_getDescriptorType, 0), "getDescriptorType() -> retval\n."},
    {"getDiffusivity", CV_PY_FN_WITH_KW_(pyopencv_cv_AKAZE_getDiffusivity, 0), "getDiffusivity() -> retval\n."},
    {"getMaxPoints", CV_PY_FN_WITH_KW_(pyopencv_cv_AKAZE_getMaxPoints, 0), "getMaxPoints() -> retval\n."},
    {"getNOctaveLayers", CV_PY_FN_WITH_KW_(pyopencv_cv_AKAZE_getNOctaveLayers, 0), "getNOctaveLayers() -> retval\n."},
    {"getNOctaves", CV_PY_FN_WITH_KW_(pyopencv_cv_AKAZE_getNOctaves, 0), "getNOctaves() -> retval\n."},
    {"getThreshold", CV_PY_FN_WITH_KW_(pyopencv_cv_AKAZE_getThreshold, 0), "getThreshold() -> retval\n."},
    {"setDescriptorChannels", CV_PY_FN_WITH_KW_(pyopencv_cv_AKAZE_setDescriptorChannels, 0), "setDescriptorChannels(dch) -> None\n."},
    {"setDescriptorSize", CV_PY_FN_WITH_KW_(pyopencv_cv_AKAZE_setDescriptorSize, 0), "setDescriptorSize(dsize) -> None\n."},
    {"setDescriptorType", CV_PY_FN_WITH_KW_(pyopencv_cv_AKAZE_setDescriptorType, 0), "setDescriptorType(dtype) -> None\n."},
    {"setDiffusivity", CV_PY_FN_WITH_KW_(pyopencv_cv_AKAZE_setDiffusivity, 0), "setDiffusivity(diff) -> None\n."},
    {"setMaxPoints", CV_PY_FN_WITH_KW_(pyopencv_cv_AKAZE_setMaxPoints, 0), "setMaxPoints(max_points) -> None\n."},
    {"setNOctaveLayers", CV_PY_FN_WITH_KW_(pyopencv_cv_AKAZE_setNOctaveLayers, 0), "setNOctaveLayers(octaveLayers) -> None\n."},
    {"setNOctaves", CV_PY_FN_WITH_KW_(pyopencv_cv_AKAZE_setNOctaves, 0), "setNOctaves(octaves) -> None\n."},
    {"setThreshold", CV_PY_FN_WITH_KW_(pyopencv_cv_AKAZE_setThreshold, 0), "setThreshold(threshold) -> None\n."},

    {NULL,          NULL}
};

// Converter (AKAZE)

template<>
struct PyOpenCV_Converter< Ptr<cv::AKAZE> >
{
    static PyObject* from(const Ptr<cv::AKAZE>& r)
    {
        return pyopencv_AKAZE_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::AKAZE>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::AKAZE> * dst_;
        if (pyopencv_AKAZE_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::AKAZE> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// AffineFeature (Generic)
//================================================================================

// GetSet (AffineFeature)



// Methods (AffineFeature)

static PyObject* pyopencv_cv_AffineFeature_create_static(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    PyObject* pyobj_backend = NULL;
    Ptr<Feature2D> backend;
    PyObject* pyobj_maxTilt = NULL;
    int maxTilt=5;
    PyObject* pyobj_minTilt = NULL;
    int minTilt=0;
    PyObject* pyobj_tiltStep = NULL;
    float tiltStep=1.4142135623730951f;
    PyObject* pyobj_rotateStepBase = NULL;
    float rotateStepBase=72;
    Ptr<AffineFeature> retval;

    const char* keywords[] = { "backend", "maxTilt", "minTilt", "tiltStep", "rotateStepBase", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|OOOO:AffineFeature.create", (char**)keywords, &pyobj_backend, &pyobj_maxTilt, &pyobj_minTilt, &pyobj_tiltStep, &pyobj_rotateStepBase) &&
        pyopencv_to_safe(pyobj_backend, backend, ArgInfo("backend", 0)) &&
        pyopencv_to_safe(pyobj_maxTilt, maxTilt, ArgInfo("maxTilt", 0)) &&
        pyopencv_to_safe(pyobj_minTilt, minTilt, ArgInfo("minTilt", 0)) &&
        pyopencv_to_safe(pyobj_tiltStep, tiltStep, ArgInfo("tiltStep", 0)) &&
        pyopencv_to_safe(pyobj_rotateStepBase, rotateStepBase, ArgInfo("rotateStepBase", 0)) )
    {
        ERRWRAP2(retval = cv::AffineFeature::create(backend, maxTilt, minTilt, tiltStep, rotateStepBase));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_AffineFeature_getDefaultName(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::AffineFeature> * self1 = 0;
    if (!pyopencv_AffineFeature_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'AffineFeature' or its derivative)");
    Ptr<cv::AffineFeature> _self_ = *(self1);
    String retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getDefaultName());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_AffineFeature_getViewParams(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::AffineFeature> * self1 = 0;
    if (!pyopencv_AffineFeature_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'AffineFeature' or its derivative)");
    Ptr<cv::AffineFeature> _self_ = *(self1);
    PyObject* pyobj_tilts = NULL;
    vector_float tilts;
    PyObject* pyobj_rolls = NULL;
    vector_float rolls;

    const char* keywords[] = { "tilts", "rolls", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO:AffineFeature.getViewParams", (char**)keywords, &pyobj_tilts, &pyobj_rolls) &&
        pyopencv_to_safe(pyobj_tilts, tilts, ArgInfo("tilts", 0)) &&
        pyopencv_to_safe(pyobj_rolls, rolls, ArgInfo("rolls", 0)) )
    {
        ERRWRAP2(_self_->getViewParams(tilts, rolls));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_AffineFeature_setViewParams(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::AffineFeature> * self1 = 0;
    if (!pyopencv_AffineFeature_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'AffineFeature' or its derivative)");
    Ptr<cv::AffineFeature> _self_ = *(self1);
    PyObject* pyobj_tilts = NULL;
    vector_float tilts;
    PyObject* pyobj_rolls = NULL;
    vector_float rolls;

    const char* keywords[] = { "tilts", "rolls", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO:AffineFeature.setViewParams", (char**)keywords, &pyobj_tilts, &pyobj_rolls) &&
        pyopencv_to_safe(pyobj_tilts, tilts, ArgInfo("tilts", 0)) &&
        pyopencv_to_safe(pyobj_rolls, rolls, ArgInfo("rolls", 0)) )
    {
        ERRWRAP2(_self_->setViewParams(tilts, rolls));
        Py_RETURN_NONE;
    }

    return NULL;
}



// Tables (AffineFeature)

static PyGetSetDef pyopencv_AffineFeature_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_AffineFeature_methods[] =
{
    {"create", CV_PY_FN_WITH_KW_(pyopencv_cv_AffineFeature_create_static, METH_STATIC), "create(backend[, maxTilt[, minTilt[, tiltStep[, rotateStepBase]]]]) -> retval\n.   @param backend The detector/extractor you want to use as backend.\n.       @param maxTilt The highest power index of tilt factor. 5 is used in the paper as tilt sampling range n.\n.       @param minTilt The lowest power index of tilt factor. 0 is used in the paper.\n.       @param tiltStep Tilt sampling step \\f$\\delta_t\\f$ in Algorithm 1 in the paper.\n.       @param rotateStepBase Rotation sampling step factor b in Algorithm 1 in the paper."},
    {"getDefaultName", CV_PY_FN_WITH_KW_(pyopencv_cv_AffineFeature_getDefaultName, 0), "getDefaultName() -> retval\n."},
    {"getViewParams", CV_PY_FN_WITH_KW_(pyopencv_cv_AffineFeature_getViewParams, 0), "getViewParams(tilts, rolls) -> None\n."},
    {"setViewParams", CV_PY_FN_WITH_KW_(pyopencv_cv_AffineFeature_setViewParams, 0), "setViewParams(tilts, rolls) -> None\n."},

    {NULL,          NULL}
};

// Converter (AffineFeature)

template<>
struct PyOpenCV_Converter< Ptr<cv::AffineFeature> >
{
    static PyObject* from(const Ptr<cv::AffineFeature>& r)
    {
        return pyopencv_AffineFeature_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::AffineFeature>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::AffineFeature> * dst_;
        if (pyopencv_AffineFeature_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::AffineFeature> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// AffineTransformer (Generic)
//================================================================================

// GetSet (AffineTransformer)



// Methods (AffineTransformer)

static PyObject* pyopencv_cv_AffineTransformer_getFullAffine(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::AffineTransformer> * self1 = 0;
    if (!pyopencv_AffineTransformer_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'AffineTransformer' or its derivative)");
    Ptr<cv::AffineTransformer> _self_ = *(self1);
    bool retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getFullAffine());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_AffineTransformer_setFullAffine(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::AffineTransformer> * self1 = 0;
    if (!pyopencv_AffineTransformer_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'AffineTransformer' or its derivative)");
    Ptr<cv::AffineTransformer> _self_ = *(self1);
    PyObject* pyobj_fullAffine = NULL;
    bool fullAffine=0;

    const char* keywords[] = { "fullAffine", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:AffineTransformer.setFullAffine", (char**)keywords, &pyobj_fullAffine) &&
        pyopencv_to_safe(pyobj_fullAffine, fullAffine, ArgInfo("fullAffine", 0)) )
    {
        ERRWRAP2(_self_->setFullAffine(fullAffine));
        Py_RETURN_NONE;
    }

    return NULL;
}



// Tables (AffineTransformer)

static PyGetSetDef pyopencv_AffineTransformer_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_AffineTransformer_methods[] =
{
    {"getFullAffine", CV_PY_FN_WITH_KW_(pyopencv_cv_AffineTransformer_getFullAffine, 0), "getFullAffine() -> retval\n."},
    {"setFullAffine", CV_PY_FN_WITH_KW_(pyopencv_cv_AffineTransformer_setFullAffine, 0), "setFullAffine(fullAffine) -> None\n."},

    {NULL,          NULL}
};

// Converter (AffineTransformer)

template<>
struct PyOpenCV_Converter< Ptr<cv::AffineTransformer> >
{
    static PyObject* from(const Ptr<cv::AffineTransformer>& r)
    {
        return pyopencv_AffineTransformer_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::AffineTransformer>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::AffineTransformer> * dst_;
        if (pyopencv_AffineTransformer_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::AffineTransformer> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// AgastFeatureDetector (Generic)
//================================================================================

// GetSet (AgastFeatureDetector)



// Methods (AgastFeatureDetector)

static PyObject* pyopencv_cv_AgastFeatureDetector_create_static(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    PyObject* pyobj_threshold = NULL;
    int threshold=10;
    PyObject* pyobj_nonmaxSuppression = NULL;
    bool nonmaxSuppression=true;
    PyObject* pyobj_type = NULL;
    AgastFeatureDetector_DetectorType type=AgastFeatureDetector::OAST_9_16;
    Ptr<AgastFeatureDetector> retval;

    const char* keywords[] = { "threshold", "nonmaxSuppression", "type", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "|OOO:AgastFeatureDetector.create", (char**)keywords, &pyobj_threshold, &pyobj_nonmaxSuppression, &pyobj_type) &&
        pyopencv_to_safe(pyobj_threshold, threshold, ArgInfo("threshold", 0)) &&
        pyopencv_to_safe(pyobj_nonmaxSuppression, nonmaxSuppression, ArgInfo("nonmaxSuppression", 0)) &&
        pyopencv_to_safe(pyobj_type, type, ArgInfo("type", 0)) )
    {
        ERRWRAP2(retval = cv::AgastFeatureDetector::create(threshold, nonmaxSuppression, type));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_AgastFeatureDetector_getDefaultName(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::AgastFeatureDetector> * self1 = 0;
    if (!pyopencv_AgastFeatureDetector_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'AgastFeatureDetector' or its derivative)");
    Ptr<cv::AgastFeatureDetector> _self_ = *(self1);
    String retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getDefaultName());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_AgastFeatureDetector_getNonmaxSuppression(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::AgastFeatureDetector> * self1 = 0;
    if (!pyopencv_AgastFeatureDetector_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'AgastFeatureDetector' or its derivative)");
    Ptr<cv::AgastFeatureDetector> _self_ = *(self1);
    bool retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getNonmaxSuppression());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_AgastFeatureDetector_getThreshold(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::AgastFeatureDetector> * self1 = 0;
    if (!pyopencv_AgastFeatureDetector_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'AgastFeatureDetector' or its derivative)");
    Ptr<cv::AgastFeatureDetector> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getThreshold());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_AgastFeatureDetector_getType(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::AgastFeatureDetector> * self1 = 0;
    if (!pyopencv_AgastFeatureDetector_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'AgastFeatureDetector' or its derivative)");
    Ptr<cv::AgastFeatureDetector> _self_ = *(self1);
    AgastFeatureDetector::DetectorType retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getType());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_AgastFeatureDetector_setNonmaxSuppression(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::AgastFeatureDetector> * self1 = 0;
    if (!pyopencv_AgastFeatureDetector_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'AgastFeatureDetector' or its derivative)");
    Ptr<cv::AgastFeatureDetector> _self_ = *(self1);
    PyObject* pyobj_f = NULL;
    bool f=0;

    const char* keywords[] = { "f", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:AgastFeatureDetector.setNonmaxSuppression", (char**)keywords, &pyobj_f) &&
        pyopencv_to_safe(pyobj_f, f, ArgInfo("f", 0)) )
    {
        ERRWRAP2(_self_->setNonmaxSuppression(f));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_AgastFeatureDetector_setThreshold(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::AgastFeatureDetector> * self1 = 0;
    if (!pyopencv_AgastFeatureDetector_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'AgastFeatureDetector' or its derivative)");
    Ptr<cv::AgastFeatureDetector> _self_ = *(self1);
    PyObject* pyobj_threshold = NULL;
    int threshold=0;

    const char* keywords[] = { "threshold", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:AgastFeatureDetector.setThreshold", (char**)keywords, &pyobj_threshold) &&
        pyopencv_to_safe(pyobj_threshold, threshold, ArgInfo("threshold", 0)) )
    {
        ERRWRAP2(_self_->setThreshold(threshold));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_AgastFeatureDetector_setType(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::AgastFeatureDetector> * self1 = 0;
    if (!pyopencv_AgastFeatureDetector_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'AgastFeatureDetector' or its derivative)");
    Ptr<cv::AgastFeatureDetector> _self_ = *(self1);
    PyObject* pyobj_type = NULL;
    AgastFeatureDetector_DetectorType type=static_cast<AgastFeatureDetector_DetectorType>(0);

    const char* keywords[] = { "type", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:AgastFeatureDetector.setType", (char**)keywords, &pyobj_type) &&
        pyopencv_to_safe(pyobj_type, type, ArgInfo("type", 0)) )
    {
        ERRWRAP2(_self_->setType(type));
        Py_RETURN_NONE;
    }

    return NULL;
}



// Tables (AgastFeatureDetector)

static PyGetSetDef pyopencv_AgastFeatureDetector_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_AgastFeatureDetector_methods[] =
{
    {"create", CV_PY_FN_WITH_KW_(pyopencv_cv_AgastFeatureDetector_create_static, METH_STATIC), "create([, threshold[, nonmaxSuppression[, type]]]) -> retval\n."},
    {"getDefaultName", CV_PY_FN_WITH_KW_(pyopencv_cv_AgastFeatureDetector_getDefaultName, 0), "getDefaultName() -> retval\n."},
    {"getNonmaxSuppression", CV_PY_FN_WITH_KW_(pyopencv_cv_AgastFeatureDetector_getNonmaxSuppression, 0), "getNonmaxSuppression() -> retval\n."},
    {"getThreshold", CV_PY_FN_WITH_KW_(pyopencv_cv_AgastFeatureDetector_getThreshold, 0), "getThreshold() -> retval\n."},
    {"getType", CV_PY_FN_WITH_KW_(pyopencv_cv_AgastFeatureDetector_getType, 0), "getType() -> retval\n."},
    {"setNonmaxSuppression", CV_PY_FN_WITH_KW_(pyopencv_cv_AgastFeatureDetector_setNonmaxSuppression, 0), "setNonmaxSuppression(f) -> None\n."},
    {"setThreshold", CV_PY_FN_WITH_KW_(pyopencv_cv_AgastFeatureDetector_setThreshold, 0), "setThreshold(threshold) -> None\n."},
    {"setType", CV_PY_FN_WITH_KW_(pyopencv_cv_AgastFeatureDetector_setType, 0), "setType(type) -> None\n."},

    {NULL,          NULL}
};

// Converter (AgastFeatureDetector)

template<>
struct PyOpenCV_Converter< Ptr<cv::AgastFeatureDetector> >
{
    static PyObject* from(const Ptr<cv::AgastFeatureDetector>& r)
    {
        return pyopencv_AgastFeatureDetector_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::AgastFeatureDetector>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::AgastFeatureDetector> * dst_;
        if (pyopencv_AgastFeatureDetector_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::AgastFeatureDetector> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// Algorithm (Generic)
//================================================================================

// GetSet (Algorithm)



// Methods (Algorithm)

static PyObject* pyopencv_cv_Algorithm_clear(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Algorithm> * self1 = 0;
    if (!pyopencv_Algorithm_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Algorithm' or its derivative)");
    Ptr<cv::Algorithm> _self_ = *(self1);

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(_self_->clear());
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_Algorithm_empty(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Algorithm> * self1 = 0;
    if (!pyopencv_Algorithm_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Algorithm' or its derivative)");
    Ptr<cv::Algorithm> _self_ = *(self1);
    bool retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->empty());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_Algorithm_getDefaultName(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Algorithm> * self1 = 0;
    if (!pyopencv_Algorithm_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Algorithm' or its derivative)");
    Ptr<cv::Algorithm> _self_ = *(self1);
    String retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getDefaultName());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_Algorithm_read(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Algorithm> * self1 = 0;
    if (!pyopencv_Algorithm_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Algorithm' or its derivative)");
    Ptr<cv::Algorithm> _self_ = *(self1);
    PyObject* pyobj_fn = NULL;
    cv::FileNode fn;

    const char* keywords[] = { "fn", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:Algorithm.read", (char**)keywords, &pyobj_fn) &&
        pyopencv_to_safe(pyobj_fn, fn, ArgInfo("fn", 0)) )
    {
        ERRWRAP2(_self_->read(fn));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_Algorithm_save(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Algorithm> * self1 = 0;
    if (!pyopencv_Algorithm_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Algorithm' or its derivative)");
    Ptr<cv::Algorithm> _self_ = *(self1);
    PyObject* pyobj_filename = NULL;
    String filename;

    const char* keywords[] = { "filename", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:Algorithm.save", (char**)keywords, &pyobj_filename) &&
        pyopencv_to_safe(pyobj_filename, filename, ArgInfo("filename", 0)) )
    {
        ERRWRAP2(_self_->save(filename));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_Algorithm_write(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Algorithm> * self1 = 0;
    if (!pyopencv_Algorithm_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Algorithm' or its derivative)");
    Ptr<cv::Algorithm> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_fs = NULL;
    Ptr<cv::FileStorage> fs;

    const char* keywords[] = { "fs", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:Algorithm.write", (char**)keywords, &pyobj_fs) &&
        pyopencv_to_safe(pyobj_fs, fs, ArgInfo("fs", 0)) )
    {
        ERRWRAP2(_self_->write(*fs));
        Py_RETURN_NONE;
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_fs = NULL;
    Ptr<cv::FileStorage> fs;
    PyObject* pyobj_name = NULL;
    String name;

    const char* keywords[] = { "fs", "name", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO:Algorithm.write", (char**)keywords, &pyobj_fs, &pyobj_name) &&
        pyopencv_to_safe(pyobj_fs, fs, ArgInfo("fs", 0)) &&
        pyopencv_to_safe(pyobj_name, name, ArgInfo("name", 0)) )
    {
        ERRWRAP2(_self_->write(*fs, name));
        Py_RETURN_NONE;
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("write");

    return NULL;
}



// Tables (Algorithm)

static PyGetSetDef pyopencv_Algorithm_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_Algorithm_methods[] =
{
    {"clear", CV_PY_FN_WITH_KW_(pyopencv_cv_Algorithm_clear, 0), "clear() -> None\n.   @brief Clears the algorithm state"},
    {"empty", CV_PY_FN_WITH_KW_(pyopencv_cv_Algorithm_empty, 0), "empty() -> retval\n.   @brief Returns true if the Algorithm is empty (e.g. in the very beginning or after unsuccessful read"},
    {"getDefaultName", CV_PY_FN_WITH_KW_(pyopencv_cv_Algorithm_getDefaultName, 0), "getDefaultName() -> retval\n.   Returns the algorithm string identifier.\n.   This string is used as top level xml/yml node tag when the object is saved to a file or string."},
    {"read", CV_PY_FN_WITH_KW_(pyopencv_cv_Algorithm_read, 0), "read(fn) -> None\n.   @brief Reads algorithm parameters from a file storage"},
    {"save", CV_PY_FN_WITH_KW_(pyopencv_cv_Algorithm_save, 0), "save(filename) -> None\n.   Saves the algorithm to a file.\n.   In order to make this method work, the derived class must implement Algorithm::write(FileStorage& fs)."},
    {"write", CV_PY_FN_WITH_KW_(pyopencv_cv_Algorithm_write, 0), "write(fs) -> None\n.   @brief Stores algorithm parameters in a file storage\n\n\n\nwrite(fs, name) -> None\n.   * @overload"},

    {NULL,          NULL}
};

// Converter (Algorithm)

template<>
struct PyOpenCV_Converter< Ptr<cv::Algorithm> >
{
    static PyObject* from(const Ptr<cv::Algorithm>& r)
    {
        return pyopencv_Algorithm_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::Algorithm>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::Algorithm> * dst_;
        if (pyopencv_Algorithm_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::Algorithm> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// AlignExposures (Generic)
//================================================================================

// GetSet (AlignExposures)



// Methods (AlignExposures)

static PyObject* pyopencv_cv_AlignExposures_process(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::AlignExposures> * self1 = 0;
    if (!pyopencv_AlignExposures_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'AlignExposures' or its derivative)");
    Ptr<cv::AlignExposures> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_src = NULL;
    vector_Mat src;
    PyObject* pyobj_dst = NULL;
    vector_Mat dst;
    PyObject* pyobj_times = NULL;
    Mat times;
    PyObject* pyobj_response = NULL;
    Mat response;

    const char* keywords[] = { "src", "dst", "times", "response", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOOO:AlignExposures.process", (char**)keywords, &pyobj_src, &pyobj_dst, &pyobj_times, &pyobj_response) &&
        pyopencv_to_safe(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to_safe(pyobj_dst, dst, ArgInfo("dst", 0)) &&
        pyopencv_to_safe(pyobj_times, times, ArgInfo("times", 0)) &&
        pyopencv_to_safe(pyobj_response, response, ArgInfo("response", 0)) )
    {
        ERRWRAP2(_self_->process(src, dst, times, response));
        Py_RETURN_NONE;
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_src = NULL;
    vector_UMat src;
    PyObject* pyobj_dst = NULL;
    vector_Mat dst;
    PyObject* pyobj_times = NULL;
    UMat times;
    PyObject* pyobj_response = NULL;
    UMat response;

    const char* keywords[] = { "src", "dst", "times", "response", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOOO:AlignExposures.process", (char**)keywords, &pyobj_src, &pyobj_dst, &pyobj_times, &pyobj_response) &&
        pyopencv_to_safe(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to_safe(pyobj_dst, dst, ArgInfo("dst", 0)) &&
        pyopencv_to_safe(pyobj_times, times, ArgInfo("times", 0)) &&
        pyopencv_to_safe(pyobj_response, response, ArgInfo("response", 0)) )
    {
        ERRWRAP2(_self_->process(src, dst, times, response));
        Py_RETURN_NONE;
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("process");

    return NULL;
}



// Tables (AlignExposures)

static PyGetSetDef pyopencv_AlignExposures_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_AlignExposures_methods[] =
{
    {"process", CV_PY_FN_WITH_KW_(pyopencv_cv_AlignExposures_process, 0), "process(src, dst, times, response) -> None\n.   @brief Aligns images\n.   \n.       @param src vector of input images\n.       @param dst vector of aligned images\n.       @param times vector of exposure time values for each image\n.       @param response 256x1 matrix with inverse camera response function for each pixel value, it should\n.       have the same number of channels as images."},

    {NULL,          NULL}
};

// Converter (AlignExposures)

template<>
struct PyOpenCV_Converter< Ptr<cv::AlignExposures> >
{
    static PyObject* from(const Ptr<cv::AlignExposures>& r)
    {
        return pyopencv_AlignExposures_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::AlignExposures>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::AlignExposures> * dst_;
        if (pyopencv_AlignExposures_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::AlignExposures> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// AlignMTB (Generic)
//================================================================================

// GetSet (AlignMTB)



// Methods (AlignMTB)

static PyObject* pyopencv_cv_AlignMTB_calculateShift(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::AlignMTB> * self1 = 0;
    if (!pyopencv_AlignMTB_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'AlignMTB' or its derivative)");
    Ptr<cv::AlignMTB> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_img0 = NULL;
    Mat img0;
    PyObject* pyobj_img1 = NULL;
    Mat img1;
    Point retval;

    const char* keywords[] = { "img0", "img1", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO:AlignMTB.calculateShift", (char**)keywords, &pyobj_img0, &pyobj_img1) &&
        pyopencv_to_safe(pyobj_img0, img0, ArgInfo("img0", 0)) &&
        pyopencv_to_safe(pyobj_img1, img1, ArgInfo("img1", 0)) )
    {
        ERRWRAP2(retval = _self_->calculateShift(img0, img1));
        return pyopencv_from(retval);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_img0 = NULL;
    UMat img0;
    PyObject* pyobj_img1 = NULL;
    UMat img1;
    Point retval;

    const char* keywords[] = { "img0", "img1", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO:AlignMTB.calculateShift", (char**)keywords, &pyobj_img0, &pyobj_img1) &&
        pyopencv_to_safe(pyobj_img0, img0, ArgInfo("img0", 0)) &&
        pyopencv_to_safe(pyobj_img1, img1, ArgInfo("img1", 0)) )
    {
        ERRWRAP2(retval = _self_->calculateShift(img0, img1));
        return pyopencv_from(retval);
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("calculateShift");

    return NULL;
}

static PyObject* pyopencv_cv_AlignMTB_computeBitmaps(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::AlignMTB> * self1 = 0;
    if (!pyopencv_AlignMTB_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'AlignMTB' or its derivative)");
    Ptr<cv::AlignMTB> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_img = NULL;
    Mat img;
    PyObject* pyobj_tb = NULL;
    Mat tb;
    PyObject* pyobj_eb = NULL;
    Mat eb;

    const char* keywords[] = { "img", "tb", "eb", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|OO:AlignMTB.computeBitmaps", (char**)keywords, &pyobj_img, &pyobj_tb, &pyobj_eb) &&
        pyopencv_to_safe(pyobj_img, img, ArgInfo("img", 0)) &&
        pyopencv_to_safe(pyobj_tb, tb, ArgInfo("tb", 1)) &&
        pyopencv_to_safe(pyobj_eb, eb, ArgInfo("eb", 1)) )
    {
        ERRWRAP2(_self_->computeBitmaps(img, tb, eb));
        return Py_BuildValue("(NN)", pyopencv_from(tb), pyopencv_from(eb));
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_img = NULL;
    UMat img;
    PyObject* pyobj_tb = NULL;
    UMat tb;
    PyObject* pyobj_eb = NULL;
    UMat eb;

    const char* keywords[] = { "img", "tb", "eb", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|OO:AlignMTB.computeBitmaps", (char**)keywords, &pyobj_img, &pyobj_tb, &pyobj_eb) &&
        pyopencv_to_safe(pyobj_img, img, ArgInfo("img", 0)) &&
        pyopencv_to_safe(pyobj_tb, tb, ArgInfo("tb", 1)) &&
        pyopencv_to_safe(pyobj_eb, eb, ArgInfo("eb", 1)) )
    {
        ERRWRAP2(_self_->computeBitmaps(img, tb, eb));
        return Py_BuildValue("(NN)", pyopencv_from(tb), pyopencv_from(eb));
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("computeBitmaps");

    return NULL;
}

static PyObject* pyopencv_cv_AlignMTB_getCut(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::AlignMTB> * self1 = 0;
    if (!pyopencv_AlignMTB_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'AlignMTB' or its derivative)");
    Ptr<cv::AlignMTB> _self_ = *(self1);
    bool retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getCut());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_AlignMTB_getExcludeRange(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::AlignMTB> * self1 = 0;
    if (!pyopencv_AlignMTB_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'AlignMTB' or its derivative)");
    Ptr<cv::AlignMTB> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getExcludeRange());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_AlignMTB_getMaxBits(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::AlignMTB> * self1 = 0;
    if (!pyopencv_AlignMTB_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'AlignMTB' or its derivative)");
    Ptr<cv::AlignMTB> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getMaxBits());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_AlignMTB_process(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::AlignMTB> * self1 = 0;
    if (!pyopencv_AlignMTB_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'AlignMTB' or its derivative)");
    Ptr<cv::AlignMTB> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(4);

    {
    PyObject* pyobj_src = NULL;
    vector_Mat src;
    PyObject* pyobj_dst = NULL;
    vector_Mat dst;
    PyObject* pyobj_times = NULL;
    Mat times;
    PyObject* pyobj_response = NULL;
    Mat response;

    const char* keywords[] = { "src", "dst", "times", "response", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOOO:AlignMTB.process", (char**)keywords, &pyobj_src, &pyobj_dst, &pyobj_times, &pyobj_response) &&
        pyopencv_to_safe(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to_safe(pyobj_dst, dst, ArgInfo("dst", 0)) &&
        pyopencv_to_safe(pyobj_times, times, ArgInfo("times", 0)) &&
        pyopencv_to_safe(pyobj_response, response, ArgInfo("response", 0)) )
    {
        ERRWRAP2(_self_->process(src, dst, times, response));
        Py_RETURN_NONE;
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_src = NULL;
    vector_UMat src;
    PyObject* pyobj_dst = NULL;
    vector_Mat dst;
    PyObject* pyobj_times = NULL;
    UMat times;
    PyObject* pyobj_response = NULL;
    UMat response;

    const char* keywords[] = { "src", "dst", "times", "response", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOOO:AlignMTB.process", (char**)keywords, &pyobj_src, &pyobj_dst, &pyobj_times, &pyobj_response) &&
        pyopencv_to_safe(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to_safe(pyobj_dst, dst, ArgInfo("dst", 0)) &&
        pyopencv_to_safe(pyobj_times, times, ArgInfo("times", 0)) &&
        pyopencv_to_safe(pyobj_response, response, ArgInfo("response", 0)) )
    {
        ERRWRAP2(_self_->process(src, dst, times, response));
        Py_RETURN_NONE;
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_src = NULL;
    vector_Mat src;
    PyObject* pyobj_dst = NULL;
    vector_Mat dst;

    const char* keywords[] = { "src", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO:AlignMTB.process", (char**)keywords, &pyobj_src, &pyobj_dst) &&
        pyopencv_to_safe(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to_safe(pyobj_dst, dst, ArgInfo("dst", 0)) )
    {
        ERRWRAP2(_self_->process(src, dst));
        Py_RETURN_NONE;
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_src = NULL;
    vector_UMat src;
    PyObject* pyobj_dst = NULL;
    vector_Mat dst;

    const char* keywords[] = { "src", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO:AlignMTB.process", (char**)keywords, &pyobj_src, &pyobj_dst) &&
        pyopencv_to_safe(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to_safe(pyobj_dst, dst, ArgInfo("dst", 0)) )
    {
        ERRWRAP2(_self_->process(src, dst));
        Py_RETURN_NONE;
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("process");

    return NULL;
}

static PyObject* pyopencv_cv_AlignMTB_setCut(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::AlignMTB> * self1 = 0;
    if (!pyopencv_AlignMTB_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'AlignMTB' or its derivative)");
    Ptr<cv::AlignMTB> _self_ = *(self1);
    PyObject* pyobj_value = NULL;
    bool value=0;

    const char* keywords[] = { "value", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:AlignMTB.setCut", (char**)keywords, &pyobj_value) &&
        pyopencv_to_safe(pyobj_value, value, ArgInfo("value", 0)) )
    {
        ERRWRAP2(_self_->setCut(value));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_AlignMTB_setExcludeRange(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::AlignMTB> * self1 = 0;
    if (!pyopencv_AlignMTB_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'AlignMTB' or its derivative)");
    Ptr<cv::AlignMTB> _self_ = *(self1);
    PyObject* pyobj_exclude_range = NULL;
    int exclude_range=0;

    const char* keywords[] = { "exclude_range", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:AlignMTB.setExcludeRange", (char**)keywords, &pyobj_exclude_range) &&
        pyopencv_to_safe(pyobj_exclude_range, exclude_range, ArgInfo("exclude_range", 0)) )
    {
        ERRWRAP2(_self_->setExcludeRange(exclude_range));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_AlignMTB_setMaxBits(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::AlignMTB> * self1 = 0;
    if (!pyopencv_AlignMTB_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'AlignMTB' or its derivative)");
    Ptr<cv::AlignMTB> _self_ = *(self1);
    PyObject* pyobj_max_bits = NULL;
    int max_bits=0;

    const char* keywords[] = { "max_bits", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:AlignMTB.setMaxBits", (char**)keywords, &pyobj_max_bits) &&
        pyopencv_to_safe(pyobj_max_bits, max_bits, ArgInfo("max_bits", 0)) )
    {
        ERRWRAP2(_self_->setMaxBits(max_bits));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_AlignMTB_shiftMat(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::AlignMTB> * self1 = 0;
    if (!pyopencv_AlignMTB_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'AlignMTB' or its derivative)");
    Ptr<cv::AlignMTB> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_src = NULL;
    Mat src;
    PyObject* pyobj_dst = NULL;
    Mat dst;
    PyObject* pyobj_shift = NULL;
    Point shift;

    const char* keywords[] = { "src", "shift", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO|O:AlignMTB.shiftMat", (char**)keywords, &pyobj_src, &pyobj_shift, &pyobj_dst) &&
        pyopencv_to_safe(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to_safe(pyobj_dst, dst, ArgInfo("dst", 1)) &&
        pyopencv_to_safe(pyobj_shift, shift, ArgInfo("shift", 0)) )
    {
        ERRWRAP2(_self_->shiftMat(src, dst, shift));
        return pyopencv_from(dst);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_src = NULL;
    UMat src;
    PyObject* pyobj_dst = NULL;
    UMat dst;
    PyObject* pyobj_shift = NULL;
    Point shift;

    const char* keywords[] = { "src", "shift", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO|O:AlignMTB.shiftMat", (char**)keywords, &pyobj_src, &pyobj_shift, &pyobj_dst) &&
        pyopencv_to_safe(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to_safe(pyobj_dst, dst, ArgInfo("dst", 1)) &&
        pyopencv_to_safe(pyobj_shift, shift, ArgInfo("shift", 0)) )
    {
        ERRWRAP2(_self_->shiftMat(src, dst, shift));
        return pyopencv_from(dst);
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("shiftMat");

    return NULL;
}



// Tables (AlignMTB)

static PyGetSetDef pyopencv_AlignMTB_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_AlignMTB_methods[] =
{
    {"calculateShift", CV_PY_FN_WITH_KW_(pyopencv_cv_AlignMTB_calculateShift, 0), "calculateShift(img0, img1) -> retval\n.   @brief Calculates shift between two images, i. e. how to shift the second image to correspond it with the\n.       first.\n.   \n.       @param img0 first image\n.       @param img1 second image"},
    {"computeBitmaps", CV_PY_FN_WITH_KW_(pyopencv_cv_AlignMTB_computeBitmaps, 0), "computeBitmaps(img[, tb[, eb]]) -> tb, eb\n.   @brief Computes median threshold and exclude bitmaps of given image.\n.   \n.       @param img input image\n.       @param tb median threshold bitmap\n.       @param eb exclude bitmap"},
    {"getCut", CV_PY_FN_WITH_KW_(pyopencv_cv_AlignMTB_getCut, 0), "getCut() -> retval\n."},
    {"getExcludeRange", CV_PY_FN_WITH_KW_(pyopencv_cv_AlignMTB_getExcludeRange, 0), "getExcludeRange() -> retval\n."},
    {"getMaxBits", CV_PY_FN_WITH_KW_(pyopencv_cv_AlignMTB_getMaxBits, 0), "getMaxBits() -> retval\n."},
    {"process", CV_PY_FN_WITH_KW_(pyopencv_cv_AlignMTB_process, 0), "process(src, dst, times, response) -> None\n.   \n\n\n\nprocess(src, dst) -> None\n.   @brief Short version of process, that doesn't take extra arguments.\n.   \n.       @param src vector of input images\n.       @param dst vector of aligned images"},
    {"setCut", CV_PY_FN_WITH_KW_(pyopencv_cv_AlignMTB_setCut, 0), "setCut(value) -> None\n."},
    {"setExcludeRange", CV_PY_FN_WITH_KW_(pyopencv_cv_AlignMTB_setExcludeRange, 0), "setExcludeRange(exclude_range) -> None\n."},
    {"setMaxBits", CV_PY_FN_WITH_KW_(pyopencv_cv_AlignMTB_setMaxBits, 0), "setMaxBits(max_bits) -> None\n."},
    {"shiftMat", CV_PY_FN_WITH_KW_(pyopencv_cv_AlignMTB_shiftMat, 0), "shiftMat(src, shift[, dst]) -> dst\n.   @brief Helper function, that shift Mat filling new regions with zeros.\n.   \n.       @param src input image\n.       @param dst result image\n.       @param shift shift value"},

    {NULL,          NULL}
};

// Converter (AlignMTB)

template<>
struct PyOpenCV_Converter< Ptr<cv::AlignMTB> >
{
    static PyObject* from(const Ptr<cv::AlignMTB>& r)
    {
        return pyopencv_AlignMTB_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::AlignMTB>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::AlignMTB> * dst_;
        if (pyopencv_AlignMTB_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::AlignMTB> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// AsyncArray (Generic)
//================================================================================

// GetSet (AsyncArray)



// Methods (AsyncArray)

static int pyopencv_cv_AsyncArray_AsyncArray(pyopencv_AsyncArray_t* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        new (&(self->v)) Ptr<cv::AsyncArray>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::AsyncArray()));
        return 0;
    }

    return -1;
}

static PyObject* pyopencv_cv_AsyncArray_get(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::AsyncArray> * self1 = 0;
    if (!pyopencv_AsyncArray_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'AsyncArray' or its derivative)");
    Ptr<cv::AsyncArray> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(4);

    {
    PyObject* pyobj_dst = NULL;
    Mat dst;

    const char* keywords[] = { "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "|O:AsyncArray.get", (char**)keywords, &pyobj_dst) &&
        pyopencv_to_safe(pyobj_dst, dst, ArgInfo("dst", 1)) )
    {
        ERRWRAP2(_self_->get(dst));
        return pyopencv_from(dst);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_dst = NULL;
    UMat dst;

    const char* keywords[] = { "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "|O:AsyncArray.get", (char**)keywords, &pyobj_dst) &&
        pyopencv_to_safe(pyobj_dst, dst, ArgInfo("dst", 1)) )
    {
        ERRWRAP2(_self_->get(dst));
        return pyopencv_from(dst);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_dst = NULL;
    Mat dst;
    PyObject* pyobj_timeoutNs = NULL;
    double timeoutNs=0;
    bool retval;

    const char* keywords[] = { "timeoutNs", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|O:AsyncArray.get", (char**)keywords, &pyobj_timeoutNs, &pyobj_dst) &&
        pyopencv_to_safe(pyobj_dst, dst, ArgInfo("dst", 1)) &&
        pyopencv_to_safe(pyobj_timeoutNs, timeoutNs, ArgInfo("timeoutNs", 0)) )
    {
        ERRWRAP2(retval = _self_->get(dst, timeoutNs));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(dst));
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_dst = NULL;
    UMat dst;
    PyObject* pyobj_timeoutNs = NULL;
    double timeoutNs=0;
    bool retval;

    const char* keywords[] = { "timeoutNs", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|O:AsyncArray.get", (char**)keywords, &pyobj_timeoutNs, &pyobj_dst) &&
        pyopencv_to_safe(pyobj_dst, dst, ArgInfo("dst", 1)) &&
        pyopencv_to_safe(pyobj_timeoutNs, timeoutNs, ArgInfo("timeoutNs", 0)) )
    {
        ERRWRAP2(retval = _self_->get(dst, timeoutNs));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(dst));
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("get");

    return NULL;
}

static PyObject* pyopencv_cv_AsyncArray_release(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::AsyncArray> * self1 = 0;
    if (!pyopencv_AsyncArray_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'AsyncArray' or its derivative)");
    Ptr<cv::AsyncArray> _self_ = *(self1);

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(_self_->release());
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_AsyncArray_valid(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::AsyncArray> * self1 = 0;
    if (!pyopencv_AsyncArray_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'AsyncArray' or its derivative)");
    Ptr<cv::AsyncArray> _self_ = *(self1);
    bool retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->valid());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_AsyncArray_wait_for(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::AsyncArray> * self1 = 0;
    if (!pyopencv_AsyncArray_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'AsyncArray' or its derivative)");
    Ptr<cv::AsyncArray> _self_ = *(self1);
    PyObject* pyobj_timeoutNs = NULL;
    double timeoutNs=0;
    bool retval;

    const char* keywords[] = { "timeoutNs", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:AsyncArray.wait_for", (char**)keywords, &pyobj_timeoutNs) &&
        pyopencv_to_safe(pyobj_timeoutNs, timeoutNs, ArgInfo("timeoutNs", 0)) )
    {
        ERRWRAP2(retval = _self_->wait_for(timeoutNs));
        return pyopencv_from(retval);
    }

    return NULL;
}



// Tables (AsyncArray)

static PyGetSetDef pyopencv_AsyncArray_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_AsyncArray_methods[] =
{
    {"get", CV_PY_FN_WITH_KW_(pyopencv_cv_AsyncArray_get, 0), "get([, dst]) -> dst\n.   Fetch the result.\n.       @param[out] dst destination array\n.   \n.       Waits for result until container has valid result.\n.       Throws exception if exception was stored as a result.\n.   \n.       Throws exception on invalid container state.\n.   \n.       @note Result or stored exception can be fetched only once.\n\n\n\nget(timeoutNs[, dst]) -> retval, dst\n.   Retrieving the result with timeout\n.       @param[out] dst destination array\n.       @param[in] timeoutNs timeout in nanoseconds, -1 for infinite wait\n.   \n.       @returns true if result is ready, false if the timeout has expired\n.   \n.       @note Result or stored exception can be fetched only once."},
    {"release", CV_PY_FN_WITH_KW_(pyopencv_cv_AsyncArray_release, 0), "release() -> None\n."},
    {"valid", CV_PY_FN_WITH_KW_(pyopencv_cv_AsyncArray_valid, 0), "valid() -> retval\n."},
    {"wait_for", CV_PY_FN_WITH_KW_(pyopencv_cv_AsyncArray_wait_for, 0), "wait_for(timeoutNs) -> retval\n."},

    {NULL,          NULL}
};

// Converter (AsyncArray)

template<>
struct PyOpenCV_Converter< Ptr<cv::AsyncArray> >
{
    static PyObject* from(const Ptr<cv::AsyncArray>& r)
    {
        return pyopencv_AsyncArray_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::AsyncArray>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::AsyncArray> * dst_;
        if (pyopencv_AsyncArray_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::AsyncArray> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// BFMatcher (Generic)
//================================================================================

// GetSet (BFMatcher)



// Methods (BFMatcher)

static int pyopencv_cv_BFMatcher_BFMatcher(pyopencv_BFMatcher_t* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    PyObject* pyobj_normType = NULL;
    int normType=NORM_L2;
    PyObject* pyobj_crossCheck = NULL;
    bool crossCheck=false;

    const char* keywords[] = { "normType", "crossCheck", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "|OO:BFMatcher", (char**)keywords, &pyobj_normType, &pyobj_crossCheck) &&
        pyopencv_to_safe(pyobj_normType, normType, ArgInfo("normType", 0)) &&
        pyopencv_to_safe(pyobj_crossCheck, crossCheck, ArgInfo("crossCheck", 0)) )
    {
        new (&(self->v)) Ptr<cv::BFMatcher>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::BFMatcher(normType, crossCheck)));
        return 0;
    }

    return -1;
}

static PyObject* pyopencv_cv_BFMatcher_create_static(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    PyObject* pyobj_normType = NULL;
    int normType=NORM_L2;
    PyObject* pyobj_crossCheck = NULL;
    bool crossCheck=false;
    Ptr<BFMatcher> retval;

    const char* keywords[] = { "normType", "crossCheck", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "|OO:BFMatcher.create", (char**)keywords, &pyobj_normType, &pyobj_crossCheck) &&
        pyopencv_to_safe(pyobj_normType, normType, ArgInfo("normType", 0)) &&
        pyopencv_to_safe(pyobj_crossCheck, crossCheck, ArgInfo("crossCheck", 0)) )
    {
        ERRWRAP2(retval = cv::BFMatcher::create(normType, crossCheck));
        return pyopencv_from(retval);
    }

    return NULL;
}



// Tables (BFMatcher)

static PyGetSetDef pyopencv_BFMatcher_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_BFMatcher_methods[] =
{
    {"create", CV_PY_FN_WITH_KW_(pyopencv_cv_BFMatcher_create_static, METH_STATIC), "create([, normType[, crossCheck]]) -> retval\n.   @brief Brute-force matcher create method.\n.       @param normType One of NORM_L1, NORM_L2, NORM_HAMMING, NORM_HAMMING2. L1 and L2 norms are\n.       preferable choices for SIFT and SURF descriptors, NORM_HAMMING should be used with ORB, BRISK and\n.       BRIEF, NORM_HAMMING2 should be used with ORB when WTA_K==3 or 4 (see ORB::ORB constructor\n.       description).\n.       @param crossCheck If it is false, this is will be default BFMatcher behaviour when it finds the k\n.       nearest neighbors for each query descriptor. If crossCheck==true, then the knnMatch() method with\n.       k=1 will only return pairs (i,j) such that for i-th query descriptor the j-th descriptor in the\n.       matcher's collection is the nearest and vice versa, i.e. the BFMatcher will only return consistent\n.       pairs. Such technique usually produces best results with minimal number of outliers when there are\n.       enough matches. This is alternative to the ratio test, used by D. Lowe in SIFT paper."},

    {NULL,          NULL}
};

// Converter (BFMatcher)

template<>
struct PyOpenCV_Converter< Ptr<cv::BFMatcher> >
{
    static PyObject* from(const Ptr<cv::BFMatcher>& r)
    {
        return pyopencv_BFMatcher_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::BFMatcher>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::BFMatcher> * dst_;
        if (pyopencv_BFMatcher_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::BFMatcher> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// BOWImgDescriptorExtractor (Generic)
//================================================================================

// GetSet (BOWImgDescriptorExtractor)



// Methods (BOWImgDescriptorExtractor)

static int pyopencv_cv_BOWImgDescriptorExtractor_BOWImgDescriptorExtractor(pyopencv_BOWImgDescriptorExtractor_t* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    PyObject* pyobj_dextractor = NULL;
    Ptr<Feature2D> dextractor;
    PyObject* pyobj_dmatcher = NULL;
    Ptr<DescriptorMatcher> dmatcher;

    const char* keywords[] = { "dextractor", "dmatcher", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO:BOWImgDescriptorExtractor", (char**)keywords, &pyobj_dextractor, &pyobj_dmatcher) &&
        pyopencv_to_safe(pyobj_dextractor, dextractor, ArgInfo("dextractor", 0)) &&
        pyopencv_to_safe(pyobj_dmatcher, dmatcher, ArgInfo("dmatcher", 0)) )
    {
        new (&(self->v)) Ptr<cv::BOWImgDescriptorExtractor>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::BOWImgDescriptorExtractor(dextractor, dmatcher)));
        return 0;
    }

    return -1;
}

static PyObject* pyopencv_cv_BOWImgDescriptorExtractor_compute(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BOWImgDescriptorExtractor> * self1 = 0;
    if (!pyopencv_BOWImgDescriptorExtractor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BOWImgDescriptorExtractor' or its derivative)");
    Ptr<cv::BOWImgDescriptorExtractor> _self_ = *(self1);
    PyObject* pyobj_image = NULL;
    Mat image;
    PyObject* pyobj_keypoints = NULL;
    vector_KeyPoint keypoints;
    PyObject* pyobj_imgDescriptor = NULL;
    Mat imgDescriptor;

    const char* keywords[] = { "image", "keypoints", "imgDescriptor", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO|O:BOWImgDescriptorExtractor.compute", (char**)keywords, &pyobj_image, &pyobj_keypoints, &pyobj_imgDescriptor) &&
        pyopencv_to_safe(pyobj_image, image, ArgInfo("image", 0)) &&
        pyopencv_to_safe(pyobj_keypoints, keypoints, ArgInfo("keypoints", 0)) &&
        pyopencv_to_safe(pyobj_imgDescriptor, imgDescriptor, ArgInfo("imgDescriptor", 1)) )
    {
        ERRWRAP2(_self_->compute2(image, keypoints, imgDescriptor));
        return pyopencv_from(imgDescriptor);
    }

    return NULL;
}

static PyObject* pyopencv_cv_BOWImgDescriptorExtractor_descriptorSize(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BOWImgDescriptorExtractor> * self1 = 0;
    if (!pyopencv_BOWImgDescriptorExtractor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BOWImgDescriptorExtractor' or its derivative)");
    Ptr<cv::BOWImgDescriptorExtractor> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->descriptorSize());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_BOWImgDescriptorExtractor_descriptorType(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BOWImgDescriptorExtractor> * self1 = 0;
    if (!pyopencv_BOWImgDescriptorExtractor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BOWImgDescriptorExtractor' or its derivative)");
    Ptr<cv::BOWImgDescriptorExtractor> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->descriptorType());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_BOWImgDescriptorExtractor_getVocabulary(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BOWImgDescriptorExtractor> * self1 = 0;
    if (!pyopencv_BOWImgDescriptorExtractor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BOWImgDescriptorExtractor' or its derivative)");
    Ptr<cv::BOWImgDescriptorExtractor> _self_ = *(self1);
    Mat retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getVocabulary());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_BOWImgDescriptorExtractor_setVocabulary(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BOWImgDescriptorExtractor> * self1 = 0;
    if (!pyopencv_BOWImgDescriptorExtractor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BOWImgDescriptorExtractor' or its derivative)");
    Ptr<cv::BOWImgDescriptorExtractor> _self_ = *(self1);
    PyObject* pyobj_vocabulary = NULL;
    Mat vocabulary;

    const char* keywords[] = { "vocabulary", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:BOWImgDescriptorExtractor.setVocabulary", (char**)keywords, &pyobj_vocabulary) &&
        pyopencv_to_safe(pyobj_vocabulary, vocabulary, ArgInfo("vocabulary", 0)) )
    {
        ERRWRAP2(_self_->setVocabulary(vocabulary));
        Py_RETURN_NONE;
    }

    return NULL;
}



// Tables (BOWImgDescriptorExtractor)

static PyGetSetDef pyopencv_BOWImgDescriptorExtractor_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_BOWImgDescriptorExtractor_methods[] =
{
    {"compute", CV_PY_FN_WITH_KW_(pyopencv_cv_BOWImgDescriptorExtractor_compute, 0), "compute(image, keypoints[, imgDescriptor]) -> imgDescriptor\n.   @overload\n.       @param keypointDescriptors Computed descriptors to match with vocabulary.\n.       @param imgDescriptor Computed output image descriptor.\n.       @param pointIdxsOfClusters Indices of keypoints that belong to the cluster. This means that\n.       pointIdxsOfClusters[i] are keypoint indices that belong to the i -th cluster (word of vocabulary)\n.       returned if it is non-zero."},
    {"descriptorSize", CV_PY_FN_WITH_KW_(pyopencv_cv_BOWImgDescriptorExtractor_descriptorSize, 0), "descriptorSize() -> retval\n.   @brief Returns an image descriptor size if the vocabulary is set. Otherwise, it returns 0."},
    {"descriptorType", CV_PY_FN_WITH_KW_(pyopencv_cv_BOWImgDescriptorExtractor_descriptorType, 0), "descriptorType() -> retval\n.   @brief Returns an image descriptor type."},
    {"getVocabulary", CV_PY_FN_WITH_KW_(pyopencv_cv_BOWImgDescriptorExtractor_getVocabulary, 0), "getVocabulary() -> retval\n.   @brief Returns the set vocabulary."},
    {"setVocabulary", CV_PY_FN_WITH_KW_(pyopencv_cv_BOWImgDescriptorExtractor_setVocabulary, 0), "setVocabulary(vocabulary) -> None\n.   @brief Sets a visual vocabulary.\n.   \n.       @param vocabulary Vocabulary (can be trained using the inheritor of BOWTrainer ). Each row of the\n.       vocabulary is a visual word (cluster center)."},

    {NULL,          NULL}
};

// Converter (BOWImgDescriptorExtractor)

template<>
struct PyOpenCV_Converter< Ptr<cv::BOWImgDescriptorExtractor> >
{
    static PyObject* from(const Ptr<cv::BOWImgDescriptorExtractor>& r)
    {
        return pyopencv_BOWImgDescriptorExtractor_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::BOWImgDescriptorExtractor>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::BOWImgDescriptorExtractor> * dst_;
        if (pyopencv_BOWImgDescriptorExtractor_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::BOWImgDescriptorExtractor> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// BOWKMeansTrainer (Generic)
//================================================================================

// GetSet (BOWKMeansTrainer)



// Methods (BOWKMeansTrainer)

static int pyopencv_cv_BOWKMeansTrainer_BOWKMeansTrainer(pyopencv_BOWKMeansTrainer_t* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    PyObject* pyobj_clusterCount = NULL;
    int clusterCount=0;
    PyObject* pyobj_termcrit = NULL;
    TermCriteria termcrit;
    PyObject* pyobj_attempts = NULL;
    int attempts=3;
    PyObject* pyobj_flags = NULL;
    int flags=KMEANS_PP_CENTERS;

    const char* keywords[] = { "clusterCount", "termcrit", "attempts", "flags", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|OOO:BOWKMeansTrainer", (char**)keywords, &pyobj_clusterCount, &pyobj_termcrit, &pyobj_attempts, &pyobj_flags) &&
        pyopencv_to_safe(pyobj_clusterCount, clusterCount, ArgInfo("clusterCount", 0)) &&
        pyopencv_to_safe(pyobj_termcrit, termcrit, ArgInfo("termcrit", 0)) &&
        pyopencv_to_safe(pyobj_attempts, attempts, ArgInfo("attempts", 0)) &&
        pyopencv_to_safe(pyobj_flags, flags, ArgInfo("flags", 0)) )
    {
        new (&(self->v)) Ptr<cv::BOWKMeansTrainer>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::BOWKMeansTrainer(clusterCount, termcrit, attempts, flags)));
        return 0;
    }

    return -1;
}

static PyObject* pyopencv_cv_BOWKMeansTrainer_cluster(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BOWKMeansTrainer> * self1 = 0;
    if (!pyopencv_BOWKMeansTrainer_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BOWKMeansTrainer' or its derivative)");
    Ptr<cv::BOWKMeansTrainer> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    Mat retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->cluster());
        return pyopencv_from(retval);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_descriptors = NULL;
    Mat descriptors;
    Mat retval;

    const char* keywords[] = { "descriptors", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:BOWKMeansTrainer.cluster", (char**)keywords, &pyobj_descriptors) &&
        pyopencv_to_safe(pyobj_descriptors, descriptors, ArgInfo("descriptors", 0)) )
    {
        ERRWRAP2(retval = _self_->cluster(descriptors));
        return pyopencv_from(retval);
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("cluster");

    return NULL;
}



// Tables (BOWKMeansTrainer)

static PyGetSetDef pyopencv_BOWKMeansTrainer_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_BOWKMeansTrainer_methods[] =
{
    {"cluster", CV_PY_FN_WITH_KW_(pyopencv_cv_BOWKMeansTrainer_cluster, 0), "cluster() -> retval\n.   \n\n\n\ncluster(descriptors) -> retval\n."},

    {NULL,          NULL}
};

// Converter (BOWKMeansTrainer)

template<>
struct PyOpenCV_Converter< Ptr<cv::BOWKMeansTrainer> >
{
    static PyObject* from(const Ptr<cv::BOWKMeansTrainer>& r)
    {
        return pyopencv_BOWKMeansTrainer_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::BOWKMeansTrainer>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::BOWKMeansTrainer> * dst_;
        if (pyopencv_BOWKMeansTrainer_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::BOWKMeansTrainer> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// BOWTrainer (Generic)
//================================================================================

// GetSet (BOWTrainer)



// Methods (BOWTrainer)

static PyObject* pyopencv_cv_BOWTrainer_add(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BOWTrainer> * self1 = 0;
    if (!pyopencv_BOWTrainer_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BOWTrainer' or its derivative)");
    Ptr<cv::BOWTrainer> _self_ = *(self1);
    PyObject* pyobj_descriptors = NULL;
    Mat descriptors;

    const char* keywords[] = { "descriptors", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:BOWTrainer.add", (char**)keywords, &pyobj_descriptors) &&
        pyopencv_to_safe(pyobj_descriptors, descriptors, ArgInfo("descriptors", 0)) )
    {
        ERRWRAP2(_self_->add(descriptors));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_BOWTrainer_clear(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BOWTrainer> * self1 = 0;
    if (!pyopencv_BOWTrainer_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BOWTrainer' or its derivative)");
    Ptr<cv::BOWTrainer> _self_ = *(self1);

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(_self_->clear());
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_BOWTrainer_cluster(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BOWTrainer> * self1 = 0;
    if (!pyopencv_BOWTrainer_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BOWTrainer' or its derivative)");
    Ptr<cv::BOWTrainer> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    Mat retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->cluster());
        return pyopencv_from(retval);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_descriptors = NULL;
    Mat descriptors;
    Mat retval;

    const char* keywords[] = { "descriptors", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:BOWTrainer.cluster", (char**)keywords, &pyobj_descriptors) &&
        pyopencv_to_safe(pyobj_descriptors, descriptors, ArgInfo("descriptors", 0)) )
    {
        ERRWRAP2(retval = _self_->cluster(descriptors));
        return pyopencv_from(retval);
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("cluster");

    return NULL;
}

static PyObject* pyopencv_cv_BOWTrainer_descriptorsCount(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BOWTrainer> * self1 = 0;
    if (!pyopencv_BOWTrainer_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BOWTrainer' or its derivative)");
    Ptr<cv::BOWTrainer> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->descriptorsCount());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_BOWTrainer_getDescriptors(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BOWTrainer> * self1 = 0;
    if (!pyopencv_BOWTrainer_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BOWTrainer' or its derivative)");
    Ptr<cv::BOWTrainer> _self_ = *(self1);
    std::vector<Mat> retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getDescriptors());
        return pyopencv_from(retval);
    }

    return NULL;
}



// Tables (BOWTrainer)

static PyGetSetDef pyopencv_BOWTrainer_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_BOWTrainer_methods[] =
{
    {"add", CV_PY_FN_WITH_KW_(pyopencv_cv_BOWTrainer_add, 0), "add(descriptors) -> None\n.   @brief Adds descriptors to a training set.\n.   \n.       @param descriptors Descriptors to add to a training set. Each row of the descriptors matrix is a\n.       descriptor.\n.   \n.       The training set is clustered using clustermethod to construct the vocabulary."},
    {"clear", CV_PY_FN_WITH_KW_(pyopencv_cv_BOWTrainer_clear, 0), "clear() -> None\n."},
    {"cluster", CV_PY_FN_WITH_KW_(pyopencv_cv_BOWTrainer_cluster, 0), "cluster() -> retval\n.   @overload\n\n\n\ncluster(descriptors) -> retval\n.   @brief Clusters train descriptors.\n.   \n.       @param descriptors Descriptors to cluster. Each row of the descriptors matrix is a descriptor.\n.       Descriptors are not added to the inner train descriptor set.\n.   \n.       The vocabulary consists of cluster centers. So, this method returns the vocabulary. In the first\n.       variant of the method, train descriptors stored in the object are clustered. In the second variant,\n.       input descriptors are clustered."},
    {"descriptorsCount", CV_PY_FN_WITH_KW_(pyopencv_cv_BOWTrainer_descriptorsCount, 0), "descriptorsCount() -> retval\n.   @brief Returns the count of all descriptors stored in the training set."},
    {"getDescriptors", CV_PY_FN_WITH_KW_(pyopencv_cv_BOWTrainer_getDescriptors, 0), "getDescriptors() -> retval\n.   @brief Returns a training set of descriptors."},

    {NULL,          NULL}
};

// Converter (BOWTrainer)

template<>
struct PyOpenCV_Converter< Ptr<cv::BOWTrainer> >
{
    static PyObject* from(const Ptr<cv::BOWTrainer>& r)
    {
        return pyopencv_BOWTrainer_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::BOWTrainer>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::BOWTrainer> * dst_;
        if (pyopencv_BOWTrainer_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::BOWTrainer> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// BRISK (Generic)
//================================================================================

// GetSet (BRISK)



// Methods (BRISK)

static PyObject* pyopencv_cv_BRISK_create_static(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    pyPrepareArgumentConversionErrorsStorage(3);

    {
    PyObject* pyobj_thresh = NULL;
    int thresh=30;
    PyObject* pyobj_octaves = NULL;
    int octaves=3;
    PyObject* pyobj_patternScale = NULL;
    float patternScale=1.0f;
    Ptr<BRISK> retval;

    const char* keywords[] = { "thresh", "octaves", "patternScale", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "|OOO:BRISK.create", (char**)keywords, &pyobj_thresh, &pyobj_octaves, &pyobj_patternScale) &&
        pyopencv_to_safe(pyobj_thresh, thresh, ArgInfo("thresh", 0)) &&
        pyopencv_to_safe(pyobj_octaves, octaves, ArgInfo("octaves", 0)) &&
        pyopencv_to_safe(pyobj_patternScale, patternScale, ArgInfo("patternScale", 0)) )
    {
        ERRWRAP2(retval = cv::BRISK::create(thresh, octaves, patternScale));
        return pyopencv_from(retval);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_radiusList = NULL;
    vector_float radiusList;
    PyObject* pyobj_numberList = NULL;
    vector_int numberList;
    PyObject* pyobj_dMax = NULL;
    float dMax=5.85f;
    PyObject* pyobj_dMin = NULL;
    float dMin=8.2f;
    PyObject* pyobj_indexChange = NULL;
    vector_int indexChange=std::vector<int>();
    Ptr<BRISK> retval;

    const char* keywords[] = { "radiusList", "numberList", "dMax", "dMin", "indexChange", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO|OOO:BRISK.create", (char**)keywords, &pyobj_radiusList, &pyobj_numberList, &pyobj_dMax, &pyobj_dMin, &pyobj_indexChange) &&
        pyopencv_to_safe(pyobj_radiusList, radiusList, ArgInfo("radiusList", 0)) &&
        pyopencv_to_safe(pyobj_numberList, numberList, ArgInfo("numberList", 0)) &&
        pyopencv_to_safe(pyobj_dMax, dMax, ArgInfo("dMax", 0)) &&
        pyopencv_to_safe(pyobj_dMin, dMin, ArgInfo("dMin", 0)) &&
        pyopencv_to_safe(pyobj_indexChange, indexChange, ArgInfo("indexChange", 0)) )
    {
        ERRWRAP2(retval = cv::BRISK::create(radiusList, numberList, dMax, dMin, indexChange));
        return pyopencv_from(retval);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_thresh = NULL;
    int thresh=0;
    PyObject* pyobj_octaves = NULL;
    int octaves=0;
    PyObject* pyobj_radiusList = NULL;
    vector_float radiusList;
    PyObject* pyobj_numberList = NULL;
    vector_int numberList;
    PyObject* pyobj_dMax = NULL;
    float dMax=5.85f;
    PyObject* pyobj_dMin = NULL;
    float dMin=8.2f;
    PyObject* pyobj_indexChange = NULL;
    vector_int indexChange=std::vector<int>();
    Ptr<BRISK> retval;

    const char* keywords[] = { "thresh", "octaves", "radiusList", "numberList", "dMax", "dMin", "indexChange", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOOO|OOO:BRISK.create", (char**)keywords, &pyobj_thresh, &pyobj_octaves, &pyobj_radiusList, &pyobj_numberList, &pyobj_dMax, &pyobj_dMin, &pyobj_indexChange) &&
        pyopencv_to_safe(pyobj_thresh, thresh, ArgInfo("thresh", 0)) &&
        pyopencv_to_safe(pyobj_octaves, octaves, ArgInfo("octaves", 0)) &&
        pyopencv_to_safe(pyobj_radiusList, radiusList, ArgInfo("radiusList", 0)) &&
        pyopencv_to_safe(pyobj_numberList, numberList, ArgInfo("numberList", 0)) &&
        pyopencv_to_safe(pyobj_dMax, dMax, ArgInfo("dMax", 0)) &&
        pyopencv_to_safe(pyobj_dMin, dMin, ArgInfo("dMin", 0)) &&
        pyopencv_to_safe(pyobj_indexChange, indexChange, ArgInfo("indexChange", 0)) )
    {
        ERRWRAP2(retval = cv::BRISK::create(thresh, octaves, radiusList, numberList, dMax, dMin, indexChange));
        return pyopencv_from(retval);
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("create");

    return NULL;
}

static PyObject* pyopencv_cv_BRISK_getDefaultName(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BRISK> * self1 = 0;
    if (!pyopencv_BRISK_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BRISK' or its derivative)");
    Ptr<cv::BRISK> _self_ = *(self1);
    String retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getDefaultName());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_BRISK_getOctaves(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BRISK> * self1 = 0;
    if (!pyopencv_BRISK_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BRISK' or its derivative)");
    Ptr<cv::BRISK> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getOctaves());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_BRISK_getPatternScale(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BRISK> * self1 = 0;
    if (!pyopencv_BRISK_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BRISK' or its derivative)");
    Ptr<cv::BRISK> _self_ = *(self1);
    float retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getPatternScale());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_BRISK_getThreshold(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BRISK> * self1 = 0;
    if (!pyopencv_BRISK_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BRISK' or its derivative)");
    Ptr<cv::BRISK> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getThreshold());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_BRISK_setOctaves(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BRISK> * self1 = 0;
    if (!pyopencv_BRISK_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BRISK' or its derivative)");
    Ptr<cv::BRISK> _self_ = *(self1);
    PyObject* pyobj_octaves = NULL;
    int octaves=0;

    const char* keywords[] = { "octaves", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:BRISK.setOctaves", (char**)keywords, &pyobj_octaves) &&
        pyopencv_to_safe(pyobj_octaves, octaves, ArgInfo("octaves", 0)) )
    {
        ERRWRAP2(_self_->setOctaves(octaves));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_BRISK_setPatternScale(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BRISK> * self1 = 0;
    if (!pyopencv_BRISK_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BRISK' or its derivative)");
    Ptr<cv::BRISK> _self_ = *(self1);
    PyObject* pyobj_patternScale = NULL;
    float patternScale=0.f;

    const char* keywords[] = { "patternScale", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:BRISK.setPatternScale", (char**)keywords, &pyobj_patternScale) &&
        pyopencv_to_safe(pyobj_patternScale, patternScale, ArgInfo("patternScale", 0)) )
    {
        ERRWRAP2(_self_->setPatternScale(patternScale));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_BRISK_setThreshold(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BRISK> * self1 = 0;
    if (!pyopencv_BRISK_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BRISK' or its derivative)");
    Ptr<cv::BRISK> _self_ = *(self1);
    PyObject* pyobj_threshold = NULL;
    int threshold=0;

    const char* keywords[] = { "threshold", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:BRISK.setThreshold", (char**)keywords, &pyobj_threshold) &&
        pyopencv_to_safe(pyobj_threshold, threshold, ArgInfo("threshold", 0)) )
    {
        ERRWRAP2(_self_->setThreshold(threshold));
        Py_RETURN_NONE;
    }

    return NULL;
}



// Tables (BRISK)

static PyGetSetDef pyopencv_BRISK_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_BRISK_methods[] =
{
    {"create", CV_PY_FN_WITH_KW_(pyopencv_cv_BRISK_create_static, METH_STATIC), "create([, thresh[, octaves[, patternScale]]]) -> retval\n.   @brief The BRISK constructor\n.   \n.       @param thresh AGAST detection threshold score.\n.       @param octaves detection octaves. Use 0 to do single scale.\n.       @param patternScale apply this scale to the pattern used for sampling the neighbourhood of a\n.       keypoint.\n\n\n\ncreate(radiusList, numberList[, dMax[, dMin[, indexChange]]]) -> retval\n.   @brief The BRISK constructor for a custom pattern\n.   \n.       @param radiusList defines the radii (in pixels) where the samples around a keypoint are taken (for\n.       keypoint scale 1).\n.       @param numberList defines the number of sampling points on the sampling circle. Must be the same\n.       size as radiusList..\n.       @param dMax threshold for the short pairings used for descriptor formation (in pixels for keypoint\n.       scale 1).\n.       @param dMin threshold for the long pairings used for orientation determination (in pixels for\n.       keypoint scale 1).\n.   @param indexChange index remapping of the bits.\n\n\n\ncreate(thresh, octaves, radiusList, numberList[, dMax[, dMin[, indexChange]]]) -> retval\n.   @brief The BRISK constructor for a custom pattern, detection threshold and octaves\n.   \n.       @param thresh AGAST detection threshold score.\n.       @param octaves detection octaves. Use 0 to do single scale.\n.       @param radiusList defines the radii (in pixels) where the samples around a keypoint are taken (for\n.       keypoint scale 1).\n.       @param numberList defines the number of sampling points on the sampling circle. Must be the same\n.       size as radiusList..\n.       @param dMax threshold for the short pairings used for descriptor formation (in pixels for keypoint\n.       scale 1).\n.       @param dMin threshold for the long pairings used for orientation determination (in pixels for\n.       keypoint scale 1).\n.   @param indexChange index remapping of the bits."},
    {"getDefaultName", CV_PY_FN_WITH_KW_(pyopencv_cv_BRISK_getDefaultName, 0), "getDefaultName() -> retval\n."},
    {"getOctaves", CV_PY_FN_WITH_KW_(pyopencv_cv_BRISK_getOctaves, 0), "getOctaves() -> retval\n."},
    {"getPatternScale", CV_PY_FN_WITH_KW_(pyopencv_cv_BRISK_getPatternScale, 0), "getPatternScale() -> retval\n."},
    {"getThreshold", CV_PY_FN_WITH_KW_(pyopencv_cv_BRISK_getThreshold, 0), "getThreshold() -> retval\n."},
    {"setOctaves", CV_PY_FN_WITH_KW_(pyopencv_cv_BRISK_setOctaves, 0), "setOctaves(octaves) -> None\n.   @brief Set detection octaves.\n.       @param octaves detection octaves. Use 0 to do single scale."},
    {"setPatternScale", CV_PY_FN_WITH_KW_(pyopencv_cv_BRISK_setPatternScale, 0), "setPatternScale(patternScale) -> None\n.   @brief Set detection patternScale.\n.       @param patternScale apply this scale to the pattern used for sampling the neighbourhood of a\n.       keypoint."},
    {"setThreshold", CV_PY_FN_WITH_KW_(pyopencv_cv_BRISK_setThreshold, 0), "setThreshold(threshold) -> None\n.   @brief Set detection threshold.\n.       @param threshold AGAST detection threshold score."},

    {NULL,          NULL}
};

// Converter (BRISK)

template<>
struct PyOpenCV_Converter< Ptr<cv::BRISK> >
{
    static PyObject* from(const Ptr<cv::BRISK>& r)
    {
        return pyopencv_BRISK_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::BRISK>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::BRISK> * dst_;
        if (pyopencv_BRISK_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::BRISK> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// BackgroundSubtractor (Generic)
//================================================================================

// GetSet (BackgroundSubtractor)



// Methods (BackgroundSubtractor)

static PyObject* pyopencv_cv_BackgroundSubtractor_apply(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BackgroundSubtractor> * self1 = 0;
    if (!pyopencv_BackgroundSubtractor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractor' or its derivative)");
    Ptr<cv::BackgroundSubtractor> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_image = NULL;
    Mat image;
    PyObject* pyobj_fgmask = NULL;
    Mat fgmask;
    PyObject* pyobj_learningRate = NULL;
    double learningRate=-1;

    const char* keywords[] = { "image", "fgmask", "learningRate", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|OO:BackgroundSubtractor.apply", (char**)keywords, &pyobj_image, &pyobj_fgmask, &pyobj_learningRate) &&
        pyopencv_to_safe(pyobj_image, image, ArgInfo("image", 0)) &&
        pyopencv_to_safe(pyobj_fgmask, fgmask, ArgInfo("fgmask", 1)) &&
        pyopencv_to_safe(pyobj_learningRate, learningRate, ArgInfo("learningRate", 0)) )
    {
        ERRWRAP2(_self_->apply(image, fgmask, learningRate));
        return pyopencv_from(fgmask);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_image = NULL;
    UMat image;
    PyObject* pyobj_fgmask = NULL;
    UMat fgmask;
    PyObject* pyobj_learningRate = NULL;
    double learningRate=-1;

    const char* keywords[] = { "image", "fgmask", "learningRate", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|OO:BackgroundSubtractor.apply", (char**)keywords, &pyobj_image, &pyobj_fgmask, &pyobj_learningRate) &&
        pyopencv_to_safe(pyobj_image, image, ArgInfo("image", 0)) &&
        pyopencv_to_safe(pyobj_fgmask, fgmask, ArgInfo("fgmask", 1)) &&
        pyopencv_to_safe(pyobj_learningRate, learningRate, ArgInfo("learningRate", 0)) )
    {
        ERRWRAP2(_self_->apply(image, fgmask, learningRate));
        return pyopencv_from(fgmask);
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("apply");

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractor_getBackgroundImage(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BackgroundSubtractor> * self1 = 0;
    if (!pyopencv_BackgroundSubtractor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractor' or its derivative)");
    Ptr<cv::BackgroundSubtractor> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_backgroundImage = NULL;
    Mat backgroundImage;

    const char* keywords[] = { "backgroundImage", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "|O:BackgroundSubtractor.getBackgroundImage", (char**)keywords, &pyobj_backgroundImage) &&
        pyopencv_to_safe(pyobj_backgroundImage, backgroundImage, ArgInfo("backgroundImage", 1)) )
    {
        ERRWRAP2(_self_->getBackgroundImage(backgroundImage));
        return pyopencv_from(backgroundImage);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_backgroundImage = NULL;
    UMat backgroundImage;

    const char* keywords[] = { "backgroundImage", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "|O:BackgroundSubtractor.getBackgroundImage", (char**)keywords, &pyobj_backgroundImage) &&
        pyopencv_to_safe(pyobj_backgroundImage, backgroundImage, ArgInfo("backgroundImage", 1)) )
    {
        ERRWRAP2(_self_->getBackgroundImage(backgroundImage));
        return pyopencv_from(backgroundImage);
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("getBackgroundImage");

    return NULL;
}



// Tables (BackgroundSubtractor)

static PyGetSetDef pyopencv_BackgroundSubtractor_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_BackgroundSubtractor_methods[] =
{
    {"apply", CV_PY_FN_WITH_KW_(pyopencv_cv_BackgroundSubtractor_apply, 0), "apply(image[, fgmask[, learningRate]]) -> fgmask\n.   @brief Computes a foreground mask.\n.   \n.       @param image Next video frame.\n.       @param fgmask The output foreground mask as an 8-bit binary image.\n.       @param learningRate The value between 0 and 1 that indicates how fast the background model is\n.       learnt. Negative parameter value makes the algorithm to use some automatically chosen learning\n.       rate. 0 means that the background model is not updated at all, 1 means that the background model\n.       is completely reinitialized from the last frame."},
    {"getBackgroundImage", CV_PY_FN_WITH_KW_(pyopencv_cv_BackgroundSubtractor_getBackgroundImage, 0), "getBackgroundImage([, backgroundImage]) -> backgroundImage\n.   @brief Computes a background image.\n.   \n.       @param backgroundImage The output background image.\n.   \n.       @note Sometimes the background image can be very blurry, as it contain the average background\n.       statistics."},

    {NULL,          NULL}
};

// Converter (BackgroundSubtractor)

template<>
struct PyOpenCV_Converter< Ptr<cv::BackgroundSubtractor> >
{
    static PyObject* from(const Ptr<cv::BackgroundSubtractor>& r)
    {
        return pyopencv_BackgroundSubtractor_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::BackgroundSubtractor>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::BackgroundSubtractor> * dst_;
        if (pyopencv_BackgroundSubtractor_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::BackgroundSubtractor> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// BackgroundSubtractorKNN (Generic)
//================================================================================

// GetSet (BackgroundSubtractorKNN)



// Methods (BackgroundSubtractorKNN)

static PyObject* pyopencv_cv_BackgroundSubtractorKNN_getDetectShadows(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BackgroundSubtractorKNN> * self1 = 0;
    if (!pyopencv_BackgroundSubtractorKNN_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorKNN' or its derivative)");
    Ptr<cv::BackgroundSubtractorKNN> _self_ = *(self1);
    bool retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getDetectShadows());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorKNN_getDist2Threshold(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BackgroundSubtractorKNN> * self1 = 0;
    if (!pyopencv_BackgroundSubtractorKNN_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorKNN' or its derivative)");
    Ptr<cv::BackgroundSubtractorKNN> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getDist2Threshold());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorKNN_getHistory(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BackgroundSubtractorKNN> * self1 = 0;
    if (!pyopencv_BackgroundSubtractorKNN_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorKNN' or its derivative)");
    Ptr<cv::BackgroundSubtractorKNN> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getHistory());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorKNN_getNSamples(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BackgroundSubtractorKNN> * self1 = 0;
    if (!pyopencv_BackgroundSubtractorKNN_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorKNN' or its derivative)");
    Ptr<cv::BackgroundSubtractorKNN> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getNSamples());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorKNN_getShadowThreshold(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BackgroundSubtractorKNN> * self1 = 0;
    if (!pyopencv_BackgroundSubtractorKNN_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorKNN' or its derivative)");
    Ptr<cv::BackgroundSubtractorKNN> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getShadowThreshold());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorKNN_getShadowValue(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BackgroundSubtractorKNN> * self1 = 0;
    if (!pyopencv_BackgroundSubtractorKNN_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorKNN' or its derivative)");
    Ptr<cv::BackgroundSubtractorKNN> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getShadowValue());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorKNN_getkNNSamples(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BackgroundSubtractorKNN> * self1 = 0;
    if (!pyopencv_BackgroundSubtractorKNN_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorKNN' or its derivative)");
    Ptr<cv::BackgroundSubtractorKNN> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getkNNSamples());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorKNN_setDetectShadows(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BackgroundSubtractorKNN> * self1 = 0;
    if (!pyopencv_BackgroundSubtractorKNN_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorKNN' or its derivative)");
    Ptr<cv::BackgroundSubtractorKNN> _self_ = *(self1);
    PyObject* pyobj_detectShadows = NULL;
    bool detectShadows=0;

    const char* keywords[] = { "detectShadows", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:BackgroundSubtractorKNN.setDetectShadows", (char**)keywords, &pyobj_detectShadows) &&
        pyopencv_to_safe(pyobj_detectShadows, detectShadows, ArgInfo("detectShadows", 0)) )
    {
        ERRWRAP2(_self_->setDetectShadows(detectShadows));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorKNN_setDist2Threshold(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BackgroundSubtractorKNN> * self1 = 0;
    if (!pyopencv_BackgroundSubtractorKNN_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorKNN' or its derivative)");
    Ptr<cv::BackgroundSubtractorKNN> _self_ = *(self1);
    PyObject* pyobj__dist2Threshold = NULL;
    double _dist2Threshold=0;

    const char* keywords[] = { "_dist2Threshold", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:BackgroundSubtractorKNN.setDist2Threshold", (char**)keywords, &pyobj__dist2Threshold) &&
        pyopencv_to_safe(pyobj__dist2Threshold, _dist2Threshold, ArgInfo("_dist2Threshold", 0)) )
    {
        ERRWRAP2(_self_->setDist2Threshold(_dist2Threshold));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorKNN_setHistory(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BackgroundSubtractorKNN> * self1 = 0;
    if (!pyopencv_BackgroundSubtractorKNN_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorKNN' or its derivative)");
    Ptr<cv::BackgroundSubtractorKNN> _self_ = *(self1);
    PyObject* pyobj_history = NULL;
    int history=0;

    const char* keywords[] = { "history", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:BackgroundSubtractorKNN.setHistory", (char**)keywords, &pyobj_history) &&
        pyopencv_to_safe(pyobj_history, history, ArgInfo("history", 0)) )
    {
        ERRWRAP2(_self_->setHistory(history));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorKNN_setNSamples(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BackgroundSubtractorKNN> * self1 = 0;
    if (!pyopencv_BackgroundSubtractorKNN_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorKNN' or its derivative)");
    Ptr<cv::BackgroundSubtractorKNN> _self_ = *(self1);
    PyObject* pyobj__nN = NULL;
    int _nN=0;

    const char* keywords[] = { "_nN", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:BackgroundSubtractorKNN.setNSamples", (char**)keywords, &pyobj__nN) &&
        pyopencv_to_safe(pyobj__nN, _nN, ArgInfo("_nN", 0)) )
    {
        ERRWRAP2(_self_->setNSamples(_nN));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorKNN_setShadowThreshold(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BackgroundSubtractorKNN> * self1 = 0;
    if (!pyopencv_BackgroundSubtractorKNN_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorKNN' or its derivative)");
    Ptr<cv::BackgroundSubtractorKNN> _self_ = *(self1);
    PyObject* pyobj_threshold = NULL;
    double threshold=0;

    const char* keywords[] = { "threshold", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:BackgroundSubtractorKNN.setShadowThreshold", (char**)keywords, &pyobj_threshold) &&
        pyopencv_to_safe(pyobj_threshold, threshold, ArgInfo("threshold", 0)) )
    {
        ERRWRAP2(_self_->setShadowThreshold(threshold));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorKNN_setShadowValue(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BackgroundSubtractorKNN> * self1 = 0;
    if (!pyopencv_BackgroundSubtractorKNN_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorKNN' or its derivative)");
    Ptr<cv::BackgroundSubtractorKNN> _self_ = *(self1);
    PyObject* pyobj_value = NULL;
    int value=0;

    const char* keywords[] = { "value", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:BackgroundSubtractorKNN.setShadowValue", (char**)keywords, &pyobj_value) &&
        pyopencv_to_safe(pyobj_value, value, ArgInfo("value", 0)) )
    {
        ERRWRAP2(_self_->setShadowValue(value));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorKNN_setkNNSamples(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BackgroundSubtractorKNN> * self1 = 0;
    if (!pyopencv_BackgroundSubtractorKNN_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorKNN' or its derivative)");
    Ptr<cv::BackgroundSubtractorKNN> _self_ = *(self1);
    PyObject* pyobj__nkNN = NULL;
    int _nkNN=0;

    const char* keywords[] = { "_nkNN", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:BackgroundSubtractorKNN.setkNNSamples", (char**)keywords, &pyobj__nkNN) &&
        pyopencv_to_safe(pyobj__nkNN, _nkNN, ArgInfo("_nkNN", 0)) )
    {
        ERRWRAP2(_self_->setkNNSamples(_nkNN));
        Py_RETURN_NONE;
    }

    return NULL;
}



// Tables (BackgroundSubtractorKNN)

static PyGetSetDef pyopencv_BackgroundSubtractorKNN_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_BackgroundSubtractorKNN_methods[] =
{
    {"getDetectShadows", CV_PY_FN_WITH_KW_(pyopencv_cv_BackgroundSubtractorKNN_getDetectShadows, 0), "getDetectShadows() -> retval\n.   @brief Returns the shadow detection flag\n.   \n.       If true, the algorithm detects shadows and marks them. See createBackgroundSubtractorKNN for\n.       details."},
    {"getDist2Threshold", CV_PY_FN_WITH_KW_(pyopencv_cv_BackgroundSubtractorKNN_getDist2Threshold, 0), "getDist2Threshold() -> retval\n.   @brief Returns the threshold on the squared distance between the pixel and the sample\n.   \n.       The threshold on the squared distance between the pixel and the sample to decide whether a pixel is\n.       close to a data sample."},
    {"getHistory", CV_PY_FN_WITH_KW_(pyopencv_cv_BackgroundSubtractorKNN_getHistory, 0), "getHistory() -> retval\n.   @brief Returns the number of last frames that affect the background model"},
    {"getNSamples", CV_PY_FN_WITH_KW_(pyopencv_cv_BackgroundSubtractorKNN_getNSamples, 0), "getNSamples() -> retval\n.   @brief Returns the number of data samples in the background model"},
    {"getShadowThreshold", CV_PY_FN_WITH_KW_(pyopencv_cv_BackgroundSubtractorKNN_getShadowThreshold, 0), "getShadowThreshold() -> retval\n.   @brief Returns the shadow threshold\n.   \n.       A shadow is detected if pixel is a darker version of the background. The shadow threshold (Tau in\n.       the paper) is a threshold defining how much darker the shadow can be. Tau= 0.5 means that if a pixel\n.       is more than twice darker then it is not shadow. See Prati, Mikic, Trivedi and Cucchiara,\n.       *Detecting Moving Shadows...*, IEEE PAMI,2003."},
    {"getShadowValue", CV_PY_FN_WITH_KW_(pyopencv_cv_BackgroundSubtractorKNN_getShadowValue, 0), "getShadowValue() -> retval\n.   @brief Returns the shadow value\n.   \n.       Shadow value is the value used to mark shadows in the foreground mask. Default value is 127. Value 0\n.       in the mask always means background, 255 means foreground."},
    {"getkNNSamples", CV_PY_FN_WITH_KW_(pyopencv_cv_BackgroundSubtractorKNN_getkNNSamples, 0), "getkNNSamples() -> retval\n.   @brief Returns the number of neighbours, the k in the kNN.\n.   \n.       K is the number of samples that need to be within dist2Threshold in order to decide that that\n.       pixel is matching the kNN background model."},
    {"setDetectShadows", CV_PY_FN_WITH_KW_(pyopencv_cv_BackgroundSubtractorKNN_setDetectShadows, 0), "setDetectShadows(detectShadows) -> None\n.   @brief Enables or disables shadow detection"},
    {"setDist2Threshold", CV_PY_FN_WITH_KW_(pyopencv_cv_BackgroundSubtractorKNN_setDist2Threshold, 0), "setDist2Threshold(_dist2Threshold) -> None\n.   @brief Sets the threshold on the squared distance"},
    {"setHistory", CV_PY_FN_WITH_KW_(pyopencv_cv_BackgroundSubtractorKNN_setHistory, 0), "setHistory(history) -> None\n.   @brief Sets the number of last frames that affect the background model"},
    {"setNSamples", CV_PY_FN_WITH_KW_(pyopencv_cv_BackgroundSubtractorKNN_setNSamples, 0), "setNSamples(_nN) -> None\n.   @brief Sets the number of data samples in the background model.\n.   \n.       The model needs to be reinitalized to reserve memory."},
    {"setShadowThreshold", CV_PY_FN_WITH_KW_(pyopencv_cv_BackgroundSubtractorKNN_setShadowThreshold, 0), "setShadowThreshold(threshold) -> None\n.   @brief Sets the shadow threshold"},
    {"setShadowValue", CV_PY_FN_WITH_KW_(pyopencv_cv_BackgroundSubtractorKNN_setShadowValue, 0), "setShadowValue(value) -> None\n.   @brief Sets the shadow value"},
    {"setkNNSamples", CV_PY_FN_WITH_KW_(pyopencv_cv_BackgroundSubtractorKNN_setkNNSamples, 0), "setkNNSamples(_nkNN) -> None\n.   @brief Sets the k in the kNN. How many nearest neighbours need to match."},

    {NULL,          NULL}
};

// Converter (BackgroundSubtractorKNN)

template<>
struct PyOpenCV_Converter< Ptr<cv::BackgroundSubtractorKNN> >
{
    static PyObject* from(const Ptr<cv::BackgroundSubtractorKNN>& r)
    {
        return pyopencv_BackgroundSubtractorKNN_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::BackgroundSubtractorKNN>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::BackgroundSubtractorKNN> * dst_;
        if (pyopencv_BackgroundSubtractorKNN_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::BackgroundSubtractorKNN> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// BackgroundSubtractorMOG2 (Generic)
//================================================================================

// GetSet (BackgroundSubtractorMOG2)



// Methods (BackgroundSubtractorMOG2)

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_apply(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BackgroundSubtractorMOG2> * self1 = 0;
    if (!pyopencv_BackgroundSubtractorMOG2_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    Ptr<cv::BackgroundSubtractorMOG2> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_image = NULL;
    Mat image;
    PyObject* pyobj_fgmask = NULL;
    Mat fgmask;
    PyObject* pyobj_learningRate = NULL;
    double learningRate=-1;

    const char* keywords[] = { "image", "fgmask", "learningRate", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|OO:BackgroundSubtractorMOG2.apply", (char**)keywords, &pyobj_image, &pyobj_fgmask, &pyobj_learningRate) &&
        pyopencv_to_safe(pyobj_image, image, ArgInfo("image", 0)) &&
        pyopencv_to_safe(pyobj_fgmask, fgmask, ArgInfo("fgmask", 1)) &&
        pyopencv_to_safe(pyobj_learningRate, learningRate, ArgInfo("learningRate", 0)) )
    {
        ERRWRAP2(_self_->apply(image, fgmask, learningRate));
        return pyopencv_from(fgmask);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_image = NULL;
    UMat image;
    PyObject* pyobj_fgmask = NULL;
    UMat fgmask;
    PyObject* pyobj_learningRate = NULL;
    double learningRate=-1;

    const char* keywords[] = { "image", "fgmask", "learningRate", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|OO:BackgroundSubtractorMOG2.apply", (char**)keywords, &pyobj_image, &pyobj_fgmask, &pyobj_learningRate) &&
        pyopencv_to_safe(pyobj_image, image, ArgInfo("image", 0)) &&
        pyopencv_to_safe(pyobj_fgmask, fgmask, ArgInfo("fgmask", 1)) &&
        pyopencv_to_safe(pyobj_learningRate, learningRate, ArgInfo("learningRate", 0)) )
    {
        ERRWRAP2(_self_->apply(image, fgmask, learningRate));
        return pyopencv_from(fgmask);
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("apply");

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_getBackgroundRatio(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BackgroundSubtractorMOG2> * self1 = 0;
    if (!pyopencv_BackgroundSubtractorMOG2_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    Ptr<cv::BackgroundSubtractorMOG2> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getBackgroundRatio());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_getComplexityReductionThreshold(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BackgroundSubtractorMOG2> * self1 = 0;
    if (!pyopencv_BackgroundSubtractorMOG2_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    Ptr<cv::BackgroundSubtractorMOG2> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getComplexityReductionThreshold());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_getDetectShadows(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BackgroundSubtractorMOG2> * self1 = 0;
    if (!pyopencv_BackgroundSubtractorMOG2_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    Ptr<cv::BackgroundSubtractorMOG2> _self_ = *(self1);
    bool retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getDetectShadows());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_getHistory(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BackgroundSubtractorMOG2> * self1 = 0;
    if (!pyopencv_BackgroundSubtractorMOG2_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    Ptr<cv::BackgroundSubtractorMOG2> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getHistory());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_getNMixtures(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BackgroundSubtractorMOG2> * self1 = 0;
    if (!pyopencv_BackgroundSubtractorMOG2_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    Ptr<cv::BackgroundSubtractorMOG2> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getNMixtures());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_getShadowThreshold(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BackgroundSubtractorMOG2> * self1 = 0;
    if (!pyopencv_BackgroundSubtractorMOG2_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    Ptr<cv::BackgroundSubtractorMOG2> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getShadowThreshold());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_getShadowValue(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BackgroundSubtractorMOG2> * self1 = 0;
    if (!pyopencv_BackgroundSubtractorMOG2_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    Ptr<cv::BackgroundSubtractorMOG2> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getShadowValue());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_getVarInit(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BackgroundSubtractorMOG2> * self1 = 0;
    if (!pyopencv_BackgroundSubtractorMOG2_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    Ptr<cv::BackgroundSubtractorMOG2> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getVarInit());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_getVarMax(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BackgroundSubtractorMOG2> * self1 = 0;
    if (!pyopencv_BackgroundSubtractorMOG2_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    Ptr<cv::BackgroundSubtractorMOG2> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getVarMax());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_getVarMin(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BackgroundSubtractorMOG2> * self1 = 0;
    if (!pyopencv_BackgroundSubtractorMOG2_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    Ptr<cv::BackgroundSubtractorMOG2> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getVarMin());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_getVarThreshold(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BackgroundSubtractorMOG2> * self1 = 0;
    if (!pyopencv_BackgroundSubtractorMOG2_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    Ptr<cv::BackgroundSubtractorMOG2> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getVarThreshold());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_getVarThresholdGen(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BackgroundSubtractorMOG2> * self1 = 0;
    if (!pyopencv_BackgroundSubtractorMOG2_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    Ptr<cv::BackgroundSubtractorMOG2> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getVarThresholdGen());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_setBackgroundRatio(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BackgroundSubtractorMOG2> * self1 = 0;
    if (!pyopencv_BackgroundSubtractorMOG2_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    Ptr<cv::BackgroundSubtractorMOG2> _self_ = *(self1);
    PyObject* pyobj_ratio = NULL;
    double ratio=0;

    const char* keywords[] = { "ratio", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:BackgroundSubtractorMOG2.setBackgroundRatio", (char**)keywords, &pyobj_ratio) &&
        pyopencv_to_safe(pyobj_ratio, ratio, ArgInfo("ratio", 0)) )
    {
        ERRWRAP2(_self_->setBackgroundRatio(ratio));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_setComplexityReductionThreshold(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BackgroundSubtractorMOG2> * self1 = 0;
    if (!pyopencv_BackgroundSubtractorMOG2_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    Ptr<cv::BackgroundSubtractorMOG2> _self_ = *(self1);
    PyObject* pyobj_ct = NULL;
    double ct=0;

    const char* keywords[] = { "ct", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:BackgroundSubtractorMOG2.setComplexityReductionThreshold", (char**)keywords, &pyobj_ct) &&
        pyopencv_to_safe(pyobj_ct, ct, ArgInfo("ct", 0)) )
    {
        ERRWRAP2(_self_->setComplexityReductionThreshold(ct));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_setDetectShadows(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BackgroundSubtractorMOG2> * self1 = 0;
    if (!pyopencv_BackgroundSubtractorMOG2_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    Ptr<cv::BackgroundSubtractorMOG2> _self_ = *(self1);
    PyObject* pyobj_detectShadows = NULL;
    bool detectShadows=0;

    const char* keywords[] = { "detectShadows", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:BackgroundSubtractorMOG2.setDetectShadows", (char**)keywords, &pyobj_detectShadows) &&
        pyopencv_to_safe(pyobj_detectShadows, detectShadows, ArgInfo("detectShadows", 0)) )
    {
        ERRWRAP2(_self_->setDetectShadows(detectShadows));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_setHistory(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BackgroundSubtractorMOG2> * self1 = 0;
    if (!pyopencv_BackgroundSubtractorMOG2_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    Ptr<cv::BackgroundSubtractorMOG2> _self_ = *(self1);
    PyObject* pyobj_history = NULL;
    int history=0;

    const char* keywords[] = { "history", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:BackgroundSubtractorMOG2.setHistory", (char**)keywords, &pyobj_history) &&
        pyopencv_to_safe(pyobj_history, history, ArgInfo("history", 0)) )
    {
        ERRWRAP2(_self_->setHistory(history));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_setNMixtures(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BackgroundSubtractorMOG2> * self1 = 0;
    if (!pyopencv_BackgroundSubtractorMOG2_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    Ptr<cv::BackgroundSubtractorMOG2> _self_ = *(self1);
    PyObject* pyobj_nmixtures = NULL;
    int nmixtures=0;

    const char* keywords[] = { "nmixtures", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:BackgroundSubtractorMOG2.setNMixtures", (char**)keywords, &pyobj_nmixtures) &&
        pyopencv_to_safe(pyobj_nmixtures, nmixtures, ArgInfo("nmixtures", 0)) )
    {
        ERRWRAP2(_self_->setNMixtures(nmixtures));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_setShadowThreshold(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BackgroundSubtractorMOG2> * self1 = 0;
    if (!pyopencv_BackgroundSubtractorMOG2_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    Ptr<cv::BackgroundSubtractorMOG2> _self_ = *(self1);
    PyObject* pyobj_threshold = NULL;
    double threshold=0;

    const char* keywords[] = { "threshold", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:BackgroundSubtractorMOG2.setShadowThreshold", (char**)keywords, &pyobj_threshold) &&
        pyopencv_to_safe(pyobj_threshold, threshold, ArgInfo("threshold", 0)) )
    {
        ERRWRAP2(_self_->setShadowThreshold(threshold));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_setShadowValue(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BackgroundSubtractorMOG2> * self1 = 0;
    if (!pyopencv_BackgroundSubtractorMOG2_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    Ptr<cv::BackgroundSubtractorMOG2> _self_ = *(self1);
    PyObject* pyobj_value = NULL;
    int value=0;

    const char* keywords[] = { "value", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:BackgroundSubtractorMOG2.setShadowValue", (char**)keywords, &pyobj_value) &&
        pyopencv_to_safe(pyobj_value, value, ArgInfo("value", 0)) )
    {
        ERRWRAP2(_self_->setShadowValue(value));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_setVarInit(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BackgroundSubtractorMOG2> * self1 = 0;
    if (!pyopencv_BackgroundSubtractorMOG2_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    Ptr<cv::BackgroundSubtractorMOG2> _self_ = *(self1);
    PyObject* pyobj_varInit = NULL;
    double varInit=0;

    const char* keywords[] = { "varInit", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:BackgroundSubtractorMOG2.setVarInit", (char**)keywords, &pyobj_varInit) &&
        pyopencv_to_safe(pyobj_varInit, varInit, ArgInfo("varInit", 0)) )
    {
        ERRWRAP2(_self_->setVarInit(varInit));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_setVarMax(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BackgroundSubtractorMOG2> * self1 = 0;
    if (!pyopencv_BackgroundSubtractorMOG2_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    Ptr<cv::BackgroundSubtractorMOG2> _self_ = *(self1);
    PyObject* pyobj_varMax = NULL;
    double varMax=0;

    const char* keywords[] = { "varMax", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:BackgroundSubtractorMOG2.setVarMax", (char**)keywords, &pyobj_varMax) &&
        pyopencv_to_safe(pyobj_varMax, varMax, ArgInfo("varMax", 0)) )
    {
        ERRWRAP2(_self_->setVarMax(varMax));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_setVarMin(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BackgroundSubtractorMOG2> * self1 = 0;
    if (!pyopencv_BackgroundSubtractorMOG2_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    Ptr<cv::BackgroundSubtractorMOG2> _self_ = *(self1);
    PyObject* pyobj_varMin = NULL;
    double varMin=0;

    const char* keywords[] = { "varMin", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:BackgroundSubtractorMOG2.setVarMin", (char**)keywords, &pyobj_varMin) &&
        pyopencv_to_safe(pyobj_varMin, varMin, ArgInfo("varMin", 0)) )
    {
        ERRWRAP2(_self_->setVarMin(varMin));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_setVarThreshold(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BackgroundSubtractorMOG2> * self1 = 0;
    if (!pyopencv_BackgroundSubtractorMOG2_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    Ptr<cv::BackgroundSubtractorMOG2> _self_ = *(self1);
    PyObject* pyobj_varThreshold = NULL;
    double varThreshold=0;

    const char* keywords[] = { "varThreshold", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:BackgroundSubtractorMOG2.setVarThreshold", (char**)keywords, &pyobj_varThreshold) &&
        pyopencv_to_safe(pyobj_varThreshold, varThreshold, ArgInfo("varThreshold", 0)) )
    {
        ERRWRAP2(_self_->setVarThreshold(varThreshold));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_BackgroundSubtractorMOG2_setVarThresholdGen(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::BackgroundSubtractorMOG2> * self1 = 0;
    if (!pyopencv_BackgroundSubtractorMOG2_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'BackgroundSubtractorMOG2' or its derivative)");
    Ptr<cv::BackgroundSubtractorMOG2> _self_ = *(self1);
    PyObject* pyobj_varThresholdGen = NULL;
    double varThresholdGen=0;

    const char* keywords[] = { "varThresholdGen", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:BackgroundSubtractorMOG2.setVarThresholdGen", (char**)keywords, &pyobj_varThresholdGen) &&
        pyopencv_to_safe(pyobj_varThresholdGen, varThresholdGen, ArgInfo("varThresholdGen", 0)) )
    {
        ERRWRAP2(_self_->setVarThresholdGen(varThresholdGen));
        Py_RETURN_NONE;
    }

    return NULL;
}



// Tables (BackgroundSubtractorMOG2)

static PyGetSetDef pyopencv_BackgroundSubtractorMOG2_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_BackgroundSubtractorMOG2_methods[] =
{
    {"apply", CV_PY_FN_WITH_KW_(pyopencv_cv_BackgroundSubtractorMOG2_apply, 0), "apply(image[, fgmask[, learningRate]]) -> fgmask\n.   @brief Computes a foreground mask.\n.   \n.       @param image Next video frame. Floating point frame will be used without scaling and should be in range \\f$[0,255]\\f$.\n.       @param fgmask The output foreground mask as an 8-bit binary image.\n.       @param learningRate The value between 0 and 1 that indicates how fast the background model is\n.       learnt. Negative parameter value makes the algorithm to use some automatically chosen learning\n.       rate. 0 means that the background model is not updated at all, 1 means that the background model\n.       is completely reinitialized from the last frame."},
    {"getBackgroundRatio", CV_PY_FN_WITH_KW_(pyopencv_cv_BackgroundSubtractorMOG2_getBackgroundRatio, 0), "getBackgroundRatio() -> retval\n.   @brief Returns the \"background ratio\" parameter of the algorithm\n.   \n.       If a foreground pixel keeps semi-constant value for about backgroundRatio\\*history frames, it's\n.       considered background and added to the model as a center of a new component. It corresponds to TB\n.       parameter in the paper."},
    {"getComplexityReductionThreshold", CV_PY_FN_WITH_KW_(pyopencv_cv_BackgroundSubtractorMOG2_getComplexityReductionThreshold, 0), "getComplexityReductionThreshold() -> retval\n.   @brief Returns the complexity reduction threshold\n.   \n.       This parameter defines the number of samples needed to accept to prove the component exists. CT=0.05\n.       is a default value for all the samples. By setting CT=0 you get an algorithm very similar to the\n.       standard Stauffer&Grimson algorithm."},
    {"getDetectShadows", CV_PY_FN_WITH_KW_(pyopencv_cv_BackgroundSubtractorMOG2_getDetectShadows, 0), "getDetectShadows() -> retval\n.   @brief Returns the shadow detection flag\n.   \n.       If true, the algorithm detects shadows and marks them. See createBackgroundSubtractorMOG2 for\n.       details."},
    {"getHistory", CV_PY_FN_WITH_KW_(pyopencv_cv_BackgroundSubtractorMOG2_getHistory, 0), "getHistory() -> retval\n.   @brief Returns the number of last frames that affect the background model"},
    {"getNMixtures", CV_PY_FN_WITH_KW_(pyopencv_cv_BackgroundSubtractorMOG2_getNMixtures, 0), "getNMixtures() -> retval\n.   @brief Returns the number of gaussian components in the background model"},
    {"getShadowThreshold", CV_PY_FN_WITH_KW_(pyopencv_cv_BackgroundSubtractorMOG2_getShadowThreshold, 0), "getShadowThreshold() -> retval\n.   @brief Returns the shadow threshold\n.   \n.       A shadow is detected if pixel is a darker version of the background. The shadow threshold (Tau in\n.       the paper) is a threshold defining how much darker the shadow can be. Tau= 0.5 means that if a pixel\n.       is more than twice darker then it is not shadow. See Prati, Mikic, Trivedi and Cucchiara,\n.       *Detecting Moving Shadows...*, IEEE PAMI,2003."},
    {"getShadowValue", CV_PY_FN_WITH_KW_(pyopencv_cv_BackgroundSubtractorMOG2_getShadowValue, 0), "getShadowValue() -> retval\n.   @brief Returns the shadow value\n.   \n.       Shadow value is the value used to mark shadows in the foreground mask. Default value is 127. Value 0\n.       in the mask always means background, 255 means foreground."},
    {"getVarInit", CV_PY_FN_WITH_KW_(pyopencv_cv_BackgroundSubtractorMOG2_getVarInit, 0), "getVarInit() -> retval\n.   @brief Returns the initial variance of each gaussian component"},
    {"getVarMax", CV_PY_FN_WITH_KW_(pyopencv_cv_BackgroundSubtractorMOG2_getVarMax, 0), "getVarMax() -> retval\n."},
    {"getVarMin", CV_PY_FN_WITH_KW_(pyopencv_cv_BackgroundSubtractorMOG2_getVarMin, 0), "getVarMin() -> retval\n."},
    {"getVarThreshold", CV_PY_FN_WITH_KW_(pyopencv_cv_BackgroundSubtractorMOG2_getVarThreshold, 0), "getVarThreshold() -> retval\n.   @brief Returns the variance threshold for the pixel-model match\n.   \n.       The main threshold on the squared Mahalanobis distance to decide if the sample is well described by\n.       the background model or not. Related to Cthr from the paper."},
    {"getVarThresholdGen", CV_PY_FN_WITH_KW_(pyopencv_cv_BackgroundSubtractorMOG2_getVarThresholdGen, 0), "getVarThresholdGen() -> retval\n.   @brief Returns the variance threshold for the pixel-model match used for new mixture component generation\n.   \n.       Threshold for the squared Mahalanobis distance that helps decide when a sample is close to the\n.       existing components (corresponds to Tg in the paper). If a pixel is not close to any component, it\n.       is considered foreground or added as a new component. 3 sigma =\\> Tg=3\\*3=9 is default. A smaller Tg\n.       value generates more components. A higher Tg value may result in a small number of components but\n.       they can grow too large."},
    {"setBackgroundRatio", CV_PY_FN_WITH_KW_(pyopencv_cv_BackgroundSubtractorMOG2_setBackgroundRatio, 0), "setBackgroundRatio(ratio) -> None\n.   @brief Sets the \"background ratio\" parameter of the algorithm"},
    {"setComplexityReductionThreshold", CV_PY_FN_WITH_KW_(pyopencv_cv_BackgroundSubtractorMOG2_setComplexityReductionThreshold, 0), "setComplexityReductionThreshold(ct) -> None\n.   @brief Sets the complexity reduction threshold"},
    {"setDetectShadows", CV_PY_FN_WITH_KW_(pyopencv_cv_BackgroundSubtractorMOG2_setDetectShadows, 0), "setDetectShadows(detectShadows) -> None\n.   @brief Enables or disables shadow detection"},
    {"setHistory", CV_PY_FN_WITH_KW_(pyopencv_cv_BackgroundSubtractorMOG2_setHistory, 0), "setHistory(history) -> None\n.   @brief Sets the number of last frames that affect the background model"},
    {"setNMixtures", CV_PY_FN_WITH_KW_(pyopencv_cv_BackgroundSubtractorMOG2_setNMixtures, 0), "setNMixtures(nmixtures) -> None\n.   @brief Sets the number of gaussian components in the background model.\n.   \n.       The model needs to be reinitalized to reserve memory."},
    {"setShadowThreshold", CV_PY_FN_WITH_KW_(pyopencv_cv_BackgroundSubtractorMOG2_setShadowThreshold, 0), "setShadowThreshold(threshold) -> None\n.   @brief Sets the shadow threshold"},
    {"setShadowValue", CV_PY_FN_WITH_KW_(pyopencv_cv_BackgroundSubtractorMOG2_setShadowValue, 0), "setShadowValue(value) -> None\n.   @brief Sets the shadow value"},
    {"setVarInit", CV_PY_FN_WITH_KW_(pyopencv_cv_BackgroundSubtractorMOG2_setVarInit, 0), "setVarInit(varInit) -> None\n.   @brief Sets the initial variance of each gaussian component"},
    {"setVarMax", CV_PY_FN_WITH_KW_(pyopencv_cv_BackgroundSubtractorMOG2_setVarMax, 0), "setVarMax(varMax) -> None\n."},
    {"setVarMin", CV_PY_FN_WITH_KW_(pyopencv_cv_BackgroundSubtractorMOG2_setVarMin, 0), "setVarMin(varMin) -> None\n."},
    {"setVarThreshold", CV_PY_FN_WITH_KW_(pyopencv_cv_BackgroundSubtractorMOG2_setVarThreshold, 0), "setVarThreshold(varThreshold) -> None\n.   @brief Sets the variance threshold for the pixel-model match"},
    {"setVarThresholdGen", CV_PY_FN_WITH_KW_(pyopencv_cv_BackgroundSubtractorMOG2_setVarThresholdGen, 0), "setVarThresholdGen(varThresholdGen) -> None\n.   @brief Sets the variance threshold for the pixel-model match used for new mixture component generation"},

    {NULL,          NULL}
};

// Converter (BackgroundSubtractorMOG2)

template<>
struct PyOpenCV_Converter< Ptr<cv::BackgroundSubtractorMOG2> >
{
    static PyObject* from(const Ptr<cv::BackgroundSubtractorMOG2>& r)
    {
        return pyopencv_BackgroundSubtractorMOG2_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::BackgroundSubtractorMOG2>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::BackgroundSubtractorMOG2> * dst_;
        if (pyopencv_BackgroundSubtractorMOG2_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::BackgroundSubtractorMOG2> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// BaseCascadeClassifier (Generic)
//================================================================================

// GetSet (BaseCascadeClassifier)



// Methods (BaseCascadeClassifier)



// Tables (BaseCascadeClassifier)

static PyGetSetDef pyopencv_BaseCascadeClassifier_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_BaseCascadeClassifier_methods[] =
{

    {NULL,          NULL}
};

// Converter (BaseCascadeClassifier)

template<>
struct PyOpenCV_Converter< Ptr<cv::BaseCascadeClassifier> >
{
    static PyObject* from(const Ptr<cv::BaseCascadeClassifier>& r)
    {
        return pyopencv_BaseCascadeClassifier_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::BaseCascadeClassifier>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::BaseCascadeClassifier> * dst_;
        if (pyopencv_BaseCascadeClassifier_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::BaseCascadeClassifier> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// CLAHE (Generic)
//================================================================================

// GetSet (CLAHE)



// Methods (CLAHE)

static PyObject* pyopencv_cv_CLAHE_apply(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::CLAHE> * self1 = 0;
    if (!pyopencv_CLAHE_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'CLAHE' or its derivative)");
    Ptr<cv::CLAHE> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_src = NULL;
    Mat src;
    PyObject* pyobj_dst = NULL;
    Mat dst;

    const char* keywords[] = { "src", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|O:CLAHE.apply", (char**)keywords, &pyobj_src, &pyobj_dst) &&
        pyopencv_to_safe(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to_safe(pyobj_dst, dst, ArgInfo("dst", 1)) )
    {
        ERRWRAP2(_self_->apply(src, dst));
        return pyopencv_from(dst);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_src = NULL;
    UMat src;
    PyObject* pyobj_dst = NULL;
    UMat dst;

    const char* keywords[] = { "src", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|O:CLAHE.apply", (char**)keywords, &pyobj_src, &pyobj_dst) &&
        pyopencv_to_safe(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to_safe(pyobj_dst, dst, ArgInfo("dst", 1)) )
    {
        ERRWRAP2(_self_->apply(src, dst));
        return pyopencv_from(dst);
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("apply");

    return NULL;
}

static PyObject* pyopencv_cv_CLAHE_collectGarbage(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::CLAHE> * self1 = 0;
    if (!pyopencv_CLAHE_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'CLAHE' or its derivative)");
    Ptr<cv::CLAHE> _self_ = *(self1);

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(_self_->collectGarbage());
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_CLAHE_getClipLimit(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::CLAHE> * self1 = 0;
    if (!pyopencv_CLAHE_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'CLAHE' or its derivative)");
    Ptr<cv::CLAHE> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getClipLimit());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_CLAHE_getTilesGridSize(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::CLAHE> * self1 = 0;
    if (!pyopencv_CLAHE_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'CLAHE' or its derivative)");
    Ptr<cv::CLAHE> _self_ = *(self1);
    Size retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getTilesGridSize());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_CLAHE_setClipLimit(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::CLAHE> * self1 = 0;
    if (!pyopencv_CLAHE_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'CLAHE' or its derivative)");
    Ptr<cv::CLAHE> _self_ = *(self1);
    PyObject* pyobj_clipLimit = NULL;
    double clipLimit=0;

    const char* keywords[] = { "clipLimit", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:CLAHE.setClipLimit", (char**)keywords, &pyobj_clipLimit) &&
        pyopencv_to_safe(pyobj_clipLimit, clipLimit, ArgInfo("clipLimit", 0)) )
    {
        ERRWRAP2(_self_->setClipLimit(clipLimit));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_CLAHE_setTilesGridSize(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::CLAHE> * self1 = 0;
    if (!pyopencv_CLAHE_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'CLAHE' or its derivative)");
    Ptr<cv::CLAHE> _self_ = *(self1);
    PyObject* pyobj_tileGridSize = NULL;
    Size tileGridSize;

    const char* keywords[] = { "tileGridSize", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:CLAHE.setTilesGridSize", (char**)keywords, &pyobj_tileGridSize) &&
        pyopencv_to_safe(pyobj_tileGridSize, tileGridSize, ArgInfo("tileGridSize", 0)) )
    {
        ERRWRAP2(_self_->setTilesGridSize(tileGridSize));
        Py_RETURN_NONE;
    }

    return NULL;
}



// Tables (CLAHE)

static PyGetSetDef pyopencv_CLAHE_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_CLAHE_methods[] =
{
    {"apply", CV_PY_FN_WITH_KW_(pyopencv_cv_CLAHE_apply, 0), "apply(src[, dst]) -> dst\n.   @brief Equalizes the histogram of a grayscale image using Contrast Limited Adaptive Histogram Equalization.\n.   \n.       @param src Source image of type CV_8UC1 or CV_16UC1.\n.       @param dst Destination image."},
    {"collectGarbage", CV_PY_FN_WITH_KW_(pyopencv_cv_CLAHE_collectGarbage, 0), "collectGarbage() -> None\n."},
    {"getClipLimit", CV_PY_FN_WITH_KW_(pyopencv_cv_CLAHE_getClipLimit, 0), "getClipLimit() -> retval\n."},
    {"getTilesGridSize", CV_PY_FN_WITH_KW_(pyopencv_cv_CLAHE_getTilesGridSize, 0), "getTilesGridSize() -> retval\n."},
    {"setClipLimit", CV_PY_FN_WITH_KW_(pyopencv_cv_CLAHE_setClipLimit, 0), "setClipLimit(clipLimit) -> None\n.   @brief Sets threshold for contrast limiting.\n.   \n.       @param clipLimit threshold value."},
    {"setTilesGridSize", CV_PY_FN_WITH_KW_(pyopencv_cv_CLAHE_setTilesGridSize, 0), "setTilesGridSize(tileGridSize) -> None\n.   @brief Sets size of grid for histogram equalization. Input image will be divided into\n.       equally sized rectangular tiles.\n.   \n.       @param tileGridSize defines the number of tiles in row and column."},

    {NULL,          NULL}
};

// Converter (CLAHE)

template<>
struct PyOpenCV_Converter< Ptr<cv::CLAHE> >
{
    static PyObject* from(const Ptr<cv::CLAHE>& r)
    {
        return pyopencv_CLAHE_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::CLAHE>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::CLAHE> * dst_;
        if (pyopencv_CLAHE_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::CLAHE> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// CalibrateCRF (Generic)
//================================================================================

// GetSet (CalibrateCRF)



// Methods (CalibrateCRF)

static PyObject* pyopencv_cv_CalibrateCRF_process(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::CalibrateCRF> * self1 = 0;
    if (!pyopencv_CalibrateCRF_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'CalibrateCRF' or its derivative)");
    Ptr<cv::CalibrateCRF> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_src = NULL;
    vector_Mat src;
    PyObject* pyobj_dst = NULL;
    Mat dst;
    PyObject* pyobj_times = NULL;
    Mat times;

    const char* keywords[] = { "src", "times", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO|O:CalibrateCRF.process", (char**)keywords, &pyobj_src, &pyobj_times, &pyobj_dst) &&
        pyopencv_to_safe(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to_safe(pyobj_dst, dst, ArgInfo("dst", 1)) &&
        pyopencv_to_safe(pyobj_times, times, ArgInfo("times", 0)) )
    {
        ERRWRAP2(_self_->process(src, dst, times));
        return pyopencv_from(dst);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_src = NULL;
    vector_UMat src;
    PyObject* pyobj_dst = NULL;
    UMat dst;
    PyObject* pyobj_times = NULL;
    UMat times;

    const char* keywords[] = { "src", "times", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO|O:CalibrateCRF.process", (char**)keywords, &pyobj_src, &pyobj_times, &pyobj_dst) &&
        pyopencv_to_safe(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to_safe(pyobj_dst, dst, ArgInfo("dst", 1)) &&
        pyopencv_to_safe(pyobj_times, times, ArgInfo("times", 0)) )
    {
        ERRWRAP2(_self_->process(src, dst, times));
        return pyopencv_from(dst);
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("process");

    return NULL;
}



// Tables (CalibrateCRF)

static PyGetSetDef pyopencv_CalibrateCRF_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_CalibrateCRF_methods[] =
{
    {"process", CV_PY_FN_WITH_KW_(pyopencv_cv_CalibrateCRF_process, 0), "process(src, times[, dst]) -> dst\n.   @brief Recovers inverse camera response.\n.   \n.       @param src vector of input images\n.       @param dst 256x1 matrix with inverse camera response function\n.       @param times vector of exposure time values for each image"},

    {NULL,          NULL}
};

// Converter (CalibrateCRF)

template<>
struct PyOpenCV_Converter< Ptr<cv::CalibrateCRF> >
{
    static PyObject* from(const Ptr<cv::CalibrateCRF>& r)
    {
        return pyopencv_CalibrateCRF_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::CalibrateCRF>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::CalibrateCRF> * dst_;
        if (pyopencv_CalibrateCRF_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::CalibrateCRF> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// CalibrateDebevec (Generic)
//================================================================================

// GetSet (CalibrateDebevec)



// Methods (CalibrateDebevec)

static PyObject* pyopencv_cv_CalibrateDebevec_getLambda(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::CalibrateDebevec> * self1 = 0;
    if (!pyopencv_CalibrateDebevec_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'CalibrateDebevec' or its derivative)");
    Ptr<cv::CalibrateDebevec> _self_ = *(self1);
    float retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getLambda());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_CalibrateDebevec_getRandom(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::CalibrateDebevec> * self1 = 0;
    if (!pyopencv_CalibrateDebevec_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'CalibrateDebevec' or its derivative)");
    Ptr<cv::CalibrateDebevec> _self_ = *(self1);
    bool retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getRandom());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_CalibrateDebevec_getSamples(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::CalibrateDebevec> * self1 = 0;
    if (!pyopencv_CalibrateDebevec_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'CalibrateDebevec' or its derivative)");
    Ptr<cv::CalibrateDebevec> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getSamples());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_CalibrateDebevec_setLambda(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::CalibrateDebevec> * self1 = 0;
    if (!pyopencv_CalibrateDebevec_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'CalibrateDebevec' or its derivative)");
    Ptr<cv::CalibrateDebevec> _self_ = *(self1);
    PyObject* pyobj_lambda = NULL;
    float lambda=0.f;

    const char* keywords[] = { "lambda_", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:CalibrateDebevec.setLambda", (char**)keywords, &pyobj_lambda) &&
        pyopencv_to_safe(pyobj_lambda, lambda, ArgInfo("lambda", 0)) )
    {
        ERRWRAP2(_self_->setLambda(lambda));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_CalibrateDebevec_setRandom(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::CalibrateDebevec> * self1 = 0;
    if (!pyopencv_CalibrateDebevec_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'CalibrateDebevec' or its derivative)");
    Ptr<cv::CalibrateDebevec> _self_ = *(self1);
    PyObject* pyobj_random = NULL;
    bool random=0;

    const char* keywords[] = { "random", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:CalibrateDebevec.setRandom", (char**)keywords, &pyobj_random) &&
        pyopencv_to_safe(pyobj_random, random, ArgInfo("random", 0)) )
    {
        ERRWRAP2(_self_->setRandom(random));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_CalibrateDebevec_setSamples(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::CalibrateDebevec> * self1 = 0;
    if (!pyopencv_CalibrateDebevec_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'CalibrateDebevec' or its derivative)");
    Ptr<cv::CalibrateDebevec> _self_ = *(self1);
    PyObject* pyobj_samples = NULL;
    int samples=0;

    const char* keywords[] = { "samples", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:CalibrateDebevec.setSamples", (char**)keywords, &pyobj_samples) &&
        pyopencv_to_safe(pyobj_samples, samples, ArgInfo("samples", 0)) )
    {
        ERRWRAP2(_self_->setSamples(samples));
        Py_RETURN_NONE;
    }

    return NULL;
}



// Tables (CalibrateDebevec)

static PyGetSetDef pyopencv_CalibrateDebevec_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_CalibrateDebevec_methods[] =
{
    {"getLambda", CV_PY_FN_WITH_KW_(pyopencv_cv_CalibrateDebevec_getLambda, 0), "getLambda() -> retval\n."},
    {"getRandom", CV_PY_FN_WITH_KW_(pyopencv_cv_CalibrateDebevec_getRandom, 0), "getRandom() -> retval\n."},
    {"getSamples", CV_PY_FN_WITH_KW_(pyopencv_cv_CalibrateDebevec_getSamples, 0), "getSamples() -> retval\n."},
    {"setLambda", CV_PY_FN_WITH_KW_(pyopencv_cv_CalibrateDebevec_setLambda, 0), "setLambda(lambda_) -> None\n."},
    {"setRandom", CV_PY_FN_WITH_KW_(pyopencv_cv_CalibrateDebevec_setRandom, 0), "setRandom(random) -> None\n."},
    {"setSamples", CV_PY_FN_WITH_KW_(pyopencv_cv_CalibrateDebevec_setSamples, 0), "setSamples(samples) -> None\n."},

    {NULL,          NULL}
};

// Converter (CalibrateDebevec)

template<>
struct PyOpenCV_Converter< Ptr<cv::CalibrateDebevec> >
{
    static PyObject* from(const Ptr<cv::CalibrateDebevec>& r)
    {
        return pyopencv_CalibrateDebevec_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::CalibrateDebevec>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::CalibrateDebevec> * dst_;
        if (pyopencv_CalibrateDebevec_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::CalibrateDebevec> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// CalibrateRobertson (Generic)
//================================================================================

// GetSet (CalibrateRobertson)



// Methods (CalibrateRobertson)

static PyObject* pyopencv_cv_CalibrateRobertson_getMaxIter(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::CalibrateRobertson> * self1 = 0;
    if (!pyopencv_CalibrateRobertson_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'CalibrateRobertson' or its derivative)");
    Ptr<cv::CalibrateRobertson> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getMaxIter());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_CalibrateRobertson_getRadiance(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::CalibrateRobertson> * self1 = 0;
    if (!pyopencv_CalibrateRobertson_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'CalibrateRobertson' or its derivative)");
    Ptr<cv::CalibrateRobertson> _self_ = *(self1);
    Mat retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getRadiance());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_CalibrateRobertson_getThreshold(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::CalibrateRobertson> * self1 = 0;
    if (!pyopencv_CalibrateRobertson_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'CalibrateRobertson' or its derivative)");
    Ptr<cv::CalibrateRobertson> _self_ = *(self1);
    float retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getThreshold());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_CalibrateRobertson_setMaxIter(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::CalibrateRobertson> * self1 = 0;
    if (!pyopencv_CalibrateRobertson_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'CalibrateRobertson' or its derivative)");
    Ptr<cv::CalibrateRobertson> _self_ = *(self1);
    PyObject* pyobj_max_iter = NULL;
    int max_iter=0;

    const char* keywords[] = { "max_iter", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:CalibrateRobertson.setMaxIter", (char**)keywords, &pyobj_max_iter) &&
        pyopencv_to_safe(pyobj_max_iter, max_iter, ArgInfo("max_iter", 0)) )
    {
        ERRWRAP2(_self_->setMaxIter(max_iter));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_CalibrateRobertson_setThreshold(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::CalibrateRobertson> * self1 = 0;
    if (!pyopencv_CalibrateRobertson_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'CalibrateRobertson' or its derivative)");
    Ptr<cv::CalibrateRobertson> _self_ = *(self1);
    PyObject* pyobj_threshold = NULL;
    float threshold=0.f;

    const char* keywords[] = { "threshold", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:CalibrateRobertson.setThreshold", (char**)keywords, &pyobj_threshold) &&
        pyopencv_to_safe(pyobj_threshold, threshold, ArgInfo("threshold", 0)) )
    {
        ERRWRAP2(_self_->setThreshold(threshold));
        Py_RETURN_NONE;
    }

    return NULL;
}



// Tables (CalibrateRobertson)

static PyGetSetDef pyopencv_CalibrateRobertson_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_CalibrateRobertson_methods[] =
{
    {"getMaxIter", CV_PY_FN_WITH_KW_(pyopencv_cv_CalibrateRobertson_getMaxIter, 0), "getMaxIter() -> retval\n."},
    {"getRadiance", CV_PY_FN_WITH_KW_(pyopencv_cv_CalibrateRobertson_getRadiance, 0), "getRadiance() -> retval\n."},
    {"getThreshold", CV_PY_FN_WITH_KW_(pyopencv_cv_CalibrateRobertson_getThreshold, 0), "getThreshold() -> retval\n."},
    {"setMaxIter", CV_PY_FN_WITH_KW_(pyopencv_cv_CalibrateRobertson_setMaxIter, 0), "setMaxIter(max_iter) -> None\n."},
    {"setThreshold", CV_PY_FN_WITH_KW_(pyopencv_cv_CalibrateRobertson_setThreshold, 0), "setThreshold(threshold) -> None\n."},

    {NULL,          NULL}
};

// Converter (CalibrateRobertson)

template<>
struct PyOpenCV_Converter< Ptr<cv::CalibrateRobertson> >
{
    static PyObject* from(const Ptr<cv::CalibrateRobertson>& r)
    {
        return pyopencv_CalibrateRobertson_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::CalibrateRobertson>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::CalibrateRobertson> * dst_;
        if (pyopencv_CalibrateRobertson_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::CalibrateRobertson> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// CascadeClassifier (Generic)
//================================================================================

// GetSet (CascadeClassifier)



// Methods (CascadeClassifier)

static int pyopencv_cv_CascadeClassifier_CascadeClassifier(pyopencv_CascadeClassifier_t* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    pyPrepareArgumentConversionErrorsStorage(2);

    {

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        new (&(self->v)) Ptr<cv::CascadeClassifier>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::CascadeClassifier()));
        return 0;
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_filename = NULL;
    String filename;

    const char* keywords[] = { "filename", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:CascadeClassifier", (char**)keywords, &pyobj_filename) &&
        pyopencv_to_safe(pyobj_filename, filename, ArgInfo("filename", 0)) )
    {
        new (&(self->v)) Ptr<cv::CascadeClassifier>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::CascadeClassifier(filename)));
        return 0;
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("CascadeClassifier");

    return -1;
}

static PyObject* pyopencv_cv_CascadeClassifier_convert_static(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    PyObject* pyobj_oldcascade = NULL;
    String oldcascade;
    PyObject* pyobj_newcascade = NULL;
    String newcascade;
    bool retval;

    const char* keywords[] = { "oldcascade", "newcascade", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO:CascadeClassifier.convert", (char**)keywords, &pyobj_oldcascade, &pyobj_newcascade) &&
        pyopencv_to_safe(pyobj_oldcascade, oldcascade, ArgInfo("oldcascade", 0)) &&
        pyopencv_to_safe(pyobj_newcascade, newcascade, ArgInfo("newcascade", 0)) )
    {
        ERRWRAP2(retval = cv::CascadeClassifier::convert(oldcascade, newcascade));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_CascadeClassifier_detectMultiScale(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::CascadeClassifier> * self1 = 0;
    if (!pyopencv_CascadeClassifier_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'CascadeClassifier' or its derivative)");
    Ptr<cv::CascadeClassifier> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_image = NULL;
    Mat image;
    vector_Rect objects;
    PyObject* pyobj_scaleFactor = NULL;
    double scaleFactor=1.1;
    PyObject* pyobj_minNeighbors = NULL;
    int minNeighbors=3;
    PyObject* pyobj_flags = NULL;
    int flags=0;
    PyObject* pyobj_minSize = NULL;
    Size minSize;
    PyObject* pyobj_maxSize = NULL;
    Size maxSize;

    const char* keywords[] = { "image", "scaleFactor", "minNeighbors", "flags", "minSize", "maxSize", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|OOOOO:CascadeClassifier.detectMultiScale", (char**)keywords, &pyobj_image, &pyobj_scaleFactor, &pyobj_minNeighbors, &pyobj_flags, &pyobj_minSize, &pyobj_maxSize) &&
        pyopencv_to_safe(pyobj_image, image, ArgInfo("image", 0)) &&
        pyopencv_to_safe(pyobj_scaleFactor, scaleFactor, ArgInfo("scaleFactor", 0)) &&
        pyopencv_to_safe(pyobj_minNeighbors, minNeighbors, ArgInfo("minNeighbors", 0)) &&
        pyopencv_to_safe(pyobj_flags, flags, ArgInfo("flags", 0)) &&
        pyopencv_to_safe(pyobj_minSize, minSize, ArgInfo("minSize", 0)) &&
        pyopencv_to_safe(pyobj_maxSize, maxSize, ArgInfo("maxSize", 0)) )
    {
        ERRWRAP2(_self_->detectMultiScale(image, objects, scaleFactor, minNeighbors, flags, minSize, maxSize));
        return pyopencv_from(objects);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_image = NULL;
    UMat image;
    vector_Rect objects;
    PyObject* pyobj_scaleFactor = NULL;
    double scaleFactor=1.1;
    PyObject* pyobj_minNeighbors = NULL;
    int minNeighbors=3;
    PyObject* pyobj_flags = NULL;
    int flags=0;
    PyObject* pyobj_minSize = NULL;
    Size minSize;
    PyObject* pyobj_maxSize = NULL;
    Size maxSize;

    const char* keywords[] = { "image", "scaleFactor", "minNeighbors", "flags", "minSize", "maxSize", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|OOOOO:CascadeClassifier.detectMultiScale", (char**)keywords, &pyobj_image, &pyobj_scaleFactor, &pyobj_minNeighbors, &pyobj_flags, &pyobj_minSize, &pyobj_maxSize) &&
        pyopencv_to_safe(pyobj_image, image, ArgInfo("image", 0)) &&
        pyopencv_to_safe(pyobj_scaleFactor, scaleFactor, ArgInfo("scaleFactor", 0)) &&
        pyopencv_to_safe(pyobj_minNeighbors, minNeighbors, ArgInfo("minNeighbors", 0)) &&
        pyopencv_to_safe(pyobj_flags, flags, ArgInfo("flags", 0)) &&
        pyopencv_to_safe(pyobj_minSize, minSize, ArgInfo("minSize", 0)) &&
        pyopencv_to_safe(pyobj_maxSize, maxSize, ArgInfo("maxSize", 0)) )
    {
        ERRWRAP2(_self_->detectMultiScale(image, objects, scaleFactor, minNeighbors, flags, minSize, maxSize));
        return pyopencv_from(objects);
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("detectMultiScale");

    return NULL;
}

static PyObject* pyopencv_cv_CascadeClassifier_detectMultiScale2(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::CascadeClassifier> * self1 = 0;
    if (!pyopencv_CascadeClassifier_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'CascadeClassifier' or its derivative)");
    Ptr<cv::CascadeClassifier> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_image = NULL;
    Mat image;
    vector_Rect objects;
    vector_int numDetections;
    PyObject* pyobj_scaleFactor = NULL;
    double scaleFactor=1.1;
    PyObject* pyobj_minNeighbors = NULL;
    int minNeighbors=3;
    PyObject* pyobj_flags = NULL;
    int flags=0;
    PyObject* pyobj_minSize = NULL;
    Size minSize;
    PyObject* pyobj_maxSize = NULL;
    Size maxSize;

    const char* keywords[] = { "image", "scaleFactor", "minNeighbors", "flags", "minSize", "maxSize", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|OOOOO:CascadeClassifier.detectMultiScale2", (char**)keywords, &pyobj_image, &pyobj_scaleFactor, &pyobj_minNeighbors, &pyobj_flags, &pyobj_minSize, &pyobj_maxSize) &&
        pyopencv_to_safe(pyobj_image, image, ArgInfo("image", 0)) &&
        pyopencv_to_safe(pyobj_scaleFactor, scaleFactor, ArgInfo("scaleFactor", 0)) &&
        pyopencv_to_safe(pyobj_minNeighbors, minNeighbors, ArgInfo("minNeighbors", 0)) &&
        pyopencv_to_safe(pyobj_flags, flags, ArgInfo("flags", 0)) &&
        pyopencv_to_safe(pyobj_minSize, minSize, ArgInfo("minSize", 0)) &&
        pyopencv_to_safe(pyobj_maxSize, maxSize, ArgInfo("maxSize", 0)) )
    {
        ERRWRAP2(_self_->detectMultiScale(image, objects, numDetections, scaleFactor, minNeighbors, flags, minSize, maxSize));
        return Py_BuildValue("(NN)", pyopencv_from(objects), pyopencv_from(numDetections));
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_image = NULL;
    UMat image;
    vector_Rect objects;
    vector_int numDetections;
    PyObject* pyobj_scaleFactor = NULL;
    double scaleFactor=1.1;
    PyObject* pyobj_minNeighbors = NULL;
    int minNeighbors=3;
    PyObject* pyobj_flags = NULL;
    int flags=0;
    PyObject* pyobj_minSize = NULL;
    Size minSize;
    PyObject* pyobj_maxSize = NULL;
    Size maxSize;

    const char* keywords[] = { "image", "scaleFactor", "minNeighbors", "flags", "minSize", "maxSize", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|OOOOO:CascadeClassifier.detectMultiScale2", (char**)keywords, &pyobj_image, &pyobj_scaleFactor, &pyobj_minNeighbors, &pyobj_flags, &pyobj_minSize, &pyobj_maxSize) &&
        pyopencv_to_safe(pyobj_image, image, ArgInfo("image", 0)) &&
        pyopencv_to_safe(pyobj_scaleFactor, scaleFactor, ArgInfo("scaleFactor", 0)) &&
        pyopencv_to_safe(pyobj_minNeighbors, minNeighbors, ArgInfo("minNeighbors", 0)) &&
        pyopencv_to_safe(pyobj_flags, flags, ArgInfo("flags", 0)) &&
        pyopencv_to_safe(pyobj_minSize, minSize, ArgInfo("minSize", 0)) &&
        pyopencv_to_safe(pyobj_maxSize, maxSize, ArgInfo("maxSize", 0)) )
    {
        ERRWRAP2(_self_->detectMultiScale(image, objects, numDetections, scaleFactor, minNeighbors, flags, minSize, maxSize));
        return Py_BuildValue("(NN)", pyopencv_from(objects), pyopencv_from(numDetections));
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("detectMultiScale2");

    return NULL;
}

static PyObject* pyopencv_cv_CascadeClassifier_detectMultiScale3(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::CascadeClassifier> * self1 = 0;
    if (!pyopencv_CascadeClassifier_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'CascadeClassifier' or its derivative)");
    Ptr<cv::CascadeClassifier> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_image = NULL;
    Mat image;
    vector_Rect objects;
    vector_int rejectLevels;
    vector_double levelWeights;
    PyObject* pyobj_scaleFactor = NULL;
    double scaleFactor=1.1;
    PyObject* pyobj_minNeighbors = NULL;
    int minNeighbors=3;
    PyObject* pyobj_flags = NULL;
    int flags=0;
    PyObject* pyobj_minSize = NULL;
    Size minSize;
    PyObject* pyobj_maxSize = NULL;
    Size maxSize;
    PyObject* pyobj_outputRejectLevels = NULL;
    bool outputRejectLevels=false;

    const char* keywords[] = { "image", "scaleFactor", "minNeighbors", "flags", "minSize", "maxSize", "outputRejectLevels", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|OOOOOO:CascadeClassifier.detectMultiScale3", (char**)keywords, &pyobj_image, &pyobj_scaleFactor, &pyobj_minNeighbors, &pyobj_flags, &pyobj_minSize, &pyobj_maxSize, &pyobj_outputRejectLevels) &&
        pyopencv_to_safe(pyobj_image, image, ArgInfo("image", 0)) &&
        pyopencv_to_safe(pyobj_scaleFactor, scaleFactor, ArgInfo("scaleFactor", 0)) &&
        pyopencv_to_safe(pyobj_minNeighbors, minNeighbors, ArgInfo("minNeighbors", 0)) &&
        pyopencv_to_safe(pyobj_flags, flags, ArgInfo("flags", 0)) &&
        pyopencv_to_safe(pyobj_minSize, minSize, ArgInfo("minSize", 0)) &&
        pyopencv_to_safe(pyobj_maxSize, maxSize, ArgInfo("maxSize", 0)) &&
        pyopencv_to_safe(pyobj_outputRejectLevels, outputRejectLevels, ArgInfo("outputRejectLevels", 0)) )
    {
        ERRWRAP2(_self_->detectMultiScale(image, objects, rejectLevels, levelWeights, scaleFactor, minNeighbors, flags, minSize, maxSize, outputRejectLevels));
        return Py_BuildValue("(NNN)", pyopencv_from(objects), pyopencv_from(rejectLevels), pyopencv_from(levelWeights));
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_image = NULL;
    UMat image;
    vector_Rect objects;
    vector_int rejectLevels;
    vector_double levelWeights;
    PyObject* pyobj_scaleFactor = NULL;
    double scaleFactor=1.1;
    PyObject* pyobj_minNeighbors = NULL;
    int minNeighbors=3;
    PyObject* pyobj_flags = NULL;
    int flags=0;
    PyObject* pyobj_minSize = NULL;
    Size minSize;
    PyObject* pyobj_maxSize = NULL;
    Size maxSize;
    PyObject* pyobj_outputRejectLevels = NULL;
    bool outputRejectLevels=false;

    const char* keywords[] = { "image", "scaleFactor", "minNeighbors", "flags", "minSize", "maxSize", "outputRejectLevels", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|OOOOOO:CascadeClassifier.detectMultiScale3", (char**)keywords, &pyobj_image, &pyobj_scaleFactor, &pyobj_minNeighbors, &pyobj_flags, &pyobj_minSize, &pyobj_maxSize, &pyobj_outputRejectLevels) &&
        pyopencv_to_safe(pyobj_image, image, ArgInfo("image", 0)) &&
        pyopencv_to_safe(pyobj_scaleFactor, scaleFactor, ArgInfo("scaleFactor", 0)) &&
        pyopencv_to_safe(pyobj_minNeighbors, minNeighbors, ArgInfo("minNeighbors", 0)) &&
        pyopencv_to_safe(pyobj_flags, flags, ArgInfo("flags", 0)) &&
        pyopencv_to_safe(pyobj_minSize, minSize, ArgInfo("minSize", 0)) &&
        pyopencv_to_safe(pyobj_maxSize, maxSize, ArgInfo("maxSize", 0)) &&
        pyopencv_to_safe(pyobj_outputRejectLevels, outputRejectLevels, ArgInfo("outputRejectLevels", 0)) )
    {
        ERRWRAP2(_self_->detectMultiScale(image, objects, rejectLevels, levelWeights, scaleFactor, minNeighbors, flags, minSize, maxSize, outputRejectLevels));
        return Py_BuildValue("(NNN)", pyopencv_from(objects), pyopencv_from(rejectLevels), pyopencv_from(levelWeights));
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("detectMultiScale3");

    return NULL;
}

static PyObject* pyopencv_cv_CascadeClassifier_empty(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::CascadeClassifier> * self1 = 0;
    if (!pyopencv_CascadeClassifier_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'CascadeClassifier' or its derivative)");
    Ptr<cv::CascadeClassifier> _self_ = *(self1);
    bool retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->empty());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_CascadeClassifier_getFeatureType(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::CascadeClassifier> * self1 = 0;
    if (!pyopencv_CascadeClassifier_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'CascadeClassifier' or its derivative)");
    Ptr<cv::CascadeClassifier> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getFeatureType());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_CascadeClassifier_getOriginalWindowSize(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::CascadeClassifier> * self1 = 0;
    if (!pyopencv_CascadeClassifier_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'CascadeClassifier' or its derivative)");
    Ptr<cv::CascadeClassifier> _self_ = *(self1);
    Size retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getOriginalWindowSize());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_CascadeClassifier_isOldFormatCascade(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::CascadeClassifier> * self1 = 0;
    if (!pyopencv_CascadeClassifier_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'CascadeClassifier' or its derivative)");
    Ptr<cv::CascadeClassifier> _self_ = *(self1);
    bool retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->isOldFormatCascade());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_CascadeClassifier_load(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::CascadeClassifier> * self1 = 0;
    if (!pyopencv_CascadeClassifier_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'CascadeClassifier' or its derivative)");
    Ptr<cv::CascadeClassifier> _self_ = *(self1);
    PyObject* pyobj_filename = NULL;
    String filename;
    bool retval;

    const char* keywords[] = { "filename", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:CascadeClassifier.load", (char**)keywords, &pyobj_filename) &&
        pyopencv_to_safe(pyobj_filename, filename, ArgInfo("filename", 0)) )
    {
        ERRWRAP2(retval = _self_->load(filename));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_CascadeClassifier_read(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::CascadeClassifier> * self1 = 0;
    if (!pyopencv_CascadeClassifier_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'CascadeClassifier' or its derivative)");
    Ptr<cv::CascadeClassifier> _self_ = *(self1);
    PyObject* pyobj_node = NULL;
    cv::FileNode node;
    bool retval;

    const char* keywords[] = { "node", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:CascadeClassifier.read", (char**)keywords, &pyobj_node) &&
        pyopencv_to_safe(pyobj_node, node, ArgInfo("node", 0)) )
    {
        ERRWRAP2(retval = _self_->read(node));
        return pyopencv_from(retval);
    }

    return NULL;
}



// Tables (CascadeClassifier)

static PyGetSetDef pyopencv_CascadeClassifier_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_CascadeClassifier_methods[] =
{
    {"convert", CV_PY_FN_WITH_KW_(pyopencv_cv_CascadeClassifier_convert_static, METH_STATIC), "convert(oldcascade, newcascade) -> retval\n."},
    {"detectMultiScale", CV_PY_FN_WITH_KW_(pyopencv_cv_CascadeClassifier_detectMultiScale, 0), "detectMultiScale(image[, scaleFactor[, minNeighbors[, flags[, minSize[, maxSize]]]]]) -> objects\n.   @brief Detects objects of different sizes in the input image. The detected objects are returned as a list\n.       of rectangles.\n.   \n.       @param image Matrix of the type CV_8U containing an image where objects are detected.\n.       @param objects Vector of rectangles where each rectangle contains the detected object, the\n.       rectangles may be partially outside the original image.\n.       @param scaleFactor Parameter specifying how much the image size is reduced at each image scale.\n.       @param minNeighbors Parameter specifying how many neighbors each candidate rectangle should have\n.       to retain it.\n.       @param flags Parameter with the same meaning for an old cascade as in the function\n.       cvHaarDetectObjects. It is not used for a new cascade.\n.       @param minSize Minimum possible object size. Objects smaller than that are ignored.\n.       @param maxSize Maximum possible object size. Objects larger than that are ignored. If `maxSize == minSize` model is evaluated on single scale."},
    {"detectMultiScale2", CV_PY_FN_WITH_KW_(pyopencv_cv_CascadeClassifier_detectMultiScale2, 0), "detectMultiScale2(image[, scaleFactor[, minNeighbors[, flags[, minSize[, maxSize]]]]]) -> objects, numDetections\n.   @overload\n.       @param image Matrix of the type CV_8U containing an image where objects are detected.\n.       @param objects Vector of rectangles where each rectangle contains the detected object, the\n.       rectangles may be partially outside the original image.\n.       @param numDetections Vector of detection numbers for the corresponding objects. An object's number\n.       of detections is the number of neighboring positively classified rectangles that were joined\n.       together to form the object.\n.       @param scaleFactor Parameter specifying how much the image size is reduced at each image scale.\n.       @param minNeighbors Parameter specifying how many neighbors each candidate rectangle should have\n.       to retain it.\n.       @param flags Parameter with the same meaning for an old cascade as in the function\n.       cvHaarDetectObjects. It is not used for a new cascade.\n.       @param minSize Minimum possible object size. Objects smaller than that are ignored.\n.       @param maxSize Maximum possible object size. Objects larger than that are ignored. If `maxSize == minSize` model is evaluated on single scale."},
    {"detectMultiScale3", CV_PY_FN_WITH_KW_(pyopencv_cv_CascadeClassifier_detectMultiScale3, 0), "detectMultiScale3(image[, scaleFactor[, minNeighbors[, flags[, minSize[, maxSize[, outputRejectLevels]]]]]]) -> objects, rejectLevels, levelWeights\n.   @overload\n.       This function allows you to retrieve the final stage decision certainty of classification.\n.       For this, one needs to set `outputRejectLevels` on true and provide the `rejectLevels` and `levelWeights` parameter.\n.       For each resulting detection, `levelWeights` will then contain the certainty of classification at the final stage.\n.       This value can then be used to separate strong from weaker classifications.\n.   \n.       A code sample on how to use it efficiently can be found below:\n.       @code\n.       Mat img;\n.       vector<double> weights;\n.       vector<int> levels;\n.       vector<Rect> detections;\n.       CascadeClassifier model(\"/path/to/your/model.xml\");\n.       model.detectMultiScale(img, detections, levels, weights, 1.1, 3, 0, Size(), Size(), true);\n.       cerr << \"Detection \" << detections[0] << \" with weight \" << weights[0] << endl;\n.       @endcode"},
    {"empty", CV_PY_FN_WITH_KW_(pyopencv_cv_CascadeClassifier_empty, 0), "empty() -> retval\n.   @brief Checks whether the classifier has been loaded."},
    {"getFeatureType", CV_PY_FN_WITH_KW_(pyopencv_cv_CascadeClassifier_getFeatureType, 0), "getFeatureType() -> retval\n."},
    {"getOriginalWindowSize", CV_PY_FN_WITH_KW_(pyopencv_cv_CascadeClassifier_getOriginalWindowSize, 0), "getOriginalWindowSize() -> retval\n."},
    {"isOldFormatCascade", CV_PY_FN_WITH_KW_(pyopencv_cv_CascadeClassifier_isOldFormatCascade, 0), "isOldFormatCascade() -> retval\n."},
    {"load", CV_PY_FN_WITH_KW_(pyopencv_cv_CascadeClassifier_load, 0), "load(filename) -> retval\n.   @brief Loads a classifier from a file.\n.   \n.       @param filename Name of the file from which the classifier is loaded. The file may contain an old\n.       HAAR classifier trained by the haartraining application or a new cascade classifier trained by the\n.       traincascade application."},
    {"read", CV_PY_FN_WITH_KW_(pyopencv_cv_CascadeClassifier_read, 0), "read(node) -> retval\n.   @brief Reads a classifier from a FileStorage node.\n.   \n.       @note The file may contain a new cascade classifier (trained by the traincascade application) only."},

    {NULL,          NULL}
};

// Converter (CascadeClassifier)

template<>
struct PyOpenCV_Converter< Ptr<cv::CascadeClassifier> >
{
    static PyObject* from(const Ptr<cv::CascadeClassifier>& r)
    {
        return pyopencv_CascadeClassifier_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::CascadeClassifier>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::CascadeClassifier> * dst_;
        if (pyopencv_CascadeClassifier_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::CascadeClassifier> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// ChiHistogramCostExtractor (Generic)
//================================================================================

// GetSet (ChiHistogramCostExtractor)



// Methods (ChiHistogramCostExtractor)



// Tables (ChiHistogramCostExtractor)

static PyGetSetDef pyopencv_ChiHistogramCostExtractor_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_ChiHistogramCostExtractor_methods[] =
{

    {NULL,          NULL}
};

// Converter (ChiHistogramCostExtractor)

template<>
struct PyOpenCV_Converter< Ptr<cv::ChiHistogramCostExtractor> >
{
    static PyObject* from(const Ptr<cv::ChiHistogramCostExtractor>& r)
    {
        return pyopencv_ChiHistogramCostExtractor_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::ChiHistogramCostExtractor>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::ChiHistogramCostExtractor> * dst_;
        if (pyopencv_ChiHistogramCostExtractor_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::ChiHistogramCostExtractor> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// CirclesGridFinderParameters (Generic)
//================================================================================

// GetSet (CirclesGridFinderParameters)


static PyObject* pyopencv_CirclesGridFinderParameters_get_convexHullFactor(pyopencv_CirclesGridFinderParameters_t* p, void *closure)
{
    return pyopencv_from(p->v.convexHullFactor);
}

static int pyopencv_CirclesGridFinderParameters_set_convexHullFactor(pyopencv_CirclesGridFinderParameters_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the convexHullFactor attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.convexHullFactor, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_CirclesGridFinderParameters_get_densityNeighborhoodSize(pyopencv_CirclesGridFinderParameters_t* p, void *closure)
{
    return pyopencv_from(p->v.densityNeighborhoodSize);
}

static int pyopencv_CirclesGridFinderParameters_set_densityNeighborhoodSize(pyopencv_CirclesGridFinderParameters_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the densityNeighborhoodSize attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.densityNeighborhoodSize, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_CirclesGridFinderParameters_get_edgeGain(pyopencv_CirclesGridFinderParameters_t* p, void *closure)
{
    return pyopencv_from(p->v.edgeGain);
}

static int pyopencv_CirclesGridFinderParameters_set_edgeGain(pyopencv_CirclesGridFinderParameters_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the edgeGain attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.edgeGain, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_CirclesGridFinderParameters_get_edgePenalty(pyopencv_CirclesGridFinderParameters_t* p, void *closure)
{
    return pyopencv_from(p->v.edgePenalty);
}

static int pyopencv_CirclesGridFinderParameters_set_edgePenalty(pyopencv_CirclesGridFinderParameters_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the edgePenalty attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.edgePenalty, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_CirclesGridFinderParameters_get_existingVertexGain(pyopencv_CirclesGridFinderParameters_t* p, void *closure)
{
    return pyopencv_from(p->v.existingVertexGain);
}

static int pyopencv_CirclesGridFinderParameters_set_existingVertexGain(pyopencv_CirclesGridFinderParameters_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the existingVertexGain attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.existingVertexGain, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_CirclesGridFinderParameters_get_keypointScale(pyopencv_CirclesGridFinderParameters_t* p, void *closure)
{
    return pyopencv_from(p->v.keypointScale);
}

static int pyopencv_CirclesGridFinderParameters_set_keypointScale(pyopencv_CirclesGridFinderParameters_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the keypointScale attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.keypointScale, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_CirclesGridFinderParameters_get_kmeansAttempts(pyopencv_CirclesGridFinderParameters_t* p, void *closure)
{
    return pyopencv_from(p->v.kmeansAttempts);
}

static int pyopencv_CirclesGridFinderParameters_set_kmeansAttempts(pyopencv_CirclesGridFinderParameters_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the kmeansAttempts attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.kmeansAttempts, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_CirclesGridFinderParameters_get_maxRectifiedDistance(pyopencv_CirclesGridFinderParameters_t* p, void *closure)
{
    return pyopencv_from(p->v.maxRectifiedDistance);
}

static int pyopencv_CirclesGridFinderParameters_set_maxRectifiedDistance(pyopencv_CirclesGridFinderParameters_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the maxRectifiedDistance attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.maxRectifiedDistance, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_CirclesGridFinderParameters_get_minDensity(pyopencv_CirclesGridFinderParameters_t* p, void *closure)
{
    return pyopencv_from(p->v.minDensity);
}

static int pyopencv_CirclesGridFinderParameters_set_minDensity(pyopencv_CirclesGridFinderParameters_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the minDensity attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.minDensity, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_CirclesGridFinderParameters_get_minDistanceToAddKeypoint(pyopencv_CirclesGridFinderParameters_t* p, void *closure)
{
    return pyopencv_from(p->v.minDistanceToAddKeypoint);
}

static int pyopencv_CirclesGridFinderParameters_set_minDistanceToAddKeypoint(pyopencv_CirclesGridFinderParameters_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the minDistanceToAddKeypoint attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.minDistanceToAddKeypoint, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_CirclesGridFinderParameters_get_minGraphConfidence(pyopencv_CirclesGridFinderParameters_t* p, void *closure)
{
    return pyopencv_from(p->v.minGraphConfidence);
}

static int pyopencv_CirclesGridFinderParameters_set_minGraphConfidence(pyopencv_CirclesGridFinderParameters_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the minGraphConfidence attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.minGraphConfidence, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_CirclesGridFinderParameters_get_minRNGEdgeSwitchDist(pyopencv_CirclesGridFinderParameters_t* p, void *closure)
{
    return pyopencv_from(p->v.minRNGEdgeSwitchDist);
}

static int pyopencv_CirclesGridFinderParameters_set_minRNGEdgeSwitchDist(pyopencv_CirclesGridFinderParameters_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the minRNGEdgeSwitchDist attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.minRNGEdgeSwitchDist, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_CirclesGridFinderParameters_get_squareSize(pyopencv_CirclesGridFinderParameters_t* p, void *closure)
{
    return pyopencv_from(p->v.squareSize);
}

static int pyopencv_CirclesGridFinderParameters_set_squareSize(pyopencv_CirclesGridFinderParameters_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the squareSize attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.squareSize, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_CirclesGridFinderParameters_get_vertexGain(pyopencv_CirclesGridFinderParameters_t* p, void *closure)
{
    return pyopencv_from(p->v.vertexGain);
}

static int pyopencv_CirclesGridFinderParameters_set_vertexGain(pyopencv_CirclesGridFinderParameters_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the vertexGain attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.vertexGain, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_CirclesGridFinderParameters_get_vertexPenalty(pyopencv_CirclesGridFinderParameters_t* p, void *closure)
{
    return pyopencv_from(p->v.vertexPenalty);
}

static int pyopencv_CirclesGridFinderParameters_set_vertexPenalty(pyopencv_CirclesGridFinderParameters_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the vertexPenalty attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.vertexPenalty, ArgInfo("value", 0)) ? 0 : -1;
}


// Methods (CirclesGridFinderParameters)

static int pyopencv_cv_CirclesGridFinderParameters_CirclesGridFinderParameters(pyopencv_CirclesGridFinderParameters_t* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        if(self) ERRWRAP2(new (&(self->v)) cv::CirclesGridFinderParameters());
        return 0;
    }

    return -1;
}



// Tables (CirclesGridFinderParameters)

static PyGetSetDef pyopencv_CirclesGridFinderParameters_getseters[] =
{
    {(char*)"convexHullFactor", (getter)pyopencv_CirclesGridFinderParameters_get_convexHullFactor, (setter)pyopencv_CirclesGridFinderParameters_set_convexHullFactor, (char*)"convexHullFactor", NULL},
    {(char*)"densityNeighborhoodSize", (getter)pyopencv_CirclesGridFinderParameters_get_densityNeighborhoodSize, (setter)pyopencv_CirclesGridFinderParameters_set_densityNeighborhoodSize, (char*)"densityNeighborhoodSize", NULL},
    {(char*)"edgeGain", (getter)pyopencv_CirclesGridFinderParameters_get_edgeGain, (setter)pyopencv_CirclesGridFinderParameters_set_edgeGain, (char*)"edgeGain", NULL},
    {(char*)"edgePenalty", (getter)pyopencv_CirclesGridFinderParameters_get_edgePenalty, (setter)pyopencv_CirclesGridFinderParameters_set_edgePenalty, (char*)"edgePenalty", NULL},
    {(char*)"existingVertexGain", (getter)pyopencv_CirclesGridFinderParameters_get_existingVertexGain, (setter)pyopencv_CirclesGridFinderParameters_set_existingVertexGain, (char*)"existingVertexGain", NULL},
    {(char*)"keypointScale", (getter)pyopencv_CirclesGridFinderParameters_get_keypointScale, (setter)pyopencv_CirclesGridFinderParameters_set_keypointScale, (char*)"keypointScale", NULL},
    {(char*)"kmeansAttempts", (getter)pyopencv_CirclesGridFinderParameters_get_kmeansAttempts, (setter)pyopencv_CirclesGridFinderParameters_set_kmeansAttempts, (char*)"kmeansAttempts", NULL},
    {(char*)"maxRectifiedDistance", (getter)pyopencv_CirclesGridFinderParameters_get_maxRectifiedDistance, (setter)pyopencv_CirclesGridFinderParameters_set_maxRectifiedDistance, (char*)"maxRectifiedDistance", NULL},
    {(char*)"minDensity", (getter)pyopencv_CirclesGridFinderParameters_get_minDensity, (setter)pyopencv_CirclesGridFinderParameters_set_minDensity, (char*)"minDensity", NULL},
    {(char*)"minDistanceToAddKeypoint", (getter)pyopencv_CirclesGridFinderParameters_get_minDistanceToAddKeypoint, (setter)pyopencv_CirclesGridFinderParameters_set_minDistanceToAddKeypoint, (char*)"minDistanceToAddKeypoint", NULL},
    {(char*)"minGraphConfidence", (getter)pyopencv_CirclesGridFinderParameters_get_minGraphConfidence, (setter)pyopencv_CirclesGridFinderParameters_set_minGraphConfidence, (char*)"minGraphConfidence", NULL},
    {(char*)"minRNGEdgeSwitchDist", (getter)pyopencv_CirclesGridFinderParameters_get_minRNGEdgeSwitchDist, (setter)pyopencv_CirclesGridFinderParameters_set_minRNGEdgeSwitchDist, (char*)"minRNGEdgeSwitchDist", NULL},
    {(char*)"squareSize", (getter)pyopencv_CirclesGridFinderParameters_get_squareSize, (setter)pyopencv_CirclesGridFinderParameters_set_squareSize, (char*)"squareSize", NULL},
    {(char*)"vertexGain", (getter)pyopencv_CirclesGridFinderParameters_get_vertexGain, (setter)pyopencv_CirclesGridFinderParameters_set_vertexGain, (char*)"vertexGain", NULL},
    {(char*)"vertexPenalty", (getter)pyopencv_CirclesGridFinderParameters_get_vertexPenalty, (setter)pyopencv_CirclesGridFinderParameters_set_vertexPenalty, (char*)"vertexPenalty", NULL},
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_CirclesGridFinderParameters_methods[] =
{

    {NULL,          NULL}
};

// Converter (CirclesGridFinderParameters)

template<>
struct PyOpenCV_Converter< cv::CirclesGridFinderParameters >
{
    static PyObject* from(const cv::CirclesGridFinderParameters& r)
    {
        return pyopencv_CirclesGridFinderParameters_Instance(r);
    }
    static bool to(PyObject* src, cv::CirclesGridFinderParameters& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        cv::CirclesGridFinderParameters * dst_;
        if (pyopencv_CirclesGridFinderParameters_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected cv::CirclesGridFinderParameters for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// DISOpticalFlow (Generic)
//================================================================================

// GetSet (DISOpticalFlow)



// Methods (DISOpticalFlow)

static PyObject* pyopencv_cv_DISOpticalFlow_create_static(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    PyObject* pyobj_preset = NULL;
    int preset=DISOpticalFlow::PRESET_FAST;
    Ptr<DISOpticalFlow> retval;

    const char* keywords[] = { "preset", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "|O:DISOpticalFlow.create", (char**)keywords, &pyobj_preset) &&
        pyopencv_to_safe(pyobj_preset, preset, ArgInfo("preset", 0)) )
    {
        ERRWRAP2(retval = cv::DISOpticalFlow::create(preset));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_DISOpticalFlow_getFinestScale(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::DISOpticalFlow> * self1 = 0;
    if (!pyopencv_DISOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'DISOpticalFlow' or its derivative)");
    Ptr<cv::DISOpticalFlow> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getFinestScale());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_DISOpticalFlow_getGradientDescentIterations(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::DISOpticalFlow> * self1 = 0;
    if (!pyopencv_DISOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'DISOpticalFlow' or its derivative)");
    Ptr<cv::DISOpticalFlow> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getGradientDescentIterations());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_DISOpticalFlow_getPatchSize(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::DISOpticalFlow> * self1 = 0;
    if (!pyopencv_DISOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'DISOpticalFlow' or its derivative)");
    Ptr<cv::DISOpticalFlow> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getPatchSize());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_DISOpticalFlow_getPatchStride(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::DISOpticalFlow> * self1 = 0;
    if (!pyopencv_DISOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'DISOpticalFlow' or its derivative)");
    Ptr<cv::DISOpticalFlow> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getPatchStride());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_DISOpticalFlow_getUseMeanNormalization(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::DISOpticalFlow> * self1 = 0;
    if (!pyopencv_DISOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'DISOpticalFlow' or its derivative)");
    Ptr<cv::DISOpticalFlow> _self_ = *(self1);
    bool retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getUseMeanNormalization());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_DISOpticalFlow_getUseSpatialPropagation(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::DISOpticalFlow> * self1 = 0;
    if (!pyopencv_DISOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'DISOpticalFlow' or its derivative)");
    Ptr<cv::DISOpticalFlow> _self_ = *(self1);
    bool retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getUseSpatialPropagation());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_DISOpticalFlow_getVariationalRefinementAlpha(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::DISOpticalFlow> * self1 = 0;
    if (!pyopencv_DISOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'DISOpticalFlow' or its derivative)");
    Ptr<cv::DISOpticalFlow> _self_ = *(self1);
    float retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getVariationalRefinementAlpha());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_DISOpticalFlow_getVariationalRefinementDelta(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::DISOpticalFlow> * self1 = 0;
    if (!pyopencv_DISOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'DISOpticalFlow' or its derivative)");
    Ptr<cv::DISOpticalFlow> _self_ = *(self1);
    float retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getVariationalRefinementDelta());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_DISOpticalFlow_getVariationalRefinementGamma(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::DISOpticalFlow> * self1 = 0;
    if (!pyopencv_DISOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'DISOpticalFlow' or its derivative)");
    Ptr<cv::DISOpticalFlow> _self_ = *(self1);
    float retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getVariationalRefinementGamma());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_DISOpticalFlow_getVariationalRefinementIterations(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::DISOpticalFlow> * self1 = 0;
    if (!pyopencv_DISOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'DISOpticalFlow' or its derivative)");
    Ptr<cv::DISOpticalFlow> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getVariationalRefinementIterations());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_DISOpticalFlow_setFinestScale(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::DISOpticalFlow> * self1 = 0;
    if (!pyopencv_DISOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'DISOpticalFlow' or its derivative)");
    Ptr<cv::DISOpticalFlow> _self_ = *(self1);
    PyObject* pyobj_val = NULL;
    int val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:DISOpticalFlow.setFinestScale", (char**)keywords, &pyobj_val) &&
        pyopencv_to_safe(pyobj_val, val, ArgInfo("val", 0)) )
    {
        ERRWRAP2(_self_->setFinestScale(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_DISOpticalFlow_setGradientDescentIterations(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::DISOpticalFlow> * self1 = 0;
    if (!pyopencv_DISOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'DISOpticalFlow' or its derivative)");
    Ptr<cv::DISOpticalFlow> _self_ = *(self1);
    PyObject* pyobj_val = NULL;
    int val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:DISOpticalFlow.setGradientDescentIterations", (char**)keywords, &pyobj_val) &&
        pyopencv_to_safe(pyobj_val, val, ArgInfo("val", 0)) )
    {
        ERRWRAP2(_self_->setGradientDescentIterations(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_DISOpticalFlow_setPatchSize(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::DISOpticalFlow> * self1 = 0;
    if (!pyopencv_DISOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'DISOpticalFlow' or its derivative)");
    Ptr<cv::DISOpticalFlow> _self_ = *(self1);
    PyObject* pyobj_val = NULL;
    int val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:DISOpticalFlow.setPatchSize", (char**)keywords, &pyobj_val) &&
        pyopencv_to_safe(pyobj_val, val, ArgInfo("val", 0)) )
    {
        ERRWRAP2(_self_->setPatchSize(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_DISOpticalFlow_setPatchStride(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::DISOpticalFlow> * self1 = 0;
    if (!pyopencv_DISOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'DISOpticalFlow' or its derivative)");
    Ptr<cv::DISOpticalFlow> _self_ = *(self1);
    PyObject* pyobj_val = NULL;
    int val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:DISOpticalFlow.setPatchStride", (char**)keywords, &pyobj_val) &&
        pyopencv_to_safe(pyobj_val, val, ArgInfo("val", 0)) )
    {
        ERRWRAP2(_self_->setPatchStride(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_DISOpticalFlow_setUseMeanNormalization(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::DISOpticalFlow> * self1 = 0;
    if (!pyopencv_DISOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'DISOpticalFlow' or its derivative)");
    Ptr<cv::DISOpticalFlow> _self_ = *(self1);
    PyObject* pyobj_val = NULL;
    bool val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:DISOpticalFlow.setUseMeanNormalization", (char**)keywords, &pyobj_val) &&
        pyopencv_to_safe(pyobj_val, val, ArgInfo("val", 0)) )
    {
        ERRWRAP2(_self_->setUseMeanNormalization(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_DISOpticalFlow_setUseSpatialPropagation(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::DISOpticalFlow> * self1 = 0;
    if (!pyopencv_DISOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'DISOpticalFlow' or its derivative)");
    Ptr<cv::DISOpticalFlow> _self_ = *(self1);
    PyObject* pyobj_val = NULL;
    bool val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:DISOpticalFlow.setUseSpatialPropagation", (char**)keywords, &pyobj_val) &&
        pyopencv_to_safe(pyobj_val, val, ArgInfo("val", 0)) )
    {
        ERRWRAP2(_self_->setUseSpatialPropagation(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_DISOpticalFlow_setVariationalRefinementAlpha(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::DISOpticalFlow> * self1 = 0;
    if (!pyopencv_DISOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'DISOpticalFlow' or its derivative)");
    Ptr<cv::DISOpticalFlow> _self_ = *(self1);
    PyObject* pyobj_val = NULL;
    float val=0.f;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:DISOpticalFlow.setVariationalRefinementAlpha", (char**)keywords, &pyobj_val) &&
        pyopencv_to_safe(pyobj_val, val, ArgInfo("val", 0)) )
    {
        ERRWRAP2(_self_->setVariationalRefinementAlpha(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_DISOpticalFlow_setVariationalRefinementDelta(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::DISOpticalFlow> * self1 = 0;
    if (!pyopencv_DISOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'DISOpticalFlow' or its derivative)");
    Ptr<cv::DISOpticalFlow> _self_ = *(self1);
    PyObject* pyobj_val = NULL;
    float val=0.f;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:DISOpticalFlow.setVariationalRefinementDelta", (char**)keywords, &pyobj_val) &&
        pyopencv_to_safe(pyobj_val, val, ArgInfo("val", 0)) )
    {
        ERRWRAP2(_self_->setVariationalRefinementDelta(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_DISOpticalFlow_setVariationalRefinementGamma(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::DISOpticalFlow> * self1 = 0;
    if (!pyopencv_DISOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'DISOpticalFlow' or its derivative)");
    Ptr<cv::DISOpticalFlow> _self_ = *(self1);
    PyObject* pyobj_val = NULL;
    float val=0.f;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:DISOpticalFlow.setVariationalRefinementGamma", (char**)keywords, &pyobj_val) &&
        pyopencv_to_safe(pyobj_val, val, ArgInfo("val", 0)) )
    {
        ERRWRAP2(_self_->setVariationalRefinementGamma(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_DISOpticalFlow_setVariationalRefinementIterations(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::DISOpticalFlow> * self1 = 0;
    if (!pyopencv_DISOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'DISOpticalFlow' or its derivative)");
    Ptr<cv::DISOpticalFlow> _self_ = *(self1);
    PyObject* pyobj_val = NULL;
    int val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:DISOpticalFlow.setVariationalRefinementIterations", (char**)keywords, &pyobj_val) &&
        pyopencv_to_safe(pyobj_val, val, ArgInfo("val", 0)) )
    {
        ERRWRAP2(_self_->setVariationalRefinementIterations(val));
        Py_RETURN_NONE;
    }

    return NULL;
}



// Tables (DISOpticalFlow)

static PyGetSetDef pyopencv_DISOpticalFlow_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_DISOpticalFlow_methods[] =
{
    {"create", CV_PY_FN_WITH_KW_(pyopencv_cv_DISOpticalFlow_create_static, METH_STATIC), "create([, preset]) -> retval\n.   @brief Creates an instance of DISOpticalFlow\n.   \n.       @param preset one of PRESET_ULTRAFAST, PRESET_FAST and PRESET_MEDIUM"},
    {"getFinestScale", CV_PY_FN_WITH_KW_(pyopencv_cv_DISOpticalFlow_getFinestScale, 0), "getFinestScale() -> retval\n.   @brief Finest level of the Gaussian pyramid on which the flow is computed (zero level\n.           corresponds to the original image resolution). The final flow is obtained by bilinear upscaling.\n.   @see setFinestScale"},
    {"getGradientDescentIterations", CV_PY_FN_WITH_KW_(pyopencv_cv_DISOpticalFlow_getGradientDescentIterations, 0), "getGradientDescentIterations() -> retval\n.   @brief Maximum number of gradient descent iterations in the patch inverse search stage. Higher values\n.           may improve quality in some cases.\n.   @see setGradientDescentIterations"},
    {"getPatchSize", CV_PY_FN_WITH_KW_(pyopencv_cv_DISOpticalFlow_getPatchSize, 0), "getPatchSize() -> retval\n.   @brief Size of an image patch for matching (in pixels). Normally, default 8x8 patches work well\n.           enough in most cases.\n.   @see setPatchSize"},
    {"getPatchStride", CV_PY_FN_WITH_KW_(pyopencv_cv_DISOpticalFlow_getPatchStride, 0), "getPatchStride() -> retval\n.   @brief Stride between neighbor patches. Must be less than patch size. Lower values correspond\n.           to higher flow quality.\n.   @see setPatchStride"},
    {"getUseMeanNormalization", CV_PY_FN_WITH_KW_(pyopencv_cv_DISOpticalFlow_getUseMeanNormalization, 0), "getUseMeanNormalization() -> retval\n.   @brief Whether to use mean-normalization of patches when computing patch distance. It is turned on\n.           by default as it typically provides a noticeable quality boost because of increased robustness to\n.           illumination variations. Turn it off if you are certain that your sequence doesn't contain any changes\n.           in illumination.\n.   @see setUseMeanNormalization"},
    {"getUseSpatialPropagation", CV_PY_FN_WITH_KW_(pyopencv_cv_DISOpticalFlow_getUseSpatialPropagation, 0), "getUseSpatialPropagation() -> retval\n.   @brief Whether to use spatial propagation of good optical flow vectors. This option is turned on by\n.           default, as it tends to work better on average and can sometimes help recover from major errors\n.           introduced by the coarse-to-fine scheme employed by the DIS optical flow algorithm. Turning this\n.           option off can make the output flow field a bit smoother, however.\n.   @see setUseSpatialPropagation"},
    {"getVariationalRefinementAlpha", CV_PY_FN_WITH_KW_(pyopencv_cv_DISOpticalFlow_getVariationalRefinementAlpha, 0), "getVariationalRefinementAlpha() -> retval\n.   @brief Weight of the smoothness term\n.   @see setVariationalRefinementAlpha"},
    {"getVariationalRefinementDelta", CV_PY_FN_WITH_KW_(pyopencv_cv_DISOpticalFlow_getVariationalRefinementDelta, 0), "getVariationalRefinementDelta() -> retval\n.   @brief Weight of the color constancy term\n.   @see setVariationalRefinementDelta"},
    {"getVariationalRefinementGamma", CV_PY_FN_WITH_KW_(pyopencv_cv_DISOpticalFlow_getVariationalRefinementGamma, 0), "getVariationalRefinementGamma() -> retval\n.   @brief Weight of the gradient constancy term\n.   @see setVariationalRefinementGamma"},
    {"getVariationalRefinementIterations", CV_PY_FN_WITH_KW_(pyopencv_cv_DISOpticalFlow_getVariationalRefinementIterations, 0), "getVariationalRefinementIterations() -> retval\n.   @brief Number of fixed point iterations of variational refinement per scale. Set to zero to\n.           disable variational refinement completely. Higher values will typically result in more smooth and\n.           high-quality flow.\n.   @see setGradientDescentIterations"},
    {"setFinestScale", CV_PY_FN_WITH_KW_(pyopencv_cv_DISOpticalFlow_setFinestScale, 0), "setFinestScale(val) -> None\n.   @copybrief getFinestScale @see getFinestScale"},
    {"setGradientDescentIterations", CV_PY_FN_WITH_KW_(pyopencv_cv_DISOpticalFlow_setGradientDescentIterations, 0), "setGradientDescentIterations(val) -> None\n.   @copybrief getGradientDescentIterations @see getGradientDescentIterations"},
    {"setPatchSize", CV_PY_FN_WITH_KW_(pyopencv_cv_DISOpticalFlow_setPatchSize, 0), "setPatchSize(val) -> None\n.   @copybrief getPatchSize @see getPatchSize"},
    {"setPatchStride", CV_PY_FN_WITH_KW_(pyopencv_cv_DISOpticalFlow_setPatchStride, 0), "setPatchStride(val) -> None\n.   @copybrief getPatchStride @see getPatchStride"},
    {"setUseMeanNormalization", CV_PY_FN_WITH_KW_(pyopencv_cv_DISOpticalFlow_setUseMeanNormalization, 0), "setUseMeanNormalization(val) -> None\n.   @copybrief getUseMeanNormalization @see getUseMeanNormalization"},
    {"setUseSpatialPropagation", CV_PY_FN_WITH_KW_(pyopencv_cv_DISOpticalFlow_setUseSpatialPropagation, 0), "setUseSpatialPropagation(val) -> None\n.   @copybrief getUseSpatialPropagation @see getUseSpatialPropagation"},
    {"setVariationalRefinementAlpha", CV_PY_FN_WITH_KW_(pyopencv_cv_DISOpticalFlow_setVariationalRefinementAlpha, 0), "setVariationalRefinementAlpha(val) -> None\n.   @copybrief getVariationalRefinementAlpha @see getVariationalRefinementAlpha"},
    {"setVariationalRefinementDelta", CV_PY_FN_WITH_KW_(pyopencv_cv_DISOpticalFlow_setVariationalRefinementDelta, 0), "setVariationalRefinementDelta(val) -> None\n.   @copybrief getVariationalRefinementDelta @see getVariationalRefinementDelta"},
    {"setVariationalRefinementGamma", CV_PY_FN_WITH_KW_(pyopencv_cv_DISOpticalFlow_setVariationalRefinementGamma, 0), "setVariationalRefinementGamma(val) -> None\n.   @copybrief getVariationalRefinementGamma @see getVariationalRefinementGamma"},
    {"setVariationalRefinementIterations", CV_PY_FN_WITH_KW_(pyopencv_cv_DISOpticalFlow_setVariationalRefinementIterations, 0), "setVariationalRefinementIterations(val) -> None\n.   @copybrief getGradientDescentIterations @see getGradientDescentIterations"},

    {NULL,          NULL}
};

// Converter (DISOpticalFlow)

template<>
struct PyOpenCV_Converter< Ptr<cv::DISOpticalFlow> >
{
    static PyObject* from(const Ptr<cv::DISOpticalFlow>& r)
    {
        return pyopencv_DISOpticalFlow_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::DISOpticalFlow>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::DISOpticalFlow> * dst_;
        if (pyopencv_DISOpticalFlow_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::DISOpticalFlow> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// DMatch (Generic)
//================================================================================

// GetSet (DMatch)


static PyObject* pyopencv_DMatch_get_distance(pyopencv_DMatch_t* p, void *closure)
{
    return pyopencv_from(p->v.distance);
}

static int pyopencv_DMatch_set_distance(pyopencv_DMatch_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the distance attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.distance, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_DMatch_get_imgIdx(pyopencv_DMatch_t* p, void *closure)
{
    return pyopencv_from(p->v.imgIdx);
}

static int pyopencv_DMatch_set_imgIdx(pyopencv_DMatch_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the imgIdx attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.imgIdx, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_DMatch_get_queryIdx(pyopencv_DMatch_t* p, void *closure)
{
    return pyopencv_from(p->v.queryIdx);
}

static int pyopencv_DMatch_set_queryIdx(pyopencv_DMatch_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the queryIdx attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.queryIdx, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_DMatch_get_trainIdx(pyopencv_DMatch_t* p, void *closure)
{
    return pyopencv_from(p->v.trainIdx);
}

static int pyopencv_DMatch_set_trainIdx(pyopencv_DMatch_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the trainIdx attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.trainIdx, ArgInfo("value", 0)) ? 0 : -1;
}


// Methods (DMatch)

static int pyopencv_cv_DMatch_DMatch(pyopencv_DMatch_t* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    pyPrepareArgumentConversionErrorsStorage(3);

    {

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        if(self) ERRWRAP2(new (&(self->v)) cv::DMatch());
        return 0;
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj__queryIdx = NULL;
    int _queryIdx=0;
    PyObject* pyobj__trainIdx = NULL;
    int _trainIdx=0;
    PyObject* pyobj__distance = NULL;
    float _distance=0.f;

    const char* keywords[] = { "_queryIdx", "_trainIdx", "_distance", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOO:DMatch", (char**)keywords, &pyobj__queryIdx, &pyobj__trainIdx, &pyobj__distance) &&
        pyopencv_to_safe(pyobj__queryIdx, _queryIdx, ArgInfo("_queryIdx", 0)) &&
        pyopencv_to_safe(pyobj__trainIdx, _trainIdx, ArgInfo("_trainIdx", 0)) &&
        pyopencv_to_safe(pyobj__distance, _distance, ArgInfo("_distance", 0)) )
    {
        if(self) ERRWRAP2(new (&(self->v)) cv::DMatch(_queryIdx, _trainIdx, _distance));
        return 0;
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj__queryIdx = NULL;
    int _queryIdx=0;
    PyObject* pyobj__trainIdx = NULL;
    int _trainIdx=0;
    PyObject* pyobj__imgIdx = NULL;
    int _imgIdx=0;
    PyObject* pyobj__distance = NULL;
    float _distance=0.f;

    const char* keywords[] = { "_queryIdx", "_trainIdx", "_imgIdx", "_distance", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOOO:DMatch", (char**)keywords, &pyobj__queryIdx, &pyobj__trainIdx, &pyobj__imgIdx, &pyobj__distance) &&
        pyopencv_to_safe(pyobj__queryIdx, _queryIdx, ArgInfo("_queryIdx", 0)) &&
        pyopencv_to_safe(pyobj__trainIdx, _trainIdx, ArgInfo("_trainIdx", 0)) &&
        pyopencv_to_safe(pyobj__imgIdx, _imgIdx, ArgInfo("_imgIdx", 0)) &&
        pyopencv_to_safe(pyobj__distance, _distance, ArgInfo("_distance", 0)) )
    {
        if(self) ERRWRAP2(new (&(self->v)) cv::DMatch(_queryIdx, _trainIdx, _imgIdx, _distance));
        return 0;
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("DMatch");

    return -1;
}



// Tables (DMatch)

static PyGetSetDef pyopencv_DMatch_getseters[] =
{
    {(char*)"distance", (getter)pyopencv_DMatch_get_distance, (setter)pyopencv_DMatch_set_distance, (char*)"distance", NULL},
    {(char*)"imgIdx", (getter)pyopencv_DMatch_get_imgIdx, (setter)pyopencv_DMatch_set_imgIdx, (char*)"imgIdx", NULL},
    {(char*)"queryIdx", (getter)pyopencv_DMatch_get_queryIdx, (setter)pyopencv_DMatch_set_queryIdx, (char*)"queryIdx", NULL},
    {(char*)"trainIdx", (getter)pyopencv_DMatch_get_trainIdx, (setter)pyopencv_DMatch_set_trainIdx, (char*)"trainIdx", NULL},
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_DMatch_methods[] =
{

    {NULL,          NULL}
};

// Converter (DMatch)

template<>
struct PyOpenCV_Converter< cv::DMatch >
{
    static PyObject* from(const cv::DMatch& r)
    {
        return pyopencv_DMatch_Instance(r);
    }
    static bool to(PyObject* src, cv::DMatch& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        cv::DMatch * dst_;
        if (pyopencv_DMatch_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected cv::DMatch for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// DenseOpticalFlow (Generic)
//================================================================================

// GetSet (DenseOpticalFlow)



// Methods (DenseOpticalFlow)

static PyObject* pyopencv_cv_DenseOpticalFlow_calc(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::DenseOpticalFlow> * self1 = 0;
    if (!pyopencv_DenseOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'DenseOpticalFlow' or its derivative)");
    Ptr<cv::DenseOpticalFlow> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_I0 = NULL;
    Mat I0;
    PyObject* pyobj_I1 = NULL;
    Mat I1;
    PyObject* pyobj_flow = NULL;
    Mat flow;

    const char* keywords[] = { "I0", "I1", "flow", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOO:DenseOpticalFlow.calc", (char**)keywords, &pyobj_I0, &pyobj_I1, &pyobj_flow) &&
        pyopencv_to_safe(pyobj_I0, I0, ArgInfo("I0", 0)) &&
        pyopencv_to_safe(pyobj_I1, I1, ArgInfo("I1", 0)) &&
        pyopencv_to_safe(pyobj_flow, flow, ArgInfo("flow", 1)) )
    {
        ERRWRAP2(_self_->calc(I0, I1, flow));
        return pyopencv_from(flow);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_I0 = NULL;
    UMat I0;
    PyObject* pyobj_I1 = NULL;
    UMat I1;
    PyObject* pyobj_flow = NULL;
    UMat flow;

    const char* keywords[] = { "I0", "I1", "flow", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOO:DenseOpticalFlow.calc", (char**)keywords, &pyobj_I0, &pyobj_I1, &pyobj_flow) &&
        pyopencv_to_safe(pyobj_I0, I0, ArgInfo("I0", 0)) &&
        pyopencv_to_safe(pyobj_I1, I1, ArgInfo("I1", 0)) &&
        pyopencv_to_safe(pyobj_flow, flow, ArgInfo("flow", 1)) )
    {
        ERRWRAP2(_self_->calc(I0, I1, flow));
        return pyopencv_from(flow);
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("calc");

    return NULL;
}

static PyObject* pyopencv_cv_DenseOpticalFlow_collectGarbage(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::DenseOpticalFlow> * self1 = 0;
    if (!pyopencv_DenseOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'DenseOpticalFlow' or its derivative)");
    Ptr<cv::DenseOpticalFlow> _self_ = *(self1);

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(_self_->collectGarbage());
        Py_RETURN_NONE;
    }

    return NULL;
}



// Tables (DenseOpticalFlow)

static PyGetSetDef pyopencv_DenseOpticalFlow_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_DenseOpticalFlow_methods[] =
{
    {"calc", CV_PY_FN_WITH_KW_(pyopencv_cv_DenseOpticalFlow_calc, 0), "calc(I0, I1, flow) -> flow\n.   @brief Calculates an optical flow.\n.   \n.       @param I0 first 8-bit single-channel input image.\n.       @param I1 second input image of the same size and the same type as prev.\n.       @param flow computed flow image that has the same size as prev and type CV_32FC2."},
    {"collectGarbage", CV_PY_FN_WITH_KW_(pyopencv_cv_DenseOpticalFlow_collectGarbage, 0), "collectGarbage() -> None\n.   @brief Releases all inner buffers."},

    {NULL,          NULL}
};

// Converter (DenseOpticalFlow)

template<>
struct PyOpenCV_Converter< Ptr<cv::DenseOpticalFlow> >
{
    static PyObject* from(const Ptr<cv::DenseOpticalFlow>& r)
    {
        return pyopencv_DenseOpticalFlow_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::DenseOpticalFlow>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::DenseOpticalFlow> * dst_;
        if (pyopencv_DenseOpticalFlow_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::DenseOpticalFlow> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// DescriptorMatcher (Generic)
//================================================================================

// GetSet (DescriptorMatcher)



// Methods (DescriptorMatcher)

static PyObject* pyopencv_cv_DescriptorMatcher_add(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::DescriptorMatcher> * self1 = 0;
    if (!pyopencv_DescriptorMatcher_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'DescriptorMatcher' or its derivative)");
    Ptr<cv::DescriptorMatcher> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_descriptors = NULL;
    vector_Mat descriptors;

    const char* keywords[] = { "descriptors", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:DescriptorMatcher.add", (char**)keywords, &pyobj_descriptors) &&
        pyopencv_to_safe(pyobj_descriptors, descriptors, ArgInfo("descriptors", 0)) )
    {
        ERRWRAP2(_self_->add(descriptors));
        Py_RETURN_NONE;
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_descriptors = NULL;
    vector_UMat descriptors;

    const char* keywords[] = { "descriptors", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:DescriptorMatcher.add", (char**)keywords, &pyobj_descriptors) &&
        pyopencv_to_safe(pyobj_descriptors, descriptors, ArgInfo("descriptors", 0)) )
    {
        ERRWRAP2(_self_->add(descriptors));
        Py_RETURN_NONE;
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("add");

    return NULL;
}

static PyObject* pyopencv_cv_DescriptorMatcher_clear(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::DescriptorMatcher> * self1 = 0;
    if (!pyopencv_DescriptorMatcher_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'DescriptorMatcher' or its derivative)");
    Ptr<cv::DescriptorMatcher> _self_ = *(self1);

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(_self_->clear());
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_DescriptorMatcher_clone(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::DescriptorMatcher> * self1 = 0;
    if (!pyopencv_DescriptorMatcher_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'DescriptorMatcher' or its derivative)");
    Ptr<cv::DescriptorMatcher> _self_ = *(self1);
    PyObject* pyobj_emptyTrainData = NULL;
    bool emptyTrainData=false;
    Ptr<DescriptorMatcher> retval;

    const char* keywords[] = { "emptyTrainData", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "|O:DescriptorMatcher.clone", (char**)keywords, &pyobj_emptyTrainData) &&
        pyopencv_to_safe(pyobj_emptyTrainData, emptyTrainData, ArgInfo("emptyTrainData", 0)) )
    {
        ERRWRAP2(retval = _self_->clone(emptyTrainData));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_DescriptorMatcher_create_static(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_descriptorMatcherType = NULL;
    String descriptorMatcherType;
    Ptr<DescriptorMatcher> retval;

    const char* keywords[] = { "descriptorMatcherType", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:DescriptorMatcher.create", (char**)keywords, &pyobj_descriptorMatcherType) &&
        pyopencv_to_safe(pyobj_descriptorMatcherType, descriptorMatcherType, ArgInfo("descriptorMatcherType", 0)) )
    {
        ERRWRAP2(retval = cv::DescriptorMatcher::create(descriptorMatcherType));
        return pyopencv_from(retval);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_matcherType = NULL;
    DescriptorMatcher_MatcherType matcherType=static_cast<DescriptorMatcher_MatcherType>(0);
    Ptr<DescriptorMatcher> retval;

    const char* keywords[] = { "matcherType", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:DescriptorMatcher.create", (char**)keywords, &pyobj_matcherType) &&
        pyopencv_to_safe(pyobj_matcherType, matcherType, ArgInfo("matcherType", 0)) )
    {
        ERRWRAP2(retval = cv::DescriptorMatcher::create(matcherType));
        return pyopencv_from(retval);
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("create");

    return NULL;
}

static PyObject* pyopencv_cv_DescriptorMatcher_empty(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::DescriptorMatcher> * self1 = 0;
    if (!pyopencv_DescriptorMatcher_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'DescriptorMatcher' or its derivative)");
    Ptr<cv::DescriptorMatcher> _self_ = *(self1);
    bool retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->empty());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_DescriptorMatcher_getTrainDescriptors(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::DescriptorMatcher> * self1 = 0;
    if (!pyopencv_DescriptorMatcher_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'DescriptorMatcher' or its derivative)");
    Ptr<cv::DescriptorMatcher> _self_ = *(self1);
    std::vector<Mat> retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getTrainDescriptors());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_DescriptorMatcher_isMaskSupported(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::DescriptorMatcher> * self1 = 0;
    if (!pyopencv_DescriptorMatcher_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'DescriptorMatcher' or its derivative)");
    Ptr<cv::DescriptorMatcher> _self_ = *(self1);
    bool retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->isMaskSupported());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_DescriptorMatcher_knnMatch(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::DescriptorMatcher> * self1 = 0;
    if (!pyopencv_DescriptorMatcher_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'DescriptorMatcher' or its derivative)");
    Ptr<cv::DescriptorMatcher> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(4);

    {
    PyObject* pyobj_queryDescriptors = NULL;
    Mat queryDescriptors;
    PyObject* pyobj_trainDescriptors = NULL;
    Mat trainDescriptors;
    vector_vector_DMatch matches;
    PyObject* pyobj_k = NULL;
    int k=0;
    PyObject* pyobj_mask = NULL;
    Mat mask;
    PyObject* pyobj_compactResult = NULL;
    bool compactResult=false;

    const char* keywords[] = { "queryDescriptors", "trainDescriptors", "k", "mask", "compactResult", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOO|OO:DescriptorMatcher.knnMatch", (char**)keywords, &pyobj_queryDescriptors, &pyobj_trainDescriptors, &pyobj_k, &pyobj_mask, &pyobj_compactResult) &&
        pyopencv_to_safe(pyobj_queryDescriptors, queryDescriptors, ArgInfo("queryDescriptors", 0)) &&
        pyopencv_to_safe(pyobj_trainDescriptors, trainDescriptors, ArgInfo("trainDescriptors", 0)) &&
        pyopencv_to_safe(pyobj_k, k, ArgInfo("k", 0)) &&
        pyopencv_to_safe(pyobj_mask, mask, ArgInfo("mask", 0)) &&
        pyopencv_to_safe(pyobj_compactResult, compactResult, ArgInfo("compactResult", 0)) )
    {
        ERRWRAP2(_self_->knnMatch(queryDescriptors, trainDescriptors, matches, k, mask, compactResult));
        return pyopencv_from(matches);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_queryDescriptors = NULL;
    UMat queryDescriptors;
    PyObject* pyobj_trainDescriptors = NULL;
    UMat trainDescriptors;
    vector_vector_DMatch matches;
    PyObject* pyobj_k = NULL;
    int k=0;
    PyObject* pyobj_mask = NULL;
    UMat mask;
    PyObject* pyobj_compactResult = NULL;
    bool compactResult=false;

    const char* keywords[] = { "queryDescriptors", "trainDescriptors", "k", "mask", "compactResult", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOO|OO:DescriptorMatcher.knnMatch", (char**)keywords, &pyobj_queryDescriptors, &pyobj_trainDescriptors, &pyobj_k, &pyobj_mask, &pyobj_compactResult) &&
        pyopencv_to_safe(pyobj_queryDescriptors, queryDescriptors, ArgInfo("queryDescriptors", 0)) &&
        pyopencv_to_safe(pyobj_trainDescriptors, trainDescriptors, ArgInfo("trainDescriptors", 0)) &&
        pyopencv_to_safe(pyobj_k, k, ArgInfo("k", 0)) &&
        pyopencv_to_safe(pyobj_mask, mask, ArgInfo("mask", 0)) &&
        pyopencv_to_safe(pyobj_compactResult, compactResult, ArgInfo("compactResult", 0)) )
    {
        ERRWRAP2(_self_->knnMatch(queryDescriptors, trainDescriptors, matches, k, mask, compactResult));
        return pyopencv_from(matches);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_queryDescriptors = NULL;
    Mat queryDescriptors;
    vector_vector_DMatch matches;
    PyObject* pyobj_k = NULL;
    int k=0;
    PyObject* pyobj_masks = NULL;
    vector_Mat masks;
    PyObject* pyobj_compactResult = NULL;
    bool compactResult=false;

    const char* keywords[] = { "queryDescriptors", "k", "masks", "compactResult", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO|OO:DescriptorMatcher.knnMatch", (char**)keywords, &pyobj_queryDescriptors, &pyobj_k, &pyobj_masks, &pyobj_compactResult) &&
        pyopencv_to_safe(pyobj_queryDescriptors, queryDescriptors, ArgInfo("queryDescriptors", 0)) &&
        pyopencv_to_safe(pyobj_k, k, ArgInfo("k", 0)) &&
        pyopencv_to_safe(pyobj_masks, masks, ArgInfo("masks", 0)) &&
        pyopencv_to_safe(pyobj_compactResult, compactResult, ArgInfo("compactResult", 0)) )
    {
        ERRWRAP2(_self_->knnMatch(queryDescriptors, matches, k, masks, compactResult));
        return pyopencv_from(matches);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_queryDescriptors = NULL;
    UMat queryDescriptors;
    vector_vector_DMatch matches;
    PyObject* pyobj_k = NULL;
    int k=0;
    PyObject* pyobj_masks = NULL;
    vector_UMat masks;
    PyObject* pyobj_compactResult = NULL;
    bool compactResult=false;

    const char* keywords[] = { "queryDescriptors", "k", "masks", "compactResult", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO|OO:DescriptorMatcher.knnMatch", (char**)keywords, &pyobj_queryDescriptors, &pyobj_k, &pyobj_masks, &pyobj_compactResult) &&
        pyopencv_to_safe(pyobj_queryDescriptors, queryDescriptors, ArgInfo("queryDescriptors", 0)) &&
        pyopencv_to_safe(pyobj_k, k, ArgInfo("k", 0)) &&
        pyopencv_to_safe(pyobj_masks, masks, ArgInfo("masks", 0)) &&
        pyopencv_to_safe(pyobj_compactResult, compactResult, ArgInfo("compactResult", 0)) )
    {
        ERRWRAP2(_self_->knnMatch(queryDescriptors, matches, k, masks, compactResult));
        return pyopencv_from(matches);
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("knnMatch");

    return NULL;
}

static PyObject* pyopencv_cv_DescriptorMatcher_match(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::DescriptorMatcher> * self1 = 0;
    if (!pyopencv_DescriptorMatcher_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'DescriptorMatcher' or its derivative)");
    Ptr<cv::DescriptorMatcher> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(4);

    {
    PyObject* pyobj_queryDescriptors = NULL;
    Mat queryDescriptors;
    PyObject* pyobj_trainDescriptors = NULL;
    Mat trainDescriptors;
    vector_DMatch matches;
    PyObject* pyobj_mask = NULL;
    Mat mask;

    const char* keywords[] = { "queryDescriptors", "trainDescriptors", "mask", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO|O:DescriptorMatcher.match", (char**)keywords, &pyobj_queryDescriptors, &pyobj_trainDescriptors, &pyobj_mask) &&
        pyopencv_to_safe(pyobj_queryDescriptors, queryDescriptors, ArgInfo("queryDescriptors", 0)) &&
        pyopencv_to_safe(pyobj_trainDescriptors, trainDescriptors, ArgInfo("trainDescriptors", 0)) &&
        pyopencv_to_safe(pyobj_mask, mask, ArgInfo("mask", 0)) )
    {
        ERRWRAP2(_self_->match(queryDescriptors, trainDescriptors, matches, mask));
        return pyopencv_from(matches);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_queryDescriptors = NULL;
    UMat queryDescriptors;
    PyObject* pyobj_trainDescriptors = NULL;
    UMat trainDescriptors;
    vector_DMatch matches;
    PyObject* pyobj_mask = NULL;
    UMat mask;

    const char* keywords[] = { "queryDescriptors", "trainDescriptors", "mask", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO|O:DescriptorMatcher.match", (char**)keywords, &pyobj_queryDescriptors, &pyobj_trainDescriptors, &pyobj_mask) &&
        pyopencv_to_safe(pyobj_queryDescriptors, queryDescriptors, ArgInfo("queryDescriptors", 0)) &&
        pyopencv_to_safe(pyobj_trainDescriptors, trainDescriptors, ArgInfo("trainDescriptors", 0)) &&
        pyopencv_to_safe(pyobj_mask, mask, ArgInfo("mask", 0)) )
    {
        ERRWRAP2(_self_->match(queryDescriptors, trainDescriptors, matches, mask));
        return pyopencv_from(matches);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_queryDescriptors = NULL;
    Mat queryDescriptors;
    vector_DMatch matches;
    PyObject* pyobj_masks = NULL;
    vector_Mat masks;

    const char* keywords[] = { "queryDescriptors", "masks", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|O:DescriptorMatcher.match", (char**)keywords, &pyobj_queryDescriptors, &pyobj_masks) &&
        pyopencv_to_safe(pyobj_queryDescriptors, queryDescriptors, ArgInfo("queryDescriptors", 0)) &&
        pyopencv_to_safe(pyobj_masks, masks, ArgInfo("masks", 0)) )
    {
        ERRWRAP2(_self_->match(queryDescriptors, matches, masks));
        return pyopencv_from(matches);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_queryDescriptors = NULL;
    UMat queryDescriptors;
    vector_DMatch matches;
    PyObject* pyobj_masks = NULL;
    vector_UMat masks;

    const char* keywords[] = { "queryDescriptors", "masks", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|O:DescriptorMatcher.match", (char**)keywords, &pyobj_queryDescriptors, &pyobj_masks) &&
        pyopencv_to_safe(pyobj_queryDescriptors, queryDescriptors, ArgInfo("queryDescriptors", 0)) &&
        pyopencv_to_safe(pyobj_masks, masks, ArgInfo("masks", 0)) )
    {
        ERRWRAP2(_self_->match(queryDescriptors, matches, masks));
        return pyopencv_from(matches);
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("match");

    return NULL;
}

static PyObject* pyopencv_cv_DescriptorMatcher_radiusMatch(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::DescriptorMatcher> * self1 = 0;
    if (!pyopencv_DescriptorMatcher_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'DescriptorMatcher' or its derivative)");
    Ptr<cv::DescriptorMatcher> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(4);

    {
    PyObject* pyobj_queryDescriptors = NULL;
    Mat queryDescriptors;
    PyObject* pyobj_trainDescriptors = NULL;
    Mat trainDescriptors;
    vector_vector_DMatch matches;
    PyObject* pyobj_maxDistance = NULL;
    float maxDistance=0.f;
    PyObject* pyobj_mask = NULL;
    Mat mask;
    PyObject* pyobj_compactResult = NULL;
    bool compactResult=false;

    const char* keywords[] = { "queryDescriptors", "trainDescriptors", "maxDistance", "mask", "compactResult", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOO|OO:DescriptorMatcher.radiusMatch", (char**)keywords, &pyobj_queryDescriptors, &pyobj_trainDescriptors, &pyobj_maxDistance, &pyobj_mask, &pyobj_compactResult) &&
        pyopencv_to_safe(pyobj_queryDescriptors, queryDescriptors, ArgInfo("queryDescriptors", 0)) &&
        pyopencv_to_safe(pyobj_trainDescriptors, trainDescriptors, ArgInfo("trainDescriptors", 0)) &&
        pyopencv_to_safe(pyobj_maxDistance, maxDistance, ArgInfo("maxDistance", 0)) &&
        pyopencv_to_safe(pyobj_mask, mask, ArgInfo("mask", 0)) &&
        pyopencv_to_safe(pyobj_compactResult, compactResult, ArgInfo("compactResult", 0)) )
    {
        ERRWRAP2(_self_->radiusMatch(queryDescriptors, trainDescriptors, matches, maxDistance, mask, compactResult));
        return pyopencv_from(matches);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_queryDescriptors = NULL;
    UMat queryDescriptors;
    PyObject* pyobj_trainDescriptors = NULL;
    UMat trainDescriptors;
    vector_vector_DMatch matches;
    PyObject* pyobj_maxDistance = NULL;
    float maxDistance=0.f;
    PyObject* pyobj_mask = NULL;
    UMat mask;
    PyObject* pyobj_compactResult = NULL;
    bool compactResult=false;

    const char* keywords[] = { "queryDescriptors", "trainDescriptors", "maxDistance", "mask", "compactResult", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOO|OO:DescriptorMatcher.radiusMatch", (char**)keywords, &pyobj_queryDescriptors, &pyobj_trainDescriptors, &pyobj_maxDistance, &pyobj_mask, &pyobj_compactResult) &&
        pyopencv_to_safe(pyobj_queryDescriptors, queryDescriptors, ArgInfo("queryDescriptors", 0)) &&
        pyopencv_to_safe(pyobj_trainDescriptors, trainDescriptors, ArgInfo("trainDescriptors", 0)) &&
        pyopencv_to_safe(pyobj_maxDistance, maxDistance, ArgInfo("maxDistance", 0)) &&
        pyopencv_to_safe(pyobj_mask, mask, ArgInfo("mask", 0)) &&
        pyopencv_to_safe(pyobj_compactResult, compactResult, ArgInfo("compactResult", 0)) )
    {
        ERRWRAP2(_self_->radiusMatch(queryDescriptors, trainDescriptors, matches, maxDistance, mask, compactResult));
        return pyopencv_from(matches);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_queryDescriptors = NULL;
    Mat queryDescriptors;
    vector_vector_DMatch matches;
    PyObject* pyobj_maxDistance = NULL;
    float maxDistance=0.f;
    PyObject* pyobj_masks = NULL;
    vector_Mat masks;
    PyObject* pyobj_compactResult = NULL;
    bool compactResult=false;

    const char* keywords[] = { "queryDescriptors", "maxDistance", "masks", "compactResult", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO|OO:DescriptorMatcher.radiusMatch", (char**)keywords, &pyobj_queryDescriptors, &pyobj_maxDistance, &pyobj_masks, &pyobj_compactResult) &&
        pyopencv_to_safe(pyobj_queryDescriptors, queryDescriptors, ArgInfo("queryDescriptors", 0)) &&
        pyopencv_to_safe(pyobj_maxDistance, maxDistance, ArgInfo("maxDistance", 0)) &&
        pyopencv_to_safe(pyobj_masks, masks, ArgInfo("masks", 0)) &&
        pyopencv_to_safe(pyobj_compactResult, compactResult, ArgInfo("compactResult", 0)) )
    {
        ERRWRAP2(_self_->radiusMatch(queryDescriptors, matches, maxDistance, masks, compactResult));
        return pyopencv_from(matches);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_queryDescriptors = NULL;
    UMat queryDescriptors;
    vector_vector_DMatch matches;
    PyObject* pyobj_maxDistance = NULL;
    float maxDistance=0.f;
    PyObject* pyobj_masks = NULL;
    vector_UMat masks;
    PyObject* pyobj_compactResult = NULL;
    bool compactResult=false;

    const char* keywords[] = { "queryDescriptors", "maxDistance", "masks", "compactResult", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO|OO:DescriptorMatcher.radiusMatch", (char**)keywords, &pyobj_queryDescriptors, &pyobj_maxDistance, &pyobj_masks, &pyobj_compactResult) &&
        pyopencv_to_safe(pyobj_queryDescriptors, queryDescriptors, ArgInfo("queryDescriptors", 0)) &&
        pyopencv_to_safe(pyobj_maxDistance, maxDistance, ArgInfo("maxDistance", 0)) &&
        pyopencv_to_safe(pyobj_masks, masks, ArgInfo("masks", 0)) &&
        pyopencv_to_safe(pyobj_compactResult, compactResult, ArgInfo("compactResult", 0)) )
    {
        ERRWRAP2(_self_->radiusMatch(queryDescriptors, matches, maxDistance, masks, compactResult));
        return pyopencv_from(matches);
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("radiusMatch");

    return NULL;
}

static PyObject* pyopencv_cv_DescriptorMatcher_read(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::DescriptorMatcher> * self1 = 0;
    if (!pyopencv_DescriptorMatcher_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'DescriptorMatcher' or its derivative)");
    Ptr<cv::DescriptorMatcher> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_fileName = NULL;
    String fileName;

    const char* keywords[] = { "fileName", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:DescriptorMatcher.read", (char**)keywords, &pyobj_fileName) &&
        pyopencv_to_safe(pyobj_fileName, fileName, ArgInfo("fileName", 0)) )
    {
        ERRWRAP2(_self_->read(fileName));
        Py_RETURN_NONE;
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_arg1 = NULL;
    cv::FileNode arg1;

    const char* keywords[] = { "arg1", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:DescriptorMatcher.read", (char**)keywords, &pyobj_arg1) &&
        pyopencv_to_safe(pyobj_arg1, arg1, ArgInfo("arg1", 0)) )
    {
        ERRWRAP2(_self_->read(arg1));
        Py_RETURN_NONE;
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("read");

    return NULL;
}

static PyObject* pyopencv_cv_DescriptorMatcher_train(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::DescriptorMatcher> * self1 = 0;
    if (!pyopencv_DescriptorMatcher_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'DescriptorMatcher' or its derivative)");
    Ptr<cv::DescriptorMatcher> _self_ = *(self1);

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(_self_->train());
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_DescriptorMatcher_write(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::DescriptorMatcher> * self1 = 0;
    if (!pyopencv_DescriptorMatcher_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'DescriptorMatcher' or its derivative)");
    Ptr<cv::DescriptorMatcher> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_fileName = NULL;
    String fileName;

    const char* keywords[] = { "fileName", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:DescriptorMatcher.write", (char**)keywords, &pyobj_fileName) &&
        pyopencv_to_safe(pyobj_fileName, fileName, ArgInfo("fileName", 0)) )
    {
        ERRWRAP2(_self_->write(fileName));
        Py_RETURN_NONE;
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_fs = NULL;
    Ptr<cv::FileStorage> fs;
    PyObject* pyobj_name = NULL;
    String name;

    const char* keywords[] = { "fs", "name", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO:DescriptorMatcher.write", (char**)keywords, &pyobj_fs, &pyobj_name) &&
        pyopencv_to_safe(pyobj_fs, fs, ArgInfo("fs", 0)) &&
        pyopencv_to_safe(pyobj_name, name, ArgInfo("name", 0)) )
    {
        ERRWRAP2(_self_->write(*fs, name));
        Py_RETURN_NONE;
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("write");

    return NULL;
}



// Tables (DescriptorMatcher)

static PyGetSetDef pyopencv_DescriptorMatcher_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_DescriptorMatcher_methods[] =
{
    {"add", CV_PY_FN_WITH_KW_(pyopencv_cv_DescriptorMatcher_add, 0), "add(descriptors) -> None\n.   @brief Adds descriptors to train a CPU(trainDescCollectionis) or GPU(utrainDescCollectionis) descriptor\n.       collection.\n.   \n.       If the collection is not empty, the new descriptors are added to existing train descriptors.\n.   \n.       @param descriptors Descriptors to add. Each descriptors[i] is a set of descriptors from the same\n.       train image."},
    {"clear", CV_PY_FN_WITH_KW_(pyopencv_cv_DescriptorMatcher_clear, 0), "clear() -> None\n.   @brief Clears the train descriptor collections."},
    {"clone", CV_PY_FN_WITH_KW_(pyopencv_cv_DescriptorMatcher_clone, 0), "clone([, emptyTrainData]) -> retval\n.   @brief Clones the matcher.\n.   \n.       @param emptyTrainData If emptyTrainData is false, the method creates a deep copy of the object,\n.       that is, copies both parameters and train data. If emptyTrainData is true, the method creates an\n.       object copy with the current parameters but with empty train data."},
    {"create", CV_PY_FN_WITH_KW_(pyopencv_cv_DescriptorMatcher_create_static, METH_STATIC), "create(descriptorMatcherType) -> retval\n.   @brief Creates a descriptor matcher of a given type with the default parameters (using default\n.       constructor).\n.   \n.       @param descriptorMatcherType Descriptor matcher type. Now the following matcher types are\n.       supported:\n.       -   `BruteForce` (it uses L2 )\n.       -   `BruteForce-L1`\n.       -   `BruteForce-Hamming`\n.       -   `BruteForce-Hamming(2)`\n.       -   `FlannBased`\n\n\n\ncreate(matcherType) -> retval\n."},
    {"empty", CV_PY_FN_WITH_KW_(pyopencv_cv_DescriptorMatcher_empty, 0), "empty() -> retval\n.   @brief Returns true if there are no train descriptors in the both collections."},
    {"getTrainDescriptors", CV_PY_FN_WITH_KW_(pyopencv_cv_DescriptorMatcher_getTrainDescriptors, 0), "getTrainDescriptors() -> retval\n.   @brief Returns a constant link to the train descriptor collection trainDescCollection ."},
    {"isMaskSupported", CV_PY_FN_WITH_KW_(pyopencv_cv_DescriptorMatcher_isMaskSupported, 0), "isMaskSupported() -> retval\n.   @brief Returns true if the descriptor matcher supports masking permissible matches."},
    {"knnMatch", CV_PY_FN_WITH_KW_(pyopencv_cv_DescriptorMatcher_knnMatch, 0), "knnMatch(queryDescriptors, trainDescriptors, k[, mask[, compactResult]]) -> matches\n.   @brief Finds the k best matches for each descriptor from a query set.\n.   \n.       @param queryDescriptors Query set of descriptors.\n.       @param trainDescriptors Train set of descriptors. This set is not added to the train descriptors\n.       collection stored in the class object.\n.       @param mask Mask specifying permissible matches between an input query and train matrices of\n.       descriptors.\n.       @param matches Matches. Each matches[i] is k or less matches for the same query descriptor.\n.       @param k Count of best matches found per each query descriptor or less if a query descriptor has\n.       less than k possible matches in total.\n.       @param compactResult Parameter used when the mask (or masks) is not empty. If compactResult is\n.       false, the matches vector has the same size as queryDescriptors rows. If compactResult is true,\n.       the matches vector does not contain matches for fully masked-out query descriptors.\n.   \n.       These extended variants of DescriptorMatcher::match methods find several best matches for each query\n.       descriptor. The matches are returned in the distance increasing order. See DescriptorMatcher::match\n.       for the details about query and train descriptors.\n\n\n\nknnMatch(queryDescriptors, k[, masks[, compactResult]]) -> matches\n.   @overload\n.       @param queryDescriptors Query set of descriptors.\n.       @param matches Matches. Each matches[i] is k or less matches for the same query descriptor.\n.       @param k Count of best matches found per each query descriptor or less if a query descriptor has\n.       less than k possible matches in total.\n.       @param masks Set of masks. Each masks[i] specifies permissible matches between the input query\n.       descriptors and stored train descriptors from the i-th image trainDescCollection[i].\n.       @param compactResult Parameter used when the mask (or masks) is not empty. If compactResult is\n.       false, the matches vector has the same size as queryDescriptors rows. If compactResult is true,\n.       the matches vector does not contain matches for fully masked-out query descriptors."},
    {"match", CV_PY_FN_WITH_KW_(pyopencv_cv_DescriptorMatcher_match, 0), "match(queryDescriptors, trainDescriptors[, mask]) -> matches\n.   @brief Finds the best match for each descriptor from a query set.\n.   \n.       @param queryDescriptors Query set of descriptors.\n.       @param trainDescriptors Train set of descriptors. This set is not added to the train descriptors\n.       collection stored in the class object.\n.       @param matches Matches. If a query descriptor is masked out in mask , no match is added for this\n.       descriptor. So, matches size may be smaller than the query descriptors count.\n.       @param mask Mask specifying permissible matches between an input query and train matrices of\n.       descriptors.\n.   \n.       In the first variant of this method, the train descriptors are passed as an input argument. In the\n.       second variant of the method, train descriptors collection that was set by DescriptorMatcher::add is\n.       used. Optional mask (or masks) can be passed to specify which query and training descriptors can be\n.       matched. Namely, queryDescriptors[i] can be matched with trainDescriptors[j] only if\n.       mask.at\\<uchar\\>(i,j) is non-zero.\n\n\n\nmatch(queryDescriptors[, masks]) -> matches\n.   @overload\n.       @param queryDescriptors Query set of descriptors.\n.       @param matches Matches. If a query descriptor is masked out in mask , no match is added for this\n.       descriptor. So, matches size may be smaller than the query descriptors count.\n.       @param masks Set of masks. Each masks[i] specifies permissible matches between the input query\n.       descriptors and stored train descriptors from the i-th image trainDescCollection[i]."},
    {"radiusMatch", CV_PY_FN_WITH_KW_(pyopencv_cv_DescriptorMatcher_radiusMatch, 0), "radiusMatch(queryDescriptors, trainDescriptors, maxDistance[, mask[, compactResult]]) -> matches\n.   @brief For each query descriptor, finds the training descriptors not farther than the specified distance.\n.   \n.       @param queryDescriptors Query set of descriptors.\n.       @param trainDescriptors Train set of descriptors. This set is not added to the train descriptors\n.       collection stored in the class object.\n.       @param matches Found matches.\n.       @param compactResult Parameter used when the mask (or masks) is not empty. If compactResult is\n.       false, the matches vector has the same size as queryDescriptors rows. If compactResult is true,\n.       the matches vector does not contain matches for fully masked-out query descriptors.\n.       @param maxDistance Threshold for the distance between matched descriptors. Distance means here\n.       metric distance (e.g. Hamming distance), not the distance between coordinates (which is measured\n.       in Pixels)!\n.       @param mask Mask specifying permissible matches between an input query and train matrices of\n.       descriptors.\n.   \n.       For each query descriptor, the methods find such training descriptors that the distance between the\n.       query descriptor and the training descriptor is equal or smaller than maxDistance. Found matches are\n.       returned in the distance increasing order.\n\n\n\nradiusMatch(queryDescriptors, maxDistance[, masks[, compactResult]]) -> matches\n.   @overload\n.       @param queryDescriptors Query set of descriptors.\n.       @param matches Found matches.\n.       @param maxDistance Threshold for the distance between matched descriptors. Distance means here\n.       metric distance (e.g. Hamming distance), not the distance between coordinates (which is measured\n.       in Pixels)!\n.       @param masks Set of masks. Each masks[i] specifies permissible matches between the input query\n.       descriptors and stored train descriptors from the i-th image trainDescCollection[i].\n.       @param compactResult Parameter used when the mask (or masks) is not empty. If compactResult is\n.       false, the matches vector has the same size as queryDescriptors rows. If compactResult is true,\n.       the matches vector does not contain matches for fully masked-out query descriptors."},
    {"read", CV_PY_FN_WITH_KW_(pyopencv_cv_DescriptorMatcher_read, 0), "read(fileName) -> None\n.   \n\n\n\nread(arg1) -> None\n."},
    {"train", CV_PY_FN_WITH_KW_(pyopencv_cv_DescriptorMatcher_train, 0), "train() -> None\n.   @brief Trains a descriptor matcher\n.   \n.       Trains a descriptor matcher (for example, the flann index). In all methods to match, the method\n.       train() is run every time before matching. Some descriptor matchers (for example, BruteForceMatcher)\n.       have an empty implementation of this method. Other matchers really train their inner structures (for\n.       example, FlannBasedMatcher trains flann::Index )."},
    {"write", CV_PY_FN_WITH_KW_(pyopencv_cv_DescriptorMatcher_write, 0), "write(fileName) -> None\n.   \n\n\n\nwrite(fs, name) -> None\n."},

    {NULL,          NULL}
};

// Converter (DescriptorMatcher)

template<>
struct PyOpenCV_Converter< Ptr<cv::DescriptorMatcher> >
{
    static PyObject* from(const Ptr<cv::DescriptorMatcher>& r)
    {
        return pyopencv_DescriptorMatcher_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::DescriptorMatcher>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::DescriptorMatcher> * dst_;
        if (pyopencv_DescriptorMatcher_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::DescriptorMatcher> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// EMDHistogramCostExtractor (Generic)
//================================================================================

// GetSet (EMDHistogramCostExtractor)



// Methods (EMDHistogramCostExtractor)

static PyObject* pyopencv_cv_EMDHistogramCostExtractor_getNormFlag(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::EMDHistogramCostExtractor> * self1 = 0;
    if (!pyopencv_EMDHistogramCostExtractor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'EMDHistogramCostExtractor' or its derivative)");
    Ptr<cv::EMDHistogramCostExtractor> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getNormFlag());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_EMDHistogramCostExtractor_setNormFlag(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::EMDHistogramCostExtractor> * self1 = 0;
    if (!pyopencv_EMDHistogramCostExtractor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'EMDHistogramCostExtractor' or its derivative)");
    Ptr<cv::EMDHistogramCostExtractor> _self_ = *(self1);
    PyObject* pyobj_flag = NULL;
    int flag=0;

    const char* keywords[] = { "flag", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:EMDHistogramCostExtractor.setNormFlag", (char**)keywords, &pyobj_flag) &&
        pyopencv_to_safe(pyobj_flag, flag, ArgInfo("flag", 0)) )
    {
        ERRWRAP2(_self_->setNormFlag(flag));
        Py_RETURN_NONE;
    }

    return NULL;
}



// Tables (EMDHistogramCostExtractor)

static PyGetSetDef pyopencv_EMDHistogramCostExtractor_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_EMDHistogramCostExtractor_methods[] =
{
    {"getNormFlag", CV_PY_FN_WITH_KW_(pyopencv_cv_EMDHistogramCostExtractor_getNormFlag, 0), "getNormFlag() -> retval\n."},
    {"setNormFlag", CV_PY_FN_WITH_KW_(pyopencv_cv_EMDHistogramCostExtractor_setNormFlag, 0), "setNormFlag(flag) -> None\n."},

    {NULL,          NULL}
};

// Converter (EMDHistogramCostExtractor)

template<>
struct PyOpenCV_Converter< Ptr<cv::EMDHistogramCostExtractor> >
{
    static PyObject* from(const Ptr<cv::EMDHistogramCostExtractor>& r)
    {
        return pyopencv_EMDHistogramCostExtractor_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::EMDHistogramCostExtractor>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::EMDHistogramCostExtractor> * dst_;
        if (pyopencv_EMDHistogramCostExtractor_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::EMDHistogramCostExtractor> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// EMDL1HistogramCostExtractor (Generic)
//================================================================================

// GetSet (EMDL1HistogramCostExtractor)



// Methods (EMDL1HistogramCostExtractor)



// Tables (EMDL1HistogramCostExtractor)

static PyGetSetDef pyopencv_EMDL1HistogramCostExtractor_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_EMDL1HistogramCostExtractor_methods[] =
{

    {NULL,          NULL}
};

// Converter (EMDL1HistogramCostExtractor)

template<>
struct PyOpenCV_Converter< Ptr<cv::EMDL1HistogramCostExtractor> >
{
    static PyObject* from(const Ptr<cv::EMDL1HistogramCostExtractor>& r)
    {
        return pyopencv_EMDL1HistogramCostExtractor_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::EMDL1HistogramCostExtractor>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::EMDL1HistogramCostExtractor> * dst_;
        if (pyopencv_EMDL1HistogramCostExtractor_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::EMDL1HistogramCostExtractor> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// FaceDetectorYN (Generic)
//================================================================================

// GetSet (FaceDetectorYN)



// Methods (FaceDetectorYN)

static PyObject* pyopencv_cv_FaceDetectorYN_create_static(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_model = NULL;
    String model;
    PyObject* pyobj_config = NULL;
    String config;
    PyObject* pyobj_input_size = NULL;
    Size input_size;
    PyObject* pyobj_score_threshold = NULL;
    float score_threshold=0.9f;
    PyObject* pyobj_nms_threshold = NULL;
    float nms_threshold=0.3f;
    PyObject* pyobj_top_k = NULL;
    int top_k=5000;
    PyObject* pyobj_backend_id = NULL;
    int backend_id=0;
    PyObject* pyobj_target_id = NULL;
    int target_id=0;
    Ptr<FaceDetectorYN> retval;

    const char* keywords[] = { "model", "config", "input_size", "score_threshold", "nms_threshold", "top_k", "backend_id", "target_id", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOO|OOOOO:FaceDetectorYN.create", (char**)keywords, &pyobj_model, &pyobj_config, &pyobj_input_size, &pyobj_score_threshold, &pyobj_nms_threshold, &pyobj_top_k, &pyobj_backend_id, &pyobj_target_id) &&
        pyopencv_to_safe(pyobj_model, model, ArgInfo("model", 0)) &&
        pyopencv_to_safe(pyobj_config, config, ArgInfo("config", 0)) &&
        pyopencv_to_safe(pyobj_input_size, input_size, ArgInfo("input_size", 0)) &&
        pyopencv_to_safe(pyobj_score_threshold, score_threshold, ArgInfo("score_threshold", 0)) &&
        pyopencv_to_safe(pyobj_nms_threshold, nms_threshold, ArgInfo("nms_threshold", 0)) &&
        pyopencv_to_safe(pyobj_top_k, top_k, ArgInfo("top_k", 0)) &&
        pyopencv_to_safe(pyobj_backend_id, backend_id, ArgInfo("backend_id", 0)) &&
        pyopencv_to_safe(pyobj_target_id, target_id, ArgInfo("target_id", 0)) )
    {
        ERRWRAP2(retval = cv::FaceDetectorYN::create(model, config, input_size, score_threshold, nms_threshold, top_k, backend_id, target_id));
        return pyopencv_from(retval);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_framework = NULL;
    String framework;
    PyObject* pyobj_bufferModel = NULL;
    vector_uchar bufferModel;
    PyObject* pyobj_bufferConfig = NULL;
    vector_uchar bufferConfig;
    PyObject* pyobj_input_size = NULL;
    Size input_size;
    PyObject* pyobj_score_threshold = NULL;
    float score_threshold=0.9f;
    PyObject* pyobj_nms_threshold = NULL;
    float nms_threshold=0.3f;
    PyObject* pyobj_top_k = NULL;
    int top_k=5000;
    PyObject* pyobj_backend_id = NULL;
    int backend_id=0;
    PyObject* pyobj_target_id = NULL;
    int target_id=0;
    Ptr<FaceDetectorYN> retval;

    const char* keywords[] = { "framework", "bufferModel", "bufferConfig", "input_size", "score_threshold", "nms_threshold", "top_k", "backend_id", "target_id", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOOO|OOOOO:FaceDetectorYN.create", (char**)keywords, &pyobj_framework, &pyobj_bufferModel, &pyobj_bufferConfig, &pyobj_input_size, &pyobj_score_threshold, &pyobj_nms_threshold, &pyobj_top_k, &pyobj_backend_id, &pyobj_target_id) &&
        pyopencv_to_safe(pyobj_framework, framework, ArgInfo("framework", 0)) &&
        pyopencv_to_safe(pyobj_bufferModel, bufferModel, ArgInfo("bufferModel", 0)) &&
        pyopencv_to_safe(pyobj_bufferConfig, bufferConfig, ArgInfo("bufferConfig", 0)) &&
        pyopencv_to_safe(pyobj_input_size, input_size, ArgInfo("input_size", 0)) &&
        pyopencv_to_safe(pyobj_score_threshold, score_threshold, ArgInfo("score_threshold", 0)) &&
        pyopencv_to_safe(pyobj_nms_threshold, nms_threshold, ArgInfo("nms_threshold", 0)) &&
        pyopencv_to_safe(pyobj_top_k, top_k, ArgInfo("top_k", 0)) &&
        pyopencv_to_safe(pyobj_backend_id, backend_id, ArgInfo("backend_id", 0)) &&
        pyopencv_to_safe(pyobj_target_id, target_id, ArgInfo("target_id", 0)) )
    {
        ERRWRAP2(retval = cv::FaceDetectorYN::create(framework, bufferModel, bufferConfig, input_size, score_threshold, nms_threshold, top_k, backend_id, target_id));
        return pyopencv_from(retval);
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("create");

    return NULL;
}

static PyObject* pyopencv_cv_FaceDetectorYN_detect(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::FaceDetectorYN> * self1 = 0;
    if (!pyopencv_FaceDetectorYN_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FaceDetectorYN' or its derivative)");
    Ptr<cv::FaceDetectorYN> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_image = NULL;
    Mat image;
    PyObject* pyobj_faces = NULL;
    Mat faces;
    int retval;

    const char* keywords[] = { "image", "faces", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|O:FaceDetectorYN.detect", (char**)keywords, &pyobj_image, &pyobj_faces) &&
        pyopencv_to_safe(pyobj_image, image, ArgInfo("image", 0)) &&
        pyopencv_to_safe(pyobj_faces, faces, ArgInfo("faces", 1)) )
    {
        ERRWRAP2(retval = _self_->detect(image, faces));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(faces));
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_image = NULL;
    UMat image;
    PyObject* pyobj_faces = NULL;
    UMat faces;
    int retval;

    const char* keywords[] = { "image", "faces", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|O:FaceDetectorYN.detect", (char**)keywords, &pyobj_image, &pyobj_faces) &&
        pyopencv_to_safe(pyobj_image, image, ArgInfo("image", 0)) &&
        pyopencv_to_safe(pyobj_faces, faces, ArgInfo("faces", 1)) )
    {
        ERRWRAP2(retval = _self_->detect(image, faces));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(faces));
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("detect");

    return NULL;
}

static PyObject* pyopencv_cv_FaceDetectorYN_getInputSize(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::FaceDetectorYN> * self1 = 0;
    if (!pyopencv_FaceDetectorYN_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FaceDetectorYN' or its derivative)");
    Ptr<cv::FaceDetectorYN> _self_ = *(self1);
    Size retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getInputSize());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FaceDetectorYN_getNMSThreshold(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::FaceDetectorYN> * self1 = 0;
    if (!pyopencv_FaceDetectorYN_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FaceDetectorYN' or its derivative)");
    Ptr<cv::FaceDetectorYN> _self_ = *(self1);
    float retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getNMSThreshold());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FaceDetectorYN_getScoreThreshold(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::FaceDetectorYN> * self1 = 0;
    if (!pyopencv_FaceDetectorYN_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FaceDetectorYN' or its derivative)");
    Ptr<cv::FaceDetectorYN> _self_ = *(self1);
    float retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getScoreThreshold());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FaceDetectorYN_getTopK(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::FaceDetectorYN> * self1 = 0;
    if (!pyopencv_FaceDetectorYN_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FaceDetectorYN' or its derivative)");
    Ptr<cv::FaceDetectorYN> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getTopK());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FaceDetectorYN_setInputSize(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::FaceDetectorYN> * self1 = 0;
    if (!pyopencv_FaceDetectorYN_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FaceDetectorYN' or its derivative)");
    Ptr<cv::FaceDetectorYN> _self_ = *(self1);
    PyObject* pyobj_input_size = NULL;
    Size input_size;

    const char* keywords[] = { "input_size", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:FaceDetectorYN.setInputSize", (char**)keywords, &pyobj_input_size) &&
        pyopencv_to_safe(pyobj_input_size, input_size, ArgInfo("input_size", 0)) )
    {
        ERRWRAP2(_self_->setInputSize(input_size));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_FaceDetectorYN_setNMSThreshold(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::FaceDetectorYN> * self1 = 0;
    if (!pyopencv_FaceDetectorYN_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FaceDetectorYN' or its derivative)");
    Ptr<cv::FaceDetectorYN> _self_ = *(self1);
    PyObject* pyobj_nms_threshold = NULL;
    float nms_threshold=0.f;

    const char* keywords[] = { "nms_threshold", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:FaceDetectorYN.setNMSThreshold", (char**)keywords, &pyobj_nms_threshold) &&
        pyopencv_to_safe(pyobj_nms_threshold, nms_threshold, ArgInfo("nms_threshold", 0)) )
    {
        ERRWRAP2(_self_->setNMSThreshold(nms_threshold));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_FaceDetectorYN_setScoreThreshold(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::FaceDetectorYN> * self1 = 0;
    if (!pyopencv_FaceDetectorYN_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FaceDetectorYN' or its derivative)");
    Ptr<cv::FaceDetectorYN> _self_ = *(self1);
    PyObject* pyobj_score_threshold = NULL;
    float score_threshold=0.f;

    const char* keywords[] = { "score_threshold", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:FaceDetectorYN.setScoreThreshold", (char**)keywords, &pyobj_score_threshold) &&
        pyopencv_to_safe(pyobj_score_threshold, score_threshold, ArgInfo("score_threshold", 0)) )
    {
        ERRWRAP2(_self_->setScoreThreshold(score_threshold));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_FaceDetectorYN_setTopK(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::FaceDetectorYN> * self1 = 0;
    if (!pyopencv_FaceDetectorYN_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FaceDetectorYN' or its derivative)");
    Ptr<cv::FaceDetectorYN> _self_ = *(self1);
    PyObject* pyobj_top_k = NULL;
    int top_k=0;

    const char* keywords[] = { "top_k", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:FaceDetectorYN.setTopK", (char**)keywords, &pyobj_top_k) &&
        pyopencv_to_safe(pyobj_top_k, top_k, ArgInfo("top_k", 0)) )
    {
        ERRWRAP2(_self_->setTopK(top_k));
        Py_RETURN_NONE;
    }

    return NULL;
}



// Tables (FaceDetectorYN)

static PyGetSetDef pyopencv_FaceDetectorYN_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_FaceDetectorYN_methods[] =
{
    {"create", CV_PY_FN_WITH_KW_(pyopencv_cv_FaceDetectorYN_create_static, METH_STATIC), "create(model, config, input_size[, score_threshold[, nms_threshold[, top_k[, backend_id[, target_id]]]]]) -> retval\n.   @brief Creates an instance of face detector class with given parameters\n.        *\n.        *  @param model the path to the requested model\n.        *  @param config the path to the config file for compability, which is not requested for ONNX models\n.        *  @param input_size the size of the input image\n.        *  @param score_threshold the threshold to filter out bounding boxes of score smaller than the given value\n.        *  @param nms_threshold the threshold to suppress bounding boxes of IoU bigger than the given value\n.        *  @param top_k keep top K bboxes before NMS\n.        *  @param backend_id the id of backend\n.        *  @param target_id the id of target device\n\n\n\ncreate(framework, bufferModel, bufferConfig, input_size[, score_threshold[, nms_threshold[, top_k[, backend_id[, target_id]]]]]) -> retval\n.   @overload\n.        *\n.        *  @param framework Name of origin framework\n.        *  @param bufferModel A buffer with a content of binary file with weights\n.        *  @param bufferConfig A buffer with a content of text file contains network configuration\n.        *  @param input_size the size of the input image\n.        *  @param score_threshold the threshold to filter out bounding boxes of score smaller than the given value\n.        *  @param nms_threshold the threshold to suppress bounding boxes of IoU bigger than the given value\n.        *  @param top_k keep top K bboxes before NMS\n.        *  @param backend_id the id of backend\n.        *  @param target_id the id of target device"},
    {"detect", CV_PY_FN_WITH_KW_(pyopencv_cv_FaceDetectorYN_detect, 0), "detect(image[, faces]) -> retval, faces\n.   @brief Detects faces in the input image. Following is an example output.\n.   \n.        * ![image](pics/lena-face-detection.jpg)\n.   \n.        *  @param image an image to detect\n.        *  @param faces detection results stored in a 2D cv::Mat of shape [num_faces, 15]\n.        *  - 0-1: x, y of bbox top left corner\n.        *  - 2-3: width, height of bbox\n.        *  - 4-5: x, y of right eye (blue point in the example image)\n.        *  - 6-7: x, y of left eye (red point in the example image)\n.        *  - 8-9: x, y of nose tip (green point in the example image)\n.        *  - 10-11: x, y of right corner of mouth (pink point in the example image)\n.        *  - 12-13: x, y of left corner of mouth (yellow point in the example image)\n.        *  - 14: face score"},
    {"getInputSize", CV_PY_FN_WITH_KW_(pyopencv_cv_FaceDetectorYN_getInputSize, 0), "getInputSize() -> retval\n."},
    {"getNMSThreshold", CV_PY_FN_WITH_KW_(pyopencv_cv_FaceDetectorYN_getNMSThreshold, 0), "getNMSThreshold() -> retval\n."},
    {"getScoreThreshold", CV_PY_FN_WITH_KW_(pyopencv_cv_FaceDetectorYN_getScoreThreshold, 0), "getScoreThreshold() -> retval\n."},
    {"getTopK", CV_PY_FN_WITH_KW_(pyopencv_cv_FaceDetectorYN_getTopK, 0), "getTopK() -> retval\n."},
    {"setInputSize", CV_PY_FN_WITH_KW_(pyopencv_cv_FaceDetectorYN_setInputSize, 0), "setInputSize(input_size) -> None\n.   @brief Set the size for the network input, which overwrites the input size of creating model. Call this method when the size of input image does not match the input size when creating model\n.        *\n.        * @param input_size the size of the input image"},
    {"setNMSThreshold", CV_PY_FN_WITH_KW_(pyopencv_cv_FaceDetectorYN_setNMSThreshold, 0), "setNMSThreshold(nms_threshold) -> None\n.   @brief Set the Non-maximum-suppression threshold to suppress bounding boxes that have IoU greater than the given value\n.        *\n.        * @param nms_threshold threshold for NMS operation"},
    {"setScoreThreshold", CV_PY_FN_WITH_KW_(pyopencv_cv_FaceDetectorYN_setScoreThreshold, 0), "setScoreThreshold(score_threshold) -> None\n.   @brief Set the score threshold to filter out bounding boxes of score less than the given value\n.        *\n.        * @param score_threshold threshold for filtering out bounding boxes"},
    {"setTopK", CV_PY_FN_WITH_KW_(pyopencv_cv_FaceDetectorYN_setTopK, 0), "setTopK(top_k) -> None\n.   @brief Set the number of bounding boxes preserved before NMS\n.        *\n.        * @param top_k the number of bounding boxes to preserve from top rank based on score"},

    {NULL,          NULL}
};

// Converter (FaceDetectorYN)

template<>
struct PyOpenCV_Converter< Ptr<cv::FaceDetectorYN> >
{
    static PyObject* from(const Ptr<cv::FaceDetectorYN>& r)
    {
        return pyopencv_FaceDetectorYN_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::FaceDetectorYN>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::FaceDetectorYN> * dst_;
        if (pyopencv_FaceDetectorYN_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::FaceDetectorYN> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// FaceRecognizerSF (Generic)
//================================================================================

// GetSet (FaceRecognizerSF)



// Methods (FaceRecognizerSF)

static PyObject* pyopencv_cv_FaceRecognizerSF_alignCrop(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::FaceRecognizerSF> * self1 = 0;
    if (!pyopencv_FaceRecognizerSF_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FaceRecognizerSF' or its derivative)");
    Ptr<cv::FaceRecognizerSF> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_src_img = NULL;
    Mat src_img;
    PyObject* pyobj_face_box = NULL;
    Mat face_box;
    PyObject* pyobj_aligned_img = NULL;
    Mat aligned_img;

    const char* keywords[] = { "src_img", "face_box", "aligned_img", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO|O:FaceRecognizerSF.alignCrop", (char**)keywords, &pyobj_src_img, &pyobj_face_box, &pyobj_aligned_img) &&
        pyopencv_to_safe(pyobj_src_img, src_img, ArgInfo("src_img", 0)) &&
        pyopencv_to_safe(pyobj_face_box, face_box, ArgInfo("face_box", 0)) &&
        pyopencv_to_safe(pyobj_aligned_img, aligned_img, ArgInfo("aligned_img", 1)) )
    {
        ERRWRAP2(_self_->alignCrop(src_img, face_box, aligned_img));
        return pyopencv_from(aligned_img);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_src_img = NULL;
    UMat src_img;
    PyObject* pyobj_face_box = NULL;
    UMat face_box;
    PyObject* pyobj_aligned_img = NULL;
    UMat aligned_img;

    const char* keywords[] = { "src_img", "face_box", "aligned_img", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO|O:FaceRecognizerSF.alignCrop", (char**)keywords, &pyobj_src_img, &pyobj_face_box, &pyobj_aligned_img) &&
        pyopencv_to_safe(pyobj_src_img, src_img, ArgInfo("src_img", 0)) &&
        pyopencv_to_safe(pyobj_face_box, face_box, ArgInfo("face_box", 0)) &&
        pyopencv_to_safe(pyobj_aligned_img, aligned_img, ArgInfo("aligned_img", 1)) )
    {
        ERRWRAP2(_self_->alignCrop(src_img, face_box, aligned_img));
        return pyopencv_from(aligned_img);
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("alignCrop");

    return NULL;
}

static PyObject* pyopencv_cv_FaceRecognizerSF_create_static(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    PyObject* pyobj_model = NULL;
    String model;
    PyObject* pyobj_config = NULL;
    String config;
    PyObject* pyobj_backend_id = NULL;
    int backend_id=0;
    PyObject* pyobj_target_id = NULL;
    int target_id=0;
    Ptr<FaceRecognizerSF> retval;

    const char* keywords[] = { "model", "config", "backend_id", "target_id", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO|OO:FaceRecognizerSF.create", (char**)keywords, &pyobj_model, &pyobj_config, &pyobj_backend_id, &pyobj_target_id) &&
        pyopencv_to_safe(pyobj_model, model, ArgInfo("model", 0)) &&
        pyopencv_to_safe(pyobj_config, config, ArgInfo("config", 0)) &&
        pyopencv_to_safe(pyobj_backend_id, backend_id, ArgInfo("backend_id", 0)) &&
        pyopencv_to_safe(pyobj_target_id, target_id, ArgInfo("target_id", 0)) )
    {
        ERRWRAP2(retval = cv::FaceRecognizerSF::create(model, config, backend_id, target_id));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FaceRecognizerSF_feature(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::FaceRecognizerSF> * self1 = 0;
    if (!pyopencv_FaceRecognizerSF_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FaceRecognizerSF' or its derivative)");
    Ptr<cv::FaceRecognizerSF> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_aligned_img = NULL;
    Mat aligned_img;
    PyObject* pyobj_face_feature = NULL;
    Mat face_feature;

    const char* keywords[] = { "aligned_img", "face_feature", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|O:FaceRecognizerSF.feature", (char**)keywords, &pyobj_aligned_img, &pyobj_face_feature) &&
        pyopencv_to_safe(pyobj_aligned_img, aligned_img, ArgInfo("aligned_img", 0)) &&
        pyopencv_to_safe(pyobj_face_feature, face_feature, ArgInfo("face_feature", 1)) )
    {
        ERRWRAP2(_self_->feature(aligned_img, face_feature));
        return pyopencv_from(face_feature);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_aligned_img = NULL;
    UMat aligned_img;
    PyObject* pyobj_face_feature = NULL;
    UMat face_feature;

    const char* keywords[] = { "aligned_img", "face_feature", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|O:FaceRecognizerSF.feature", (char**)keywords, &pyobj_aligned_img, &pyobj_face_feature) &&
        pyopencv_to_safe(pyobj_aligned_img, aligned_img, ArgInfo("aligned_img", 0)) &&
        pyopencv_to_safe(pyobj_face_feature, face_feature, ArgInfo("face_feature", 1)) )
    {
        ERRWRAP2(_self_->feature(aligned_img, face_feature));
        return pyopencv_from(face_feature);
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("feature");

    return NULL;
}

static PyObject* pyopencv_cv_FaceRecognizerSF_match(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::FaceRecognizerSF> * self1 = 0;
    if (!pyopencv_FaceRecognizerSF_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FaceRecognizerSF' or its derivative)");
    Ptr<cv::FaceRecognizerSF> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_face_feature1 = NULL;
    Mat face_feature1;
    PyObject* pyobj_face_feature2 = NULL;
    Mat face_feature2;
    PyObject* pyobj_dis_type = NULL;
    int dis_type=FaceRecognizerSF::FR_COSINE;
    double retval;

    const char* keywords[] = { "face_feature1", "face_feature2", "dis_type", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO|O:FaceRecognizerSF.match", (char**)keywords, &pyobj_face_feature1, &pyobj_face_feature2, &pyobj_dis_type) &&
        pyopencv_to_safe(pyobj_face_feature1, face_feature1, ArgInfo("face_feature1", 0)) &&
        pyopencv_to_safe(pyobj_face_feature2, face_feature2, ArgInfo("face_feature2", 0)) &&
        pyopencv_to_safe(pyobj_dis_type, dis_type, ArgInfo("dis_type", 0)) )
    {
        ERRWRAP2(retval = _self_->match(face_feature1, face_feature2, dis_type));
        return pyopencv_from(retval);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_face_feature1 = NULL;
    UMat face_feature1;
    PyObject* pyobj_face_feature2 = NULL;
    UMat face_feature2;
    PyObject* pyobj_dis_type = NULL;
    int dis_type=FaceRecognizerSF::FR_COSINE;
    double retval;

    const char* keywords[] = { "face_feature1", "face_feature2", "dis_type", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO|O:FaceRecognizerSF.match", (char**)keywords, &pyobj_face_feature1, &pyobj_face_feature2, &pyobj_dis_type) &&
        pyopencv_to_safe(pyobj_face_feature1, face_feature1, ArgInfo("face_feature1", 0)) &&
        pyopencv_to_safe(pyobj_face_feature2, face_feature2, ArgInfo("face_feature2", 0)) &&
        pyopencv_to_safe(pyobj_dis_type, dis_type, ArgInfo("dis_type", 0)) )
    {
        ERRWRAP2(retval = _self_->match(face_feature1, face_feature2, dis_type));
        return pyopencv_from(retval);
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("match");

    return NULL;
}



// Tables (FaceRecognizerSF)

static PyGetSetDef pyopencv_FaceRecognizerSF_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_FaceRecognizerSF_methods[] =
{
    {"alignCrop", CV_PY_FN_WITH_KW_(pyopencv_cv_FaceRecognizerSF_alignCrop, 0), "alignCrop(src_img, face_box[, aligned_img]) -> aligned_img\n.   @brief Aligning image to put face on the standard position\n.        *  @param src_img input image\n.        *  @param face_box the detection result used for indicate face in input image\n.        *  @param aligned_img output aligned image"},
    {"create", CV_PY_FN_WITH_KW_(pyopencv_cv_FaceRecognizerSF_create_static, METH_STATIC), "create(model, config[, backend_id[, target_id]]) -> retval\n.   @brief Creates an instance of this class with given parameters\n.        *  @param model the path of the onnx model used for face recognition\n.        *  @param config the path to the config file for compability, which is not requested for ONNX models\n.        *  @param backend_id the id of backend\n.        *  @param target_id the id of target device"},
    {"feature", CV_PY_FN_WITH_KW_(pyopencv_cv_FaceRecognizerSF_feature, 0), "feature(aligned_img[, face_feature]) -> face_feature\n.   @brief Extracting face feature from aligned image\n.        *  @param aligned_img input aligned image\n.        *  @param face_feature output face feature"},
    {"match", CV_PY_FN_WITH_KW_(pyopencv_cv_FaceRecognizerSF_match, 0), "match(face_feature1, face_feature2[, dis_type]) -> retval\n.   @brief Calculating the distance between two face features\n.        *  @param face_feature1 the first input feature\n.        *  @param face_feature2 the second input feature of the same size and the same type as face_feature1\n.        *  @param dis_type defining the similarity with optional values \"FR_OSINE\" or \"FR_NORM_L2\""},

    {NULL,          NULL}
};

// Converter (FaceRecognizerSF)

template<>
struct PyOpenCV_Converter< Ptr<cv::FaceRecognizerSF> >
{
    static PyObject* from(const Ptr<cv::FaceRecognizerSF>& r)
    {
        return pyopencv_FaceRecognizerSF_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::FaceRecognizerSF>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::FaceRecognizerSF> * dst_;
        if (pyopencv_FaceRecognizerSF_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::FaceRecognizerSF> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// FarnebackOpticalFlow (Generic)
//================================================================================

// GetSet (FarnebackOpticalFlow)



// Methods (FarnebackOpticalFlow)

static PyObject* pyopencv_cv_FarnebackOpticalFlow_create_static(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    PyObject* pyobj_numLevels = NULL;
    int numLevels=5;
    PyObject* pyobj_pyrScale = NULL;
    double pyrScale=0.5;
    PyObject* pyobj_fastPyramids = NULL;
    bool fastPyramids=false;
    PyObject* pyobj_winSize = NULL;
    int winSize=13;
    PyObject* pyobj_numIters = NULL;
    int numIters=10;
    PyObject* pyobj_polyN = NULL;
    int polyN=5;
    PyObject* pyobj_polySigma = NULL;
    double polySigma=1.1;
    PyObject* pyobj_flags = NULL;
    int flags=0;
    Ptr<FarnebackOpticalFlow> retval;

    const char* keywords[] = { "numLevels", "pyrScale", "fastPyramids", "winSize", "numIters", "polyN", "polySigma", "flags", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "|OOOOOOOO:FarnebackOpticalFlow.create", (char**)keywords, &pyobj_numLevels, &pyobj_pyrScale, &pyobj_fastPyramids, &pyobj_winSize, &pyobj_numIters, &pyobj_polyN, &pyobj_polySigma, &pyobj_flags) &&
        pyopencv_to_safe(pyobj_numLevels, numLevels, ArgInfo("numLevels", 0)) &&
        pyopencv_to_safe(pyobj_pyrScale, pyrScale, ArgInfo("pyrScale", 0)) &&
        pyopencv_to_safe(pyobj_fastPyramids, fastPyramids, ArgInfo("fastPyramids", 0)) &&
        pyopencv_to_safe(pyobj_winSize, winSize, ArgInfo("winSize", 0)) &&
        pyopencv_to_safe(pyobj_numIters, numIters, ArgInfo("numIters", 0)) &&
        pyopencv_to_safe(pyobj_polyN, polyN, ArgInfo("polyN", 0)) &&
        pyopencv_to_safe(pyobj_polySigma, polySigma, ArgInfo("polySigma", 0)) &&
        pyopencv_to_safe(pyobj_flags, flags, ArgInfo("flags", 0)) )
    {
        ERRWRAP2(retval = cv::FarnebackOpticalFlow::create(numLevels, pyrScale, fastPyramids, winSize, numIters, polyN, polySigma, flags));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FarnebackOpticalFlow_getFastPyramids(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::FarnebackOpticalFlow> * self1 = 0;
    if (!pyopencv_FarnebackOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FarnebackOpticalFlow' or its derivative)");
    Ptr<cv::FarnebackOpticalFlow> _self_ = *(self1);
    bool retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getFastPyramids());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FarnebackOpticalFlow_getFlags(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::FarnebackOpticalFlow> * self1 = 0;
    if (!pyopencv_FarnebackOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FarnebackOpticalFlow' or its derivative)");
    Ptr<cv::FarnebackOpticalFlow> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getFlags());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FarnebackOpticalFlow_getNumIters(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::FarnebackOpticalFlow> * self1 = 0;
    if (!pyopencv_FarnebackOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FarnebackOpticalFlow' or its derivative)");
    Ptr<cv::FarnebackOpticalFlow> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getNumIters());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FarnebackOpticalFlow_getNumLevels(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::FarnebackOpticalFlow> * self1 = 0;
    if (!pyopencv_FarnebackOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FarnebackOpticalFlow' or its derivative)");
    Ptr<cv::FarnebackOpticalFlow> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getNumLevels());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FarnebackOpticalFlow_getPolyN(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::FarnebackOpticalFlow> * self1 = 0;
    if (!pyopencv_FarnebackOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FarnebackOpticalFlow' or its derivative)");
    Ptr<cv::FarnebackOpticalFlow> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getPolyN());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FarnebackOpticalFlow_getPolySigma(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::FarnebackOpticalFlow> * self1 = 0;
    if (!pyopencv_FarnebackOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FarnebackOpticalFlow' or its derivative)");
    Ptr<cv::FarnebackOpticalFlow> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getPolySigma());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FarnebackOpticalFlow_getPyrScale(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::FarnebackOpticalFlow> * self1 = 0;
    if (!pyopencv_FarnebackOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FarnebackOpticalFlow' or its derivative)");
    Ptr<cv::FarnebackOpticalFlow> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getPyrScale());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FarnebackOpticalFlow_getWinSize(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::FarnebackOpticalFlow> * self1 = 0;
    if (!pyopencv_FarnebackOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FarnebackOpticalFlow' or its derivative)");
    Ptr<cv::FarnebackOpticalFlow> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getWinSize());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FarnebackOpticalFlow_setFastPyramids(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::FarnebackOpticalFlow> * self1 = 0;
    if (!pyopencv_FarnebackOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FarnebackOpticalFlow' or its derivative)");
    Ptr<cv::FarnebackOpticalFlow> _self_ = *(self1);
    PyObject* pyobj_fastPyramids = NULL;
    bool fastPyramids=0;

    const char* keywords[] = { "fastPyramids", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:FarnebackOpticalFlow.setFastPyramids", (char**)keywords, &pyobj_fastPyramids) &&
        pyopencv_to_safe(pyobj_fastPyramids, fastPyramids, ArgInfo("fastPyramids", 0)) )
    {
        ERRWRAP2(_self_->setFastPyramids(fastPyramids));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_FarnebackOpticalFlow_setFlags(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::FarnebackOpticalFlow> * self1 = 0;
    if (!pyopencv_FarnebackOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FarnebackOpticalFlow' or its derivative)");
    Ptr<cv::FarnebackOpticalFlow> _self_ = *(self1);
    PyObject* pyobj_flags = NULL;
    int flags=0;

    const char* keywords[] = { "flags", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:FarnebackOpticalFlow.setFlags", (char**)keywords, &pyobj_flags) &&
        pyopencv_to_safe(pyobj_flags, flags, ArgInfo("flags", 0)) )
    {
        ERRWRAP2(_self_->setFlags(flags));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_FarnebackOpticalFlow_setNumIters(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::FarnebackOpticalFlow> * self1 = 0;
    if (!pyopencv_FarnebackOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FarnebackOpticalFlow' or its derivative)");
    Ptr<cv::FarnebackOpticalFlow> _self_ = *(self1);
    PyObject* pyobj_numIters = NULL;
    int numIters=0;

    const char* keywords[] = { "numIters", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:FarnebackOpticalFlow.setNumIters", (char**)keywords, &pyobj_numIters) &&
        pyopencv_to_safe(pyobj_numIters, numIters, ArgInfo("numIters", 0)) )
    {
        ERRWRAP2(_self_->setNumIters(numIters));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_FarnebackOpticalFlow_setNumLevels(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::FarnebackOpticalFlow> * self1 = 0;
    if (!pyopencv_FarnebackOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FarnebackOpticalFlow' or its derivative)");
    Ptr<cv::FarnebackOpticalFlow> _self_ = *(self1);
    PyObject* pyobj_numLevels = NULL;
    int numLevels=0;

    const char* keywords[] = { "numLevels", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:FarnebackOpticalFlow.setNumLevels", (char**)keywords, &pyobj_numLevels) &&
        pyopencv_to_safe(pyobj_numLevels, numLevels, ArgInfo("numLevels", 0)) )
    {
        ERRWRAP2(_self_->setNumLevels(numLevels));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_FarnebackOpticalFlow_setPolyN(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::FarnebackOpticalFlow> * self1 = 0;
    if (!pyopencv_FarnebackOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FarnebackOpticalFlow' or its derivative)");
    Ptr<cv::FarnebackOpticalFlow> _self_ = *(self1);
    PyObject* pyobj_polyN = NULL;
    int polyN=0;

    const char* keywords[] = { "polyN", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:FarnebackOpticalFlow.setPolyN", (char**)keywords, &pyobj_polyN) &&
        pyopencv_to_safe(pyobj_polyN, polyN, ArgInfo("polyN", 0)) )
    {
        ERRWRAP2(_self_->setPolyN(polyN));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_FarnebackOpticalFlow_setPolySigma(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::FarnebackOpticalFlow> * self1 = 0;
    if (!pyopencv_FarnebackOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FarnebackOpticalFlow' or its derivative)");
    Ptr<cv::FarnebackOpticalFlow> _self_ = *(self1);
    PyObject* pyobj_polySigma = NULL;
    double polySigma=0;

    const char* keywords[] = { "polySigma", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:FarnebackOpticalFlow.setPolySigma", (char**)keywords, &pyobj_polySigma) &&
        pyopencv_to_safe(pyobj_polySigma, polySigma, ArgInfo("polySigma", 0)) )
    {
        ERRWRAP2(_self_->setPolySigma(polySigma));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_FarnebackOpticalFlow_setPyrScale(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::FarnebackOpticalFlow> * self1 = 0;
    if (!pyopencv_FarnebackOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FarnebackOpticalFlow' or its derivative)");
    Ptr<cv::FarnebackOpticalFlow> _self_ = *(self1);
    PyObject* pyobj_pyrScale = NULL;
    double pyrScale=0;

    const char* keywords[] = { "pyrScale", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:FarnebackOpticalFlow.setPyrScale", (char**)keywords, &pyobj_pyrScale) &&
        pyopencv_to_safe(pyobj_pyrScale, pyrScale, ArgInfo("pyrScale", 0)) )
    {
        ERRWRAP2(_self_->setPyrScale(pyrScale));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_FarnebackOpticalFlow_setWinSize(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::FarnebackOpticalFlow> * self1 = 0;
    if (!pyopencv_FarnebackOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FarnebackOpticalFlow' or its derivative)");
    Ptr<cv::FarnebackOpticalFlow> _self_ = *(self1);
    PyObject* pyobj_winSize = NULL;
    int winSize=0;

    const char* keywords[] = { "winSize", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:FarnebackOpticalFlow.setWinSize", (char**)keywords, &pyobj_winSize) &&
        pyopencv_to_safe(pyobj_winSize, winSize, ArgInfo("winSize", 0)) )
    {
        ERRWRAP2(_self_->setWinSize(winSize));
        Py_RETURN_NONE;
    }

    return NULL;
}



// Tables (FarnebackOpticalFlow)

static PyGetSetDef pyopencv_FarnebackOpticalFlow_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_FarnebackOpticalFlow_methods[] =
{
    {"create", CV_PY_FN_WITH_KW_(pyopencv_cv_FarnebackOpticalFlow_create_static, METH_STATIC), "create([, numLevels[, pyrScale[, fastPyramids[, winSize[, numIters[, polyN[, polySigma[, flags]]]]]]]]) -> retval\n."},
    {"getFastPyramids", CV_PY_FN_WITH_KW_(pyopencv_cv_FarnebackOpticalFlow_getFastPyramids, 0), "getFastPyramids() -> retval\n."},
    {"getFlags", CV_PY_FN_WITH_KW_(pyopencv_cv_FarnebackOpticalFlow_getFlags, 0), "getFlags() -> retval\n."},
    {"getNumIters", CV_PY_FN_WITH_KW_(pyopencv_cv_FarnebackOpticalFlow_getNumIters, 0), "getNumIters() -> retval\n."},
    {"getNumLevels", CV_PY_FN_WITH_KW_(pyopencv_cv_FarnebackOpticalFlow_getNumLevels, 0), "getNumLevels() -> retval\n."},
    {"getPolyN", CV_PY_FN_WITH_KW_(pyopencv_cv_FarnebackOpticalFlow_getPolyN, 0), "getPolyN() -> retval\n."},
    {"getPolySigma", CV_PY_FN_WITH_KW_(pyopencv_cv_FarnebackOpticalFlow_getPolySigma, 0), "getPolySigma() -> retval\n."},
    {"getPyrScale", CV_PY_FN_WITH_KW_(pyopencv_cv_FarnebackOpticalFlow_getPyrScale, 0), "getPyrScale() -> retval\n."},
    {"getWinSize", CV_PY_FN_WITH_KW_(pyopencv_cv_FarnebackOpticalFlow_getWinSize, 0), "getWinSize() -> retval\n."},
    {"setFastPyramids", CV_PY_FN_WITH_KW_(pyopencv_cv_FarnebackOpticalFlow_setFastPyramids, 0), "setFastPyramids(fastPyramids) -> None\n."},
    {"setFlags", CV_PY_FN_WITH_KW_(pyopencv_cv_FarnebackOpticalFlow_setFlags, 0), "setFlags(flags) -> None\n."},
    {"setNumIters", CV_PY_FN_WITH_KW_(pyopencv_cv_FarnebackOpticalFlow_setNumIters, 0), "setNumIters(numIters) -> None\n."},
    {"setNumLevels", CV_PY_FN_WITH_KW_(pyopencv_cv_FarnebackOpticalFlow_setNumLevels, 0), "setNumLevels(numLevels) -> None\n."},
    {"setPolyN", CV_PY_FN_WITH_KW_(pyopencv_cv_FarnebackOpticalFlow_setPolyN, 0), "setPolyN(polyN) -> None\n."},
    {"setPolySigma", CV_PY_FN_WITH_KW_(pyopencv_cv_FarnebackOpticalFlow_setPolySigma, 0), "setPolySigma(polySigma) -> None\n."},
    {"setPyrScale", CV_PY_FN_WITH_KW_(pyopencv_cv_FarnebackOpticalFlow_setPyrScale, 0), "setPyrScale(pyrScale) -> None\n."},
    {"setWinSize", CV_PY_FN_WITH_KW_(pyopencv_cv_FarnebackOpticalFlow_setWinSize, 0), "setWinSize(winSize) -> None\n."},

    {NULL,          NULL}
};

// Converter (FarnebackOpticalFlow)

template<>
struct PyOpenCV_Converter< Ptr<cv::FarnebackOpticalFlow> >
{
    static PyObject* from(const Ptr<cv::FarnebackOpticalFlow>& r)
    {
        return pyopencv_FarnebackOpticalFlow_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::FarnebackOpticalFlow>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::FarnebackOpticalFlow> * dst_;
        if (pyopencv_FarnebackOpticalFlow_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::FarnebackOpticalFlow> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// FastFeatureDetector (Generic)
//================================================================================

// GetSet (FastFeatureDetector)



// Methods (FastFeatureDetector)

static PyObject* pyopencv_cv_FastFeatureDetector_create_static(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    PyObject* pyobj_threshold = NULL;
    int threshold=10;
    PyObject* pyobj_nonmaxSuppression = NULL;
    bool nonmaxSuppression=true;
    PyObject* pyobj_type = NULL;
    FastFeatureDetector_DetectorType type=FastFeatureDetector::TYPE_9_16;
    Ptr<FastFeatureDetector> retval;

    const char* keywords[] = { "threshold", "nonmaxSuppression", "type", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "|OOO:FastFeatureDetector.create", (char**)keywords, &pyobj_threshold, &pyobj_nonmaxSuppression, &pyobj_type) &&
        pyopencv_to_safe(pyobj_threshold, threshold, ArgInfo("threshold", 0)) &&
        pyopencv_to_safe(pyobj_nonmaxSuppression, nonmaxSuppression, ArgInfo("nonmaxSuppression", 0)) &&
        pyopencv_to_safe(pyobj_type, type, ArgInfo("type", 0)) )
    {
        ERRWRAP2(retval = cv::FastFeatureDetector::create(threshold, nonmaxSuppression, type));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FastFeatureDetector_getDefaultName(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::FastFeatureDetector> * self1 = 0;
    if (!pyopencv_FastFeatureDetector_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FastFeatureDetector' or its derivative)");
    Ptr<cv::FastFeatureDetector> _self_ = *(self1);
    String retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getDefaultName());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FastFeatureDetector_getNonmaxSuppression(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::FastFeatureDetector> * self1 = 0;
    if (!pyopencv_FastFeatureDetector_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FastFeatureDetector' or its derivative)");
    Ptr<cv::FastFeatureDetector> _self_ = *(self1);
    bool retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getNonmaxSuppression());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FastFeatureDetector_getThreshold(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::FastFeatureDetector> * self1 = 0;
    if (!pyopencv_FastFeatureDetector_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FastFeatureDetector' or its derivative)");
    Ptr<cv::FastFeatureDetector> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getThreshold());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FastFeatureDetector_getType(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::FastFeatureDetector> * self1 = 0;
    if (!pyopencv_FastFeatureDetector_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FastFeatureDetector' or its derivative)");
    Ptr<cv::FastFeatureDetector> _self_ = *(self1);
    FastFeatureDetector::DetectorType retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getType());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FastFeatureDetector_setNonmaxSuppression(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::FastFeatureDetector> * self1 = 0;
    if (!pyopencv_FastFeatureDetector_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FastFeatureDetector' or its derivative)");
    Ptr<cv::FastFeatureDetector> _self_ = *(self1);
    PyObject* pyobj_f = NULL;
    bool f=0;

    const char* keywords[] = { "f", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:FastFeatureDetector.setNonmaxSuppression", (char**)keywords, &pyobj_f) &&
        pyopencv_to_safe(pyobj_f, f, ArgInfo("f", 0)) )
    {
        ERRWRAP2(_self_->setNonmaxSuppression(f));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_FastFeatureDetector_setThreshold(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::FastFeatureDetector> * self1 = 0;
    if (!pyopencv_FastFeatureDetector_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FastFeatureDetector' or its derivative)");
    Ptr<cv::FastFeatureDetector> _self_ = *(self1);
    PyObject* pyobj_threshold = NULL;
    int threshold=0;

    const char* keywords[] = { "threshold", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:FastFeatureDetector.setThreshold", (char**)keywords, &pyobj_threshold) &&
        pyopencv_to_safe(pyobj_threshold, threshold, ArgInfo("threshold", 0)) )
    {
        ERRWRAP2(_self_->setThreshold(threshold));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_FastFeatureDetector_setType(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::FastFeatureDetector> * self1 = 0;
    if (!pyopencv_FastFeatureDetector_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FastFeatureDetector' or its derivative)");
    Ptr<cv::FastFeatureDetector> _self_ = *(self1);
    PyObject* pyobj_type = NULL;
    FastFeatureDetector_DetectorType type=static_cast<FastFeatureDetector_DetectorType>(0);

    const char* keywords[] = { "type", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:FastFeatureDetector.setType", (char**)keywords, &pyobj_type) &&
        pyopencv_to_safe(pyobj_type, type, ArgInfo("type", 0)) )
    {
        ERRWRAP2(_self_->setType(type));
        Py_RETURN_NONE;
    }

    return NULL;
}



// Tables (FastFeatureDetector)

static PyGetSetDef pyopencv_FastFeatureDetector_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_FastFeatureDetector_methods[] =
{
    {"create", CV_PY_FN_WITH_KW_(pyopencv_cv_FastFeatureDetector_create_static, METH_STATIC), "create([, threshold[, nonmaxSuppression[, type]]]) -> retval\n."},
    {"getDefaultName", CV_PY_FN_WITH_KW_(pyopencv_cv_FastFeatureDetector_getDefaultName, 0), "getDefaultName() -> retval\n."},
    {"getNonmaxSuppression", CV_PY_FN_WITH_KW_(pyopencv_cv_FastFeatureDetector_getNonmaxSuppression, 0), "getNonmaxSuppression() -> retval\n."},
    {"getThreshold", CV_PY_FN_WITH_KW_(pyopencv_cv_FastFeatureDetector_getThreshold, 0), "getThreshold() -> retval\n."},
    {"getType", CV_PY_FN_WITH_KW_(pyopencv_cv_FastFeatureDetector_getType, 0), "getType() -> retval\n."},
    {"setNonmaxSuppression", CV_PY_FN_WITH_KW_(pyopencv_cv_FastFeatureDetector_setNonmaxSuppression, 0), "setNonmaxSuppression(f) -> None\n."},
    {"setThreshold", CV_PY_FN_WITH_KW_(pyopencv_cv_FastFeatureDetector_setThreshold, 0), "setThreshold(threshold) -> None\n."},
    {"setType", CV_PY_FN_WITH_KW_(pyopencv_cv_FastFeatureDetector_setType, 0), "setType(type) -> None\n."},

    {NULL,          NULL}
};

// Converter (FastFeatureDetector)

template<>
struct PyOpenCV_Converter< Ptr<cv::FastFeatureDetector> >
{
    static PyObject* from(const Ptr<cv::FastFeatureDetector>& r)
    {
        return pyopencv_FastFeatureDetector_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::FastFeatureDetector>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::FastFeatureDetector> * dst_;
        if (pyopencv_FastFeatureDetector_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::FastFeatureDetector> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// Feature2D (Generic)
//================================================================================

// GetSet (Feature2D)



// Methods (Feature2D)

static PyObject* pyopencv_cv_Feature2D_compute(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Feature2D> * self1 = 0;
    if (!pyopencv_Feature2D_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Feature2D' or its derivative)");
    Ptr<cv::Feature2D> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(4);

    {
    PyObject* pyobj_image = NULL;
    Mat image;
    PyObject* pyobj_keypoints = NULL;
    vector_KeyPoint keypoints;
    PyObject* pyobj_descriptors = NULL;
    Mat descriptors;

    const char* keywords[] = { "image", "keypoints", "descriptors", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO|O:Feature2D.compute", (char**)keywords, &pyobj_image, &pyobj_keypoints, &pyobj_descriptors) &&
        pyopencv_to_safe(pyobj_image, image, ArgInfo("image", 0)) &&
        pyopencv_to_safe(pyobj_keypoints, keypoints, ArgInfo("keypoints", 1)) &&
        pyopencv_to_safe(pyobj_descriptors, descriptors, ArgInfo("descriptors", 1)) )
    {
        ERRWRAP2(_self_->compute(image, keypoints, descriptors));
        return Py_BuildValue("(NN)", pyopencv_from(keypoints), pyopencv_from(descriptors));
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_image = NULL;
    UMat image;
    PyObject* pyobj_keypoints = NULL;
    vector_KeyPoint keypoints;
    PyObject* pyobj_descriptors = NULL;
    UMat descriptors;

    const char* keywords[] = { "image", "keypoints", "descriptors", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO|O:Feature2D.compute", (char**)keywords, &pyobj_image, &pyobj_keypoints, &pyobj_descriptors) &&
        pyopencv_to_safe(pyobj_image, image, ArgInfo("image", 0)) &&
        pyopencv_to_safe(pyobj_keypoints, keypoints, ArgInfo("keypoints", 1)) &&
        pyopencv_to_safe(pyobj_descriptors, descriptors, ArgInfo("descriptors", 1)) )
    {
        ERRWRAP2(_self_->compute(image, keypoints, descriptors));
        return Py_BuildValue("(NN)", pyopencv_from(keypoints), pyopencv_from(descriptors));
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_images = NULL;
    vector_Mat images;
    PyObject* pyobj_keypoints = NULL;
    vector_vector_KeyPoint keypoints;
    PyObject* pyobj_descriptors = NULL;
    vector_Mat descriptors;

    const char* keywords[] = { "images", "keypoints", "descriptors", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO|O:Feature2D.compute", (char**)keywords, &pyobj_images, &pyobj_keypoints, &pyobj_descriptors) &&
        pyopencv_to_safe(pyobj_images, images, ArgInfo("images", 0)) &&
        pyopencv_to_safe(pyobj_keypoints, keypoints, ArgInfo("keypoints", 1)) &&
        pyopencv_to_safe(pyobj_descriptors, descriptors, ArgInfo("descriptors", 1)) )
    {
        ERRWRAP2(_self_->compute(images, keypoints, descriptors));
        return Py_BuildValue("(NN)", pyopencv_from(keypoints), pyopencv_from(descriptors));
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_images = NULL;
    vector_UMat images;
    PyObject* pyobj_keypoints = NULL;
    vector_vector_KeyPoint keypoints;
    PyObject* pyobj_descriptors = NULL;
    vector_UMat descriptors;

    const char* keywords[] = { "images", "keypoints", "descriptors", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO|O:Feature2D.compute", (char**)keywords, &pyobj_images, &pyobj_keypoints, &pyobj_descriptors) &&
        pyopencv_to_safe(pyobj_images, images, ArgInfo("images", 0)) &&
        pyopencv_to_safe(pyobj_keypoints, keypoints, ArgInfo("keypoints", 1)) &&
        pyopencv_to_safe(pyobj_descriptors, descriptors, ArgInfo("descriptors", 1)) )
    {
        ERRWRAP2(_self_->compute(images, keypoints, descriptors));
        return Py_BuildValue("(NN)", pyopencv_from(keypoints), pyopencv_from(descriptors));
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("compute");

    return NULL;
}

static PyObject* pyopencv_cv_Feature2D_defaultNorm(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Feature2D> * self1 = 0;
    if (!pyopencv_Feature2D_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Feature2D' or its derivative)");
    Ptr<cv::Feature2D> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->defaultNorm());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_Feature2D_descriptorSize(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Feature2D> * self1 = 0;
    if (!pyopencv_Feature2D_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Feature2D' or its derivative)");
    Ptr<cv::Feature2D> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->descriptorSize());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_Feature2D_descriptorType(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Feature2D> * self1 = 0;
    if (!pyopencv_Feature2D_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Feature2D' or its derivative)");
    Ptr<cv::Feature2D> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->descriptorType());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_Feature2D_detect(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Feature2D> * self1 = 0;
    if (!pyopencv_Feature2D_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Feature2D' or its derivative)");
    Ptr<cv::Feature2D> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(4);

    {
    PyObject* pyobj_image = NULL;
    Mat image;
    vector_KeyPoint keypoints;
    PyObject* pyobj_mask = NULL;
    Mat mask;

    const char* keywords[] = { "image", "mask", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|O:Feature2D.detect", (char**)keywords, &pyobj_image, &pyobj_mask) &&
        pyopencv_to_safe(pyobj_image, image, ArgInfo("image", 0)) &&
        pyopencv_to_safe(pyobj_mask, mask, ArgInfo("mask", 0)) )
    {
        ERRWRAP2(_self_->detect(image, keypoints, mask));
        return pyopencv_from(keypoints);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_image = NULL;
    UMat image;
    vector_KeyPoint keypoints;
    PyObject* pyobj_mask = NULL;
    UMat mask;

    const char* keywords[] = { "image", "mask", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|O:Feature2D.detect", (char**)keywords, &pyobj_image, &pyobj_mask) &&
        pyopencv_to_safe(pyobj_image, image, ArgInfo("image", 0)) &&
        pyopencv_to_safe(pyobj_mask, mask, ArgInfo("mask", 0)) )
    {
        ERRWRAP2(_self_->detect(image, keypoints, mask));
        return pyopencv_from(keypoints);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_images = NULL;
    vector_Mat images;
    vector_vector_KeyPoint keypoints;
    PyObject* pyobj_masks = NULL;
    vector_Mat masks;

    const char* keywords[] = { "images", "masks", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|O:Feature2D.detect", (char**)keywords, &pyobj_images, &pyobj_masks) &&
        pyopencv_to_safe(pyobj_images, images, ArgInfo("images", 0)) &&
        pyopencv_to_safe(pyobj_masks, masks, ArgInfo("masks", 0)) )
    {
        ERRWRAP2(_self_->detect(images, keypoints, masks));
        return pyopencv_from(keypoints);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_images = NULL;
    vector_UMat images;
    vector_vector_KeyPoint keypoints;
    PyObject* pyobj_masks = NULL;
    vector_UMat masks;

    const char* keywords[] = { "images", "masks", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|O:Feature2D.detect", (char**)keywords, &pyobj_images, &pyobj_masks) &&
        pyopencv_to_safe(pyobj_images, images, ArgInfo("images", 0)) &&
        pyopencv_to_safe(pyobj_masks, masks, ArgInfo("masks", 0)) )
    {
        ERRWRAP2(_self_->detect(images, keypoints, masks));
        return pyopencv_from(keypoints);
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("detect");

    return NULL;
}

static PyObject* pyopencv_cv_Feature2D_detectAndCompute(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Feature2D> * self1 = 0;
    if (!pyopencv_Feature2D_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Feature2D' or its derivative)");
    Ptr<cv::Feature2D> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_image = NULL;
    Mat image;
    PyObject* pyobj_mask = NULL;
    Mat mask;
    vector_KeyPoint keypoints;
    PyObject* pyobj_descriptors = NULL;
    Mat descriptors;
    PyObject* pyobj_useProvidedKeypoints = NULL;
    bool useProvidedKeypoints=false;

    const char* keywords[] = { "image", "mask", "descriptors", "useProvidedKeypoints", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO|OO:Feature2D.detectAndCompute", (char**)keywords, &pyobj_image, &pyobj_mask, &pyobj_descriptors, &pyobj_useProvidedKeypoints) &&
        pyopencv_to_safe(pyobj_image, image, ArgInfo("image", 0)) &&
        pyopencv_to_safe(pyobj_mask, mask, ArgInfo("mask", 0)) &&
        pyopencv_to_safe(pyobj_descriptors, descriptors, ArgInfo("descriptors", 1)) &&
        pyopencv_to_safe(pyobj_useProvidedKeypoints, useProvidedKeypoints, ArgInfo("useProvidedKeypoints", 0)) )
    {
        ERRWRAP2(_self_->detectAndCompute(image, mask, keypoints, descriptors, useProvidedKeypoints));
        return Py_BuildValue("(NN)", pyopencv_from(keypoints), pyopencv_from(descriptors));
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_image = NULL;
    UMat image;
    PyObject* pyobj_mask = NULL;
    UMat mask;
    vector_KeyPoint keypoints;
    PyObject* pyobj_descriptors = NULL;
    UMat descriptors;
    PyObject* pyobj_useProvidedKeypoints = NULL;
    bool useProvidedKeypoints=false;

    const char* keywords[] = { "image", "mask", "descriptors", "useProvidedKeypoints", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO|OO:Feature2D.detectAndCompute", (char**)keywords, &pyobj_image, &pyobj_mask, &pyobj_descriptors, &pyobj_useProvidedKeypoints) &&
        pyopencv_to_safe(pyobj_image, image, ArgInfo("image", 0)) &&
        pyopencv_to_safe(pyobj_mask, mask, ArgInfo("mask", 0)) &&
        pyopencv_to_safe(pyobj_descriptors, descriptors, ArgInfo("descriptors", 1)) &&
        pyopencv_to_safe(pyobj_useProvidedKeypoints, useProvidedKeypoints, ArgInfo("useProvidedKeypoints", 0)) )
    {
        ERRWRAP2(_self_->detectAndCompute(image, mask, keypoints, descriptors, useProvidedKeypoints));
        return Py_BuildValue("(NN)", pyopencv_from(keypoints), pyopencv_from(descriptors));
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("detectAndCompute");

    return NULL;
}

static PyObject* pyopencv_cv_Feature2D_empty(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Feature2D> * self1 = 0;
    if (!pyopencv_Feature2D_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Feature2D' or its derivative)");
    Ptr<cv::Feature2D> _self_ = *(self1);
    bool retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->empty());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_Feature2D_getDefaultName(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Feature2D> * self1 = 0;
    if (!pyopencv_Feature2D_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Feature2D' or its derivative)");
    Ptr<cv::Feature2D> _self_ = *(self1);
    String retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getDefaultName());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_Feature2D_read(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Feature2D> * self1 = 0;
    if (!pyopencv_Feature2D_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Feature2D' or its derivative)");
    Ptr<cv::Feature2D> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_fileName = NULL;
    String fileName;

    const char* keywords[] = { "fileName", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:Feature2D.read", (char**)keywords, &pyobj_fileName) &&
        pyopencv_to_safe(pyobj_fileName, fileName, ArgInfo("fileName", 0)) )
    {
        ERRWRAP2(_self_->read(fileName));
        Py_RETURN_NONE;
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_arg1 = NULL;
    cv::FileNode arg1;

    const char* keywords[] = { "arg1", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:Feature2D.read", (char**)keywords, &pyobj_arg1) &&
        pyopencv_to_safe(pyobj_arg1, arg1, ArgInfo("arg1", 0)) )
    {
        ERRWRAP2(_self_->read(arg1));
        Py_RETURN_NONE;
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("read");

    return NULL;
}

static PyObject* pyopencv_cv_Feature2D_write(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Feature2D> * self1 = 0;
    if (!pyopencv_Feature2D_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Feature2D' or its derivative)");
    Ptr<cv::Feature2D> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_fileName = NULL;
    String fileName;

    const char* keywords[] = { "fileName", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:Feature2D.write", (char**)keywords, &pyobj_fileName) &&
        pyopencv_to_safe(pyobj_fileName, fileName, ArgInfo("fileName", 0)) )
    {
        ERRWRAP2(_self_->write(fileName));
        Py_RETURN_NONE;
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_fs = NULL;
    Ptr<cv::FileStorage> fs;
    PyObject* pyobj_name = NULL;
    String name;

    const char* keywords[] = { "fs", "name", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO:Feature2D.write", (char**)keywords, &pyobj_fs, &pyobj_name) &&
        pyopencv_to_safe(pyobj_fs, fs, ArgInfo("fs", 0)) &&
        pyopencv_to_safe(pyobj_name, name, ArgInfo("name", 0)) )
    {
        ERRWRAP2(_self_->write(*fs, name));
        Py_RETURN_NONE;
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("write");

    return NULL;
}



// Tables (Feature2D)

static PyGetSetDef pyopencv_Feature2D_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_Feature2D_methods[] =
{
    {"compute", CV_PY_FN_WITH_KW_(pyopencv_cv_Feature2D_compute, 0), "compute(image, keypoints[, descriptors]) -> keypoints, descriptors\n.   @brief Computes the descriptors for a set of keypoints detected in an image (first variant) or image set\n.       (second variant).\n.   \n.       @param image Image.\n.       @param keypoints Input collection of keypoints. Keypoints for which a descriptor cannot be\n.       computed are removed. Sometimes new keypoints can be added, for example: SIFT duplicates keypoint\n.       with several dominant orientations (for each orientation).\n.       @param descriptors Computed descriptors. In the second variant of the method descriptors[i] are\n.       descriptors computed for a keypoints[i]. Row j is the keypoints (or keypoints[i]) is the\n.       descriptor for keypoint j-th keypoint.\n\n\n\ncompute(images, keypoints[, descriptors]) -> keypoints, descriptors\n.   @overload\n.   \n.       @param images Image set.\n.       @param keypoints Input collection of keypoints. Keypoints for which a descriptor cannot be\n.       computed are removed. Sometimes new keypoints can be added, for example: SIFT duplicates keypoint\n.       with several dominant orientations (for each orientation).\n.       @param descriptors Computed descriptors. In the second variant of the method descriptors[i] are\n.       descriptors computed for a keypoints[i]. Row j is the keypoints (or keypoints[i]) is the\n.       descriptor for keypoint j-th keypoint."},
    {"defaultNorm", CV_PY_FN_WITH_KW_(pyopencv_cv_Feature2D_defaultNorm, 0), "defaultNorm() -> retval\n."},
    {"descriptorSize", CV_PY_FN_WITH_KW_(pyopencv_cv_Feature2D_descriptorSize, 0), "descriptorSize() -> retval\n."},
    {"descriptorType", CV_PY_FN_WITH_KW_(pyopencv_cv_Feature2D_descriptorType, 0), "descriptorType() -> retval\n."},
    {"detect", CV_PY_FN_WITH_KW_(pyopencv_cv_Feature2D_detect, 0), "detect(image[, mask]) -> keypoints\n.   @brief Detects keypoints in an image (first variant) or image set (second variant).\n.   \n.       @param image Image.\n.       @param keypoints The detected keypoints. In the second variant of the method keypoints[i] is a set\n.       of keypoints detected in images[i] .\n.       @param mask Mask specifying where to look for keypoints (optional). It must be a 8-bit integer\n.       matrix with non-zero values in the region of interest.\n\n\n\ndetect(images[, masks]) -> keypoints\n.   @overload\n.       @param images Image set.\n.       @param keypoints The detected keypoints. In the second variant of the method keypoints[i] is a set\n.       of keypoints detected in images[i] .\n.       @param masks Masks for each input image specifying where to look for keypoints (optional).\n.       masks[i] is a mask for images[i]."},
    {"detectAndCompute", CV_PY_FN_WITH_KW_(pyopencv_cv_Feature2D_detectAndCompute, 0), "detectAndCompute(image, mask[, descriptors[, useProvidedKeypoints]]) -> keypoints, descriptors\n.   Detects keypoints and computes the descriptors"},
    {"empty", CV_PY_FN_WITH_KW_(pyopencv_cv_Feature2D_empty, 0), "empty() -> retval\n."},
    {"getDefaultName", CV_PY_FN_WITH_KW_(pyopencv_cv_Feature2D_getDefaultName, 0), "getDefaultName() -> retval\n."},
    {"read", CV_PY_FN_WITH_KW_(pyopencv_cv_Feature2D_read, 0), "read(fileName) -> None\n.   \n\n\n\nread(arg1) -> None\n."},
    {"write", CV_PY_FN_WITH_KW_(pyopencv_cv_Feature2D_write, 0), "write(fileName) -> None\n.   \n\n\n\nwrite(fs, name) -> None\n."},

    {NULL,          NULL}
};

// Converter (Feature2D)

template<>
struct PyOpenCV_Converter< Ptr<cv::Feature2D> >
{
    static PyObject* from(const Ptr<cv::Feature2D>& r)
    {
        return pyopencv_Feature2D_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::Feature2D>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::Feature2D> * dst_;
        if (pyopencv_Feature2D_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::Feature2D> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// FileNode (Generic)
//================================================================================

// GetSet (FileNode)



// Methods (FileNode)

static int pyopencv_cv_FileNode_FileNode(pyopencv_FileNode_t* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        if(self) ERRWRAP2(new (&(self->v)) cv::FileNode());
        return 0;
    }

    return -1;
}

static PyObject* pyopencv_cv_FileNode_at(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    cv::FileNode * self1 = 0;
    if (!pyopencv_FileNode_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FileNode' or its derivative)");
    cv::FileNode* _self_ = (self1);
    PyObject* pyobj_i = NULL;
    int i=0;
    FileNode retval;

    const char* keywords[] = { "i", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:FileNode.at", (char**)keywords, &pyobj_i) &&
        pyopencv_to_safe(pyobj_i, i, ArgInfo("i", 0)) )
    {
        ERRWRAP2(retval = _self_->operator[](i));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileNode_empty(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    cv::FileNode * self1 = 0;
    if (!pyopencv_FileNode_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FileNode' or its derivative)");
    cv::FileNode* _self_ = (self1);
    bool retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->empty());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileNode_getNode(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    cv::FileNode * self1 = 0;
    if (!pyopencv_FileNode_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FileNode' or its derivative)");
    cv::FileNode* _self_ = (self1);
    char* nodename=(char*)"";
    FileNode retval;

    const char* keywords[] = { "nodename", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "s:FileNode.getNode", (char**)keywords, &nodename) )
    {
        ERRWRAP2(retval = _self_->operator[](nodename));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileNode_isInt(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    cv::FileNode * self1 = 0;
    if (!pyopencv_FileNode_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FileNode' or its derivative)");
    cv::FileNode* _self_ = (self1);
    bool retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->isInt());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileNode_isMap(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    cv::FileNode * self1 = 0;
    if (!pyopencv_FileNode_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FileNode' or its derivative)");
    cv::FileNode* _self_ = (self1);
    bool retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->isMap());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileNode_isNamed(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    cv::FileNode * self1 = 0;
    if (!pyopencv_FileNode_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FileNode' or its derivative)");
    cv::FileNode* _self_ = (self1);
    bool retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->isNamed());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileNode_isNone(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    cv::FileNode * self1 = 0;
    if (!pyopencv_FileNode_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FileNode' or its derivative)");
    cv::FileNode* _self_ = (self1);
    bool retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->isNone());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileNode_isReal(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    cv::FileNode * self1 = 0;
    if (!pyopencv_FileNode_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FileNode' or its derivative)");
    cv::FileNode* _self_ = (self1);
    bool retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->isReal());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileNode_isSeq(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    cv::FileNode * self1 = 0;
    if (!pyopencv_FileNode_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FileNode' or its derivative)");
    cv::FileNode* _self_ = (self1);
    bool retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->isSeq());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileNode_isString(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    cv::FileNode * self1 = 0;
    if (!pyopencv_FileNode_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FileNode' or its derivative)");
    cv::FileNode* _self_ = (self1);
    bool retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->isString());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileNode_keys(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    cv::FileNode * self1 = 0;
    if (!pyopencv_FileNode_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FileNode' or its derivative)");
    cv::FileNode* _self_ = (self1);
    std::vector<String> retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->keys());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileNode_mat(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    cv::FileNode * self1 = 0;
    if (!pyopencv_FileNode_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FileNode' or its derivative)");
    cv::FileNode* _self_ = (self1);
    Mat retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->mat());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileNode_name(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    cv::FileNode * self1 = 0;
    if (!pyopencv_FileNode_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FileNode' or its derivative)");
    cv::FileNode* _self_ = (self1);
    std::string retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->name());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileNode_rawSize(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    cv::FileNode * self1 = 0;
    if (!pyopencv_FileNode_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FileNode' or its derivative)");
    cv::FileNode* _self_ = (self1);
    size_t retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->rawSize());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileNode_real(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    cv::FileNode * self1 = 0;
    if (!pyopencv_FileNode_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FileNode' or its derivative)");
    cv::FileNode* _self_ = (self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->real());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileNode_size(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    cv::FileNode * self1 = 0;
    if (!pyopencv_FileNode_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FileNode' or its derivative)");
    cv::FileNode* _self_ = (self1);
    size_t retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->size());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileNode_string(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    cv::FileNode * self1 = 0;
    if (!pyopencv_FileNode_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FileNode' or its derivative)");
    cv::FileNode* _self_ = (self1);
    std::string retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->string());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileNode_type(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    cv::FileNode * self1 = 0;
    if (!pyopencv_FileNode_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FileNode' or its derivative)");
    cv::FileNode* _self_ = (self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->type());
        return pyopencv_from(retval);
    }

    return NULL;
}



// Tables (FileNode)

static PyGetSetDef pyopencv_FileNode_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_FileNode_methods[] =
{
    {"at", CV_PY_FN_WITH_KW_(pyopencv_cv_FileNode_at, 0), "at(i) -> retval\n.   @overload\n.        @param i Index of an element in the sequence node."},
    {"empty", CV_PY_FN_WITH_KW_(pyopencv_cv_FileNode_empty, 0), "empty() -> retval\n."},
    {"getNode", CV_PY_FN_WITH_KW_(pyopencv_cv_FileNode_getNode, 0), "getNode(nodename) -> retval\n.   @overload\n.        @param nodename Name of an element in the mapping node."},
    {"isInt", CV_PY_FN_WITH_KW_(pyopencv_cv_FileNode_isInt, 0), "isInt() -> retval\n."},
    {"isMap", CV_PY_FN_WITH_KW_(pyopencv_cv_FileNode_isMap, 0), "isMap() -> retval\n."},
    {"isNamed", CV_PY_FN_WITH_KW_(pyopencv_cv_FileNode_isNamed, 0), "isNamed() -> retval\n."},
    {"isNone", CV_PY_FN_WITH_KW_(pyopencv_cv_FileNode_isNone, 0), "isNone() -> retval\n."},
    {"isReal", CV_PY_FN_WITH_KW_(pyopencv_cv_FileNode_isReal, 0), "isReal() -> retval\n."},
    {"isSeq", CV_PY_FN_WITH_KW_(pyopencv_cv_FileNode_isSeq, 0), "isSeq() -> retval\n."},
    {"isString", CV_PY_FN_WITH_KW_(pyopencv_cv_FileNode_isString, 0), "isString() -> retval\n."},
    {"keys", CV_PY_FN_WITH_KW_(pyopencv_cv_FileNode_keys, 0), "keys() -> retval\n.   @brief Returns keys of a mapping node.\n.        @returns Keys of a mapping node."},
    {"mat", CV_PY_FN_WITH_KW_(pyopencv_cv_FileNode_mat, 0), "mat() -> retval\n."},
    {"name", CV_PY_FN_WITH_KW_(pyopencv_cv_FileNode_name, 0), "name() -> retval\n."},
    {"rawSize", CV_PY_FN_WITH_KW_(pyopencv_cv_FileNode_rawSize, 0), "rawSize() -> retval\n."},
    {"real", CV_PY_FN_WITH_KW_(pyopencv_cv_FileNode_real, 0), "real() -> retval\n.   Internal method used when reading FileStorage.\n.        Sets the type (int, real or string) and value of the previously created node."},
    {"size", CV_PY_FN_WITH_KW_(pyopencv_cv_FileNode_size, 0), "size() -> retval\n."},
    {"string", CV_PY_FN_WITH_KW_(pyopencv_cv_FileNode_string, 0), "string() -> retval\n."},
    {"type", CV_PY_FN_WITH_KW_(pyopencv_cv_FileNode_type, 0), "type() -> retval\n.   @brief Returns type of the node.\n.        @returns Type of the node. See FileNode::Type"},

    {NULL,          NULL}
};

// Converter (FileNode)

template<>
struct PyOpenCV_Converter< cv::FileNode >
{
    static PyObject* from(const cv::FileNode& r)
    {
        return pyopencv_FileNode_Instance(r);
    }
    static bool to(PyObject* src, cv::FileNode& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        cv::FileNode * dst_;
        if (pyopencv_FileNode_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected cv::FileNode for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// FileStorage (Generic)
//================================================================================

// GetSet (FileStorage)



// Methods (FileStorage)

static int pyopencv_cv_FileStorage_FileStorage(pyopencv_FileStorage_t* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    pyPrepareArgumentConversionErrorsStorage(2);

    {

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        new (&(self->v)) Ptr<cv::FileStorage>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::FileStorage()));
        return 0;
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_filename = NULL;
    String filename;
    PyObject* pyobj_flags = NULL;
    int flags=0;
    PyObject* pyobj_encoding = NULL;
    String encoding;

    const char* keywords[] = { "filename", "flags", "encoding", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO|O:FileStorage", (char**)keywords, &pyobj_filename, &pyobj_flags, &pyobj_encoding) &&
        pyopencv_to_safe(pyobj_filename, filename, ArgInfo("filename", 0)) &&
        pyopencv_to_safe(pyobj_flags, flags, ArgInfo("flags", 0)) &&
        pyopencv_to_safe(pyobj_encoding, encoding, ArgInfo("encoding", 0)) )
    {
        new (&(self->v)) Ptr<cv::FileStorage>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::FileStorage(filename, flags, encoding)));
        return 0;
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("FileStorage");

    return -1;
}

static PyObject* pyopencv_cv_FileStorage_endWriteStruct(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::FileStorage> * self1 = 0;
    if (!pyopencv_FileStorage_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FileStorage' or its derivative)");
    Ptr<cv::FileStorage> _self_ = *(self1);

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(_self_->endWriteStruct());
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileStorage_getFirstTopLevelNode(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::FileStorage> * self1 = 0;
    if (!pyopencv_FileStorage_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FileStorage' or its derivative)");
    Ptr<cv::FileStorage> _self_ = *(self1);
    FileNode retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getFirstTopLevelNode());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileStorage_getFormat(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::FileStorage> * self1 = 0;
    if (!pyopencv_FileStorage_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FileStorage' or its derivative)");
    Ptr<cv::FileStorage> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getFormat());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileStorage_getNode(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::FileStorage> * self1 = 0;
    if (!pyopencv_FileStorage_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FileStorage' or its derivative)");
    Ptr<cv::FileStorage> _self_ = *(self1);
    char* nodename=(char*)"";
    FileNode retval;

    const char* keywords[] = { "nodename", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "s:FileStorage.getNode", (char**)keywords, &nodename) )
    {
        ERRWRAP2(retval = _self_->operator[](nodename));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileStorage_isOpened(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::FileStorage> * self1 = 0;
    if (!pyopencv_FileStorage_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FileStorage' or its derivative)");
    Ptr<cv::FileStorage> _self_ = *(self1);
    bool retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->isOpened());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileStorage_open(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::FileStorage> * self1 = 0;
    if (!pyopencv_FileStorage_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FileStorage' or its derivative)");
    Ptr<cv::FileStorage> _self_ = *(self1);
    PyObject* pyobj_filename = NULL;
    String filename;
    PyObject* pyobj_flags = NULL;
    int flags=0;
    PyObject* pyobj_encoding = NULL;
    String encoding;
    bool retval;

    const char* keywords[] = { "filename", "flags", "encoding", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO|O:FileStorage.open", (char**)keywords, &pyobj_filename, &pyobj_flags, &pyobj_encoding) &&
        pyopencv_to_safe(pyobj_filename, filename, ArgInfo("filename", 0)) &&
        pyopencv_to_safe(pyobj_flags, flags, ArgInfo("flags", 0)) &&
        pyopencv_to_safe(pyobj_encoding, encoding, ArgInfo("encoding", 0)) )
    {
        ERRWRAP2(retval = _self_->open(filename, flags, encoding));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileStorage_release(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::FileStorage> * self1 = 0;
    if (!pyopencv_FileStorage_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FileStorage' or its derivative)");
    Ptr<cv::FileStorage> _self_ = *(self1);

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(_self_->release());
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileStorage_releaseAndGetString(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::FileStorage> * self1 = 0;
    if (!pyopencv_FileStorage_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FileStorage' or its derivative)");
    Ptr<cv::FileStorage> _self_ = *(self1);
    String retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->releaseAndGetString());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileStorage_root(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::FileStorage> * self1 = 0;
    if (!pyopencv_FileStorage_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FileStorage' or its derivative)");
    Ptr<cv::FileStorage> _self_ = *(self1);
    PyObject* pyobj_streamidx = NULL;
    int streamidx=0;
    FileNode retval;

    const char* keywords[] = { "streamidx", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "|O:FileStorage.root", (char**)keywords, &pyobj_streamidx) &&
        pyopencv_to_safe(pyobj_streamidx, streamidx, ArgInfo("streamidx", 0)) )
    {
        ERRWRAP2(retval = _self_->root(streamidx));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileStorage_startWriteStruct(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::FileStorage> * self1 = 0;
    if (!pyopencv_FileStorage_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FileStorage' or its derivative)");
    Ptr<cv::FileStorage> _self_ = *(self1);
    PyObject* pyobj_name = NULL;
    String name;
    PyObject* pyobj_flags = NULL;
    int flags=0;
    PyObject* pyobj_typeName = NULL;
    String typeName;

    const char* keywords[] = { "name", "flags", "typeName", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO|O:FileStorage.startWriteStruct", (char**)keywords, &pyobj_name, &pyobj_flags, &pyobj_typeName) &&
        pyopencv_to_safe(pyobj_name, name, ArgInfo("name", 0)) &&
        pyopencv_to_safe(pyobj_flags, flags, ArgInfo("flags", 0)) &&
        pyopencv_to_safe(pyobj_typeName, typeName, ArgInfo("typeName", 0)) )
    {
        ERRWRAP2(_self_->startWriteStruct(name, flags, typeName));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_FileStorage_write(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::FileStorage> * self1 = 0;
    if (!pyopencv_FileStorage_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FileStorage' or its derivative)");
    Ptr<cv::FileStorage> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(5);

    {
    PyObject* pyobj_name = NULL;
    String name;
    PyObject* pyobj_val = NULL;
    int val=0;

    const char* keywords[] = { "name", "val", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO:FileStorage.write", (char**)keywords, &pyobj_name, &pyobj_val) &&
        pyopencv_to_safe(pyobj_name, name, ArgInfo("name", 0)) &&
        pyopencv_to_safe(pyobj_val, val, ArgInfo("val", 0)) )
    {
        ERRWRAP2(_self_->write(name, val));
        Py_RETURN_NONE;
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_name = NULL;
    String name;
    PyObject* pyobj_val = NULL;
    double val=0;

    const char* keywords[] = { "name", "val", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO:FileStorage.write", (char**)keywords, &pyobj_name, &pyobj_val) &&
        pyopencv_to_safe(pyobj_name, name, ArgInfo("name", 0)) &&
        pyopencv_to_safe(pyobj_val, val, ArgInfo("val", 0)) )
    {
        ERRWRAP2(_self_->write(name, val));
        Py_RETURN_NONE;
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_name = NULL;
    String name;
    PyObject* pyobj_val = NULL;
    String val;

    const char* keywords[] = { "name", "val", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO:FileStorage.write", (char**)keywords, &pyobj_name, &pyobj_val) &&
        pyopencv_to_safe(pyobj_name, name, ArgInfo("name", 0)) &&
        pyopencv_to_safe(pyobj_val, val, ArgInfo("val", 0)) )
    {
        ERRWRAP2(_self_->write(name, val));
        Py_RETURN_NONE;
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_name = NULL;
    String name;
    PyObject* pyobj_val = NULL;
    Mat val;

    const char* keywords[] = { "name", "val", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO:FileStorage.write", (char**)keywords, &pyobj_name, &pyobj_val) &&
        pyopencv_to_safe(pyobj_name, name, ArgInfo("name", 0)) &&
        pyopencv_to_safe(pyobj_val, val, ArgInfo("val", 0)) )
    {
        ERRWRAP2(_self_->write(name, val));
        Py_RETURN_NONE;
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_name = NULL;
    String name;
    PyObject* pyobj_val = NULL;
    vector_String val;

    const char* keywords[] = { "name", "val", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO:FileStorage.write", (char**)keywords, &pyobj_name, &pyobj_val) &&
        pyopencv_to_safe(pyobj_name, name, ArgInfo("name", 0)) &&
        pyopencv_to_safe(pyobj_val, val, ArgInfo("val", 0)) )
    {
        ERRWRAP2(_self_->write(name, val));
        Py_RETURN_NONE;
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("write");

    return NULL;
}

static PyObject* pyopencv_cv_FileStorage_writeComment(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::FileStorage> * self1 = 0;
    if (!pyopencv_FileStorage_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'FileStorage' or its derivative)");
    Ptr<cv::FileStorage> _self_ = *(self1);
    PyObject* pyobj_comment = NULL;
    String comment;
    PyObject* pyobj_append = NULL;
    bool append=false;

    const char* keywords[] = { "comment", "append", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|O:FileStorage.writeComment", (char**)keywords, &pyobj_comment, &pyobj_append) &&
        pyopencv_to_safe(pyobj_comment, comment, ArgInfo("comment", 0)) &&
        pyopencv_to_safe(pyobj_append, append, ArgInfo("append", 0)) )
    {
        ERRWRAP2(_self_->writeComment(comment, append));
        Py_RETURN_NONE;
    }

    return NULL;
}



// Tables (FileStorage)

static PyGetSetDef pyopencv_FileStorage_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_FileStorage_methods[] =
{
    {"endWriteStruct", CV_PY_FN_WITH_KW_(pyopencv_cv_FileStorage_endWriteStruct, 0), "endWriteStruct() -> None\n.   @brief Finishes writing nested structure (should pair startWriteStruct())"},
    {"getFirstTopLevelNode", CV_PY_FN_WITH_KW_(pyopencv_cv_FileStorage_getFirstTopLevelNode, 0), "getFirstTopLevelNode() -> retval\n.   @brief Returns the first element of the top-level mapping.\n.        @returns The first element of the top-level mapping."},
    {"getFormat", CV_PY_FN_WITH_KW_(pyopencv_cv_FileStorage_getFormat, 0), "getFormat() -> retval\n.   @brief Returns the current format.\n.        * @returns The current format, see FileStorage::Mode"},
    {"getNode", CV_PY_FN_WITH_KW_(pyopencv_cv_FileStorage_getNode, 0), "getNode(nodename) -> retval\n.   @overload"},
    {"isOpened", CV_PY_FN_WITH_KW_(pyopencv_cv_FileStorage_isOpened, 0), "isOpened() -> retval\n.   @brief Checks whether the file is opened.\n.   \n.        @returns true if the object is associated with the current file and false otherwise. It is a\n.        good practice to call this method after you tried to open a file."},
    {"open", CV_PY_FN_WITH_KW_(pyopencv_cv_FileStorage_open, 0), "open(filename, flags[, encoding]) -> retval\n.   @brief Opens a file.\n.   \n.        See description of parameters in FileStorage::FileStorage. The method calls FileStorage::release\n.        before opening the file.\n.        @param filename Name of the file to open or the text string to read the data from.\n.        Extension of the file (.xml, .yml/.yaml or .json) determines its format (XML, YAML or JSON\n.        respectively). Also you can append .gz to work with compressed files, for example myHugeMatrix.xml.gz. If both\n.        FileStorage::WRITE and FileStorage::MEMORY flags are specified, source is used just to specify\n.        the output file format (e.g. mydata.xml, .yml etc.). A file name can also contain parameters.\n.        You can use this format, \"*?base64\" (e.g. \"file.json?base64\" (case sensitive)), as an alternative to\n.        FileStorage::BASE64 flag.\n.        @param flags Mode of operation. One of FileStorage::Mode\n.        @param encoding Encoding of the file. Note that UTF-16 XML encoding is not supported currently and\n.        you should use 8-bit encoding instead of it."},
    {"release", CV_PY_FN_WITH_KW_(pyopencv_cv_FileStorage_release, 0), "release() -> None\n.   @brief Closes the file and releases all the memory buffers.\n.   \n.        Call this method after all I/O operations with the storage are finished."},
    {"releaseAndGetString", CV_PY_FN_WITH_KW_(pyopencv_cv_FileStorage_releaseAndGetString, 0), "releaseAndGetString() -> retval\n.   @brief Closes the file and releases all the memory buffers.\n.   \n.        Call this method after all I/O operations with the storage are finished. If the storage was\n.        opened for writing data and FileStorage::WRITE was specified"},
    {"root", CV_PY_FN_WITH_KW_(pyopencv_cv_FileStorage_root, 0), "root([, streamidx]) -> retval\n.   @brief Returns the top-level mapping\n.        @param streamidx Zero-based index of the stream. In most cases there is only one stream in the file.\n.        However, YAML supports multiple streams and so there can be several.\n.        @returns The top-level mapping."},
    {"startWriteStruct", CV_PY_FN_WITH_KW_(pyopencv_cv_FileStorage_startWriteStruct, 0), "startWriteStruct(name, flags[, typeName]) -> None\n.   @brief Starts to write a nested structure (sequence or a mapping).\n.       @param name name of the structure. When writing to sequences (a.k.a. \"arrays\"), pass an empty string.\n.       @param flags type of the structure (FileNode::MAP or FileNode::SEQ (both with optional FileNode::FLOW)).\n.       @param typeName optional name of the type you store. The effect of setting this depends on the storage format.\n.       I.e. if the format has a specification for storing type information, this parameter is used."},
    {"write", CV_PY_FN_WITH_KW_(pyopencv_cv_FileStorage_write, 0), "write(name, val) -> None\n.   * @brief Simplified writing API to use with bindings.\n.        * @param name Name of the written object. When writing to sequences (a.k.a. \"arrays\"), pass an empty string.\n.        * @param val Value of the written object."},
    {"writeComment", CV_PY_FN_WITH_KW_(pyopencv_cv_FileStorage_writeComment, 0), "writeComment(comment[, append]) -> None\n.   @brief Writes a comment.\n.   \n.        The function writes a comment into file storage. The comments are skipped when the storage is read.\n.        @param comment The written comment, single-line or multi-line\n.        @param append If true, the function tries to put the comment at the end of current line.\n.        Else if the comment is multi-line, or if it does not fit at the end of the current\n.        line, the comment starts a new line."},

    {NULL,          NULL}
};

// Converter (FileStorage)

template<>
struct PyOpenCV_Converter< Ptr<cv::FileStorage> >
{
    static PyObject* from(const Ptr<cv::FileStorage>& r)
    {
        return pyopencv_FileStorage_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::FileStorage>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::FileStorage> * dst_;
        if (pyopencv_FileStorage_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::FileStorage> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// FlannBasedMatcher (Generic)
//================================================================================

// GetSet (FlannBasedMatcher)



// Methods (FlannBasedMatcher)

static int pyopencv_cv_FlannBasedMatcher_FlannBasedMatcher(pyopencv_FlannBasedMatcher_t* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    PyObject* pyobj_indexParams = NULL;
    Ptr<flann::IndexParams> indexParams=makePtr<flann::KDTreeIndexParams>();
    PyObject* pyobj_searchParams = NULL;
    Ptr<flann::SearchParams> searchParams=makePtr<flann::SearchParams>();

    const char* keywords[] = { "indexParams", "searchParams", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "|OO:FlannBasedMatcher", (char**)keywords, &pyobj_indexParams, &pyobj_searchParams) &&
        pyopencv_to_safe(pyobj_indexParams, indexParams, ArgInfo("indexParams", 0)) &&
        pyopencv_to_safe(pyobj_searchParams, searchParams, ArgInfo("searchParams", 0)) )
    {
        new (&(self->v)) Ptr<cv::FlannBasedMatcher>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::FlannBasedMatcher(indexParams, searchParams)));
        return 0;
    }

    return -1;
}

static PyObject* pyopencv_cv_FlannBasedMatcher_create_static(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    Ptr<FlannBasedMatcher> retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = cv::FlannBasedMatcher::create());
        return pyopencv_from(retval);
    }

    return NULL;
}



// Tables (FlannBasedMatcher)

static PyGetSetDef pyopencv_FlannBasedMatcher_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_FlannBasedMatcher_methods[] =
{
    {"create", CV_PY_FN_WITH_KW_(pyopencv_cv_FlannBasedMatcher_create_static, METH_STATIC), "create() -> retval\n."},

    {NULL,          NULL}
};

// Converter (FlannBasedMatcher)

template<>
struct PyOpenCV_Converter< Ptr<cv::FlannBasedMatcher> >
{
    static PyObject* from(const Ptr<cv::FlannBasedMatcher>& r)
    {
        return pyopencv_FlannBasedMatcher_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::FlannBasedMatcher>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::FlannBasedMatcher> * dst_;
        if (pyopencv_FlannBasedMatcher_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::FlannBasedMatcher> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// GFTTDetector (Generic)
//================================================================================

// GetSet (GFTTDetector)



// Methods (GFTTDetector)

static PyObject* pyopencv_cv_GFTTDetector_create_static(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_maxCorners = NULL;
    int maxCorners=1000;
    PyObject* pyobj_qualityLevel = NULL;
    double qualityLevel=0.01;
    PyObject* pyobj_minDistance = NULL;
    double minDistance=1;
    PyObject* pyobj_blockSize = NULL;
    int blockSize=3;
    PyObject* pyobj_useHarrisDetector = NULL;
    bool useHarrisDetector=false;
    PyObject* pyobj_k = NULL;
    double k=0.04;
    Ptr<GFTTDetector> retval;

    const char* keywords[] = { "maxCorners", "qualityLevel", "minDistance", "blockSize", "useHarrisDetector", "k", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "|OOOOOO:GFTTDetector.create", (char**)keywords, &pyobj_maxCorners, &pyobj_qualityLevel, &pyobj_minDistance, &pyobj_blockSize, &pyobj_useHarrisDetector, &pyobj_k) &&
        pyopencv_to_safe(pyobj_maxCorners, maxCorners, ArgInfo("maxCorners", 0)) &&
        pyopencv_to_safe(pyobj_qualityLevel, qualityLevel, ArgInfo("qualityLevel", 0)) &&
        pyopencv_to_safe(pyobj_minDistance, minDistance, ArgInfo("minDistance", 0)) &&
        pyopencv_to_safe(pyobj_blockSize, blockSize, ArgInfo("blockSize", 0)) &&
        pyopencv_to_safe(pyobj_useHarrisDetector, useHarrisDetector, ArgInfo("useHarrisDetector", 0)) &&
        pyopencv_to_safe(pyobj_k, k, ArgInfo("k", 0)) )
    {
        ERRWRAP2(retval = cv::GFTTDetector::create(maxCorners, qualityLevel, minDistance, blockSize, useHarrisDetector, k));
        return pyopencv_from(retval);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_maxCorners = NULL;
    int maxCorners=0;
    PyObject* pyobj_qualityLevel = NULL;
    double qualityLevel=0;
    PyObject* pyobj_minDistance = NULL;
    double minDistance=0;
    PyObject* pyobj_blockSize = NULL;
    int blockSize=0;
    PyObject* pyobj_gradiantSize = NULL;
    int gradiantSize=0;
    PyObject* pyobj_useHarrisDetector = NULL;
    bool useHarrisDetector=false;
    PyObject* pyobj_k = NULL;
    double k=0.04;
    Ptr<GFTTDetector> retval;

    const char* keywords[] = { "maxCorners", "qualityLevel", "minDistance", "blockSize", "gradiantSize", "useHarrisDetector", "k", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOOOO|OO:GFTTDetector.create", (char**)keywords, &pyobj_maxCorners, &pyobj_qualityLevel, &pyobj_minDistance, &pyobj_blockSize, &pyobj_gradiantSize, &pyobj_useHarrisDetector, &pyobj_k) &&
        pyopencv_to_safe(pyobj_maxCorners, maxCorners, ArgInfo("maxCorners", 0)) &&
        pyopencv_to_safe(pyobj_qualityLevel, qualityLevel, ArgInfo("qualityLevel", 0)) &&
        pyopencv_to_safe(pyobj_minDistance, minDistance, ArgInfo("minDistance", 0)) &&
        pyopencv_to_safe(pyobj_blockSize, blockSize, ArgInfo("blockSize", 0)) &&
        pyopencv_to_safe(pyobj_gradiantSize, gradiantSize, ArgInfo("gradiantSize", 0)) &&
        pyopencv_to_safe(pyobj_useHarrisDetector, useHarrisDetector, ArgInfo("useHarrisDetector", 0)) &&
        pyopencv_to_safe(pyobj_k, k, ArgInfo("k", 0)) )
    {
        ERRWRAP2(retval = cv::GFTTDetector::create(maxCorners, qualityLevel, minDistance, blockSize, gradiantSize, useHarrisDetector, k));
        return pyopencv_from(retval);
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("create");

    return NULL;
}

static PyObject* pyopencv_cv_GFTTDetector_getBlockSize(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GFTTDetector> * self1 = 0;
    if (!pyopencv_GFTTDetector_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GFTTDetector' or its derivative)");
    Ptr<cv::GFTTDetector> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getBlockSize());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_GFTTDetector_getDefaultName(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GFTTDetector> * self1 = 0;
    if (!pyopencv_GFTTDetector_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GFTTDetector' or its derivative)");
    Ptr<cv::GFTTDetector> _self_ = *(self1);
    String retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getDefaultName());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_GFTTDetector_getGradientSize(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GFTTDetector> * self1 = 0;
    if (!pyopencv_GFTTDetector_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GFTTDetector' or its derivative)");
    Ptr<cv::GFTTDetector> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getGradientSize());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_GFTTDetector_getHarrisDetector(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GFTTDetector> * self1 = 0;
    if (!pyopencv_GFTTDetector_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GFTTDetector' or its derivative)");
    Ptr<cv::GFTTDetector> _self_ = *(self1);
    bool retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getHarrisDetector());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_GFTTDetector_getK(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GFTTDetector> * self1 = 0;
    if (!pyopencv_GFTTDetector_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GFTTDetector' or its derivative)");
    Ptr<cv::GFTTDetector> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getK());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_GFTTDetector_getMaxFeatures(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GFTTDetector> * self1 = 0;
    if (!pyopencv_GFTTDetector_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GFTTDetector' or its derivative)");
    Ptr<cv::GFTTDetector> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getMaxFeatures());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_GFTTDetector_getMinDistance(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GFTTDetector> * self1 = 0;
    if (!pyopencv_GFTTDetector_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GFTTDetector' or its derivative)");
    Ptr<cv::GFTTDetector> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getMinDistance());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_GFTTDetector_getQualityLevel(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GFTTDetector> * self1 = 0;
    if (!pyopencv_GFTTDetector_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GFTTDetector' or its derivative)");
    Ptr<cv::GFTTDetector> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getQualityLevel());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_GFTTDetector_setBlockSize(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GFTTDetector> * self1 = 0;
    if (!pyopencv_GFTTDetector_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GFTTDetector' or its derivative)");
    Ptr<cv::GFTTDetector> _self_ = *(self1);
    PyObject* pyobj_blockSize = NULL;
    int blockSize=0;

    const char* keywords[] = { "blockSize", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:GFTTDetector.setBlockSize", (char**)keywords, &pyobj_blockSize) &&
        pyopencv_to_safe(pyobj_blockSize, blockSize, ArgInfo("blockSize", 0)) )
    {
        ERRWRAP2(_self_->setBlockSize(blockSize));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_GFTTDetector_setGradientSize(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GFTTDetector> * self1 = 0;
    if (!pyopencv_GFTTDetector_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GFTTDetector' or its derivative)");
    Ptr<cv::GFTTDetector> _self_ = *(self1);
    PyObject* pyobj_gradientSize_ = NULL;
    int gradientSize_=0;

    const char* keywords[] = { "gradientSize_", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:GFTTDetector.setGradientSize", (char**)keywords, &pyobj_gradientSize_) &&
        pyopencv_to_safe(pyobj_gradientSize_, gradientSize_, ArgInfo("gradientSize_", 0)) )
    {
        ERRWRAP2(_self_->setGradientSize(gradientSize_));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_GFTTDetector_setHarrisDetector(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GFTTDetector> * self1 = 0;
    if (!pyopencv_GFTTDetector_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GFTTDetector' or its derivative)");
    Ptr<cv::GFTTDetector> _self_ = *(self1);
    PyObject* pyobj_val = NULL;
    bool val=0;

    const char* keywords[] = { "val", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:GFTTDetector.setHarrisDetector", (char**)keywords, &pyobj_val) &&
        pyopencv_to_safe(pyobj_val, val, ArgInfo("val", 0)) )
    {
        ERRWRAP2(_self_->setHarrisDetector(val));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_GFTTDetector_setK(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GFTTDetector> * self1 = 0;
    if (!pyopencv_GFTTDetector_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GFTTDetector' or its derivative)");
    Ptr<cv::GFTTDetector> _self_ = *(self1);
    PyObject* pyobj_k = NULL;
    double k=0;

    const char* keywords[] = { "k", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:GFTTDetector.setK", (char**)keywords, &pyobj_k) &&
        pyopencv_to_safe(pyobj_k, k, ArgInfo("k", 0)) )
    {
        ERRWRAP2(_self_->setK(k));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_GFTTDetector_setMaxFeatures(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GFTTDetector> * self1 = 0;
    if (!pyopencv_GFTTDetector_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GFTTDetector' or its derivative)");
    Ptr<cv::GFTTDetector> _self_ = *(self1);
    PyObject* pyobj_maxFeatures = NULL;
    int maxFeatures=0;

    const char* keywords[] = { "maxFeatures", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:GFTTDetector.setMaxFeatures", (char**)keywords, &pyobj_maxFeatures) &&
        pyopencv_to_safe(pyobj_maxFeatures, maxFeatures, ArgInfo("maxFeatures", 0)) )
    {
        ERRWRAP2(_self_->setMaxFeatures(maxFeatures));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_GFTTDetector_setMinDistance(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GFTTDetector> * self1 = 0;
    if (!pyopencv_GFTTDetector_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GFTTDetector' or its derivative)");
    Ptr<cv::GFTTDetector> _self_ = *(self1);
    PyObject* pyobj_minDistance = NULL;
    double minDistance=0;

    const char* keywords[] = { "minDistance", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:GFTTDetector.setMinDistance", (char**)keywords, &pyobj_minDistance) &&
        pyopencv_to_safe(pyobj_minDistance, minDistance, ArgInfo("minDistance", 0)) )
    {
        ERRWRAP2(_self_->setMinDistance(minDistance));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_GFTTDetector_setQualityLevel(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GFTTDetector> * self1 = 0;
    if (!pyopencv_GFTTDetector_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GFTTDetector' or its derivative)");
    Ptr<cv::GFTTDetector> _self_ = *(self1);
    PyObject* pyobj_qlevel = NULL;
    double qlevel=0;

    const char* keywords[] = { "qlevel", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:GFTTDetector.setQualityLevel", (char**)keywords, &pyobj_qlevel) &&
        pyopencv_to_safe(pyobj_qlevel, qlevel, ArgInfo("qlevel", 0)) )
    {
        ERRWRAP2(_self_->setQualityLevel(qlevel));
        Py_RETURN_NONE;
    }

    return NULL;
}



// Tables (GFTTDetector)

static PyGetSetDef pyopencv_GFTTDetector_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_GFTTDetector_methods[] =
{
    {"create", CV_PY_FN_WITH_KW_(pyopencv_cv_GFTTDetector_create_static, METH_STATIC), "create([, maxCorners[, qualityLevel[, minDistance[, blockSize[, useHarrisDetector[, k]]]]]]) -> retval\n.   \n\n\n\ncreate(maxCorners, qualityLevel, minDistance, blockSize, gradiantSize[, useHarrisDetector[, k]]) -> retval\n."},
    {"getBlockSize", CV_PY_FN_WITH_KW_(pyopencv_cv_GFTTDetector_getBlockSize, 0), "getBlockSize() -> retval\n."},
    {"getDefaultName", CV_PY_FN_WITH_KW_(pyopencv_cv_GFTTDetector_getDefaultName, 0), "getDefaultName() -> retval\n."},
    {"getGradientSize", CV_PY_FN_WITH_KW_(pyopencv_cv_GFTTDetector_getGradientSize, 0), "getGradientSize() -> retval\n."},
    {"getHarrisDetector", CV_PY_FN_WITH_KW_(pyopencv_cv_GFTTDetector_getHarrisDetector, 0), "getHarrisDetector() -> retval\n."},
    {"getK", CV_PY_FN_WITH_KW_(pyopencv_cv_GFTTDetector_getK, 0), "getK() -> retval\n."},
    {"getMaxFeatures", CV_PY_FN_WITH_KW_(pyopencv_cv_GFTTDetector_getMaxFeatures, 0), "getMaxFeatures() -> retval\n."},
    {"getMinDistance", CV_PY_FN_WITH_KW_(pyopencv_cv_GFTTDetector_getMinDistance, 0), "getMinDistance() -> retval\n."},
    {"getQualityLevel", CV_PY_FN_WITH_KW_(pyopencv_cv_GFTTDetector_getQualityLevel, 0), "getQualityLevel() -> retval\n."},
    {"setBlockSize", CV_PY_FN_WITH_KW_(pyopencv_cv_GFTTDetector_setBlockSize, 0), "setBlockSize(blockSize) -> None\n."},
    {"setGradientSize", CV_PY_FN_WITH_KW_(pyopencv_cv_GFTTDetector_setGradientSize, 0), "setGradientSize(gradientSize_) -> None\n."},
    {"setHarrisDetector", CV_PY_FN_WITH_KW_(pyopencv_cv_GFTTDetector_setHarrisDetector, 0), "setHarrisDetector(val) -> None\n."},
    {"setK", CV_PY_FN_WITH_KW_(pyopencv_cv_GFTTDetector_setK, 0), "setK(k) -> None\n."},
    {"setMaxFeatures", CV_PY_FN_WITH_KW_(pyopencv_cv_GFTTDetector_setMaxFeatures, 0), "setMaxFeatures(maxFeatures) -> None\n."},
    {"setMinDistance", CV_PY_FN_WITH_KW_(pyopencv_cv_GFTTDetector_setMinDistance, 0), "setMinDistance(minDistance) -> None\n."},
    {"setQualityLevel", CV_PY_FN_WITH_KW_(pyopencv_cv_GFTTDetector_setQualityLevel, 0), "setQualityLevel(qlevel) -> None\n."},

    {NULL,          NULL}
};

// Converter (GFTTDetector)

template<>
struct PyOpenCV_Converter< Ptr<cv::GFTTDetector> >
{
    static PyObject* from(const Ptr<cv::GFTTDetector>& r)
    {
        return pyopencv_GFTTDetector_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::GFTTDetector>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::GFTTDetector> * dst_;
        if (pyopencv_GFTTDetector_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::GFTTDetector> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// GeneralizedHough (Generic)
//================================================================================

// GetSet (GeneralizedHough)



// Methods (GeneralizedHough)

static PyObject* pyopencv_cv_GeneralizedHough_detect(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GeneralizedHough> * self1 = 0;
    if (!pyopencv_GeneralizedHough_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GeneralizedHough' or its derivative)");
    Ptr<cv::GeneralizedHough> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(4);

    {
    PyObject* pyobj_image = NULL;
    Mat image;
    PyObject* pyobj_positions = NULL;
    Mat positions;
    PyObject* pyobj_votes = NULL;
    Mat votes;

    const char* keywords[] = { "image", "positions", "votes", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|OO:GeneralizedHough.detect", (char**)keywords, &pyobj_image, &pyobj_positions, &pyobj_votes) &&
        pyopencv_to_safe(pyobj_image, image, ArgInfo("image", 0)) &&
        pyopencv_to_safe(pyobj_positions, positions, ArgInfo("positions", 1)) &&
        pyopencv_to_safe(pyobj_votes, votes, ArgInfo("votes", 1)) )
    {
        ERRWRAP2(_self_->detect(image, positions, votes));
        return Py_BuildValue("(NN)", pyopencv_from(positions), pyopencv_from(votes));
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_image = NULL;
    UMat image;
    PyObject* pyobj_positions = NULL;
    UMat positions;
    PyObject* pyobj_votes = NULL;
    UMat votes;

    const char* keywords[] = { "image", "positions", "votes", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|OO:GeneralizedHough.detect", (char**)keywords, &pyobj_image, &pyobj_positions, &pyobj_votes) &&
        pyopencv_to_safe(pyobj_image, image, ArgInfo("image", 0)) &&
        pyopencv_to_safe(pyobj_positions, positions, ArgInfo("positions", 1)) &&
        pyopencv_to_safe(pyobj_votes, votes, ArgInfo("votes", 1)) )
    {
        ERRWRAP2(_self_->detect(image, positions, votes));
        return Py_BuildValue("(NN)", pyopencv_from(positions), pyopencv_from(votes));
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_edges = NULL;
    Mat edges;
    PyObject* pyobj_dx = NULL;
    Mat dx;
    PyObject* pyobj_dy = NULL;
    Mat dy;
    PyObject* pyobj_positions = NULL;
    Mat positions;
    PyObject* pyobj_votes = NULL;
    Mat votes;

    const char* keywords[] = { "edges", "dx", "dy", "positions", "votes", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOO|OO:GeneralizedHough.detect", (char**)keywords, &pyobj_edges, &pyobj_dx, &pyobj_dy, &pyobj_positions, &pyobj_votes) &&
        pyopencv_to_safe(pyobj_edges, edges, ArgInfo("edges", 0)) &&
        pyopencv_to_safe(pyobj_dx, dx, ArgInfo("dx", 0)) &&
        pyopencv_to_safe(pyobj_dy, dy, ArgInfo("dy", 0)) &&
        pyopencv_to_safe(pyobj_positions, positions, ArgInfo("positions", 1)) &&
        pyopencv_to_safe(pyobj_votes, votes, ArgInfo("votes", 1)) )
    {
        ERRWRAP2(_self_->detect(edges, dx, dy, positions, votes));
        return Py_BuildValue("(NN)", pyopencv_from(positions), pyopencv_from(votes));
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_edges = NULL;
    UMat edges;
    PyObject* pyobj_dx = NULL;
    UMat dx;
    PyObject* pyobj_dy = NULL;
    UMat dy;
    PyObject* pyobj_positions = NULL;
    UMat positions;
    PyObject* pyobj_votes = NULL;
    UMat votes;

    const char* keywords[] = { "edges", "dx", "dy", "positions", "votes", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOO|OO:GeneralizedHough.detect", (char**)keywords, &pyobj_edges, &pyobj_dx, &pyobj_dy, &pyobj_positions, &pyobj_votes) &&
        pyopencv_to_safe(pyobj_edges, edges, ArgInfo("edges", 0)) &&
        pyopencv_to_safe(pyobj_dx, dx, ArgInfo("dx", 0)) &&
        pyopencv_to_safe(pyobj_dy, dy, ArgInfo("dy", 0)) &&
        pyopencv_to_safe(pyobj_positions, positions, ArgInfo("positions", 1)) &&
        pyopencv_to_safe(pyobj_votes, votes, ArgInfo("votes", 1)) )
    {
        ERRWRAP2(_self_->detect(edges, dx, dy, positions, votes));
        return Py_BuildValue("(NN)", pyopencv_from(positions), pyopencv_from(votes));
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("detect");

    return NULL;
}

static PyObject* pyopencv_cv_GeneralizedHough_getCannyHighThresh(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GeneralizedHough> * self1 = 0;
    if (!pyopencv_GeneralizedHough_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GeneralizedHough' or its derivative)");
    Ptr<cv::GeneralizedHough> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getCannyHighThresh());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_GeneralizedHough_getCannyLowThresh(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GeneralizedHough> * self1 = 0;
    if (!pyopencv_GeneralizedHough_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GeneralizedHough' or its derivative)");
    Ptr<cv::GeneralizedHough> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getCannyLowThresh());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_GeneralizedHough_getDp(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GeneralizedHough> * self1 = 0;
    if (!pyopencv_GeneralizedHough_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GeneralizedHough' or its derivative)");
    Ptr<cv::GeneralizedHough> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getDp());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_GeneralizedHough_getMaxBufferSize(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GeneralizedHough> * self1 = 0;
    if (!pyopencv_GeneralizedHough_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GeneralizedHough' or its derivative)");
    Ptr<cv::GeneralizedHough> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getMaxBufferSize());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_GeneralizedHough_getMinDist(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GeneralizedHough> * self1 = 0;
    if (!pyopencv_GeneralizedHough_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GeneralizedHough' or its derivative)");
    Ptr<cv::GeneralizedHough> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getMinDist());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_GeneralizedHough_setCannyHighThresh(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GeneralizedHough> * self1 = 0;
    if (!pyopencv_GeneralizedHough_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GeneralizedHough' or its derivative)");
    Ptr<cv::GeneralizedHough> _self_ = *(self1);
    PyObject* pyobj_cannyHighThresh = NULL;
    int cannyHighThresh=0;

    const char* keywords[] = { "cannyHighThresh", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:GeneralizedHough.setCannyHighThresh", (char**)keywords, &pyobj_cannyHighThresh) &&
        pyopencv_to_safe(pyobj_cannyHighThresh, cannyHighThresh, ArgInfo("cannyHighThresh", 0)) )
    {
        ERRWRAP2(_self_->setCannyHighThresh(cannyHighThresh));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_GeneralizedHough_setCannyLowThresh(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GeneralizedHough> * self1 = 0;
    if (!pyopencv_GeneralizedHough_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GeneralizedHough' or its derivative)");
    Ptr<cv::GeneralizedHough> _self_ = *(self1);
    PyObject* pyobj_cannyLowThresh = NULL;
    int cannyLowThresh=0;

    const char* keywords[] = { "cannyLowThresh", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:GeneralizedHough.setCannyLowThresh", (char**)keywords, &pyobj_cannyLowThresh) &&
        pyopencv_to_safe(pyobj_cannyLowThresh, cannyLowThresh, ArgInfo("cannyLowThresh", 0)) )
    {
        ERRWRAP2(_self_->setCannyLowThresh(cannyLowThresh));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_GeneralizedHough_setDp(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GeneralizedHough> * self1 = 0;
    if (!pyopencv_GeneralizedHough_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GeneralizedHough' or its derivative)");
    Ptr<cv::GeneralizedHough> _self_ = *(self1);
    PyObject* pyobj_dp = NULL;
    double dp=0;

    const char* keywords[] = { "dp", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:GeneralizedHough.setDp", (char**)keywords, &pyobj_dp) &&
        pyopencv_to_safe(pyobj_dp, dp, ArgInfo("dp", 0)) )
    {
        ERRWRAP2(_self_->setDp(dp));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_GeneralizedHough_setMaxBufferSize(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GeneralizedHough> * self1 = 0;
    if (!pyopencv_GeneralizedHough_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GeneralizedHough' or its derivative)");
    Ptr<cv::GeneralizedHough> _self_ = *(self1);
    PyObject* pyobj_maxBufferSize = NULL;
    int maxBufferSize=0;

    const char* keywords[] = { "maxBufferSize", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:GeneralizedHough.setMaxBufferSize", (char**)keywords, &pyobj_maxBufferSize) &&
        pyopencv_to_safe(pyobj_maxBufferSize, maxBufferSize, ArgInfo("maxBufferSize", 0)) )
    {
        ERRWRAP2(_self_->setMaxBufferSize(maxBufferSize));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_GeneralizedHough_setMinDist(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GeneralizedHough> * self1 = 0;
    if (!pyopencv_GeneralizedHough_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GeneralizedHough' or its derivative)");
    Ptr<cv::GeneralizedHough> _self_ = *(self1);
    PyObject* pyobj_minDist = NULL;
    double minDist=0;

    const char* keywords[] = { "minDist", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:GeneralizedHough.setMinDist", (char**)keywords, &pyobj_minDist) &&
        pyopencv_to_safe(pyobj_minDist, minDist, ArgInfo("minDist", 0)) )
    {
        ERRWRAP2(_self_->setMinDist(minDist));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_GeneralizedHough_setTemplate(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GeneralizedHough> * self1 = 0;
    if (!pyopencv_GeneralizedHough_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GeneralizedHough' or its derivative)");
    Ptr<cv::GeneralizedHough> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(4);

    {
    PyObject* pyobj_templ = NULL;
    Mat templ;
    PyObject* pyobj_templCenter = NULL;
    Point templCenter=Point(-1, -1);

    const char* keywords[] = { "templ", "templCenter", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|O:GeneralizedHough.setTemplate", (char**)keywords, &pyobj_templ, &pyobj_templCenter) &&
        pyopencv_to_safe(pyobj_templ, templ, ArgInfo("templ", 0)) &&
        pyopencv_to_safe(pyobj_templCenter, templCenter, ArgInfo("templCenter", 0)) )
    {
        ERRWRAP2(_self_->setTemplate(templ, templCenter));
        Py_RETURN_NONE;
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_templ = NULL;
    UMat templ;
    PyObject* pyobj_templCenter = NULL;
    Point templCenter=Point(-1, -1);

    const char* keywords[] = { "templ", "templCenter", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|O:GeneralizedHough.setTemplate", (char**)keywords, &pyobj_templ, &pyobj_templCenter) &&
        pyopencv_to_safe(pyobj_templ, templ, ArgInfo("templ", 0)) &&
        pyopencv_to_safe(pyobj_templCenter, templCenter, ArgInfo("templCenter", 0)) )
    {
        ERRWRAP2(_self_->setTemplate(templ, templCenter));
        Py_RETURN_NONE;
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_edges = NULL;
    Mat edges;
    PyObject* pyobj_dx = NULL;
    Mat dx;
    PyObject* pyobj_dy = NULL;
    Mat dy;
    PyObject* pyobj_templCenter = NULL;
    Point templCenter=Point(-1, -1);

    const char* keywords[] = { "edges", "dx", "dy", "templCenter", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOO|O:GeneralizedHough.setTemplate", (char**)keywords, &pyobj_edges, &pyobj_dx, &pyobj_dy, &pyobj_templCenter) &&
        pyopencv_to_safe(pyobj_edges, edges, ArgInfo("edges", 0)) &&
        pyopencv_to_safe(pyobj_dx, dx, ArgInfo("dx", 0)) &&
        pyopencv_to_safe(pyobj_dy, dy, ArgInfo("dy", 0)) &&
        pyopencv_to_safe(pyobj_templCenter, templCenter, ArgInfo("templCenter", 0)) )
    {
        ERRWRAP2(_self_->setTemplate(edges, dx, dy, templCenter));
        Py_RETURN_NONE;
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_edges = NULL;
    UMat edges;
    PyObject* pyobj_dx = NULL;
    UMat dx;
    PyObject* pyobj_dy = NULL;
    UMat dy;
    PyObject* pyobj_templCenter = NULL;
    Point templCenter=Point(-1, -1);

    const char* keywords[] = { "edges", "dx", "dy", "templCenter", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOO|O:GeneralizedHough.setTemplate", (char**)keywords, &pyobj_edges, &pyobj_dx, &pyobj_dy, &pyobj_templCenter) &&
        pyopencv_to_safe(pyobj_edges, edges, ArgInfo("edges", 0)) &&
        pyopencv_to_safe(pyobj_dx, dx, ArgInfo("dx", 0)) &&
        pyopencv_to_safe(pyobj_dy, dy, ArgInfo("dy", 0)) &&
        pyopencv_to_safe(pyobj_templCenter, templCenter, ArgInfo("templCenter", 0)) )
    {
        ERRWRAP2(_self_->setTemplate(edges, dx, dy, templCenter));
        Py_RETURN_NONE;
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("setTemplate");

    return NULL;
}



// Tables (GeneralizedHough)

static PyGetSetDef pyopencv_GeneralizedHough_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_GeneralizedHough_methods[] =
{
    {"detect", CV_PY_FN_WITH_KW_(pyopencv_cv_GeneralizedHough_detect, 0), "detect(image[, positions[, votes]]) -> positions, votes\n.   \n\n\n\ndetect(edges, dx, dy[, positions[, votes]]) -> positions, votes\n."},
    {"getCannyHighThresh", CV_PY_FN_WITH_KW_(pyopencv_cv_GeneralizedHough_getCannyHighThresh, 0), "getCannyHighThresh() -> retval\n."},
    {"getCannyLowThresh", CV_PY_FN_WITH_KW_(pyopencv_cv_GeneralizedHough_getCannyLowThresh, 0), "getCannyLowThresh() -> retval\n."},
    {"getDp", CV_PY_FN_WITH_KW_(pyopencv_cv_GeneralizedHough_getDp, 0), "getDp() -> retval\n."},
    {"getMaxBufferSize", CV_PY_FN_WITH_KW_(pyopencv_cv_GeneralizedHough_getMaxBufferSize, 0), "getMaxBufferSize() -> retval\n."},
    {"getMinDist", CV_PY_FN_WITH_KW_(pyopencv_cv_GeneralizedHough_getMinDist, 0), "getMinDist() -> retval\n."},
    {"setCannyHighThresh", CV_PY_FN_WITH_KW_(pyopencv_cv_GeneralizedHough_setCannyHighThresh, 0), "setCannyHighThresh(cannyHighThresh) -> None\n."},
    {"setCannyLowThresh", CV_PY_FN_WITH_KW_(pyopencv_cv_GeneralizedHough_setCannyLowThresh, 0), "setCannyLowThresh(cannyLowThresh) -> None\n."},
    {"setDp", CV_PY_FN_WITH_KW_(pyopencv_cv_GeneralizedHough_setDp, 0), "setDp(dp) -> None\n."},
    {"setMaxBufferSize", CV_PY_FN_WITH_KW_(pyopencv_cv_GeneralizedHough_setMaxBufferSize, 0), "setMaxBufferSize(maxBufferSize) -> None\n."},
    {"setMinDist", CV_PY_FN_WITH_KW_(pyopencv_cv_GeneralizedHough_setMinDist, 0), "setMinDist(minDist) -> None\n."},
    {"setTemplate", CV_PY_FN_WITH_KW_(pyopencv_cv_GeneralizedHough_setTemplate, 0), "setTemplate(templ[, templCenter]) -> None\n.   \n\n\n\nsetTemplate(edges, dx, dy[, templCenter]) -> None\n."},

    {NULL,          NULL}
};

// Converter (GeneralizedHough)

template<>
struct PyOpenCV_Converter< Ptr<cv::GeneralizedHough> >
{
    static PyObject* from(const Ptr<cv::GeneralizedHough>& r)
    {
        return pyopencv_GeneralizedHough_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::GeneralizedHough>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::GeneralizedHough> * dst_;
        if (pyopencv_GeneralizedHough_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::GeneralizedHough> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// GeneralizedHoughBallard (Generic)
//================================================================================

// GetSet (GeneralizedHoughBallard)



// Methods (GeneralizedHoughBallard)

static PyObject* pyopencv_cv_GeneralizedHoughBallard_getLevels(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GeneralizedHoughBallard> * self1 = 0;
    if (!pyopencv_GeneralizedHoughBallard_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GeneralizedHoughBallard' or its derivative)");
    Ptr<cv::GeneralizedHoughBallard> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getLevels());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_GeneralizedHoughBallard_getVotesThreshold(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GeneralizedHoughBallard> * self1 = 0;
    if (!pyopencv_GeneralizedHoughBallard_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GeneralizedHoughBallard' or its derivative)");
    Ptr<cv::GeneralizedHoughBallard> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getVotesThreshold());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_GeneralizedHoughBallard_setLevels(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GeneralizedHoughBallard> * self1 = 0;
    if (!pyopencv_GeneralizedHoughBallard_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GeneralizedHoughBallard' or its derivative)");
    Ptr<cv::GeneralizedHoughBallard> _self_ = *(self1);
    PyObject* pyobj_levels = NULL;
    int levels=0;

    const char* keywords[] = { "levels", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:GeneralizedHoughBallard.setLevels", (char**)keywords, &pyobj_levels) &&
        pyopencv_to_safe(pyobj_levels, levels, ArgInfo("levels", 0)) )
    {
        ERRWRAP2(_self_->setLevels(levels));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_GeneralizedHoughBallard_setVotesThreshold(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GeneralizedHoughBallard> * self1 = 0;
    if (!pyopencv_GeneralizedHoughBallard_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GeneralizedHoughBallard' or its derivative)");
    Ptr<cv::GeneralizedHoughBallard> _self_ = *(self1);
    PyObject* pyobj_votesThreshold = NULL;
    int votesThreshold=0;

    const char* keywords[] = { "votesThreshold", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:GeneralizedHoughBallard.setVotesThreshold", (char**)keywords, &pyobj_votesThreshold) &&
        pyopencv_to_safe(pyobj_votesThreshold, votesThreshold, ArgInfo("votesThreshold", 0)) )
    {
        ERRWRAP2(_self_->setVotesThreshold(votesThreshold));
        Py_RETURN_NONE;
    }

    return NULL;
}



// Tables (GeneralizedHoughBallard)

static PyGetSetDef pyopencv_GeneralizedHoughBallard_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_GeneralizedHoughBallard_methods[] =
{
    {"getLevels", CV_PY_FN_WITH_KW_(pyopencv_cv_GeneralizedHoughBallard_getLevels, 0), "getLevels() -> retval\n."},
    {"getVotesThreshold", CV_PY_FN_WITH_KW_(pyopencv_cv_GeneralizedHoughBallard_getVotesThreshold, 0), "getVotesThreshold() -> retval\n."},
    {"setLevels", CV_PY_FN_WITH_KW_(pyopencv_cv_GeneralizedHoughBallard_setLevels, 0), "setLevels(levels) -> None\n."},
    {"setVotesThreshold", CV_PY_FN_WITH_KW_(pyopencv_cv_GeneralizedHoughBallard_setVotesThreshold, 0), "setVotesThreshold(votesThreshold) -> None\n."},

    {NULL,          NULL}
};

// Converter (GeneralizedHoughBallard)

template<>
struct PyOpenCV_Converter< Ptr<cv::GeneralizedHoughBallard> >
{
    static PyObject* from(const Ptr<cv::GeneralizedHoughBallard>& r)
    {
        return pyopencv_GeneralizedHoughBallard_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::GeneralizedHoughBallard>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::GeneralizedHoughBallard> * dst_;
        if (pyopencv_GeneralizedHoughBallard_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::GeneralizedHoughBallard> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// GeneralizedHoughGuil (Generic)
//================================================================================

// GetSet (GeneralizedHoughGuil)



// Methods (GeneralizedHoughGuil)

static PyObject* pyopencv_cv_GeneralizedHoughGuil_getAngleEpsilon(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GeneralizedHoughGuil> * self1 = 0;
    if (!pyopencv_GeneralizedHoughGuil_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GeneralizedHoughGuil' or its derivative)");
    Ptr<cv::GeneralizedHoughGuil> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getAngleEpsilon());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_GeneralizedHoughGuil_getAngleStep(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GeneralizedHoughGuil> * self1 = 0;
    if (!pyopencv_GeneralizedHoughGuil_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GeneralizedHoughGuil' or its derivative)");
    Ptr<cv::GeneralizedHoughGuil> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getAngleStep());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_GeneralizedHoughGuil_getAngleThresh(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GeneralizedHoughGuil> * self1 = 0;
    if (!pyopencv_GeneralizedHoughGuil_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GeneralizedHoughGuil' or its derivative)");
    Ptr<cv::GeneralizedHoughGuil> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getAngleThresh());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_GeneralizedHoughGuil_getLevels(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GeneralizedHoughGuil> * self1 = 0;
    if (!pyopencv_GeneralizedHoughGuil_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GeneralizedHoughGuil' or its derivative)");
    Ptr<cv::GeneralizedHoughGuil> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getLevels());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_GeneralizedHoughGuil_getMaxAngle(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GeneralizedHoughGuil> * self1 = 0;
    if (!pyopencv_GeneralizedHoughGuil_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GeneralizedHoughGuil' or its derivative)");
    Ptr<cv::GeneralizedHoughGuil> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getMaxAngle());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_GeneralizedHoughGuil_getMaxScale(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GeneralizedHoughGuil> * self1 = 0;
    if (!pyopencv_GeneralizedHoughGuil_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GeneralizedHoughGuil' or its derivative)");
    Ptr<cv::GeneralizedHoughGuil> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getMaxScale());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_GeneralizedHoughGuil_getMinAngle(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GeneralizedHoughGuil> * self1 = 0;
    if (!pyopencv_GeneralizedHoughGuil_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GeneralizedHoughGuil' or its derivative)");
    Ptr<cv::GeneralizedHoughGuil> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getMinAngle());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_GeneralizedHoughGuil_getMinScale(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GeneralizedHoughGuil> * self1 = 0;
    if (!pyopencv_GeneralizedHoughGuil_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GeneralizedHoughGuil' or its derivative)");
    Ptr<cv::GeneralizedHoughGuil> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getMinScale());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_GeneralizedHoughGuil_getPosThresh(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GeneralizedHoughGuil> * self1 = 0;
    if (!pyopencv_GeneralizedHoughGuil_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GeneralizedHoughGuil' or its derivative)");
    Ptr<cv::GeneralizedHoughGuil> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getPosThresh());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_GeneralizedHoughGuil_getScaleStep(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GeneralizedHoughGuil> * self1 = 0;
    if (!pyopencv_GeneralizedHoughGuil_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GeneralizedHoughGuil' or its derivative)");
    Ptr<cv::GeneralizedHoughGuil> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getScaleStep());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_GeneralizedHoughGuil_getScaleThresh(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GeneralizedHoughGuil> * self1 = 0;
    if (!pyopencv_GeneralizedHoughGuil_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GeneralizedHoughGuil' or its derivative)");
    Ptr<cv::GeneralizedHoughGuil> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getScaleThresh());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_GeneralizedHoughGuil_getXi(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GeneralizedHoughGuil> * self1 = 0;
    if (!pyopencv_GeneralizedHoughGuil_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GeneralizedHoughGuil' or its derivative)");
    Ptr<cv::GeneralizedHoughGuil> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getXi());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_GeneralizedHoughGuil_setAngleEpsilon(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GeneralizedHoughGuil> * self1 = 0;
    if (!pyopencv_GeneralizedHoughGuil_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GeneralizedHoughGuil' or its derivative)");
    Ptr<cv::GeneralizedHoughGuil> _self_ = *(self1);
    PyObject* pyobj_angleEpsilon = NULL;
    double angleEpsilon=0;

    const char* keywords[] = { "angleEpsilon", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:GeneralizedHoughGuil.setAngleEpsilon", (char**)keywords, &pyobj_angleEpsilon) &&
        pyopencv_to_safe(pyobj_angleEpsilon, angleEpsilon, ArgInfo("angleEpsilon", 0)) )
    {
        ERRWRAP2(_self_->setAngleEpsilon(angleEpsilon));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_GeneralizedHoughGuil_setAngleStep(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GeneralizedHoughGuil> * self1 = 0;
    if (!pyopencv_GeneralizedHoughGuil_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GeneralizedHoughGuil' or its derivative)");
    Ptr<cv::GeneralizedHoughGuil> _self_ = *(self1);
    PyObject* pyobj_angleStep = NULL;
    double angleStep=0;

    const char* keywords[] = { "angleStep", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:GeneralizedHoughGuil.setAngleStep", (char**)keywords, &pyobj_angleStep) &&
        pyopencv_to_safe(pyobj_angleStep, angleStep, ArgInfo("angleStep", 0)) )
    {
        ERRWRAP2(_self_->setAngleStep(angleStep));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_GeneralizedHoughGuil_setAngleThresh(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GeneralizedHoughGuil> * self1 = 0;
    if (!pyopencv_GeneralizedHoughGuil_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GeneralizedHoughGuil' or its derivative)");
    Ptr<cv::GeneralizedHoughGuil> _self_ = *(self1);
    PyObject* pyobj_angleThresh = NULL;
    int angleThresh=0;

    const char* keywords[] = { "angleThresh", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:GeneralizedHoughGuil.setAngleThresh", (char**)keywords, &pyobj_angleThresh) &&
        pyopencv_to_safe(pyobj_angleThresh, angleThresh, ArgInfo("angleThresh", 0)) )
    {
        ERRWRAP2(_self_->setAngleThresh(angleThresh));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_GeneralizedHoughGuil_setLevels(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GeneralizedHoughGuil> * self1 = 0;
    if (!pyopencv_GeneralizedHoughGuil_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GeneralizedHoughGuil' or its derivative)");
    Ptr<cv::GeneralizedHoughGuil> _self_ = *(self1);
    PyObject* pyobj_levels = NULL;
    int levels=0;

    const char* keywords[] = { "levels", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:GeneralizedHoughGuil.setLevels", (char**)keywords, &pyobj_levels) &&
        pyopencv_to_safe(pyobj_levels, levels, ArgInfo("levels", 0)) )
    {
        ERRWRAP2(_self_->setLevels(levels));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_GeneralizedHoughGuil_setMaxAngle(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GeneralizedHoughGuil> * self1 = 0;
    if (!pyopencv_GeneralizedHoughGuil_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GeneralizedHoughGuil' or its derivative)");
    Ptr<cv::GeneralizedHoughGuil> _self_ = *(self1);
    PyObject* pyobj_maxAngle = NULL;
    double maxAngle=0;

    const char* keywords[] = { "maxAngle", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:GeneralizedHoughGuil.setMaxAngle", (char**)keywords, &pyobj_maxAngle) &&
        pyopencv_to_safe(pyobj_maxAngle, maxAngle, ArgInfo("maxAngle", 0)) )
    {
        ERRWRAP2(_self_->setMaxAngle(maxAngle));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_GeneralizedHoughGuil_setMaxScale(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GeneralizedHoughGuil> * self1 = 0;
    if (!pyopencv_GeneralizedHoughGuil_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GeneralizedHoughGuil' or its derivative)");
    Ptr<cv::GeneralizedHoughGuil> _self_ = *(self1);
    PyObject* pyobj_maxScale = NULL;
    double maxScale=0;

    const char* keywords[] = { "maxScale", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:GeneralizedHoughGuil.setMaxScale", (char**)keywords, &pyobj_maxScale) &&
        pyopencv_to_safe(pyobj_maxScale, maxScale, ArgInfo("maxScale", 0)) )
    {
        ERRWRAP2(_self_->setMaxScale(maxScale));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_GeneralizedHoughGuil_setMinAngle(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GeneralizedHoughGuil> * self1 = 0;
    if (!pyopencv_GeneralizedHoughGuil_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GeneralizedHoughGuil' or its derivative)");
    Ptr<cv::GeneralizedHoughGuil> _self_ = *(self1);
    PyObject* pyobj_minAngle = NULL;
    double minAngle=0;

    const char* keywords[] = { "minAngle", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:GeneralizedHoughGuil.setMinAngle", (char**)keywords, &pyobj_minAngle) &&
        pyopencv_to_safe(pyobj_minAngle, minAngle, ArgInfo("minAngle", 0)) )
    {
        ERRWRAP2(_self_->setMinAngle(minAngle));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_GeneralizedHoughGuil_setMinScale(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GeneralizedHoughGuil> * self1 = 0;
    if (!pyopencv_GeneralizedHoughGuil_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GeneralizedHoughGuil' or its derivative)");
    Ptr<cv::GeneralizedHoughGuil> _self_ = *(self1);
    PyObject* pyobj_minScale = NULL;
    double minScale=0;

    const char* keywords[] = { "minScale", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:GeneralizedHoughGuil.setMinScale", (char**)keywords, &pyobj_minScale) &&
        pyopencv_to_safe(pyobj_minScale, minScale, ArgInfo("minScale", 0)) )
    {
        ERRWRAP2(_self_->setMinScale(minScale));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_GeneralizedHoughGuil_setPosThresh(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GeneralizedHoughGuil> * self1 = 0;
    if (!pyopencv_GeneralizedHoughGuil_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GeneralizedHoughGuil' or its derivative)");
    Ptr<cv::GeneralizedHoughGuil> _self_ = *(self1);
    PyObject* pyobj_posThresh = NULL;
    int posThresh=0;

    const char* keywords[] = { "posThresh", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:GeneralizedHoughGuil.setPosThresh", (char**)keywords, &pyobj_posThresh) &&
        pyopencv_to_safe(pyobj_posThresh, posThresh, ArgInfo("posThresh", 0)) )
    {
        ERRWRAP2(_self_->setPosThresh(posThresh));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_GeneralizedHoughGuil_setScaleStep(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GeneralizedHoughGuil> * self1 = 0;
    if (!pyopencv_GeneralizedHoughGuil_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GeneralizedHoughGuil' or its derivative)");
    Ptr<cv::GeneralizedHoughGuil> _self_ = *(self1);
    PyObject* pyobj_scaleStep = NULL;
    double scaleStep=0;

    const char* keywords[] = { "scaleStep", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:GeneralizedHoughGuil.setScaleStep", (char**)keywords, &pyobj_scaleStep) &&
        pyopencv_to_safe(pyobj_scaleStep, scaleStep, ArgInfo("scaleStep", 0)) )
    {
        ERRWRAP2(_self_->setScaleStep(scaleStep));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_GeneralizedHoughGuil_setScaleThresh(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GeneralizedHoughGuil> * self1 = 0;
    if (!pyopencv_GeneralizedHoughGuil_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GeneralizedHoughGuil' or its derivative)");
    Ptr<cv::GeneralizedHoughGuil> _self_ = *(self1);
    PyObject* pyobj_scaleThresh = NULL;
    int scaleThresh=0;

    const char* keywords[] = { "scaleThresh", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:GeneralizedHoughGuil.setScaleThresh", (char**)keywords, &pyobj_scaleThresh) &&
        pyopencv_to_safe(pyobj_scaleThresh, scaleThresh, ArgInfo("scaleThresh", 0)) )
    {
        ERRWRAP2(_self_->setScaleThresh(scaleThresh));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_GeneralizedHoughGuil_setXi(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::GeneralizedHoughGuil> * self1 = 0;
    if (!pyopencv_GeneralizedHoughGuil_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GeneralizedHoughGuil' or its derivative)");
    Ptr<cv::GeneralizedHoughGuil> _self_ = *(self1);
    PyObject* pyobj_xi = NULL;
    double xi=0;

    const char* keywords[] = { "xi", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:GeneralizedHoughGuil.setXi", (char**)keywords, &pyobj_xi) &&
        pyopencv_to_safe(pyobj_xi, xi, ArgInfo("xi", 0)) )
    {
        ERRWRAP2(_self_->setXi(xi));
        Py_RETURN_NONE;
    }

    return NULL;
}



// Tables (GeneralizedHoughGuil)

static PyGetSetDef pyopencv_GeneralizedHoughGuil_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_GeneralizedHoughGuil_methods[] =
{
    {"getAngleEpsilon", CV_PY_FN_WITH_KW_(pyopencv_cv_GeneralizedHoughGuil_getAngleEpsilon, 0), "getAngleEpsilon() -> retval\n."},
    {"getAngleStep", CV_PY_FN_WITH_KW_(pyopencv_cv_GeneralizedHoughGuil_getAngleStep, 0), "getAngleStep() -> retval\n."},
    {"getAngleThresh", CV_PY_FN_WITH_KW_(pyopencv_cv_GeneralizedHoughGuil_getAngleThresh, 0), "getAngleThresh() -> retval\n."},
    {"getLevels", CV_PY_FN_WITH_KW_(pyopencv_cv_GeneralizedHoughGuil_getLevels, 0), "getLevels() -> retval\n."},
    {"getMaxAngle", CV_PY_FN_WITH_KW_(pyopencv_cv_GeneralizedHoughGuil_getMaxAngle, 0), "getMaxAngle() -> retval\n."},
    {"getMaxScale", CV_PY_FN_WITH_KW_(pyopencv_cv_GeneralizedHoughGuil_getMaxScale, 0), "getMaxScale() -> retval\n."},
    {"getMinAngle", CV_PY_FN_WITH_KW_(pyopencv_cv_GeneralizedHoughGuil_getMinAngle, 0), "getMinAngle() -> retval\n."},
    {"getMinScale", CV_PY_FN_WITH_KW_(pyopencv_cv_GeneralizedHoughGuil_getMinScale, 0), "getMinScale() -> retval\n."},
    {"getPosThresh", CV_PY_FN_WITH_KW_(pyopencv_cv_GeneralizedHoughGuil_getPosThresh, 0), "getPosThresh() -> retval\n."},
    {"getScaleStep", CV_PY_FN_WITH_KW_(pyopencv_cv_GeneralizedHoughGuil_getScaleStep, 0), "getScaleStep() -> retval\n."},
    {"getScaleThresh", CV_PY_FN_WITH_KW_(pyopencv_cv_GeneralizedHoughGuil_getScaleThresh, 0), "getScaleThresh() -> retval\n."},
    {"getXi", CV_PY_FN_WITH_KW_(pyopencv_cv_GeneralizedHoughGuil_getXi, 0), "getXi() -> retval\n."},
    {"setAngleEpsilon", CV_PY_FN_WITH_KW_(pyopencv_cv_GeneralizedHoughGuil_setAngleEpsilon, 0), "setAngleEpsilon(angleEpsilon) -> None\n."},
    {"setAngleStep", CV_PY_FN_WITH_KW_(pyopencv_cv_GeneralizedHoughGuil_setAngleStep, 0), "setAngleStep(angleStep) -> None\n."},
    {"setAngleThresh", CV_PY_FN_WITH_KW_(pyopencv_cv_GeneralizedHoughGuil_setAngleThresh, 0), "setAngleThresh(angleThresh) -> None\n."},
    {"setLevels", CV_PY_FN_WITH_KW_(pyopencv_cv_GeneralizedHoughGuil_setLevels, 0), "setLevels(levels) -> None\n."},
    {"setMaxAngle", CV_PY_FN_WITH_KW_(pyopencv_cv_GeneralizedHoughGuil_setMaxAngle, 0), "setMaxAngle(maxAngle) -> None\n."},
    {"setMaxScale", CV_PY_FN_WITH_KW_(pyopencv_cv_GeneralizedHoughGuil_setMaxScale, 0), "setMaxScale(maxScale) -> None\n."},
    {"setMinAngle", CV_PY_FN_WITH_KW_(pyopencv_cv_GeneralizedHoughGuil_setMinAngle, 0), "setMinAngle(minAngle) -> None\n."},
    {"setMinScale", CV_PY_FN_WITH_KW_(pyopencv_cv_GeneralizedHoughGuil_setMinScale, 0), "setMinScale(minScale) -> None\n."},
    {"setPosThresh", CV_PY_FN_WITH_KW_(pyopencv_cv_GeneralizedHoughGuil_setPosThresh, 0), "setPosThresh(posThresh) -> None\n."},
    {"setScaleStep", CV_PY_FN_WITH_KW_(pyopencv_cv_GeneralizedHoughGuil_setScaleStep, 0), "setScaleStep(scaleStep) -> None\n."},
    {"setScaleThresh", CV_PY_FN_WITH_KW_(pyopencv_cv_GeneralizedHoughGuil_setScaleThresh, 0), "setScaleThresh(scaleThresh) -> None\n."},
    {"setXi", CV_PY_FN_WITH_KW_(pyopencv_cv_GeneralizedHoughGuil_setXi, 0), "setXi(xi) -> None\n."},

    {NULL,          NULL}
};

// Converter (GeneralizedHoughGuil)

template<>
struct PyOpenCV_Converter< Ptr<cv::GeneralizedHoughGuil> >
{
    static PyObject* from(const Ptr<cv::GeneralizedHoughGuil>& r)
    {
        return pyopencv_GeneralizedHoughGuil_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::GeneralizedHoughGuil>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::GeneralizedHoughGuil> * dst_;
        if (pyopencv_GeneralizedHoughGuil_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::GeneralizedHoughGuil> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// GraphicalCodeDetector (Generic)
//================================================================================

// GetSet (GraphicalCodeDetector)



// Methods (GraphicalCodeDetector)

static PyObject* pyopencv_cv_GraphicalCodeDetector_decode(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    cv::GraphicalCodeDetector * self1 = 0;
    if (!pyopencv_GraphicalCodeDetector_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GraphicalCodeDetector' or its derivative)");
    cv::GraphicalCodeDetector* _self_ = (self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_img = NULL;
    Mat img;
    PyObject* pyobj_points = NULL;
    Mat points;
    PyObject* pyobj_straight_code = NULL;
    Mat straight_code;
    std::string retval;

    const char* keywords[] = { "img", "points", "straight_code", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO|O:GraphicalCodeDetector.decode", (char**)keywords, &pyobj_img, &pyobj_points, &pyobj_straight_code) &&
        pyopencv_to_safe(pyobj_img, img, ArgInfo("img", 0)) &&
        pyopencv_to_safe(pyobj_points, points, ArgInfo("points", 0)) &&
        pyopencv_to_safe(pyobj_straight_code, straight_code, ArgInfo("straight_code", 1)) )
    {
        ERRWRAP2(retval = _self_->decode(img, points, straight_code));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(straight_code));
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_img = NULL;
    UMat img;
    PyObject* pyobj_points = NULL;
    UMat points;
    PyObject* pyobj_straight_code = NULL;
    UMat straight_code;
    std::string retval;

    const char* keywords[] = { "img", "points", "straight_code", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO|O:GraphicalCodeDetector.decode", (char**)keywords, &pyobj_img, &pyobj_points, &pyobj_straight_code) &&
        pyopencv_to_safe(pyobj_img, img, ArgInfo("img", 0)) &&
        pyopencv_to_safe(pyobj_points, points, ArgInfo("points", 0)) &&
        pyopencv_to_safe(pyobj_straight_code, straight_code, ArgInfo("straight_code", 1)) )
    {
        ERRWRAP2(retval = _self_->decode(img, points, straight_code));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(straight_code));
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("decode");

    return NULL;
}

static PyObject* pyopencv_cv_GraphicalCodeDetector_decodeMulti(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    cv::GraphicalCodeDetector * self1 = 0;
    if (!pyopencv_GraphicalCodeDetector_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GraphicalCodeDetector' or its derivative)");
    cv::GraphicalCodeDetector* _self_ = (self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_img = NULL;
    Mat img;
    PyObject* pyobj_points = NULL;
    Mat points;
    vector_string decoded_info;
    PyObject* pyobj_straight_code = NULL;
    vector_Mat straight_code;
    bool retval;

    const char* keywords[] = { "img", "points", "straight_code", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO|O:GraphicalCodeDetector.decodeMulti", (char**)keywords, &pyobj_img, &pyobj_points, &pyobj_straight_code) &&
        pyopencv_to_safe(pyobj_img, img, ArgInfo("img", 0)) &&
        pyopencv_to_safe(pyobj_points, points, ArgInfo("points", 0)) &&
        pyopencv_to_safe(pyobj_straight_code, straight_code, ArgInfo("straight_code", 1)) )
    {
        ERRWRAP2(retval = _self_->decodeMulti(img, points, decoded_info, straight_code));
        return Py_BuildValue("(NNN)", pyopencv_from(retval), pyopencv_from(decoded_info), pyopencv_from(straight_code));
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_img = NULL;
    UMat img;
    PyObject* pyobj_points = NULL;
    UMat points;
    vector_string decoded_info;
    PyObject* pyobj_straight_code = NULL;
    vector_UMat straight_code;
    bool retval;

    const char* keywords[] = { "img", "points", "straight_code", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO|O:GraphicalCodeDetector.decodeMulti", (char**)keywords, &pyobj_img, &pyobj_points, &pyobj_straight_code) &&
        pyopencv_to_safe(pyobj_img, img, ArgInfo("img", 0)) &&
        pyopencv_to_safe(pyobj_points, points, ArgInfo("points", 0)) &&
        pyopencv_to_safe(pyobj_straight_code, straight_code, ArgInfo("straight_code", 1)) )
    {
        ERRWRAP2(retval = _self_->decodeMulti(img, points, decoded_info, straight_code));
        return Py_BuildValue("(NNN)", pyopencv_from(retval), pyopencv_from(decoded_info), pyopencv_from(straight_code));
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("decodeMulti");

    return NULL;
}

static PyObject* pyopencv_cv_GraphicalCodeDetector_detect(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    cv::GraphicalCodeDetector * self1 = 0;
    if (!pyopencv_GraphicalCodeDetector_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GraphicalCodeDetector' or its derivative)");
    cv::GraphicalCodeDetector* _self_ = (self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_img = NULL;
    Mat img;
    PyObject* pyobj_points = NULL;
    Mat points;
    bool retval;

    const char* keywords[] = { "img", "points", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|O:GraphicalCodeDetector.detect", (char**)keywords, &pyobj_img, &pyobj_points) &&
        pyopencv_to_safe(pyobj_img, img, ArgInfo("img", 0)) &&
        pyopencv_to_safe(pyobj_points, points, ArgInfo("points", 1)) )
    {
        ERRWRAP2(retval = _self_->detect(img, points));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(points));
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_img = NULL;
    UMat img;
    PyObject* pyobj_points = NULL;
    UMat points;
    bool retval;

    const char* keywords[] = { "img", "points", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|O:GraphicalCodeDetector.detect", (char**)keywords, &pyobj_img, &pyobj_points) &&
        pyopencv_to_safe(pyobj_img, img, ArgInfo("img", 0)) &&
        pyopencv_to_safe(pyobj_points, points, ArgInfo("points", 1)) )
    {
        ERRWRAP2(retval = _self_->detect(img, points));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(points));
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("detect");

    return NULL;
}

static PyObject* pyopencv_cv_GraphicalCodeDetector_detectAndDecode(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    cv::GraphicalCodeDetector * self1 = 0;
    if (!pyopencv_GraphicalCodeDetector_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GraphicalCodeDetector' or its derivative)");
    cv::GraphicalCodeDetector* _self_ = (self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_img = NULL;
    Mat img;
    PyObject* pyobj_points = NULL;
    Mat points;
    PyObject* pyobj_straight_code = NULL;
    Mat straight_code;
    std::string retval;

    const char* keywords[] = { "img", "points", "straight_code", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|OO:GraphicalCodeDetector.detectAndDecode", (char**)keywords, &pyobj_img, &pyobj_points, &pyobj_straight_code) &&
        pyopencv_to_safe(pyobj_img, img, ArgInfo("img", 0)) &&
        pyopencv_to_safe(pyobj_points, points, ArgInfo("points", 1)) &&
        pyopencv_to_safe(pyobj_straight_code, straight_code, ArgInfo("straight_code", 1)) )
    {
        ERRWRAP2(retval = _self_->detectAndDecode(img, points, straight_code));
        return Py_BuildValue("(NNN)", pyopencv_from(retval), pyopencv_from(points), pyopencv_from(straight_code));
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_img = NULL;
    UMat img;
    PyObject* pyobj_points = NULL;
    UMat points;
    PyObject* pyobj_straight_code = NULL;
    UMat straight_code;
    std::string retval;

    const char* keywords[] = { "img", "points", "straight_code", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|OO:GraphicalCodeDetector.detectAndDecode", (char**)keywords, &pyobj_img, &pyobj_points, &pyobj_straight_code) &&
        pyopencv_to_safe(pyobj_img, img, ArgInfo("img", 0)) &&
        pyopencv_to_safe(pyobj_points, points, ArgInfo("points", 1)) &&
        pyopencv_to_safe(pyobj_straight_code, straight_code, ArgInfo("straight_code", 1)) )
    {
        ERRWRAP2(retval = _self_->detectAndDecode(img, points, straight_code));
        return Py_BuildValue("(NNN)", pyopencv_from(retval), pyopencv_from(points), pyopencv_from(straight_code));
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("detectAndDecode");

    return NULL;
}

static PyObject* pyopencv_cv_GraphicalCodeDetector_detectAndDecodeMulti(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    cv::GraphicalCodeDetector * self1 = 0;
    if (!pyopencv_GraphicalCodeDetector_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GraphicalCodeDetector' or its derivative)");
    cv::GraphicalCodeDetector* _self_ = (self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_img = NULL;
    Mat img;
    vector_string decoded_info;
    PyObject* pyobj_points = NULL;
    Mat points;
    PyObject* pyobj_straight_code = NULL;
    vector_Mat straight_code;
    bool retval;

    const char* keywords[] = { "img", "points", "straight_code", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|OO:GraphicalCodeDetector.detectAndDecodeMulti", (char**)keywords, &pyobj_img, &pyobj_points, &pyobj_straight_code) &&
        pyopencv_to_safe(pyobj_img, img, ArgInfo("img", 0)) &&
        pyopencv_to_safe(pyobj_points, points, ArgInfo("points", 1)) &&
        pyopencv_to_safe(pyobj_straight_code, straight_code, ArgInfo("straight_code", 1)) )
    {
        ERRWRAP2(retval = _self_->detectAndDecodeMulti(img, decoded_info, points, straight_code));
        return Py_BuildValue("(NNNN)", pyopencv_from(retval), pyopencv_from(decoded_info), pyopencv_from(points), pyopencv_from(straight_code));
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_img = NULL;
    UMat img;
    vector_string decoded_info;
    PyObject* pyobj_points = NULL;
    UMat points;
    PyObject* pyobj_straight_code = NULL;
    vector_UMat straight_code;
    bool retval;

    const char* keywords[] = { "img", "points", "straight_code", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|OO:GraphicalCodeDetector.detectAndDecodeMulti", (char**)keywords, &pyobj_img, &pyobj_points, &pyobj_straight_code) &&
        pyopencv_to_safe(pyobj_img, img, ArgInfo("img", 0)) &&
        pyopencv_to_safe(pyobj_points, points, ArgInfo("points", 1)) &&
        pyopencv_to_safe(pyobj_straight_code, straight_code, ArgInfo("straight_code", 1)) )
    {
        ERRWRAP2(retval = _self_->detectAndDecodeMulti(img, decoded_info, points, straight_code));
        return Py_BuildValue("(NNNN)", pyopencv_from(retval), pyopencv_from(decoded_info), pyopencv_from(points), pyopencv_from(straight_code));
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("detectAndDecodeMulti");

    return NULL;
}

static PyObject* pyopencv_cv_GraphicalCodeDetector_detectMulti(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    cv::GraphicalCodeDetector * self1 = 0;
    if (!pyopencv_GraphicalCodeDetector_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'GraphicalCodeDetector' or its derivative)");
    cv::GraphicalCodeDetector* _self_ = (self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_img = NULL;
    Mat img;
    PyObject* pyobj_points = NULL;
    Mat points;
    bool retval;

    const char* keywords[] = { "img", "points", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|O:GraphicalCodeDetector.detectMulti", (char**)keywords, &pyobj_img, &pyobj_points) &&
        pyopencv_to_safe(pyobj_img, img, ArgInfo("img", 0)) &&
        pyopencv_to_safe(pyobj_points, points, ArgInfo("points", 1)) )
    {
        ERRWRAP2(retval = _self_->detectMulti(img, points));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(points));
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_img = NULL;
    UMat img;
    PyObject* pyobj_points = NULL;
    UMat points;
    bool retval;

    const char* keywords[] = { "img", "points", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|O:GraphicalCodeDetector.detectMulti", (char**)keywords, &pyobj_img, &pyobj_points) &&
        pyopencv_to_safe(pyobj_img, img, ArgInfo("img", 0)) &&
        pyopencv_to_safe(pyobj_points, points, ArgInfo("points", 1)) )
    {
        ERRWRAP2(retval = _self_->detectMulti(img, points));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(points));
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("detectMulti");

    return NULL;
}



// Tables (GraphicalCodeDetector)

static PyGetSetDef pyopencv_GraphicalCodeDetector_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_GraphicalCodeDetector_methods[] =
{
    {"decode", CV_PY_FN_WITH_KW_(pyopencv_cv_GraphicalCodeDetector_decode, 0), "decode(img, points[, straight_code]) -> retval, straight_code\n.   @brief Decodes graphical code in image once it's found by the detect() method.\n.   \n.        Returns UTF8-encoded output string or empty string if the code cannot be decoded.\n.        @param img grayscale or color (BGR) image containing graphical code.\n.        @param points Quadrangle vertices found by detect() method (or some other algorithm).\n.        @param straight_code The optional output image containing binarized code, will be empty if not found."},
    {"decodeMulti", CV_PY_FN_WITH_KW_(pyopencv_cv_GraphicalCodeDetector_decodeMulti, 0), "decodeMulti(img, points[, straight_code]) -> retval, decoded_info, straight_code\n.   @brief Decodes graphical codes in image once it's found by the detect() method.\n.        @param img grayscale or color (BGR) image containing graphical codes.\n.        @param decoded_info UTF8-encoded output vector of string or empty vector of string if the codes cannot be decoded.\n.        @param points vector of Quadrangle vertices found by detect() method (or some other algorithm).\n.        @param straight_code The optional output vector of images containing binarized codes"},
    {"detect", CV_PY_FN_WITH_KW_(pyopencv_cv_GraphicalCodeDetector_detect, 0), "detect(img[, points]) -> retval, points\n.   @brief Detects graphical code in image and returns the quadrangle containing the code.\n.        @param img grayscale or color (BGR) image containing (or not) graphical code.\n.        @param points Output vector of vertices of the minimum-area quadrangle containing the code."},
    {"detectAndDecode", CV_PY_FN_WITH_KW_(pyopencv_cv_GraphicalCodeDetector_detectAndDecode, 0), "detectAndDecode(img[, points[, straight_code]]) -> retval, points, straight_code\n.   @brief Both detects and decodes graphical code\n.   \n.        @param img grayscale or color (BGR) image containing graphical code.\n.        @param points optional output array of vertices of the found graphical code quadrangle, will be empty if not found.\n.        @param straight_code The optional output image containing binarized code"},
    {"detectAndDecodeMulti", CV_PY_FN_WITH_KW_(pyopencv_cv_GraphicalCodeDetector_detectAndDecodeMulti, 0), "detectAndDecodeMulti(img[, points[, straight_code]]) -> retval, decoded_info, points, straight_code\n.   @brief Both detects and decodes graphical codes\n.       @param img grayscale or color (BGR) image containing graphical codes.\n.       @param decoded_info UTF8-encoded output vector of string or empty vector of string if the codes cannot be decoded.\n.       @param points optional output vector of vertices of the found graphical code quadrangles. Will be empty if not found.\n.       @param straight_code The optional vector of images containing binarized codes"},
    {"detectMulti", CV_PY_FN_WITH_KW_(pyopencv_cv_GraphicalCodeDetector_detectMulti, 0), "detectMulti(img[, points]) -> retval, points\n.   @brief Detects graphical codes in image and returns the vector of the quadrangles containing the codes.\n.        @param img grayscale or color (BGR) image containing (or not) graphical codes.\n.        @param points Output vector of vector of vertices of the minimum-area quadrangle containing the codes."},

    {NULL,          NULL}
};

// Converter (GraphicalCodeDetector)

template<>
struct PyOpenCV_Converter< cv::GraphicalCodeDetector >
{
    static PyObject* from(const cv::GraphicalCodeDetector& r)
    {
        return pyopencv_GraphicalCodeDetector_Instance(r);
    }
    static bool to(PyObject* src, cv::GraphicalCodeDetector& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        cv::GraphicalCodeDetector * dst_;
        if (pyopencv_GraphicalCodeDetector_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected cv::GraphicalCodeDetector for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// HOGDescriptor (Generic)
//================================================================================

// GetSet (HOGDescriptor)


static PyObject* pyopencv_HOGDescriptor_get_L2HysThreshold(pyopencv_HOGDescriptor_t* p, void *closure)
{
    return pyopencv_from(p->v->L2HysThreshold);
}

static PyObject* pyopencv_HOGDescriptor_get_blockSize(pyopencv_HOGDescriptor_t* p, void *closure)
{
    return pyopencv_from(p->v->blockSize);
}

static PyObject* pyopencv_HOGDescriptor_get_blockStride(pyopencv_HOGDescriptor_t* p, void *closure)
{
    return pyopencv_from(p->v->blockStride);
}

static PyObject* pyopencv_HOGDescriptor_get_cellSize(pyopencv_HOGDescriptor_t* p, void *closure)
{
    return pyopencv_from(p->v->cellSize);
}

static PyObject* pyopencv_HOGDescriptor_get_derivAperture(pyopencv_HOGDescriptor_t* p, void *closure)
{
    return pyopencv_from(p->v->derivAperture);
}

static PyObject* pyopencv_HOGDescriptor_get_gammaCorrection(pyopencv_HOGDescriptor_t* p, void *closure)
{
    return pyopencv_from(p->v->gammaCorrection);
}

static PyObject* pyopencv_HOGDescriptor_get_histogramNormType(pyopencv_HOGDescriptor_t* p, void *closure)
{
    return pyopencv_from(p->v->histogramNormType);
}

static PyObject* pyopencv_HOGDescriptor_get_nbins(pyopencv_HOGDescriptor_t* p, void *closure)
{
    return pyopencv_from(p->v->nbins);
}

static PyObject* pyopencv_HOGDescriptor_get_nlevels(pyopencv_HOGDescriptor_t* p, void *closure)
{
    return pyopencv_from(p->v->nlevels);
}

static PyObject* pyopencv_HOGDescriptor_get_signedGradient(pyopencv_HOGDescriptor_t* p, void *closure)
{
    return pyopencv_from(p->v->signedGradient);
}

static PyObject* pyopencv_HOGDescriptor_get_svmDetector(pyopencv_HOGDescriptor_t* p, void *closure)
{
    return pyopencv_from(p->v->svmDetector);
}

static PyObject* pyopencv_HOGDescriptor_get_winSigma(pyopencv_HOGDescriptor_t* p, void *closure)
{
    return pyopencv_from(p->v->winSigma);
}

static PyObject* pyopencv_HOGDescriptor_get_winSize(pyopencv_HOGDescriptor_t* p, void *closure)
{
    return pyopencv_from(p->v->winSize);
}


// Methods (HOGDescriptor)

static int pyopencv_cv_HOGDescriptor_HOGDescriptor(pyopencv_HOGDescriptor_t* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    pyPrepareArgumentConversionErrorsStorage(3);

    {

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        new (&(self->v)) Ptr<cv::HOGDescriptor>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::HOGDescriptor()));
        return 0;
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj__winSize = NULL;
    Size _winSize;
    PyObject* pyobj__blockSize = NULL;
    Size _blockSize;
    PyObject* pyobj__blockStride = NULL;
    Size _blockStride;
    PyObject* pyobj__cellSize = NULL;
    Size _cellSize;
    PyObject* pyobj__nbins = NULL;
    int _nbins=0;
    PyObject* pyobj__derivAperture = NULL;
    int _derivAperture=1;
    PyObject* pyobj__winSigma = NULL;
    double _winSigma=-1;
    PyObject* pyobj__histogramNormType = NULL;
    HOGDescriptor_HistogramNormType _histogramNormType=HOGDescriptor::L2Hys;
    PyObject* pyobj__L2HysThreshold = NULL;
    double _L2HysThreshold=0.2;
    PyObject* pyobj__gammaCorrection = NULL;
    bool _gammaCorrection=false;
    PyObject* pyobj__nlevels = NULL;
    int _nlevels=HOGDescriptor::DEFAULT_NLEVELS;
    PyObject* pyobj__signedGradient = NULL;
    bool _signedGradient=false;

    const char* keywords[] = { "_winSize", "_blockSize", "_blockStride", "_cellSize", "_nbins", "_derivAperture", "_winSigma", "_histogramNormType", "_L2HysThreshold", "_gammaCorrection", "_nlevels", "_signedGradient", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOOOO|OOOOOOO:HOGDescriptor", (char**)keywords, &pyobj__winSize, &pyobj__blockSize, &pyobj__blockStride, &pyobj__cellSize, &pyobj__nbins, &pyobj__derivAperture, &pyobj__winSigma, &pyobj__histogramNormType, &pyobj__L2HysThreshold, &pyobj__gammaCorrection, &pyobj__nlevels, &pyobj__signedGradient) &&
        pyopencv_to_safe(pyobj__winSize, _winSize, ArgInfo("_winSize", 0)) &&
        pyopencv_to_safe(pyobj__blockSize, _blockSize, ArgInfo("_blockSize", 0)) &&
        pyopencv_to_safe(pyobj__blockStride, _blockStride, ArgInfo("_blockStride", 0)) &&
        pyopencv_to_safe(pyobj__cellSize, _cellSize, ArgInfo("_cellSize", 0)) &&
        pyopencv_to_safe(pyobj__nbins, _nbins, ArgInfo("_nbins", 0)) &&
        pyopencv_to_safe(pyobj__derivAperture, _derivAperture, ArgInfo("_derivAperture", 0)) &&
        pyopencv_to_safe(pyobj__winSigma, _winSigma, ArgInfo("_winSigma", 0)) &&
        pyopencv_to_safe(pyobj__histogramNormType, _histogramNormType, ArgInfo("_histogramNormType", 0)) &&
        pyopencv_to_safe(pyobj__L2HysThreshold, _L2HysThreshold, ArgInfo("_L2HysThreshold", 0)) &&
        pyopencv_to_safe(pyobj__gammaCorrection, _gammaCorrection, ArgInfo("_gammaCorrection", 0)) &&
        pyopencv_to_safe(pyobj__nlevels, _nlevels, ArgInfo("_nlevels", 0)) &&
        pyopencv_to_safe(pyobj__signedGradient, _signedGradient, ArgInfo("_signedGradient", 0)) )
    {
        new (&(self->v)) Ptr<cv::HOGDescriptor>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::HOGDescriptor(_winSize, _blockSize, _blockStride, _cellSize, _nbins, _derivAperture, _winSigma, _histogramNormType, _L2HysThreshold, _gammaCorrection, _nlevels, _signedGradient)));
        return 0;
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_filename = NULL;
    String filename;

    const char* keywords[] = { "filename", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:HOGDescriptor", (char**)keywords, &pyobj_filename) &&
        pyopencv_to_safe(pyobj_filename, filename, ArgInfo("filename", 0)) )
    {
        new (&(self->v)) Ptr<cv::HOGDescriptor>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::HOGDescriptor(filename)));
        return 0;
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("HOGDescriptor");

    return -1;
}

static PyObject* pyopencv_cv_HOGDescriptor_checkDetectorSize(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::HOGDescriptor> * self1 = 0;
    if (!pyopencv_HOGDescriptor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'HOGDescriptor' or its derivative)");
    Ptr<cv::HOGDescriptor> _self_ = *(self1);
    bool retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->checkDetectorSize());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_HOGDescriptor_compute(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::HOGDescriptor> * self1 = 0;
    if (!pyopencv_HOGDescriptor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'HOGDescriptor' or its derivative)");
    Ptr<cv::HOGDescriptor> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_img = NULL;
    Mat img;
    vector_float descriptors;
    PyObject* pyobj_winStride = NULL;
    Size winStride;
    PyObject* pyobj_padding = NULL;
    Size padding;
    PyObject* pyobj_locations = NULL;
    vector_Point locations=std::vector<Point>();

    const char* keywords[] = { "img", "winStride", "padding", "locations", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|OOO:HOGDescriptor.compute", (char**)keywords, &pyobj_img, &pyobj_winStride, &pyobj_padding, &pyobj_locations) &&
        pyopencv_to_safe(pyobj_img, img, ArgInfo("img", 0)) &&
        pyopencv_to_safe(pyobj_winStride, winStride, ArgInfo("winStride", 0)) &&
        pyopencv_to_safe(pyobj_padding, padding, ArgInfo("padding", 0)) &&
        pyopencv_to_safe(pyobj_locations, locations, ArgInfo("locations", 0)) )
    {
        ERRWRAP2(_self_->compute(img, descriptors, winStride, padding, locations));
        return pyopencv_from(descriptors);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_img = NULL;
    UMat img;
    vector_float descriptors;
    PyObject* pyobj_winStride = NULL;
    Size winStride;
    PyObject* pyobj_padding = NULL;
    Size padding;
    PyObject* pyobj_locations = NULL;
    vector_Point locations=std::vector<Point>();

    const char* keywords[] = { "img", "winStride", "padding", "locations", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|OOO:HOGDescriptor.compute", (char**)keywords, &pyobj_img, &pyobj_winStride, &pyobj_padding, &pyobj_locations) &&
        pyopencv_to_safe(pyobj_img, img, ArgInfo("img", 0)) &&
        pyopencv_to_safe(pyobj_winStride, winStride, ArgInfo("winStride", 0)) &&
        pyopencv_to_safe(pyobj_padding, padding, ArgInfo("padding", 0)) &&
        pyopencv_to_safe(pyobj_locations, locations, ArgInfo("locations", 0)) )
    {
        ERRWRAP2(_self_->compute(img, descriptors, winStride, padding, locations));
        return pyopencv_from(descriptors);
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("compute");

    return NULL;
}

static PyObject* pyopencv_cv_HOGDescriptor_computeGradient(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::HOGDescriptor> * self1 = 0;
    if (!pyopencv_HOGDescriptor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'HOGDescriptor' or its derivative)");
    Ptr<cv::HOGDescriptor> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_img = NULL;
    Mat img;
    PyObject* pyobj_grad = NULL;
    Mat grad;
    PyObject* pyobj_angleOfs = NULL;
    Mat angleOfs;
    PyObject* pyobj_paddingTL = NULL;
    Size paddingTL;
    PyObject* pyobj_paddingBR = NULL;
    Size paddingBR;

    const char* keywords[] = { "img", "grad", "angleOfs", "paddingTL", "paddingBR", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOO|OO:HOGDescriptor.computeGradient", (char**)keywords, &pyobj_img, &pyobj_grad, &pyobj_angleOfs, &pyobj_paddingTL, &pyobj_paddingBR) &&
        pyopencv_to_safe(pyobj_img, img, ArgInfo("img", 0)) &&
        pyopencv_to_safe(pyobj_grad, grad, ArgInfo("grad", 1)) &&
        pyopencv_to_safe(pyobj_angleOfs, angleOfs, ArgInfo("angleOfs", 1)) &&
        pyopencv_to_safe(pyobj_paddingTL, paddingTL, ArgInfo("paddingTL", 0)) &&
        pyopencv_to_safe(pyobj_paddingBR, paddingBR, ArgInfo("paddingBR", 0)) )
    {
        ERRWRAP2(_self_->computeGradient(img, grad, angleOfs, paddingTL, paddingBR));
        return Py_BuildValue("(NN)", pyopencv_from(grad), pyopencv_from(angleOfs));
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_img = NULL;
    UMat img;
    PyObject* pyobj_grad = NULL;
    UMat grad;
    PyObject* pyobj_angleOfs = NULL;
    UMat angleOfs;
    PyObject* pyobj_paddingTL = NULL;
    Size paddingTL;
    PyObject* pyobj_paddingBR = NULL;
    Size paddingBR;

    const char* keywords[] = { "img", "grad", "angleOfs", "paddingTL", "paddingBR", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOO|OO:HOGDescriptor.computeGradient", (char**)keywords, &pyobj_img, &pyobj_grad, &pyobj_angleOfs, &pyobj_paddingTL, &pyobj_paddingBR) &&
        pyopencv_to_safe(pyobj_img, img, ArgInfo("img", 0)) &&
        pyopencv_to_safe(pyobj_grad, grad, ArgInfo("grad", 1)) &&
        pyopencv_to_safe(pyobj_angleOfs, angleOfs, ArgInfo("angleOfs", 1)) &&
        pyopencv_to_safe(pyobj_paddingTL, paddingTL, ArgInfo("paddingTL", 0)) &&
        pyopencv_to_safe(pyobj_paddingBR, paddingBR, ArgInfo("paddingBR", 0)) )
    {
        ERRWRAP2(_self_->computeGradient(img, grad, angleOfs, paddingTL, paddingBR));
        return Py_BuildValue("(NN)", pyopencv_from(grad), pyopencv_from(angleOfs));
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("computeGradient");

    return NULL;
}

static PyObject* pyopencv_cv_HOGDescriptor_detect(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::HOGDescriptor> * self1 = 0;
    if (!pyopencv_HOGDescriptor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'HOGDescriptor' or its derivative)");
    Ptr<cv::HOGDescriptor> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_img = NULL;
    Mat img;
    vector_Point foundLocations;
    vector_double weights;
    PyObject* pyobj_hitThreshold = NULL;
    double hitThreshold=0;
    PyObject* pyobj_winStride = NULL;
    Size winStride;
    PyObject* pyobj_padding = NULL;
    Size padding;
    PyObject* pyobj_searchLocations = NULL;
    vector_Point searchLocations=std::vector<Point>();

    const char* keywords[] = { "img", "hitThreshold", "winStride", "padding", "searchLocations", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|OOOO:HOGDescriptor.detect", (char**)keywords, &pyobj_img, &pyobj_hitThreshold, &pyobj_winStride, &pyobj_padding, &pyobj_searchLocations) &&
        pyopencv_to_safe(pyobj_img, img, ArgInfo("img", 0)) &&
        pyopencv_to_safe(pyobj_hitThreshold, hitThreshold, ArgInfo("hitThreshold", 0)) &&
        pyopencv_to_safe(pyobj_winStride, winStride, ArgInfo("winStride", 0)) &&
        pyopencv_to_safe(pyobj_padding, padding, ArgInfo("padding", 0)) &&
        pyopencv_to_safe(pyobj_searchLocations, searchLocations, ArgInfo("searchLocations", 0)) )
    {
        ERRWRAP2(_self_->detect(img, foundLocations, weights, hitThreshold, winStride, padding, searchLocations));
        return Py_BuildValue("(NN)", pyopencv_from(foundLocations), pyopencv_from(weights));
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_img = NULL;
    UMat img;
    vector_Point foundLocations;
    vector_double weights;
    PyObject* pyobj_hitThreshold = NULL;
    double hitThreshold=0;
    PyObject* pyobj_winStride = NULL;
    Size winStride;
    PyObject* pyobj_padding = NULL;
    Size padding;
    PyObject* pyobj_searchLocations = NULL;
    vector_Point searchLocations=std::vector<Point>();

    const char* keywords[] = { "img", "hitThreshold", "winStride", "padding", "searchLocations", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|OOOO:HOGDescriptor.detect", (char**)keywords, &pyobj_img, &pyobj_hitThreshold, &pyobj_winStride, &pyobj_padding, &pyobj_searchLocations) &&
        pyopencv_to_safe(pyobj_img, img, ArgInfo("img", 0)) &&
        pyopencv_to_safe(pyobj_hitThreshold, hitThreshold, ArgInfo("hitThreshold", 0)) &&
        pyopencv_to_safe(pyobj_winStride, winStride, ArgInfo("winStride", 0)) &&
        pyopencv_to_safe(pyobj_padding, padding, ArgInfo("padding", 0)) &&
        pyopencv_to_safe(pyobj_searchLocations, searchLocations, ArgInfo("searchLocations", 0)) )
    {
        ERRWRAP2(_self_->detect(img, foundLocations, weights, hitThreshold, winStride, padding, searchLocations));
        return Py_BuildValue("(NN)", pyopencv_from(foundLocations), pyopencv_from(weights));
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("detect");

    return NULL;
}

static PyObject* pyopencv_cv_HOGDescriptor_detectMultiScale(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::HOGDescriptor> * self1 = 0;
    if (!pyopencv_HOGDescriptor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'HOGDescriptor' or its derivative)");
    Ptr<cv::HOGDescriptor> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_img = NULL;
    Mat img;
    vector_Rect foundLocations;
    vector_double foundWeights;
    PyObject* pyobj_hitThreshold = NULL;
    double hitThreshold=0;
    PyObject* pyobj_winStride = NULL;
    Size winStride;
    PyObject* pyobj_padding = NULL;
    Size padding;
    PyObject* pyobj_scale = NULL;
    double scale=1.05;
    PyObject* pyobj_groupThreshold = NULL;
    double groupThreshold=2.0;
    PyObject* pyobj_useMeanshiftGrouping = NULL;
    bool useMeanshiftGrouping=false;

    const char* keywords[] = { "img", "hitThreshold", "winStride", "padding", "scale", "groupThreshold", "useMeanshiftGrouping", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|OOOOOO:HOGDescriptor.detectMultiScale", (char**)keywords, &pyobj_img, &pyobj_hitThreshold, &pyobj_winStride, &pyobj_padding, &pyobj_scale, &pyobj_groupThreshold, &pyobj_useMeanshiftGrouping) &&
        pyopencv_to_safe(pyobj_img, img, ArgInfo("img", 0)) &&
        pyopencv_to_safe(pyobj_hitThreshold, hitThreshold, ArgInfo("hitThreshold", 0)) &&
        pyopencv_to_safe(pyobj_winStride, winStride, ArgInfo("winStride", 0)) &&
        pyopencv_to_safe(pyobj_padding, padding, ArgInfo("padding", 0)) &&
        pyopencv_to_safe(pyobj_scale, scale, ArgInfo("scale", 0)) &&
        pyopencv_to_safe(pyobj_groupThreshold, groupThreshold, ArgInfo("groupThreshold", 0)) &&
        pyopencv_to_safe(pyobj_useMeanshiftGrouping, useMeanshiftGrouping, ArgInfo("useMeanshiftGrouping", 0)) )
    {
        ERRWRAP2(_self_->detectMultiScale(img, foundLocations, foundWeights, hitThreshold, winStride, padding, scale, groupThreshold, useMeanshiftGrouping));
        return Py_BuildValue("(NN)", pyopencv_from(foundLocations), pyopencv_from(foundWeights));
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_img = NULL;
    UMat img;
    vector_Rect foundLocations;
    vector_double foundWeights;
    PyObject* pyobj_hitThreshold = NULL;
    double hitThreshold=0;
    PyObject* pyobj_winStride = NULL;
    Size winStride;
    PyObject* pyobj_padding = NULL;
    Size padding;
    PyObject* pyobj_scale = NULL;
    double scale=1.05;
    PyObject* pyobj_groupThreshold = NULL;
    double groupThreshold=2.0;
    PyObject* pyobj_useMeanshiftGrouping = NULL;
    bool useMeanshiftGrouping=false;

    const char* keywords[] = { "img", "hitThreshold", "winStride", "padding", "scale", "groupThreshold", "useMeanshiftGrouping", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|OOOOOO:HOGDescriptor.detectMultiScale", (char**)keywords, &pyobj_img, &pyobj_hitThreshold, &pyobj_winStride, &pyobj_padding, &pyobj_scale, &pyobj_groupThreshold, &pyobj_useMeanshiftGrouping) &&
        pyopencv_to_safe(pyobj_img, img, ArgInfo("img", 0)) &&
        pyopencv_to_safe(pyobj_hitThreshold, hitThreshold, ArgInfo("hitThreshold", 0)) &&
        pyopencv_to_safe(pyobj_winStride, winStride, ArgInfo("winStride", 0)) &&
        pyopencv_to_safe(pyobj_padding, padding, ArgInfo("padding", 0)) &&
        pyopencv_to_safe(pyobj_scale, scale, ArgInfo("scale", 0)) &&
        pyopencv_to_safe(pyobj_groupThreshold, groupThreshold, ArgInfo("groupThreshold", 0)) &&
        pyopencv_to_safe(pyobj_useMeanshiftGrouping, useMeanshiftGrouping, ArgInfo("useMeanshiftGrouping", 0)) )
    {
        ERRWRAP2(_self_->detectMultiScale(img, foundLocations, foundWeights, hitThreshold, winStride, padding, scale, groupThreshold, useMeanshiftGrouping));
        return Py_BuildValue("(NN)", pyopencv_from(foundLocations), pyopencv_from(foundWeights));
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("detectMultiScale");

    return NULL;
}

static PyObject* pyopencv_cv_HOGDescriptor_getDaimlerPeopleDetector_static(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    std::vector<float> retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = cv::HOGDescriptor::getDaimlerPeopleDetector());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_HOGDescriptor_getDefaultPeopleDetector_static(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    std::vector<float> retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = cv::HOGDescriptor::getDefaultPeopleDetector());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_HOGDescriptor_getDescriptorSize(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::HOGDescriptor> * self1 = 0;
    if (!pyopencv_HOGDescriptor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'HOGDescriptor' or its derivative)");
    Ptr<cv::HOGDescriptor> _self_ = *(self1);
    size_t retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getDescriptorSize());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_HOGDescriptor_getWinSigma(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::HOGDescriptor> * self1 = 0;
    if (!pyopencv_HOGDescriptor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'HOGDescriptor' or its derivative)");
    Ptr<cv::HOGDescriptor> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getWinSigma());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_HOGDescriptor_load(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::HOGDescriptor> * self1 = 0;
    if (!pyopencv_HOGDescriptor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'HOGDescriptor' or its derivative)");
    Ptr<cv::HOGDescriptor> _self_ = *(self1);
    PyObject* pyobj_filename = NULL;
    String filename;
    PyObject* pyobj_objname = NULL;
    String objname;
    bool retval;

    const char* keywords[] = { "filename", "objname", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|O:HOGDescriptor.load", (char**)keywords, &pyobj_filename, &pyobj_objname) &&
        pyopencv_to_safe(pyobj_filename, filename, ArgInfo("filename", 0)) &&
        pyopencv_to_safe(pyobj_objname, objname, ArgInfo("objname", 0)) )
    {
        ERRWRAP2(retval = _self_->load(filename, objname));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_HOGDescriptor_save(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::HOGDescriptor> * self1 = 0;
    if (!pyopencv_HOGDescriptor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'HOGDescriptor' or its derivative)");
    Ptr<cv::HOGDescriptor> _self_ = *(self1);
    PyObject* pyobj_filename = NULL;
    String filename;
    PyObject* pyobj_objname = NULL;
    String objname;

    const char* keywords[] = { "filename", "objname", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|O:HOGDescriptor.save", (char**)keywords, &pyobj_filename, &pyobj_objname) &&
        pyopencv_to_safe(pyobj_filename, filename, ArgInfo("filename", 0)) &&
        pyopencv_to_safe(pyobj_objname, objname, ArgInfo("objname", 0)) )
    {
        ERRWRAP2(_self_->save(filename, objname));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_HOGDescriptor_setSVMDetector(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::HOGDescriptor> * self1 = 0;
    if (!pyopencv_HOGDescriptor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'HOGDescriptor' or its derivative)");
    Ptr<cv::HOGDescriptor> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_svmdetector = NULL;
    Mat svmdetector;

    const char* keywords[] = { "svmdetector", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:HOGDescriptor.setSVMDetector", (char**)keywords, &pyobj_svmdetector) &&
        pyopencv_to_safe(pyobj_svmdetector, svmdetector, ArgInfo("svmdetector", 0)) )
    {
        ERRWRAP2(_self_->setSVMDetector(svmdetector));
        Py_RETURN_NONE;
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_svmdetector = NULL;
    UMat svmdetector;

    const char* keywords[] = { "svmdetector", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:HOGDescriptor.setSVMDetector", (char**)keywords, &pyobj_svmdetector) &&
        pyopencv_to_safe(pyobj_svmdetector, svmdetector, ArgInfo("svmdetector", 0)) )
    {
        ERRWRAP2(_self_->setSVMDetector(svmdetector));
        Py_RETURN_NONE;
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("setSVMDetector");

    return NULL;
}



// Tables (HOGDescriptor)

static PyGetSetDef pyopencv_HOGDescriptor_getseters[] =
{
    {(char*)"L2HysThreshold", (getter)pyopencv_HOGDescriptor_get_L2HysThreshold, NULL, (char*)"L2HysThreshold", NULL},
    {(char*)"blockSize", (getter)pyopencv_HOGDescriptor_get_blockSize, NULL, (char*)"blockSize", NULL},
    {(char*)"blockStride", (getter)pyopencv_HOGDescriptor_get_blockStride, NULL, (char*)"blockStride", NULL},
    {(char*)"cellSize", (getter)pyopencv_HOGDescriptor_get_cellSize, NULL, (char*)"cellSize", NULL},
    {(char*)"derivAperture", (getter)pyopencv_HOGDescriptor_get_derivAperture, NULL, (char*)"derivAperture", NULL},
    {(char*)"gammaCorrection", (getter)pyopencv_HOGDescriptor_get_gammaCorrection, NULL, (char*)"gammaCorrection", NULL},
    {(char*)"histogramNormType", (getter)pyopencv_HOGDescriptor_get_histogramNormType, NULL, (char*)"histogramNormType", NULL},
    {(char*)"nbins", (getter)pyopencv_HOGDescriptor_get_nbins, NULL, (char*)"nbins", NULL},
    {(char*)"nlevels", (getter)pyopencv_HOGDescriptor_get_nlevels, NULL, (char*)"nlevels", NULL},
    {(char*)"signedGradient", (getter)pyopencv_HOGDescriptor_get_signedGradient, NULL, (char*)"signedGradient", NULL},
    {(char*)"svmDetector", (getter)pyopencv_HOGDescriptor_get_svmDetector, NULL, (char*)"svmDetector", NULL},
    {(char*)"winSigma", (getter)pyopencv_HOGDescriptor_get_winSigma, NULL, (char*)"winSigma", NULL},
    {(char*)"winSize", (getter)pyopencv_HOGDescriptor_get_winSize, NULL, (char*)"winSize", NULL},
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_HOGDescriptor_methods[] =
{
    {"checkDetectorSize", CV_PY_FN_WITH_KW_(pyopencv_cv_HOGDescriptor_checkDetectorSize, 0), "checkDetectorSize() -> retval\n.   @brief Checks if detector size equal to descriptor size."},
    {"compute", CV_PY_FN_WITH_KW_(pyopencv_cv_HOGDescriptor_compute, 0), "compute(img[, winStride[, padding[, locations]]]) -> descriptors\n.   @brief Computes HOG descriptors of given image.\n.       @param img Matrix of the type CV_8U containing an image where HOG features will be calculated.\n.       @param descriptors Matrix of the type CV_32F\n.       @param winStride Window stride. It must be a multiple of block stride.\n.       @param padding Padding\n.       @param locations Vector of Point"},
    {"computeGradient", CV_PY_FN_WITH_KW_(pyopencv_cv_HOGDescriptor_computeGradient, 0), "computeGradient(img, grad, angleOfs[, paddingTL[, paddingBR]]) -> grad, angleOfs\n.   @brief  Computes gradients and quantized gradient orientations.\n.       @param img Matrix contains the image to be computed\n.       @param grad Matrix of type CV_32FC2 contains computed gradients\n.       @param angleOfs Matrix of type CV_8UC2 contains quantized gradient orientations\n.       @param paddingTL Padding from top-left\n.       @param paddingBR Padding from bottom-right"},
    {"detect", CV_PY_FN_WITH_KW_(pyopencv_cv_HOGDescriptor_detect, 0), "detect(img[, hitThreshold[, winStride[, padding[, searchLocations]]]]) -> foundLocations, weights\n.   @brief Performs object detection without a multi-scale window.\n.       @param img Matrix of the type CV_8U or CV_8UC3 containing an image where objects are detected.\n.       @param foundLocations Vector of point where each point contains left-top corner point of detected object boundaries.\n.       @param weights Vector that will contain confidence values for each detected object.\n.       @param hitThreshold Threshold for the distance between features and SVM classifying plane.\n.       Usually it is 0 and should be specified in the detector coefficients (as the last free coefficient).\n.       But if the free coefficient is omitted (which is allowed), you can specify it manually here.\n.       @param winStride Window stride. It must be a multiple of block stride.\n.       @param padding Padding\n.       @param searchLocations Vector of Point includes set of requested locations to be evaluated."},
    {"detectMultiScale", CV_PY_FN_WITH_KW_(pyopencv_cv_HOGDescriptor_detectMultiScale, 0), "detectMultiScale(img[, hitThreshold[, winStride[, padding[, scale[, groupThreshold[, useMeanshiftGrouping]]]]]]) -> foundLocations, foundWeights\n.   @brief Detects objects of different sizes in the input image. The detected objects are returned as a list\n.       of rectangles.\n.       @param img Matrix of the type CV_8U or CV_8UC3 containing an image where objects are detected.\n.       @param foundLocations Vector of rectangles where each rectangle contains the detected object.\n.       @param foundWeights Vector that will contain confidence values for each detected object.\n.       @param hitThreshold Threshold for the distance between features and SVM classifying plane.\n.       Usually it is 0 and should be specified in the detector coefficients (as the last free coefficient).\n.       But if the free coefficient is omitted (which is allowed), you can specify it manually here.\n.       @param winStride Window stride. It must be a multiple of block stride.\n.       @param padding Padding\n.       @param scale Coefficient of the detection window increase.\n.       @param groupThreshold Coefficient to regulate the similarity threshold. When detected, some objects can be covered\n.       by many rectangles. 0 means not to perform grouping.\n.       @param useMeanshiftGrouping indicates grouping algorithm"},
    {"getDaimlerPeopleDetector", CV_PY_FN_WITH_KW_(pyopencv_cv_HOGDescriptor_getDaimlerPeopleDetector_static, METH_STATIC), "getDaimlerPeopleDetector() -> retval\n.   @brief Returns coefficients of the classifier trained for people detection (for 48x96 windows)."},
    {"getDefaultPeopleDetector", CV_PY_FN_WITH_KW_(pyopencv_cv_HOGDescriptor_getDefaultPeopleDetector_static, METH_STATIC), "getDefaultPeopleDetector() -> retval\n.   @brief Returns coefficients of the classifier trained for people detection (for 64x128 windows)."},
    {"getDescriptorSize", CV_PY_FN_WITH_KW_(pyopencv_cv_HOGDescriptor_getDescriptorSize, 0), "getDescriptorSize() -> retval\n.   @brief Returns the number of coefficients required for the classification."},
    {"getWinSigma", CV_PY_FN_WITH_KW_(pyopencv_cv_HOGDescriptor_getWinSigma, 0), "getWinSigma() -> retval\n.   @brief Returns winSigma value"},
    {"load", CV_PY_FN_WITH_KW_(pyopencv_cv_HOGDescriptor_load, 0), "load(filename[, objname]) -> retval\n.   @brief loads HOGDescriptor parameters and coefficients for the linear SVM classifier from a file\n.       @param filename Name of the file to read.\n.       @param objname The optional name of the node to read (if empty, the first top-level node will be used)."},
    {"save", CV_PY_FN_WITH_KW_(pyopencv_cv_HOGDescriptor_save, 0), "save(filename[, objname]) -> None\n.   @brief saves HOGDescriptor parameters and coefficients for the linear SVM classifier to a file\n.       @param filename File name\n.       @param objname Object name"},
    {"setSVMDetector", CV_PY_FN_WITH_KW_(pyopencv_cv_HOGDescriptor_setSVMDetector, 0), "setSVMDetector(svmdetector) -> None\n.   @brief Sets coefficients for the linear SVM classifier.\n.       @param svmdetector coefficients for the linear SVM classifier."},

    {NULL,          NULL}
};

// Converter (HOGDescriptor)

template<>
struct PyOpenCV_Converter< Ptr<cv::HOGDescriptor> >
{
    static PyObject* from(const Ptr<cv::HOGDescriptor>& r)
    {
        return pyopencv_HOGDescriptor_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::HOGDescriptor>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::HOGDescriptor> * dst_;
        if (pyopencv_HOGDescriptor_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::HOGDescriptor> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// HausdorffDistanceExtractor (Generic)
//================================================================================

// GetSet (HausdorffDistanceExtractor)



// Methods (HausdorffDistanceExtractor)

static PyObject* pyopencv_cv_HausdorffDistanceExtractor_getDistanceFlag(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::HausdorffDistanceExtractor> * self1 = 0;
    if (!pyopencv_HausdorffDistanceExtractor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'HausdorffDistanceExtractor' or its derivative)");
    Ptr<cv::HausdorffDistanceExtractor> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getDistanceFlag());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_HausdorffDistanceExtractor_getRankProportion(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::HausdorffDistanceExtractor> * self1 = 0;
    if (!pyopencv_HausdorffDistanceExtractor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'HausdorffDistanceExtractor' or its derivative)");
    Ptr<cv::HausdorffDistanceExtractor> _self_ = *(self1);
    float retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getRankProportion());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_HausdorffDistanceExtractor_setDistanceFlag(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::HausdorffDistanceExtractor> * self1 = 0;
    if (!pyopencv_HausdorffDistanceExtractor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'HausdorffDistanceExtractor' or its derivative)");
    Ptr<cv::HausdorffDistanceExtractor> _self_ = *(self1);
    PyObject* pyobj_distanceFlag = NULL;
    int distanceFlag=0;

    const char* keywords[] = { "distanceFlag", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:HausdorffDistanceExtractor.setDistanceFlag", (char**)keywords, &pyobj_distanceFlag) &&
        pyopencv_to_safe(pyobj_distanceFlag, distanceFlag, ArgInfo("distanceFlag", 0)) )
    {
        ERRWRAP2(_self_->setDistanceFlag(distanceFlag));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_HausdorffDistanceExtractor_setRankProportion(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::HausdorffDistanceExtractor> * self1 = 0;
    if (!pyopencv_HausdorffDistanceExtractor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'HausdorffDistanceExtractor' or its derivative)");
    Ptr<cv::HausdorffDistanceExtractor> _self_ = *(self1);
    PyObject* pyobj_rankProportion = NULL;
    float rankProportion=0.f;

    const char* keywords[] = { "rankProportion", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:HausdorffDistanceExtractor.setRankProportion", (char**)keywords, &pyobj_rankProportion) &&
        pyopencv_to_safe(pyobj_rankProportion, rankProportion, ArgInfo("rankProportion", 0)) )
    {
        ERRWRAP2(_self_->setRankProportion(rankProportion));
        Py_RETURN_NONE;
    }

    return NULL;
}



// Tables (HausdorffDistanceExtractor)

static PyGetSetDef pyopencv_HausdorffDistanceExtractor_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_HausdorffDistanceExtractor_methods[] =
{
    {"getDistanceFlag", CV_PY_FN_WITH_KW_(pyopencv_cv_HausdorffDistanceExtractor_getDistanceFlag, 0), "getDistanceFlag() -> retval\n."},
    {"getRankProportion", CV_PY_FN_WITH_KW_(pyopencv_cv_HausdorffDistanceExtractor_getRankProportion, 0), "getRankProportion() -> retval\n."},
    {"setDistanceFlag", CV_PY_FN_WITH_KW_(pyopencv_cv_HausdorffDistanceExtractor_setDistanceFlag, 0), "setDistanceFlag(distanceFlag) -> None\n.   @brief Set the norm used to compute the Hausdorff value between two shapes. It can be L1 or L2 norm.\n.   \n.       @param distanceFlag Flag indicating which norm is used to compute the Hausdorff distance\n.       (NORM_L1, NORM_L2)."},
    {"setRankProportion", CV_PY_FN_WITH_KW_(pyopencv_cv_HausdorffDistanceExtractor_setRankProportion, 0), "setRankProportion(rankProportion) -> None\n.   @brief This method sets the rank proportion (or fractional value) that establish the Kth ranked value of\n.       the partial Hausdorff distance. Experimentally had been shown that 0.6 is a good value to compare\n.       shapes.\n.   \n.       @param rankProportion fractional value (between 0 and 1)."},

    {NULL,          NULL}
};

// Converter (HausdorffDistanceExtractor)

template<>
struct PyOpenCV_Converter< Ptr<cv::HausdorffDistanceExtractor> >
{
    static PyObject* from(const Ptr<cv::HausdorffDistanceExtractor>& r)
    {
        return pyopencv_HausdorffDistanceExtractor_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::HausdorffDistanceExtractor>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::HausdorffDistanceExtractor> * dst_;
        if (pyopencv_HausdorffDistanceExtractor_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::HausdorffDistanceExtractor> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// HistogramCostExtractor (Generic)
//================================================================================

// GetSet (HistogramCostExtractor)



// Methods (HistogramCostExtractor)

static PyObject* pyopencv_cv_HistogramCostExtractor_buildCostMatrix(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::HistogramCostExtractor> * self1 = 0;
    if (!pyopencv_HistogramCostExtractor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'HistogramCostExtractor' or its derivative)");
    Ptr<cv::HistogramCostExtractor> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_descriptors1 = NULL;
    Mat descriptors1;
    PyObject* pyobj_descriptors2 = NULL;
    Mat descriptors2;
    PyObject* pyobj_costMatrix = NULL;
    Mat costMatrix;

    const char* keywords[] = { "descriptors1", "descriptors2", "costMatrix", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO|O:HistogramCostExtractor.buildCostMatrix", (char**)keywords, &pyobj_descriptors1, &pyobj_descriptors2, &pyobj_costMatrix) &&
        pyopencv_to_safe(pyobj_descriptors1, descriptors1, ArgInfo("descriptors1", 0)) &&
        pyopencv_to_safe(pyobj_descriptors2, descriptors2, ArgInfo("descriptors2", 0)) &&
        pyopencv_to_safe(pyobj_costMatrix, costMatrix, ArgInfo("costMatrix", 1)) )
    {
        ERRWRAP2(_self_->buildCostMatrix(descriptors1, descriptors2, costMatrix));
        return pyopencv_from(costMatrix);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_descriptors1 = NULL;
    UMat descriptors1;
    PyObject* pyobj_descriptors2 = NULL;
    UMat descriptors2;
    PyObject* pyobj_costMatrix = NULL;
    UMat costMatrix;

    const char* keywords[] = { "descriptors1", "descriptors2", "costMatrix", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO|O:HistogramCostExtractor.buildCostMatrix", (char**)keywords, &pyobj_descriptors1, &pyobj_descriptors2, &pyobj_costMatrix) &&
        pyopencv_to_safe(pyobj_descriptors1, descriptors1, ArgInfo("descriptors1", 0)) &&
        pyopencv_to_safe(pyobj_descriptors2, descriptors2, ArgInfo("descriptors2", 0)) &&
        pyopencv_to_safe(pyobj_costMatrix, costMatrix, ArgInfo("costMatrix", 1)) )
    {
        ERRWRAP2(_self_->buildCostMatrix(descriptors1, descriptors2, costMatrix));
        return pyopencv_from(costMatrix);
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("buildCostMatrix");

    return NULL;
}

static PyObject* pyopencv_cv_HistogramCostExtractor_getDefaultCost(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::HistogramCostExtractor> * self1 = 0;
    if (!pyopencv_HistogramCostExtractor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'HistogramCostExtractor' or its derivative)");
    Ptr<cv::HistogramCostExtractor> _self_ = *(self1);
    float retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getDefaultCost());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_HistogramCostExtractor_getNDummies(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::HistogramCostExtractor> * self1 = 0;
    if (!pyopencv_HistogramCostExtractor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'HistogramCostExtractor' or its derivative)");
    Ptr<cv::HistogramCostExtractor> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getNDummies());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_HistogramCostExtractor_setDefaultCost(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::HistogramCostExtractor> * self1 = 0;
    if (!pyopencv_HistogramCostExtractor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'HistogramCostExtractor' or its derivative)");
    Ptr<cv::HistogramCostExtractor> _self_ = *(self1);
    PyObject* pyobj_defaultCost = NULL;
    float defaultCost=0.f;

    const char* keywords[] = { "defaultCost", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:HistogramCostExtractor.setDefaultCost", (char**)keywords, &pyobj_defaultCost) &&
        pyopencv_to_safe(pyobj_defaultCost, defaultCost, ArgInfo("defaultCost", 0)) )
    {
        ERRWRAP2(_self_->setDefaultCost(defaultCost));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_HistogramCostExtractor_setNDummies(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::HistogramCostExtractor> * self1 = 0;
    if (!pyopencv_HistogramCostExtractor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'HistogramCostExtractor' or its derivative)");
    Ptr<cv::HistogramCostExtractor> _self_ = *(self1);
    PyObject* pyobj_nDummies = NULL;
    int nDummies=0;

    const char* keywords[] = { "nDummies", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:HistogramCostExtractor.setNDummies", (char**)keywords, &pyobj_nDummies) &&
        pyopencv_to_safe(pyobj_nDummies, nDummies, ArgInfo("nDummies", 0)) )
    {
        ERRWRAP2(_self_->setNDummies(nDummies));
        Py_RETURN_NONE;
    }

    return NULL;
}



// Tables (HistogramCostExtractor)

static PyGetSetDef pyopencv_HistogramCostExtractor_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_HistogramCostExtractor_methods[] =
{
    {"buildCostMatrix", CV_PY_FN_WITH_KW_(pyopencv_cv_HistogramCostExtractor_buildCostMatrix, 0), "buildCostMatrix(descriptors1, descriptors2[, costMatrix]) -> costMatrix\n."},
    {"getDefaultCost", CV_PY_FN_WITH_KW_(pyopencv_cv_HistogramCostExtractor_getDefaultCost, 0), "getDefaultCost() -> retval\n."},
    {"getNDummies", CV_PY_FN_WITH_KW_(pyopencv_cv_HistogramCostExtractor_getNDummies, 0), "getNDummies() -> retval\n."},
    {"setDefaultCost", CV_PY_FN_WITH_KW_(pyopencv_cv_HistogramCostExtractor_setDefaultCost, 0), "setDefaultCost(defaultCost) -> None\n."},
    {"setNDummies", CV_PY_FN_WITH_KW_(pyopencv_cv_HistogramCostExtractor_setNDummies, 0), "setNDummies(nDummies) -> None\n."},

    {NULL,          NULL}
};

// Converter (HistogramCostExtractor)

template<>
struct PyOpenCV_Converter< Ptr<cv::HistogramCostExtractor> >
{
    static PyObject* from(const Ptr<cv::HistogramCostExtractor>& r)
    {
        return pyopencv_HistogramCostExtractor_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::HistogramCostExtractor>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::HistogramCostExtractor> * dst_;
        if (pyopencv_HistogramCostExtractor_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::HistogramCostExtractor> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// KAZE (Generic)
//================================================================================

// GetSet (KAZE)



// Methods (KAZE)

static PyObject* pyopencv_cv_KAZE_create_static(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    PyObject* pyobj_extended = NULL;
    bool extended=false;
    PyObject* pyobj_upright = NULL;
    bool upright=false;
    PyObject* pyobj_threshold = NULL;
    float threshold=0.001f;
    PyObject* pyobj_nOctaves = NULL;
    int nOctaves=4;
    PyObject* pyobj_nOctaveLayers = NULL;
    int nOctaveLayers=4;
    PyObject* pyobj_diffusivity = NULL;
    KAZE_DiffusivityType diffusivity=KAZE::DIFF_PM_G2;
    Ptr<KAZE> retval;

    const char* keywords[] = { "extended", "upright", "threshold", "nOctaves", "nOctaveLayers", "diffusivity", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "|OOOOOO:KAZE.create", (char**)keywords, &pyobj_extended, &pyobj_upright, &pyobj_threshold, &pyobj_nOctaves, &pyobj_nOctaveLayers, &pyobj_diffusivity) &&
        pyopencv_to_safe(pyobj_extended, extended, ArgInfo("extended", 0)) &&
        pyopencv_to_safe(pyobj_upright, upright, ArgInfo("upright", 0)) &&
        pyopencv_to_safe(pyobj_threshold, threshold, ArgInfo("threshold", 0)) &&
        pyopencv_to_safe(pyobj_nOctaves, nOctaves, ArgInfo("nOctaves", 0)) &&
        pyopencv_to_safe(pyobj_nOctaveLayers, nOctaveLayers, ArgInfo("nOctaveLayers", 0)) &&
        pyopencv_to_safe(pyobj_diffusivity, diffusivity, ArgInfo("diffusivity", 0)) )
    {
        ERRWRAP2(retval = cv::KAZE::create(extended, upright, threshold, nOctaves, nOctaveLayers, diffusivity));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_KAZE_getDefaultName(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::KAZE> * self1 = 0;
    if (!pyopencv_KAZE_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'KAZE' or its derivative)");
    Ptr<cv::KAZE> _self_ = *(self1);
    String retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getDefaultName());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_KAZE_getDiffusivity(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::KAZE> * self1 = 0;
    if (!pyopencv_KAZE_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'KAZE' or its derivative)");
    Ptr<cv::KAZE> _self_ = *(self1);
    KAZE::DiffusivityType retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getDiffusivity());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_KAZE_getExtended(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::KAZE> * self1 = 0;
    if (!pyopencv_KAZE_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'KAZE' or its derivative)");
    Ptr<cv::KAZE> _self_ = *(self1);
    bool retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getExtended());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_KAZE_getNOctaveLayers(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::KAZE> * self1 = 0;
    if (!pyopencv_KAZE_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'KAZE' or its derivative)");
    Ptr<cv::KAZE> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getNOctaveLayers());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_KAZE_getNOctaves(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::KAZE> * self1 = 0;
    if (!pyopencv_KAZE_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'KAZE' or its derivative)");
    Ptr<cv::KAZE> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getNOctaves());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_KAZE_getThreshold(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::KAZE> * self1 = 0;
    if (!pyopencv_KAZE_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'KAZE' or its derivative)");
    Ptr<cv::KAZE> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getThreshold());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_KAZE_getUpright(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::KAZE> * self1 = 0;
    if (!pyopencv_KAZE_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'KAZE' or its derivative)");
    Ptr<cv::KAZE> _self_ = *(self1);
    bool retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getUpright());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_KAZE_setDiffusivity(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::KAZE> * self1 = 0;
    if (!pyopencv_KAZE_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'KAZE' or its derivative)");
    Ptr<cv::KAZE> _self_ = *(self1);
    PyObject* pyobj_diff = NULL;
    KAZE_DiffusivityType diff=static_cast<KAZE_DiffusivityType>(0);

    const char* keywords[] = { "diff", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:KAZE.setDiffusivity", (char**)keywords, &pyobj_diff) &&
        pyopencv_to_safe(pyobj_diff, diff, ArgInfo("diff", 0)) )
    {
        ERRWRAP2(_self_->setDiffusivity(diff));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_KAZE_setExtended(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::KAZE> * self1 = 0;
    if (!pyopencv_KAZE_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'KAZE' or its derivative)");
    Ptr<cv::KAZE> _self_ = *(self1);
    PyObject* pyobj_extended = NULL;
    bool extended=0;

    const char* keywords[] = { "extended", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:KAZE.setExtended", (char**)keywords, &pyobj_extended) &&
        pyopencv_to_safe(pyobj_extended, extended, ArgInfo("extended", 0)) )
    {
        ERRWRAP2(_self_->setExtended(extended));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_KAZE_setNOctaveLayers(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::KAZE> * self1 = 0;
    if (!pyopencv_KAZE_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'KAZE' or its derivative)");
    Ptr<cv::KAZE> _self_ = *(self1);
    PyObject* pyobj_octaveLayers = NULL;
    int octaveLayers=0;

    const char* keywords[] = { "octaveLayers", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:KAZE.setNOctaveLayers", (char**)keywords, &pyobj_octaveLayers) &&
        pyopencv_to_safe(pyobj_octaveLayers, octaveLayers, ArgInfo("octaveLayers", 0)) )
    {
        ERRWRAP2(_self_->setNOctaveLayers(octaveLayers));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_KAZE_setNOctaves(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::KAZE> * self1 = 0;
    if (!pyopencv_KAZE_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'KAZE' or its derivative)");
    Ptr<cv::KAZE> _self_ = *(self1);
    PyObject* pyobj_octaves = NULL;
    int octaves=0;

    const char* keywords[] = { "octaves", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:KAZE.setNOctaves", (char**)keywords, &pyobj_octaves) &&
        pyopencv_to_safe(pyobj_octaves, octaves, ArgInfo("octaves", 0)) )
    {
        ERRWRAP2(_self_->setNOctaves(octaves));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_KAZE_setThreshold(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::KAZE> * self1 = 0;
    if (!pyopencv_KAZE_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'KAZE' or its derivative)");
    Ptr<cv::KAZE> _self_ = *(self1);
    PyObject* pyobj_threshold = NULL;
    double threshold=0;

    const char* keywords[] = { "threshold", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:KAZE.setThreshold", (char**)keywords, &pyobj_threshold) &&
        pyopencv_to_safe(pyobj_threshold, threshold, ArgInfo("threshold", 0)) )
    {
        ERRWRAP2(_self_->setThreshold(threshold));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_KAZE_setUpright(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::KAZE> * self1 = 0;
    if (!pyopencv_KAZE_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'KAZE' or its derivative)");
    Ptr<cv::KAZE> _self_ = *(self1);
    PyObject* pyobj_upright = NULL;
    bool upright=0;

    const char* keywords[] = { "upright", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:KAZE.setUpright", (char**)keywords, &pyobj_upright) &&
        pyopencv_to_safe(pyobj_upright, upright, ArgInfo("upright", 0)) )
    {
        ERRWRAP2(_self_->setUpright(upright));
        Py_RETURN_NONE;
    }

    return NULL;
}



// Tables (KAZE)

static PyGetSetDef pyopencv_KAZE_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_KAZE_methods[] =
{
    {"create", CV_PY_FN_WITH_KW_(pyopencv_cv_KAZE_create_static, METH_STATIC), "create([, extended[, upright[, threshold[, nOctaves[, nOctaveLayers[, diffusivity]]]]]]) -> retval\n.   @brief The KAZE constructor\n.   \n.       @param extended Set to enable extraction of extended (128-byte) descriptor.\n.       @param upright Set to enable use of upright descriptors (non rotation-invariant).\n.       @param threshold Detector response threshold to accept point\n.       @param nOctaves Maximum octave evolution of the image\n.       @param nOctaveLayers Default number of sublevels per scale level\n.       @param diffusivity Diffusivity type. DIFF_PM_G1, DIFF_PM_G2, DIFF_WEICKERT or\n.       DIFF_CHARBONNIER"},
    {"getDefaultName", CV_PY_FN_WITH_KW_(pyopencv_cv_KAZE_getDefaultName, 0), "getDefaultName() -> retval\n."},
    {"getDiffusivity", CV_PY_FN_WITH_KW_(pyopencv_cv_KAZE_getDiffusivity, 0), "getDiffusivity() -> retval\n."},
    {"getExtended", CV_PY_FN_WITH_KW_(pyopencv_cv_KAZE_getExtended, 0), "getExtended() -> retval\n."},
    {"getNOctaveLayers", CV_PY_FN_WITH_KW_(pyopencv_cv_KAZE_getNOctaveLayers, 0), "getNOctaveLayers() -> retval\n."},
    {"getNOctaves", CV_PY_FN_WITH_KW_(pyopencv_cv_KAZE_getNOctaves, 0), "getNOctaves() -> retval\n."},
    {"getThreshold", CV_PY_FN_WITH_KW_(pyopencv_cv_KAZE_getThreshold, 0), "getThreshold() -> retval\n."},
    {"getUpright", CV_PY_FN_WITH_KW_(pyopencv_cv_KAZE_getUpright, 0), "getUpright() -> retval\n."},
    {"setDiffusivity", CV_PY_FN_WITH_KW_(pyopencv_cv_KAZE_setDiffusivity, 0), "setDiffusivity(diff) -> None\n."},
    {"setExtended", CV_PY_FN_WITH_KW_(pyopencv_cv_KAZE_setExtended, 0), "setExtended(extended) -> None\n."},
    {"setNOctaveLayers", CV_PY_FN_WITH_KW_(pyopencv_cv_KAZE_setNOctaveLayers, 0), "setNOctaveLayers(octaveLayers) -> None\n."},
    {"setNOctaves", CV_PY_FN_WITH_KW_(pyopencv_cv_KAZE_setNOctaves, 0), "setNOctaves(octaves) -> None\n."},
    {"setThreshold", CV_PY_FN_WITH_KW_(pyopencv_cv_KAZE_setThreshold, 0), "setThreshold(threshold) -> None\n."},
    {"setUpright", CV_PY_FN_WITH_KW_(pyopencv_cv_KAZE_setUpright, 0), "setUpright(upright) -> None\n."},

    {NULL,          NULL}
};

// Converter (KAZE)

template<>
struct PyOpenCV_Converter< Ptr<cv::KAZE> >
{
    static PyObject* from(const Ptr<cv::KAZE>& r)
    {
        return pyopencv_KAZE_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::KAZE>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::KAZE> * dst_;
        if (pyopencv_KAZE_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::KAZE> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// KalmanFilter (Generic)
//================================================================================

// GetSet (KalmanFilter)


static PyObject* pyopencv_KalmanFilter_get_controlMatrix(pyopencv_KalmanFilter_t* p, void *closure)
{
    return pyopencv_from(p->v->controlMatrix);
}

static int pyopencv_KalmanFilter_set_controlMatrix(pyopencv_KalmanFilter_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the controlMatrix attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v->controlMatrix, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_KalmanFilter_get_errorCovPost(pyopencv_KalmanFilter_t* p, void *closure)
{
    return pyopencv_from(p->v->errorCovPost);
}

static int pyopencv_KalmanFilter_set_errorCovPost(pyopencv_KalmanFilter_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the errorCovPost attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v->errorCovPost, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_KalmanFilter_get_errorCovPre(pyopencv_KalmanFilter_t* p, void *closure)
{
    return pyopencv_from(p->v->errorCovPre);
}

static int pyopencv_KalmanFilter_set_errorCovPre(pyopencv_KalmanFilter_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the errorCovPre attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v->errorCovPre, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_KalmanFilter_get_gain(pyopencv_KalmanFilter_t* p, void *closure)
{
    return pyopencv_from(p->v->gain);
}

static int pyopencv_KalmanFilter_set_gain(pyopencv_KalmanFilter_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the gain attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v->gain, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_KalmanFilter_get_measurementMatrix(pyopencv_KalmanFilter_t* p, void *closure)
{
    return pyopencv_from(p->v->measurementMatrix);
}

static int pyopencv_KalmanFilter_set_measurementMatrix(pyopencv_KalmanFilter_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the measurementMatrix attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v->measurementMatrix, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_KalmanFilter_get_measurementNoiseCov(pyopencv_KalmanFilter_t* p, void *closure)
{
    return pyopencv_from(p->v->measurementNoiseCov);
}

static int pyopencv_KalmanFilter_set_measurementNoiseCov(pyopencv_KalmanFilter_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the measurementNoiseCov attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v->measurementNoiseCov, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_KalmanFilter_get_processNoiseCov(pyopencv_KalmanFilter_t* p, void *closure)
{
    return pyopencv_from(p->v->processNoiseCov);
}

static int pyopencv_KalmanFilter_set_processNoiseCov(pyopencv_KalmanFilter_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the processNoiseCov attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v->processNoiseCov, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_KalmanFilter_get_statePost(pyopencv_KalmanFilter_t* p, void *closure)
{
    return pyopencv_from(p->v->statePost);
}

static int pyopencv_KalmanFilter_set_statePost(pyopencv_KalmanFilter_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the statePost attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v->statePost, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_KalmanFilter_get_statePre(pyopencv_KalmanFilter_t* p, void *closure)
{
    return pyopencv_from(p->v->statePre);
}

static int pyopencv_KalmanFilter_set_statePre(pyopencv_KalmanFilter_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the statePre attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v->statePre, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_KalmanFilter_get_transitionMatrix(pyopencv_KalmanFilter_t* p, void *closure)
{
    return pyopencv_from(p->v->transitionMatrix);
}

static int pyopencv_KalmanFilter_set_transitionMatrix(pyopencv_KalmanFilter_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the transitionMatrix attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v->transitionMatrix, ArgInfo("value", 0)) ? 0 : -1;
}


// Methods (KalmanFilter)

static int pyopencv_cv_KalmanFilter_KalmanFilter(pyopencv_KalmanFilter_t* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    pyPrepareArgumentConversionErrorsStorage(2);

    {

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        new (&(self->v)) Ptr<cv::KalmanFilter>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::KalmanFilter()));
        return 0;
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_dynamParams = NULL;
    int dynamParams=0;
    PyObject* pyobj_measureParams = NULL;
    int measureParams=0;
    PyObject* pyobj_controlParams = NULL;
    int controlParams=0;
    PyObject* pyobj_type = NULL;
    int type=CV_32F;

    const char* keywords[] = { "dynamParams", "measureParams", "controlParams", "type", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO|OO:KalmanFilter", (char**)keywords, &pyobj_dynamParams, &pyobj_measureParams, &pyobj_controlParams, &pyobj_type) &&
        pyopencv_to_safe(pyobj_dynamParams, dynamParams, ArgInfo("dynamParams", 0)) &&
        pyopencv_to_safe(pyobj_measureParams, measureParams, ArgInfo("measureParams", 0)) &&
        pyopencv_to_safe(pyobj_controlParams, controlParams, ArgInfo("controlParams", 0)) &&
        pyopencv_to_safe(pyobj_type, type, ArgInfo("type", 0)) )
    {
        new (&(self->v)) Ptr<cv::KalmanFilter>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::KalmanFilter(dynamParams, measureParams, controlParams, type)));
        return 0;
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("KalmanFilter");

    return -1;
}

static PyObject* pyopencv_cv_KalmanFilter_correct(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::KalmanFilter> * self1 = 0;
    if (!pyopencv_KalmanFilter_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'KalmanFilter' or its derivative)");
    Ptr<cv::KalmanFilter> _self_ = *(self1);
    PyObject* pyobj_measurement = NULL;
    Mat measurement;
    Mat retval;

    const char* keywords[] = { "measurement", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:KalmanFilter.correct", (char**)keywords, &pyobj_measurement) &&
        pyopencv_to_safe(pyobj_measurement, measurement, ArgInfo("measurement", 0)) )
    {
        ERRWRAP2(retval = _self_->correct(measurement));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_KalmanFilter_predict(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::KalmanFilter> * self1 = 0;
    if (!pyopencv_KalmanFilter_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'KalmanFilter' or its derivative)");
    Ptr<cv::KalmanFilter> _self_ = *(self1);
    PyObject* pyobj_control = NULL;
    Mat control;
    Mat retval;

    const char* keywords[] = { "control", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "|O:KalmanFilter.predict", (char**)keywords, &pyobj_control) &&
        pyopencv_to_safe(pyobj_control, control, ArgInfo("control", 0)) )
    {
        ERRWRAP2(retval = _self_->predict(control));
        return pyopencv_from(retval);
    }

    return NULL;
}



// Tables (KalmanFilter)

static PyGetSetDef pyopencv_KalmanFilter_getseters[] =
{
    {(char*)"controlMatrix", (getter)pyopencv_KalmanFilter_get_controlMatrix, (setter)pyopencv_KalmanFilter_set_controlMatrix, (char*)"controlMatrix", NULL},
    {(char*)"errorCovPost", (getter)pyopencv_KalmanFilter_get_errorCovPost, (setter)pyopencv_KalmanFilter_set_errorCovPost, (char*)"errorCovPost", NULL},
    {(char*)"errorCovPre", (getter)pyopencv_KalmanFilter_get_errorCovPre, (setter)pyopencv_KalmanFilter_set_errorCovPre, (char*)"errorCovPre", NULL},
    {(char*)"gain", (getter)pyopencv_KalmanFilter_get_gain, (setter)pyopencv_KalmanFilter_set_gain, (char*)"gain", NULL},
    {(char*)"measurementMatrix", (getter)pyopencv_KalmanFilter_get_measurementMatrix, (setter)pyopencv_KalmanFilter_set_measurementMatrix, (char*)"measurementMatrix", NULL},
    {(char*)"measurementNoiseCov", (getter)pyopencv_KalmanFilter_get_measurementNoiseCov, (setter)pyopencv_KalmanFilter_set_measurementNoiseCov, (char*)"measurementNoiseCov", NULL},
    {(char*)"processNoiseCov", (getter)pyopencv_KalmanFilter_get_processNoiseCov, (setter)pyopencv_KalmanFilter_set_processNoiseCov, (char*)"processNoiseCov", NULL},
    {(char*)"statePost", (getter)pyopencv_KalmanFilter_get_statePost, (setter)pyopencv_KalmanFilter_set_statePost, (char*)"statePost", NULL},
    {(char*)"statePre", (getter)pyopencv_KalmanFilter_get_statePre, (setter)pyopencv_KalmanFilter_set_statePre, (char*)"statePre", NULL},
    {(char*)"transitionMatrix", (getter)pyopencv_KalmanFilter_get_transitionMatrix, (setter)pyopencv_KalmanFilter_set_transitionMatrix, (char*)"transitionMatrix", NULL},
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_KalmanFilter_methods[] =
{
    {"correct", CV_PY_FN_WITH_KW_(pyopencv_cv_KalmanFilter_correct, 0), "correct(measurement) -> retval\n.   @brief Updates the predicted state from the measurement.\n.   \n.       @param measurement The measured system parameters"},
    {"predict", CV_PY_FN_WITH_KW_(pyopencv_cv_KalmanFilter_predict, 0), "predict([, control]) -> retval\n.   @brief Computes a predicted state.\n.   \n.       @param control The optional input control"},

    {NULL,          NULL}
};

// Converter (KalmanFilter)

template<>
struct PyOpenCV_Converter< Ptr<cv::KalmanFilter> >
{
    static PyObject* from(const Ptr<cv::KalmanFilter>& r)
    {
        return pyopencv_KalmanFilter_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::KalmanFilter>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::KalmanFilter> * dst_;
        if (pyopencv_KalmanFilter_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::KalmanFilter> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// KeyPoint (Generic)
//================================================================================

// GetSet (KeyPoint)


static PyObject* pyopencv_KeyPoint_get_angle(pyopencv_KeyPoint_t* p, void *closure)
{
    return pyopencv_from(p->v.angle);
}

static int pyopencv_KeyPoint_set_angle(pyopencv_KeyPoint_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the angle attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.angle, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_KeyPoint_get_class_id(pyopencv_KeyPoint_t* p, void *closure)
{
    return pyopencv_from(p->v.class_id);
}

static int pyopencv_KeyPoint_set_class_id(pyopencv_KeyPoint_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the class_id attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.class_id, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_KeyPoint_get_octave(pyopencv_KeyPoint_t* p, void *closure)
{
    return pyopencv_from(p->v.octave);
}

static int pyopencv_KeyPoint_set_octave(pyopencv_KeyPoint_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the octave attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.octave, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_KeyPoint_get_pt(pyopencv_KeyPoint_t* p, void *closure)
{
    return pyopencv_from(p->v.pt);
}

static int pyopencv_KeyPoint_set_pt(pyopencv_KeyPoint_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the pt attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.pt, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_KeyPoint_get_response(pyopencv_KeyPoint_t* p, void *closure)
{
    return pyopencv_from(p->v.response);
}

static int pyopencv_KeyPoint_set_response(pyopencv_KeyPoint_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the response attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.response, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_KeyPoint_get_size(pyopencv_KeyPoint_t* p, void *closure)
{
    return pyopencv_from(p->v.size);
}

static int pyopencv_KeyPoint_set_size(pyopencv_KeyPoint_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the size attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.size, ArgInfo("value", 0)) ? 0 : -1;
}


// Methods (KeyPoint)

static int pyopencv_cv_KeyPoint_KeyPoint(pyopencv_KeyPoint_t* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    pyPrepareArgumentConversionErrorsStorage(2);

    {

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        if(self) ERRWRAP2(new (&(self->v)) cv::KeyPoint());
        return 0;
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_x = NULL;
    float x=0.f;
    PyObject* pyobj_y = NULL;
    float y=0.f;
    PyObject* pyobj_size = NULL;
    float size=0.f;
    PyObject* pyobj_angle = NULL;
    float angle=-1;
    PyObject* pyobj_response = NULL;
    float response=0;
    PyObject* pyobj_octave = NULL;
    int octave=0;
    PyObject* pyobj_class_id = NULL;
    int class_id=-1;

    const char* keywords[] = { "x", "y", "size", "angle", "response", "octave", "class_id", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOO|OOOO:KeyPoint", (char**)keywords, &pyobj_x, &pyobj_y, &pyobj_size, &pyobj_angle, &pyobj_response, &pyobj_octave, &pyobj_class_id) &&
        pyopencv_to_safe(pyobj_x, x, ArgInfo("x", 0)) &&
        pyopencv_to_safe(pyobj_y, y, ArgInfo("y", 0)) &&
        pyopencv_to_safe(pyobj_size, size, ArgInfo("size", 0)) &&
        pyopencv_to_safe(pyobj_angle, angle, ArgInfo("angle", 0)) &&
        pyopencv_to_safe(pyobj_response, response, ArgInfo("response", 0)) &&
        pyopencv_to_safe(pyobj_octave, octave, ArgInfo("octave", 0)) &&
        pyopencv_to_safe(pyobj_class_id, class_id, ArgInfo("class_id", 0)) )
    {
        if(self) ERRWRAP2(new (&(self->v)) cv::KeyPoint(x, y, size, angle, response, octave, class_id));
        return 0;
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("KeyPoint");

    return -1;
}

static PyObject* pyopencv_cv_KeyPoint_convert_static(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_keypoints = NULL;
    vector_KeyPoint keypoints;
    vector_Point2f points2f;
    PyObject* pyobj_keypointIndexes = NULL;
    vector_int keypointIndexes=std::vector<int>();

    const char* keywords[] = { "keypoints", "keypointIndexes", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|O:KeyPoint.convert", (char**)keywords, &pyobj_keypoints, &pyobj_keypointIndexes) &&
        pyopencv_to_safe(pyobj_keypoints, keypoints, ArgInfo("keypoints", 0)) &&
        pyopencv_to_safe(pyobj_keypointIndexes, keypointIndexes, ArgInfo("keypointIndexes", 0)) )
    {
        ERRWRAP2(cv::KeyPoint::convert(keypoints, points2f, keypointIndexes));
        return pyopencv_from(points2f);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_points2f = NULL;
    vector_Point2f points2f;
    vector_KeyPoint keypoints;
    PyObject* pyobj_size = NULL;
    float size=1;
    PyObject* pyobj_response = NULL;
    float response=1;
    PyObject* pyobj_octave = NULL;
    int octave=0;
    PyObject* pyobj_class_id = NULL;
    int class_id=-1;

    const char* keywords[] = { "points2f", "size", "response", "octave", "class_id", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|OOOO:KeyPoint.convert", (char**)keywords, &pyobj_points2f, &pyobj_size, &pyobj_response, &pyobj_octave, &pyobj_class_id) &&
        pyopencv_to_safe(pyobj_points2f, points2f, ArgInfo("points2f", 0)) &&
        pyopencv_to_safe(pyobj_size, size, ArgInfo("size", 0)) &&
        pyopencv_to_safe(pyobj_response, response, ArgInfo("response", 0)) &&
        pyopencv_to_safe(pyobj_octave, octave, ArgInfo("octave", 0)) &&
        pyopencv_to_safe(pyobj_class_id, class_id, ArgInfo("class_id", 0)) )
    {
        ERRWRAP2(cv::KeyPoint::convert(points2f, keypoints, size, response, octave, class_id));
        return pyopencv_from(keypoints);
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("convert");

    return NULL;
}

static PyObject* pyopencv_cv_KeyPoint_overlap_static(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    PyObject* pyobj_kp1 = NULL;
    cv::KeyPoint kp1;
    PyObject* pyobj_kp2 = NULL;
    cv::KeyPoint kp2;
    float retval;

    const char* keywords[] = { "kp1", "kp2", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO:KeyPoint.overlap", (char**)keywords, &pyobj_kp1, &pyobj_kp2) &&
        pyopencv_to_safe(pyobj_kp1, kp1, ArgInfo("kp1", 0)) &&
        pyopencv_to_safe(pyobj_kp2, kp2, ArgInfo("kp2", 0)) )
    {
        ERRWRAP2(retval = cv::KeyPoint::overlap(kp1, kp2));
        return pyopencv_from(retval);
    }

    return NULL;
}



// Tables (KeyPoint)

static PyGetSetDef pyopencv_KeyPoint_getseters[] =
{
    {(char*)"angle", (getter)pyopencv_KeyPoint_get_angle, (setter)pyopencv_KeyPoint_set_angle, (char*)"angle", NULL},
    {(char*)"class_id", (getter)pyopencv_KeyPoint_get_class_id, (setter)pyopencv_KeyPoint_set_class_id, (char*)"class_id", NULL},
    {(char*)"octave", (getter)pyopencv_KeyPoint_get_octave, (setter)pyopencv_KeyPoint_set_octave, (char*)"octave", NULL},
    {(char*)"pt", (getter)pyopencv_KeyPoint_get_pt, (setter)pyopencv_KeyPoint_set_pt, (char*)"pt", NULL},
    {(char*)"response", (getter)pyopencv_KeyPoint_get_response, (setter)pyopencv_KeyPoint_set_response, (char*)"response", NULL},
    {(char*)"size", (getter)pyopencv_KeyPoint_get_size, (setter)pyopencv_KeyPoint_set_size, (char*)"size", NULL},
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_KeyPoint_methods[] =
{
    {"convert", CV_PY_FN_WITH_KW_(pyopencv_cv_KeyPoint_convert_static, METH_STATIC), "convert(keypoints[, keypointIndexes]) -> points2f\n.   This method converts vector of keypoints to vector of points or the reverse, where each keypoint is\n.       assigned the same size and the same orientation.\n.   \n.       @param keypoints Keypoints obtained from any feature detection algorithm like SIFT/SURF/ORB\n.       @param points2f Array of (x,y) coordinates of each keypoint\n.       @param keypointIndexes Array of indexes of keypoints to be converted to points. (Acts like a mask to\n.       convert only specified keypoints)\n\n\n\nconvert(points2f[, size[, response[, octave[, class_id]]]]) -> keypoints\n.   @overload\n.       @param points2f Array of (x,y) coordinates of each keypoint\n.       @param keypoints Keypoints obtained from any feature detection algorithm like SIFT/SURF/ORB\n.       @param size keypoint diameter\n.       @param response keypoint detector response on the keypoint (that is, strength of the keypoint)\n.       @param octave pyramid octave in which the keypoint has been detected\n.       @param class_id object id"},
    {"overlap", CV_PY_FN_WITH_KW_(pyopencv_cv_KeyPoint_overlap_static, METH_STATIC), "overlap(kp1, kp2) -> retval\n.   This method computes overlap for pair of keypoints. Overlap is the ratio between area of keypoint\n.       regions' intersection and area of keypoint regions' union (considering keypoint region as circle).\n.       If they don't overlap, we get zero. If they coincide at same location with same size, we get 1.\n.       @param kp1 First keypoint\n.       @param kp2 Second keypoint"},

    {NULL,          NULL}
};

// Converter (KeyPoint)

template<>
struct PyOpenCV_Converter< cv::KeyPoint >
{
    static PyObject* from(const cv::KeyPoint& r)
    {
        return pyopencv_KeyPoint_Instance(r);
    }
    static bool to(PyObject* src, cv::KeyPoint& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        cv::KeyPoint * dst_;
        if (pyopencv_KeyPoint_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected cv::KeyPoint for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// LineSegmentDetector (Generic)
//================================================================================

// GetSet (LineSegmentDetector)



// Methods (LineSegmentDetector)

static PyObject* pyopencv_cv_LineSegmentDetector_compareSegments(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::LineSegmentDetector> * self1 = 0;
    if (!pyopencv_LineSegmentDetector_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'LineSegmentDetector' or its derivative)");
    Ptr<cv::LineSegmentDetector> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_size = NULL;
    Size size;
    PyObject* pyobj_lines1 = NULL;
    Mat lines1;
    PyObject* pyobj_lines2 = NULL;
    Mat lines2;
    PyObject* pyobj_image = NULL;
    Mat image;
    int retval;

    const char* keywords[] = { "size", "lines1", "lines2", "image", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOO|O:LineSegmentDetector.compareSegments", (char**)keywords, &pyobj_size, &pyobj_lines1, &pyobj_lines2, &pyobj_image) &&
        pyopencv_to_safe(pyobj_size, size, ArgInfo("size", 0)) &&
        pyopencv_to_safe(pyobj_lines1, lines1, ArgInfo("lines1", 0)) &&
        pyopencv_to_safe(pyobj_lines2, lines2, ArgInfo("lines2", 0)) &&
        pyopencv_to_safe(pyobj_image, image, ArgInfo("image", 1)) )
    {
        ERRWRAP2(retval = _self_->compareSegments(size, lines1, lines2, image));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(image));
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_size = NULL;
    Size size;
    PyObject* pyobj_lines1 = NULL;
    UMat lines1;
    PyObject* pyobj_lines2 = NULL;
    UMat lines2;
    PyObject* pyobj_image = NULL;
    UMat image;
    int retval;

    const char* keywords[] = { "size", "lines1", "lines2", "image", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOO|O:LineSegmentDetector.compareSegments", (char**)keywords, &pyobj_size, &pyobj_lines1, &pyobj_lines2, &pyobj_image) &&
        pyopencv_to_safe(pyobj_size, size, ArgInfo("size", 0)) &&
        pyopencv_to_safe(pyobj_lines1, lines1, ArgInfo("lines1", 0)) &&
        pyopencv_to_safe(pyobj_lines2, lines2, ArgInfo("lines2", 0)) &&
        pyopencv_to_safe(pyobj_image, image, ArgInfo("image", 1)) )
    {
        ERRWRAP2(retval = _self_->compareSegments(size, lines1, lines2, image));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(image));
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("compareSegments");

    return NULL;
}

static PyObject* pyopencv_cv_LineSegmentDetector_detect(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::LineSegmentDetector> * self1 = 0;
    if (!pyopencv_LineSegmentDetector_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'LineSegmentDetector' or its derivative)");
    Ptr<cv::LineSegmentDetector> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_image = NULL;
    Mat image;
    PyObject* pyobj_lines = NULL;
    Mat lines;
    PyObject* pyobj_width = NULL;
    Mat width;
    PyObject* pyobj_prec = NULL;
    Mat prec;
    PyObject* pyobj_nfa = NULL;
    Mat nfa;

    const char* keywords[] = { "image", "lines", "width", "prec", "nfa", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|OOOO:LineSegmentDetector.detect", (char**)keywords, &pyobj_image, &pyobj_lines, &pyobj_width, &pyobj_prec, &pyobj_nfa) &&
        pyopencv_to_safe(pyobj_image, image, ArgInfo("image", 0)) &&
        pyopencv_to_safe(pyobj_lines, lines, ArgInfo("lines", 1)) &&
        pyopencv_to_safe(pyobj_width, width, ArgInfo("width", 1)) &&
        pyopencv_to_safe(pyobj_prec, prec, ArgInfo("prec", 1)) &&
        pyopencv_to_safe(pyobj_nfa, nfa, ArgInfo("nfa", 1)) )
    {
        ERRWRAP2(_self_->detect(image, lines, width, prec, nfa));
        return Py_BuildValue("(NNNN)", pyopencv_from(lines), pyopencv_from(width), pyopencv_from(prec), pyopencv_from(nfa));
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_image = NULL;
    UMat image;
    PyObject* pyobj_lines = NULL;
    UMat lines;
    PyObject* pyobj_width = NULL;
    UMat width;
    PyObject* pyobj_prec = NULL;
    UMat prec;
    PyObject* pyobj_nfa = NULL;
    UMat nfa;

    const char* keywords[] = { "image", "lines", "width", "prec", "nfa", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|OOOO:LineSegmentDetector.detect", (char**)keywords, &pyobj_image, &pyobj_lines, &pyobj_width, &pyobj_prec, &pyobj_nfa) &&
        pyopencv_to_safe(pyobj_image, image, ArgInfo("image", 0)) &&
        pyopencv_to_safe(pyobj_lines, lines, ArgInfo("lines", 1)) &&
        pyopencv_to_safe(pyobj_width, width, ArgInfo("width", 1)) &&
        pyopencv_to_safe(pyobj_prec, prec, ArgInfo("prec", 1)) &&
        pyopencv_to_safe(pyobj_nfa, nfa, ArgInfo("nfa", 1)) )
    {
        ERRWRAP2(_self_->detect(image, lines, width, prec, nfa));
        return Py_BuildValue("(NNNN)", pyopencv_from(lines), pyopencv_from(width), pyopencv_from(prec), pyopencv_from(nfa));
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("detect");

    return NULL;
}

static PyObject* pyopencv_cv_LineSegmentDetector_drawSegments(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::LineSegmentDetector> * self1 = 0;
    if (!pyopencv_LineSegmentDetector_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'LineSegmentDetector' or its derivative)");
    Ptr<cv::LineSegmentDetector> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_image = NULL;
    Mat image;
    PyObject* pyobj_lines = NULL;
    Mat lines;

    const char* keywords[] = { "image", "lines", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO:LineSegmentDetector.drawSegments", (char**)keywords, &pyobj_image, &pyobj_lines) &&
        pyopencv_to_safe(pyobj_image, image, ArgInfo("image", 1)) &&
        pyopencv_to_safe(pyobj_lines, lines, ArgInfo("lines", 0)) )
    {
        ERRWRAP2(_self_->drawSegments(image, lines));
        return pyopencv_from(image);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_image = NULL;
    UMat image;
    PyObject* pyobj_lines = NULL;
    UMat lines;

    const char* keywords[] = { "image", "lines", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO:LineSegmentDetector.drawSegments", (char**)keywords, &pyobj_image, &pyobj_lines) &&
        pyopencv_to_safe(pyobj_image, image, ArgInfo("image", 1)) &&
        pyopencv_to_safe(pyobj_lines, lines, ArgInfo("lines", 0)) )
    {
        ERRWRAP2(_self_->drawSegments(image, lines));
        return pyopencv_from(image);
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("drawSegments");

    return NULL;
}



// Tables (LineSegmentDetector)

static PyGetSetDef pyopencv_LineSegmentDetector_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_LineSegmentDetector_methods[] =
{
    {"compareSegments", CV_PY_FN_WITH_KW_(pyopencv_cv_LineSegmentDetector_compareSegments, 0), "compareSegments(size, lines1, lines2[, image]) -> retval, image\n.   @brief Draws two groups of lines in blue and red, counting the non overlapping (mismatching) pixels.\n.   \n.       @param size The size of the image, where lines1 and lines2 were found.\n.       @param lines1 The first group of lines that needs to be drawn. It is visualized in blue color.\n.       @param lines2 The second group of lines. They visualized in red color.\n.       @param image Optional image, where the lines will be drawn. The image should be color(3-channel)\n.       in order for lines1 and lines2 to be drawn in the above mentioned colors."},
    {"detect", CV_PY_FN_WITH_KW_(pyopencv_cv_LineSegmentDetector_detect, 0), "detect(image[, lines[, width[, prec[, nfa]]]]) -> lines, width, prec, nfa\n.   @brief Finds lines in the input image.\n.   \n.       This is the output of the default parameters of the algorithm on the above shown image.\n.   \n.       ![image](pics/building_lsd.png)\n.   \n.       @param image A grayscale (CV_8UC1) input image. If only a roi needs to be selected, use:\n.       `lsd_ptr-\\>detect(image(roi), lines, ...); lines += Scalar(roi.x, roi.y, roi.x, roi.y);`\n.       @param lines A vector of Vec4f elements specifying the beginning and ending point of a line. Where\n.       Vec4f is (x1, y1, x2, y2), point 1 is the start, point 2 - end. Returned lines are strictly\n.       oriented depending on the gradient.\n.       @param width Vector of widths of the regions, where the lines are found. E.g. Width of line.\n.       @param prec Vector of precisions with which the lines are found.\n.       @param nfa Vector containing number of false alarms in the line region, with precision of 10%. The\n.       bigger the value, logarithmically better the detection.\n.       - -1 corresponds to 10 mean false alarms\n.       - 0 corresponds to 1 mean false alarm\n.       - 1 corresponds to 0.1 mean false alarms\n.       This vector will be calculated only when the objects type is #LSD_REFINE_ADV."},
    {"drawSegments", CV_PY_FN_WITH_KW_(pyopencv_cv_LineSegmentDetector_drawSegments, 0), "drawSegments(image, lines) -> image\n.   @brief Draws the line segments on a given image.\n.       @param image The image, where the lines will be drawn. Should be bigger or equal to the image,\n.       where the lines were found.\n.       @param lines A vector of the lines that needed to be drawn."},

    {NULL,          NULL}
};

// Converter (LineSegmentDetector)

template<>
struct PyOpenCV_Converter< Ptr<cv::LineSegmentDetector> >
{
    static PyObject* from(const Ptr<cv::LineSegmentDetector>& r)
    {
        return pyopencv_LineSegmentDetector_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::LineSegmentDetector>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::LineSegmentDetector> * dst_;
        if (pyopencv_LineSegmentDetector_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::LineSegmentDetector> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// MSER (Generic)
//================================================================================

// GetSet (MSER)



// Methods (MSER)

static PyObject* pyopencv_cv_MSER_create_static(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    PyObject* pyobj_delta = NULL;
    int delta=5;
    PyObject* pyobj_min_area = NULL;
    int min_area=60;
    PyObject* pyobj_max_area = NULL;
    int max_area=14400;
    PyObject* pyobj_max_variation = NULL;
    double max_variation=0.25;
    PyObject* pyobj_min_diversity = NULL;
    double min_diversity=.2;
    PyObject* pyobj_max_evolution = NULL;
    int max_evolution=200;
    PyObject* pyobj_area_threshold = NULL;
    double area_threshold=1.01;
    PyObject* pyobj_min_margin = NULL;
    double min_margin=0.003;
    PyObject* pyobj_edge_blur_size = NULL;
    int edge_blur_size=5;
    Ptr<MSER> retval;

    const char* keywords[] = { "delta", "min_area", "max_area", "max_variation", "min_diversity", "max_evolution", "area_threshold", "min_margin", "edge_blur_size", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "|OOOOOOOOO:MSER.create", (char**)keywords, &pyobj_delta, &pyobj_min_area, &pyobj_max_area, &pyobj_max_variation, &pyobj_min_diversity, &pyobj_max_evolution, &pyobj_area_threshold, &pyobj_min_margin, &pyobj_edge_blur_size) &&
        pyopencv_to_safe(pyobj_delta, delta, ArgInfo("delta", 0)) &&
        pyopencv_to_safe(pyobj_min_area, min_area, ArgInfo("min_area", 0)) &&
        pyopencv_to_safe(pyobj_max_area, max_area, ArgInfo("max_area", 0)) &&
        pyopencv_to_safe(pyobj_max_variation, max_variation, ArgInfo("max_variation", 0)) &&
        pyopencv_to_safe(pyobj_min_diversity, min_diversity, ArgInfo("min_diversity", 0)) &&
        pyopencv_to_safe(pyobj_max_evolution, max_evolution, ArgInfo("max_evolution", 0)) &&
        pyopencv_to_safe(pyobj_area_threshold, area_threshold, ArgInfo("area_threshold", 0)) &&
        pyopencv_to_safe(pyobj_min_margin, min_margin, ArgInfo("min_margin", 0)) &&
        pyopencv_to_safe(pyobj_edge_blur_size, edge_blur_size, ArgInfo("edge_blur_size", 0)) )
    {
        ERRWRAP2(retval = cv::MSER::create(delta, min_area, max_area, max_variation, min_diversity, max_evolution, area_threshold, min_margin, edge_blur_size));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_MSER_detectRegions(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::MSER> * self1 = 0;
    if (!pyopencv_MSER_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'MSER' or its derivative)");
    Ptr<cv::MSER> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_image = NULL;
    Mat image;
    vector_vector_Point msers;
    vector_Rect bboxes;

    const char* keywords[] = { "image", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:MSER.detectRegions", (char**)keywords, &pyobj_image) &&
        pyopencv_to_safe(pyobj_image, image, ArgInfo("image", 0)) )
    {
        ERRWRAP2(_self_->detectRegions(image, msers, bboxes));
        return Py_BuildValue("(NN)", pyopencv_from(msers), pyopencv_from(bboxes));
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_image = NULL;
    UMat image;
    vector_vector_Point msers;
    vector_Rect bboxes;

    const char* keywords[] = { "image", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:MSER.detectRegions", (char**)keywords, &pyobj_image) &&
        pyopencv_to_safe(pyobj_image, image, ArgInfo("image", 0)) )
    {
        ERRWRAP2(_self_->detectRegions(image, msers, bboxes));
        return Py_BuildValue("(NN)", pyopencv_from(msers), pyopencv_from(bboxes));
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("detectRegions");

    return NULL;
}

static PyObject* pyopencv_cv_MSER_getAreaThreshold(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::MSER> * self1 = 0;
    if (!pyopencv_MSER_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'MSER' or its derivative)");
    Ptr<cv::MSER> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getAreaThreshold());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_MSER_getDefaultName(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::MSER> * self1 = 0;
    if (!pyopencv_MSER_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'MSER' or its derivative)");
    Ptr<cv::MSER> _self_ = *(self1);
    String retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getDefaultName());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_MSER_getDelta(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::MSER> * self1 = 0;
    if (!pyopencv_MSER_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'MSER' or its derivative)");
    Ptr<cv::MSER> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getDelta());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_MSER_getEdgeBlurSize(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::MSER> * self1 = 0;
    if (!pyopencv_MSER_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'MSER' or its derivative)");
    Ptr<cv::MSER> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getEdgeBlurSize());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_MSER_getMaxArea(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::MSER> * self1 = 0;
    if (!pyopencv_MSER_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'MSER' or its derivative)");
    Ptr<cv::MSER> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getMaxArea());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_MSER_getMaxEvolution(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::MSER> * self1 = 0;
    if (!pyopencv_MSER_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'MSER' or its derivative)");
    Ptr<cv::MSER> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getMaxEvolution());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_MSER_getMaxVariation(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::MSER> * self1 = 0;
    if (!pyopencv_MSER_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'MSER' or its derivative)");
    Ptr<cv::MSER> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getMaxVariation());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_MSER_getMinArea(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::MSER> * self1 = 0;
    if (!pyopencv_MSER_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'MSER' or its derivative)");
    Ptr<cv::MSER> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getMinArea());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_MSER_getMinDiversity(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::MSER> * self1 = 0;
    if (!pyopencv_MSER_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'MSER' or its derivative)");
    Ptr<cv::MSER> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getMinDiversity());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_MSER_getMinMargin(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::MSER> * self1 = 0;
    if (!pyopencv_MSER_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'MSER' or its derivative)");
    Ptr<cv::MSER> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getMinMargin());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_MSER_getPass2Only(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::MSER> * self1 = 0;
    if (!pyopencv_MSER_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'MSER' or its derivative)");
    Ptr<cv::MSER> _self_ = *(self1);
    bool retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getPass2Only());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_MSER_setAreaThreshold(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::MSER> * self1 = 0;
    if (!pyopencv_MSER_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'MSER' or its derivative)");
    Ptr<cv::MSER> _self_ = *(self1);
    PyObject* pyobj_areaThreshold = NULL;
    double areaThreshold=0;

    const char* keywords[] = { "areaThreshold", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:MSER.setAreaThreshold", (char**)keywords, &pyobj_areaThreshold) &&
        pyopencv_to_safe(pyobj_areaThreshold, areaThreshold, ArgInfo("areaThreshold", 0)) )
    {
        ERRWRAP2(_self_->setAreaThreshold(areaThreshold));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_MSER_setDelta(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::MSER> * self1 = 0;
    if (!pyopencv_MSER_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'MSER' or its derivative)");
    Ptr<cv::MSER> _self_ = *(self1);
    PyObject* pyobj_delta = NULL;
    int delta=0;

    const char* keywords[] = { "delta", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:MSER.setDelta", (char**)keywords, &pyobj_delta) &&
        pyopencv_to_safe(pyobj_delta, delta, ArgInfo("delta", 0)) )
    {
        ERRWRAP2(_self_->setDelta(delta));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_MSER_setEdgeBlurSize(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::MSER> * self1 = 0;
    if (!pyopencv_MSER_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'MSER' or its derivative)");
    Ptr<cv::MSER> _self_ = *(self1);
    PyObject* pyobj_edge_blur_size = NULL;
    int edge_blur_size=0;

    const char* keywords[] = { "edge_blur_size", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:MSER.setEdgeBlurSize", (char**)keywords, &pyobj_edge_blur_size) &&
        pyopencv_to_safe(pyobj_edge_blur_size, edge_blur_size, ArgInfo("edge_blur_size", 0)) )
    {
        ERRWRAP2(_self_->setEdgeBlurSize(edge_blur_size));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_MSER_setMaxArea(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::MSER> * self1 = 0;
    if (!pyopencv_MSER_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'MSER' or its derivative)");
    Ptr<cv::MSER> _self_ = *(self1);
    PyObject* pyobj_maxArea = NULL;
    int maxArea=0;

    const char* keywords[] = { "maxArea", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:MSER.setMaxArea", (char**)keywords, &pyobj_maxArea) &&
        pyopencv_to_safe(pyobj_maxArea, maxArea, ArgInfo("maxArea", 0)) )
    {
        ERRWRAP2(_self_->setMaxArea(maxArea));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_MSER_setMaxEvolution(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::MSER> * self1 = 0;
    if (!pyopencv_MSER_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'MSER' or its derivative)");
    Ptr<cv::MSER> _self_ = *(self1);
    PyObject* pyobj_maxEvolution = NULL;
    int maxEvolution=0;

    const char* keywords[] = { "maxEvolution", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:MSER.setMaxEvolution", (char**)keywords, &pyobj_maxEvolution) &&
        pyopencv_to_safe(pyobj_maxEvolution, maxEvolution, ArgInfo("maxEvolution", 0)) )
    {
        ERRWRAP2(_self_->setMaxEvolution(maxEvolution));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_MSER_setMaxVariation(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::MSER> * self1 = 0;
    if (!pyopencv_MSER_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'MSER' or its derivative)");
    Ptr<cv::MSER> _self_ = *(self1);
    PyObject* pyobj_maxVariation = NULL;
    double maxVariation=0;

    const char* keywords[] = { "maxVariation", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:MSER.setMaxVariation", (char**)keywords, &pyobj_maxVariation) &&
        pyopencv_to_safe(pyobj_maxVariation, maxVariation, ArgInfo("maxVariation", 0)) )
    {
        ERRWRAP2(_self_->setMaxVariation(maxVariation));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_MSER_setMinArea(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::MSER> * self1 = 0;
    if (!pyopencv_MSER_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'MSER' or its derivative)");
    Ptr<cv::MSER> _self_ = *(self1);
    PyObject* pyobj_minArea = NULL;
    int minArea=0;

    const char* keywords[] = { "minArea", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:MSER.setMinArea", (char**)keywords, &pyobj_minArea) &&
        pyopencv_to_safe(pyobj_minArea, minArea, ArgInfo("minArea", 0)) )
    {
        ERRWRAP2(_self_->setMinArea(minArea));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_MSER_setMinDiversity(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::MSER> * self1 = 0;
    if (!pyopencv_MSER_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'MSER' or its derivative)");
    Ptr<cv::MSER> _self_ = *(self1);
    PyObject* pyobj_minDiversity = NULL;
    double minDiversity=0;

    const char* keywords[] = { "minDiversity", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:MSER.setMinDiversity", (char**)keywords, &pyobj_minDiversity) &&
        pyopencv_to_safe(pyobj_minDiversity, minDiversity, ArgInfo("minDiversity", 0)) )
    {
        ERRWRAP2(_self_->setMinDiversity(minDiversity));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_MSER_setMinMargin(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::MSER> * self1 = 0;
    if (!pyopencv_MSER_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'MSER' or its derivative)");
    Ptr<cv::MSER> _self_ = *(self1);
    PyObject* pyobj_min_margin = NULL;
    double min_margin=0;

    const char* keywords[] = { "min_margin", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:MSER.setMinMargin", (char**)keywords, &pyobj_min_margin) &&
        pyopencv_to_safe(pyobj_min_margin, min_margin, ArgInfo("min_margin", 0)) )
    {
        ERRWRAP2(_self_->setMinMargin(min_margin));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_MSER_setPass2Only(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::MSER> * self1 = 0;
    if (!pyopencv_MSER_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'MSER' or its derivative)");
    Ptr<cv::MSER> _self_ = *(self1);
    PyObject* pyobj_f = NULL;
    bool f=0;

    const char* keywords[] = { "f", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:MSER.setPass2Only", (char**)keywords, &pyobj_f) &&
        pyopencv_to_safe(pyobj_f, f, ArgInfo("f", 0)) )
    {
        ERRWRAP2(_self_->setPass2Only(f));
        Py_RETURN_NONE;
    }

    return NULL;
}



// Tables (MSER)

static PyGetSetDef pyopencv_MSER_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_MSER_methods[] =
{
    {"create", CV_PY_FN_WITH_KW_(pyopencv_cv_MSER_create_static, METH_STATIC), "create([, delta[, min_area[, max_area[, max_variation[, min_diversity[, max_evolution[, area_threshold[, min_margin[, edge_blur_size]]]]]]]]]) -> retval\n.   @brief Full constructor for %MSER detector\n.   \n.       @param delta it compares \\f$(size_{i}-size_{i-delta})/size_{i-delta}\\f$\n.       @param min_area prune the area which smaller than minArea\n.       @param max_area prune the area which bigger than maxArea\n.       @param max_variation prune the area have similar size to its children\n.       @param min_diversity for color image, trace back to cut off mser with diversity less than min_diversity\n.       @param max_evolution  for color image, the evolution steps\n.       @param area_threshold for color image, the area threshold to cause re-initialize\n.       @param min_margin for color image, ignore too small margin\n.       @param edge_blur_size for color image, the aperture size for edge blur"},
    {"detectRegions", CV_PY_FN_WITH_KW_(pyopencv_cv_MSER_detectRegions, 0), "detectRegions(image) -> msers, bboxes\n.   @brief Detect %MSER regions\n.   \n.       @param image input image (8UC1, 8UC3 or 8UC4, must be greater or equal than 3x3)\n.       @param msers resulting list of point sets\n.       @param bboxes resulting bounding boxes"},
    {"getAreaThreshold", CV_PY_FN_WITH_KW_(pyopencv_cv_MSER_getAreaThreshold, 0), "getAreaThreshold() -> retval\n."},
    {"getDefaultName", CV_PY_FN_WITH_KW_(pyopencv_cv_MSER_getDefaultName, 0), "getDefaultName() -> retval\n."},
    {"getDelta", CV_PY_FN_WITH_KW_(pyopencv_cv_MSER_getDelta, 0), "getDelta() -> retval\n."},
    {"getEdgeBlurSize", CV_PY_FN_WITH_KW_(pyopencv_cv_MSER_getEdgeBlurSize, 0), "getEdgeBlurSize() -> retval\n."},
    {"getMaxArea", CV_PY_FN_WITH_KW_(pyopencv_cv_MSER_getMaxArea, 0), "getMaxArea() -> retval\n."},
    {"getMaxEvolution", CV_PY_FN_WITH_KW_(pyopencv_cv_MSER_getMaxEvolution, 0), "getMaxEvolution() -> retval\n."},
    {"getMaxVariation", CV_PY_FN_WITH_KW_(pyopencv_cv_MSER_getMaxVariation, 0), "getMaxVariation() -> retval\n."},
    {"getMinArea", CV_PY_FN_WITH_KW_(pyopencv_cv_MSER_getMinArea, 0), "getMinArea() -> retval\n."},
    {"getMinDiversity", CV_PY_FN_WITH_KW_(pyopencv_cv_MSER_getMinDiversity, 0), "getMinDiversity() -> retval\n."},
    {"getMinMargin", CV_PY_FN_WITH_KW_(pyopencv_cv_MSER_getMinMargin, 0), "getMinMargin() -> retval\n."},
    {"getPass2Only", CV_PY_FN_WITH_KW_(pyopencv_cv_MSER_getPass2Only, 0), "getPass2Only() -> retval\n."},
    {"setAreaThreshold", CV_PY_FN_WITH_KW_(pyopencv_cv_MSER_setAreaThreshold, 0), "setAreaThreshold(areaThreshold) -> None\n."},
    {"setDelta", CV_PY_FN_WITH_KW_(pyopencv_cv_MSER_setDelta, 0), "setDelta(delta) -> None\n."},
    {"setEdgeBlurSize", CV_PY_FN_WITH_KW_(pyopencv_cv_MSER_setEdgeBlurSize, 0), "setEdgeBlurSize(edge_blur_size) -> None\n."},
    {"setMaxArea", CV_PY_FN_WITH_KW_(pyopencv_cv_MSER_setMaxArea, 0), "setMaxArea(maxArea) -> None\n."},
    {"setMaxEvolution", CV_PY_FN_WITH_KW_(pyopencv_cv_MSER_setMaxEvolution, 0), "setMaxEvolution(maxEvolution) -> None\n."},
    {"setMaxVariation", CV_PY_FN_WITH_KW_(pyopencv_cv_MSER_setMaxVariation, 0), "setMaxVariation(maxVariation) -> None\n."},
    {"setMinArea", CV_PY_FN_WITH_KW_(pyopencv_cv_MSER_setMinArea, 0), "setMinArea(minArea) -> None\n."},
    {"setMinDiversity", CV_PY_FN_WITH_KW_(pyopencv_cv_MSER_setMinDiversity, 0), "setMinDiversity(minDiversity) -> None\n."},
    {"setMinMargin", CV_PY_FN_WITH_KW_(pyopencv_cv_MSER_setMinMargin, 0), "setMinMargin(min_margin) -> None\n."},
    {"setPass2Only", CV_PY_FN_WITH_KW_(pyopencv_cv_MSER_setPass2Only, 0), "setPass2Only(f) -> None\n."},

    {NULL,          NULL}
};

// Converter (MSER)

template<>
struct PyOpenCV_Converter< Ptr<cv::MSER> >
{
    static PyObject* from(const Ptr<cv::MSER>& r)
    {
        return pyopencv_MSER_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::MSER>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::MSER> * dst_;
        if (pyopencv_MSER_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::MSER> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// MergeDebevec (Generic)
//================================================================================

// GetSet (MergeDebevec)



// Methods (MergeDebevec)

static PyObject* pyopencv_cv_MergeDebevec_process(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::MergeDebevec> * self1 = 0;
    if (!pyopencv_MergeDebevec_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'MergeDebevec' or its derivative)");
    Ptr<cv::MergeDebevec> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(4);

    {
    PyObject* pyobj_src = NULL;
    vector_Mat src;
    PyObject* pyobj_dst = NULL;
    Mat dst;
    PyObject* pyobj_times = NULL;
    Mat times;
    PyObject* pyobj_response = NULL;
    Mat response;

    const char* keywords[] = { "src", "times", "response", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOO|O:MergeDebevec.process", (char**)keywords, &pyobj_src, &pyobj_times, &pyobj_response, &pyobj_dst) &&
        pyopencv_to_safe(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to_safe(pyobj_dst, dst, ArgInfo("dst", 1)) &&
        pyopencv_to_safe(pyobj_times, times, ArgInfo("times", 0)) &&
        pyopencv_to_safe(pyobj_response, response, ArgInfo("response", 0)) )
    {
        ERRWRAP2(_self_->process(src, dst, times, response));
        return pyopencv_from(dst);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_src = NULL;
    vector_UMat src;
    PyObject* pyobj_dst = NULL;
    UMat dst;
    PyObject* pyobj_times = NULL;
    UMat times;
    PyObject* pyobj_response = NULL;
    UMat response;

    const char* keywords[] = { "src", "times", "response", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOO|O:MergeDebevec.process", (char**)keywords, &pyobj_src, &pyobj_times, &pyobj_response, &pyobj_dst) &&
        pyopencv_to_safe(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to_safe(pyobj_dst, dst, ArgInfo("dst", 1)) &&
        pyopencv_to_safe(pyobj_times, times, ArgInfo("times", 0)) &&
        pyopencv_to_safe(pyobj_response, response, ArgInfo("response", 0)) )
    {
        ERRWRAP2(_self_->process(src, dst, times, response));
        return pyopencv_from(dst);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_src = NULL;
    vector_Mat src;
    PyObject* pyobj_dst = NULL;
    Mat dst;
    PyObject* pyobj_times = NULL;
    Mat times;

    const char* keywords[] = { "src", "times", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO|O:MergeDebevec.process", (char**)keywords, &pyobj_src, &pyobj_times, &pyobj_dst) &&
        pyopencv_to_safe(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to_safe(pyobj_dst, dst, ArgInfo("dst", 1)) &&
        pyopencv_to_safe(pyobj_times, times, ArgInfo("times", 0)) )
    {
        ERRWRAP2(_self_->process(src, dst, times));
        return pyopencv_from(dst);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_src = NULL;
    vector_UMat src;
    PyObject* pyobj_dst = NULL;
    UMat dst;
    PyObject* pyobj_times = NULL;
    UMat times;

    const char* keywords[] = { "src", "times", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO|O:MergeDebevec.process", (char**)keywords, &pyobj_src, &pyobj_times, &pyobj_dst) &&
        pyopencv_to_safe(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to_safe(pyobj_dst, dst, ArgInfo("dst", 1)) &&
        pyopencv_to_safe(pyobj_times, times, ArgInfo("times", 0)) )
    {
        ERRWRAP2(_self_->process(src, dst, times));
        return pyopencv_from(dst);
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("process");

    return NULL;
}



// Tables (MergeDebevec)

static PyGetSetDef pyopencv_MergeDebevec_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_MergeDebevec_methods[] =
{
    {"process", CV_PY_FN_WITH_KW_(pyopencv_cv_MergeDebevec_process, 0), "process(src, times, response[, dst]) -> dst\n.   \n\n\n\nprocess(src, times[, dst]) -> dst\n."},

    {NULL,          NULL}
};

// Converter (MergeDebevec)

template<>
struct PyOpenCV_Converter< Ptr<cv::MergeDebevec> >
{
    static PyObject* from(const Ptr<cv::MergeDebevec>& r)
    {
        return pyopencv_MergeDebevec_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::MergeDebevec>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::MergeDebevec> * dst_;
        if (pyopencv_MergeDebevec_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::MergeDebevec> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// MergeExposures (Generic)
//================================================================================

// GetSet (MergeExposures)



// Methods (MergeExposures)

static PyObject* pyopencv_cv_MergeExposures_process(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::MergeExposures> * self1 = 0;
    if (!pyopencv_MergeExposures_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'MergeExposures' or its derivative)");
    Ptr<cv::MergeExposures> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_src = NULL;
    vector_Mat src;
    PyObject* pyobj_dst = NULL;
    Mat dst;
    PyObject* pyobj_times = NULL;
    Mat times;
    PyObject* pyobj_response = NULL;
    Mat response;

    const char* keywords[] = { "src", "times", "response", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOO|O:MergeExposures.process", (char**)keywords, &pyobj_src, &pyobj_times, &pyobj_response, &pyobj_dst) &&
        pyopencv_to_safe(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to_safe(pyobj_dst, dst, ArgInfo("dst", 1)) &&
        pyopencv_to_safe(pyobj_times, times, ArgInfo("times", 0)) &&
        pyopencv_to_safe(pyobj_response, response, ArgInfo("response", 0)) )
    {
        ERRWRAP2(_self_->process(src, dst, times, response));
        return pyopencv_from(dst);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_src = NULL;
    vector_UMat src;
    PyObject* pyobj_dst = NULL;
    UMat dst;
    PyObject* pyobj_times = NULL;
    UMat times;
    PyObject* pyobj_response = NULL;
    UMat response;

    const char* keywords[] = { "src", "times", "response", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOO|O:MergeExposures.process", (char**)keywords, &pyobj_src, &pyobj_times, &pyobj_response, &pyobj_dst) &&
        pyopencv_to_safe(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to_safe(pyobj_dst, dst, ArgInfo("dst", 1)) &&
        pyopencv_to_safe(pyobj_times, times, ArgInfo("times", 0)) &&
        pyopencv_to_safe(pyobj_response, response, ArgInfo("response", 0)) )
    {
        ERRWRAP2(_self_->process(src, dst, times, response));
        return pyopencv_from(dst);
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("process");

    return NULL;
}



// Tables (MergeExposures)

static PyGetSetDef pyopencv_MergeExposures_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_MergeExposures_methods[] =
{
    {"process", CV_PY_FN_WITH_KW_(pyopencv_cv_MergeExposures_process, 0), "process(src, times, response[, dst]) -> dst\n.   @brief Merges images.\n.   \n.       @param src vector of input images\n.       @param dst result image\n.       @param times vector of exposure time values for each image\n.       @param response 256x1 matrix with inverse camera response function for each pixel value, it should\n.       have the same number of channels as images."},

    {NULL,          NULL}
};

// Converter (MergeExposures)

template<>
struct PyOpenCV_Converter< Ptr<cv::MergeExposures> >
{
    static PyObject* from(const Ptr<cv::MergeExposures>& r)
    {
        return pyopencv_MergeExposures_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::MergeExposures>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::MergeExposures> * dst_;
        if (pyopencv_MergeExposures_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::MergeExposures> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// MergeMertens (Generic)
//================================================================================

// GetSet (MergeMertens)



// Methods (MergeMertens)

static PyObject* pyopencv_cv_MergeMertens_getContrastWeight(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::MergeMertens> * self1 = 0;
    if (!pyopencv_MergeMertens_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'MergeMertens' or its derivative)");
    Ptr<cv::MergeMertens> _self_ = *(self1);
    float retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getContrastWeight());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_MergeMertens_getExposureWeight(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::MergeMertens> * self1 = 0;
    if (!pyopencv_MergeMertens_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'MergeMertens' or its derivative)");
    Ptr<cv::MergeMertens> _self_ = *(self1);
    float retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getExposureWeight());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_MergeMertens_getSaturationWeight(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::MergeMertens> * self1 = 0;
    if (!pyopencv_MergeMertens_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'MergeMertens' or its derivative)");
    Ptr<cv::MergeMertens> _self_ = *(self1);
    float retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getSaturationWeight());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_MergeMertens_process(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::MergeMertens> * self1 = 0;
    if (!pyopencv_MergeMertens_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'MergeMertens' or its derivative)");
    Ptr<cv::MergeMertens> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(4);

    {
    PyObject* pyobj_src = NULL;
    vector_Mat src;
    PyObject* pyobj_dst = NULL;
    Mat dst;
    PyObject* pyobj_times = NULL;
    Mat times;
    PyObject* pyobj_response = NULL;
    Mat response;

    const char* keywords[] = { "src", "times", "response", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOO|O:MergeMertens.process", (char**)keywords, &pyobj_src, &pyobj_times, &pyobj_response, &pyobj_dst) &&
        pyopencv_to_safe(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to_safe(pyobj_dst, dst, ArgInfo("dst", 1)) &&
        pyopencv_to_safe(pyobj_times, times, ArgInfo("times", 0)) &&
        pyopencv_to_safe(pyobj_response, response, ArgInfo("response", 0)) )
    {
        ERRWRAP2(_self_->process(src, dst, times, response));
        return pyopencv_from(dst);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_src = NULL;
    vector_UMat src;
    PyObject* pyobj_dst = NULL;
    UMat dst;
    PyObject* pyobj_times = NULL;
    UMat times;
    PyObject* pyobj_response = NULL;
    UMat response;

    const char* keywords[] = { "src", "times", "response", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOO|O:MergeMertens.process", (char**)keywords, &pyobj_src, &pyobj_times, &pyobj_response, &pyobj_dst) &&
        pyopencv_to_safe(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to_safe(pyobj_dst, dst, ArgInfo("dst", 1)) &&
        pyopencv_to_safe(pyobj_times, times, ArgInfo("times", 0)) &&
        pyopencv_to_safe(pyobj_response, response, ArgInfo("response", 0)) )
    {
        ERRWRAP2(_self_->process(src, dst, times, response));
        return pyopencv_from(dst);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_src = NULL;
    vector_Mat src;
    PyObject* pyobj_dst = NULL;
    Mat dst;

    const char* keywords[] = { "src", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|O:MergeMertens.process", (char**)keywords, &pyobj_src, &pyobj_dst) &&
        pyopencv_to_safe(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to_safe(pyobj_dst, dst, ArgInfo("dst", 1)) )
    {
        ERRWRAP2(_self_->process(src, dst));
        return pyopencv_from(dst);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_src = NULL;
    vector_UMat src;
    PyObject* pyobj_dst = NULL;
    UMat dst;

    const char* keywords[] = { "src", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|O:MergeMertens.process", (char**)keywords, &pyobj_src, &pyobj_dst) &&
        pyopencv_to_safe(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to_safe(pyobj_dst, dst, ArgInfo("dst", 1)) )
    {
        ERRWRAP2(_self_->process(src, dst));
        return pyopencv_from(dst);
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("process");

    return NULL;
}

static PyObject* pyopencv_cv_MergeMertens_setContrastWeight(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::MergeMertens> * self1 = 0;
    if (!pyopencv_MergeMertens_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'MergeMertens' or its derivative)");
    Ptr<cv::MergeMertens> _self_ = *(self1);
    PyObject* pyobj_contrast_weiht = NULL;
    float contrast_weiht=0.f;

    const char* keywords[] = { "contrast_weiht", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:MergeMertens.setContrastWeight", (char**)keywords, &pyobj_contrast_weiht) &&
        pyopencv_to_safe(pyobj_contrast_weiht, contrast_weiht, ArgInfo("contrast_weiht", 0)) )
    {
        ERRWRAP2(_self_->setContrastWeight(contrast_weiht));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_MergeMertens_setExposureWeight(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::MergeMertens> * self1 = 0;
    if (!pyopencv_MergeMertens_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'MergeMertens' or its derivative)");
    Ptr<cv::MergeMertens> _self_ = *(self1);
    PyObject* pyobj_exposure_weight = NULL;
    float exposure_weight=0.f;

    const char* keywords[] = { "exposure_weight", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:MergeMertens.setExposureWeight", (char**)keywords, &pyobj_exposure_weight) &&
        pyopencv_to_safe(pyobj_exposure_weight, exposure_weight, ArgInfo("exposure_weight", 0)) )
    {
        ERRWRAP2(_self_->setExposureWeight(exposure_weight));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_MergeMertens_setSaturationWeight(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::MergeMertens> * self1 = 0;
    if (!pyopencv_MergeMertens_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'MergeMertens' or its derivative)");
    Ptr<cv::MergeMertens> _self_ = *(self1);
    PyObject* pyobj_saturation_weight = NULL;
    float saturation_weight=0.f;

    const char* keywords[] = { "saturation_weight", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:MergeMertens.setSaturationWeight", (char**)keywords, &pyobj_saturation_weight) &&
        pyopencv_to_safe(pyobj_saturation_weight, saturation_weight, ArgInfo("saturation_weight", 0)) )
    {
        ERRWRAP2(_self_->setSaturationWeight(saturation_weight));
        Py_RETURN_NONE;
    }

    return NULL;
}



// Tables (MergeMertens)

static PyGetSetDef pyopencv_MergeMertens_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_MergeMertens_methods[] =
{
    {"getContrastWeight", CV_PY_FN_WITH_KW_(pyopencv_cv_MergeMertens_getContrastWeight, 0), "getContrastWeight() -> retval\n."},
    {"getExposureWeight", CV_PY_FN_WITH_KW_(pyopencv_cv_MergeMertens_getExposureWeight, 0), "getExposureWeight() -> retval\n."},
    {"getSaturationWeight", CV_PY_FN_WITH_KW_(pyopencv_cv_MergeMertens_getSaturationWeight, 0), "getSaturationWeight() -> retval\n."},
    {"process", CV_PY_FN_WITH_KW_(pyopencv_cv_MergeMertens_process, 0), "process(src, times, response[, dst]) -> dst\n.   \n\n\n\nprocess(src[, dst]) -> dst\n.   @brief Short version of process, that doesn't take extra arguments.\n.   \n.       @param src vector of input images\n.       @param dst result image"},
    {"setContrastWeight", CV_PY_FN_WITH_KW_(pyopencv_cv_MergeMertens_setContrastWeight, 0), "setContrastWeight(contrast_weiht) -> None\n."},
    {"setExposureWeight", CV_PY_FN_WITH_KW_(pyopencv_cv_MergeMertens_setExposureWeight, 0), "setExposureWeight(exposure_weight) -> None\n."},
    {"setSaturationWeight", CV_PY_FN_WITH_KW_(pyopencv_cv_MergeMertens_setSaturationWeight, 0), "setSaturationWeight(saturation_weight) -> None\n."},

    {NULL,          NULL}
};

// Converter (MergeMertens)

template<>
struct PyOpenCV_Converter< Ptr<cv::MergeMertens> >
{
    static PyObject* from(const Ptr<cv::MergeMertens>& r)
    {
        return pyopencv_MergeMertens_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::MergeMertens>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::MergeMertens> * dst_;
        if (pyopencv_MergeMertens_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::MergeMertens> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// MergeRobertson (Generic)
//================================================================================

// GetSet (MergeRobertson)



// Methods (MergeRobertson)

static PyObject* pyopencv_cv_MergeRobertson_process(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::MergeRobertson> * self1 = 0;
    if (!pyopencv_MergeRobertson_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'MergeRobertson' or its derivative)");
    Ptr<cv::MergeRobertson> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(4);

    {
    PyObject* pyobj_src = NULL;
    vector_Mat src;
    PyObject* pyobj_dst = NULL;
    Mat dst;
    PyObject* pyobj_times = NULL;
    Mat times;
    PyObject* pyobj_response = NULL;
    Mat response;

    const char* keywords[] = { "src", "times", "response", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOO|O:MergeRobertson.process", (char**)keywords, &pyobj_src, &pyobj_times, &pyobj_response, &pyobj_dst) &&
        pyopencv_to_safe(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to_safe(pyobj_dst, dst, ArgInfo("dst", 1)) &&
        pyopencv_to_safe(pyobj_times, times, ArgInfo("times", 0)) &&
        pyopencv_to_safe(pyobj_response, response, ArgInfo("response", 0)) )
    {
        ERRWRAP2(_self_->process(src, dst, times, response));
        return pyopencv_from(dst);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_src = NULL;
    vector_UMat src;
    PyObject* pyobj_dst = NULL;
    UMat dst;
    PyObject* pyobj_times = NULL;
    UMat times;
    PyObject* pyobj_response = NULL;
    UMat response;

    const char* keywords[] = { "src", "times", "response", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOO|O:MergeRobertson.process", (char**)keywords, &pyobj_src, &pyobj_times, &pyobj_response, &pyobj_dst) &&
        pyopencv_to_safe(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to_safe(pyobj_dst, dst, ArgInfo("dst", 1)) &&
        pyopencv_to_safe(pyobj_times, times, ArgInfo("times", 0)) &&
        pyopencv_to_safe(pyobj_response, response, ArgInfo("response", 0)) )
    {
        ERRWRAP2(_self_->process(src, dst, times, response));
        return pyopencv_from(dst);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_src = NULL;
    vector_Mat src;
    PyObject* pyobj_dst = NULL;
    Mat dst;
    PyObject* pyobj_times = NULL;
    Mat times;

    const char* keywords[] = { "src", "times", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO|O:MergeRobertson.process", (char**)keywords, &pyobj_src, &pyobj_times, &pyobj_dst) &&
        pyopencv_to_safe(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to_safe(pyobj_dst, dst, ArgInfo("dst", 1)) &&
        pyopencv_to_safe(pyobj_times, times, ArgInfo("times", 0)) )
    {
        ERRWRAP2(_self_->process(src, dst, times));
        return pyopencv_from(dst);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_src = NULL;
    vector_UMat src;
    PyObject* pyobj_dst = NULL;
    UMat dst;
    PyObject* pyobj_times = NULL;
    UMat times;

    const char* keywords[] = { "src", "times", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO|O:MergeRobertson.process", (char**)keywords, &pyobj_src, &pyobj_times, &pyobj_dst) &&
        pyopencv_to_safe(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to_safe(pyobj_dst, dst, ArgInfo("dst", 1)) &&
        pyopencv_to_safe(pyobj_times, times, ArgInfo("times", 0)) )
    {
        ERRWRAP2(_self_->process(src, dst, times));
        return pyopencv_from(dst);
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("process");

    return NULL;
}



// Tables (MergeRobertson)

static PyGetSetDef pyopencv_MergeRobertson_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_MergeRobertson_methods[] =
{
    {"process", CV_PY_FN_WITH_KW_(pyopencv_cv_MergeRobertson_process, 0), "process(src, times, response[, dst]) -> dst\n.   \n\n\n\nprocess(src, times[, dst]) -> dst\n."},

    {NULL,          NULL}
};

// Converter (MergeRobertson)

template<>
struct PyOpenCV_Converter< Ptr<cv::MergeRobertson> >
{
    static PyObject* from(const Ptr<cv::MergeRobertson>& r)
    {
        return pyopencv_MergeRobertson_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::MergeRobertson>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::MergeRobertson> * dst_;
        if (pyopencv_MergeRobertson_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::MergeRobertson> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// Moments (Map)
//================================================================================
static bool pyopencv_to(PyObject* src, cv::Moments& dst, const ArgInfo& info)
{
    PyObject* tmp;
    bool ok;

    if( PyMapping_HasKeyString(src, (char*)"m00") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"m00");
        ok = tmp && pyopencv_to_safe(tmp, dst.m00, ArgInfo("m00", 0));
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    if( PyMapping_HasKeyString(src, (char*)"m10") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"m10");
        ok = tmp && pyopencv_to_safe(tmp, dst.m10, ArgInfo("m10", 0));
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    if( PyMapping_HasKeyString(src, (char*)"m01") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"m01");
        ok = tmp && pyopencv_to_safe(tmp, dst.m01, ArgInfo("m01", 0));
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    if( PyMapping_HasKeyString(src, (char*)"m20") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"m20");
        ok = tmp && pyopencv_to_safe(tmp, dst.m20, ArgInfo("m20", 0));
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    if( PyMapping_HasKeyString(src, (char*)"m11") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"m11");
        ok = tmp && pyopencv_to_safe(tmp, dst.m11, ArgInfo("m11", 0));
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    if( PyMapping_HasKeyString(src, (char*)"m02") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"m02");
        ok = tmp && pyopencv_to_safe(tmp, dst.m02, ArgInfo("m02", 0));
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    if( PyMapping_HasKeyString(src, (char*)"m30") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"m30");
        ok = tmp && pyopencv_to_safe(tmp, dst.m30, ArgInfo("m30", 0));
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    if( PyMapping_HasKeyString(src, (char*)"m21") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"m21");
        ok = tmp && pyopencv_to_safe(tmp, dst.m21, ArgInfo("m21", 0));
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    if( PyMapping_HasKeyString(src, (char*)"m12") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"m12");
        ok = tmp && pyopencv_to_safe(tmp, dst.m12, ArgInfo("m12", 0));
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    if( PyMapping_HasKeyString(src, (char*)"m03") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"m03");
        ok = tmp && pyopencv_to_safe(tmp, dst.m03, ArgInfo("m03", 0));
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    if( PyMapping_HasKeyString(src, (char*)"mu20") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"mu20");
        ok = tmp && pyopencv_to_safe(tmp, dst.mu20, ArgInfo("mu20", 0));
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    if( PyMapping_HasKeyString(src, (char*)"mu11") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"mu11");
        ok = tmp && pyopencv_to_safe(tmp, dst.mu11, ArgInfo("mu11", 0));
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    if( PyMapping_HasKeyString(src, (char*)"mu02") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"mu02");
        ok = tmp && pyopencv_to_safe(tmp, dst.mu02, ArgInfo("mu02", 0));
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    if( PyMapping_HasKeyString(src, (char*)"mu30") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"mu30");
        ok = tmp && pyopencv_to_safe(tmp, dst.mu30, ArgInfo("mu30", 0));
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    if( PyMapping_HasKeyString(src, (char*)"mu21") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"mu21");
        ok = tmp && pyopencv_to_safe(tmp, dst.mu21, ArgInfo("mu21", 0));
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    if( PyMapping_HasKeyString(src, (char*)"mu12") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"mu12");
        ok = tmp && pyopencv_to_safe(tmp, dst.mu12, ArgInfo("mu12", 0));
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    if( PyMapping_HasKeyString(src, (char*)"mu03") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"mu03");
        ok = tmp && pyopencv_to_safe(tmp, dst.mu03, ArgInfo("mu03", 0));
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    if( PyMapping_HasKeyString(src, (char*)"nu20") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"nu20");
        ok = tmp && pyopencv_to_safe(tmp, dst.nu20, ArgInfo("nu20", 0));
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    if( PyMapping_HasKeyString(src, (char*)"nu11") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"nu11");
        ok = tmp && pyopencv_to_safe(tmp, dst.nu11, ArgInfo("nu11", 0));
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    if( PyMapping_HasKeyString(src, (char*)"nu02") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"nu02");
        ok = tmp && pyopencv_to_safe(tmp, dst.nu02, ArgInfo("nu02", 0));
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    if( PyMapping_HasKeyString(src, (char*)"nu30") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"nu30");
        ok = tmp && pyopencv_to_safe(tmp, dst.nu30, ArgInfo("nu30", 0));
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    if( PyMapping_HasKeyString(src, (char*)"nu21") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"nu21");
        ok = tmp && pyopencv_to_safe(tmp, dst.nu21, ArgInfo("nu21", 0));
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    if( PyMapping_HasKeyString(src, (char*)"nu12") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"nu12");
        ok = tmp && pyopencv_to_safe(tmp, dst.nu12, ArgInfo("nu12", 0));
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    if( PyMapping_HasKeyString(src, (char*)"nu03") )
    {
        tmp = PyMapping_GetItemString(src, (char*)"nu03");
        ok = tmp && pyopencv_to_safe(tmp, dst.nu03, ArgInfo("nu03", 0));
        Py_DECREF(tmp);
        if(!ok) return false;
    }
    return true;
}

template<> bool pyopencv_to(PyObject* src, cv::Moments& dst, const ArgInfo& info);

//================================================================================
// NormHistogramCostExtractor (Generic)
//================================================================================

// GetSet (NormHistogramCostExtractor)



// Methods (NormHistogramCostExtractor)

static PyObject* pyopencv_cv_NormHistogramCostExtractor_getNormFlag(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::NormHistogramCostExtractor> * self1 = 0;
    if (!pyopencv_NormHistogramCostExtractor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'NormHistogramCostExtractor' or its derivative)");
    Ptr<cv::NormHistogramCostExtractor> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getNormFlag());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_NormHistogramCostExtractor_setNormFlag(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::NormHistogramCostExtractor> * self1 = 0;
    if (!pyopencv_NormHistogramCostExtractor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'NormHistogramCostExtractor' or its derivative)");
    Ptr<cv::NormHistogramCostExtractor> _self_ = *(self1);
    PyObject* pyobj_flag = NULL;
    int flag=0;

    const char* keywords[] = { "flag", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:NormHistogramCostExtractor.setNormFlag", (char**)keywords, &pyobj_flag) &&
        pyopencv_to_safe(pyobj_flag, flag, ArgInfo("flag", 0)) )
    {
        ERRWRAP2(_self_->setNormFlag(flag));
        Py_RETURN_NONE;
    }

    return NULL;
}



// Tables (NormHistogramCostExtractor)

static PyGetSetDef pyopencv_NormHistogramCostExtractor_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_NormHistogramCostExtractor_methods[] =
{
    {"getNormFlag", CV_PY_FN_WITH_KW_(pyopencv_cv_NormHistogramCostExtractor_getNormFlag, 0), "getNormFlag() -> retval\n."},
    {"setNormFlag", CV_PY_FN_WITH_KW_(pyopencv_cv_NormHistogramCostExtractor_setNormFlag, 0), "setNormFlag(flag) -> None\n."},

    {NULL,          NULL}
};

// Converter (NormHistogramCostExtractor)

template<>
struct PyOpenCV_Converter< Ptr<cv::NormHistogramCostExtractor> >
{
    static PyObject* from(const Ptr<cv::NormHistogramCostExtractor>& r)
    {
        return pyopencv_NormHistogramCostExtractor_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::NormHistogramCostExtractor>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::NormHistogramCostExtractor> * dst_;
        if (pyopencv_NormHistogramCostExtractor_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::NormHistogramCostExtractor> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// ORB (Generic)
//================================================================================

// GetSet (ORB)



// Methods (ORB)

static PyObject* pyopencv_cv_ORB_create_static(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    PyObject* pyobj_nfeatures = NULL;
    int nfeatures=500;
    PyObject* pyobj_scaleFactor = NULL;
    float scaleFactor=1.2f;
    PyObject* pyobj_nlevels = NULL;
    int nlevels=8;
    PyObject* pyobj_edgeThreshold = NULL;
    int edgeThreshold=31;
    PyObject* pyobj_firstLevel = NULL;
    int firstLevel=0;
    PyObject* pyobj_WTA_K = NULL;
    int WTA_K=2;
    PyObject* pyobj_scoreType = NULL;
    ORB_ScoreType scoreType=ORB::HARRIS_SCORE;
    PyObject* pyobj_patchSize = NULL;
    int patchSize=31;
    PyObject* pyobj_fastThreshold = NULL;
    int fastThreshold=20;
    Ptr<ORB> retval;

    const char* keywords[] = { "nfeatures", "scaleFactor", "nlevels", "edgeThreshold", "firstLevel", "WTA_K", "scoreType", "patchSize", "fastThreshold", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "|OOOOOOOOO:ORB.create", (char**)keywords, &pyobj_nfeatures, &pyobj_scaleFactor, &pyobj_nlevels, &pyobj_edgeThreshold, &pyobj_firstLevel, &pyobj_WTA_K, &pyobj_scoreType, &pyobj_patchSize, &pyobj_fastThreshold) &&
        pyopencv_to_safe(pyobj_nfeatures, nfeatures, ArgInfo("nfeatures", 0)) &&
        pyopencv_to_safe(pyobj_scaleFactor, scaleFactor, ArgInfo("scaleFactor", 0)) &&
        pyopencv_to_safe(pyobj_nlevels, nlevels, ArgInfo("nlevels", 0)) &&
        pyopencv_to_safe(pyobj_edgeThreshold, edgeThreshold, ArgInfo("edgeThreshold", 0)) &&
        pyopencv_to_safe(pyobj_firstLevel, firstLevel, ArgInfo("firstLevel", 0)) &&
        pyopencv_to_safe(pyobj_WTA_K, WTA_K, ArgInfo("WTA_K", 0)) &&
        pyopencv_to_safe(pyobj_scoreType, scoreType, ArgInfo("scoreType", 0)) &&
        pyopencv_to_safe(pyobj_patchSize, patchSize, ArgInfo("patchSize", 0)) &&
        pyopencv_to_safe(pyobj_fastThreshold, fastThreshold, ArgInfo("fastThreshold", 0)) )
    {
        ERRWRAP2(retval = cv::ORB::create(nfeatures, scaleFactor, nlevels, edgeThreshold, firstLevel, WTA_K, scoreType, patchSize, fastThreshold));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ORB_getDefaultName(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ORB> * self1 = 0;
    if (!pyopencv_ORB_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ORB' or its derivative)");
    Ptr<cv::ORB> _self_ = *(self1);
    String retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getDefaultName());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ORB_getEdgeThreshold(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ORB> * self1 = 0;
    if (!pyopencv_ORB_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ORB' or its derivative)");
    Ptr<cv::ORB> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getEdgeThreshold());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ORB_getFastThreshold(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ORB> * self1 = 0;
    if (!pyopencv_ORB_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ORB' or its derivative)");
    Ptr<cv::ORB> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getFastThreshold());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ORB_getFirstLevel(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ORB> * self1 = 0;
    if (!pyopencv_ORB_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ORB' or its derivative)");
    Ptr<cv::ORB> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getFirstLevel());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ORB_getMaxFeatures(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ORB> * self1 = 0;
    if (!pyopencv_ORB_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ORB' or its derivative)");
    Ptr<cv::ORB> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getMaxFeatures());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ORB_getNLevels(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ORB> * self1 = 0;
    if (!pyopencv_ORB_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ORB' or its derivative)");
    Ptr<cv::ORB> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getNLevels());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ORB_getPatchSize(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ORB> * self1 = 0;
    if (!pyopencv_ORB_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ORB' or its derivative)");
    Ptr<cv::ORB> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getPatchSize());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ORB_getScaleFactor(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ORB> * self1 = 0;
    if (!pyopencv_ORB_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ORB' or its derivative)");
    Ptr<cv::ORB> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getScaleFactor());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ORB_getScoreType(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ORB> * self1 = 0;
    if (!pyopencv_ORB_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ORB' or its derivative)");
    Ptr<cv::ORB> _self_ = *(self1);
    ORB::ScoreType retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getScoreType());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ORB_getWTA_K(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ORB> * self1 = 0;
    if (!pyopencv_ORB_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ORB' or its derivative)");
    Ptr<cv::ORB> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getWTA_K());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ORB_setEdgeThreshold(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ORB> * self1 = 0;
    if (!pyopencv_ORB_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ORB' or its derivative)");
    Ptr<cv::ORB> _self_ = *(self1);
    PyObject* pyobj_edgeThreshold = NULL;
    int edgeThreshold=0;

    const char* keywords[] = { "edgeThreshold", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:ORB.setEdgeThreshold", (char**)keywords, &pyobj_edgeThreshold) &&
        pyopencv_to_safe(pyobj_edgeThreshold, edgeThreshold, ArgInfo("edgeThreshold", 0)) )
    {
        ERRWRAP2(_self_->setEdgeThreshold(edgeThreshold));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ORB_setFastThreshold(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ORB> * self1 = 0;
    if (!pyopencv_ORB_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ORB' or its derivative)");
    Ptr<cv::ORB> _self_ = *(self1);
    PyObject* pyobj_fastThreshold = NULL;
    int fastThreshold=0;

    const char* keywords[] = { "fastThreshold", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:ORB.setFastThreshold", (char**)keywords, &pyobj_fastThreshold) &&
        pyopencv_to_safe(pyobj_fastThreshold, fastThreshold, ArgInfo("fastThreshold", 0)) )
    {
        ERRWRAP2(_self_->setFastThreshold(fastThreshold));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ORB_setFirstLevel(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ORB> * self1 = 0;
    if (!pyopencv_ORB_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ORB' or its derivative)");
    Ptr<cv::ORB> _self_ = *(self1);
    PyObject* pyobj_firstLevel = NULL;
    int firstLevel=0;

    const char* keywords[] = { "firstLevel", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:ORB.setFirstLevel", (char**)keywords, &pyobj_firstLevel) &&
        pyopencv_to_safe(pyobj_firstLevel, firstLevel, ArgInfo("firstLevel", 0)) )
    {
        ERRWRAP2(_self_->setFirstLevel(firstLevel));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ORB_setMaxFeatures(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ORB> * self1 = 0;
    if (!pyopencv_ORB_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ORB' or its derivative)");
    Ptr<cv::ORB> _self_ = *(self1);
    PyObject* pyobj_maxFeatures = NULL;
    int maxFeatures=0;

    const char* keywords[] = { "maxFeatures", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:ORB.setMaxFeatures", (char**)keywords, &pyobj_maxFeatures) &&
        pyopencv_to_safe(pyobj_maxFeatures, maxFeatures, ArgInfo("maxFeatures", 0)) )
    {
        ERRWRAP2(_self_->setMaxFeatures(maxFeatures));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ORB_setNLevels(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ORB> * self1 = 0;
    if (!pyopencv_ORB_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ORB' or its derivative)");
    Ptr<cv::ORB> _self_ = *(self1);
    PyObject* pyobj_nlevels = NULL;
    int nlevels=0;

    const char* keywords[] = { "nlevels", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:ORB.setNLevels", (char**)keywords, &pyobj_nlevels) &&
        pyopencv_to_safe(pyobj_nlevels, nlevels, ArgInfo("nlevels", 0)) )
    {
        ERRWRAP2(_self_->setNLevels(nlevels));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ORB_setPatchSize(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ORB> * self1 = 0;
    if (!pyopencv_ORB_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ORB' or its derivative)");
    Ptr<cv::ORB> _self_ = *(self1);
    PyObject* pyobj_patchSize = NULL;
    int patchSize=0;

    const char* keywords[] = { "patchSize", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:ORB.setPatchSize", (char**)keywords, &pyobj_patchSize) &&
        pyopencv_to_safe(pyobj_patchSize, patchSize, ArgInfo("patchSize", 0)) )
    {
        ERRWRAP2(_self_->setPatchSize(patchSize));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ORB_setScaleFactor(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ORB> * self1 = 0;
    if (!pyopencv_ORB_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ORB' or its derivative)");
    Ptr<cv::ORB> _self_ = *(self1);
    PyObject* pyobj_scaleFactor = NULL;
    double scaleFactor=0;

    const char* keywords[] = { "scaleFactor", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:ORB.setScaleFactor", (char**)keywords, &pyobj_scaleFactor) &&
        pyopencv_to_safe(pyobj_scaleFactor, scaleFactor, ArgInfo("scaleFactor", 0)) )
    {
        ERRWRAP2(_self_->setScaleFactor(scaleFactor));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ORB_setScoreType(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ORB> * self1 = 0;
    if (!pyopencv_ORB_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ORB' or its derivative)");
    Ptr<cv::ORB> _self_ = *(self1);
    PyObject* pyobj_scoreType = NULL;
    ORB_ScoreType scoreType=static_cast<ORB_ScoreType>(0);

    const char* keywords[] = { "scoreType", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:ORB.setScoreType", (char**)keywords, &pyobj_scoreType) &&
        pyopencv_to_safe(pyobj_scoreType, scoreType, ArgInfo("scoreType", 0)) )
    {
        ERRWRAP2(_self_->setScoreType(scoreType));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ORB_setWTA_K(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ORB> * self1 = 0;
    if (!pyopencv_ORB_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ORB' or its derivative)");
    Ptr<cv::ORB> _self_ = *(self1);
    PyObject* pyobj_wta_k = NULL;
    int wta_k=0;

    const char* keywords[] = { "wta_k", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:ORB.setWTA_K", (char**)keywords, &pyobj_wta_k) &&
        pyopencv_to_safe(pyobj_wta_k, wta_k, ArgInfo("wta_k", 0)) )
    {
        ERRWRAP2(_self_->setWTA_K(wta_k));
        Py_RETURN_NONE;
    }

    return NULL;
}



// Tables (ORB)

static PyGetSetDef pyopencv_ORB_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_ORB_methods[] =
{
    {"create", CV_PY_FN_WITH_KW_(pyopencv_cv_ORB_create_static, METH_STATIC), "create([, nfeatures[, scaleFactor[, nlevels[, edgeThreshold[, firstLevel[, WTA_K[, scoreType[, patchSize[, fastThreshold]]]]]]]]]) -> retval\n.   @brief The ORB constructor\n.   \n.       @param nfeatures The maximum number of features to retain.\n.       @param scaleFactor Pyramid decimation ratio, greater than 1. scaleFactor==2 means the classical\n.       pyramid, where each next level has 4x less pixels than the previous, but such a big scale factor\n.       will degrade feature matching scores dramatically. On the other hand, too close to 1 scale factor\n.       will mean that to cover certain scale range you will need more pyramid levels and so the speed\n.       will suffer.\n.       @param nlevels The number of pyramid levels. The smallest level will have linear size equal to\n.       input_image_linear_size/pow(scaleFactor, nlevels - firstLevel).\n.       @param edgeThreshold This is size of the border where the features are not detected. It should\n.       roughly match the patchSize parameter.\n.       @param firstLevel The level of pyramid to put source image to. Previous layers are filled\n.       with upscaled source image.\n.       @param WTA_K The number of points that produce each element of the oriented BRIEF descriptor. The\n.       default value 2 means the BRIEF where we take a random point pair and compare their brightnesses,\n.       so we get 0/1 response. Other possible values are 3 and 4. For example, 3 means that we take 3\n.       random points (of course, those point coordinates are random, but they are generated from the\n.       pre-defined seed, so each element of BRIEF descriptor is computed deterministically from the pixel\n.       rectangle), find point of maximum brightness and output index of the winner (0, 1 or 2). Such\n.       output will occupy 2 bits, and therefore it will need a special variant of Hamming distance,\n.       denoted as NORM_HAMMING2 (2 bits per bin). When WTA_K=4, we take 4 random points to compute each\n.       bin (that will also occupy 2 bits with possible values 0, 1, 2 or 3).\n.       @param scoreType The default HARRIS_SCORE means that Harris algorithm is used to rank features\n.       (the score is written to KeyPoint::score and is used to retain best nfeatures features);\n.       FAST_SCORE is alternative value of the parameter that produces slightly less stable keypoints,\n.       but it is a little faster to compute.\n.       @param patchSize size of the patch used by the oriented BRIEF descriptor. Of course, on smaller\n.       pyramid layers the perceived image area covered by a feature will be larger.\n.       @param fastThreshold the fast threshold"},
    {"getDefaultName", CV_PY_FN_WITH_KW_(pyopencv_cv_ORB_getDefaultName, 0), "getDefaultName() -> retval\n."},
    {"getEdgeThreshold", CV_PY_FN_WITH_KW_(pyopencv_cv_ORB_getEdgeThreshold, 0), "getEdgeThreshold() -> retval\n."},
    {"getFastThreshold", CV_PY_FN_WITH_KW_(pyopencv_cv_ORB_getFastThreshold, 0), "getFastThreshold() -> retval\n."},
    {"getFirstLevel", CV_PY_FN_WITH_KW_(pyopencv_cv_ORB_getFirstLevel, 0), "getFirstLevel() -> retval\n."},
    {"getMaxFeatures", CV_PY_FN_WITH_KW_(pyopencv_cv_ORB_getMaxFeatures, 0), "getMaxFeatures() -> retval\n."},
    {"getNLevels", CV_PY_FN_WITH_KW_(pyopencv_cv_ORB_getNLevels, 0), "getNLevels() -> retval\n."},
    {"getPatchSize", CV_PY_FN_WITH_KW_(pyopencv_cv_ORB_getPatchSize, 0), "getPatchSize() -> retval\n."},
    {"getScaleFactor", CV_PY_FN_WITH_KW_(pyopencv_cv_ORB_getScaleFactor, 0), "getScaleFactor() -> retval\n."},
    {"getScoreType", CV_PY_FN_WITH_KW_(pyopencv_cv_ORB_getScoreType, 0), "getScoreType() -> retval\n."},
    {"getWTA_K", CV_PY_FN_WITH_KW_(pyopencv_cv_ORB_getWTA_K, 0), "getWTA_K() -> retval\n."},
    {"setEdgeThreshold", CV_PY_FN_WITH_KW_(pyopencv_cv_ORB_setEdgeThreshold, 0), "setEdgeThreshold(edgeThreshold) -> None\n."},
    {"setFastThreshold", CV_PY_FN_WITH_KW_(pyopencv_cv_ORB_setFastThreshold, 0), "setFastThreshold(fastThreshold) -> None\n."},
    {"setFirstLevel", CV_PY_FN_WITH_KW_(pyopencv_cv_ORB_setFirstLevel, 0), "setFirstLevel(firstLevel) -> None\n."},
    {"setMaxFeatures", CV_PY_FN_WITH_KW_(pyopencv_cv_ORB_setMaxFeatures, 0), "setMaxFeatures(maxFeatures) -> None\n."},
    {"setNLevels", CV_PY_FN_WITH_KW_(pyopencv_cv_ORB_setNLevels, 0), "setNLevels(nlevels) -> None\n."},
    {"setPatchSize", CV_PY_FN_WITH_KW_(pyopencv_cv_ORB_setPatchSize, 0), "setPatchSize(patchSize) -> None\n."},
    {"setScaleFactor", CV_PY_FN_WITH_KW_(pyopencv_cv_ORB_setScaleFactor, 0), "setScaleFactor(scaleFactor) -> None\n."},
    {"setScoreType", CV_PY_FN_WITH_KW_(pyopencv_cv_ORB_setScoreType, 0), "setScoreType(scoreType) -> None\n."},
    {"setWTA_K", CV_PY_FN_WITH_KW_(pyopencv_cv_ORB_setWTA_K, 0), "setWTA_K(wta_k) -> None\n."},

    {NULL,          NULL}
};

// Converter (ORB)

template<>
struct PyOpenCV_Converter< Ptr<cv::ORB> >
{
    static PyObject* from(const Ptr<cv::ORB>& r)
    {
        return pyopencv_ORB_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::ORB>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::ORB> * dst_;
        if (pyopencv_ORB_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::ORB> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// PyRotationWarper (Generic)
//================================================================================

// GetSet (PyRotationWarper)



// Methods (PyRotationWarper)

static int pyopencv_cv_PyRotationWarper_PyRotationWarper(pyopencv_PyRotationWarper_t* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_type = NULL;
    String type;
    PyObject* pyobj_scale = NULL;
    float scale=0.f;

    const char* keywords[] = { "type", "scale", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO:PyRotationWarper", (char**)keywords, &pyobj_type, &pyobj_scale) &&
        pyopencv_to_safe(pyobj_type, type, ArgInfo("type", 0)) &&
        pyopencv_to_safe(pyobj_scale, scale, ArgInfo("scale", 0)) )
    {
        new (&(self->v)) Ptr<cv::PyRotationWarper>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::PyRotationWarper(type, scale)));
        return 0;
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        new (&(self->v)) Ptr<cv::PyRotationWarper>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::PyRotationWarper()));
        return 0;
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("PyRotationWarper");

    return -1;
}

static PyObject* pyopencv_cv_PyRotationWarper_buildMaps(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::PyRotationWarper> * self1 = 0;
    if (!pyopencv_PyRotationWarper_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'PyRotationWarper' or its derivative)");
    Ptr<cv::PyRotationWarper> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_src_size = NULL;
    Size src_size;
    PyObject* pyobj_K = NULL;
    Mat K;
    PyObject* pyobj_R = NULL;
    Mat R;
    PyObject* pyobj_xmap = NULL;
    Mat xmap;
    PyObject* pyobj_ymap = NULL;
    Mat ymap;
    Rect retval;

    const char* keywords[] = { "src_size", "K", "R", "xmap", "ymap", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOO|OO:PyRotationWarper.buildMaps", (char**)keywords, &pyobj_src_size, &pyobj_K, &pyobj_R, &pyobj_xmap, &pyobj_ymap) &&
        pyopencv_to_safe(pyobj_src_size, src_size, ArgInfo("src_size", 0)) &&
        pyopencv_to_safe(pyobj_K, K, ArgInfo("K", 0)) &&
        pyopencv_to_safe(pyobj_R, R, ArgInfo("R", 0)) &&
        pyopencv_to_safe(pyobj_xmap, xmap, ArgInfo("xmap", 1)) &&
        pyopencv_to_safe(pyobj_ymap, ymap, ArgInfo("ymap", 1)) )
    {
        ERRWRAP2(retval = _self_->buildMaps(src_size, K, R, xmap, ymap));
        return Py_BuildValue("(NNN)", pyopencv_from(retval), pyopencv_from(xmap), pyopencv_from(ymap));
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_src_size = NULL;
    Size src_size;
    PyObject* pyobj_K = NULL;
    UMat K;
    PyObject* pyobj_R = NULL;
    UMat R;
    PyObject* pyobj_xmap = NULL;
    UMat xmap;
    PyObject* pyobj_ymap = NULL;
    UMat ymap;
    Rect retval;

    const char* keywords[] = { "src_size", "K", "R", "xmap", "ymap", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOO|OO:PyRotationWarper.buildMaps", (char**)keywords, &pyobj_src_size, &pyobj_K, &pyobj_R, &pyobj_xmap, &pyobj_ymap) &&
        pyopencv_to_safe(pyobj_src_size, src_size, ArgInfo("src_size", 0)) &&
        pyopencv_to_safe(pyobj_K, K, ArgInfo("K", 0)) &&
        pyopencv_to_safe(pyobj_R, R, ArgInfo("R", 0)) &&
        pyopencv_to_safe(pyobj_xmap, xmap, ArgInfo("xmap", 1)) &&
        pyopencv_to_safe(pyobj_ymap, ymap, ArgInfo("ymap", 1)) )
    {
        ERRWRAP2(retval = _self_->buildMaps(src_size, K, R, xmap, ymap));
        return Py_BuildValue("(NNN)", pyopencv_from(retval), pyopencv_from(xmap), pyopencv_from(ymap));
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("buildMaps");

    return NULL;
}

static PyObject* pyopencv_cv_PyRotationWarper_getScale(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::PyRotationWarper> * self1 = 0;
    if (!pyopencv_PyRotationWarper_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'PyRotationWarper' or its derivative)");
    Ptr<cv::PyRotationWarper> _self_ = *(self1);
    float retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getScale());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_PyRotationWarper_setScale(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::PyRotationWarper> * self1 = 0;
    if (!pyopencv_PyRotationWarper_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'PyRotationWarper' or its derivative)");
    Ptr<cv::PyRotationWarper> _self_ = *(self1);
    PyObject* pyobj_arg1 = NULL;
    float arg1=0.f;

    const char* keywords[] = { "arg1", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:PyRotationWarper.setScale", (char**)keywords, &pyobj_arg1) &&
        pyopencv_to_safe(pyobj_arg1, arg1, ArgInfo("arg1", 0)) )
    {
        ERRWRAP2(_self_->setScale(arg1));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_PyRotationWarper_warp(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::PyRotationWarper> * self1 = 0;
    if (!pyopencv_PyRotationWarper_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'PyRotationWarper' or its derivative)");
    Ptr<cv::PyRotationWarper> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_src = NULL;
    Mat src;
    PyObject* pyobj_K = NULL;
    Mat K;
    PyObject* pyobj_R = NULL;
    Mat R;
    PyObject* pyobj_interp_mode = NULL;
    int interp_mode=0;
    PyObject* pyobj_border_mode = NULL;
    int border_mode=0;
    PyObject* pyobj_dst = NULL;
    Mat dst;
    Point retval;

    const char* keywords[] = { "src", "K", "R", "interp_mode", "border_mode", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOOOO|O:PyRotationWarper.warp", (char**)keywords, &pyobj_src, &pyobj_K, &pyobj_R, &pyobj_interp_mode, &pyobj_border_mode, &pyobj_dst) &&
        pyopencv_to_safe(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to_safe(pyobj_K, K, ArgInfo("K", 0)) &&
        pyopencv_to_safe(pyobj_R, R, ArgInfo("R", 0)) &&
        pyopencv_to_safe(pyobj_interp_mode, interp_mode, ArgInfo("interp_mode", 0)) &&
        pyopencv_to_safe(pyobj_border_mode, border_mode, ArgInfo("border_mode", 0)) &&
        pyopencv_to_safe(pyobj_dst, dst, ArgInfo("dst", 1)) )
    {
        ERRWRAP2(retval = _self_->warp(src, K, R, interp_mode, border_mode, dst));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(dst));
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_src = NULL;
    UMat src;
    PyObject* pyobj_K = NULL;
    UMat K;
    PyObject* pyobj_R = NULL;
    UMat R;
    PyObject* pyobj_interp_mode = NULL;
    int interp_mode=0;
    PyObject* pyobj_border_mode = NULL;
    int border_mode=0;
    PyObject* pyobj_dst = NULL;
    UMat dst;
    Point retval;

    const char* keywords[] = { "src", "K", "R", "interp_mode", "border_mode", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOOOO|O:PyRotationWarper.warp", (char**)keywords, &pyobj_src, &pyobj_K, &pyobj_R, &pyobj_interp_mode, &pyobj_border_mode, &pyobj_dst) &&
        pyopencv_to_safe(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to_safe(pyobj_K, K, ArgInfo("K", 0)) &&
        pyopencv_to_safe(pyobj_R, R, ArgInfo("R", 0)) &&
        pyopencv_to_safe(pyobj_interp_mode, interp_mode, ArgInfo("interp_mode", 0)) &&
        pyopencv_to_safe(pyobj_border_mode, border_mode, ArgInfo("border_mode", 0)) &&
        pyopencv_to_safe(pyobj_dst, dst, ArgInfo("dst", 1)) )
    {
        ERRWRAP2(retval = _self_->warp(src, K, R, interp_mode, border_mode, dst));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(dst));
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("warp");

    return NULL;
}

static PyObject* pyopencv_cv_PyRotationWarper_warpBackward(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::PyRotationWarper> * self1 = 0;
    if (!pyopencv_PyRotationWarper_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'PyRotationWarper' or its derivative)");
    Ptr<cv::PyRotationWarper> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_src = NULL;
    Mat src;
    PyObject* pyobj_K = NULL;
    Mat K;
    PyObject* pyobj_R = NULL;
    Mat R;
    PyObject* pyobj_interp_mode = NULL;
    int interp_mode=0;
    PyObject* pyobj_border_mode = NULL;
    int border_mode=0;
    PyObject* pyobj_dst_size = NULL;
    Size dst_size;
    PyObject* pyobj_dst = NULL;
    Mat dst;

    const char* keywords[] = { "src", "K", "R", "interp_mode", "border_mode", "dst_size", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOOOOO|O:PyRotationWarper.warpBackward", (char**)keywords, &pyobj_src, &pyobj_K, &pyobj_R, &pyobj_interp_mode, &pyobj_border_mode, &pyobj_dst_size, &pyobj_dst) &&
        pyopencv_to_safe(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to_safe(pyobj_K, K, ArgInfo("K", 0)) &&
        pyopencv_to_safe(pyobj_R, R, ArgInfo("R", 0)) &&
        pyopencv_to_safe(pyobj_interp_mode, interp_mode, ArgInfo("interp_mode", 0)) &&
        pyopencv_to_safe(pyobj_border_mode, border_mode, ArgInfo("border_mode", 0)) &&
        pyopencv_to_safe(pyobj_dst_size, dst_size, ArgInfo("dst_size", 0)) &&
        pyopencv_to_safe(pyobj_dst, dst, ArgInfo("dst", 1)) )
    {
        ERRWRAP2(_self_->warpBackward(src, K, R, interp_mode, border_mode, dst_size, dst));
        return pyopencv_from(dst);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_src = NULL;
    UMat src;
    PyObject* pyobj_K = NULL;
    UMat K;
    PyObject* pyobj_R = NULL;
    UMat R;
    PyObject* pyobj_interp_mode = NULL;
    int interp_mode=0;
    PyObject* pyobj_border_mode = NULL;
    int border_mode=0;
    PyObject* pyobj_dst_size = NULL;
    Size dst_size;
    PyObject* pyobj_dst = NULL;
    UMat dst;

    const char* keywords[] = { "src", "K", "R", "interp_mode", "border_mode", "dst_size", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOOOOO|O:PyRotationWarper.warpBackward", (char**)keywords, &pyobj_src, &pyobj_K, &pyobj_R, &pyobj_interp_mode, &pyobj_border_mode, &pyobj_dst_size, &pyobj_dst) &&
        pyopencv_to_safe(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to_safe(pyobj_K, K, ArgInfo("K", 0)) &&
        pyopencv_to_safe(pyobj_R, R, ArgInfo("R", 0)) &&
        pyopencv_to_safe(pyobj_interp_mode, interp_mode, ArgInfo("interp_mode", 0)) &&
        pyopencv_to_safe(pyobj_border_mode, border_mode, ArgInfo("border_mode", 0)) &&
        pyopencv_to_safe(pyobj_dst_size, dst_size, ArgInfo("dst_size", 0)) &&
        pyopencv_to_safe(pyobj_dst, dst, ArgInfo("dst", 1)) )
    {
        ERRWRAP2(_self_->warpBackward(src, K, R, interp_mode, border_mode, dst_size, dst));
        return pyopencv_from(dst);
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("warpBackward");

    return NULL;
}

static PyObject* pyopencv_cv_PyRotationWarper_warpPoint(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::PyRotationWarper> * self1 = 0;
    if (!pyopencv_PyRotationWarper_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'PyRotationWarper' or its derivative)");
    Ptr<cv::PyRotationWarper> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_pt = NULL;
    Point2f pt;
    PyObject* pyobj_K = NULL;
    Mat K;
    PyObject* pyobj_R = NULL;
    Mat R;
    Point2f retval;

    const char* keywords[] = { "pt", "K", "R", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOO:PyRotationWarper.warpPoint", (char**)keywords, &pyobj_pt, &pyobj_K, &pyobj_R) &&
        pyopencv_to_safe(pyobj_pt, pt, ArgInfo("pt", 0)) &&
        pyopencv_to_safe(pyobj_K, K, ArgInfo("K", 0)) &&
        pyopencv_to_safe(pyobj_R, R, ArgInfo("R", 0)) )
    {
        ERRWRAP2(retval = _self_->warpPoint(pt, K, R));
        return pyopencv_from(retval);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_pt = NULL;
    Point2f pt;
    PyObject* pyobj_K = NULL;
    UMat K;
    PyObject* pyobj_R = NULL;
    UMat R;
    Point2f retval;

    const char* keywords[] = { "pt", "K", "R", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOO:PyRotationWarper.warpPoint", (char**)keywords, &pyobj_pt, &pyobj_K, &pyobj_R) &&
        pyopencv_to_safe(pyobj_pt, pt, ArgInfo("pt", 0)) &&
        pyopencv_to_safe(pyobj_K, K, ArgInfo("K", 0)) &&
        pyopencv_to_safe(pyobj_R, R, ArgInfo("R", 0)) )
    {
        ERRWRAP2(retval = _self_->warpPoint(pt, K, R));
        return pyopencv_from(retval);
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("warpPoint");

    return NULL;
}

static PyObject* pyopencv_cv_PyRotationWarper_warpPointBackward(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::PyRotationWarper> * self1 = 0;
    if (!pyopencv_PyRotationWarper_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'PyRotationWarper' or its derivative)");
    Ptr<cv::PyRotationWarper> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(4);

    {
    PyObject* pyobj_pt = NULL;
    Point2f pt;
    PyObject* pyobj_K = NULL;
    Mat K;
    PyObject* pyobj_R = NULL;
    Mat R;
    Point2f retval;

    const char* keywords[] = { "pt", "K", "R", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOO:PyRotationWarper.warpPointBackward", (char**)keywords, &pyobj_pt, &pyobj_K, &pyobj_R) &&
        pyopencv_to_safe(pyobj_pt, pt, ArgInfo("pt", 0)) &&
        pyopencv_to_safe(pyobj_K, K, ArgInfo("K", 0)) &&
        pyopencv_to_safe(pyobj_R, R, ArgInfo("R", 0)) )
    {
        ERRWRAP2(retval = _self_->warpPointBackward(pt, K, R));
        return pyopencv_from(retval);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_pt = NULL;
    Point2f pt;
    PyObject* pyobj_K = NULL;
    UMat K;
    PyObject* pyobj_R = NULL;
    UMat R;
    Point2f retval;

    const char* keywords[] = { "pt", "K", "R", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOO:PyRotationWarper.warpPointBackward", (char**)keywords, &pyobj_pt, &pyobj_K, &pyobj_R) &&
        pyopencv_to_safe(pyobj_pt, pt, ArgInfo("pt", 0)) &&
        pyopencv_to_safe(pyobj_K, K, ArgInfo("K", 0)) &&
        pyopencv_to_safe(pyobj_R, R, ArgInfo("R", 0)) )
    {
        ERRWRAP2(retval = _self_->warpPointBackward(pt, K, R));
        return pyopencv_from(retval);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_pt = NULL;
    Point2f pt;
    PyObject* pyobj_K = NULL;
    Mat K;
    PyObject* pyobj_R = NULL;
    Mat R;
    Point2f retval;

    const char* keywords[] = { "pt", "K", "R", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOO:PyRotationWarper.warpPointBackward", (char**)keywords, &pyobj_pt, &pyobj_K, &pyobj_R) &&
        pyopencv_to_safe(pyobj_pt, pt, ArgInfo("pt", 0)) &&
        pyopencv_to_safe(pyobj_K, K, ArgInfo("K", 0)) &&
        pyopencv_to_safe(pyobj_R, R, ArgInfo("R", 0)) )
    {
        ERRWRAP2(retval = _self_->warpPointBackward(pt, K, R));
        return pyopencv_from(retval);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_pt = NULL;
    Point2f pt;
    PyObject* pyobj_K = NULL;
    UMat K;
    PyObject* pyobj_R = NULL;
    UMat R;
    Point2f retval;

    const char* keywords[] = { "pt", "K", "R", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOO:PyRotationWarper.warpPointBackward", (char**)keywords, &pyobj_pt, &pyobj_K, &pyobj_R) &&
        pyopencv_to_safe(pyobj_pt, pt, ArgInfo("pt", 0)) &&
        pyopencv_to_safe(pyobj_K, K, ArgInfo("K", 0)) &&
        pyopencv_to_safe(pyobj_R, R, ArgInfo("R", 0)) )
    {
        ERRWRAP2(retval = _self_->warpPointBackward(pt, K, R));
        return pyopencv_from(retval);
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("warpPointBackward");

    return NULL;
}

static PyObject* pyopencv_cv_PyRotationWarper_warpRoi(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::PyRotationWarper> * self1 = 0;
    if (!pyopencv_PyRotationWarper_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'PyRotationWarper' or its derivative)");
    Ptr<cv::PyRotationWarper> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_src_size = NULL;
    Size src_size;
    PyObject* pyobj_K = NULL;
    Mat K;
    PyObject* pyobj_R = NULL;
    Mat R;
    Rect retval;

    const char* keywords[] = { "src_size", "K", "R", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOO:PyRotationWarper.warpRoi", (char**)keywords, &pyobj_src_size, &pyobj_K, &pyobj_R) &&
        pyopencv_to_safe(pyobj_src_size, src_size, ArgInfo("src_size", 0)) &&
        pyopencv_to_safe(pyobj_K, K, ArgInfo("K", 0)) &&
        pyopencv_to_safe(pyobj_R, R, ArgInfo("R", 0)) )
    {
        ERRWRAP2(retval = _self_->warpRoi(src_size, K, R));
        return pyopencv_from(retval);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_src_size = NULL;
    Size src_size;
    PyObject* pyobj_K = NULL;
    UMat K;
    PyObject* pyobj_R = NULL;
    UMat R;
    Rect retval;

    const char* keywords[] = { "src_size", "K", "R", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOO:PyRotationWarper.warpRoi", (char**)keywords, &pyobj_src_size, &pyobj_K, &pyobj_R) &&
        pyopencv_to_safe(pyobj_src_size, src_size, ArgInfo("src_size", 0)) &&
        pyopencv_to_safe(pyobj_K, K, ArgInfo("K", 0)) &&
        pyopencv_to_safe(pyobj_R, R, ArgInfo("R", 0)) )
    {
        ERRWRAP2(retval = _self_->warpRoi(src_size, K, R));
        return pyopencv_from(retval);
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("warpRoi");

    return NULL;
}



// Tables (PyRotationWarper)

static PyGetSetDef pyopencv_PyRotationWarper_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_PyRotationWarper_methods[] =
{
    {"buildMaps", CV_PY_FN_WITH_KW_(pyopencv_cv_PyRotationWarper_buildMaps, 0), "buildMaps(src_size, K, R[, xmap[, ymap]]) -> retval, xmap, ymap\n.   @brief Builds the projection maps according to the given camera data.\n.   \n.           @param src_size Source image size\n.           @param K Camera intrinsic parameters\n.           @param R Camera rotation matrix\n.           @param xmap Projection map for the x axis\n.           @param ymap Projection map for the y axis\n.           @return Projected image minimum bounding box"},
    {"getScale", CV_PY_FN_WITH_KW_(pyopencv_cv_PyRotationWarper_getScale, 0), "getScale() -> retval\n."},
    {"setScale", CV_PY_FN_WITH_KW_(pyopencv_cv_PyRotationWarper_setScale, 0), "setScale(arg1) -> None\n."},
    {"warp", CV_PY_FN_WITH_KW_(pyopencv_cv_PyRotationWarper_warp, 0), "warp(src, K, R, interp_mode, border_mode[, dst]) -> retval, dst\n.   @brief Projects the image.\n.   \n.           @param src Source image\n.           @param K Camera intrinsic parameters\n.           @param R Camera rotation matrix\n.           @param interp_mode Interpolation mode\n.           @param border_mode Border extrapolation mode\n.           @param dst Projected image\n.           @return Project image top-left corner"},
    {"warpBackward", CV_PY_FN_WITH_KW_(pyopencv_cv_PyRotationWarper_warpBackward, 0), "warpBackward(src, K, R, interp_mode, border_mode, dst_size[, dst]) -> dst\n.   @brief Projects the image backward.\n.   \n.           @param src Projected image\n.           @param K Camera intrinsic parameters\n.           @param R Camera rotation matrix\n.           @param interp_mode Interpolation mode\n.           @param border_mode Border extrapolation mode\n.           @param dst_size Backward-projected image size\n.           @param dst Backward-projected image"},
    {"warpPoint", CV_PY_FN_WITH_KW_(pyopencv_cv_PyRotationWarper_warpPoint, 0), "warpPoint(pt, K, R) -> retval\n.   @brief Projects the image point.\n.   \n.           @param pt Source point\n.           @param K Camera intrinsic parameters\n.           @param R Camera rotation matrix\n.           @return Projected point"},
    {"warpPointBackward", CV_PY_FN_WITH_KW_(pyopencv_cv_PyRotationWarper_warpPointBackward, 0), "warpPointBackward(pt, K, R) -> retval\n.   @brief Projects the image point backward.\n.   \n.           @param pt Projected point\n.           @param K Camera intrinsic parameters\n.           @param R Camera rotation matrix\n.           @return Backward-projected point"},
    {"warpRoi", CV_PY_FN_WITH_KW_(pyopencv_cv_PyRotationWarper_warpRoi, 0), "warpRoi(src_size, K, R) -> retval\n.   @param src_size Source image bounding box\n.           @param K Camera intrinsic parameters\n.           @param R Camera rotation matrix\n.           @return Projected image minimum bounding box"},

    {NULL,          NULL}
};

// Converter (PyRotationWarper)

template<>
struct PyOpenCV_Converter< Ptr<cv::PyRotationWarper> >
{
    static PyObject* from(const Ptr<cv::PyRotationWarper>& r)
    {
        return pyopencv_PyRotationWarper_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::PyRotationWarper>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::PyRotationWarper> * dst_;
        if (pyopencv_PyRotationWarper_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::PyRotationWarper> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// QRCodeDetector (Generic)
//================================================================================

// GetSet (QRCodeDetector)



// Methods (QRCodeDetector)

static int pyopencv_cv_QRCodeDetector_QRCodeDetector(pyopencv_QRCodeDetector_t* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        if(self) ERRWRAP2(new (&(self->v)) cv::QRCodeDetector());
        return 0;
    }

    return -1;
}

static PyObject* pyopencv_cv_QRCodeDetector_decodeCurved(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    cv::QRCodeDetector * self1 = 0;
    if (!pyopencv_QRCodeDetector_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'QRCodeDetector' or its derivative)");
    cv::QRCodeDetector* _self_ = (self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_img = NULL;
    Mat img;
    PyObject* pyobj_points = NULL;
    Mat points;
    PyObject* pyobj_straight_qrcode = NULL;
    Mat straight_qrcode;
    cv::String retval;

    const char* keywords[] = { "img", "points", "straight_qrcode", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO|O:QRCodeDetector.decodeCurved", (char**)keywords, &pyobj_img, &pyobj_points, &pyobj_straight_qrcode) &&
        pyopencv_to_safe(pyobj_img, img, ArgInfo("img", 0)) &&
        pyopencv_to_safe(pyobj_points, points, ArgInfo("points", 0)) &&
        pyopencv_to_safe(pyobj_straight_qrcode, straight_qrcode, ArgInfo("straight_qrcode", 1)) )
    {
        ERRWRAP2(retval = _self_->decodeCurved(img, points, straight_qrcode));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(straight_qrcode));
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_img = NULL;
    UMat img;
    PyObject* pyobj_points = NULL;
    UMat points;
    PyObject* pyobj_straight_qrcode = NULL;
    UMat straight_qrcode;
    cv::String retval;

    const char* keywords[] = { "img", "points", "straight_qrcode", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO|O:QRCodeDetector.decodeCurved", (char**)keywords, &pyobj_img, &pyobj_points, &pyobj_straight_qrcode) &&
        pyopencv_to_safe(pyobj_img, img, ArgInfo("img", 0)) &&
        pyopencv_to_safe(pyobj_points, points, ArgInfo("points", 0)) &&
        pyopencv_to_safe(pyobj_straight_qrcode, straight_qrcode, ArgInfo("straight_qrcode", 1)) )
    {
        ERRWRAP2(retval = _self_->decodeCurved(img, points, straight_qrcode));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(straight_qrcode));
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("decodeCurved");

    return NULL;
}

static PyObject* pyopencv_cv_QRCodeDetector_detectAndDecodeCurved(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    cv::QRCodeDetector * self1 = 0;
    if (!pyopencv_QRCodeDetector_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'QRCodeDetector' or its derivative)");
    cv::QRCodeDetector* _self_ = (self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_img = NULL;
    Mat img;
    PyObject* pyobj_points = NULL;
    Mat points;
    PyObject* pyobj_straight_qrcode = NULL;
    Mat straight_qrcode;
    std::string retval;

    const char* keywords[] = { "img", "points", "straight_qrcode", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|OO:QRCodeDetector.detectAndDecodeCurved", (char**)keywords, &pyobj_img, &pyobj_points, &pyobj_straight_qrcode) &&
        pyopencv_to_safe(pyobj_img, img, ArgInfo("img", 0)) &&
        pyopencv_to_safe(pyobj_points, points, ArgInfo("points", 1)) &&
        pyopencv_to_safe(pyobj_straight_qrcode, straight_qrcode, ArgInfo("straight_qrcode", 1)) )
    {
        ERRWRAP2(retval = _self_->detectAndDecodeCurved(img, points, straight_qrcode));
        return Py_BuildValue("(NNN)", pyopencv_from(retval), pyopencv_from(points), pyopencv_from(straight_qrcode));
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_img = NULL;
    UMat img;
    PyObject* pyobj_points = NULL;
    UMat points;
    PyObject* pyobj_straight_qrcode = NULL;
    UMat straight_qrcode;
    std::string retval;

    const char* keywords[] = { "img", "points", "straight_qrcode", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|OO:QRCodeDetector.detectAndDecodeCurved", (char**)keywords, &pyobj_img, &pyobj_points, &pyobj_straight_qrcode) &&
        pyopencv_to_safe(pyobj_img, img, ArgInfo("img", 0)) &&
        pyopencv_to_safe(pyobj_points, points, ArgInfo("points", 1)) &&
        pyopencv_to_safe(pyobj_straight_qrcode, straight_qrcode, ArgInfo("straight_qrcode", 1)) )
    {
        ERRWRAP2(retval = _self_->detectAndDecodeCurved(img, points, straight_qrcode));
        return Py_BuildValue("(NNN)", pyopencv_from(retval), pyopencv_from(points), pyopencv_from(straight_qrcode));
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("detectAndDecodeCurved");

    return NULL;
}

static PyObject* pyopencv_cv_QRCodeDetector_setEpsX(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    cv::QRCodeDetector * self1 = 0;
    if (!pyopencv_QRCodeDetector_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'QRCodeDetector' or its derivative)");
    cv::QRCodeDetector* _self_ = (self1);
    PyObject* pyobj_epsX = NULL;
    double epsX=0;
    QRCodeDetector retval;

    const char* keywords[] = { "epsX", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:QRCodeDetector.setEpsX", (char**)keywords, &pyobj_epsX) &&
        pyopencv_to_safe(pyobj_epsX, epsX, ArgInfo("epsX", 0)) )
    {
        ERRWRAP2(retval = _self_->setEpsX(epsX));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_QRCodeDetector_setEpsY(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    cv::QRCodeDetector * self1 = 0;
    if (!pyopencv_QRCodeDetector_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'QRCodeDetector' or its derivative)");
    cv::QRCodeDetector* _self_ = (self1);
    PyObject* pyobj_epsY = NULL;
    double epsY=0;
    QRCodeDetector retval;

    const char* keywords[] = { "epsY", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:QRCodeDetector.setEpsY", (char**)keywords, &pyobj_epsY) &&
        pyopencv_to_safe(pyobj_epsY, epsY, ArgInfo("epsY", 0)) )
    {
        ERRWRAP2(retval = _self_->setEpsY(epsY));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_QRCodeDetector_setUseAlignmentMarkers(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    cv::QRCodeDetector * self1 = 0;
    if (!pyopencv_QRCodeDetector_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'QRCodeDetector' or its derivative)");
    cv::QRCodeDetector* _self_ = (self1);
    PyObject* pyobj_useAlignmentMarkers = NULL;
    bool useAlignmentMarkers=0;
    QRCodeDetector retval;

    const char* keywords[] = { "useAlignmentMarkers", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:QRCodeDetector.setUseAlignmentMarkers", (char**)keywords, &pyobj_useAlignmentMarkers) &&
        pyopencv_to_safe(pyobj_useAlignmentMarkers, useAlignmentMarkers, ArgInfo("useAlignmentMarkers", 0)) )
    {
        ERRWRAP2(retval = _self_->setUseAlignmentMarkers(useAlignmentMarkers));
        return pyopencv_from(retval);
    }

    return NULL;
}



// Tables (QRCodeDetector)

static PyGetSetDef pyopencv_QRCodeDetector_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_QRCodeDetector_methods[] =
{
    {"decodeCurved", CV_PY_FN_WITH_KW_(pyopencv_cv_QRCodeDetector_decodeCurved, 0), "decodeCurved(img, points[, straight_qrcode]) -> retval, straight_qrcode\n.   @brief Decodes QR code on a curved surface in image once it's found by the detect() method.\n.   \n.        Returns UTF8-encoded output string or empty string if the code cannot be decoded.\n.        @param img grayscale or color (BGR) image containing QR code.\n.        @param points Quadrangle vertices found by detect() method (or some other algorithm).\n.        @param straight_qrcode The optional output image containing rectified and binarized QR code"},
    {"detectAndDecodeCurved", CV_PY_FN_WITH_KW_(pyopencv_cv_QRCodeDetector_detectAndDecodeCurved, 0), "detectAndDecodeCurved(img[, points[, straight_qrcode]]) -> retval, points, straight_qrcode\n.   @brief Both detects and decodes QR code on a curved surface\n.   \n.        @param img grayscale or color (BGR) image containing QR code.\n.        @param points optional output array of vertices of the found QR code quadrangle. Will be empty if not found.\n.        @param straight_qrcode The optional output image containing rectified and binarized QR code"},
    {"setEpsX", CV_PY_FN_WITH_KW_(pyopencv_cv_QRCodeDetector_setEpsX, 0), "setEpsX(epsX) -> retval\n.   @brief sets the epsilon used during the horizontal scan of QR code stop marker detection.\n.        @param epsX Epsilon neighborhood, which allows you to determine the horizontal pattern\n.        of the scheme 1:1:3:1:1 according to QR code standard."},
    {"setEpsY", CV_PY_FN_WITH_KW_(pyopencv_cv_QRCodeDetector_setEpsY, 0), "setEpsY(epsY) -> retval\n.   @brief sets the epsilon used during the vertical scan of QR code stop marker detection.\n.        @param epsY Epsilon neighborhood, which allows you to determine the vertical pattern\n.        of the scheme 1:1:3:1:1 according to QR code standard."},
    {"setUseAlignmentMarkers", CV_PY_FN_WITH_KW_(pyopencv_cv_QRCodeDetector_setUseAlignmentMarkers, 0), "setUseAlignmentMarkers(useAlignmentMarkers) -> retval\n.   @brief use markers to improve the position of the corners of the QR code\n.        *\n.        * alignmentMarkers using by default"},

    {NULL,          NULL}
};

// Converter (QRCodeDetector)

template<>
struct PyOpenCV_Converter< cv::QRCodeDetector >
{
    static PyObject* from(const cv::QRCodeDetector& r)
    {
        return pyopencv_QRCodeDetector_Instance(r);
    }
    static bool to(PyObject* src, cv::QRCodeDetector& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        cv::QRCodeDetector * dst_;
        if (pyopencv_QRCodeDetector_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected cv::QRCodeDetector for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// QRCodeDetectorAruco (Generic)
//================================================================================

// GetSet (QRCodeDetectorAruco)



// Methods (QRCodeDetectorAruco)

static int pyopencv_cv_QRCodeDetectorAruco_QRCodeDetectorAruco(pyopencv_QRCodeDetectorAruco_t* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    pyPrepareArgumentConversionErrorsStorage(2);

    {

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        if(self) ERRWRAP2(new (&(self->v)) cv::QRCodeDetectorAruco());
        return 0;
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_params = NULL;
    cv::QRCodeDetectorAruco::Params params;

    const char* keywords[] = { "params", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:QRCodeDetectorAruco", (char**)keywords, &pyobj_params) &&
        pyopencv_to_safe(pyobj_params, params, ArgInfo("params", 0)) )
    {
        if(self) ERRWRAP2(new (&(self->v)) cv::QRCodeDetectorAruco(params));
        return 0;
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("QRCodeDetectorAruco");

    return -1;
}

static PyObject* pyopencv_cv_QRCodeDetectorAruco_getArucoParameters(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    cv::QRCodeDetectorAruco * self1 = 0;
    if (!pyopencv_QRCodeDetectorAruco_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'QRCodeDetectorAruco' or its derivative)");
    cv::QRCodeDetectorAruco* _self_ = (self1);
    aruco::DetectorParameters retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getArucoParameters());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_QRCodeDetectorAruco_getDetectorParameters(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    cv::QRCodeDetectorAruco * self1 = 0;
    if (!pyopencv_QRCodeDetectorAruco_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'QRCodeDetectorAruco' or its derivative)");
    cv::QRCodeDetectorAruco* _self_ = (self1);
    QRCodeDetectorAruco::Params retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getDetectorParameters());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_QRCodeDetectorAruco_setArucoParameters(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    cv::QRCodeDetectorAruco * self1 = 0;
    if (!pyopencv_QRCodeDetectorAruco_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'QRCodeDetectorAruco' or its derivative)");
    cv::QRCodeDetectorAruco* _self_ = (self1);
    PyObject* pyobj_params = NULL;
    cv::aruco::DetectorParameters params;

    const char* keywords[] = { "params", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:QRCodeDetectorAruco.setArucoParameters", (char**)keywords, &pyobj_params) &&
        pyopencv_to_safe(pyobj_params, params, ArgInfo("params", 0)) )
    {
        ERRWRAP2(_self_->setArucoParameters(params));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_QRCodeDetectorAruco_setDetectorParameters(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    cv::QRCodeDetectorAruco * self1 = 0;
    if (!pyopencv_QRCodeDetectorAruco_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'QRCodeDetectorAruco' or its derivative)");
    cv::QRCodeDetectorAruco* _self_ = (self1);
    PyObject* pyobj_params = NULL;
    cv::QRCodeDetectorAruco::Params params;
    QRCodeDetectorAruco retval;

    const char* keywords[] = { "params", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:QRCodeDetectorAruco.setDetectorParameters", (char**)keywords, &pyobj_params) &&
        pyopencv_to_safe(pyobj_params, params, ArgInfo("params", 0)) )
    {
        ERRWRAP2(retval = _self_->setDetectorParameters(params));
        return pyopencv_from(retval);
    }

    return NULL;
}



// Tables (QRCodeDetectorAruco)

static PyGetSetDef pyopencv_QRCodeDetectorAruco_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_QRCodeDetectorAruco_methods[] =
{
    {"getArucoParameters", CV_PY_FN_WITH_KW_(pyopencv_cv_QRCodeDetectorAruco_getArucoParameters, 0), "getArucoParameters() -> retval\n.   @brief Aruco detector parameters are used to search for the finder patterns."},
    {"getDetectorParameters", CV_PY_FN_WITH_KW_(pyopencv_cv_QRCodeDetectorAruco_getDetectorParameters, 0), "getDetectorParameters() -> retval\n.   @brief Detector parameters getter. See cv::QRCodeDetectorAruco::Params"},
    {"setArucoParameters", CV_PY_FN_WITH_KW_(pyopencv_cv_QRCodeDetectorAruco_setArucoParameters, 0), "setArucoParameters(params) -> None\n.   @brief Aruco detector parameters are used to search for the finder patterns."},
    {"setDetectorParameters", CV_PY_FN_WITH_KW_(pyopencv_cv_QRCodeDetectorAruco_setDetectorParameters, 0), "setDetectorParameters(params) -> retval\n.   @brief Detector parameters setter. See cv::QRCodeDetectorAruco::Params"},

    {NULL,          NULL}
};

// Converter (QRCodeDetectorAruco)

template<>
struct PyOpenCV_Converter< cv::QRCodeDetectorAruco >
{
    static PyObject* from(const cv::QRCodeDetectorAruco& r)
    {
        return pyopencv_QRCodeDetectorAruco_Instance(r);
    }
    static bool to(PyObject* src, cv::QRCodeDetectorAruco& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        cv::QRCodeDetectorAruco * dst_;
        if (pyopencv_QRCodeDetectorAruco_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected cv::QRCodeDetectorAruco for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// QRCodeDetectorAruco_Params (Generic)
//================================================================================

// GetSet (QRCodeDetectorAruco_Params)


static PyObject* pyopencv_QRCodeDetectorAruco_Params_get_maxColorsMismatch(pyopencv_QRCodeDetectorAruco_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.maxColorsMismatch);
}

static int pyopencv_QRCodeDetectorAruco_Params_set_maxColorsMismatch(pyopencv_QRCodeDetectorAruco_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the maxColorsMismatch attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.maxColorsMismatch, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_QRCodeDetectorAruco_Params_get_maxModuleSizeMismatch(pyopencv_QRCodeDetectorAruco_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.maxModuleSizeMismatch);
}

static int pyopencv_QRCodeDetectorAruco_Params_set_maxModuleSizeMismatch(pyopencv_QRCodeDetectorAruco_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the maxModuleSizeMismatch attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.maxModuleSizeMismatch, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_QRCodeDetectorAruco_Params_get_maxPenalties(pyopencv_QRCodeDetectorAruco_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.maxPenalties);
}

static int pyopencv_QRCodeDetectorAruco_Params_set_maxPenalties(pyopencv_QRCodeDetectorAruco_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the maxPenalties attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.maxPenalties, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_QRCodeDetectorAruco_Params_get_maxRotation(pyopencv_QRCodeDetectorAruco_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.maxRotation);
}

static int pyopencv_QRCodeDetectorAruco_Params_set_maxRotation(pyopencv_QRCodeDetectorAruco_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the maxRotation attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.maxRotation, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_QRCodeDetectorAruco_Params_get_maxTimingPatternMismatch(pyopencv_QRCodeDetectorAruco_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.maxTimingPatternMismatch);
}

static int pyopencv_QRCodeDetectorAruco_Params_set_maxTimingPatternMismatch(pyopencv_QRCodeDetectorAruco_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the maxTimingPatternMismatch attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.maxTimingPatternMismatch, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_QRCodeDetectorAruco_Params_get_minModuleSizeInPyramid(pyopencv_QRCodeDetectorAruco_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.minModuleSizeInPyramid);
}

static int pyopencv_QRCodeDetectorAruco_Params_set_minModuleSizeInPyramid(pyopencv_QRCodeDetectorAruco_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the minModuleSizeInPyramid attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.minModuleSizeInPyramid, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_QRCodeDetectorAruco_Params_get_scaleTimingPatternScore(pyopencv_QRCodeDetectorAruco_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.scaleTimingPatternScore);
}

static int pyopencv_QRCodeDetectorAruco_Params_set_scaleTimingPatternScore(pyopencv_QRCodeDetectorAruco_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the scaleTimingPatternScore attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.scaleTimingPatternScore, ArgInfo("value", 0)) ? 0 : -1;
}


// Methods (QRCodeDetectorAruco_Params)

static int pyopencv_cv_QRCodeDetectorAruco_Params_QRCodeDetectorAruco_Params(pyopencv_QRCodeDetectorAruco_Params_t* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        if(self) ERRWRAP2(new (&(self->v)) cv::QRCodeDetectorAruco::Params());
        return 0;
    }

    return -1;
}



// Tables (QRCodeDetectorAruco_Params)

static PyGetSetDef pyopencv_QRCodeDetectorAruco_Params_getseters[] =
{
    {(char*)"maxColorsMismatch", (getter)pyopencv_QRCodeDetectorAruco_Params_get_maxColorsMismatch, (setter)pyopencv_QRCodeDetectorAruco_Params_set_maxColorsMismatch, (char*)"maxColorsMismatch", NULL},
    {(char*)"maxModuleSizeMismatch", (getter)pyopencv_QRCodeDetectorAruco_Params_get_maxModuleSizeMismatch, (setter)pyopencv_QRCodeDetectorAruco_Params_set_maxModuleSizeMismatch, (char*)"maxModuleSizeMismatch", NULL},
    {(char*)"maxPenalties", (getter)pyopencv_QRCodeDetectorAruco_Params_get_maxPenalties, (setter)pyopencv_QRCodeDetectorAruco_Params_set_maxPenalties, (char*)"maxPenalties", NULL},
    {(char*)"maxRotation", (getter)pyopencv_QRCodeDetectorAruco_Params_get_maxRotation, (setter)pyopencv_QRCodeDetectorAruco_Params_set_maxRotation, (char*)"maxRotation", NULL},
    {(char*)"maxTimingPatternMismatch", (getter)pyopencv_QRCodeDetectorAruco_Params_get_maxTimingPatternMismatch, (setter)pyopencv_QRCodeDetectorAruco_Params_set_maxTimingPatternMismatch, (char*)"maxTimingPatternMismatch", NULL},
    {(char*)"minModuleSizeInPyramid", (getter)pyopencv_QRCodeDetectorAruco_Params_get_minModuleSizeInPyramid, (setter)pyopencv_QRCodeDetectorAruco_Params_set_minModuleSizeInPyramid, (char*)"minModuleSizeInPyramid", NULL},
    {(char*)"scaleTimingPatternScore", (getter)pyopencv_QRCodeDetectorAruco_Params_get_scaleTimingPatternScore, (setter)pyopencv_QRCodeDetectorAruco_Params_set_scaleTimingPatternScore, (char*)"scaleTimingPatternScore", NULL},
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_QRCodeDetectorAruco_Params_methods[] =
{

    {NULL,          NULL}
};

// Converter (QRCodeDetectorAruco_Params)

template<>
struct PyOpenCV_Converter< cv::QRCodeDetectorAruco::Params >
{
    static PyObject* from(const cv::QRCodeDetectorAruco::Params& r)
    {
        return pyopencv_QRCodeDetectorAruco_Params_Instance(r);
    }
    static bool to(PyObject* src, cv::QRCodeDetectorAruco::Params& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        cv::QRCodeDetectorAruco::Params * dst_;
        if (pyopencv_QRCodeDetectorAruco_Params_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected cv::QRCodeDetectorAruco::Params for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// QRCodeEncoder (Generic)
//================================================================================

// GetSet (QRCodeEncoder)



// Methods (QRCodeEncoder)

static PyObject* pyopencv_cv_QRCodeEncoder_create_static(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    PyObject* pyobj_parameters = NULL;
    cv::QRCodeEncoder::Params parameters=QRCodeEncoder::Params();
    Ptr<QRCodeEncoder> retval;

    const char* keywords[] = { "parameters", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "|O:QRCodeEncoder.create", (char**)keywords, &pyobj_parameters) &&
        pyopencv_to_safe(pyobj_parameters, parameters, ArgInfo("parameters", 0)) )
    {
        ERRWRAP2(retval = cv::QRCodeEncoder::create(parameters));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_QRCodeEncoder_encode(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::QRCodeEncoder> * self1 = 0;
    if (!pyopencv_QRCodeEncoder_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'QRCodeEncoder' or its derivative)");
    Ptr<cv::QRCodeEncoder> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_encoded_info = NULL;
    String encoded_info;
    PyObject* pyobj_qrcode = NULL;
    Mat qrcode;

    const char* keywords[] = { "encoded_info", "qrcode", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|O:QRCodeEncoder.encode", (char**)keywords, &pyobj_encoded_info, &pyobj_qrcode) &&
        pyopencv_to_safe(pyobj_encoded_info, encoded_info, ArgInfo("encoded_info", 0)) &&
        pyopencv_to_safe(pyobj_qrcode, qrcode, ArgInfo("qrcode", 1)) )
    {
        ERRWRAP2(_self_->encode(encoded_info, qrcode));
        return pyopencv_from(qrcode);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_encoded_info = NULL;
    String encoded_info;
    PyObject* pyobj_qrcode = NULL;
    UMat qrcode;

    const char* keywords[] = { "encoded_info", "qrcode", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|O:QRCodeEncoder.encode", (char**)keywords, &pyobj_encoded_info, &pyobj_qrcode) &&
        pyopencv_to_safe(pyobj_encoded_info, encoded_info, ArgInfo("encoded_info", 0)) &&
        pyopencv_to_safe(pyobj_qrcode, qrcode, ArgInfo("qrcode", 1)) )
    {
        ERRWRAP2(_self_->encode(encoded_info, qrcode));
        return pyopencv_from(qrcode);
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("encode");

    return NULL;
}

static PyObject* pyopencv_cv_QRCodeEncoder_encodeStructuredAppend(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::QRCodeEncoder> * self1 = 0;
    if (!pyopencv_QRCodeEncoder_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'QRCodeEncoder' or its derivative)");
    Ptr<cv::QRCodeEncoder> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_encoded_info = NULL;
    String encoded_info;
    PyObject* pyobj_qrcodes = NULL;
    vector_Mat qrcodes;

    const char* keywords[] = { "encoded_info", "qrcodes", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|O:QRCodeEncoder.encodeStructuredAppend", (char**)keywords, &pyobj_encoded_info, &pyobj_qrcodes) &&
        pyopencv_to_safe(pyobj_encoded_info, encoded_info, ArgInfo("encoded_info", 0)) &&
        pyopencv_to_safe(pyobj_qrcodes, qrcodes, ArgInfo("qrcodes", 1)) )
    {
        ERRWRAP2(_self_->encodeStructuredAppend(encoded_info, qrcodes));
        return pyopencv_from(qrcodes);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_encoded_info = NULL;
    String encoded_info;
    PyObject* pyobj_qrcodes = NULL;
    vector_UMat qrcodes;

    const char* keywords[] = { "encoded_info", "qrcodes", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|O:QRCodeEncoder.encodeStructuredAppend", (char**)keywords, &pyobj_encoded_info, &pyobj_qrcodes) &&
        pyopencv_to_safe(pyobj_encoded_info, encoded_info, ArgInfo("encoded_info", 0)) &&
        pyopencv_to_safe(pyobj_qrcodes, qrcodes, ArgInfo("qrcodes", 1)) )
    {
        ERRWRAP2(_self_->encodeStructuredAppend(encoded_info, qrcodes));
        return pyopencv_from(qrcodes);
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("encodeStructuredAppend");

    return NULL;
}



// Tables (QRCodeEncoder)

static PyGetSetDef pyopencv_QRCodeEncoder_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_QRCodeEncoder_methods[] =
{
    {"create", CV_PY_FN_WITH_KW_(pyopencv_cv_QRCodeEncoder_create_static, METH_STATIC), "create([, parameters]) -> retval\n.   @brief Constructor\n.       @param parameters QR code encoder parameters QRCodeEncoder::Params"},
    {"encode", CV_PY_FN_WITH_KW_(pyopencv_cv_QRCodeEncoder_encode, 0), "encode(encoded_info[, qrcode]) -> qrcode\n.   @brief Generates QR code from input string.\n.        @param encoded_info Input string to encode.\n.        @param qrcode Generated QR code."},
    {"encodeStructuredAppend", CV_PY_FN_WITH_KW_(pyopencv_cv_QRCodeEncoder_encodeStructuredAppend, 0), "encodeStructuredAppend(encoded_info[, qrcodes]) -> qrcodes\n.   @brief Generates QR code from input string in Structured Append mode. The encoded message is splitting over a number of QR codes.\n.        @param encoded_info Input string to encode.\n.        @param qrcodes Vector of generated QR codes."},

    {NULL,          NULL}
};

// Converter (QRCodeEncoder)

template<>
struct PyOpenCV_Converter< Ptr<cv::QRCodeEncoder> >
{
    static PyObject* from(const Ptr<cv::QRCodeEncoder>& r)
    {
        return pyopencv_QRCodeEncoder_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::QRCodeEncoder>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::QRCodeEncoder> * dst_;
        if (pyopencv_QRCodeEncoder_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::QRCodeEncoder> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// QRCodeEncoder_Params (Generic)
//================================================================================

// GetSet (QRCodeEncoder_Params)


static PyObject* pyopencv_QRCodeEncoder_Params_get_correction_level(pyopencv_QRCodeEncoder_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.correction_level);
}

static int pyopencv_QRCodeEncoder_Params_set_correction_level(pyopencv_QRCodeEncoder_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the correction_level attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.correction_level, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_QRCodeEncoder_Params_get_mode(pyopencv_QRCodeEncoder_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.mode);
}

static int pyopencv_QRCodeEncoder_Params_set_mode(pyopencv_QRCodeEncoder_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the mode attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.mode, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_QRCodeEncoder_Params_get_structure_number(pyopencv_QRCodeEncoder_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.structure_number);
}

static int pyopencv_QRCodeEncoder_Params_set_structure_number(pyopencv_QRCodeEncoder_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the structure_number attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.structure_number, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_QRCodeEncoder_Params_get_version(pyopencv_QRCodeEncoder_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.version);
}

static int pyopencv_QRCodeEncoder_Params_set_version(pyopencv_QRCodeEncoder_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the version attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.version, ArgInfo("value", 0)) ? 0 : -1;
}


// Methods (QRCodeEncoder_Params)

static int pyopencv_cv_QRCodeEncoder_Params_QRCodeEncoder_Params(pyopencv_QRCodeEncoder_Params_t* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        if(self) ERRWRAP2(new (&(self->v)) cv::QRCodeEncoder::Params());
        return 0;
    }

    return -1;
}



// Tables (QRCodeEncoder_Params)

static PyGetSetDef pyopencv_QRCodeEncoder_Params_getseters[] =
{
    {(char*)"correction_level", (getter)pyopencv_QRCodeEncoder_Params_get_correction_level, (setter)pyopencv_QRCodeEncoder_Params_set_correction_level, (char*)"correction_level", NULL},
    {(char*)"mode", (getter)pyopencv_QRCodeEncoder_Params_get_mode, (setter)pyopencv_QRCodeEncoder_Params_set_mode, (char*)"mode", NULL},
    {(char*)"structure_number", (getter)pyopencv_QRCodeEncoder_Params_get_structure_number, (setter)pyopencv_QRCodeEncoder_Params_set_structure_number, (char*)"structure_number", NULL},
    {(char*)"version", (getter)pyopencv_QRCodeEncoder_Params_get_version, (setter)pyopencv_QRCodeEncoder_Params_set_version, (char*)"version", NULL},
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_QRCodeEncoder_Params_methods[] =
{

    {NULL,          NULL}
};

// Converter (QRCodeEncoder_Params)

template<>
struct PyOpenCV_Converter< cv::QRCodeEncoder::Params >
{
    static PyObject* from(const cv::QRCodeEncoder::Params& r)
    {
        return pyopencv_QRCodeEncoder_Params_Instance(r);
    }
    static bool to(PyObject* src, cv::QRCodeEncoder::Params& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        cv::QRCodeEncoder::Params * dst_;
        if (pyopencv_QRCodeEncoder_Params_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected cv::QRCodeEncoder::Params for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// RotatedRect (Generic)
//================================================================================

// GetSet (RotatedRect)


static PyObject* pyopencv_RotatedRect_get_angle(pyopencv_RotatedRect_t* p, void *closure)
{
    return pyopencv_from(p->v.angle);
}

static int pyopencv_RotatedRect_set_angle(pyopencv_RotatedRect_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the angle attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.angle, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_RotatedRect_get_center(pyopencv_RotatedRect_t* p, void *closure)
{
    return pyopencv_from(p->v.center);
}

static int pyopencv_RotatedRect_set_center(pyopencv_RotatedRect_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the center attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.center, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_RotatedRect_get_size(pyopencv_RotatedRect_t* p, void *closure)
{
    return pyopencv_from(p->v.size);
}

static int pyopencv_RotatedRect_set_size(pyopencv_RotatedRect_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the size attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.size, ArgInfo("value", 0)) ? 0 : -1;
}


// Methods (RotatedRect)

static int pyopencv_cv_RotatedRect_RotatedRect(pyopencv_RotatedRect_t* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    pyPrepareArgumentConversionErrorsStorage(3);

    {

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        if(self) ERRWRAP2(new (&(self->v)) cv::RotatedRect());
        return 0;
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_center = NULL;
    Point2f center;
    PyObject* pyobj_size = NULL;
    Size2f size;
    PyObject* pyobj_angle = NULL;
    float angle=0.f;

    const char* keywords[] = { "center", "size", "angle", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOO:RotatedRect", (char**)keywords, &pyobj_center, &pyobj_size, &pyobj_angle) &&
        pyopencv_to_safe(pyobj_center, center, ArgInfo("center", 0)) &&
        pyopencv_to_safe(pyobj_size, size, ArgInfo("size", 0)) &&
        pyopencv_to_safe(pyobj_angle, angle, ArgInfo("angle", 0)) )
    {
        if(self) ERRWRAP2(new (&(self->v)) cv::RotatedRect(center, size, angle));
        return 0;
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_point1 = NULL;
    Point2f point1;
    PyObject* pyobj_point2 = NULL;
    Point2f point2;
    PyObject* pyobj_point3 = NULL;
    Point2f point3;

    const char* keywords[] = { "point1", "point2", "point3", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOO:RotatedRect", (char**)keywords, &pyobj_point1, &pyobj_point2, &pyobj_point3) &&
        pyopencv_to_safe(pyobj_point1, point1, ArgInfo("point1", 0)) &&
        pyopencv_to_safe(pyobj_point2, point2, ArgInfo("point2", 0)) &&
        pyopencv_to_safe(pyobj_point3, point3, ArgInfo("point3", 0)) )
    {
        if(self) ERRWRAP2(new (&(self->v)) cv::RotatedRect(point1, point2, point3));
        return 0;
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("RotatedRect");

    return -1;
}

static PyObject* pyopencv_cv_RotatedRect_boundingRect(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    cv::RotatedRect * self1 = 0;
    if (!pyopencv_RotatedRect_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'RotatedRect' or its derivative)");
    cv::RotatedRect* _self_ = (self1);
    Rect retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->boundingRect());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_RotatedRect_points(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    cv::RotatedRect * self1 = 0;
    if (!pyopencv_RotatedRect_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'RotatedRect' or its derivative)");
    cv::RotatedRect* _self_ = (self1);
    vector_Point2f pts;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(_self_->points(pts));
        return pyopencv_from(pts);
    }

    return NULL;
}



// Tables (RotatedRect)

static PyGetSetDef pyopencv_RotatedRect_getseters[] =
{
    {(char*)"angle", (getter)pyopencv_RotatedRect_get_angle, (setter)pyopencv_RotatedRect_set_angle, (char*)"angle", NULL},
    {(char*)"center", (getter)pyopencv_RotatedRect_get_center, (setter)pyopencv_RotatedRect_set_center, (char*)"center", NULL},
    {(char*)"size", (getter)pyopencv_RotatedRect_get_size, (setter)pyopencv_RotatedRect_set_size, (char*)"size", NULL},
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_RotatedRect_methods[] =
{
    {"boundingRect", CV_PY_FN_WITH_KW_(pyopencv_cv_RotatedRect_boundingRect, 0), "boundingRect() -> retval\n."},
    {"points", CV_PY_FN_WITH_KW_(pyopencv_cv_RotatedRect_points, 0), "points() -> pts\n.   returns 4 vertices of the rotated rectangle\n.       @param pts The points array for storing rectangle vertices. The order is _bottomLeft_, _topLeft_, topRight, bottomRight.\n.       @note _Bottom_, _Top_, _Left_ and _Right_ sides refer to the original rectangle (angle is 0),\n.       so after 180 degree rotation _bottomLeft_ point will be located at the top right corner of the\n.       rectangle."},

    {NULL,          NULL}
};

// Converter (RotatedRect)

template<>
struct PyOpenCV_Converter< cv::RotatedRect >
{
    static PyObject* from(const cv::RotatedRect& r)
    {
        return pyopencv_RotatedRect_Instance(r);
    }
    static bool to(PyObject* src, cv::RotatedRect& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        cv::RotatedRect * dst_;
        if (pyopencv_RotatedRect_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected cv::RotatedRect for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// SIFT (Generic)
//================================================================================

// GetSet (SIFT)



// Methods (SIFT)

static PyObject* pyopencv_cv_SIFT_create_static(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_nfeatures = NULL;
    int nfeatures=0;
    PyObject* pyobj_nOctaveLayers = NULL;
    int nOctaveLayers=3;
    PyObject* pyobj_contrastThreshold = NULL;
    double contrastThreshold=0.04;
    PyObject* pyobj_edgeThreshold = NULL;
    double edgeThreshold=10;
    PyObject* pyobj_sigma = NULL;
    double sigma=1.6;
    PyObject* pyobj_enable_precise_upscale = NULL;
    bool enable_precise_upscale=false;
    Ptr<SIFT> retval;

    const char* keywords[] = { "nfeatures", "nOctaveLayers", "contrastThreshold", "edgeThreshold", "sigma", "enable_precise_upscale", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "|OOOOOO:SIFT.create", (char**)keywords, &pyobj_nfeatures, &pyobj_nOctaveLayers, &pyobj_contrastThreshold, &pyobj_edgeThreshold, &pyobj_sigma, &pyobj_enable_precise_upscale) &&
        pyopencv_to_safe(pyobj_nfeatures, nfeatures, ArgInfo("nfeatures", 0)) &&
        pyopencv_to_safe(pyobj_nOctaveLayers, nOctaveLayers, ArgInfo("nOctaveLayers", 0)) &&
        pyopencv_to_safe(pyobj_contrastThreshold, contrastThreshold, ArgInfo("contrastThreshold", 0)) &&
        pyopencv_to_safe(pyobj_edgeThreshold, edgeThreshold, ArgInfo("edgeThreshold", 0)) &&
        pyopencv_to_safe(pyobj_sigma, sigma, ArgInfo("sigma", 0)) &&
        pyopencv_to_safe(pyobj_enable_precise_upscale, enable_precise_upscale, ArgInfo("enable_precise_upscale", 0)) )
    {
        ERRWRAP2(retval = cv::SIFT::create(nfeatures, nOctaveLayers, contrastThreshold, edgeThreshold, sigma, enable_precise_upscale));
        return pyopencv_from(retval);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_nfeatures = NULL;
    int nfeatures=0;
    PyObject* pyobj_nOctaveLayers = NULL;
    int nOctaveLayers=0;
    PyObject* pyobj_contrastThreshold = NULL;
    double contrastThreshold=0;
    PyObject* pyobj_edgeThreshold = NULL;
    double edgeThreshold=0;
    PyObject* pyobj_sigma = NULL;
    double sigma=0;
    PyObject* pyobj_descriptorType = NULL;
    int descriptorType=0;
    PyObject* pyobj_enable_precise_upscale = NULL;
    bool enable_precise_upscale=false;
    Ptr<SIFT> retval;

    const char* keywords[] = { "nfeatures", "nOctaveLayers", "contrastThreshold", "edgeThreshold", "sigma", "descriptorType", "enable_precise_upscale", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOOOOO|O:SIFT.create", (char**)keywords, &pyobj_nfeatures, &pyobj_nOctaveLayers, &pyobj_contrastThreshold, &pyobj_edgeThreshold, &pyobj_sigma, &pyobj_descriptorType, &pyobj_enable_precise_upscale) &&
        pyopencv_to_safe(pyobj_nfeatures, nfeatures, ArgInfo("nfeatures", 0)) &&
        pyopencv_to_safe(pyobj_nOctaveLayers, nOctaveLayers, ArgInfo("nOctaveLayers", 0)) &&
        pyopencv_to_safe(pyobj_contrastThreshold, contrastThreshold, ArgInfo("contrastThreshold", 0)) &&
        pyopencv_to_safe(pyobj_edgeThreshold, edgeThreshold, ArgInfo("edgeThreshold", 0)) &&
        pyopencv_to_safe(pyobj_sigma, sigma, ArgInfo("sigma", 0)) &&
        pyopencv_to_safe(pyobj_descriptorType, descriptorType, ArgInfo("descriptorType", 0)) &&
        pyopencv_to_safe(pyobj_enable_precise_upscale, enable_precise_upscale, ArgInfo("enable_precise_upscale", 0)) )
    {
        ERRWRAP2(retval = cv::SIFT::create(nfeatures, nOctaveLayers, contrastThreshold, edgeThreshold, sigma, descriptorType, enable_precise_upscale));
        return pyopencv_from(retval);
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("create");

    return NULL;
}

static PyObject* pyopencv_cv_SIFT_getContrastThreshold(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::SIFT> * self1 = 0;
    if (!pyopencv_SIFT_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'SIFT' or its derivative)");
    Ptr<cv::SIFT> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getContrastThreshold());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_SIFT_getDefaultName(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::SIFT> * self1 = 0;
    if (!pyopencv_SIFT_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'SIFT' or its derivative)");
    Ptr<cv::SIFT> _self_ = *(self1);
    String retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getDefaultName());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_SIFT_getEdgeThreshold(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::SIFT> * self1 = 0;
    if (!pyopencv_SIFT_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'SIFT' or its derivative)");
    Ptr<cv::SIFT> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getEdgeThreshold());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_SIFT_getNFeatures(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::SIFT> * self1 = 0;
    if (!pyopencv_SIFT_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'SIFT' or its derivative)");
    Ptr<cv::SIFT> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getNFeatures());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_SIFT_getNOctaveLayers(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::SIFT> * self1 = 0;
    if (!pyopencv_SIFT_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'SIFT' or its derivative)");
    Ptr<cv::SIFT> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getNOctaveLayers());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_SIFT_getSigma(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::SIFT> * self1 = 0;
    if (!pyopencv_SIFT_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'SIFT' or its derivative)");
    Ptr<cv::SIFT> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getSigma());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_SIFT_setContrastThreshold(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::SIFT> * self1 = 0;
    if (!pyopencv_SIFT_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'SIFT' or its derivative)");
    Ptr<cv::SIFT> _self_ = *(self1);
    PyObject* pyobj_contrastThreshold = NULL;
    double contrastThreshold=0;

    const char* keywords[] = { "contrastThreshold", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:SIFT.setContrastThreshold", (char**)keywords, &pyobj_contrastThreshold) &&
        pyopencv_to_safe(pyobj_contrastThreshold, contrastThreshold, ArgInfo("contrastThreshold", 0)) )
    {
        ERRWRAP2(_self_->setContrastThreshold(contrastThreshold));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_SIFT_setEdgeThreshold(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::SIFT> * self1 = 0;
    if (!pyopencv_SIFT_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'SIFT' or its derivative)");
    Ptr<cv::SIFT> _self_ = *(self1);
    PyObject* pyobj_edgeThreshold = NULL;
    double edgeThreshold=0;

    const char* keywords[] = { "edgeThreshold", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:SIFT.setEdgeThreshold", (char**)keywords, &pyobj_edgeThreshold) &&
        pyopencv_to_safe(pyobj_edgeThreshold, edgeThreshold, ArgInfo("edgeThreshold", 0)) )
    {
        ERRWRAP2(_self_->setEdgeThreshold(edgeThreshold));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_SIFT_setNFeatures(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::SIFT> * self1 = 0;
    if (!pyopencv_SIFT_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'SIFT' or its derivative)");
    Ptr<cv::SIFT> _self_ = *(self1);
    PyObject* pyobj_maxFeatures = NULL;
    int maxFeatures=0;

    const char* keywords[] = { "maxFeatures", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:SIFT.setNFeatures", (char**)keywords, &pyobj_maxFeatures) &&
        pyopencv_to_safe(pyobj_maxFeatures, maxFeatures, ArgInfo("maxFeatures", 0)) )
    {
        ERRWRAP2(_self_->setNFeatures(maxFeatures));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_SIFT_setNOctaveLayers(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::SIFT> * self1 = 0;
    if (!pyopencv_SIFT_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'SIFT' or its derivative)");
    Ptr<cv::SIFT> _self_ = *(self1);
    PyObject* pyobj_nOctaveLayers = NULL;
    int nOctaveLayers=0;

    const char* keywords[] = { "nOctaveLayers", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:SIFT.setNOctaveLayers", (char**)keywords, &pyobj_nOctaveLayers) &&
        pyopencv_to_safe(pyobj_nOctaveLayers, nOctaveLayers, ArgInfo("nOctaveLayers", 0)) )
    {
        ERRWRAP2(_self_->setNOctaveLayers(nOctaveLayers));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_SIFT_setSigma(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::SIFT> * self1 = 0;
    if (!pyopencv_SIFT_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'SIFT' or its derivative)");
    Ptr<cv::SIFT> _self_ = *(self1);
    PyObject* pyobj_sigma = NULL;
    double sigma=0;

    const char* keywords[] = { "sigma", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:SIFT.setSigma", (char**)keywords, &pyobj_sigma) &&
        pyopencv_to_safe(pyobj_sigma, sigma, ArgInfo("sigma", 0)) )
    {
        ERRWRAP2(_self_->setSigma(sigma));
        Py_RETURN_NONE;
    }

    return NULL;
}



// Tables (SIFT)

static PyGetSetDef pyopencv_SIFT_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_SIFT_methods[] =
{
    {"create", CV_PY_FN_WITH_KW_(pyopencv_cv_SIFT_create_static, METH_STATIC), "create([, nfeatures[, nOctaveLayers[, contrastThreshold[, edgeThreshold[, sigma[, enable_precise_upscale]]]]]]) -> retval\n.   @param nfeatures The number of best features to retain. The features are ranked by their scores\n.       (measured in SIFT algorithm as the local contrast)\n.   \n.       @param nOctaveLayers The number of layers in each octave. 3 is the value used in D. Lowe paper. The\n.       number of octaves is computed automatically from the image resolution.\n.   \n.       @param contrastThreshold The contrast threshold used to filter out weak features in semi-uniform\n.       (low-contrast) regions. The larger the threshold, the less features are produced by the detector.\n.   \n.       @note The contrast threshold will be divided by nOctaveLayers when the filtering is applied. When\n.       nOctaveLayers is set to default and if you want to use the value used in D. Lowe paper, 0.03, set\n.       this argument to 0.09.\n.   \n.       @param edgeThreshold The threshold used to filter out edge-like features. Note that the its meaning\n.       is different from the contrastThreshold, i.e. the larger the edgeThreshold, the less features are\n.       filtered out (more features are retained).\n.   \n.       @param sigma The sigma of the Gaussian applied to the input image at the octave \\#0. If your image\n.       is captured with a weak camera with soft lenses, you might want to reduce the number.\n.   \n.       @param enable_precise_upscale Whether to enable precise upscaling in the scale pyramid, which maps\n.       index \\f$\\texttt{x}\\f$ to \\f$\\texttt{2x}\\f$. This prevents localization bias. The option\n.       is disabled by default.\n\n\n\ncreate(nfeatures, nOctaveLayers, contrastThreshold, edgeThreshold, sigma, descriptorType[, enable_precise_upscale]) -> retval\n.   @brief Create SIFT with specified descriptorType.\n.       @param nfeatures The number of best features to retain. The features are ranked by their scores\n.       (measured in SIFT algorithm as the local contrast)\n.   \n.       @param nOctaveLayers The number of layers in each octave. 3 is the value used in D. Lowe paper. The\n.       number of octaves is computed automatically from the image resolution.\n.   \n.       @param contrastThreshold The contrast threshold used to filter out weak features in semi-uniform\n.       (low-contrast) regions. The larger the threshold, the less features are produced by the detector.\n.   \n.       @note The contrast threshold will be divided by nOctaveLayers when the filtering is applied. When\n.       nOctaveLayers is set to default and if you want to use the value used in D. Lowe paper, 0.03, set\n.       this argument to 0.09.\n.   \n.       @param edgeThreshold The threshold used to filter out edge-like features. Note that the its meaning\n.       is different from the contrastThreshold, i.e. the larger the edgeThreshold, the less features are\n.       filtered out (more features are retained).\n.   \n.       @param sigma The sigma of the Gaussian applied to the input image at the octave \\#0. If your image\n.       is captured with a weak camera with soft lenses, you might want to reduce the number.\n.   \n.       @param descriptorType The type of descriptors. Only CV_32F and CV_8U are supported.\n.   \n.       @param enable_precise_upscale Whether to enable precise upscaling in the scale pyramid, which maps\n.       index \\f$\\texttt{x}\\f$ to \\f$\\texttt{2x}\\f$. This prevents localization bias. The option\n.       is disabled by default."},
    {"getContrastThreshold", CV_PY_FN_WITH_KW_(pyopencv_cv_SIFT_getContrastThreshold, 0), "getContrastThreshold() -> retval\n."},
    {"getDefaultName", CV_PY_FN_WITH_KW_(pyopencv_cv_SIFT_getDefaultName, 0), "getDefaultName() -> retval\n."},
    {"getEdgeThreshold", CV_PY_FN_WITH_KW_(pyopencv_cv_SIFT_getEdgeThreshold, 0), "getEdgeThreshold() -> retval\n."},
    {"getNFeatures", CV_PY_FN_WITH_KW_(pyopencv_cv_SIFT_getNFeatures, 0), "getNFeatures() -> retval\n."},
    {"getNOctaveLayers", CV_PY_FN_WITH_KW_(pyopencv_cv_SIFT_getNOctaveLayers, 0), "getNOctaveLayers() -> retval\n."},
    {"getSigma", CV_PY_FN_WITH_KW_(pyopencv_cv_SIFT_getSigma, 0), "getSigma() -> retval\n."},
    {"setContrastThreshold", CV_PY_FN_WITH_KW_(pyopencv_cv_SIFT_setContrastThreshold, 0), "setContrastThreshold(contrastThreshold) -> None\n."},
    {"setEdgeThreshold", CV_PY_FN_WITH_KW_(pyopencv_cv_SIFT_setEdgeThreshold, 0), "setEdgeThreshold(edgeThreshold) -> None\n."},
    {"setNFeatures", CV_PY_FN_WITH_KW_(pyopencv_cv_SIFT_setNFeatures, 0), "setNFeatures(maxFeatures) -> None\n."},
    {"setNOctaveLayers", CV_PY_FN_WITH_KW_(pyopencv_cv_SIFT_setNOctaveLayers, 0), "setNOctaveLayers(nOctaveLayers) -> None\n."},
    {"setSigma", CV_PY_FN_WITH_KW_(pyopencv_cv_SIFT_setSigma, 0), "setSigma(sigma) -> None\n."},

    {NULL,          NULL}
};

// Converter (SIFT)

template<>
struct PyOpenCV_Converter< Ptr<cv::SIFT> >
{
    static PyObject* from(const Ptr<cv::SIFT>& r)
    {
        return pyopencv_SIFT_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::SIFT>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::SIFT> * dst_;
        if (pyopencv_SIFT_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::SIFT> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// ShapeContextDistanceExtractor (Generic)
//================================================================================

// GetSet (ShapeContextDistanceExtractor)



// Methods (ShapeContextDistanceExtractor)

static PyObject* pyopencv_cv_ShapeContextDistanceExtractor_getAngularBins(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ShapeContextDistanceExtractor> * self1 = 0;
    if (!pyopencv_ShapeContextDistanceExtractor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ShapeContextDistanceExtractor' or its derivative)");
    Ptr<cv::ShapeContextDistanceExtractor> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getAngularBins());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ShapeContextDistanceExtractor_getBendingEnergyWeight(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ShapeContextDistanceExtractor> * self1 = 0;
    if (!pyopencv_ShapeContextDistanceExtractor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ShapeContextDistanceExtractor' or its derivative)");
    Ptr<cv::ShapeContextDistanceExtractor> _self_ = *(self1);
    float retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getBendingEnergyWeight());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ShapeContextDistanceExtractor_getCostExtractor(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ShapeContextDistanceExtractor> * self1 = 0;
    if (!pyopencv_ShapeContextDistanceExtractor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ShapeContextDistanceExtractor' or its derivative)");
    Ptr<cv::ShapeContextDistanceExtractor> _self_ = *(self1);
    Ptr<HistogramCostExtractor> retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getCostExtractor());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ShapeContextDistanceExtractor_getImageAppearanceWeight(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ShapeContextDistanceExtractor> * self1 = 0;
    if (!pyopencv_ShapeContextDistanceExtractor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ShapeContextDistanceExtractor' or its derivative)");
    Ptr<cv::ShapeContextDistanceExtractor> _self_ = *(self1);
    float retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getImageAppearanceWeight());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ShapeContextDistanceExtractor_getImages(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ShapeContextDistanceExtractor> * self1 = 0;
    if (!pyopencv_ShapeContextDistanceExtractor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ShapeContextDistanceExtractor' or its derivative)");
    Ptr<cv::ShapeContextDistanceExtractor> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_image1 = NULL;
    Mat image1;
    PyObject* pyobj_image2 = NULL;
    Mat image2;

    const char* keywords[] = { "image1", "image2", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "|OO:ShapeContextDistanceExtractor.getImages", (char**)keywords, &pyobj_image1, &pyobj_image2) &&
        pyopencv_to_safe(pyobj_image1, image1, ArgInfo("image1", 1)) &&
        pyopencv_to_safe(pyobj_image2, image2, ArgInfo("image2", 1)) )
    {
        ERRWRAP2(_self_->getImages(image1, image2));
        return Py_BuildValue("(NN)", pyopencv_from(image1), pyopencv_from(image2));
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_image1 = NULL;
    UMat image1;
    PyObject* pyobj_image2 = NULL;
    UMat image2;

    const char* keywords[] = { "image1", "image2", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "|OO:ShapeContextDistanceExtractor.getImages", (char**)keywords, &pyobj_image1, &pyobj_image2) &&
        pyopencv_to_safe(pyobj_image1, image1, ArgInfo("image1", 1)) &&
        pyopencv_to_safe(pyobj_image2, image2, ArgInfo("image2", 1)) )
    {
        ERRWRAP2(_self_->getImages(image1, image2));
        return Py_BuildValue("(NN)", pyopencv_from(image1), pyopencv_from(image2));
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("getImages");

    return NULL;
}

static PyObject* pyopencv_cv_ShapeContextDistanceExtractor_getInnerRadius(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ShapeContextDistanceExtractor> * self1 = 0;
    if (!pyopencv_ShapeContextDistanceExtractor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ShapeContextDistanceExtractor' or its derivative)");
    Ptr<cv::ShapeContextDistanceExtractor> _self_ = *(self1);
    float retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getInnerRadius());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ShapeContextDistanceExtractor_getIterations(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ShapeContextDistanceExtractor> * self1 = 0;
    if (!pyopencv_ShapeContextDistanceExtractor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ShapeContextDistanceExtractor' or its derivative)");
    Ptr<cv::ShapeContextDistanceExtractor> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getIterations());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ShapeContextDistanceExtractor_getOuterRadius(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ShapeContextDistanceExtractor> * self1 = 0;
    if (!pyopencv_ShapeContextDistanceExtractor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ShapeContextDistanceExtractor' or its derivative)");
    Ptr<cv::ShapeContextDistanceExtractor> _self_ = *(self1);
    float retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getOuterRadius());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ShapeContextDistanceExtractor_getRadialBins(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ShapeContextDistanceExtractor> * self1 = 0;
    if (!pyopencv_ShapeContextDistanceExtractor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ShapeContextDistanceExtractor' or its derivative)");
    Ptr<cv::ShapeContextDistanceExtractor> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getRadialBins());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ShapeContextDistanceExtractor_getRotationInvariant(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ShapeContextDistanceExtractor> * self1 = 0;
    if (!pyopencv_ShapeContextDistanceExtractor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ShapeContextDistanceExtractor' or its derivative)");
    Ptr<cv::ShapeContextDistanceExtractor> _self_ = *(self1);
    bool retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getRotationInvariant());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ShapeContextDistanceExtractor_getShapeContextWeight(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ShapeContextDistanceExtractor> * self1 = 0;
    if (!pyopencv_ShapeContextDistanceExtractor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ShapeContextDistanceExtractor' or its derivative)");
    Ptr<cv::ShapeContextDistanceExtractor> _self_ = *(self1);
    float retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getShapeContextWeight());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ShapeContextDistanceExtractor_getStdDev(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ShapeContextDistanceExtractor> * self1 = 0;
    if (!pyopencv_ShapeContextDistanceExtractor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ShapeContextDistanceExtractor' or its derivative)");
    Ptr<cv::ShapeContextDistanceExtractor> _self_ = *(self1);
    float retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getStdDev());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ShapeContextDistanceExtractor_getTransformAlgorithm(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ShapeContextDistanceExtractor> * self1 = 0;
    if (!pyopencv_ShapeContextDistanceExtractor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ShapeContextDistanceExtractor' or its derivative)");
    Ptr<cv::ShapeContextDistanceExtractor> _self_ = *(self1);
    Ptr<ShapeTransformer> retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getTransformAlgorithm());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ShapeContextDistanceExtractor_setAngularBins(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ShapeContextDistanceExtractor> * self1 = 0;
    if (!pyopencv_ShapeContextDistanceExtractor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ShapeContextDistanceExtractor' or its derivative)");
    Ptr<cv::ShapeContextDistanceExtractor> _self_ = *(self1);
    PyObject* pyobj_nAngularBins = NULL;
    int nAngularBins=0;

    const char* keywords[] = { "nAngularBins", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:ShapeContextDistanceExtractor.setAngularBins", (char**)keywords, &pyobj_nAngularBins) &&
        pyopencv_to_safe(pyobj_nAngularBins, nAngularBins, ArgInfo("nAngularBins", 0)) )
    {
        ERRWRAP2(_self_->setAngularBins(nAngularBins));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ShapeContextDistanceExtractor_setBendingEnergyWeight(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ShapeContextDistanceExtractor> * self1 = 0;
    if (!pyopencv_ShapeContextDistanceExtractor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ShapeContextDistanceExtractor' or its derivative)");
    Ptr<cv::ShapeContextDistanceExtractor> _self_ = *(self1);
    PyObject* pyobj_bendingEnergyWeight = NULL;
    float bendingEnergyWeight=0.f;

    const char* keywords[] = { "bendingEnergyWeight", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:ShapeContextDistanceExtractor.setBendingEnergyWeight", (char**)keywords, &pyobj_bendingEnergyWeight) &&
        pyopencv_to_safe(pyobj_bendingEnergyWeight, bendingEnergyWeight, ArgInfo("bendingEnergyWeight", 0)) )
    {
        ERRWRAP2(_self_->setBendingEnergyWeight(bendingEnergyWeight));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ShapeContextDistanceExtractor_setCostExtractor(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ShapeContextDistanceExtractor> * self1 = 0;
    if (!pyopencv_ShapeContextDistanceExtractor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ShapeContextDistanceExtractor' or its derivative)");
    Ptr<cv::ShapeContextDistanceExtractor> _self_ = *(self1);
    PyObject* pyobj_comparer = NULL;
    Ptr<HistogramCostExtractor> comparer;

    const char* keywords[] = { "comparer", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:ShapeContextDistanceExtractor.setCostExtractor", (char**)keywords, &pyobj_comparer) &&
        pyopencv_to_safe(pyobj_comparer, comparer, ArgInfo("comparer", 0)) )
    {
        ERRWRAP2(_self_->setCostExtractor(comparer));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ShapeContextDistanceExtractor_setImageAppearanceWeight(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ShapeContextDistanceExtractor> * self1 = 0;
    if (!pyopencv_ShapeContextDistanceExtractor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ShapeContextDistanceExtractor' or its derivative)");
    Ptr<cv::ShapeContextDistanceExtractor> _self_ = *(self1);
    PyObject* pyobj_imageAppearanceWeight = NULL;
    float imageAppearanceWeight=0.f;

    const char* keywords[] = { "imageAppearanceWeight", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:ShapeContextDistanceExtractor.setImageAppearanceWeight", (char**)keywords, &pyobj_imageAppearanceWeight) &&
        pyopencv_to_safe(pyobj_imageAppearanceWeight, imageAppearanceWeight, ArgInfo("imageAppearanceWeight", 0)) )
    {
        ERRWRAP2(_self_->setImageAppearanceWeight(imageAppearanceWeight));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ShapeContextDistanceExtractor_setImages(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ShapeContextDistanceExtractor> * self1 = 0;
    if (!pyopencv_ShapeContextDistanceExtractor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ShapeContextDistanceExtractor' or its derivative)");
    Ptr<cv::ShapeContextDistanceExtractor> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_image1 = NULL;
    Mat image1;
    PyObject* pyobj_image2 = NULL;
    Mat image2;

    const char* keywords[] = { "image1", "image2", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO:ShapeContextDistanceExtractor.setImages", (char**)keywords, &pyobj_image1, &pyobj_image2) &&
        pyopencv_to_safe(pyobj_image1, image1, ArgInfo("image1", 0)) &&
        pyopencv_to_safe(pyobj_image2, image2, ArgInfo("image2", 0)) )
    {
        ERRWRAP2(_self_->setImages(image1, image2));
        Py_RETURN_NONE;
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_image1 = NULL;
    UMat image1;
    PyObject* pyobj_image2 = NULL;
    UMat image2;

    const char* keywords[] = { "image1", "image2", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO:ShapeContextDistanceExtractor.setImages", (char**)keywords, &pyobj_image1, &pyobj_image2) &&
        pyopencv_to_safe(pyobj_image1, image1, ArgInfo("image1", 0)) &&
        pyopencv_to_safe(pyobj_image2, image2, ArgInfo("image2", 0)) )
    {
        ERRWRAP2(_self_->setImages(image1, image2));
        Py_RETURN_NONE;
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("setImages");

    return NULL;
}

static PyObject* pyopencv_cv_ShapeContextDistanceExtractor_setInnerRadius(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ShapeContextDistanceExtractor> * self1 = 0;
    if (!pyopencv_ShapeContextDistanceExtractor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ShapeContextDistanceExtractor' or its derivative)");
    Ptr<cv::ShapeContextDistanceExtractor> _self_ = *(self1);
    PyObject* pyobj_innerRadius = NULL;
    float innerRadius=0.f;

    const char* keywords[] = { "innerRadius", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:ShapeContextDistanceExtractor.setInnerRadius", (char**)keywords, &pyobj_innerRadius) &&
        pyopencv_to_safe(pyobj_innerRadius, innerRadius, ArgInfo("innerRadius", 0)) )
    {
        ERRWRAP2(_self_->setInnerRadius(innerRadius));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ShapeContextDistanceExtractor_setIterations(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ShapeContextDistanceExtractor> * self1 = 0;
    if (!pyopencv_ShapeContextDistanceExtractor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ShapeContextDistanceExtractor' or its derivative)");
    Ptr<cv::ShapeContextDistanceExtractor> _self_ = *(self1);
    PyObject* pyobj_iterations = NULL;
    int iterations=0;

    const char* keywords[] = { "iterations", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:ShapeContextDistanceExtractor.setIterations", (char**)keywords, &pyobj_iterations) &&
        pyopencv_to_safe(pyobj_iterations, iterations, ArgInfo("iterations", 0)) )
    {
        ERRWRAP2(_self_->setIterations(iterations));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ShapeContextDistanceExtractor_setOuterRadius(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ShapeContextDistanceExtractor> * self1 = 0;
    if (!pyopencv_ShapeContextDistanceExtractor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ShapeContextDistanceExtractor' or its derivative)");
    Ptr<cv::ShapeContextDistanceExtractor> _self_ = *(self1);
    PyObject* pyobj_outerRadius = NULL;
    float outerRadius=0.f;

    const char* keywords[] = { "outerRadius", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:ShapeContextDistanceExtractor.setOuterRadius", (char**)keywords, &pyobj_outerRadius) &&
        pyopencv_to_safe(pyobj_outerRadius, outerRadius, ArgInfo("outerRadius", 0)) )
    {
        ERRWRAP2(_self_->setOuterRadius(outerRadius));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ShapeContextDistanceExtractor_setRadialBins(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ShapeContextDistanceExtractor> * self1 = 0;
    if (!pyopencv_ShapeContextDistanceExtractor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ShapeContextDistanceExtractor' or its derivative)");
    Ptr<cv::ShapeContextDistanceExtractor> _self_ = *(self1);
    PyObject* pyobj_nRadialBins = NULL;
    int nRadialBins=0;

    const char* keywords[] = { "nRadialBins", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:ShapeContextDistanceExtractor.setRadialBins", (char**)keywords, &pyobj_nRadialBins) &&
        pyopencv_to_safe(pyobj_nRadialBins, nRadialBins, ArgInfo("nRadialBins", 0)) )
    {
        ERRWRAP2(_self_->setRadialBins(nRadialBins));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ShapeContextDistanceExtractor_setRotationInvariant(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ShapeContextDistanceExtractor> * self1 = 0;
    if (!pyopencv_ShapeContextDistanceExtractor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ShapeContextDistanceExtractor' or its derivative)");
    Ptr<cv::ShapeContextDistanceExtractor> _self_ = *(self1);
    PyObject* pyobj_rotationInvariant = NULL;
    bool rotationInvariant=0;

    const char* keywords[] = { "rotationInvariant", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:ShapeContextDistanceExtractor.setRotationInvariant", (char**)keywords, &pyobj_rotationInvariant) &&
        pyopencv_to_safe(pyobj_rotationInvariant, rotationInvariant, ArgInfo("rotationInvariant", 0)) )
    {
        ERRWRAP2(_self_->setRotationInvariant(rotationInvariant));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ShapeContextDistanceExtractor_setShapeContextWeight(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ShapeContextDistanceExtractor> * self1 = 0;
    if (!pyopencv_ShapeContextDistanceExtractor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ShapeContextDistanceExtractor' or its derivative)");
    Ptr<cv::ShapeContextDistanceExtractor> _self_ = *(self1);
    PyObject* pyobj_shapeContextWeight = NULL;
    float shapeContextWeight=0.f;

    const char* keywords[] = { "shapeContextWeight", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:ShapeContextDistanceExtractor.setShapeContextWeight", (char**)keywords, &pyobj_shapeContextWeight) &&
        pyopencv_to_safe(pyobj_shapeContextWeight, shapeContextWeight, ArgInfo("shapeContextWeight", 0)) )
    {
        ERRWRAP2(_self_->setShapeContextWeight(shapeContextWeight));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ShapeContextDistanceExtractor_setStdDev(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ShapeContextDistanceExtractor> * self1 = 0;
    if (!pyopencv_ShapeContextDistanceExtractor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ShapeContextDistanceExtractor' or its derivative)");
    Ptr<cv::ShapeContextDistanceExtractor> _self_ = *(self1);
    PyObject* pyobj_sigma = NULL;
    float sigma=0.f;

    const char* keywords[] = { "sigma", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:ShapeContextDistanceExtractor.setStdDev", (char**)keywords, &pyobj_sigma) &&
        pyopencv_to_safe(pyobj_sigma, sigma, ArgInfo("sigma", 0)) )
    {
        ERRWRAP2(_self_->setStdDev(sigma));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_ShapeContextDistanceExtractor_setTransformAlgorithm(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ShapeContextDistanceExtractor> * self1 = 0;
    if (!pyopencv_ShapeContextDistanceExtractor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ShapeContextDistanceExtractor' or its derivative)");
    Ptr<cv::ShapeContextDistanceExtractor> _self_ = *(self1);
    PyObject* pyobj_transformer = NULL;
    Ptr<ShapeTransformer> transformer;

    const char* keywords[] = { "transformer", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:ShapeContextDistanceExtractor.setTransformAlgorithm", (char**)keywords, &pyobj_transformer) &&
        pyopencv_to_safe(pyobj_transformer, transformer, ArgInfo("transformer", 0)) )
    {
        ERRWRAP2(_self_->setTransformAlgorithm(transformer));
        Py_RETURN_NONE;
    }

    return NULL;
}



// Tables (ShapeContextDistanceExtractor)

static PyGetSetDef pyopencv_ShapeContextDistanceExtractor_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_ShapeContextDistanceExtractor_methods[] =
{
    {"getAngularBins", CV_PY_FN_WITH_KW_(pyopencv_cv_ShapeContextDistanceExtractor_getAngularBins, 0), "getAngularBins() -> retval\n."},
    {"getBendingEnergyWeight", CV_PY_FN_WITH_KW_(pyopencv_cv_ShapeContextDistanceExtractor_getBendingEnergyWeight, 0), "getBendingEnergyWeight() -> retval\n."},
    {"getCostExtractor", CV_PY_FN_WITH_KW_(pyopencv_cv_ShapeContextDistanceExtractor_getCostExtractor, 0), "getCostExtractor() -> retval\n."},
    {"getImageAppearanceWeight", CV_PY_FN_WITH_KW_(pyopencv_cv_ShapeContextDistanceExtractor_getImageAppearanceWeight, 0), "getImageAppearanceWeight() -> retval\n."},
    {"getImages", CV_PY_FN_WITH_KW_(pyopencv_cv_ShapeContextDistanceExtractor_getImages, 0), "getImages([, image1[, image2]]) -> image1, image2\n."},
    {"getInnerRadius", CV_PY_FN_WITH_KW_(pyopencv_cv_ShapeContextDistanceExtractor_getInnerRadius, 0), "getInnerRadius() -> retval\n."},
    {"getIterations", CV_PY_FN_WITH_KW_(pyopencv_cv_ShapeContextDistanceExtractor_getIterations, 0), "getIterations() -> retval\n."},
    {"getOuterRadius", CV_PY_FN_WITH_KW_(pyopencv_cv_ShapeContextDistanceExtractor_getOuterRadius, 0), "getOuterRadius() -> retval\n."},
    {"getRadialBins", CV_PY_FN_WITH_KW_(pyopencv_cv_ShapeContextDistanceExtractor_getRadialBins, 0), "getRadialBins() -> retval\n."},
    {"getRotationInvariant", CV_PY_FN_WITH_KW_(pyopencv_cv_ShapeContextDistanceExtractor_getRotationInvariant, 0), "getRotationInvariant() -> retval\n."},
    {"getShapeContextWeight", CV_PY_FN_WITH_KW_(pyopencv_cv_ShapeContextDistanceExtractor_getShapeContextWeight, 0), "getShapeContextWeight() -> retval\n."},
    {"getStdDev", CV_PY_FN_WITH_KW_(pyopencv_cv_ShapeContextDistanceExtractor_getStdDev, 0), "getStdDev() -> retval\n."},
    {"getTransformAlgorithm", CV_PY_FN_WITH_KW_(pyopencv_cv_ShapeContextDistanceExtractor_getTransformAlgorithm, 0), "getTransformAlgorithm() -> retval\n."},
    {"setAngularBins", CV_PY_FN_WITH_KW_(pyopencv_cv_ShapeContextDistanceExtractor_setAngularBins, 0), "setAngularBins(nAngularBins) -> None\n.   @brief Establish the number of angular bins for the Shape Context Descriptor used in the shape matching\n.       pipeline.\n.   \n.       @param nAngularBins The number of angular bins in the shape context descriptor."},
    {"setBendingEnergyWeight", CV_PY_FN_WITH_KW_(pyopencv_cv_ShapeContextDistanceExtractor_setBendingEnergyWeight, 0), "setBendingEnergyWeight(bendingEnergyWeight) -> None\n.   @brief Set the weight of the Bending Energy in the final value of the shape distance. The bending energy\n.       definition depends on what transformation is being used to align the shapes. The final value of the\n.       shape distance is a user-defined linear combination of the shape context distance, an image\n.       appearance distance, and a bending energy.\n.   \n.       @param bendingEnergyWeight The weight of the Bending Energy in the final distance value."},
    {"setCostExtractor", CV_PY_FN_WITH_KW_(pyopencv_cv_ShapeContextDistanceExtractor_setCostExtractor, 0), "setCostExtractor(comparer) -> None\n.   @brief Set the algorithm used for building the shape context descriptor cost matrix.\n.   \n.       @param comparer Smart pointer to a HistogramCostExtractor, an algorithm that defines the cost\n.       matrix between descriptors."},
    {"setImageAppearanceWeight", CV_PY_FN_WITH_KW_(pyopencv_cv_ShapeContextDistanceExtractor_setImageAppearanceWeight, 0), "setImageAppearanceWeight(imageAppearanceWeight) -> None\n.   @brief Set the weight of the Image Appearance cost in the final value of the shape distance. The image\n.       appearance cost is defined as the sum of squared brightness differences in Gaussian windows around\n.       corresponding image points. The final value of the shape distance is a user-defined linear\n.       combination of the shape context distance, an image appearance distance, and a bending energy. If\n.       this value is set to a number different from 0, is mandatory to set the images that correspond to\n.       each shape.\n.   \n.       @param imageAppearanceWeight The weight of the appearance cost in the final distance value."},
    {"setImages", CV_PY_FN_WITH_KW_(pyopencv_cv_ShapeContextDistanceExtractor_setImages, 0), "setImages(image1, image2) -> None\n.   @brief Set the images that correspond to each shape. This images are used in the calculation of the Image\n.       Appearance cost.\n.   \n.       @param image1 Image corresponding to the shape defined by contours1.\n.       @param image2 Image corresponding to the shape defined by contours2."},
    {"setInnerRadius", CV_PY_FN_WITH_KW_(pyopencv_cv_ShapeContextDistanceExtractor_setInnerRadius, 0), "setInnerRadius(innerRadius) -> None\n.   @brief Set the inner radius of the shape context descriptor.\n.   \n.       @param innerRadius The value of the inner radius."},
    {"setIterations", CV_PY_FN_WITH_KW_(pyopencv_cv_ShapeContextDistanceExtractor_setIterations, 0), "setIterations(iterations) -> None\n."},
    {"setOuterRadius", CV_PY_FN_WITH_KW_(pyopencv_cv_ShapeContextDistanceExtractor_setOuterRadius, 0), "setOuterRadius(outerRadius) -> None\n.   @brief Set the outer radius of the shape context descriptor.\n.   \n.       @param outerRadius The value of the outer radius."},
    {"setRadialBins", CV_PY_FN_WITH_KW_(pyopencv_cv_ShapeContextDistanceExtractor_setRadialBins, 0), "setRadialBins(nRadialBins) -> None\n.   @brief Establish the number of radial bins for the Shape Context Descriptor used in the shape matching\n.       pipeline.\n.   \n.       @param nRadialBins The number of radial bins in the shape context descriptor."},
    {"setRotationInvariant", CV_PY_FN_WITH_KW_(pyopencv_cv_ShapeContextDistanceExtractor_setRotationInvariant, 0), "setRotationInvariant(rotationInvariant) -> None\n."},
    {"setShapeContextWeight", CV_PY_FN_WITH_KW_(pyopencv_cv_ShapeContextDistanceExtractor_setShapeContextWeight, 0), "setShapeContextWeight(shapeContextWeight) -> None\n.   @brief Set the weight of the shape context distance in the final value of the shape distance. The shape\n.       context distance between two shapes is defined as the symmetric sum of shape context matching costs\n.       over best matching points. The final value of the shape distance is a user-defined linear\n.       combination of the shape context distance, an image appearance distance, and a bending energy.\n.   \n.       @param shapeContextWeight The weight of the shape context distance in the final distance value."},
    {"setStdDev", CV_PY_FN_WITH_KW_(pyopencv_cv_ShapeContextDistanceExtractor_setStdDev, 0), "setStdDev(sigma) -> None\n.   @brief Set the value of the standard deviation for the Gaussian window for the image appearance cost.\n.   \n.       @param sigma Standard Deviation."},
    {"setTransformAlgorithm", CV_PY_FN_WITH_KW_(pyopencv_cv_ShapeContextDistanceExtractor_setTransformAlgorithm, 0), "setTransformAlgorithm(transformer) -> None\n.   @brief Set the algorithm used for aligning the shapes.\n.   \n.       @param transformer Smart pointer to a ShapeTransformer, an algorithm that defines the aligning\n.       transformation."},

    {NULL,          NULL}
};

// Converter (ShapeContextDistanceExtractor)

template<>
struct PyOpenCV_Converter< Ptr<cv::ShapeContextDistanceExtractor> >
{
    static PyObject* from(const Ptr<cv::ShapeContextDistanceExtractor>& r)
    {
        return pyopencv_ShapeContextDistanceExtractor_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::ShapeContextDistanceExtractor>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::ShapeContextDistanceExtractor> * dst_;
        if (pyopencv_ShapeContextDistanceExtractor_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::ShapeContextDistanceExtractor> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// ShapeDistanceExtractor (Generic)
//================================================================================

// GetSet (ShapeDistanceExtractor)



// Methods (ShapeDistanceExtractor)

static PyObject* pyopencv_cv_ShapeDistanceExtractor_computeDistance(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ShapeDistanceExtractor> * self1 = 0;
    if (!pyopencv_ShapeDistanceExtractor_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ShapeDistanceExtractor' or its derivative)");
    Ptr<cv::ShapeDistanceExtractor> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_contour1 = NULL;
    Mat contour1;
    PyObject* pyobj_contour2 = NULL;
    Mat contour2;
    float retval;

    const char* keywords[] = { "contour1", "contour2", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO:ShapeDistanceExtractor.computeDistance", (char**)keywords, &pyobj_contour1, &pyobj_contour2) &&
        pyopencv_to_safe(pyobj_contour1, contour1, ArgInfo("contour1", 0)) &&
        pyopencv_to_safe(pyobj_contour2, contour2, ArgInfo("contour2", 0)) )
    {
        ERRWRAP2(retval = _self_->computeDistance(contour1, contour2));
        return pyopencv_from(retval);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_contour1 = NULL;
    UMat contour1;
    PyObject* pyobj_contour2 = NULL;
    UMat contour2;
    float retval;

    const char* keywords[] = { "contour1", "contour2", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO:ShapeDistanceExtractor.computeDistance", (char**)keywords, &pyobj_contour1, &pyobj_contour2) &&
        pyopencv_to_safe(pyobj_contour1, contour1, ArgInfo("contour1", 0)) &&
        pyopencv_to_safe(pyobj_contour2, contour2, ArgInfo("contour2", 0)) )
    {
        ERRWRAP2(retval = _self_->computeDistance(contour1, contour2));
        return pyopencv_from(retval);
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("computeDistance");

    return NULL;
}



// Tables (ShapeDistanceExtractor)

static PyGetSetDef pyopencv_ShapeDistanceExtractor_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_ShapeDistanceExtractor_methods[] =
{
    {"computeDistance", CV_PY_FN_WITH_KW_(pyopencv_cv_ShapeDistanceExtractor_computeDistance, 0), "computeDistance(contour1, contour2) -> retval\n.   @brief Compute the shape distance between two shapes defined by its contours.\n.   \n.       @param contour1 Contour defining first shape.\n.       @param contour2 Contour defining second shape."},

    {NULL,          NULL}
};

// Converter (ShapeDistanceExtractor)

template<>
struct PyOpenCV_Converter< Ptr<cv::ShapeDistanceExtractor> >
{
    static PyObject* from(const Ptr<cv::ShapeDistanceExtractor>& r)
    {
        return pyopencv_ShapeDistanceExtractor_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::ShapeDistanceExtractor>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::ShapeDistanceExtractor> * dst_;
        if (pyopencv_ShapeDistanceExtractor_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::ShapeDistanceExtractor> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// ShapeTransformer (Generic)
//================================================================================

// GetSet (ShapeTransformer)



// Methods (ShapeTransformer)

static PyObject* pyopencv_cv_ShapeTransformer_applyTransformation(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ShapeTransformer> * self1 = 0;
    if (!pyopencv_ShapeTransformer_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ShapeTransformer' or its derivative)");
    Ptr<cv::ShapeTransformer> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_input = NULL;
    Mat input;
    PyObject* pyobj_output = NULL;
    Mat output;
    float retval;

    const char* keywords[] = { "input", "output", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|O:ShapeTransformer.applyTransformation", (char**)keywords, &pyobj_input, &pyobj_output) &&
        pyopencv_to_safe(pyobj_input, input, ArgInfo("input", 0)) &&
        pyopencv_to_safe(pyobj_output, output, ArgInfo("output", 1)) )
    {
        ERRWRAP2(retval = _self_->applyTransformation(input, output));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(output));
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_input = NULL;
    UMat input;
    PyObject* pyobj_output = NULL;
    UMat output;
    float retval;

    const char* keywords[] = { "input", "output", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|O:ShapeTransformer.applyTransformation", (char**)keywords, &pyobj_input, &pyobj_output) &&
        pyopencv_to_safe(pyobj_input, input, ArgInfo("input", 0)) &&
        pyopencv_to_safe(pyobj_output, output, ArgInfo("output", 1)) )
    {
        ERRWRAP2(retval = _self_->applyTransformation(input, output));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(output));
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("applyTransformation");

    return NULL;
}

static PyObject* pyopencv_cv_ShapeTransformer_estimateTransformation(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ShapeTransformer> * self1 = 0;
    if (!pyopencv_ShapeTransformer_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ShapeTransformer' or its derivative)");
    Ptr<cv::ShapeTransformer> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_transformingShape = NULL;
    Mat transformingShape;
    PyObject* pyobj_targetShape = NULL;
    Mat targetShape;
    PyObject* pyobj_matches = NULL;
    vector_DMatch matches;

    const char* keywords[] = { "transformingShape", "targetShape", "matches", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOO:ShapeTransformer.estimateTransformation", (char**)keywords, &pyobj_transformingShape, &pyobj_targetShape, &pyobj_matches) &&
        pyopencv_to_safe(pyobj_transformingShape, transformingShape, ArgInfo("transformingShape", 0)) &&
        pyopencv_to_safe(pyobj_targetShape, targetShape, ArgInfo("targetShape", 0)) &&
        pyopencv_to_safe(pyobj_matches, matches, ArgInfo("matches", 0)) )
    {
        ERRWRAP2(_self_->estimateTransformation(transformingShape, targetShape, matches));
        Py_RETURN_NONE;
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_transformingShape = NULL;
    UMat transformingShape;
    PyObject* pyobj_targetShape = NULL;
    UMat targetShape;
    PyObject* pyobj_matches = NULL;
    vector_DMatch matches;

    const char* keywords[] = { "transformingShape", "targetShape", "matches", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOO:ShapeTransformer.estimateTransformation", (char**)keywords, &pyobj_transformingShape, &pyobj_targetShape, &pyobj_matches) &&
        pyopencv_to_safe(pyobj_transformingShape, transformingShape, ArgInfo("transformingShape", 0)) &&
        pyopencv_to_safe(pyobj_targetShape, targetShape, ArgInfo("targetShape", 0)) &&
        pyopencv_to_safe(pyobj_matches, matches, ArgInfo("matches", 0)) )
    {
        ERRWRAP2(_self_->estimateTransformation(transformingShape, targetShape, matches));
        Py_RETURN_NONE;
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("estimateTransformation");

    return NULL;
}

static PyObject* pyopencv_cv_ShapeTransformer_warpImage(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ShapeTransformer> * self1 = 0;
    if (!pyopencv_ShapeTransformer_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ShapeTransformer' or its derivative)");
    Ptr<cv::ShapeTransformer> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_transformingImage = NULL;
    Mat transformingImage;
    PyObject* pyobj_output = NULL;
    Mat output;
    PyObject* pyobj_flags = NULL;
    int flags=INTER_LINEAR;
    PyObject* pyobj_borderMode = NULL;
    int borderMode=BORDER_CONSTANT;
    PyObject* pyobj_borderValue = NULL;
    Scalar borderValue;

    const char* keywords[] = { "transformingImage", "output", "flags", "borderMode", "borderValue", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|OOOO:ShapeTransformer.warpImage", (char**)keywords, &pyobj_transformingImage, &pyobj_output, &pyobj_flags, &pyobj_borderMode, &pyobj_borderValue) &&
        pyopencv_to_safe(pyobj_transformingImage, transformingImage, ArgInfo("transformingImage", 0)) &&
        pyopencv_to_safe(pyobj_output, output, ArgInfo("output", 1)) &&
        pyopencv_to_safe(pyobj_flags, flags, ArgInfo("flags", 0)) &&
        pyopencv_to_safe(pyobj_borderMode, borderMode, ArgInfo("borderMode", 0)) &&
        pyopencv_to_safe(pyobj_borderValue, borderValue, ArgInfo("borderValue", 0)) )
    {
        ERRWRAP2(_self_->warpImage(transformingImage, output, flags, borderMode, borderValue));
        return pyopencv_from(output);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_transformingImage = NULL;
    UMat transformingImage;
    PyObject* pyobj_output = NULL;
    UMat output;
    PyObject* pyobj_flags = NULL;
    int flags=INTER_LINEAR;
    PyObject* pyobj_borderMode = NULL;
    int borderMode=BORDER_CONSTANT;
    PyObject* pyobj_borderValue = NULL;
    Scalar borderValue;

    const char* keywords[] = { "transformingImage", "output", "flags", "borderMode", "borderValue", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|OOOO:ShapeTransformer.warpImage", (char**)keywords, &pyobj_transformingImage, &pyobj_output, &pyobj_flags, &pyobj_borderMode, &pyobj_borderValue) &&
        pyopencv_to_safe(pyobj_transformingImage, transformingImage, ArgInfo("transformingImage", 0)) &&
        pyopencv_to_safe(pyobj_output, output, ArgInfo("output", 1)) &&
        pyopencv_to_safe(pyobj_flags, flags, ArgInfo("flags", 0)) &&
        pyopencv_to_safe(pyobj_borderMode, borderMode, ArgInfo("borderMode", 0)) &&
        pyopencv_to_safe(pyobj_borderValue, borderValue, ArgInfo("borderValue", 0)) )
    {
        ERRWRAP2(_self_->warpImage(transformingImage, output, flags, borderMode, borderValue));
        return pyopencv_from(output);
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("warpImage");

    return NULL;
}



// Tables (ShapeTransformer)

static PyGetSetDef pyopencv_ShapeTransformer_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_ShapeTransformer_methods[] =
{
    {"applyTransformation", CV_PY_FN_WITH_KW_(pyopencv_cv_ShapeTransformer_applyTransformation, 0), "applyTransformation(input[, output]) -> retval, output\n.   @brief Apply a transformation, given a pre-estimated transformation parameters.\n.   \n.       @param input Contour (set of points) to apply the transformation.\n.       @param output Output contour."},
    {"estimateTransformation", CV_PY_FN_WITH_KW_(pyopencv_cv_ShapeTransformer_estimateTransformation, 0), "estimateTransformation(transformingShape, targetShape, matches) -> None\n.   @brief Estimate the transformation parameters of the current transformer algorithm, based on point matches.\n.   \n.       @param transformingShape Contour defining first shape.\n.       @param targetShape Contour defining second shape (Target).\n.       @param matches Standard vector of Matches between points."},
    {"warpImage", CV_PY_FN_WITH_KW_(pyopencv_cv_ShapeTransformer_warpImage, 0), "warpImage(transformingImage[, output[, flags[, borderMode[, borderValue]]]]) -> output\n.   @brief Apply a transformation, given a pre-estimated transformation parameters, to an Image.\n.   \n.       @param transformingImage Input image.\n.       @param output Output image.\n.       @param flags Image interpolation method.\n.       @param borderMode border style.\n.       @param borderValue border value."},

    {NULL,          NULL}
};

// Converter (ShapeTransformer)

template<>
struct PyOpenCV_Converter< Ptr<cv::ShapeTransformer> >
{
    static PyObject* from(const Ptr<cv::ShapeTransformer>& r)
    {
        return pyopencv_ShapeTransformer_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::ShapeTransformer>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::ShapeTransformer> * dst_;
        if (pyopencv_ShapeTransformer_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::ShapeTransformer> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// SimpleBlobDetector (Generic)
//================================================================================

// GetSet (SimpleBlobDetector)



// Methods (SimpleBlobDetector)

static PyObject* pyopencv_cv_SimpleBlobDetector_create_static(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    PyObject* pyobj_parameters = NULL;
    cv::SimpleBlobDetector::Params parameters=SimpleBlobDetector::Params();
    Ptr<SimpleBlobDetector> retval;

    const char* keywords[] = { "parameters", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "|O:SimpleBlobDetector.create", (char**)keywords, &pyobj_parameters) &&
        pyopencv_to_safe(pyobj_parameters, parameters, ArgInfo("parameters", 0)) )
    {
        ERRWRAP2(retval = cv::SimpleBlobDetector::create(parameters));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_SimpleBlobDetector_getBlobContours(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::SimpleBlobDetector> * self1 = 0;
    if (!pyopencv_SimpleBlobDetector_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'SimpleBlobDetector' or its derivative)");
    Ptr<cv::SimpleBlobDetector> _self_ = *(self1);
    std::vector<std::vector<cv::Point> > retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getBlobContours());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_SimpleBlobDetector_getDefaultName(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::SimpleBlobDetector> * self1 = 0;
    if (!pyopencv_SimpleBlobDetector_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'SimpleBlobDetector' or its derivative)");
    Ptr<cv::SimpleBlobDetector> _self_ = *(self1);
    String retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getDefaultName());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_SimpleBlobDetector_getParams(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::SimpleBlobDetector> * self1 = 0;
    if (!pyopencv_SimpleBlobDetector_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'SimpleBlobDetector' or its derivative)");
    Ptr<cv::SimpleBlobDetector> _self_ = *(self1);
    SimpleBlobDetector::Params retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getParams());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_SimpleBlobDetector_setParams(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::SimpleBlobDetector> * self1 = 0;
    if (!pyopencv_SimpleBlobDetector_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'SimpleBlobDetector' or its derivative)");
    Ptr<cv::SimpleBlobDetector> _self_ = *(self1);
    PyObject* pyobj_params = NULL;
    cv::SimpleBlobDetector::Params params;

    const char* keywords[] = { "params", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:SimpleBlobDetector.setParams", (char**)keywords, &pyobj_params) &&
        pyopencv_to_safe(pyobj_params, params, ArgInfo("params", 0)) )
    {
        ERRWRAP2(_self_->setParams(params));
        Py_RETURN_NONE;
    }

    return NULL;
}



// Tables (SimpleBlobDetector)

static PyGetSetDef pyopencv_SimpleBlobDetector_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_SimpleBlobDetector_methods[] =
{
    {"create", CV_PY_FN_WITH_KW_(pyopencv_cv_SimpleBlobDetector_create_static, METH_STATIC), "create([, parameters]) -> retval\n."},
    {"getBlobContours", CV_PY_FN_WITH_KW_(pyopencv_cv_SimpleBlobDetector_getBlobContours, 0), "getBlobContours() -> retval\n."},
    {"getDefaultName", CV_PY_FN_WITH_KW_(pyopencv_cv_SimpleBlobDetector_getDefaultName, 0), "getDefaultName() -> retval\n."},
    {"getParams", CV_PY_FN_WITH_KW_(pyopencv_cv_SimpleBlobDetector_getParams, 0), "getParams() -> retval\n."},
    {"setParams", CV_PY_FN_WITH_KW_(pyopencv_cv_SimpleBlobDetector_setParams, 0), "setParams(params) -> None\n."},

    {NULL,          NULL}
};

// Converter (SimpleBlobDetector)

template<>
struct PyOpenCV_Converter< Ptr<cv::SimpleBlobDetector> >
{
    static PyObject* from(const Ptr<cv::SimpleBlobDetector>& r)
    {
        return pyopencv_SimpleBlobDetector_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::SimpleBlobDetector>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::SimpleBlobDetector> * dst_;
        if (pyopencv_SimpleBlobDetector_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::SimpleBlobDetector> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// SimpleBlobDetector_Params (Generic)
//================================================================================

// GetSet (SimpleBlobDetector_Params)


static PyObject* pyopencv_SimpleBlobDetector_Params_get_blobColor(pyopencv_SimpleBlobDetector_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.blobColor);
}

static int pyopencv_SimpleBlobDetector_Params_set_blobColor(pyopencv_SimpleBlobDetector_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the blobColor attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.blobColor, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_SimpleBlobDetector_Params_get_collectContours(pyopencv_SimpleBlobDetector_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.collectContours);
}

static int pyopencv_SimpleBlobDetector_Params_set_collectContours(pyopencv_SimpleBlobDetector_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the collectContours attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.collectContours, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_SimpleBlobDetector_Params_get_filterByArea(pyopencv_SimpleBlobDetector_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.filterByArea);
}

static int pyopencv_SimpleBlobDetector_Params_set_filterByArea(pyopencv_SimpleBlobDetector_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the filterByArea attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.filterByArea, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_SimpleBlobDetector_Params_get_filterByCircularity(pyopencv_SimpleBlobDetector_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.filterByCircularity);
}

static int pyopencv_SimpleBlobDetector_Params_set_filterByCircularity(pyopencv_SimpleBlobDetector_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the filterByCircularity attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.filterByCircularity, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_SimpleBlobDetector_Params_get_filterByColor(pyopencv_SimpleBlobDetector_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.filterByColor);
}

static int pyopencv_SimpleBlobDetector_Params_set_filterByColor(pyopencv_SimpleBlobDetector_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the filterByColor attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.filterByColor, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_SimpleBlobDetector_Params_get_filterByConvexity(pyopencv_SimpleBlobDetector_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.filterByConvexity);
}

static int pyopencv_SimpleBlobDetector_Params_set_filterByConvexity(pyopencv_SimpleBlobDetector_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the filterByConvexity attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.filterByConvexity, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_SimpleBlobDetector_Params_get_filterByInertia(pyopencv_SimpleBlobDetector_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.filterByInertia);
}

static int pyopencv_SimpleBlobDetector_Params_set_filterByInertia(pyopencv_SimpleBlobDetector_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the filterByInertia attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.filterByInertia, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_SimpleBlobDetector_Params_get_maxArea(pyopencv_SimpleBlobDetector_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.maxArea);
}

static int pyopencv_SimpleBlobDetector_Params_set_maxArea(pyopencv_SimpleBlobDetector_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the maxArea attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.maxArea, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_SimpleBlobDetector_Params_get_maxCircularity(pyopencv_SimpleBlobDetector_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.maxCircularity);
}

static int pyopencv_SimpleBlobDetector_Params_set_maxCircularity(pyopencv_SimpleBlobDetector_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the maxCircularity attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.maxCircularity, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_SimpleBlobDetector_Params_get_maxConvexity(pyopencv_SimpleBlobDetector_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.maxConvexity);
}

static int pyopencv_SimpleBlobDetector_Params_set_maxConvexity(pyopencv_SimpleBlobDetector_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the maxConvexity attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.maxConvexity, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_SimpleBlobDetector_Params_get_maxInertiaRatio(pyopencv_SimpleBlobDetector_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.maxInertiaRatio);
}

static int pyopencv_SimpleBlobDetector_Params_set_maxInertiaRatio(pyopencv_SimpleBlobDetector_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the maxInertiaRatio attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.maxInertiaRatio, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_SimpleBlobDetector_Params_get_maxThreshold(pyopencv_SimpleBlobDetector_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.maxThreshold);
}

static int pyopencv_SimpleBlobDetector_Params_set_maxThreshold(pyopencv_SimpleBlobDetector_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the maxThreshold attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.maxThreshold, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_SimpleBlobDetector_Params_get_minArea(pyopencv_SimpleBlobDetector_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.minArea);
}

static int pyopencv_SimpleBlobDetector_Params_set_minArea(pyopencv_SimpleBlobDetector_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the minArea attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.minArea, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_SimpleBlobDetector_Params_get_minCircularity(pyopencv_SimpleBlobDetector_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.minCircularity);
}

static int pyopencv_SimpleBlobDetector_Params_set_minCircularity(pyopencv_SimpleBlobDetector_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the minCircularity attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.minCircularity, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_SimpleBlobDetector_Params_get_minConvexity(pyopencv_SimpleBlobDetector_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.minConvexity);
}

static int pyopencv_SimpleBlobDetector_Params_set_minConvexity(pyopencv_SimpleBlobDetector_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the minConvexity attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.minConvexity, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_SimpleBlobDetector_Params_get_minDistBetweenBlobs(pyopencv_SimpleBlobDetector_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.minDistBetweenBlobs);
}

static int pyopencv_SimpleBlobDetector_Params_set_minDistBetweenBlobs(pyopencv_SimpleBlobDetector_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the minDistBetweenBlobs attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.minDistBetweenBlobs, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_SimpleBlobDetector_Params_get_minInertiaRatio(pyopencv_SimpleBlobDetector_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.minInertiaRatio);
}

static int pyopencv_SimpleBlobDetector_Params_set_minInertiaRatio(pyopencv_SimpleBlobDetector_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the minInertiaRatio attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.minInertiaRatio, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_SimpleBlobDetector_Params_get_minRepeatability(pyopencv_SimpleBlobDetector_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.minRepeatability);
}

static int pyopencv_SimpleBlobDetector_Params_set_minRepeatability(pyopencv_SimpleBlobDetector_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the minRepeatability attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.minRepeatability, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_SimpleBlobDetector_Params_get_minThreshold(pyopencv_SimpleBlobDetector_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.minThreshold);
}

static int pyopencv_SimpleBlobDetector_Params_set_minThreshold(pyopencv_SimpleBlobDetector_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the minThreshold attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.minThreshold, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_SimpleBlobDetector_Params_get_thresholdStep(pyopencv_SimpleBlobDetector_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.thresholdStep);
}

static int pyopencv_SimpleBlobDetector_Params_set_thresholdStep(pyopencv_SimpleBlobDetector_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the thresholdStep attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.thresholdStep, ArgInfo("value", 0)) ? 0 : -1;
}


// Methods (SimpleBlobDetector_Params)

static int pyopencv_cv_SimpleBlobDetector_Params_SimpleBlobDetector_Params(pyopencv_SimpleBlobDetector_Params_t* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        if(self) ERRWRAP2(new (&(self->v)) cv::SimpleBlobDetector::Params());
        return 0;
    }

    return -1;
}



// Tables (SimpleBlobDetector_Params)

static PyGetSetDef pyopencv_SimpleBlobDetector_Params_getseters[] =
{
    {(char*)"blobColor", (getter)pyopencv_SimpleBlobDetector_Params_get_blobColor, (setter)pyopencv_SimpleBlobDetector_Params_set_blobColor, (char*)"blobColor", NULL},
    {(char*)"collectContours", (getter)pyopencv_SimpleBlobDetector_Params_get_collectContours, (setter)pyopencv_SimpleBlobDetector_Params_set_collectContours, (char*)"collectContours", NULL},
    {(char*)"filterByArea", (getter)pyopencv_SimpleBlobDetector_Params_get_filterByArea, (setter)pyopencv_SimpleBlobDetector_Params_set_filterByArea, (char*)"filterByArea", NULL},
    {(char*)"filterByCircularity", (getter)pyopencv_SimpleBlobDetector_Params_get_filterByCircularity, (setter)pyopencv_SimpleBlobDetector_Params_set_filterByCircularity, (char*)"filterByCircularity", NULL},
    {(char*)"filterByColor", (getter)pyopencv_SimpleBlobDetector_Params_get_filterByColor, (setter)pyopencv_SimpleBlobDetector_Params_set_filterByColor, (char*)"filterByColor", NULL},
    {(char*)"filterByConvexity", (getter)pyopencv_SimpleBlobDetector_Params_get_filterByConvexity, (setter)pyopencv_SimpleBlobDetector_Params_set_filterByConvexity, (char*)"filterByConvexity", NULL},
    {(char*)"filterByInertia", (getter)pyopencv_SimpleBlobDetector_Params_get_filterByInertia, (setter)pyopencv_SimpleBlobDetector_Params_set_filterByInertia, (char*)"filterByInertia", NULL},
    {(char*)"maxArea", (getter)pyopencv_SimpleBlobDetector_Params_get_maxArea, (setter)pyopencv_SimpleBlobDetector_Params_set_maxArea, (char*)"maxArea", NULL},
    {(char*)"maxCircularity", (getter)pyopencv_SimpleBlobDetector_Params_get_maxCircularity, (setter)pyopencv_SimpleBlobDetector_Params_set_maxCircularity, (char*)"maxCircularity", NULL},
    {(char*)"maxConvexity", (getter)pyopencv_SimpleBlobDetector_Params_get_maxConvexity, (setter)pyopencv_SimpleBlobDetector_Params_set_maxConvexity, (char*)"maxConvexity", NULL},
    {(char*)"maxInertiaRatio", (getter)pyopencv_SimpleBlobDetector_Params_get_maxInertiaRatio, (setter)pyopencv_SimpleBlobDetector_Params_set_maxInertiaRatio, (char*)"maxInertiaRatio", NULL},
    {(char*)"maxThreshold", (getter)pyopencv_SimpleBlobDetector_Params_get_maxThreshold, (setter)pyopencv_SimpleBlobDetector_Params_set_maxThreshold, (char*)"maxThreshold", NULL},
    {(char*)"minArea", (getter)pyopencv_SimpleBlobDetector_Params_get_minArea, (setter)pyopencv_SimpleBlobDetector_Params_set_minArea, (char*)"minArea", NULL},
    {(char*)"minCircularity", (getter)pyopencv_SimpleBlobDetector_Params_get_minCircularity, (setter)pyopencv_SimpleBlobDetector_Params_set_minCircularity, (char*)"minCircularity", NULL},
    {(char*)"minConvexity", (getter)pyopencv_SimpleBlobDetector_Params_get_minConvexity, (setter)pyopencv_SimpleBlobDetector_Params_set_minConvexity, (char*)"minConvexity", NULL},
    {(char*)"minDistBetweenBlobs", (getter)pyopencv_SimpleBlobDetector_Params_get_minDistBetweenBlobs, (setter)pyopencv_SimpleBlobDetector_Params_set_minDistBetweenBlobs, (char*)"minDistBetweenBlobs", NULL},
    {(char*)"minInertiaRatio", (getter)pyopencv_SimpleBlobDetector_Params_get_minInertiaRatio, (setter)pyopencv_SimpleBlobDetector_Params_set_minInertiaRatio, (char*)"minInertiaRatio", NULL},
    {(char*)"minRepeatability", (getter)pyopencv_SimpleBlobDetector_Params_get_minRepeatability, (setter)pyopencv_SimpleBlobDetector_Params_set_minRepeatability, (char*)"minRepeatability", NULL},
    {(char*)"minThreshold", (getter)pyopencv_SimpleBlobDetector_Params_get_minThreshold, (setter)pyopencv_SimpleBlobDetector_Params_set_minThreshold, (char*)"minThreshold", NULL},
    {(char*)"thresholdStep", (getter)pyopencv_SimpleBlobDetector_Params_get_thresholdStep, (setter)pyopencv_SimpleBlobDetector_Params_set_thresholdStep, (char*)"thresholdStep", NULL},
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_SimpleBlobDetector_Params_methods[] =
{

    {NULL,          NULL}
};

// Converter (SimpleBlobDetector_Params)

template<>
struct PyOpenCV_Converter< cv::SimpleBlobDetector::Params >
{
    static PyObject* from(const cv::SimpleBlobDetector::Params& r)
    {
        return pyopencv_SimpleBlobDetector_Params_Instance(r);
    }
    static bool to(PyObject* src, cv::SimpleBlobDetector::Params& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        cv::SimpleBlobDetector::Params * dst_;
        if (pyopencv_SimpleBlobDetector_Params_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected cv::SimpleBlobDetector::Params for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// SparseOpticalFlow (Generic)
//================================================================================

// GetSet (SparseOpticalFlow)



// Methods (SparseOpticalFlow)

static PyObject* pyopencv_cv_SparseOpticalFlow_calc(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::SparseOpticalFlow> * self1 = 0;
    if (!pyopencv_SparseOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'SparseOpticalFlow' or its derivative)");
    Ptr<cv::SparseOpticalFlow> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_prevImg = NULL;
    Mat prevImg;
    PyObject* pyobj_nextImg = NULL;
    Mat nextImg;
    PyObject* pyobj_prevPts = NULL;
    Mat prevPts;
    PyObject* pyobj_nextPts = NULL;
    Mat nextPts;
    PyObject* pyobj_status = NULL;
    Mat status;
    PyObject* pyobj_err = NULL;
    Mat err;

    const char* keywords[] = { "prevImg", "nextImg", "prevPts", "nextPts", "status", "err", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOOO|OO:SparseOpticalFlow.calc", (char**)keywords, &pyobj_prevImg, &pyobj_nextImg, &pyobj_prevPts, &pyobj_nextPts, &pyobj_status, &pyobj_err) &&
        pyopencv_to_safe(pyobj_prevImg, prevImg, ArgInfo("prevImg", 0)) &&
        pyopencv_to_safe(pyobj_nextImg, nextImg, ArgInfo("nextImg", 0)) &&
        pyopencv_to_safe(pyobj_prevPts, prevPts, ArgInfo("prevPts", 0)) &&
        pyopencv_to_safe(pyobj_nextPts, nextPts, ArgInfo("nextPts", 1)) &&
        pyopencv_to_safe(pyobj_status, status, ArgInfo("status", 1)) &&
        pyopencv_to_safe(pyobj_err, err, ArgInfo("err", 1)) )
    {
        ERRWRAP2(_self_->calc(prevImg, nextImg, prevPts, nextPts, status, err));
        return Py_BuildValue("(NNN)", pyopencv_from(nextPts), pyopencv_from(status), pyopencv_from(err));
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_prevImg = NULL;
    UMat prevImg;
    PyObject* pyobj_nextImg = NULL;
    UMat nextImg;
    PyObject* pyobj_prevPts = NULL;
    UMat prevPts;
    PyObject* pyobj_nextPts = NULL;
    UMat nextPts;
    PyObject* pyobj_status = NULL;
    UMat status;
    PyObject* pyobj_err = NULL;
    UMat err;

    const char* keywords[] = { "prevImg", "nextImg", "prevPts", "nextPts", "status", "err", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOOO|OO:SparseOpticalFlow.calc", (char**)keywords, &pyobj_prevImg, &pyobj_nextImg, &pyobj_prevPts, &pyobj_nextPts, &pyobj_status, &pyobj_err) &&
        pyopencv_to_safe(pyobj_prevImg, prevImg, ArgInfo("prevImg", 0)) &&
        pyopencv_to_safe(pyobj_nextImg, nextImg, ArgInfo("nextImg", 0)) &&
        pyopencv_to_safe(pyobj_prevPts, prevPts, ArgInfo("prevPts", 0)) &&
        pyopencv_to_safe(pyobj_nextPts, nextPts, ArgInfo("nextPts", 1)) &&
        pyopencv_to_safe(pyobj_status, status, ArgInfo("status", 1)) &&
        pyopencv_to_safe(pyobj_err, err, ArgInfo("err", 1)) )
    {
        ERRWRAP2(_self_->calc(prevImg, nextImg, prevPts, nextPts, status, err));
        return Py_BuildValue("(NNN)", pyopencv_from(nextPts), pyopencv_from(status), pyopencv_from(err));
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("calc");

    return NULL;
}



// Tables (SparseOpticalFlow)

static PyGetSetDef pyopencv_SparseOpticalFlow_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_SparseOpticalFlow_methods[] =
{
    {"calc", CV_PY_FN_WITH_KW_(pyopencv_cv_SparseOpticalFlow_calc, 0), "calc(prevImg, nextImg, prevPts, nextPts[, status[, err]]) -> nextPts, status, err\n.   @brief Calculates a sparse optical flow.\n.   \n.       @param prevImg First input image.\n.       @param nextImg Second input image of the same size and the same type as prevImg.\n.       @param prevPts Vector of 2D points for which the flow needs to be found.\n.       @param nextPts Output vector of 2D points containing the calculated new positions of input features in the second image.\n.       @param status Output status vector. Each element of the vector is set to 1 if the\n.                     flow for the corresponding features has been found. Otherwise, it is set to 0.\n.       @param err Optional output vector that contains error response for each point (inverse confidence)."},

    {NULL,          NULL}
};

// Converter (SparseOpticalFlow)

template<>
struct PyOpenCV_Converter< Ptr<cv::SparseOpticalFlow> >
{
    static PyObject* from(const Ptr<cv::SparseOpticalFlow>& r)
    {
        return pyopencv_SparseOpticalFlow_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::SparseOpticalFlow>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::SparseOpticalFlow> * dst_;
        if (pyopencv_SparseOpticalFlow_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::SparseOpticalFlow> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// SparsePyrLKOpticalFlow (Generic)
//================================================================================

// GetSet (SparsePyrLKOpticalFlow)



// Methods (SparsePyrLKOpticalFlow)

static PyObject* pyopencv_cv_SparsePyrLKOpticalFlow_create_static(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    PyObject* pyobj_winSize = NULL;
    Size winSize=Size(21, 21);
    PyObject* pyobj_maxLevel = NULL;
    int maxLevel=3;
    PyObject* pyobj_crit = NULL;
    TermCriteria crit=TermCriteria(TermCriteria::COUNT+TermCriteria::EPS, 30, 0.01);
    PyObject* pyobj_flags = NULL;
    int flags=0;
    PyObject* pyobj_minEigThreshold = NULL;
    double minEigThreshold=1e-4;
    Ptr<SparsePyrLKOpticalFlow> retval;

    const char* keywords[] = { "winSize", "maxLevel", "crit", "flags", "minEigThreshold", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "|OOOOO:SparsePyrLKOpticalFlow.create", (char**)keywords, &pyobj_winSize, &pyobj_maxLevel, &pyobj_crit, &pyobj_flags, &pyobj_minEigThreshold) &&
        pyopencv_to_safe(pyobj_winSize, winSize, ArgInfo("winSize", 0)) &&
        pyopencv_to_safe(pyobj_maxLevel, maxLevel, ArgInfo("maxLevel", 0)) &&
        pyopencv_to_safe(pyobj_crit, crit, ArgInfo("crit", 0)) &&
        pyopencv_to_safe(pyobj_flags, flags, ArgInfo("flags", 0)) &&
        pyopencv_to_safe(pyobj_minEigThreshold, minEigThreshold, ArgInfo("minEigThreshold", 0)) )
    {
        ERRWRAP2(retval = cv::SparsePyrLKOpticalFlow::create(winSize, maxLevel, crit, flags, minEigThreshold));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_SparsePyrLKOpticalFlow_getFlags(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::SparsePyrLKOpticalFlow> * self1 = 0;
    if (!pyopencv_SparsePyrLKOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'SparsePyrLKOpticalFlow' or its derivative)");
    Ptr<cv::SparsePyrLKOpticalFlow> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getFlags());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_SparsePyrLKOpticalFlow_getMaxLevel(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::SparsePyrLKOpticalFlow> * self1 = 0;
    if (!pyopencv_SparsePyrLKOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'SparsePyrLKOpticalFlow' or its derivative)");
    Ptr<cv::SparsePyrLKOpticalFlow> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getMaxLevel());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_SparsePyrLKOpticalFlow_getMinEigThreshold(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::SparsePyrLKOpticalFlow> * self1 = 0;
    if (!pyopencv_SparsePyrLKOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'SparsePyrLKOpticalFlow' or its derivative)");
    Ptr<cv::SparsePyrLKOpticalFlow> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getMinEigThreshold());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_SparsePyrLKOpticalFlow_getTermCriteria(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::SparsePyrLKOpticalFlow> * self1 = 0;
    if (!pyopencv_SparsePyrLKOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'SparsePyrLKOpticalFlow' or its derivative)");
    Ptr<cv::SparsePyrLKOpticalFlow> _self_ = *(self1);
    TermCriteria retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getTermCriteria());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_SparsePyrLKOpticalFlow_getWinSize(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::SparsePyrLKOpticalFlow> * self1 = 0;
    if (!pyopencv_SparsePyrLKOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'SparsePyrLKOpticalFlow' or its derivative)");
    Ptr<cv::SparsePyrLKOpticalFlow> _self_ = *(self1);
    Size retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getWinSize());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_SparsePyrLKOpticalFlow_setFlags(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::SparsePyrLKOpticalFlow> * self1 = 0;
    if (!pyopencv_SparsePyrLKOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'SparsePyrLKOpticalFlow' or its derivative)");
    Ptr<cv::SparsePyrLKOpticalFlow> _self_ = *(self1);
    PyObject* pyobj_flags = NULL;
    int flags=0;

    const char* keywords[] = { "flags", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:SparsePyrLKOpticalFlow.setFlags", (char**)keywords, &pyobj_flags) &&
        pyopencv_to_safe(pyobj_flags, flags, ArgInfo("flags", 0)) )
    {
        ERRWRAP2(_self_->setFlags(flags));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_SparsePyrLKOpticalFlow_setMaxLevel(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::SparsePyrLKOpticalFlow> * self1 = 0;
    if (!pyopencv_SparsePyrLKOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'SparsePyrLKOpticalFlow' or its derivative)");
    Ptr<cv::SparsePyrLKOpticalFlow> _self_ = *(self1);
    PyObject* pyobj_maxLevel = NULL;
    int maxLevel=0;

    const char* keywords[] = { "maxLevel", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:SparsePyrLKOpticalFlow.setMaxLevel", (char**)keywords, &pyobj_maxLevel) &&
        pyopencv_to_safe(pyobj_maxLevel, maxLevel, ArgInfo("maxLevel", 0)) )
    {
        ERRWRAP2(_self_->setMaxLevel(maxLevel));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_SparsePyrLKOpticalFlow_setMinEigThreshold(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::SparsePyrLKOpticalFlow> * self1 = 0;
    if (!pyopencv_SparsePyrLKOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'SparsePyrLKOpticalFlow' or its derivative)");
    Ptr<cv::SparsePyrLKOpticalFlow> _self_ = *(self1);
    PyObject* pyobj_minEigThreshold = NULL;
    double minEigThreshold=0;

    const char* keywords[] = { "minEigThreshold", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:SparsePyrLKOpticalFlow.setMinEigThreshold", (char**)keywords, &pyobj_minEigThreshold) &&
        pyopencv_to_safe(pyobj_minEigThreshold, minEigThreshold, ArgInfo("minEigThreshold", 0)) )
    {
        ERRWRAP2(_self_->setMinEigThreshold(minEigThreshold));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_SparsePyrLKOpticalFlow_setTermCriteria(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::SparsePyrLKOpticalFlow> * self1 = 0;
    if (!pyopencv_SparsePyrLKOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'SparsePyrLKOpticalFlow' or its derivative)");
    Ptr<cv::SparsePyrLKOpticalFlow> _self_ = *(self1);
    PyObject* pyobj_crit = NULL;
    TermCriteria crit;

    const char* keywords[] = { "crit", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:SparsePyrLKOpticalFlow.setTermCriteria", (char**)keywords, &pyobj_crit) &&
        pyopencv_to_safe(pyobj_crit, crit, ArgInfo("crit", 0)) )
    {
        ERRWRAP2(_self_->setTermCriteria(crit));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_SparsePyrLKOpticalFlow_setWinSize(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::SparsePyrLKOpticalFlow> * self1 = 0;
    if (!pyopencv_SparsePyrLKOpticalFlow_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'SparsePyrLKOpticalFlow' or its derivative)");
    Ptr<cv::SparsePyrLKOpticalFlow> _self_ = *(self1);
    PyObject* pyobj_winSize = NULL;
    Size winSize;

    const char* keywords[] = { "winSize", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:SparsePyrLKOpticalFlow.setWinSize", (char**)keywords, &pyobj_winSize) &&
        pyopencv_to_safe(pyobj_winSize, winSize, ArgInfo("winSize", 0)) )
    {
        ERRWRAP2(_self_->setWinSize(winSize));
        Py_RETURN_NONE;
    }

    return NULL;
}



// Tables (SparsePyrLKOpticalFlow)

static PyGetSetDef pyopencv_SparsePyrLKOpticalFlow_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_SparsePyrLKOpticalFlow_methods[] =
{
    {"create", CV_PY_FN_WITH_KW_(pyopencv_cv_SparsePyrLKOpticalFlow_create_static, METH_STATIC), "create([, winSize[, maxLevel[, crit[, flags[, minEigThreshold]]]]]) -> retval\n."},
    {"getFlags", CV_PY_FN_WITH_KW_(pyopencv_cv_SparsePyrLKOpticalFlow_getFlags, 0), "getFlags() -> retval\n."},
    {"getMaxLevel", CV_PY_FN_WITH_KW_(pyopencv_cv_SparsePyrLKOpticalFlow_getMaxLevel, 0), "getMaxLevel() -> retval\n."},
    {"getMinEigThreshold", CV_PY_FN_WITH_KW_(pyopencv_cv_SparsePyrLKOpticalFlow_getMinEigThreshold, 0), "getMinEigThreshold() -> retval\n."},
    {"getTermCriteria", CV_PY_FN_WITH_KW_(pyopencv_cv_SparsePyrLKOpticalFlow_getTermCriteria, 0), "getTermCriteria() -> retval\n."},
    {"getWinSize", CV_PY_FN_WITH_KW_(pyopencv_cv_SparsePyrLKOpticalFlow_getWinSize, 0), "getWinSize() -> retval\n."},
    {"setFlags", CV_PY_FN_WITH_KW_(pyopencv_cv_SparsePyrLKOpticalFlow_setFlags, 0), "setFlags(flags) -> None\n."},
    {"setMaxLevel", CV_PY_FN_WITH_KW_(pyopencv_cv_SparsePyrLKOpticalFlow_setMaxLevel, 0), "setMaxLevel(maxLevel) -> None\n."},
    {"setMinEigThreshold", CV_PY_FN_WITH_KW_(pyopencv_cv_SparsePyrLKOpticalFlow_setMinEigThreshold, 0), "setMinEigThreshold(minEigThreshold) -> None\n."},
    {"setTermCriteria", CV_PY_FN_WITH_KW_(pyopencv_cv_SparsePyrLKOpticalFlow_setTermCriteria, 0), "setTermCriteria(crit) -> None\n."},
    {"setWinSize", CV_PY_FN_WITH_KW_(pyopencv_cv_SparsePyrLKOpticalFlow_setWinSize, 0), "setWinSize(winSize) -> None\n."},

    {NULL,          NULL}
};

// Converter (SparsePyrLKOpticalFlow)

template<>
struct PyOpenCV_Converter< Ptr<cv::SparsePyrLKOpticalFlow> >
{
    static PyObject* from(const Ptr<cv::SparsePyrLKOpticalFlow>& r)
    {
        return pyopencv_SparsePyrLKOpticalFlow_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::SparsePyrLKOpticalFlow>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::SparsePyrLKOpticalFlow> * dst_;
        if (pyopencv_SparsePyrLKOpticalFlow_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::SparsePyrLKOpticalFlow> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// StereoBM (Generic)
//================================================================================

// GetSet (StereoBM)



// Methods (StereoBM)

static PyObject* pyopencv_cv_StereoBM_create_static(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    PyObject* pyobj_numDisparities = NULL;
    int numDisparities=0;
    PyObject* pyobj_blockSize = NULL;
    int blockSize=21;
    Ptr<StereoBM> retval;

    const char* keywords[] = { "numDisparities", "blockSize", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "|OO:StereoBM.create", (char**)keywords, &pyobj_numDisparities, &pyobj_blockSize) &&
        pyopencv_to_safe(pyobj_numDisparities, numDisparities, ArgInfo("numDisparities", 0)) &&
        pyopencv_to_safe(pyobj_blockSize, blockSize, ArgInfo("blockSize", 0)) )
    {
        ERRWRAP2(retval = cv::StereoBM::create(numDisparities, blockSize));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_StereoBM_getPreFilterCap(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::StereoBM> * self1 = 0;
    if (!pyopencv_StereoBM_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'StereoBM' or its derivative)");
    Ptr<cv::StereoBM> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getPreFilterCap());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_StereoBM_getPreFilterSize(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::StereoBM> * self1 = 0;
    if (!pyopencv_StereoBM_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'StereoBM' or its derivative)");
    Ptr<cv::StereoBM> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getPreFilterSize());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_StereoBM_getPreFilterType(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::StereoBM> * self1 = 0;
    if (!pyopencv_StereoBM_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'StereoBM' or its derivative)");
    Ptr<cv::StereoBM> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getPreFilterType());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_StereoBM_getROI1(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::StereoBM> * self1 = 0;
    if (!pyopencv_StereoBM_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'StereoBM' or its derivative)");
    Ptr<cv::StereoBM> _self_ = *(self1);
    Rect retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getROI1());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_StereoBM_getROI2(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::StereoBM> * self1 = 0;
    if (!pyopencv_StereoBM_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'StereoBM' or its derivative)");
    Ptr<cv::StereoBM> _self_ = *(self1);
    Rect retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getROI2());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_StereoBM_getSmallerBlockSize(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::StereoBM> * self1 = 0;
    if (!pyopencv_StereoBM_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'StereoBM' or its derivative)");
    Ptr<cv::StereoBM> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getSmallerBlockSize());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_StereoBM_getTextureThreshold(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::StereoBM> * self1 = 0;
    if (!pyopencv_StereoBM_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'StereoBM' or its derivative)");
    Ptr<cv::StereoBM> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getTextureThreshold());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_StereoBM_getUniquenessRatio(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::StereoBM> * self1 = 0;
    if (!pyopencv_StereoBM_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'StereoBM' or its derivative)");
    Ptr<cv::StereoBM> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getUniquenessRatio());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_StereoBM_setPreFilterCap(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::StereoBM> * self1 = 0;
    if (!pyopencv_StereoBM_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'StereoBM' or its derivative)");
    Ptr<cv::StereoBM> _self_ = *(self1);
    PyObject* pyobj_preFilterCap = NULL;
    int preFilterCap=0;

    const char* keywords[] = { "preFilterCap", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:StereoBM.setPreFilterCap", (char**)keywords, &pyobj_preFilterCap) &&
        pyopencv_to_safe(pyobj_preFilterCap, preFilterCap, ArgInfo("preFilterCap", 0)) )
    {
        ERRWRAP2(_self_->setPreFilterCap(preFilterCap));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_StereoBM_setPreFilterSize(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::StereoBM> * self1 = 0;
    if (!pyopencv_StereoBM_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'StereoBM' or its derivative)");
    Ptr<cv::StereoBM> _self_ = *(self1);
    PyObject* pyobj_preFilterSize = NULL;
    int preFilterSize=0;

    const char* keywords[] = { "preFilterSize", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:StereoBM.setPreFilterSize", (char**)keywords, &pyobj_preFilterSize) &&
        pyopencv_to_safe(pyobj_preFilterSize, preFilterSize, ArgInfo("preFilterSize", 0)) )
    {
        ERRWRAP2(_self_->setPreFilterSize(preFilterSize));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_StereoBM_setPreFilterType(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::StereoBM> * self1 = 0;
    if (!pyopencv_StereoBM_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'StereoBM' or its derivative)");
    Ptr<cv::StereoBM> _self_ = *(self1);
    PyObject* pyobj_preFilterType = NULL;
    int preFilterType=0;

    const char* keywords[] = { "preFilterType", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:StereoBM.setPreFilterType", (char**)keywords, &pyobj_preFilterType) &&
        pyopencv_to_safe(pyobj_preFilterType, preFilterType, ArgInfo("preFilterType", 0)) )
    {
        ERRWRAP2(_self_->setPreFilterType(preFilterType));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_StereoBM_setROI1(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::StereoBM> * self1 = 0;
    if (!pyopencv_StereoBM_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'StereoBM' or its derivative)");
    Ptr<cv::StereoBM> _self_ = *(self1);
    PyObject* pyobj_roi1 = NULL;
    Rect roi1;

    const char* keywords[] = { "roi1", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:StereoBM.setROI1", (char**)keywords, &pyobj_roi1) &&
        pyopencv_to_safe(pyobj_roi1, roi1, ArgInfo("roi1", 0)) )
    {
        ERRWRAP2(_self_->setROI1(roi1));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_StereoBM_setROI2(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::StereoBM> * self1 = 0;
    if (!pyopencv_StereoBM_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'StereoBM' or its derivative)");
    Ptr<cv::StereoBM> _self_ = *(self1);
    PyObject* pyobj_roi2 = NULL;
    Rect roi2;

    const char* keywords[] = { "roi2", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:StereoBM.setROI2", (char**)keywords, &pyobj_roi2) &&
        pyopencv_to_safe(pyobj_roi2, roi2, ArgInfo("roi2", 0)) )
    {
        ERRWRAP2(_self_->setROI2(roi2));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_StereoBM_setSmallerBlockSize(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::StereoBM> * self1 = 0;
    if (!pyopencv_StereoBM_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'StereoBM' or its derivative)");
    Ptr<cv::StereoBM> _self_ = *(self1);
    PyObject* pyobj_blockSize = NULL;
    int blockSize=0;

    const char* keywords[] = { "blockSize", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:StereoBM.setSmallerBlockSize", (char**)keywords, &pyobj_blockSize) &&
        pyopencv_to_safe(pyobj_blockSize, blockSize, ArgInfo("blockSize", 0)) )
    {
        ERRWRAP2(_self_->setSmallerBlockSize(blockSize));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_StereoBM_setTextureThreshold(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::StereoBM> * self1 = 0;
    if (!pyopencv_StereoBM_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'StereoBM' or its derivative)");
    Ptr<cv::StereoBM> _self_ = *(self1);
    PyObject* pyobj_textureThreshold = NULL;
    int textureThreshold=0;

    const char* keywords[] = { "textureThreshold", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:StereoBM.setTextureThreshold", (char**)keywords, &pyobj_textureThreshold) &&
        pyopencv_to_safe(pyobj_textureThreshold, textureThreshold, ArgInfo("textureThreshold", 0)) )
    {
        ERRWRAP2(_self_->setTextureThreshold(textureThreshold));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_StereoBM_setUniquenessRatio(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::StereoBM> * self1 = 0;
    if (!pyopencv_StereoBM_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'StereoBM' or its derivative)");
    Ptr<cv::StereoBM> _self_ = *(self1);
    PyObject* pyobj_uniquenessRatio = NULL;
    int uniquenessRatio=0;

    const char* keywords[] = { "uniquenessRatio", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:StereoBM.setUniquenessRatio", (char**)keywords, &pyobj_uniquenessRatio) &&
        pyopencv_to_safe(pyobj_uniquenessRatio, uniquenessRatio, ArgInfo("uniquenessRatio", 0)) )
    {
        ERRWRAP2(_self_->setUniquenessRatio(uniquenessRatio));
        Py_RETURN_NONE;
    }

    return NULL;
}



// Tables (StereoBM)

static PyGetSetDef pyopencv_StereoBM_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_StereoBM_methods[] =
{
    {"create", CV_PY_FN_WITH_KW_(pyopencv_cv_StereoBM_create_static, METH_STATIC), "create([, numDisparities[, blockSize]]) -> retval\n.   @brief Creates StereoBM object\n.   \n.       @param numDisparities the disparity search range. For each pixel algorithm will find the best\n.       disparity from 0 (default minimum disparity) to numDisparities. The search range can then be\n.       shifted by changing the minimum disparity.\n.       @param blockSize the linear size of the blocks compared by the algorithm. The size should be odd\n.       (as the block is centered at the current pixel). Larger block size implies smoother, though less\n.       accurate disparity map. Smaller block size gives more detailed disparity map, but there is higher\n.       chance for algorithm to find a wrong correspondence.\n.   \n.       The function create StereoBM object. You can then call StereoBM::compute() to compute disparity for\n.       a specific stereo pair."},
    {"getPreFilterCap", CV_PY_FN_WITH_KW_(pyopencv_cv_StereoBM_getPreFilterCap, 0), "getPreFilterCap() -> retval\n."},
    {"getPreFilterSize", CV_PY_FN_WITH_KW_(pyopencv_cv_StereoBM_getPreFilterSize, 0), "getPreFilterSize() -> retval\n."},
    {"getPreFilterType", CV_PY_FN_WITH_KW_(pyopencv_cv_StereoBM_getPreFilterType, 0), "getPreFilterType() -> retval\n."},
    {"getROI1", CV_PY_FN_WITH_KW_(pyopencv_cv_StereoBM_getROI1, 0), "getROI1() -> retval\n."},
    {"getROI2", CV_PY_FN_WITH_KW_(pyopencv_cv_StereoBM_getROI2, 0), "getROI2() -> retval\n."},
    {"getSmallerBlockSize", CV_PY_FN_WITH_KW_(pyopencv_cv_StereoBM_getSmallerBlockSize, 0), "getSmallerBlockSize() -> retval\n."},
    {"getTextureThreshold", CV_PY_FN_WITH_KW_(pyopencv_cv_StereoBM_getTextureThreshold, 0), "getTextureThreshold() -> retval\n."},
    {"getUniquenessRatio", CV_PY_FN_WITH_KW_(pyopencv_cv_StereoBM_getUniquenessRatio, 0), "getUniquenessRatio() -> retval\n."},
    {"setPreFilterCap", CV_PY_FN_WITH_KW_(pyopencv_cv_StereoBM_setPreFilterCap, 0), "setPreFilterCap(preFilterCap) -> None\n."},
    {"setPreFilterSize", CV_PY_FN_WITH_KW_(pyopencv_cv_StereoBM_setPreFilterSize, 0), "setPreFilterSize(preFilterSize) -> None\n."},
    {"setPreFilterType", CV_PY_FN_WITH_KW_(pyopencv_cv_StereoBM_setPreFilterType, 0), "setPreFilterType(preFilterType) -> None\n."},
    {"setROI1", CV_PY_FN_WITH_KW_(pyopencv_cv_StereoBM_setROI1, 0), "setROI1(roi1) -> None\n."},
    {"setROI2", CV_PY_FN_WITH_KW_(pyopencv_cv_StereoBM_setROI2, 0), "setROI2(roi2) -> None\n."},
    {"setSmallerBlockSize", CV_PY_FN_WITH_KW_(pyopencv_cv_StereoBM_setSmallerBlockSize, 0), "setSmallerBlockSize(blockSize) -> None\n."},
    {"setTextureThreshold", CV_PY_FN_WITH_KW_(pyopencv_cv_StereoBM_setTextureThreshold, 0), "setTextureThreshold(textureThreshold) -> None\n."},
    {"setUniquenessRatio", CV_PY_FN_WITH_KW_(pyopencv_cv_StereoBM_setUniquenessRatio, 0), "setUniquenessRatio(uniquenessRatio) -> None\n."},

    {NULL,          NULL}
};

// Converter (StereoBM)

template<>
struct PyOpenCV_Converter< Ptr<cv::StereoBM> >
{
    static PyObject* from(const Ptr<cv::StereoBM>& r)
    {
        return pyopencv_StereoBM_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::StereoBM>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::StereoBM> * dst_;
        if (pyopencv_StereoBM_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::StereoBM> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// StereoMatcher (Generic)
//================================================================================

// GetSet (StereoMatcher)



// Methods (StereoMatcher)

static PyObject* pyopencv_cv_StereoMatcher_compute(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::StereoMatcher> * self1 = 0;
    if (!pyopencv_StereoMatcher_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'StereoMatcher' or its derivative)");
    Ptr<cv::StereoMatcher> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_left = NULL;
    Mat left;
    PyObject* pyobj_right = NULL;
    Mat right;
    PyObject* pyobj_disparity = NULL;
    Mat disparity;

    const char* keywords[] = { "left", "right", "disparity", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO|O:StereoMatcher.compute", (char**)keywords, &pyobj_left, &pyobj_right, &pyobj_disparity) &&
        pyopencv_to_safe(pyobj_left, left, ArgInfo("left", 0)) &&
        pyopencv_to_safe(pyobj_right, right, ArgInfo("right", 0)) &&
        pyopencv_to_safe(pyobj_disparity, disparity, ArgInfo("disparity", 1)) )
    {
        ERRWRAP2(_self_->compute(left, right, disparity));
        return pyopencv_from(disparity);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_left = NULL;
    UMat left;
    PyObject* pyobj_right = NULL;
    UMat right;
    PyObject* pyobj_disparity = NULL;
    UMat disparity;

    const char* keywords[] = { "left", "right", "disparity", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO|O:StereoMatcher.compute", (char**)keywords, &pyobj_left, &pyobj_right, &pyobj_disparity) &&
        pyopencv_to_safe(pyobj_left, left, ArgInfo("left", 0)) &&
        pyopencv_to_safe(pyobj_right, right, ArgInfo("right", 0)) &&
        pyopencv_to_safe(pyobj_disparity, disparity, ArgInfo("disparity", 1)) )
    {
        ERRWRAP2(_self_->compute(left, right, disparity));
        return pyopencv_from(disparity);
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("compute");

    return NULL;
}

static PyObject* pyopencv_cv_StereoMatcher_getBlockSize(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::StereoMatcher> * self1 = 0;
    if (!pyopencv_StereoMatcher_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'StereoMatcher' or its derivative)");
    Ptr<cv::StereoMatcher> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getBlockSize());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_StereoMatcher_getDisp12MaxDiff(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::StereoMatcher> * self1 = 0;
    if (!pyopencv_StereoMatcher_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'StereoMatcher' or its derivative)");
    Ptr<cv::StereoMatcher> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getDisp12MaxDiff());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_StereoMatcher_getMinDisparity(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::StereoMatcher> * self1 = 0;
    if (!pyopencv_StereoMatcher_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'StereoMatcher' or its derivative)");
    Ptr<cv::StereoMatcher> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getMinDisparity());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_StereoMatcher_getNumDisparities(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::StereoMatcher> * self1 = 0;
    if (!pyopencv_StereoMatcher_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'StereoMatcher' or its derivative)");
    Ptr<cv::StereoMatcher> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getNumDisparities());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_StereoMatcher_getSpeckleRange(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::StereoMatcher> * self1 = 0;
    if (!pyopencv_StereoMatcher_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'StereoMatcher' or its derivative)");
    Ptr<cv::StereoMatcher> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getSpeckleRange());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_StereoMatcher_getSpeckleWindowSize(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::StereoMatcher> * self1 = 0;
    if (!pyopencv_StereoMatcher_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'StereoMatcher' or its derivative)");
    Ptr<cv::StereoMatcher> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getSpeckleWindowSize());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_StereoMatcher_setBlockSize(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::StereoMatcher> * self1 = 0;
    if (!pyopencv_StereoMatcher_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'StereoMatcher' or its derivative)");
    Ptr<cv::StereoMatcher> _self_ = *(self1);
    PyObject* pyobj_blockSize = NULL;
    int blockSize=0;

    const char* keywords[] = { "blockSize", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:StereoMatcher.setBlockSize", (char**)keywords, &pyobj_blockSize) &&
        pyopencv_to_safe(pyobj_blockSize, blockSize, ArgInfo("blockSize", 0)) )
    {
        ERRWRAP2(_self_->setBlockSize(blockSize));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_StereoMatcher_setDisp12MaxDiff(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::StereoMatcher> * self1 = 0;
    if (!pyopencv_StereoMatcher_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'StereoMatcher' or its derivative)");
    Ptr<cv::StereoMatcher> _self_ = *(self1);
    PyObject* pyobj_disp12MaxDiff = NULL;
    int disp12MaxDiff=0;

    const char* keywords[] = { "disp12MaxDiff", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:StereoMatcher.setDisp12MaxDiff", (char**)keywords, &pyobj_disp12MaxDiff) &&
        pyopencv_to_safe(pyobj_disp12MaxDiff, disp12MaxDiff, ArgInfo("disp12MaxDiff", 0)) )
    {
        ERRWRAP2(_self_->setDisp12MaxDiff(disp12MaxDiff));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_StereoMatcher_setMinDisparity(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::StereoMatcher> * self1 = 0;
    if (!pyopencv_StereoMatcher_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'StereoMatcher' or its derivative)");
    Ptr<cv::StereoMatcher> _self_ = *(self1);
    PyObject* pyobj_minDisparity = NULL;
    int minDisparity=0;

    const char* keywords[] = { "minDisparity", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:StereoMatcher.setMinDisparity", (char**)keywords, &pyobj_minDisparity) &&
        pyopencv_to_safe(pyobj_minDisparity, minDisparity, ArgInfo("minDisparity", 0)) )
    {
        ERRWRAP2(_self_->setMinDisparity(minDisparity));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_StereoMatcher_setNumDisparities(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::StereoMatcher> * self1 = 0;
    if (!pyopencv_StereoMatcher_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'StereoMatcher' or its derivative)");
    Ptr<cv::StereoMatcher> _self_ = *(self1);
    PyObject* pyobj_numDisparities = NULL;
    int numDisparities=0;

    const char* keywords[] = { "numDisparities", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:StereoMatcher.setNumDisparities", (char**)keywords, &pyobj_numDisparities) &&
        pyopencv_to_safe(pyobj_numDisparities, numDisparities, ArgInfo("numDisparities", 0)) )
    {
        ERRWRAP2(_self_->setNumDisparities(numDisparities));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_StereoMatcher_setSpeckleRange(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::StereoMatcher> * self1 = 0;
    if (!pyopencv_StereoMatcher_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'StereoMatcher' or its derivative)");
    Ptr<cv::StereoMatcher> _self_ = *(self1);
    PyObject* pyobj_speckleRange = NULL;
    int speckleRange=0;

    const char* keywords[] = { "speckleRange", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:StereoMatcher.setSpeckleRange", (char**)keywords, &pyobj_speckleRange) &&
        pyopencv_to_safe(pyobj_speckleRange, speckleRange, ArgInfo("speckleRange", 0)) )
    {
        ERRWRAP2(_self_->setSpeckleRange(speckleRange));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_StereoMatcher_setSpeckleWindowSize(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::StereoMatcher> * self1 = 0;
    if (!pyopencv_StereoMatcher_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'StereoMatcher' or its derivative)");
    Ptr<cv::StereoMatcher> _self_ = *(self1);
    PyObject* pyobj_speckleWindowSize = NULL;
    int speckleWindowSize=0;

    const char* keywords[] = { "speckleWindowSize", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:StereoMatcher.setSpeckleWindowSize", (char**)keywords, &pyobj_speckleWindowSize) &&
        pyopencv_to_safe(pyobj_speckleWindowSize, speckleWindowSize, ArgInfo("speckleWindowSize", 0)) )
    {
        ERRWRAP2(_self_->setSpeckleWindowSize(speckleWindowSize));
        Py_RETURN_NONE;
    }

    return NULL;
}



// Tables (StereoMatcher)

static PyGetSetDef pyopencv_StereoMatcher_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_StereoMatcher_methods[] =
{
    {"compute", CV_PY_FN_WITH_KW_(pyopencv_cv_StereoMatcher_compute, 0), "compute(left, right[, disparity]) -> disparity\n.   @brief Computes disparity map for the specified stereo pair\n.   \n.       @param left Left 8-bit single-channel image.\n.       @param right Right image of the same size and the same type as the left one.\n.       @param disparity Output disparity map. It has the same size as the input images. Some algorithms,\n.       like StereoBM or StereoSGBM compute 16-bit fixed-point disparity map (where each disparity value\n.       has 4 fractional bits), whereas other algorithms output 32-bit floating-point disparity map."},
    {"getBlockSize", CV_PY_FN_WITH_KW_(pyopencv_cv_StereoMatcher_getBlockSize, 0), "getBlockSize() -> retval\n."},
    {"getDisp12MaxDiff", CV_PY_FN_WITH_KW_(pyopencv_cv_StereoMatcher_getDisp12MaxDiff, 0), "getDisp12MaxDiff() -> retval\n."},
    {"getMinDisparity", CV_PY_FN_WITH_KW_(pyopencv_cv_StereoMatcher_getMinDisparity, 0), "getMinDisparity() -> retval\n."},
    {"getNumDisparities", CV_PY_FN_WITH_KW_(pyopencv_cv_StereoMatcher_getNumDisparities, 0), "getNumDisparities() -> retval\n."},
    {"getSpeckleRange", CV_PY_FN_WITH_KW_(pyopencv_cv_StereoMatcher_getSpeckleRange, 0), "getSpeckleRange() -> retval\n."},
    {"getSpeckleWindowSize", CV_PY_FN_WITH_KW_(pyopencv_cv_StereoMatcher_getSpeckleWindowSize, 0), "getSpeckleWindowSize() -> retval\n."},
    {"setBlockSize", CV_PY_FN_WITH_KW_(pyopencv_cv_StereoMatcher_setBlockSize, 0), "setBlockSize(blockSize) -> None\n."},
    {"setDisp12MaxDiff", CV_PY_FN_WITH_KW_(pyopencv_cv_StereoMatcher_setDisp12MaxDiff, 0), "setDisp12MaxDiff(disp12MaxDiff) -> None\n."},
    {"setMinDisparity", CV_PY_FN_WITH_KW_(pyopencv_cv_StereoMatcher_setMinDisparity, 0), "setMinDisparity(minDisparity) -> None\n."},
    {"setNumDisparities", CV_PY_FN_WITH_KW_(pyopencv_cv_StereoMatcher_setNumDisparities, 0), "setNumDisparities(numDisparities) -> None\n."},
    {"setSpeckleRange", CV_PY_FN_WITH_KW_(pyopencv_cv_StereoMatcher_setSpeckleRange, 0), "setSpeckleRange(speckleRange) -> None\n."},
    {"setSpeckleWindowSize", CV_PY_FN_WITH_KW_(pyopencv_cv_StereoMatcher_setSpeckleWindowSize, 0), "setSpeckleWindowSize(speckleWindowSize) -> None\n."},

    {NULL,          NULL}
};

// Converter (StereoMatcher)

template<>
struct PyOpenCV_Converter< Ptr<cv::StereoMatcher> >
{
    static PyObject* from(const Ptr<cv::StereoMatcher>& r)
    {
        return pyopencv_StereoMatcher_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::StereoMatcher>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::StereoMatcher> * dst_;
        if (pyopencv_StereoMatcher_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::StereoMatcher> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// StereoSGBM (Generic)
//================================================================================

// GetSet (StereoSGBM)



// Methods (StereoSGBM)

static PyObject* pyopencv_cv_StereoSGBM_create_static(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    PyObject* pyobj_minDisparity = NULL;
    int minDisparity=0;
    PyObject* pyobj_numDisparities = NULL;
    int numDisparities=16;
    PyObject* pyobj_blockSize = NULL;
    int blockSize=3;
    PyObject* pyobj_P1 = NULL;
    int P1=0;
    PyObject* pyobj_P2 = NULL;
    int P2=0;
    PyObject* pyobj_disp12MaxDiff = NULL;
    int disp12MaxDiff=0;
    PyObject* pyobj_preFilterCap = NULL;
    int preFilterCap=0;
    PyObject* pyobj_uniquenessRatio = NULL;
    int uniquenessRatio=0;
    PyObject* pyobj_speckleWindowSize = NULL;
    int speckleWindowSize=0;
    PyObject* pyobj_speckleRange = NULL;
    int speckleRange=0;
    PyObject* pyobj_mode = NULL;
    int mode=StereoSGBM::MODE_SGBM;
    Ptr<StereoSGBM> retval;

    const char* keywords[] = { "minDisparity", "numDisparities", "blockSize", "P1", "P2", "disp12MaxDiff", "preFilterCap", "uniquenessRatio", "speckleWindowSize", "speckleRange", "mode", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "|OOOOOOOOOOO:StereoSGBM.create", (char**)keywords, &pyobj_minDisparity, &pyobj_numDisparities, &pyobj_blockSize, &pyobj_P1, &pyobj_P2, &pyobj_disp12MaxDiff, &pyobj_preFilterCap, &pyobj_uniquenessRatio, &pyobj_speckleWindowSize, &pyobj_speckleRange, &pyobj_mode) &&
        pyopencv_to_safe(pyobj_minDisparity, minDisparity, ArgInfo("minDisparity", 0)) &&
        pyopencv_to_safe(pyobj_numDisparities, numDisparities, ArgInfo("numDisparities", 0)) &&
        pyopencv_to_safe(pyobj_blockSize, blockSize, ArgInfo("blockSize", 0)) &&
        pyopencv_to_safe(pyobj_P1, P1, ArgInfo("P1", 0)) &&
        pyopencv_to_safe(pyobj_P2, P2, ArgInfo("P2", 0)) &&
        pyopencv_to_safe(pyobj_disp12MaxDiff, disp12MaxDiff, ArgInfo("disp12MaxDiff", 0)) &&
        pyopencv_to_safe(pyobj_preFilterCap, preFilterCap, ArgInfo("preFilterCap", 0)) &&
        pyopencv_to_safe(pyobj_uniquenessRatio, uniquenessRatio, ArgInfo("uniquenessRatio", 0)) &&
        pyopencv_to_safe(pyobj_speckleWindowSize, speckleWindowSize, ArgInfo("speckleWindowSize", 0)) &&
        pyopencv_to_safe(pyobj_speckleRange, speckleRange, ArgInfo("speckleRange", 0)) &&
        pyopencv_to_safe(pyobj_mode, mode, ArgInfo("mode", 0)) )
    {
        ERRWRAP2(retval = cv::StereoSGBM::create(minDisparity, numDisparities, blockSize, P1, P2, disp12MaxDiff, preFilterCap, uniquenessRatio, speckleWindowSize, speckleRange, mode));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_StereoSGBM_getMode(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::StereoSGBM> * self1 = 0;
    if (!pyopencv_StereoSGBM_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'StereoSGBM' or its derivative)");
    Ptr<cv::StereoSGBM> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getMode());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_StereoSGBM_getP1(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::StereoSGBM> * self1 = 0;
    if (!pyopencv_StereoSGBM_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'StereoSGBM' or its derivative)");
    Ptr<cv::StereoSGBM> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getP1());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_StereoSGBM_getP2(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::StereoSGBM> * self1 = 0;
    if (!pyopencv_StereoSGBM_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'StereoSGBM' or its derivative)");
    Ptr<cv::StereoSGBM> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getP2());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_StereoSGBM_getPreFilterCap(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::StereoSGBM> * self1 = 0;
    if (!pyopencv_StereoSGBM_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'StereoSGBM' or its derivative)");
    Ptr<cv::StereoSGBM> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getPreFilterCap());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_StereoSGBM_getUniquenessRatio(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::StereoSGBM> * self1 = 0;
    if (!pyopencv_StereoSGBM_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'StereoSGBM' or its derivative)");
    Ptr<cv::StereoSGBM> _self_ = *(self1);
    int retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getUniquenessRatio());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_StereoSGBM_setMode(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::StereoSGBM> * self1 = 0;
    if (!pyopencv_StereoSGBM_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'StereoSGBM' or its derivative)");
    Ptr<cv::StereoSGBM> _self_ = *(self1);
    PyObject* pyobj_mode = NULL;
    int mode=0;

    const char* keywords[] = { "mode", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:StereoSGBM.setMode", (char**)keywords, &pyobj_mode) &&
        pyopencv_to_safe(pyobj_mode, mode, ArgInfo("mode", 0)) )
    {
        ERRWRAP2(_self_->setMode(mode));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_StereoSGBM_setP1(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::StereoSGBM> * self1 = 0;
    if (!pyopencv_StereoSGBM_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'StereoSGBM' or its derivative)");
    Ptr<cv::StereoSGBM> _self_ = *(self1);
    PyObject* pyobj_P1 = NULL;
    int P1=0;

    const char* keywords[] = { "P1", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:StereoSGBM.setP1", (char**)keywords, &pyobj_P1) &&
        pyopencv_to_safe(pyobj_P1, P1, ArgInfo("P1", 0)) )
    {
        ERRWRAP2(_self_->setP1(P1));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_StereoSGBM_setP2(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::StereoSGBM> * self1 = 0;
    if (!pyopencv_StereoSGBM_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'StereoSGBM' or its derivative)");
    Ptr<cv::StereoSGBM> _self_ = *(self1);
    PyObject* pyobj_P2 = NULL;
    int P2=0;

    const char* keywords[] = { "P2", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:StereoSGBM.setP2", (char**)keywords, &pyobj_P2) &&
        pyopencv_to_safe(pyobj_P2, P2, ArgInfo("P2", 0)) )
    {
        ERRWRAP2(_self_->setP2(P2));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_StereoSGBM_setPreFilterCap(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::StereoSGBM> * self1 = 0;
    if (!pyopencv_StereoSGBM_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'StereoSGBM' or its derivative)");
    Ptr<cv::StereoSGBM> _self_ = *(self1);
    PyObject* pyobj_preFilterCap = NULL;
    int preFilterCap=0;

    const char* keywords[] = { "preFilterCap", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:StereoSGBM.setPreFilterCap", (char**)keywords, &pyobj_preFilterCap) &&
        pyopencv_to_safe(pyobj_preFilterCap, preFilterCap, ArgInfo("preFilterCap", 0)) )
    {
        ERRWRAP2(_self_->setPreFilterCap(preFilterCap));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_StereoSGBM_setUniquenessRatio(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::StereoSGBM> * self1 = 0;
    if (!pyopencv_StereoSGBM_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'StereoSGBM' or its derivative)");
    Ptr<cv::StereoSGBM> _self_ = *(self1);
    PyObject* pyobj_uniquenessRatio = NULL;
    int uniquenessRatio=0;

    const char* keywords[] = { "uniquenessRatio", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:StereoSGBM.setUniquenessRatio", (char**)keywords, &pyobj_uniquenessRatio) &&
        pyopencv_to_safe(pyobj_uniquenessRatio, uniquenessRatio, ArgInfo("uniquenessRatio", 0)) )
    {
        ERRWRAP2(_self_->setUniquenessRatio(uniquenessRatio));
        Py_RETURN_NONE;
    }

    return NULL;
}



// Tables (StereoSGBM)

static PyGetSetDef pyopencv_StereoSGBM_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_StereoSGBM_methods[] =
{
    {"create", CV_PY_FN_WITH_KW_(pyopencv_cv_StereoSGBM_create_static, METH_STATIC), "create([, minDisparity[, numDisparities[, blockSize[, P1[, P2[, disp12MaxDiff[, preFilterCap[, uniquenessRatio[, speckleWindowSize[, speckleRange[, mode]]]]]]]]]]]) -> retval\n.   @brief Creates StereoSGBM object\n.   \n.       @param minDisparity Minimum possible disparity value. Normally, it is zero but sometimes\n.       rectification algorithms can shift images, so this parameter needs to be adjusted accordingly.\n.       @param numDisparities Maximum disparity minus minimum disparity. The value is always greater than\n.       zero. In the current implementation, this parameter must be divisible by 16.\n.       @param blockSize Matched block size. It must be an odd number \\>=1 . Normally, it should be\n.       somewhere in the 3..11 range.\n.       @param P1 The first parameter controlling the disparity smoothness. See below.\n.       @param P2 The second parameter controlling the disparity smoothness. The larger the values are,\n.       the smoother the disparity is. P1 is the penalty on the disparity change by plus or minus 1\n.       between neighbor pixels. P2 is the penalty on the disparity change by more than 1 between neighbor\n.       pixels. The algorithm requires P2 \\> P1 . See stereo_match.cpp sample where some reasonably good\n.       P1 and P2 values are shown (like 8\\*number_of_image_channels\\*blockSize\\*blockSize and\n.       32\\*number_of_image_channels\\*blockSize\\*blockSize , respectively).\n.       @param disp12MaxDiff Maximum allowed difference (in integer pixel units) in the left-right\n.       disparity check. Set it to a non-positive value to disable the check.\n.       @param preFilterCap Truncation value for the prefiltered image pixels. The algorithm first\n.       computes x-derivative at each pixel and clips its value by [-preFilterCap, preFilterCap] interval.\n.       The result values are passed to the Birchfield-Tomasi pixel cost function.\n.       @param uniquenessRatio Margin in percentage by which the best (minimum) computed cost function\n.       value should \"win\" the second best value to consider the found match correct. Normally, a value\n.       within the 5-15 range is good enough.\n.       @param speckleWindowSize Maximum size of smooth disparity regions to consider their noise speckles\n.       and invalidate. Set it to 0 to disable speckle filtering. Otherwise, set it somewhere in the\n.       50-200 range.\n.       @param speckleRange Maximum disparity variation within each connected component. If you do speckle\n.       filtering, set the parameter to a positive value, it will be implicitly multiplied by 16.\n.       Normally, 1 or 2 is good enough.\n.       @param mode Set it to StereoSGBM::MODE_HH to run the full-scale two-pass dynamic programming\n.       algorithm. It will consume O(W\\*H\\*numDisparities) bytes, which is large for 640x480 stereo and\n.       huge for HD-size pictures. By default, it is set to false .\n.   \n.       The first constructor initializes StereoSGBM with all the default parameters. So, you only have to\n.       set StereoSGBM::numDisparities at minimum. The second constructor enables you to set each parameter\n.       to a custom value."},
    {"getMode", CV_PY_FN_WITH_KW_(pyopencv_cv_StereoSGBM_getMode, 0), "getMode() -> retval\n."},
    {"getP1", CV_PY_FN_WITH_KW_(pyopencv_cv_StereoSGBM_getP1, 0), "getP1() -> retval\n."},
    {"getP2", CV_PY_FN_WITH_KW_(pyopencv_cv_StereoSGBM_getP2, 0), "getP2() -> retval\n."},
    {"getPreFilterCap", CV_PY_FN_WITH_KW_(pyopencv_cv_StereoSGBM_getPreFilterCap, 0), "getPreFilterCap() -> retval\n."},
    {"getUniquenessRatio", CV_PY_FN_WITH_KW_(pyopencv_cv_StereoSGBM_getUniquenessRatio, 0), "getUniquenessRatio() -> retval\n."},
    {"setMode", CV_PY_FN_WITH_KW_(pyopencv_cv_StereoSGBM_setMode, 0), "setMode(mode) -> None\n."},
    {"setP1", CV_PY_FN_WITH_KW_(pyopencv_cv_StereoSGBM_setP1, 0), "setP1(P1) -> None\n."},
    {"setP2", CV_PY_FN_WITH_KW_(pyopencv_cv_StereoSGBM_setP2, 0), "setP2(P2) -> None\n."},
    {"setPreFilterCap", CV_PY_FN_WITH_KW_(pyopencv_cv_StereoSGBM_setPreFilterCap, 0), "setPreFilterCap(preFilterCap) -> None\n."},
    {"setUniquenessRatio", CV_PY_FN_WITH_KW_(pyopencv_cv_StereoSGBM_setUniquenessRatio, 0), "setUniquenessRatio(uniquenessRatio) -> None\n."},

    {NULL,          NULL}
};

// Converter (StereoSGBM)

template<>
struct PyOpenCV_Converter< Ptr<cv::StereoSGBM> >
{
    static PyObject* from(const Ptr<cv::StereoSGBM>& r)
    {
        return pyopencv_StereoSGBM_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::StereoSGBM>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::StereoSGBM> * dst_;
        if (pyopencv_StereoSGBM_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::StereoSGBM> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// Stitcher (Generic)
//================================================================================

// GetSet (Stitcher)



// Methods (Stitcher)

static PyObject* pyopencv_cv_Stitcher_composePanorama(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Stitcher> * self1 = 0;
    if (!pyopencv_Stitcher_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Stitcher' or its derivative)");
    Ptr<cv::Stitcher> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(4);

    {
    PyObject* pyobj_pano = NULL;
    Mat pano;
    Status retval;

    const char* keywords[] = { "pano", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "|O:Stitcher.composePanorama", (char**)keywords, &pyobj_pano) &&
        pyopencv_to_safe(pyobj_pano, pano, ArgInfo("pano", 1)) )
    {
        ERRWRAP2(retval = _self_->composePanorama(pano));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(pano));
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_pano = NULL;
    UMat pano;
    Status retval;

    const char* keywords[] = { "pano", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "|O:Stitcher.composePanorama", (char**)keywords, &pyobj_pano) &&
        pyopencv_to_safe(pyobj_pano, pano, ArgInfo("pano", 1)) )
    {
        ERRWRAP2(retval = _self_->composePanorama(pano));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(pano));
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_images = NULL;
    vector_Mat images;
    PyObject* pyobj_pano = NULL;
    Mat pano;
    Status retval;

    const char* keywords[] = { "images", "pano", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|O:Stitcher.composePanorama", (char**)keywords, &pyobj_images, &pyobj_pano) &&
        pyopencv_to_safe(pyobj_images, images, ArgInfo("images", 0)) &&
        pyopencv_to_safe(pyobj_pano, pano, ArgInfo("pano", 1)) )
    {
        ERRWRAP2(retval = _self_->composePanorama(images, pano));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(pano));
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_images = NULL;
    vector_UMat images;
    PyObject* pyobj_pano = NULL;
    UMat pano;
    Status retval;

    const char* keywords[] = { "images", "pano", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|O:Stitcher.composePanorama", (char**)keywords, &pyobj_images, &pyobj_pano) &&
        pyopencv_to_safe(pyobj_images, images, ArgInfo("images", 0)) &&
        pyopencv_to_safe(pyobj_pano, pano, ArgInfo("pano", 1)) )
    {
        ERRWRAP2(retval = _self_->composePanorama(images, pano));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(pano));
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("composePanorama");

    return NULL;
}

static PyObject* pyopencv_cv_Stitcher_compositingResol(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Stitcher> * self1 = 0;
    if (!pyopencv_Stitcher_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Stitcher' or its derivative)");
    Ptr<cv::Stitcher> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->compositingResol());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_Stitcher_create_static(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    PyObject* pyobj_mode = NULL;
    Mode mode=Stitcher::PANORAMA;
    Ptr<Stitcher> retval;

    const char* keywords[] = { "mode", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "|O:Stitcher.create", (char**)keywords, &pyobj_mode) &&
        pyopencv_to_safe(pyobj_mode, mode, ArgInfo("mode", 0)) )
    {
        ERRWRAP2(retval = cv::Stitcher::create(mode));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_Stitcher_estimateTransform(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Stitcher> * self1 = 0;
    if (!pyopencv_Stitcher_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Stitcher' or its derivative)");
    Ptr<cv::Stitcher> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_images = NULL;
    vector_Mat images;
    PyObject* pyobj_masks = NULL;
    vector_Mat masks;
    Status retval;

    const char* keywords[] = { "images", "masks", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|O:Stitcher.estimateTransform", (char**)keywords, &pyobj_images, &pyobj_masks) &&
        pyopencv_to_safe(pyobj_images, images, ArgInfo("images", 0)) &&
        pyopencv_to_safe(pyobj_masks, masks, ArgInfo("masks", 0)) )
    {
        ERRWRAP2(retval = _self_->estimateTransform(images, masks));
        return pyopencv_from(retval);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_images = NULL;
    vector_UMat images;
    PyObject* pyobj_masks = NULL;
    vector_UMat masks;
    Status retval;

    const char* keywords[] = { "images", "masks", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|O:Stitcher.estimateTransform", (char**)keywords, &pyobj_images, &pyobj_masks) &&
        pyopencv_to_safe(pyobj_images, images, ArgInfo("images", 0)) &&
        pyopencv_to_safe(pyobj_masks, masks, ArgInfo("masks", 0)) )
    {
        ERRWRAP2(retval = _self_->estimateTransform(images, masks));
        return pyopencv_from(retval);
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("estimateTransform");

    return NULL;
}

static PyObject* pyopencv_cv_Stitcher_interpolationFlags(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Stitcher> * self1 = 0;
    if (!pyopencv_Stitcher_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Stitcher' or its derivative)");
    Ptr<cv::Stitcher> _self_ = *(self1);
    InterpolationFlags retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->interpolationFlags());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_Stitcher_panoConfidenceThresh(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Stitcher> * self1 = 0;
    if (!pyopencv_Stitcher_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Stitcher' or its derivative)");
    Ptr<cv::Stitcher> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->panoConfidenceThresh());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_Stitcher_registrationResol(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Stitcher> * self1 = 0;
    if (!pyopencv_Stitcher_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Stitcher' or its derivative)");
    Ptr<cv::Stitcher> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->registrationResol());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_Stitcher_seamEstimationResol(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Stitcher> * self1 = 0;
    if (!pyopencv_Stitcher_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Stitcher' or its derivative)");
    Ptr<cv::Stitcher> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->seamEstimationResol());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_Stitcher_setCompositingResol(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Stitcher> * self1 = 0;
    if (!pyopencv_Stitcher_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Stitcher' or its derivative)");
    Ptr<cv::Stitcher> _self_ = *(self1);
    PyObject* pyobj_resol_mpx = NULL;
    double resol_mpx=0;

    const char* keywords[] = { "resol_mpx", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:Stitcher.setCompositingResol", (char**)keywords, &pyobj_resol_mpx) &&
        pyopencv_to_safe(pyobj_resol_mpx, resol_mpx, ArgInfo("resol_mpx", 0)) )
    {
        ERRWRAP2(_self_->setCompositingResol(resol_mpx));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_Stitcher_setInterpolationFlags(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Stitcher> * self1 = 0;
    if (!pyopencv_Stitcher_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Stitcher' or its derivative)");
    Ptr<cv::Stitcher> _self_ = *(self1);
    PyObject* pyobj_interp_flags = NULL;
    InterpolationFlags interp_flags=static_cast<InterpolationFlags>(0);

    const char* keywords[] = { "interp_flags", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:Stitcher.setInterpolationFlags", (char**)keywords, &pyobj_interp_flags) &&
        pyopencv_to_safe(pyobj_interp_flags, interp_flags, ArgInfo("interp_flags", 0)) )
    {
        ERRWRAP2(_self_->setInterpolationFlags(interp_flags));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_Stitcher_setPanoConfidenceThresh(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Stitcher> * self1 = 0;
    if (!pyopencv_Stitcher_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Stitcher' or its derivative)");
    Ptr<cv::Stitcher> _self_ = *(self1);
    PyObject* pyobj_conf_thresh = NULL;
    double conf_thresh=0;

    const char* keywords[] = { "conf_thresh", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:Stitcher.setPanoConfidenceThresh", (char**)keywords, &pyobj_conf_thresh) &&
        pyopencv_to_safe(pyobj_conf_thresh, conf_thresh, ArgInfo("conf_thresh", 0)) )
    {
        ERRWRAP2(_self_->setPanoConfidenceThresh(conf_thresh));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_Stitcher_setRegistrationResol(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Stitcher> * self1 = 0;
    if (!pyopencv_Stitcher_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Stitcher' or its derivative)");
    Ptr<cv::Stitcher> _self_ = *(self1);
    PyObject* pyobj_resol_mpx = NULL;
    double resol_mpx=0;

    const char* keywords[] = { "resol_mpx", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:Stitcher.setRegistrationResol", (char**)keywords, &pyobj_resol_mpx) &&
        pyopencv_to_safe(pyobj_resol_mpx, resol_mpx, ArgInfo("resol_mpx", 0)) )
    {
        ERRWRAP2(_self_->setRegistrationResol(resol_mpx));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_Stitcher_setSeamEstimationResol(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Stitcher> * self1 = 0;
    if (!pyopencv_Stitcher_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Stitcher' or its derivative)");
    Ptr<cv::Stitcher> _self_ = *(self1);
    PyObject* pyobj_resol_mpx = NULL;
    double resol_mpx=0;

    const char* keywords[] = { "resol_mpx", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:Stitcher.setSeamEstimationResol", (char**)keywords, &pyobj_resol_mpx) &&
        pyopencv_to_safe(pyobj_resol_mpx, resol_mpx, ArgInfo("resol_mpx", 0)) )
    {
        ERRWRAP2(_self_->setSeamEstimationResol(resol_mpx));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_Stitcher_setWaveCorrection(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Stitcher> * self1 = 0;
    if (!pyopencv_Stitcher_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Stitcher' or its derivative)");
    Ptr<cv::Stitcher> _self_ = *(self1);
    PyObject* pyobj_flag = NULL;
    bool flag=0;

    const char* keywords[] = { "flag", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:Stitcher.setWaveCorrection", (char**)keywords, &pyobj_flag) &&
        pyopencv_to_safe(pyobj_flag, flag, ArgInfo("flag", 0)) )
    {
        ERRWRAP2(_self_->setWaveCorrection(flag));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_Stitcher_stitch(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Stitcher> * self1 = 0;
    if (!pyopencv_Stitcher_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Stitcher' or its derivative)");
    Ptr<cv::Stitcher> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(4);

    {
    PyObject* pyobj_images = NULL;
    vector_Mat images;
    PyObject* pyobj_pano = NULL;
    Mat pano;
    Status retval;

    const char* keywords[] = { "images", "pano", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|O:Stitcher.stitch", (char**)keywords, &pyobj_images, &pyobj_pano) &&
        pyopencv_to_safe(pyobj_images, images, ArgInfo("images", 0)) &&
        pyopencv_to_safe(pyobj_pano, pano, ArgInfo("pano", 1)) )
    {
        ERRWRAP2(retval = _self_->stitch(images, pano));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(pano));
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_images = NULL;
    vector_UMat images;
    PyObject* pyobj_pano = NULL;
    UMat pano;
    Status retval;

    const char* keywords[] = { "images", "pano", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|O:Stitcher.stitch", (char**)keywords, &pyobj_images, &pyobj_pano) &&
        pyopencv_to_safe(pyobj_images, images, ArgInfo("images", 0)) &&
        pyopencv_to_safe(pyobj_pano, pano, ArgInfo("pano", 1)) )
    {
        ERRWRAP2(retval = _self_->stitch(images, pano));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(pano));
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_images = NULL;
    vector_Mat images;
    PyObject* pyobj_masks = NULL;
    vector_Mat masks;
    PyObject* pyobj_pano = NULL;
    Mat pano;
    Status retval;

    const char* keywords[] = { "images", "masks", "pano", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO|O:Stitcher.stitch", (char**)keywords, &pyobj_images, &pyobj_masks, &pyobj_pano) &&
        pyopencv_to_safe(pyobj_images, images, ArgInfo("images", 0)) &&
        pyopencv_to_safe(pyobj_masks, masks, ArgInfo("masks", 0)) &&
        pyopencv_to_safe(pyobj_pano, pano, ArgInfo("pano", 1)) )
    {
        ERRWRAP2(retval = _self_->stitch(images, masks, pano));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(pano));
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_images = NULL;
    vector_UMat images;
    PyObject* pyobj_masks = NULL;
    vector_UMat masks;
    PyObject* pyobj_pano = NULL;
    UMat pano;
    Status retval;

    const char* keywords[] = { "images", "masks", "pano", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO|O:Stitcher.stitch", (char**)keywords, &pyobj_images, &pyobj_masks, &pyobj_pano) &&
        pyopencv_to_safe(pyobj_images, images, ArgInfo("images", 0)) &&
        pyopencv_to_safe(pyobj_masks, masks, ArgInfo("masks", 0)) &&
        pyopencv_to_safe(pyobj_pano, pano, ArgInfo("pano", 1)) )
    {
        ERRWRAP2(retval = _self_->stitch(images, masks, pano));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(pano));
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("stitch");

    return NULL;
}

static PyObject* pyopencv_cv_Stitcher_waveCorrection(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Stitcher> * self1 = 0;
    if (!pyopencv_Stitcher_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Stitcher' or its derivative)");
    Ptr<cv::Stitcher> _self_ = *(self1);
    bool retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->waveCorrection());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_Stitcher_workScale(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Stitcher> * self1 = 0;
    if (!pyopencv_Stitcher_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Stitcher' or its derivative)");
    Ptr<cv::Stitcher> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->workScale());
        return pyopencv_from(retval);
    }

    return NULL;
}



// Tables (Stitcher)

static PyGetSetDef pyopencv_Stitcher_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_Stitcher_methods[] =
{
    {"composePanorama", CV_PY_FN_WITH_KW_(pyopencv_cv_Stitcher_composePanorama, 0), "composePanorama([, pano]) -> retval, pano\n.   @overload\n\n\n\ncomposePanorama(images[, pano]) -> retval, pano\n.   @brief These functions try to compose the given images (or images stored internally from the other function\n.       calls) into the final pano under the assumption that the image transformations were estimated\n.       before.\n.   \n.       @note Use the functions only if you're aware of the stitching pipeline, otherwise use\n.       Stitcher::stitch.\n.   \n.       @param images Input images.\n.       @param pano Final pano.\n.       @return Status code."},
    {"compositingResol", CV_PY_FN_WITH_KW_(pyopencv_cv_Stitcher_compositingResol, 0), "compositingResol() -> retval\n."},
    {"create", CV_PY_FN_WITH_KW_(pyopencv_cv_Stitcher_create_static, METH_STATIC), "create([, mode]) -> retval\n.   @brief Creates a Stitcher configured in one of the stitching modes.\n.   \n.       @param mode Scenario for stitcher operation. This is usually determined by source of images\n.       to stitch and their transformation. Default parameters will be chosen for operation in given\n.       scenario.\n.       @return Stitcher class instance."},
    {"estimateTransform", CV_PY_FN_WITH_KW_(pyopencv_cv_Stitcher_estimateTransform, 0), "estimateTransform(images[, masks]) -> retval\n.   @brief These functions try to match the given images and to estimate rotations of each camera.\n.   \n.       @note Use the functions only if you're aware of the stitching pipeline, otherwise use\n.       Stitcher::stitch.\n.   \n.       @param images Input images.\n.       @param masks Masks for each input image specifying where to look for keypoints (optional).\n.       @return Status code."},
    {"interpolationFlags", CV_PY_FN_WITH_KW_(pyopencv_cv_Stitcher_interpolationFlags, 0), "interpolationFlags() -> retval\n."},
    {"panoConfidenceThresh", CV_PY_FN_WITH_KW_(pyopencv_cv_Stitcher_panoConfidenceThresh, 0), "panoConfidenceThresh() -> retval\n."},
    {"registrationResol", CV_PY_FN_WITH_KW_(pyopencv_cv_Stitcher_registrationResol, 0), "registrationResol() -> retval\n."},
    {"seamEstimationResol", CV_PY_FN_WITH_KW_(pyopencv_cv_Stitcher_seamEstimationResol, 0), "seamEstimationResol() -> retval\n."},
    {"setCompositingResol", CV_PY_FN_WITH_KW_(pyopencv_cv_Stitcher_setCompositingResol, 0), "setCompositingResol(resol_mpx) -> None\n."},
    {"setInterpolationFlags", CV_PY_FN_WITH_KW_(pyopencv_cv_Stitcher_setInterpolationFlags, 0), "setInterpolationFlags(interp_flags) -> None\n."},
    {"setPanoConfidenceThresh", CV_PY_FN_WITH_KW_(pyopencv_cv_Stitcher_setPanoConfidenceThresh, 0), "setPanoConfidenceThresh(conf_thresh) -> None\n."},
    {"setRegistrationResol", CV_PY_FN_WITH_KW_(pyopencv_cv_Stitcher_setRegistrationResol, 0), "setRegistrationResol(resol_mpx) -> None\n."},
    {"setSeamEstimationResol", CV_PY_FN_WITH_KW_(pyopencv_cv_Stitcher_setSeamEstimationResol, 0), "setSeamEstimationResol(resol_mpx) -> None\n."},
    {"setWaveCorrection", CV_PY_FN_WITH_KW_(pyopencv_cv_Stitcher_setWaveCorrection, 0), "setWaveCorrection(flag) -> None\n."},
    {"stitch", CV_PY_FN_WITH_KW_(pyopencv_cv_Stitcher_stitch, 0), "stitch(images[, pano]) -> retval, pano\n.   @overload\n\n\n\nstitch(images, masks[, pano]) -> retval, pano\n.   @brief These functions try to stitch the given images.\n.   \n.       @param images Input images.\n.       @param masks Masks for each input image specifying where to look for keypoints (optional).\n.       @param pano Final pano.\n.       @return Status code."},
    {"waveCorrection", CV_PY_FN_WITH_KW_(pyopencv_cv_Stitcher_waveCorrection, 0), "waveCorrection() -> retval\n."},
    {"workScale", CV_PY_FN_WITH_KW_(pyopencv_cv_Stitcher_workScale, 0), "workScale() -> retval\n."},

    {NULL,          NULL}
};

// Converter (Stitcher)

template<>
struct PyOpenCV_Converter< Ptr<cv::Stitcher> >
{
    static PyObject* from(const Ptr<cv::Stitcher>& r)
    {
        return pyopencv_Stitcher_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::Stitcher>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::Stitcher> * dst_;
        if (pyopencv_Stitcher_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::Stitcher> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// Subdiv2D (Generic)
//================================================================================

// GetSet (Subdiv2D)



// Methods (Subdiv2D)

static int pyopencv_cv_Subdiv2D_Subdiv2D(pyopencv_Subdiv2D_t* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    pyPrepareArgumentConversionErrorsStorage(2);

    {

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        new (&(self->v)) Ptr<cv::Subdiv2D>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::Subdiv2D()));
        return 0;
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_rect = NULL;
    Rect rect;

    const char* keywords[] = { "rect", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:Subdiv2D", (char**)keywords, &pyobj_rect) &&
        pyopencv_to_safe(pyobj_rect, rect, ArgInfo("rect", 0)) )
    {
        new (&(self->v)) Ptr<cv::Subdiv2D>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::Subdiv2D(rect)));
        return 0;
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("Subdiv2D");

    return -1;
}

static PyObject* pyopencv_cv_Subdiv2D_edgeDst(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Subdiv2D> * self1 = 0;
    if (!pyopencv_Subdiv2D_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Subdiv2D' or its derivative)");
    Ptr<cv::Subdiv2D> _self_ = *(self1);
    PyObject* pyobj_edge = NULL;
    int edge=0;
    Point2f dstpt;
    int retval;

    const char* keywords[] = { "edge", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:Subdiv2D.edgeDst", (char**)keywords, &pyobj_edge) &&
        pyopencv_to_safe(pyobj_edge, edge, ArgInfo("edge", 0)) )
    {
        ERRWRAP2(retval = _self_->edgeDst(edge, &dstpt));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(dstpt));
    }

    return NULL;
}

static PyObject* pyopencv_cv_Subdiv2D_edgeOrg(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Subdiv2D> * self1 = 0;
    if (!pyopencv_Subdiv2D_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Subdiv2D' or its derivative)");
    Ptr<cv::Subdiv2D> _self_ = *(self1);
    PyObject* pyobj_edge = NULL;
    int edge=0;
    Point2f orgpt;
    int retval;

    const char* keywords[] = { "edge", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:Subdiv2D.edgeOrg", (char**)keywords, &pyobj_edge) &&
        pyopencv_to_safe(pyobj_edge, edge, ArgInfo("edge", 0)) )
    {
        ERRWRAP2(retval = _self_->edgeOrg(edge, &orgpt));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(orgpt));
    }

    return NULL;
}

static PyObject* pyopencv_cv_Subdiv2D_findNearest(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Subdiv2D> * self1 = 0;
    if (!pyopencv_Subdiv2D_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Subdiv2D' or its derivative)");
    Ptr<cv::Subdiv2D> _self_ = *(self1);
    PyObject* pyobj_pt = NULL;
    Point2f pt;
    Point2f nearestPt;
    int retval;

    const char* keywords[] = { "pt", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:Subdiv2D.findNearest", (char**)keywords, &pyobj_pt) &&
        pyopencv_to_safe(pyobj_pt, pt, ArgInfo("pt", 0)) )
    {
        ERRWRAP2(retval = _self_->findNearest(pt, &nearestPt));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(nearestPt));
    }

    return NULL;
}

static PyObject* pyopencv_cv_Subdiv2D_getEdge(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Subdiv2D> * self1 = 0;
    if (!pyopencv_Subdiv2D_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Subdiv2D' or its derivative)");
    Ptr<cv::Subdiv2D> _self_ = *(self1);
    PyObject* pyobj_edge = NULL;
    int edge=0;
    PyObject* pyobj_nextEdgeType = NULL;
    int nextEdgeType=0;
    int retval;

    const char* keywords[] = { "edge", "nextEdgeType", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO:Subdiv2D.getEdge", (char**)keywords, &pyobj_edge, &pyobj_nextEdgeType) &&
        pyopencv_to_safe(pyobj_edge, edge, ArgInfo("edge", 0)) &&
        pyopencv_to_safe(pyobj_nextEdgeType, nextEdgeType, ArgInfo("nextEdgeType", 0)) )
    {
        ERRWRAP2(retval = _self_->getEdge(edge, nextEdgeType));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_Subdiv2D_getEdgeList(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Subdiv2D> * self1 = 0;
    if (!pyopencv_Subdiv2D_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Subdiv2D' or its derivative)");
    Ptr<cv::Subdiv2D> _self_ = *(self1);
    vector_Vec4f edgeList;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(_self_->getEdgeList(edgeList));
        return pyopencv_from(edgeList);
    }

    return NULL;
}

static PyObject* pyopencv_cv_Subdiv2D_getLeadingEdgeList(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Subdiv2D> * self1 = 0;
    if (!pyopencv_Subdiv2D_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Subdiv2D' or its derivative)");
    Ptr<cv::Subdiv2D> _self_ = *(self1);
    vector_int leadingEdgeList;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(_self_->getLeadingEdgeList(leadingEdgeList));
        return pyopencv_from(leadingEdgeList);
    }

    return NULL;
}

static PyObject* pyopencv_cv_Subdiv2D_getTriangleList(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Subdiv2D> * self1 = 0;
    if (!pyopencv_Subdiv2D_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Subdiv2D' or its derivative)");
    Ptr<cv::Subdiv2D> _self_ = *(self1);
    vector_Vec6f triangleList;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(_self_->getTriangleList(triangleList));
        return pyopencv_from(triangleList);
    }

    return NULL;
}

static PyObject* pyopencv_cv_Subdiv2D_getVertex(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Subdiv2D> * self1 = 0;
    if (!pyopencv_Subdiv2D_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Subdiv2D' or its derivative)");
    Ptr<cv::Subdiv2D> _self_ = *(self1);
    PyObject* pyobj_vertex = NULL;
    int vertex=0;
    int firstEdge;
    Point2f retval;

    const char* keywords[] = { "vertex", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:Subdiv2D.getVertex", (char**)keywords, &pyobj_vertex) &&
        pyopencv_to_safe(pyobj_vertex, vertex, ArgInfo("vertex", 0)) )
    {
        ERRWRAP2(retval = _self_->getVertex(vertex, &firstEdge));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(firstEdge));
    }

    return NULL;
}

static PyObject* pyopencv_cv_Subdiv2D_getVoronoiFacetList(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Subdiv2D> * self1 = 0;
    if (!pyopencv_Subdiv2D_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Subdiv2D' or its derivative)");
    Ptr<cv::Subdiv2D> _self_ = *(self1);
    PyObject* pyobj_idx = NULL;
    vector_int idx;
    vector_vector_Point2f facetList;
    vector_Point2f facetCenters;

    const char* keywords[] = { "idx", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:Subdiv2D.getVoronoiFacetList", (char**)keywords, &pyobj_idx) &&
        pyopencv_to_safe(pyobj_idx, idx, ArgInfo("idx", 0)) )
    {
        ERRWRAP2(_self_->getVoronoiFacetList(idx, facetList, facetCenters));
        return Py_BuildValue("(NN)", pyopencv_from(facetList), pyopencv_from(facetCenters));
    }

    return NULL;
}

static PyObject* pyopencv_cv_Subdiv2D_initDelaunay(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Subdiv2D> * self1 = 0;
    if (!pyopencv_Subdiv2D_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Subdiv2D' or its derivative)");
    Ptr<cv::Subdiv2D> _self_ = *(self1);
    PyObject* pyobj_rect = NULL;
    Rect rect;

    const char* keywords[] = { "rect", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:Subdiv2D.initDelaunay", (char**)keywords, &pyobj_rect) &&
        pyopencv_to_safe(pyobj_rect, rect, ArgInfo("rect", 0)) )
    {
        ERRWRAP2(_self_->initDelaunay(rect));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_Subdiv2D_insert(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Subdiv2D> * self1 = 0;
    if (!pyopencv_Subdiv2D_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Subdiv2D' or its derivative)");
    Ptr<cv::Subdiv2D> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_pt = NULL;
    Point2f pt;
    int retval;

    const char* keywords[] = { "pt", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:Subdiv2D.insert", (char**)keywords, &pyobj_pt) &&
        pyopencv_to_safe(pyobj_pt, pt, ArgInfo("pt", 0)) )
    {
        ERRWRAP2(retval = _self_->insert(pt));
        return pyopencv_from(retval);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_ptvec = NULL;
    vector_Point2f ptvec;

    const char* keywords[] = { "ptvec", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:Subdiv2D.insert", (char**)keywords, &pyobj_ptvec) &&
        pyopencv_to_safe(pyobj_ptvec, ptvec, ArgInfo("ptvec", 0)) )
    {
        ERRWRAP2(_self_->insert(ptvec));
        Py_RETURN_NONE;
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("insert");

    return NULL;
}

static PyObject* pyopencv_cv_Subdiv2D_locate(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Subdiv2D> * self1 = 0;
    if (!pyopencv_Subdiv2D_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Subdiv2D' or its derivative)");
    Ptr<cv::Subdiv2D> _self_ = *(self1);
    PyObject* pyobj_pt = NULL;
    Point2f pt;
    int edge;
    int vertex;
    int retval;

    const char* keywords[] = { "pt", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:Subdiv2D.locate", (char**)keywords, &pyobj_pt) &&
        pyopencv_to_safe(pyobj_pt, pt, ArgInfo("pt", 0)) )
    {
        ERRWRAP2(retval = _self_->locate(pt, edge, vertex));
        return Py_BuildValue("(NNN)", pyopencv_from(retval), pyopencv_from(edge), pyopencv_from(vertex));
    }

    return NULL;
}

static PyObject* pyopencv_cv_Subdiv2D_nextEdge(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Subdiv2D> * self1 = 0;
    if (!pyopencv_Subdiv2D_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Subdiv2D' or its derivative)");
    Ptr<cv::Subdiv2D> _self_ = *(self1);
    PyObject* pyobj_edge = NULL;
    int edge=0;
    int retval;

    const char* keywords[] = { "edge", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:Subdiv2D.nextEdge", (char**)keywords, &pyobj_edge) &&
        pyopencv_to_safe(pyobj_edge, edge, ArgInfo("edge", 0)) )
    {
        ERRWRAP2(retval = _self_->nextEdge(edge));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_Subdiv2D_rotateEdge(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Subdiv2D> * self1 = 0;
    if (!pyopencv_Subdiv2D_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Subdiv2D' or its derivative)");
    Ptr<cv::Subdiv2D> _self_ = *(self1);
    PyObject* pyobj_edge = NULL;
    int edge=0;
    PyObject* pyobj_rotate = NULL;
    int rotate=0;
    int retval;

    const char* keywords[] = { "edge", "rotate", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO:Subdiv2D.rotateEdge", (char**)keywords, &pyobj_edge, &pyobj_rotate) &&
        pyopencv_to_safe(pyobj_edge, edge, ArgInfo("edge", 0)) &&
        pyopencv_to_safe(pyobj_rotate, rotate, ArgInfo("rotate", 0)) )
    {
        ERRWRAP2(retval = _self_->rotateEdge(edge, rotate));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_Subdiv2D_symEdge(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Subdiv2D> * self1 = 0;
    if (!pyopencv_Subdiv2D_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Subdiv2D' or its derivative)");
    Ptr<cv::Subdiv2D> _self_ = *(self1);
    PyObject* pyobj_edge = NULL;
    int edge=0;
    int retval;

    const char* keywords[] = { "edge", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:Subdiv2D.symEdge", (char**)keywords, &pyobj_edge) &&
        pyopencv_to_safe(pyobj_edge, edge, ArgInfo("edge", 0)) )
    {
        ERRWRAP2(retval = _self_->symEdge(edge));
        return pyopencv_from(retval);
    }

    return NULL;
}



// Tables (Subdiv2D)

static PyGetSetDef pyopencv_Subdiv2D_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_Subdiv2D_methods[] =
{
    {"edgeDst", CV_PY_FN_WITH_KW_(pyopencv_cv_Subdiv2D_edgeDst, 0), "edgeDst(edge) -> retval, dstpt\n.   @brief Returns the edge destination.\n.   \n.       @param edge Subdivision edge ID.\n.       @param dstpt Output vertex location.\n.   \n.       @returns vertex ID."},
    {"edgeOrg", CV_PY_FN_WITH_KW_(pyopencv_cv_Subdiv2D_edgeOrg, 0), "edgeOrg(edge) -> retval, orgpt\n.   @brief Returns the edge origin.\n.   \n.       @param edge Subdivision edge ID.\n.       @param orgpt Output vertex location.\n.   \n.       @returns vertex ID."},
    {"findNearest", CV_PY_FN_WITH_KW_(pyopencv_cv_Subdiv2D_findNearest, 0), "findNearest(pt) -> retval, nearestPt\n.   @brief Finds the subdivision vertex closest to the given point.\n.   \n.       @param pt Input point.\n.       @param nearestPt Output subdivision vertex point.\n.   \n.       The function is another function that locates the input point within the subdivision. It finds the\n.       subdivision vertex that is the closest to the input point. It is not necessarily one of vertices\n.       of the facet containing the input point, though the facet (located using locate() ) is used as a\n.       starting point.\n.   \n.       @returns vertex ID."},
    {"getEdge", CV_PY_FN_WITH_KW_(pyopencv_cv_Subdiv2D_getEdge, 0), "getEdge(edge, nextEdgeType) -> retval\n.   @brief Returns one of the edges related to the given edge.\n.   \n.       @param edge Subdivision edge ID.\n.       @param nextEdgeType Parameter specifying which of the related edges to return.\n.       The following values are possible:\n.       -   NEXT_AROUND_ORG next around the edge origin ( eOnext on the picture below if e is the input edge)\n.       -   NEXT_AROUND_DST next around the edge vertex ( eDnext )\n.       -   PREV_AROUND_ORG previous around the edge origin (reversed eRnext )\n.       -   PREV_AROUND_DST previous around the edge destination (reversed eLnext )\n.       -   NEXT_AROUND_LEFT next around the left facet ( eLnext )\n.       -   NEXT_AROUND_RIGHT next around the right facet ( eRnext )\n.       -   PREV_AROUND_LEFT previous around the left facet (reversed eOnext )\n.       -   PREV_AROUND_RIGHT previous around the right facet (reversed eDnext )\n.   \n.       ![sample output](pics/quadedge.png)\n.   \n.       @returns edge ID related to the input edge."},
    {"getEdgeList", CV_PY_FN_WITH_KW_(pyopencv_cv_Subdiv2D_getEdgeList, 0), "getEdgeList() -> edgeList\n.   @brief Returns a list of all edges.\n.   \n.       @param edgeList Output vector.\n.   \n.       The function gives each edge as a 4 numbers vector, where each two are one of the edge\n.       vertices. i.e. org_x = v[0], org_y = v[1], dst_x = v[2], dst_y = v[3]."},
    {"getLeadingEdgeList", CV_PY_FN_WITH_KW_(pyopencv_cv_Subdiv2D_getLeadingEdgeList, 0), "getLeadingEdgeList() -> leadingEdgeList\n.   @brief Returns a list of the leading edge ID connected to each triangle.\n.   \n.       @param leadingEdgeList Output vector.\n.   \n.       The function gives one edge ID for each triangle."},
    {"getTriangleList", CV_PY_FN_WITH_KW_(pyopencv_cv_Subdiv2D_getTriangleList, 0), "getTriangleList() -> triangleList\n.   @brief Returns a list of all triangles.\n.   \n.       @param triangleList Output vector.\n.   \n.       The function gives each triangle as a 6 numbers vector, where each two are one of the triangle\n.       vertices. i.e. p1_x = v[0], p1_y = v[1], p2_x = v[2], p2_y = v[3], p3_x = v[4], p3_y = v[5]."},
    {"getVertex", CV_PY_FN_WITH_KW_(pyopencv_cv_Subdiv2D_getVertex, 0), "getVertex(vertex) -> retval, firstEdge\n.   @brief Returns vertex location from vertex ID.\n.   \n.       @param vertex vertex ID.\n.       @param firstEdge Optional. The first edge ID which is connected to the vertex.\n.       @returns vertex (x,y)"},
    {"getVoronoiFacetList", CV_PY_FN_WITH_KW_(pyopencv_cv_Subdiv2D_getVoronoiFacetList, 0), "getVoronoiFacetList(idx) -> facetList, facetCenters\n.   @brief Returns a list of all Voronoi facets.\n.   \n.       @param idx Vector of vertices IDs to consider. For all vertices you can pass empty vector.\n.       @param facetList Output vector of the Voronoi facets.\n.       @param facetCenters Output vector of the Voronoi facets center points."},
    {"initDelaunay", CV_PY_FN_WITH_KW_(pyopencv_cv_Subdiv2D_initDelaunay, 0), "initDelaunay(rect) -> None\n.   @brief Creates a new empty Delaunay subdivision\n.   \n.       @param rect Rectangle that includes all of the 2D points that are to be added to the subdivision."},
    {"insert", CV_PY_FN_WITH_KW_(pyopencv_cv_Subdiv2D_insert, 0), "insert(pt) -> retval\n.   @brief Insert a single point into a Delaunay triangulation.\n.   \n.       @param pt Point to insert.\n.   \n.       The function inserts a single point into a subdivision and modifies the subdivision topology\n.       appropriately. If a point with the same coordinates exists already, no new point is added.\n.       @returns the ID of the point.\n.   \n.       @note If the point is outside of the triangulation specified rect a runtime error is raised.\n\n\n\ninsert(ptvec) -> None\n.   @brief Insert multiple points into a Delaunay triangulation.\n.   \n.       @param ptvec Points to insert.\n.   \n.       The function inserts a vector of points into a subdivision and modifies the subdivision topology\n.       appropriately."},
    {"locate", CV_PY_FN_WITH_KW_(pyopencv_cv_Subdiv2D_locate, 0), "locate(pt) -> retval, edge, vertex\n.   @brief Returns the location of a point within a Delaunay triangulation.\n.   \n.       @param pt Point to locate.\n.       @param edge Output edge that the point belongs to or is located to the right of it.\n.       @param vertex Optional output vertex the input point coincides with.\n.   \n.       The function locates the input point within the subdivision and gives one of the triangle edges\n.       or vertices.\n.   \n.       @returns an integer which specify one of the following five cases for point location:\n.       -  The point falls into some facet. The function returns #PTLOC_INSIDE and edge will contain one of\n.          edges of the facet.\n.       -  The point falls onto the edge. The function returns #PTLOC_ON_EDGE and edge will contain this edge.\n.       -  The point coincides with one of the subdivision vertices. The function returns #PTLOC_VERTEX and\n.          vertex will contain a pointer to the vertex.\n.       -  The point is outside the subdivision reference rectangle. The function returns #PTLOC_OUTSIDE_RECT\n.          and no pointers are filled.\n.       -  One of input arguments is invalid. A runtime error is raised or, if silent or \"parent\" error\n.          processing mode is selected, #PTLOC_ERROR is returned."},
    {"nextEdge", CV_PY_FN_WITH_KW_(pyopencv_cv_Subdiv2D_nextEdge, 0), "nextEdge(edge) -> retval\n.   @brief Returns next edge around the edge origin.\n.   \n.       @param edge Subdivision edge ID.\n.   \n.       @returns an integer which is next edge ID around the edge origin: eOnext on the\n.       picture above if e is the input edge)."},
    {"rotateEdge", CV_PY_FN_WITH_KW_(pyopencv_cv_Subdiv2D_rotateEdge, 0), "rotateEdge(edge, rotate) -> retval\n.   @brief Returns another edge of the same quad-edge.\n.   \n.       @param edge Subdivision edge ID.\n.       @param rotate Parameter specifying which of the edges of the same quad-edge as the input\n.       one to return. The following values are possible:\n.       -   0 - the input edge ( e on the picture below if e is the input edge)\n.       -   1 - the rotated edge ( eRot )\n.       -   2 - the reversed edge (reversed e (in green))\n.       -   3 - the reversed rotated edge (reversed eRot (in green))\n.   \n.       @returns one of the edges ID of the same quad-edge as the input edge."},
    {"symEdge", CV_PY_FN_WITH_KW_(pyopencv_cv_Subdiv2D_symEdge, 0), "symEdge(edge) -> retval\n."},

    {NULL,          NULL}
};

// Converter (Subdiv2D)

template<>
struct PyOpenCV_Converter< Ptr<cv::Subdiv2D> >
{
    static PyObject* from(const Ptr<cv::Subdiv2D>& r)
    {
        return pyopencv_Subdiv2D_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::Subdiv2D>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::Subdiv2D> * dst_;
        if (pyopencv_Subdiv2D_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::Subdiv2D> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// ThinPlateSplineShapeTransformer (Generic)
//================================================================================

// GetSet (ThinPlateSplineShapeTransformer)



// Methods (ThinPlateSplineShapeTransformer)

static PyObject* pyopencv_cv_ThinPlateSplineShapeTransformer_getRegularizationParameter(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ThinPlateSplineShapeTransformer> * self1 = 0;
    if (!pyopencv_ThinPlateSplineShapeTransformer_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ThinPlateSplineShapeTransformer' or its derivative)");
    Ptr<cv::ThinPlateSplineShapeTransformer> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getRegularizationParameter());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_ThinPlateSplineShapeTransformer_setRegularizationParameter(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::ThinPlateSplineShapeTransformer> * self1 = 0;
    if (!pyopencv_ThinPlateSplineShapeTransformer_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'ThinPlateSplineShapeTransformer' or its derivative)");
    Ptr<cv::ThinPlateSplineShapeTransformer> _self_ = *(self1);
    PyObject* pyobj_beta = NULL;
    double beta=0;

    const char* keywords[] = { "beta", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:ThinPlateSplineShapeTransformer.setRegularizationParameter", (char**)keywords, &pyobj_beta) &&
        pyopencv_to_safe(pyobj_beta, beta, ArgInfo("beta", 0)) )
    {
        ERRWRAP2(_self_->setRegularizationParameter(beta));
        Py_RETURN_NONE;
    }

    return NULL;
}



// Tables (ThinPlateSplineShapeTransformer)

static PyGetSetDef pyopencv_ThinPlateSplineShapeTransformer_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_ThinPlateSplineShapeTransformer_methods[] =
{
    {"getRegularizationParameter", CV_PY_FN_WITH_KW_(pyopencv_cv_ThinPlateSplineShapeTransformer_getRegularizationParameter, 0), "getRegularizationParameter() -> retval\n."},
    {"setRegularizationParameter", CV_PY_FN_WITH_KW_(pyopencv_cv_ThinPlateSplineShapeTransformer_setRegularizationParameter, 0), "setRegularizationParameter(beta) -> None\n.   @brief Set the regularization parameter for relaxing the exact interpolation requirements of the TPS\n.       algorithm.\n.   \n.       @param beta value of the regularization parameter."},

    {NULL,          NULL}
};

// Converter (ThinPlateSplineShapeTransformer)

template<>
struct PyOpenCV_Converter< Ptr<cv::ThinPlateSplineShapeTransformer> >
{
    static PyObject* from(const Ptr<cv::ThinPlateSplineShapeTransformer>& r)
    {
        return pyopencv_ThinPlateSplineShapeTransformer_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::ThinPlateSplineShapeTransformer>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::ThinPlateSplineShapeTransformer> * dst_;
        if (pyopencv_ThinPlateSplineShapeTransformer_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::ThinPlateSplineShapeTransformer> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// TickMeter (Generic)
//================================================================================

// GetSet (TickMeter)



// Methods (TickMeter)

static int pyopencv_cv_TickMeter_TickMeter(pyopencv_TickMeter_t* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        new (&(self->v)) Ptr<cv::TickMeter>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::TickMeter()));
        return 0;
    }

    return -1;
}

static PyObject* pyopencv_cv_TickMeter_getAvgTimeMilli(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::TickMeter> * self1 = 0;
    if (!pyopencv_TickMeter_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'TickMeter' or its derivative)");
    Ptr<cv::TickMeter> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getAvgTimeMilli());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_TickMeter_getAvgTimeSec(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::TickMeter> * self1 = 0;
    if (!pyopencv_TickMeter_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'TickMeter' or its derivative)");
    Ptr<cv::TickMeter> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getAvgTimeSec());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_TickMeter_getCounter(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::TickMeter> * self1 = 0;
    if (!pyopencv_TickMeter_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'TickMeter' or its derivative)");
    Ptr<cv::TickMeter> _self_ = *(self1);
    int64 retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getCounter());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_TickMeter_getFPS(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::TickMeter> * self1 = 0;
    if (!pyopencv_TickMeter_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'TickMeter' or its derivative)");
    Ptr<cv::TickMeter> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getFPS());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_TickMeter_getTimeMicro(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::TickMeter> * self1 = 0;
    if (!pyopencv_TickMeter_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'TickMeter' or its derivative)");
    Ptr<cv::TickMeter> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getTimeMicro());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_TickMeter_getTimeMilli(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::TickMeter> * self1 = 0;
    if (!pyopencv_TickMeter_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'TickMeter' or its derivative)");
    Ptr<cv::TickMeter> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getTimeMilli());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_TickMeter_getTimeSec(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::TickMeter> * self1 = 0;
    if (!pyopencv_TickMeter_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'TickMeter' or its derivative)");
    Ptr<cv::TickMeter> _self_ = *(self1);
    double retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getTimeSec());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_TickMeter_getTimeTicks(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::TickMeter> * self1 = 0;
    if (!pyopencv_TickMeter_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'TickMeter' or its derivative)");
    Ptr<cv::TickMeter> _self_ = *(self1);
    int64 retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getTimeTicks());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_TickMeter_reset(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::TickMeter> * self1 = 0;
    if (!pyopencv_TickMeter_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'TickMeter' or its derivative)");
    Ptr<cv::TickMeter> _self_ = *(self1);

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(_self_->reset());
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_TickMeter_start(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::TickMeter> * self1 = 0;
    if (!pyopencv_TickMeter_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'TickMeter' or its derivative)");
    Ptr<cv::TickMeter> _self_ = *(self1);

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(_self_->start());
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_TickMeter_stop(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::TickMeter> * self1 = 0;
    if (!pyopencv_TickMeter_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'TickMeter' or its derivative)");
    Ptr<cv::TickMeter> _self_ = *(self1);

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(_self_->stop());
        Py_RETURN_NONE;
    }

    return NULL;
}



// Tables (TickMeter)

static PyGetSetDef pyopencv_TickMeter_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_TickMeter_methods[] =
{
    {"getAvgTimeMilli", CV_PY_FN_WITH_KW_(pyopencv_cv_TickMeter_getAvgTimeMilli, 0), "getAvgTimeMilli() -> retval\n."},
    {"getAvgTimeSec", CV_PY_FN_WITH_KW_(pyopencv_cv_TickMeter_getAvgTimeSec, 0), "getAvgTimeSec() -> retval\n."},
    {"getCounter", CV_PY_FN_WITH_KW_(pyopencv_cv_TickMeter_getCounter, 0), "getCounter() -> retval\n."},
    {"getFPS", CV_PY_FN_WITH_KW_(pyopencv_cv_TickMeter_getFPS, 0), "getFPS() -> retval\n."},
    {"getTimeMicro", CV_PY_FN_WITH_KW_(pyopencv_cv_TickMeter_getTimeMicro, 0), "getTimeMicro() -> retval\n."},
    {"getTimeMilli", CV_PY_FN_WITH_KW_(pyopencv_cv_TickMeter_getTimeMilli, 0), "getTimeMilli() -> retval\n."},
    {"getTimeSec", CV_PY_FN_WITH_KW_(pyopencv_cv_TickMeter_getTimeSec, 0), "getTimeSec() -> retval\n."},
    {"getTimeTicks", CV_PY_FN_WITH_KW_(pyopencv_cv_TickMeter_getTimeTicks, 0), "getTimeTicks() -> retval\n."},
    {"reset", CV_PY_FN_WITH_KW_(pyopencv_cv_TickMeter_reset, 0), "reset() -> None\n."},
    {"start", CV_PY_FN_WITH_KW_(pyopencv_cv_TickMeter_start, 0), "start() -> None\n."},
    {"stop", CV_PY_FN_WITH_KW_(pyopencv_cv_TickMeter_stop, 0), "stop() -> None\n."},

    {NULL,          NULL}
};

// Converter (TickMeter)

template<>
struct PyOpenCV_Converter< Ptr<cv::TickMeter> >
{
    static PyObject* from(const Ptr<cv::TickMeter>& r)
    {
        return pyopencv_TickMeter_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::TickMeter>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::TickMeter> * dst_;
        if (pyopencv_TickMeter_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::TickMeter> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// Tonemap (Generic)
//================================================================================

// GetSet (Tonemap)



// Methods (Tonemap)

static PyObject* pyopencv_cv_Tonemap_getGamma(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Tonemap> * self1 = 0;
    if (!pyopencv_Tonemap_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Tonemap' or its derivative)");
    Ptr<cv::Tonemap> _self_ = *(self1);
    float retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getGamma());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_Tonemap_process(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Tonemap> * self1 = 0;
    if (!pyopencv_Tonemap_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Tonemap' or its derivative)");
    Ptr<cv::Tonemap> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_src = NULL;
    Mat src;
    PyObject* pyobj_dst = NULL;
    Mat dst;

    const char* keywords[] = { "src", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|O:Tonemap.process", (char**)keywords, &pyobj_src, &pyobj_dst) &&
        pyopencv_to_safe(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to_safe(pyobj_dst, dst, ArgInfo("dst", 1)) )
    {
        ERRWRAP2(_self_->process(src, dst));
        return pyopencv_from(dst);
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_src = NULL;
    UMat src;
    PyObject* pyobj_dst = NULL;
    UMat dst;

    const char* keywords[] = { "src", "dst", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O|O:Tonemap.process", (char**)keywords, &pyobj_src, &pyobj_dst) &&
        pyopencv_to_safe(pyobj_src, src, ArgInfo("src", 0)) &&
        pyopencv_to_safe(pyobj_dst, dst, ArgInfo("dst", 1)) )
    {
        ERRWRAP2(_self_->process(src, dst));
        return pyopencv_from(dst);
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("process");

    return NULL;
}

static PyObject* pyopencv_cv_Tonemap_setGamma(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Tonemap> * self1 = 0;
    if (!pyopencv_Tonemap_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Tonemap' or its derivative)");
    Ptr<cv::Tonemap> _self_ = *(self1);
    PyObject* pyobj_gamma = NULL;
    float gamma=0.f;

    const char* keywords[] = { "gamma", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:Tonemap.setGamma", (char**)keywords, &pyobj_gamma) &&
        pyopencv_to_safe(pyobj_gamma, gamma, ArgInfo("gamma", 0)) )
    {
        ERRWRAP2(_self_->setGamma(gamma));
        Py_RETURN_NONE;
    }

    return NULL;
}



// Tables (Tonemap)

static PyGetSetDef pyopencv_Tonemap_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_Tonemap_methods[] =
{
    {"getGamma", CV_PY_FN_WITH_KW_(pyopencv_cv_Tonemap_getGamma, 0), "getGamma() -> retval\n."},
    {"process", CV_PY_FN_WITH_KW_(pyopencv_cv_Tonemap_process, 0), "process(src[, dst]) -> dst\n.   @brief Tonemaps image\n.   \n.       @param src source image - CV_32FC3 Mat (float 32 bits 3 channels)\n.       @param dst destination image - CV_32FC3 Mat with values in [0, 1] range"},
    {"setGamma", CV_PY_FN_WITH_KW_(pyopencv_cv_Tonemap_setGamma, 0), "setGamma(gamma) -> None\n."},

    {NULL,          NULL}
};

// Converter (Tonemap)

template<>
struct PyOpenCV_Converter< Ptr<cv::Tonemap> >
{
    static PyObject* from(const Ptr<cv::Tonemap>& r)
    {
        return pyopencv_Tonemap_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::Tonemap>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::Tonemap> * dst_;
        if (pyopencv_Tonemap_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::Tonemap> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// TonemapDrago (Generic)
//================================================================================

// GetSet (TonemapDrago)



// Methods (TonemapDrago)

static PyObject* pyopencv_cv_TonemapDrago_getBias(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::TonemapDrago> * self1 = 0;
    if (!pyopencv_TonemapDrago_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'TonemapDrago' or its derivative)");
    Ptr<cv::TonemapDrago> _self_ = *(self1);
    float retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getBias());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_TonemapDrago_getSaturation(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::TonemapDrago> * self1 = 0;
    if (!pyopencv_TonemapDrago_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'TonemapDrago' or its derivative)");
    Ptr<cv::TonemapDrago> _self_ = *(self1);
    float retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getSaturation());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_TonemapDrago_setBias(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::TonemapDrago> * self1 = 0;
    if (!pyopencv_TonemapDrago_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'TonemapDrago' or its derivative)");
    Ptr<cv::TonemapDrago> _self_ = *(self1);
    PyObject* pyobj_bias = NULL;
    float bias=0.f;

    const char* keywords[] = { "bias", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:TonemapDrago.setBias", (char**)keywords, &pyobj_bias) &&
        pyopencv_to_safe(pyobj_bias, bias, ArgInfo("bias", 0)) )
    {
        ERRWRAP2(_self_->setBias(bias));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_TonemapDrago_setSaturation(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::TonemapDrago> * self1 = 0;
    if (!pyopencv_TonemapDrago_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'TonemapDrago' or its derivative)");
    Ptr<cv::TonemapDrago> _self_ = *(self1);
    PyObject* pyobj_saturation = NULL;
    float saturation=0.f;

    const char* keywords[] = { "saturation", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:TonemapDrago.setSaturation", (char**)keywords, &pyobj_saturation) &&
        pyopencv_to_safe(pyobj_saturation, saturation, ArgInfo("saturation", 0)) )
    {
        ERRWRAP2(_self_->setSaturation(saturation));
        Py_RETURN_NONE;
    }

    return NULL;
}



// Tables (TonemapDrago)

static PyGetSetDef pyopencv_TonemapDrago_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_TonemapDrago_methods[] =
{
    {"getBias", CV_PY_FN_WITH_KW_(pyopencv_cv_TonemapDrago_getBias, 0), "getBias() -> retval\n."},
    {"getSaturation", CV_PY_FN_WITH_KW_(pyopencv_cv_TonemapDrago_getSaturation, 0), "getSaturation() -> retval\n."},
    {"setBias", CV_PY_FN_WITH_KW_(pyopencv_cv_TonemapDrago_setBias, 0), "setBias(bias) -> None\n."},
    {"setSaturation", CV_PY_FN_WITH_KW_(pyopencv_cv_TonemapDrago_setSaturation, 0), "setSaturation(saturation) -> None\n."},

    {NULL,          NULL}
};

// Converter (TonemapDrago)

template<>
struct PyOpenCV_Converter< Ptr<cv::TonemapDrago> >
{
    static PyObject* from(const Ptr<cv::TonemapDrago>& r)
    {
        return pyopencv_TonemapDrago_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::TonemapDrago>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::TonemapDrago> * dst_;
        if (pyopencv_TonemapDrago_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::TonemapDrago> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// TonemapMantiuk (Generic)
//================================================================================

// GetSet (TonemapMantiuk)



// Methods (TonemapMantiuk)

static PyObject* pyopencv_cv_TonemapMantiuk_getSaturation(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::TonemapMantiuk> * self1 = 0;
    if (!pyopencv_TonemapMantiuk_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'TonemapMantiuk' or its derivative)");
    Ptr<cv::TonemapMantiuk> _self_ = *(self1);
    float retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getSaturation());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_TonemapMantiuk_getScale(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::TonemapMantiuk> * self1 = 0;
    if (!pyopencv_TonemapMantiuk_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'TonemapMantiuk' or its derivative)");
    Ptr<cv::TonemapMantiuk> _self_ = *(self1);
    float retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getScale());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_TonemapMantiuk_setSaturation(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::TonemapMantiuk> * self1 = 0;
    if (!pyopencv_TonemapMantiuk_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'TonemapMantiuk' or its derivative)");
    Ptr<cv::TonemapMantiuk> _self_ = *(self1);
    PyObject* pyobj_saturation = NULL;
    float saturation=0.f;

    const char* keywords[] = { "saturation", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:TonemapMantiuk.setSaturation", (char**)keywords, &pyobj_saturation) &&
        pyopencv_to_safe(pyobj_saturation, saturation, ArgInfo("saturation", 0)) )
    {
        ERRWRAP2(_self_->setSaturation(saturation));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_TonemapMantiuk_setScale(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::TonemapMantiuk> * self1 = 0;
    if (!pyopencv_TonemapMantiuk_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'TonemapMantiuk' or its derivative)");
    Ptr<cv::TonemapMantiuk> _self_ = *(self1);
    PyObject* pyobj_scale = NULL;
    float scale=0.f;

    const char* keywords[] = { "scale", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:TonemapMantiuk.setScale", (char**)keywords, &pyobj_scale) &&
        pyopencv_to_safe(pyobj_scale, scale, ArgInfo("scale", 0)) )
    {
        ERRWRAP2(_self_->setScale(scale));
        Py_RETURN_NONE;
    }

    return NULL;
}



// Tables (TonemapMantiuk)

static PyGetSetDef pyopencv_TonemapMantiuk_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_TonemapMantiuk_methods[] =
{
    {"getSaturation", CV_PY_FN_WITH_KW_(pyopencv_cv_TonemapMantiuk_getSaturation, 0), "getSaturation() -> retval\n."},
    {"getScale", CV_PY_FN_WITH_KW_(pyopencv_cv_TonemapMantiuk_getScale, 0), "getScale() -> retval\n."},
    {"setSaturation", CV_PY_FN_WITH_KW_(pyopencv_cv_TonemapMantiuk_setSaturation, 0), "setSaturation(saturation) -> None\n."},
    {"setScale", CV_PY_FN_WITH_KW_(pyopencv_cv_TonemapMantiuk_setScale, 0), "setScale(scale) -> None\n."},

    {NULL,          NULL}
};

// Converter (TonemapMantiuk)

template<>
struct PyOpenCV_Converter< Ptr<cv::TonemapMantiuk> >
{
    static PyObject* from(const Ptr<cv::TonemapMantiuk>& r)
    {
        return pyopencv_TonemapMantiuk_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::TonemapMantiuk>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::TonemapMantiuk> * dst_;
        if (pyopencv_TonemapMantiuk_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::TonemapMantiuk> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// TonemapReinhard (Generic)
//================================================================================

// GetSet (TonemapReinhard)



// Methods (TonemapReinhard)

static PyObject* pyopencv_cv_TonemapReinhard_getColorAdaptation(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::TonemapReinhard> * self1 = 0;
    if (!pyopencv_TonemapReinhard_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'TonemapReinhard' or its derivative)");
    Ptr<cv::TonemapReinhard> _self_ = *(self1);
    float retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getColorAdaptation());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_TonemapReinhard_getIntensity(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::TonemapReinhard> * self1 = 0;
    if (!pyopencv_TonemapReinhard_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'TonemapReinhard' or its derivative)");
    Ptr<cv::TonemapReinhard> _self_ = *(self1);
    float retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getIntensity());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_TonemapReinhard_getLightAdaptation(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::TonemapReinhard> * self1 = 0;
    if (!pyopencv_TonemapReinhard_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'TonemapReinhard' or its derivative)");
    Ptr<cv::TonemapReinhard> _self_ = *(self1);
    float retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getLightAdaptation());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_TonemapReinhard_setColorAdaptation(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::TonemapReinhard> * self1 = 0;
    if (!pyopencv_TonemapReinhard_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'TonemapReinhard' or its derivative)");
    Ptr<cv::TonemapReinhard> _self_ = *(self1);
    PyObject* pyobj_color_adapt = NULL;
    float color_adapt=0.f;

    const char* keywords[] = { "color_adapt", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:TonemapReinhard.setColorAdaptation", (char**)keywords, &pyobj_color_adapt) &&
        pyopencv_to_safe(pyobj_color_adapt, color_adapt, ArgInfo("color_adapt", 0)) )
    {
        ERRWRAP2(_self_->setColorAdaptation(color_adapt));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_TonemapReinhard_setIntensity(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::TonemapReinhard> * self1 = 0;
    if (!pyopencv_TonemapReinhard_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'TonemapReinhard' or its derivative)");
    Ptr<cv::TonemapReinhard> _self_ = *(self1);
    PyObject* pyobj_intensity = NULL;
    float intensity=0.f;

    const char* keywords[] = { "intensity", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:TonemapReinhard.setIntensity", (char**)keywords, &pyobj_intensity) &&
        pyopencv_to_safe(pyobj_intensity, intensity, ArgInfo("intensity", 0)) )
    {
        ERRWRAP2(_self_->setIntensity(intensity));
        Py_RETURN_NONE;
    }

    return NULL;
}

static PyObject* pyopencv_cv_TonemapReinhard_setLightAdaptation(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::TonemapReinhard> * self1 = 0;
    if (!pyopencv_TonemapReinhard_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'TonemapReinhard' or its derivative)");
    Ptr<cv::TonemapReinhard> _self_ = *(self1);
    PyObject* pyobj_light_adapt = NULL;
    float light_adapt=0.f;

    const char* keywords[] = { "light_adapt", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:TonemapReinhard.setLightAdaptation", (char**)keywords, &pyobj_light_adapt) &&
        pyopencv_to_safe(pyobj_light_adapt, light_adapt, ArgInfo("light_adapt", 0)) )
    {
        ERRWRAP2(_self_->setLightAdaptation(light_adapt));
        Py_RETURN_NONE;
    }

    return NULL;
}



// Tables (TonemapReinhard)

static PyGetSetDef pyopencv_TonemapReinhard_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_TonemapReinhard_methods[] =
{
    {"getColorAdaptation", CV_PY_FN_WITH_KW_(pyopencv_cv_TonemapReinhard_getColorAdaptation, 0), "getColorAdaptation() -> retval\n."},
    {"getIntensity", CV_PY_FN_WITH_KW_(pyopencv_cv_TonemapReinhard_getIntensity, 0), "getIntensity() -> retval\n."},
    {"getLightAdaptation", CV_PY_FN_WITH_KW_(pyopencv_cv_TonemapReinhard_getLightAdaptation, 0), "getLightAdaptation() -> retval\n."},
    {"setColorAdaptation", CV_PY_FN_WITH_KW_(pyopencv_cv_TonemapReinhard_setColorAdaptation, 0), "setColorAdaptation(color_adapt) -> None\n."},
    {"setIntensity", CV_PY_FN_WITH_KW_(pyopencv_cv_TonemapReinhard_setIntensity, 0), "setIntensity(intensity) -> None\n."},
    {"setLightAdaptation", CV_PY_FN_WITH_KW_(pyopencv_cv_TonemapReinhard_setLightAdaptation, 0), "setLightAdaptation(light_adapt) -> None\n."},

    {NULL,          NULL}
};

// Converter (TonemapReinhard)

template<>
struct PyOpenCV_Converter< Ptr<cv::TonemapReinhard> >
{
    static PyObject* from(const Ptr<cv::TonemapReinhard>& r)
    {
        return pyopencv_TonemapReinhard_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::TonemapReinhard>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::TonemapReinhard> * dst_;
        if (pyopencv_TonemapReinhard_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::TonemapReinhard> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// Tracker (Generic)
//================================================================================

// GetSet (Tracker)



// Methods (Tracker)

static PyObject* pyopencv_cv_Tracker_init(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Tracker> * self1 = 0;
    if (!pyopencv_Tracker_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Tracker' or its derivative)");
    Ptr<cv::Tracker> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_image = NULL;
    Mat image;
    PyObject* pyobj_boundingBox = NULL;
    Rect boundingBox;

    const char* keywords[] = { "image", "boundingBox", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO:Tracker.init", (char**)keywords, &pyobj_image, &pyobj_boundingBox) &&
        pyopencv_to_safe(pyobj_image, image, ArgInfo("image", 0)) &&
        pyopencv_to_safe(pyobj_boundingBox, boundingBox, ArgInfo("boundingBox", 0)) )
    {
        ERRWRAP2(_self_->init(image, boundingBox));
        Py_RETURN_NONE;
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_image = NULL;
    UMat image;
    PyObject* pyobj_boundingBox = NULL;
    Rect boundingBox;

    const char* keywords[] = { "image", "boundingBox", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO:Tracker.init", (char**)keywords, &pyobj_image, &pyobj_boundingBox) &&
        pyopencv_to_safe(pyobj_image, image, ArgInfo("image", 0)) &&
        pyopencv_to_safe(pyobj_boundingBox, boundingBox, ArgInfo("boundingBox", 0)) )
    {
        ERRWRAP2(_self_->init(image, boundingBox));
        Py_RETURN_NONE;
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("init");

    return NULL;
}

static PyObject* pyopencv_cv_Tracker_update(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::Tracker> * self1 = 0;
    if (!pyopencv_Tracker_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'Tracker' or its derivative)");
    Ptr<cv::Tracker> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_image = NULL;
    Mat image;
    Rect boundingBox;
    bool retval;

    const char* keywords[] = { "image", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:Tracker.update", (char**)keywords, &pyobj_image) &&
        pyopencv_to_safe(pyobj_image, image, ArgInfo("image", 0)) )
    {
        ERRWRAP2(retval = _self_->update(image, boundingBox));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(boundingBox));
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_image = NULL;
    UMat image;
    Rect boundingBox;
    bool retval;

    const char* keywords[] = { "image", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:Tracker.update", (char**)keywords, &pyobj_image) &&
        pyopencv_to_safe(pyobj_image, image, ArgInfo("image", 0)) )
    {
        ERRWRAP2(retval = _self_->update(image, boundingBox));
        return Py_BuildValue("(NN)", pyopencv_from(retval), pyopencv_from(boundingBox));
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("update");

    return NULL;
}



// Tables (Tracker)

static PyGetSetDef pyopencv_Tracker_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_Tracker_methods[] =
{
    {"init", CV_PY_FN_WITH_KW_(pyopencv_cv_Tracker_init, 0), "init(image, boundingBox) -> None\n.   @brief Initialize the tracker with a known bounding box that surrounded the target\n.       @param image The initial frame\n.       @param boundingBox The initial bounding box"},
    {"update", CV_PY_FN_WITH_KW_(pyopencv_cv_Tracker_update, 0), "update(image) -> retval, boundingBox\n.   @brief Update the tracker, find the new most likely bounding box for the target\n.       @param image The current frame\n.       @param boundingBox The bounding box that represent the new target location, if true was returned, not\n.       modified otherwise\n.   \n.       @return True means that target was located and false means that tracker cannot locate target in\n.       current frame. Note, that latter *does not* imply that tracker has failed, maybe target is indeed\n.       missing from the frame (say, out of sight)"},

    {NULL,          NULL}
};

// Converter (Tracker)

template<>
struct PyOpenCV_Converter< Ptr<cv::Tracker> >
{
    static PyObject* from(const Ptr<cv::Tracker>& r)
    {
        return pyopencv_Tracker_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::Tracker>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::Tracker> * dst_;
        if (pyopencv_Tracker_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::Tracker> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// TrackerCSRT (Generic)
//================================================================================

// GetSet (TrackerCSRT)



// Methods (TrackerCSRT)

static PyObject* pyopencv_cv_TrackerCSRT_create_static(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    PyObject* pyobj_parameters = NULL;
    cv::TrackerCSRT::Params parameters=TrackerCSRT::Params();
    Ptr<TrackerCSRT> retval;

    const char* keywords[] = { "parameters", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "|O:TrackerCSRT.create", (char**)keywords, &pyobj_parameters) &&
        pyopencv_to_safe(pyobj_parameters, parameters, ArgInfo("parameters", 0)) )
    {
        ERRWRAP2(retval = cv::TrackerCSRT::create(parameters));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_TrackerCSRT_setInitialMask(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::TrackerCSRT> * self1 = 0;
    if (!pyopencv_TrackerCSRT_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'TrackerCSRT' or its derivative)");
    Ptr<cv::TrackerCSRT> _self_ = *(self1);
    pyPrepareArgumentConversionErrorsStorage(2);

    {
    PyObject* pyobj_mask = NULL;
    Mat mask;

    const char* keywords[] = { "mask", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:TrackerCSRT.setInitialMask", (char**)keywords, &pyobj_mask) &&
        pyopencv_to_safe(pyobj_mask, mask, ArgInfo("mask", 0)) )
    {
        ERRWRAP2(_self_->setInitialMask(mask));
        Py_RETURN_NONE;
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_mask = NULL;
    UMat mask;

    const char* keywords[] = { "mask", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:TrackerCSRT.setInitialMask", (char**)keywords, &pyobj_mask) &&
        pyopencv_to_safe(pyobj_mask, mask, ArgInfo("mask", 0)) )
    {
        ERRWRAP2(_self_->setInitialMask(mask));
        Py_RETURN_NONE;
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("setInitialMask");

    return NULL;
}



// Tables (TrackerCSRT)

static PyGetSetDef pyopencv_TrackerCSRT_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_TrackerCSRT_methods[] =
{
    {"create", CV_PY_FN_WITH_KW_(pyopencv_cv_TrackerCSRT_create_static, METH_STATIC), "create([, parameters]) -> retval\n.   @brief Create CSRT tracker instance\n.       @param parameters CSRT parameters TrackerCSRT::Params"},
    {"setInitialMask", CV_PY_FN_WITH_KW_(pyopencv_cv_TrackerCSRT_setInitialMask, 0), "setInitialMask(mask) -> None\n."},

    {NULL,          NULL}
};

// Converter (TrackerCSRT)

template<>
struct PyOpenCV_Converter< Ptr<cv::TrackerCSRT> >
{
    static PyObject* from(const Ptr<cv::TrackerCSRT>& r)
    {
        return pyopencv_TrackerCSRT_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::TrackerCSRT>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::TrackerCSRT> * dst_;
        if (pyopencv_TrackerCSRT_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::TrackerCSRT> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// TrackerCSRT_Params (Generic)
//================================================================================

// GetSet (TrackerCSRT_Params)


static PyObject* pyopencv_TrackerCSRT_Params_get_admm_iterations(pyopencv_TrackerCSRT_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.admm_iterations);
}

static int pyopencv_TrackerCSRT_Params_set_admm_iterations(pyopencv_TrackerCSRT_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the admm_iterations attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.admm_iterations, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerCSRT_Params_get_background_ratio(pyopencv_TrackerCSRT_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.background_ratio);
}

static int pyopencv_TrackerCSRT_Params_set_background_ratio(pyopencv_TrackerCSRT_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the background_ratio attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.background_ratio, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerCSRT_Params_get_cheb_attenuation(pyopencv_TrackerCSRT_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.cheb_attenuation);
}

static int pyopencv_TrackerCSRT_Params_set_cheb_attenuation(pyopencv_TrackerCSRT_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the cheb_attenuation attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.cheb_attenuation, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerCSRT_Params_get_filter_lr(pyopencv_TrackerCSRT_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.filter_lr);
}

static int pyopencv_TrackerCSRT_Params_set_filter_lr(pyopencv_TrackerCSRT_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the filter_lr attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.filter_lr, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerCSRT_Params_get_gsl_sigma(pyopencv_TrackerCSRT_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.gsl_sigma);
}

static int pyopencv_TrackerCSRT_Params_set_gsl_sigma(pyopencv_TrackerCSRT_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the gsl_sigma attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.gsl_sigma, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerCSRT_Params_get_histogram_bins(pyopencv_TrackerCSRT_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.histogram_bins);
}

static int pyopencv_TrackerCSRT_Params_set_histogram_bins(pyopencv_TrackerCSRT_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the histogram_bins attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.histogram_bins, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerCSRT_Params_get_histogram_lr(pyopencv_TrackerCSRT_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.histogram_lr);
}

static int pyopencv_TrackerCSRT_Params_set_histogram_lr(pyopencv_TrackerCSRT_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the histogram_lr attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.histogram_lr, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerCSRT_Params_get_hog_clip(pyopencv_TrackerCSRT_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.hog_clip);
}

static int pyopencv_TrackerCSRT_Params_set_hog_clip(pyopencv_TrackerCSRT_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the hog_clip attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.hog_clip, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerCSRT_Params_get_hog_orientations(pyopencv_TrackerCSRT_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.hog_orientations);
}

static int pyopencv_TrackerCSRT_Params_set_hog_orientations(pyopencv_TrackerCSRT_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the hog_orientations attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.hog_orientations, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerCSRT_Params_get_kaiser_alpha(pyopencv_TrackerCSRT_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.kaiser_alpha);
}

static int pyopencv_TrackerCSRT_Params_set_kaiser_alpha(pyopencv_TrackerCSRT_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the kaiser_alpha attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.kaiser_alpha, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerCSRT_Params_get_num_hog_channels_used(pyopencv_TrackerCSRT_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.num_hog_channels_used);
}

static int pyopencv_TrackerCSRT_Params_set_num_hog_channels_used(pyopencv_TrackerCSRT_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the num_hog_channels_used attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.num_hog_channels_used, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerCSRT_Params_get_number_of_scales(pyopencv_TrackerCSRT_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.number_of_scales);
}

static int pyopencv_TrackerCSRT_Params_set_number_of_scales(pyopencv_TrackerCSRT_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the number_of_scales attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.number_of_scales, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerCSRT_Params_get_padding(pyopencv_TrackerCSRT_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.padding);
}

static int pyopencv_TrackerCSRT_Params_set_padding(pyopencv_TrackerCSRT_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the padding attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.padding, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerCSRT_Params_get_psr_threshold(pyopencv_TrackerCSRT_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.psr_threshold);
}

static int pyopencv_TrackerCSRT_Params_set_psr_threshold(pyopencv_TrackerCSRT_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the psr_threshold attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.psr_threshold, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerCSRT_Params_get_scale_lr(pyopencv_TrackerCSRT_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.scale_lr);
}

static int pyopencv_TrackerCSRT_Params_set_scale_lr(pyopencv_TrackerCSRT_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the scale_lr attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.scale_lr, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerCSRT_Params_get_scale_model_max_area(pyopencv_TrackerCSRT_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.scale_model_max_area);
}

static int pyopencv_TrackerCSRT_Params_set_scale_model_max_area(pyopencv_TrackerCSRT_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the scale_model_max_area attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.scale_model_max_area, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerCSRT_Params_get_scale_sigma_factor(pyopencv_TrackerCSRT_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.scale_sigma_factor);
}

static int pyopencv_TrackerCSRT_Params_set_scale_sigma_factor(pyopencv_TrackerCSRT_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the scale_sigma_factor attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.scale_sigma_factor, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerCSRT_Params_get_scale_step(pyopencv_TrackerCSRT_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.scale_step);
}

static int pyopencv_TrackerCSRT_Params_set_scale_step(pyopencv_TrackerCSRT_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the scale_step attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.scale_step, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerCSRT_Params_get_template_size(pyopencv_TrackerCSRT_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.template_size);
}

static int pyopencv_TrackerCSRT_Params_set_template_size(pyopencv_TrackerCSRT_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the template_size attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.template_size, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerCSRT_Params_get_use_channel_weights(pyopencv_TrackerCSRT_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.use_channel_weights);
}

static int pyopencv_TrackerCSRT_Params_set_use_channel_weights(pyopencv_TrackerCSRT_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the use_channel_weights attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.use_channel_weights, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerCSRT_Params_get_use_color_names(pyopencv_TrackerCSRT_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.use_color_names);
}

static int pyopencv_TrackerCSRT_Params_set_use_color_names(pyopencv_TrackerCSRT_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the use_color_names attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.use_color_names, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerCSRT_Params_get_use_gray(pyopencv_TrackerCSRT_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.use_gray);
}

static int pyopencv_TrackerCSRT_Params_set_use_gray(pyopencv_TrackerCSRT_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the use_gray attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.use_gray, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerCSRT_Params_get_use_hog(pyopencv_TrackerCSRT_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.use_hog);
}

static int pyopencv_TrackerCSRT_Params_set_use_hog(pyopencv_TrackerCSRT_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the use_hog attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.use_hog, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerCSRT_Params_get_use_rgb(pyopencv_TrackerCSRT_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.use_rgb);
}

static int pyopencv_TrackerCSRT_Params_set_use_rgb(pyopencv_TrackerCSRT_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the use_rgb attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.use_rgb, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerCSRT_Params_get_use_segmentation(pyopencv_TrackerCSRT_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.use_segmentation);
}

static int pyopencv_TrackerCSRT_Params_set_use_segmentation(pyopencv_TrackerCSRT_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the use_segmentation attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.use_segmentation, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerCSRT_Params_get_weights_lr(pyopencv_TrackerCSRT_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.weights_lr);
}

static int pyopencv_TrackerCSRT_Params_set_weights_lr(pyopencv_TrackerCSRT_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the weights_lr attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.weights_lr, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerCSRT_Params_get_window_function(pyopencv_TrackerCSRT_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.window_function);
}

static int pyopencv_TrackerCSRT_Params_set_window_function(pyopencv_TrackerCSRT_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the window_function attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.window_function, ArgInfo("value", 0)) ? 0 : -1;
}


// Methods (TrackerCSRT_Params)

static int pyopencv_cv_TrackerCSRT_Params_TrackerCSRT_Params(pyopencv_TrackerCSRT_Params_t* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        if(self) ERRWRAP2(new (&(self->v)) cv::TrackerCSRT::Params());
        return 0;
    }

    return -1;
}



// Tables (TrackerCSRT_Params)

static PyGetSetDef pyopencv_TrackerCSRT_Params_getseters[] =
{
    {(char*)"admm_iterations", (getter)pyopencv_TrackerCSRT_Params_get_admm_iterations, (setter)pyopencv_TrackerCSRT_Params_set_admm_iterations, (char*)"admm_iterations", NULL},
    {(char*)"background_ratio", (getter)pyopencv_TrackerCSRT_Params_get_background_ratio, (setter)pyopencv_TrackerCSRT_Params_set_background_ratio, (char*)"background_ratio", NULL},
    {(char*)"cheb_attenuation", (getter)pyopencv_TrackerCSRT_Params_get_cheb_attenuation, (setter)pyopencv_TrackerCSRT_Params_set_cheb_attenuation, (char*)"cheb_attenuation", NULL},
    {(char*)"filter_lr", (getter)pyopencv_TrackerCSRT_Params_get_filter_lr, (setter)pyopencv_TrackerCSRT_Params_set_filter_lr, (char*)"filter_lr", NULL},
    {(char*)"gsl_sigma", (getter)pyopencv_TrackerCSRT_Params_get_gsl_sigma, (setter)pyopencv_TrackerCSRT_Params_set_gsl_sigma, (char*)"gsl_sigma", NULL},
    {(char*)"histogram_bins", (getter)pyopencv_TrackerCSRT_Params_get_histogram_bins, (setter)pyopencv_TrackerCSRT_Params_set_histogram_bins, (char*)"histogram_bins", NULL},
    {(char*)"histogram_lr", (getter)pyopencv_TrackerCSRT_Params_get_histogram_lr, (setter)pyopencv_TrackerCSRT_Params_set_histogram_lr, (char*)"histogram_lr", NULL},
    {(char*)"hog_clip", (getter)pyopencv_TrackerCSRT_Params_get_hog_clip, (setter)pyopencv_TrackerCSRT_Params_set_hog_clip, (char*)"hog_clip", NULL},
    {(char*)"hog_orientations", (getter)pyopencv_TrackerCSRT_Params_get_hog_orientations, (setter)pyopencv_TrackerCSRT_Params_set_hog_orientations, (char*)"hog_orientations", NULL},
    {(char*)"kaiser_alpha", (getter)pyopencv_TrackerCSRT_Params_get_kaiser_alpha, (setter)pyopencv_TrackerCSRT_Params_set_kaiser_alpha, (char*)"kaiser_alpha", NULL},
    {(char*)"num_hog_channels_used", (getter)pyopencv_TrackerCSRT_Params_get_num_hog_channels_used, (setter)pyopencv_TrackerCSRT_Params_set_num_hog_channels_used, (char*)"num_hog_channels_used", NULL},
    {(char*)"number_of_scales", (getter)pyopencv_TrackerCSRT_Params_get_number_of_scales, (setter)pyopencv_TrackerCSRT_Params_set_number_of_scales, (char*)"number_of_scales", NULL},
    {(char*)"padding", (getter)pyopencv_TrackerCSRT_Params_get_padding, (setter)pyopencv_TrackerCSRT_Params_set_padding, (char*)"padding", NULL},
    {(char*)"psr_threshold", (getter)pyopencv_TrackerCSRT_Params_get_psr_threshold, (setter)pyopencv_TrackerCSRT_Params_set_psr_threshold, (char*)"psr_threshold", NULL},
    {(char*)"scale_lr", (getter)pyopencv_TrackerCSRT_Params_get_scale_lr, (setter)pyopencv_TrackerCSRT_Params_set_scale_lr, (char*)"scale_lr", NULL},
    {(char*)"scale_model_max_area", (getter)pyopencv_TrackerCSRT_Params_get_scale_model_max_area, (setter)pyopencv_TrackerCSRT_Params_set_scale_model_max_area, (char*)"scale_model_max_area", NULL},
    {(char*)"scale_sigma_factor", (getter)pyopencv_TrackerCSRT_Params_get_scale_sigma_factor, (setter)pyopencv_TrackerCSRT_Params_set_scale_sigma_factor, (char*)"scale_sigma_factor", NULL},
    {(char*)"scale_step", (getter)pyopencv_TrackerCSRT_Params_get_scale_step, (setter)pyopencv_TrackerCSRT_Params_set_scale_step, (char*)"scale_step", NULL},
    {(char*)"template_size", (getter)pyopencv_TrackerCSRT_Params_get_template_size, (setter)pyopencv_TrackerCSRT_Params_set_template_size, (char*)"template_size", NULL},
    {(char*)"use_channel_weights", (getter)pyopencv_TrackerCSRT_Params_get_use_channel_weights, (setter)pyopencv_TrackerCSRT_Params_set_use_channel_weights, (char*)"use_channel_weights", NULL},
    {(char*)"use_color_names", (getter)pyopencv_TrackerCSRT_Params_get_use_color_names, (setter)pyopencv_TrackerCSRT_Params_set_use_color_names, (char*)"use_color_names", NULL},
    {(char*)"use_gray", (getter)pyopencv_TrackerCSRT_Params_get_use_gray, (setter)pyopencv_TrackerCSRT_Params_set_use_gray, (char*)"use_gray", NULL},
    {(char*)"use_hog", (getter)pyopencv_TrackerCSRT_Params_get_use_hog, (setter)pyopencv_TrackerCSRT_Params_set_use_hog, (char*)"use_hog", NULL},
    {(char*)"use_rgb", (getter)pyopencv_TrackerCSRT_Params_get_use_rgb, (setter)pyopencv_TrackerCSRT_Params_set_use_rgb, (char*)"use_rgb", NULL},
    {(char*)"use_segmentation", (getter)pyopencv_TrackerCSRT_Params_get_use_segmentation, (setter)pyopencv_TrackerCSRT_Params_set_use_segmentation, (char*)"use_segmentation", NULL},
    {(char*)"weights_lr", (getter)pyopencv_TrackerCSRT_Params_get_weights_lr, (setter)pyopencv_TrackerCSRT_Params_set_weights_lr, (char*)"weights_lr", NULL},
    {(char*)"window_function", (getter)pyopencv_TrackerCSRT_Params_get_window_function, (setter)pyopencv_TrackerCSRT_Params_set_window_function, (char*)"window_function", NULL},
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_TrackerCSRT_Params_methods[] =
{

    {NULL,          NULL}
};

// Converter (TrackerCSRT_Params)

template<>
struct PyOpenCV_Converter< cv::TrackerCSRT::Params >
{
    static PyObject* from(const cv::TrackerCSRT::Params& r)
    {
        return pyopencv_TrackerCSRT_Params_Instance(r);
    }
    static bool to(PyObject* src, cv::TrackerCSRT::Params& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        cv::TrackerCSRT::Params * dst_;
        if (pyopencv_TrackerCSRT_Params_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected cv::TrackerCSRT::Params for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// TrackerDaSiamRPN (Generic)
//================================================================================

// GetSet (TrackerDaSiamRPN)



// Methods (TrackerDaSiamRPN)

static PyObject* pyopencv_cv_TrackerDaSiamRPN_create_static(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    PyObject* pyobj_parameters = NULL;
    cv::TrackerDaSiamRPN::Params parameters=TrackerDaSiamRPN::Params();
    Ptr<TrackerDaSiamRPN> retval;

    const char* keywords[] = { "parameters", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "|O:TrackerDaSiamRPN.create", (char**)keywords, &pyobj_parameters) &&
        pyopencv_to_safe(pyobj_parameters, parameters, ArgInfo("parameters", 0)) )
    {
        ERRWRAP2(retval = cv::TrackerDaSiamRPN::create(parameters));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_TrackerDaSiamRPN_getTrackingScore(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::TrackerDaSiamRPN> * self1 = 0;
    if (!pyopencv_TrackerDaSiamRPN_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'TrackerDaSiamRPN' or its derivative)");
    Ptr<cv::TrackerDaSiamRPN> _self_ = *(self1);
    float retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getTrackingScore());
        return pyopencv_from(retval);
    }

    return NULL;
}



// Tables (TrackerDaSiamRPN)

static PyGetSetDef pyopencv_TrackerDaSiamRPN_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_TrackerDaSiamRPN_methods[] =
{
    {"create", CV_PY_FN_WITH_KW_(pyopencv_cv_TrackerDaSiamRPN_create_static, METH_STATIC), "create([, parameters]) -> retval\n.   @brief Constructor\n.       @param parameters DaSiamRPN parameters TrackerDaSiamRPN::Params"},
    {"getTrackingScore", CV_PY_FN_WITH_KW_(pyopencv_cv_TrackerDaSiamRPN_getTrackingScore, 0), "getTrackingScore() -> retval\n.   @brief Return tracking score"},

    {NULL,          NULL}
};

// Converter (TrackerDaSiamRPN)

template<>
struct PyOpenCV_Converter< Ptr<cv::TrackerDaSiamRPN> >
{
    static PyObject* from(const Ptr<cv::TrackerDaSiamRPN>& r)
    {
        return pyopencv_TrackerDaSiamRPN_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::TrackerDaSiamRPN>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::TrackerDaSiamRPN> * dst_;
        if (pyopencv_TrackerDaSiamRPN_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::TrackerDaSiamRPN> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// TrackerDaSiamRPN_Params (Generic)
//================================================================================

// GetSet (TrackerDaSiamRPN_Params)


static PyObject* pyopencv_TrackerDaSiamRPN_Params_get_backend(pyopencv_TrackerDaSiamRPN_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.backend);
}

static int pyopencv_TrackerDaSiamRPN_Params_set_backend(pyopencv_TrackerDaSiamRPN_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the backend attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.backend, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerDaSiamRPN_Params_get_kernel_cls1(pyopencv_TrackerDaSiamRPN_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.kernel_cls1);
}

static int pyopencv_TrackerDaSiamRPN_Params_set_kernel_cls1(pyopencv_TrackerDaSiamRPN_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the kernel_cls1 attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.kernel_cls1, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerDaSiamRPN_Params_get_kernel_r1(pyopencv_TrackerDaSiamRPN_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.kernel_r1);
}

static int pyopencv_TrackerDaSiamRPN_Params_set_kernel_r1(pyopencv_TrackerDaSiamRPN_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the kernel_r1 attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.kernel_r1, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerDaSiamRPN_Params_get_model(pyopencv_TrackerDaSiamRPN_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.model);
}

static int pyopencv_TrackerDaSiamRPN_Params_set_model(pyopencv_TrackerDaSiamRPN_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the model attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.model, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerDaSiamRPN_Params_get_target(pyopencv_TrackerDaSiamRPN_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.target);
}

static int pyopencv_TrackerDaSiamRPN_Params_set_target(pyopencv_TrackerDaSiamRPN_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the target attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.target, ArgInfo("value", 0)) ? 0 : -1;
}


// Methods (TrackerDaSiamRPN_Params)

static int pyopencv_cv_TrackerDaSiamRPN_Params_TrackerDaSiamRPN_Params(pyopencv_TrackerDaSiamRPN_Params_t* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        if(self) ERRWRAP2(new (&(self->v)) cv::TrackerDaSiamRPN::Params());
        return 0;
    }

    return -1;
}



// Tables (TrackerDaSiamRPN_Params)

static PyGetSetDef pyopencv_TrackerDaSiamRPN_Params_getseters[] =
{
    {(char*)"backend", (getter)pyopencv_TrackerDaSiamRPN_Params_get_backend, (setter)pyopencv_TrackerDaSiamRPN_Params_set_backend, (char*)"backend", NULL},
    {(char*)"kernel_cls1", (getter)pyopencv_TrackerDaSiamRPN_Params_get_kernel_cls1, (setter)pyopencv_TrackerDaSiamRPN_Params_set_kernel_cls1, (char*)"kernel_cls1", NULL},
    {(char*)"kernel_r1", (getter)pyopencv_TrackerDaSiamRPN_Params_get_kernel_r1, (setter)pyopencv_TrackerDaSiamRPN_Params_set_kernel_r1, (char*)"kernel_r1", NULL},
    {(char*)"model", (getter)pyopencv_TrackerDaSiamRPN_Params_get_model, (setter)pyopencv_TrackerDaSiamRPN_Params_set_model, (char*)"model", NULL},
    {(char*)"target", (getter)pyopencv_TrackerDaSiamRPN_Params_get_target, (setter)pyopencv_TrackerDaSiamRPN_Params_set_target, (char*)"target", NULL},
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_TrackerDaSiamRPN_Params_methods[] =
{

    {NULL,          NULL}
};

// Converter (TrackerDaSiamRPN_Params)

template<>
struct PyOpenCV_Converter< cv::TrackerDaSiamRPN::Params >
{
    static PyObject* from(const cv::TrackerDaSiamRPN::Params& r)
    {
        return pyopencv_TrackerDaSiamRPN_Params_Instance(r);
    }
    static bool to(PyObject* src, cv::TrackerDaSiamRPN::Params& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        cv::TrackerDaSiamRPN::Params * dst_;
        if (pyopencv_TrackerDaSiamRPN_Params_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected cv::TrackerDaSiamRPN::Params for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// TrackerGOTURN (Generic)
//================================================================================

// GetSet (TrackerGOTURN)



// Methods (TrackerGOTURN)

static PyObject* pyopencv_cv_TrackerGOTURN_create_static(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    PyObject* pyobj_parameters = NULL;
    cv::TrackerGOTURN::Params parameters=TrackerGOTURN::Params();
    Ptr<TrackerGOTURN> retval;

    const char* keywords[] = { "parameters", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "|O:TrackerGOTURN.create", (char**)keywords, &pyobj_parameters) &&
        pyopencv_to_safe(pyobj_parameters, parameters, ArgInfo("parameters", 0)) )
    {
        ERRWRAP2(retval = cv::TrackerGOTURN::create(parameters));
        return pyopencv_from(retval);
    }

    return NULL;
}



// Tables (TrackerGOTURN)

static PyGetSetDef pyopencv_TrackerGOTURN_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_TrackerGOTURN_methods[] =
{
    {"create", CV_PY_FN_WITH_KW_(pyopencv_cv_TrackerGOTURN_create_static, METH_STATIC), "create([, parameters]) -> retval\n.   @brief Constructor\n.       @param parameters GOTURN parameters TrackerGOTURN::Params"},

    {NULL,          NULL}
};

// Converter (TrackerGOTURN)

template<>
struct PyOpenCV_Converter< Ptr<cv::TrackerGOTURN> >
{
    static PyObject* from(const Ptr<cv::TrackerGOTURN>& r)
    {
        return pyopencv_TrackerGOTURN_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::TrackerGOTURN>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::TrackerGOTURN> * dst_;
        if (pyopencv_TrackerGOTURN_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::TrackerGOTURN> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// TrackerGOTURN_Params (Generic)
//================================================================================

// GetSet (TrackerGOTURN_Params)


static PyObject* pyopencv_TrackerGOTURN_Params_get_modelBin(pyopencv_TrackerGOTURN_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.modelBin);
}

static int pyopencv_TrackerGOTURN_Params_set_modelBin(pyopencv_TrackerGOTURN_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the modelBin attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.modelBin, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerGOTURN_Params_get_modelTxt(pyopencv_TrackerGOTURN_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.modelTxt);
}

static int pyopencv_TrackerGOTURN_Params_set_modelTxt(pyopencv_TrackerGOTURN_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the modelTxt attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.modelTxt, ArgInfo("value", 0)) ? 0 : -1;
}


// Methods (TrackerGOTURN_Params)

static int pyopencv_cv_TrackerGOTURN_Params_TrackerGOTURN_Params(pyopencv_TrackerGOTURN_Params_t* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        if(self) ERRWRAP2(new (&(self->v)) cv::TrackerGOTURN::Params());
        return 0;
    }

    return -1;
}



// Tables (TrackerGOTURN_Params)

static PyGetSetDef pyopencv_TrackerGOTURN_Params_getseters[] =
{
    {(char*)"modelBin", (getter)pyopencv_TrackerGOTURN_Params_get_modelBin, (setter)pyopencv_TrackerGOTURN_Params_set_modelBin, (char*)"modelBin", NULL},
    {(char*)"modelTxt", (getter)pyopencv_TrackerGOTURN_Params_get_modelTxt, (setter)pyopencv_TrackerGOTURN_Params_set_modelTxt, (char*)"modelTxt", NULL},
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_TrackerGOTURN_Params_methods[] =
{

    {NULL,          NULL}
};

// Converter (TrackerGOTURN_Params)

template<>
struct PyOpenCV_Converter< cv::TrackerGOTURN::Params >
{
    static PyObject* from(const cv::TrackerGOTURN::Params& r)
    {
        return pyopencv_TrackerGOTURN_Params_Instance(r);
    }
    static bool to(PyObject* src, cv::TrackerGOTURN::Params& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        cv::TrackerGOTURN::Params * dst_;
        if (pyopencv_TrackerGOTURN_Params_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected cv::TrackerGOTURN::Params for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// TrackerKCF (Generic)
//================================================================================

// GetSet (TrackerKCF)



// Methods (TrackerKCF)

static PyObject* pyopencv_cv_TrackerKCF_create_static(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    PyObject* pyobj_parameters = NULL;
    cv::TrackerKCF::Params parameters=TrackerKCF::Params();
    Ptr<TrackerKCF> retval;

    const char* keywords[] = { "parameters", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "|O:TrackerKCF.create", (char**)keywords, &pyobj_parameters) &&
        pyopencv_to_safe(pyobj_parameters, parameters, ArgInfo("parameters", 0)) )
    {
        ERRWRAP2(retval = cv::TrackerKCF::create(parameters));
        return pyopencv_from(retval);
    }

    return NULL;
}



// Tables (TrackerKCF)

static PyGetSetDef pyopencv_TrackerKCF_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_TrackerKCF_methods[] =
{
    {"create", CV_PY_FN_WITH_KW_(pyopencv_cv_TrackerKCF_create_static, METH_STATIC), "create([, parameters]) -> retval\n.   @brief Create KCF tracker instance\n.       @param parameters KCF parameters TrackerKCF::Params"},

    {NULL,          NULL}
};

// Converter (TrackerKCF)

template<>
struct PyOpenCV_Converter< Ptr<cv::TrackerKCF> >
{
    static PyObject* from(const Ptr<cv::TrackerKCF>& r)
    {
        return pyopencv_TrackerKCF_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::TrackerKCF>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::TrackerKCF> * dst_;
        if (pyopencv_TrackerKCF_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::TrackerKCF> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// TrackerKCF_Params (Generic)
//================================================================================

// GetSet (TrackerKCF_Params)


static PyObject* pyopencv_TrackerKCF_Params_get_compress_feature(pyopencv_TrackerKCF_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.compress_feature);
}

static int pyopencv_TrackerKCF_Params_set_compress_feature(pyopencv_TrackerKCF_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the compress_feature attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.compress_feature, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerKCF_Params_get_compressed_size(pyopencv_TrackerKCF_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.compressed_size);
}

static int pyopencv_TrackerKCF_Params_set_compressed_size(pyopencv_TrackerKCF_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the compressed_size attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.compressed_size, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerKCF_Params_get_desc_npca(pyopencv_TrackerKCF_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.desc_npca);
}

static int pyopencv_TrackerKCF_Params_set_desc_npca(pyopencv_TrackerKCF_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the desc_npca attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.desc_npca, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerKCF_Params_get_desc_pca(pyopencv_TrackerKCF_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.desc_pca);
}

static int pyopencv_TrackerKCF_Params_set_desc_pca(pyopencv_TrackerKCF_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the desc_pca attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.desc_pca, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerKCF_Params_get_detect_thresh(pyopencv_TrackerKCF_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.detect_thresh);
}

static int pyopencv_TrackerKCF_Params_set_detect_thresh(pyopencv_TrackerKCF_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the detect_thresh attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.detect_thresh, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerKCF_Params_get_interp_factor(pyopencv_TrackerKCF_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.interp_factor);
}

static int pyopencv_TrackerKCF_Params_set_interp_factor(pyopencv_TrackerKCF_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the interp_factor attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.interp_factor, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerKCF_Params_get_lambda(pyopencv_TrackerKCF_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.lambda);
}

static int pyopencv_TrackerKCF_Params_set_lambda(pyopencv_TrackerKCF_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the lambda attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.lambda, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerKCF_Params_get_max_patch_size(pyopencv_TrackerKCF_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.max_patch_size);
}

static int pyopencv_TrackerKCF_Params_set_max_patch_size(pyopencv_TrackerKCF_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the max_patch_size attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.max_patch_size, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerKCF_Params_get_output_sigma_factor(pyopencv_TrackerKCF_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.output_sigma_factor);
}

static int pyopencv_TrackerKCF_Params_set_output_sigma_factor(pyopencv_TrackerKCF_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the output_sigma_factor attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.output_sigma_factor, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerKCF_Params_get_pca_learning_rate(pyopencv_TrackerKCF_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.pca_learning_rate);
}

static int pyopencv_TrackerKCF_Params_set_pca_learning_rate(pyopencv_TrackerKCF_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the pca_learning_rate attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.pca_learning_rate, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerKCF_Params_get_resize(pyopencv_TrackerKCF_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.resize);
}

static int pyopencv_TrackerKCF_Params_set_resize(pyopencv_TrackerKCF_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the resize attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.resize, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerKCF_Params_get_sigma(pyopencv_TrackerKCF_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.sigma);
}

static int pyopencv_TrackerKCF_Params_set_sigma(pyopencv_TrackerKCF_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the sigma attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.sigma, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerKCF_Params_get_split_coeff(pyopencv_TrackerKCF_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.split_coeff);
}

static int pyopencv_TrackerKCF_Params_set_split_coeff(pyopencv_TrackerKCF_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the split_coeff attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.split_coeff, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerKCF_Params_get_wrap_kernel(pyopencv_TrackerKCF_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.wrap_kernel);
}

static int pyopencv_TrackerKCF_Params_set_wrap_kernel(pyopencv_TrackerKCF_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the wrap_kernel attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.wrap_kernel, ArgInfo("value", 0)) ? 0 : -1;
}


// Methods (TrackerKCF_Params)

static int pyopencv_cv_TrackerKCF_Params_TrackerKCF_Params(pyopencv_TrackerKCF_Params_t* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        if(self) ERRWRAP2(new (&(self->v)) cv::TrackerKCF::Params());
        return 0;
    }

    return -1;
}



// Tables (TrackerKCF_Params)

static PyGetSetDef pyopencv_TrackerKCF_Params_getseters[] =
{
    {(char*)"compress_feature", (getter)pyopencv_TrackerKCF_Params_get_compress_feature, (setter)pyopencv_TrackerKCF_Params_set_compress_feature, (char*)"compress_feature", NULL},
    {(char*)"compressed_size", (getter)pyopencv_TrackerKCF_Params_get_compressed_size, (setter)pyopencv_TrackerKCF_Params_set_compressed_size, (char*)"compressed_size", NULL},
    {(char*)"desc_npca", (getter)pyopencv_TrackerKCF_Params_get_desc_npca, (setter)pyopencv_TrackerKCF_Params_set_desc_npca, (char*)"desc_npca", NULL},
    {(char*)"desc_pca", (getter)pyopencv_TrackerKCF_Params_get_desc_pca, (setter)pyopencv_TrackerKCF_Params_set_desc_pca, (char*)"desc_pca", NULL},
    {(char*)"detect_thresh", (getter)pyopencv_TrackerKCF_Params_get_detect_thresh, (setter)pyopencv_TrackerKCF_Params_set_detect_thresh, (char*)"detect_thresh", NULL},
    {(char*)"interp_factor", (getter)pyopencv_TrackerKCF_Params_get_interp_factor, (setter)pyopencv_TrackerKCF_Params_set_interp_factor, (char*)"interp_factor", NULL},
    {(char*)"lambda_", (getter)pyopencv_TrackerKCF_Params_get_lambda, (setter)pyopencv_TrackerKCF_Params_set_lambda, (char*)"lambda_", NULL},
    {(char*)"max_patch_size", (getter)pyopencv_TrackerKCF_Params_get_max_patch_size, (setter)pyopencv_TrackerKCF_Params_set_max_patch_size, (char*)"max_patch_size", NULL},
    {(char*)"output_sigma_factor", (getter)pyopencv_TrackerKCF_Params_get_output_sigma_factor, (setter)pyopencv_TrackerKCF_Params_set_output_sigma_factor, (char*)"output_sigma_factor", NULL},
    {(char*)"pca_learning_rate", (getter)pyopencv_TrackerKCF_Params_get_pca_learning_rate, (setter)pyopencv_TrackerKCF_Params_set_pca_learning_rate, (char*)"pca_learning_rate", NULL},
    {(char*)"resize", (getter)pyopencv_TrackerKCF_Params_get_resize, (setter)pyopencv_TrackerKCF_Params_set_resize, (char*)"resize", NULL},
    {(char*)"sigma", (getter)pyopencv_TrackerKCF_Params_get_sigma, (setter)pyopencv_TrackerKCF_Params_set_sigma, (char*)"sigma", NULL},
    {(char*)"split_coeff", (getter)pyopencv_TrackerKCF_Params_get_split_coeff, (setter)pyopencv_TrackerKCF_Params_set_split_coeff, (char*)"split_coeff", NULL},
    {(char*)"wrap_kernel", (getter)pyopencv_TrackerKCF_Params_get_wrap_kernel, (setter)pyopencv_TrackerKCF_Params_set_wrap_kernel, (char*)"wrap_kernel", NULL},
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_TrackerKCF_Params_methods[] =
{

    {NULL,          NULL}
};

// Converter (TrackerKCF_Params)

template<>
struct PyOpenCV_Converter< cv::TrackerKCF::Params >
{
    static PyObject* from(const cv::TrackerKCF::Params& r)
    {
        return pyopencv_TrackerKCF_Params_Instance(r);
    }
    static bool to(PyObject* src, cv::TrackerKCF::Params& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        cv::TrackerKCF::Params * dst_;
        if (pyopencv_TrackerKCF_Params_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected cv::TrackerKCF::Params for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// TrackerMIL (Generic)
//================================================================================

// GetSet (TrackerMIL)



// Methods (TrackerMIL)

static PyObject* pyopencv_cv_TrackerMIL_create_static(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    PyObject* pyobj_parameters = NULL;
    cv::TrackerMIL::Params parameters=TrackerMIL::Params();
    Ptr<TrackerMIL> retval;

    const char* keywords[] = { "parameters", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "|O:TrackerMIL.create", (char**)keywords, &pyobj_parameters) &&
        pyopencv_to_safe(pyobj_parameters, parameters, ArgInfo("parameters", 0)) )
    {
        ERRWRAP2(retval = cv::TrackerMIL::create(parameters));
        return pyopencv_from(retval);
    }

    return NULL;
}



// Tables (TrackerMIL)

static PyGetSetDef pyopencv_TrackerMIL_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_TrackerMIL_methods[] =
{
    {"create", CV_PY_FN_WITH_KW_(pyopencv_cv_TrackerMIL_create_static, METH_STATIC), "create([, parameters]) -> retval\n.   @brief Create MIL tracker instance\n.        *  @param parameters MIL parameters TrackerMIL::Params"},

    {NULL,          NULL}
};

// Converter (TrackerMIL)

template<>
struct PyOpenCV_Converter< Ptr<cv::TrackerMIL> >
{
    static PyObject* from(const Ptr<cv::TrackerMIL>& r)
    {
        return pyopencv_TrackerMIL_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::TrackerMIL>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::TrackerMIL> * dst_;
        if (pyopencv_TrackerMIL_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::TrackerMIL> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// TrackerMIL_Params (Generic)
//================================================================================

// GetSet (TrackerMIL_Params)


static PyObject* pyopencv_TrackerMIL_Params_get_featureSetNumFeatures(pyopencv_TrackerMIL_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.featureSetNumFeatures);
}

static int pyopencv_TrackerMIL_Params_set_featureSetNumFeatures(pyopencv_TrackerMIL_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the featureSetNumFeatures attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.featureSetNumFeatures, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerMIL_Params_get_samplerInitInRadius(pyopencv_TrackerMIL_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.samplerInitInRadius);
}

static int pyopencv_TrackerMIL_Params_set_samplerInitInRadius(pyopencv_TrackerMIL_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the samplerInitInRadius attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.samplerInitInRadius, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerMIL_Params_get_samplerInitMaxNegNum(pyopencv_TrackerMIL_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.samplerInitMaxNegNum);
}

static int pyopencv_TrackerMIL_Params_set_samplerInitMaxNegNum(pyopencv_TrackerMIL_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the samplerInitMaxNegNum attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.samplerInitMaxNegNum, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerMIL_Params_get_samplerSearchWinSize(pyopencv_TrackerMIL_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.samplerSearchWinSize);
}

static int pyopencv_TrackerMIL_Params_set_samplerSearchWinSize(pyopencv_TrackerMIL_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the samplerSearchWinSize attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.samplerSearchWinSize, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerMIL_Params_get_samplerTrackInRadius(pyopencv_TrackerMIL_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.samplerTrackInRadius);
}

static int pyopencv_TrackerMIL_Params_set_samplerTrackInRadius(pyopencv_TrackerMIL_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the samplerTrackInRadius attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.samplerTrackInRadius, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerMIL_Params_get_samplerTrackMaxNegNum(pyopencv_TrackerMIL_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.samplerTrackMaxNegNum);
}

static int pyopencv_TrackerMIL_Params_set_samplerTrackMaxNegNum(pyopencv_TrackerMIL_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the samplerTrackMaxNegNum attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.samplerTrackMaxNegNum, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerMIL_Params_get_samplerTrackMaxPosNum(pyopencv_TrackerMIL_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.samplerTrackMaxPosNum);
}

static int pyopencv_TrackerMIL_Params_set_samplerTrackMaxPosNum(pyopencv_TrackerMIL_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the samplerTrackMaxPosNum attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.samplerTrackMaxPosNum, ArgInfo("value", 0)) ? 0 : -1;
}


// Methods (TrackerMIL_Params)

static int pyopencv_cv_TrackerMIL_Params_TrackerMIL_Params(pyopencv_TrackerMIL_Params_t* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        if(self) ERRWRAP2(new (&(self->v)) cv::TrackerMIL::Params());
        return 0;
    }

    return -1;
}



// Tables (TrackerMIL_Params)

static PyGetSetDef pyopencv_TrackerMIL_Params_getseters[] =
{
    {(char*)"featureSetNumFeatures", (getter)pyopencv_TrackerMIL_Params_get_featureSetNumFeatures, (setter)pyopencv_TrackerMIL_Params_set_featureSetNumFeatures, (char*)"featureSetNumFeatures", NULL},
    {(char*)"samplerInitInRadius", (getter)pyopencv_TrackerMIL_Params_get_samplerInitInRadius, (setter)pyopencv_TrackerMIL_Params_set_samplerInitInRadius, (char*)"samplerInitInRadius", NULL},
    {(char*)"samplerInitMaxNegNum", (getter)pyopencv_TrackerMIL_Params_get_samplerInitMaxNegNum, (setter)pyopencv_TrackerMIL_Params_set_samplerInitMaxNegNum, (char*)"samplerInitMaxNegNum", NULL},
    {(char*)"samplerSearchWinSize", (getter)pyopencv_TrackerMIL_Params_get_samplerSearchWinSize, (setter)pyopencv_TrackerMIL_Params_set_samplerSearchWinSize, (char*)"samplerSearchWinSize", NULL},
    {(char*)"samplerTrackInRadius", (getter)pyopencv_TrackerMIL_Params_get_samplerTrackInRadius, (setter)pyopencv_TrackerMIL_Params_set_samplerTrackInRadius, (char*)"samplerTrackInRadius", NULL},
    {(char*)"samplerTrackMaxNegNum", (getter)pyopencv_TrackerMIL_Params_get_samplerTrackMaxNegNum, (setter)pyopencv_TrackerMIL_Params_set_samplerTrackMaxNegNum, (char*)"samplerTrackMaxNegNum", NULL},
    {(char*)"samplerTrackMaxPosNum", (getter)pyopencv_TrackerMIL_Params_get_samplerTrackMaxPosNum, (setter)pyopencv_TrackerMIL_Params_set_samplerTrackMaxPosNum, (char*)"samplerTrackMaxPosNum", NULL},
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_TrackerMIL_Params_methods[] =
{

    {NULL,          NULL}
};

// Converter (TrackerMIL_Params)

template<>
struct PyOpenCV_Converter< cv::TrackerMIL::Params >
{
    static PyObject* from(const cv::TrackerMIL::Params& r)
    {
        return pyopencv_TrackerMIL_Params_Instance(r);
    }
    static bool to(PyObject* src, cv::TrackerMIL::Params& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        cv::TrackerMIL::Params * dst_;
        if (pyopencv_TrackerMIL_Params_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected cv::TrackerMIL::Params for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// TrackerNano (Generic)
//================================================================================

// GetSet (TrackerNano)



// Methods (TrackerNano)

static PyObject* pyopencv_cv_TrackerNano_create_static(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    PyObject* pyobj_parameters = NULL;
    cv::TrackerNano::Params parameters=TrackerNano::Params();
    Ptr<TrackerNano> retval;

    const char* keywords[] = { "parameters", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "|O:TrackerNano.create", (char**)keywords, &pyobj_parameters) &&
        pyopencv_to_safe(pyobj_parameters, parameters, ArgInfo("parameters", 0)) )
    {
        ERRWRAP2(retval = cv::TrackerNano::create(parameters));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_TrackerNano_getTrackingScore(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::TrackerNano> * self1 = 0;
    if (!pyopencv_TrackerNano_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'TrackerNano' or its derivative)");
    Ptr<cv::TrackerNano> _self_ = *(self1);
    float retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getTrackingScore());
        return pyopencv_from(retval);
    }

    return NULL;
}



// Tables (TrackerNano)

static PyGetSetDef pyopencv_TrackerNano_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_TrackerNano_methods[] =
{
    {"create", CV_PY_FN_WITH_KW_(pyopencv_cv_TrackerNano_create_static, METH_STATIC), "create([, parameters]) -> retval\n.   @brief Constructor\n.       @param parameters NanoTrack parameters TrackerNano::Params"},
    {"getTrackingScore", CV_PY_FN_WITH_KW_(pyopencv_cv_TrackerNano_getTrackingScore, 0), "getTrackingScore() -> retval\n.   @brief Return tracking score"},

    {NULL,          NULL}
};

// Converter (TrackerNano)

template<>
struct PyOpenCV_Converter< Ptr<cv::TrackerNano> >
{
    static PyObject* from(const Ptr<cv::TrackerNano>& r)
    {
        return pyopencv_TrackerNano_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::TrackerNano>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::TrackerNano> * dst_;
        if (pyopencv_TrackerNano_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::TrackerNano> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// TrackerNano_Params (Generic)
//================================================================================

// GetSet (TrackerNano_Params)


static PyObject* pyopencv_TrackerNano_Params_get_backbone(pyopencv_TrackerNano_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.backbone);
}

static int pyopencv_TrackerNano_Params_set_backbone(pyopencv_TrackerNano_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the backbone attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.backbone, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerNano_Params_get_backend(pyopencv_TrackerNano_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.backend);
}

static int pyopencv_TrackerNano_Params_set_backend(pyopencv_TrackerNano_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the backend attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.backend, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerNano_Params_get_neckhead(pyopencv_TrackerNano_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.neckhead);
}

static int pyopencv_TrackerNano_Params_set_neckhead(pyopencv_TrackerNano_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the neckhead attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.neckhead, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerNano_Params_get_target(pyopencv_TrackerNano_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.target);
}

static int pyopencv_TrackerNano_Params_set_target(pyopencv_TrackerNano_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the target attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.target, ArgInfo("value", 0)) ? 0 : -1;
}


// Methods (TrackerNano_Params)

static int pyopencv_cv_TrackerNano_Params_TrackerNano_Params(pyopencv_TrackerNano_Params_t* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        if(self) ERRWRAP2(new (&(self->v)) cv::TrackerNano::Params());
        return 0;
    }

    return -1;
}



// Tables (TrackerNano_Params)

static PyGetSetDef pyopencv_TrackerNano_Params_getseters[] =
{
    {(char*)"backbone", (getter)pyopencv_TrackerNano_Params_get_backbone, (setter)pyopencv_TrackerNano_Params_set_backbone, (char*)"backbone", NULL},
    {(char*)"backend", (getter)pyopencv_TrackerNano_Params_get_backend, (setter)pyopencv_TrackerNano_Params_set_backend, (char*)"backend", NULL},
    {(char*)"neckhead", (getter)pyopencv_TrackerNano_Params_get_neckhead, (setter)pyopencv_TrackerNano_Params_set_neckhead, (char*)"neckhead", NULL},
    {(char*)"target", (getter)pyopencv_TrackerNano_Params_get_target, (setter)pyopencv_TrackerNano_Params_set_target, (char*)"target", NULL},
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_TrackerNano_Params_methods[] =
{

    {NULL,          NULL}
};

// Converter (TrackerNano_Params)

template<>
struct PyOpenCV_Converter< cv::TrackerNano::Params >
{
    static PyObject* from(const cv::TrackerNano::Params& r)
    {
        return pyopencv_TrackerNano_Params_Instance(r);
    }
    static bool to(PyObject* src, cv::TrackerNano::Params& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        cv::TrackerNano::Params * dst_;
        if (pyopencv_TrackerNano_Params_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected cv::TrackerNano::Params for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// TrackerVit (Generic)
//================================================================================

// GetSet (TrackerVit)



// Methods (TrackerVit)

static PyObject* pyopencv_cv_TrackerVit_create_static(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    PyObject* pyobj_parameters = NULL;
    cv::TrackerVit::Params parameters=TrackerVit::Params();
    Ptr<TrackerVit> retval;

    const char* keywords[] = { "parameters", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "|O:TrackerVit.create", (char**)keywords, &pyobj_parameters) &&
        pyopencv_to_safe(pyobj_parameters, parameters, ArgInfo("parameters", 0)) )
    {
        ERRWRAP2(retval = cv::TrackerVit::create(parameters));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_TrackerVit_getTrackingScore(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::TrackerVit> * self1 = 0;
    if (!pyopencv_TrackerVit_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'TrackerVit' or its derivative)");
    Ptr<cv::TrackerVit> _self_ = *(self1);
    float retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->getTrackingScore());
        return pyopencv_from(retval);
    }

    return NULL;
}



// Tables (TrackerVit)

static PyGetSetDef pyopencv_TrackerVit_getseters[] =
{
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_TrackerVit_methods[] =
{
    {"create", CV_PY_FN_WITH_KW_(pyopencv_cv_TrackerVit_create_static, METH_STATIC), "create([, parameters]) -> retval\n.   @brief Constructor\n.       @param parameters vit tracker parameters TrackerVit::Params"},
    {"getTrackingScore", CV_PY_FN_WITH_KW_(pyopencv_cv_TrackerVit_getTrackingScore, 0), "getTrackingScore() -> retval\n.   @brief Return tracking score"},

    {NULL,          NULL}
};

// Converter (TrackerVit)

template<>
struct PyOpenCV_Converter< Ptr<cv::TrackerVit> >
{
    static PyObject* from(const Ptr<cv::TrackerVit>& r)
    {
        return pyopencv_TrackerVit_Instance(r);
    }
    static bool to(PyObject* src, Ptr<cv::TrackerVit>& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        Ptr<cv::TrackerVit> * dst_;
        if (pyopencv_TrackerVit_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected Ptr<cv::TrackerVit> for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// TrackerVit_Params (Generic)
//================================================================================

// GetSet (TrackerVit_Params)


static PyObject* pyopencv_TrackerVit_Params_get_backend(pyopencv_TrackerVit_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.backend);
}

static int pyopencv_TrackerVit_Params_set_backend(pyopencv_TrackerVit_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the backend attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.backend, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerVit_Params_get_meanvalue(pyopencv_TrackerVit_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.meanvalue);
}

static int pyopencv_TrackerVit_Params_set_meanvalue(pyopencv_TrackerVit_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the meanvalue attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.meanvalue, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerVit_Params_get_net(pyopencv_TrackerVit_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.net);
}

static int pyopencv_TrackerVit_Params_set_net(pyopencv_TrackerVit_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the net attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.net, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerVit_Params_get_stdvalue(pyopencv_TrackerVit_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.stdvalue);
}

static int pyopencv_TrackerVit_Params_set_stdvalue(pyopencv_TrackerVit_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the stdvalue attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.stdvalue, ArgInfo("value", 0)) ? 0 : -1;
}

static PyObject* pyopencv_TrackerVit_Params_get_target(pyopencv_TrackerVit_Params_t* p, void *closure)
{
    return pyopencv_from(p->v.target);
}

static int pyopencv_TrackerVit_Params_set_target(pyopencv_TrackerVit_Params_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the target attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v.target, ArgInfo("value", 0)) ? 0 : -1;
}


// Methods (TrackerVit_Params)

static int pyopencv_cv_TrackerVit_Params_TrackerVit_Params(pyopencv_TrackerVit_Params_t* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        if(self) ERRWRAP2(new (&(self->v)) cv::TrackerVit::Params());
        return 0;
    }

    return -1;
}



// Tables (TrackerVit_Params)

static PyGetSetDef pyopencv_TrackerVit_Params_getseters[] =
{
    {(char*)"backend", (getter)pyopencv_TrackerVit_Params_get_backend, (setter)pyopencv_TrackerVit_Params_set_backend, (char*)"backend", NULL},
    {(char*)"meanvalue", (getter)pyopencv_TrackerVit_Params_get_meanvalue, (setter)pyopencv_TrackerVit_Params_set_meanvalue, (char*)"meanvalue", NULL},
    {(char*)"net", (getter)pyopencv_TrackerVit_Params_get_net, (setter)pyopencv_TrackerVit_Params_set_net, (char*)"net", NULL},
    {(char*)"stdvalue", (getter)pyopencv_TrackerVit_Params_get_stdvalue, (setter)pyopencv_TrackerVit_Params_set_stdvalue, (char*)"stdvalue", NULL},
    {(char*)"target", (getter)pyopencv_TrackerVit_Params_get_target, (setter)pyopencv_TrackerVit_Params_set_target, (char*)"target", NULL},
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_TrackerVit_Params_methods[] =
{

    {NULL,          NULL}
};

// Converter (TrackerVit_Params)

template<>
struct PyOpenCV_Converter< cv::TrackerVit::Params >
{
    static PyObject* from(const cv::TrackerVit::Params& r)
    {
        return pyopencv_TrackerVit_Params_Instance(r);
    }
    static bool to(PyObject* src, cv::TrackerVit::Params& dst, const ArgInfo& info)
    {
        if(!src || src == Py_None)
            return true;
        cv::TrackerVit::Params * dst_;
        if (pyopencv_TrackerVit_Params_getp(src, dst_))
        {
            dst = *dst_;
            return true;
        }
        
        failmsg("Expected cv::TrackerVit::Params for argument '%s'", info.name);
        return false;
    }
};

//================================================================================
// UMat (Generic)
//================================================================================

// GetSet (UMat)


static PyObject* pyopencv_UMat_get_offset(pyopencv_UMat_t* p, void *closure)
{
    return pyopencv_from(p->v->offset);
}

static int pyopencv_UMat_set_offset(pyopencv_UMat_t* p, PyObject *value, void *closure)
{
    if (!value)
    {
        PyErr_SetString(PyExc_TypeError, "Cannot delete the offset attribute");
        return -1;
    }
    return pyopencv_to_safe(value, p->v->offset, ArgInfo("value", 0)) ? 0 : -1;
}


// Methods (UMat)

static int pyopencv_cv_UMat_UMat(pyopencv_UMat_t* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    pyPrepareArgumentConversionErrorsStorage(9);

    {
    PyObject* pyobj_usageFlags = NULL;
    UMatUsageFlags usageFlags=USAGE_DEFAULT;

    const char* keywords[] = { "usageFlags", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "|O:UMat", (char**)keywords, &pyobj_usageFlags) &&
        pyopencv_to_safe(pyobj_usageFlags, usageFlags, ArgInfo("usageFlags", 0)) )
    {
        new (&(self->v)) Ptr<cv::UMat>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::UMat(usageFlags)));
        return 0;
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_rows = NULL;
    int rows=0;
    PyObject* pyobj_cols = NULL;
    int cols=0;
    PyObject* pyobj_type = NULL;
    int type=0;
    PyObject* pyobj_usageFlags = NULL;
    UMatUsageFlags usageFlags=USAGE_DEFAULT;

    const char* keywords[] = { "rows", "cols", "type", "usageFlags", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOO|O:UMat", (char**)keywords, &pyobj_rows, &pyobj_cols, &pyobj_type, &pyobj_usageFlags) &&
        pyopencv_to_safe(pyobj_rows, rows, ArgInfo("rows", 0)) &&
        pyopencv_to_safe(pyobj_cols, cols, ArgInfo("cols", 0)) &&
        pyopencv_to_safe(pyobj_type, type, ArgInfo("type", 0)) &&
        pyopencv_to_safe(pyobj_usageFlags, usageFlags, ArgInfo("usageFlags", 0)) )
    {
        new (&(self->v)) Ptr<cv::UMat>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::UMat(rows, cols, type, usageFlags)));
        return 0;
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_size = NULL;
    Size size;
    PyObject* pyobj_type = NULL;
    int type=0;
    PyObject* pyobj_usageFlags = NULL;
    UMatUsageFlags usageFlags=USAGE_DEFAULT;

    const char* keywords[] = { "size", "type", "usageFlags", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO|O:UMat", (char**)keywords, &pyobj_size, &pyobj_type, &pyobj_usageFlags) &&
        pyopencv_to_safe(pyobj_size, size, ArgInfo("size", 0)) &&
        pyopencv_to_safe(pyobj_type, type, ArgInfo("type", 0)) &&
        pyopencv_to_safe(pyobj_usageFlags, usageFlags, ArgInfo("usageFlags", 0)) )
    {
        new (&(self->v)) Ptr<cv::UMat>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::UMat(size, type, usageFlags)));
        return 0;
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_rows = NULL;
    int rows=0;
    PyObject* pyobj_cols = NULL;
    int cols=0;
    PyObject* pyobj_type = NULL;
    int type=0;
    PyObject* pyobj_s = NULL;
    Scalar s;
    PyObject* pyobj_usageFlags = NULL;
    UMatUsageFlags usageFlags=USAGE_DEFAULT;

    const char* keywords[] = { "rows", "cols", "type", "s", "usageFlags", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOOO|O:UMat", (char**)keywords, &pyobj_rows, &pyobj_cols, &pyobj_type, &pyobj_s, &pyobj_usageFlags) &&
        pyopencv_to_safe(pyobj_rows, rows, ArgInfo("rows", 0)) &&
        pyopencv_to_safe(pyobj_cols, cols, ArgInfo("cols", 0)) &&
        pyopencv_to_safe(pyobj_type, type, ArgInfo("type", 0)) &&
        pyopencv_to_safe(pyobj_s, s, ArgInfo("s", 0)) &&
        pyopencv_to_safe(pyobj_usageFlags, usageFlags, ArgInfo("usageFlags", 0)) )
    {
        new (&(self->v)) Ptr<cv::UMat>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::UMat(rows, cols, type, s, usageFlags)));
        return 0;
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_size = NULL;
    Size size;
    PyObject* pyobj_type = NULL;
    int type=0;
    PyObject* pyobj_s = NULL;
    Scalar s;
    PyObject* pyobj_usageFlags = NULL;
    UMatUsageFlags usageFlags=USAGE_DEFAULT;

    const char* keywords[] = { "size", "type", "s", "usageFlags", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OOO|O:UMat", (char**)keywords, &pyobj_size, &pyobj_type, &pyobj_s, &pyobj_usageFlags) &&
        pyopencv_to_safe(pyobj_size, size, ArgInfo("size", 0)) &&
        pyopencv_to_safe(pyobj_type, type, ArgInfo("type", 0)) &&
        pyopencv_to_safe(pyobj_s, s, ArgInfo("s", 0)) &&
        pyopencv_to_safe(pyobj_usageFlags, usageFlags, ArgInfo("usageFlags", 0)) )
    {
        new (&(self->v)) Ptr<cv::UMat>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::UMat(size, type, s, usageFlags)));
        return 0;
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_m = NULL;
    UMat m;

    const char* keywords[] = { "m", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:UMat", (char**)keywords, &pyobj_m) &&
        pyopencv_to_safe(pyobj_m, m, ArgInfo("m", 0)) )
    {
        new (&(self->v)) Ptr<cv::UMat>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::UMat(m)));
        return 0;
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_m = NULL;
    UMat m;
    PyObject* pyobj_rowRange = NULL;
    Range rowRange;
    PyObject* pyobj_colRange = NULL;
    Range colRange=Range::all();

    const char* keywords[] = { "m", "rowRange", "colRange", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO|O:UMat", (char**)keywords, &pyobj_m, &pyobj_rowRange, &pyobj_colRange) &&
        pyopencv_to_safe(pyobj_m, m, ArgInfo("m", 0)) &&
        pyopencv_to_safe(pyobj_rowRange, rowRange, ArgInfo("rowRange", 0)) &&
        pyopencv_to_safe(pyobj_colRange, colRange, ArgInfo("colRange", 0)) )
    {
        new (&(self->v)) Ptr<cv::UMat>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::UMat(m, rowRange, colRange)));
        return 0;
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_m = NULL;
    UMat m;
    PyObject* pyobj_roi = NULL;
    Rect roi;

    const char* keywords[] = { "m", "roi", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO:UMat", (char**)keywords, &pyobj_m, &pyobj_roi) &&
        pyopencv_to_safe(pyobj_m, m, ArgInfo("m", 0)) &&
        pyopencv_to_safe(pyobj_roi, roi, ArgInfo("roi", 0)) )
    {
        new (&(self->v)) Ptr<cv::UMat>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::UMat(m, roi)));
        return 0;
    }


        pyPopulateArgumentConversionErrors();
    }
    

    {
    PyObject* pyobj_m = NULL;
    UMat m;
    PyObject* pyobj_ranges = NULL;
    vector_Range ranges;

    const char* keywords[] = { "m", "ranges", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "OO:UMat", (char**)keywords, &pyobj_m, &pyobj_ranges) &&
        pyopencv_to_safe(pyobj_m, m, ArgInfo("m", 0)) &&
        pyopencv_to_safe(pyobj_ranges, ranges, ArgInfo("ranges", 0)) )
    {
        new (&(self->v)) Ptr<cv::UMat>(); // init Ptr with placement new
        if(self) ERRWRAP2(self->v.reset(new cv::UMat(m, ranges)));
        return 0;
    }


        pyPopulateArgumentConversionErrors();
    }
    pyRaiseCVOverloadException("UMat");

    return -1;
}

static PyObject* pyopencv_cv_UMat_context_static(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    void* retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = cv_UMat_context());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_UMat_get(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::UMat> * self1 = 0;
    if (!pyopencv_UMat_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'UMat' or its derivative)");
    Ptr<cv::UMat> _self_ = *(self1);
    Mat retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = cv_UMat_get(_self_));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_UMat_handle(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::UMat> * self1 = 0;
    if (!pyopencv_UMat_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'UMat' or its derivative)");
    Ptr<cv::UMat> _self_ = *(self1);
    PyObject* pyobj_accessFlags = NULL;
    AccessFlag accessFlags=static_cast<AccessFlag>(0);
    void* retval;

    const char* keywords[] = { "accessFlags", NULL };
    if( PyArg_ParseTupleAndKeywords(py_args, kw, "O:UMat.handle", (char**)keywords, &pyobj_accessFlags) &&
        pyopencv_to_safe(pyobj_accessFlags, accessFlags, ArgInfo("accessFlags", 0)) )
    {
        ERRWRAP2(retval = _self_->handle(accessFlags));
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_UMat_isContinuous(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::UMat> * self1 = 0;
    if (!pyopencv_UMat_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'UMat' or its derivative)");
    Ptr<cv::UMat> _self_ = *(self1);
    bool retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->isContinuous());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_UMat_isSubmatrix(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;


    Ptr<cv::UMat> * self1 = 0;
    if (!pyopencv_UMat_getp(self, self1))
        return failmsgp("Incorrect type of self (must be 'UMat' or its derivative)");
    Ptr<cv::UMat> _self_ = *(self1);
    bool retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = _self_->isSubmatrix());
        return pyopencv_from(retval);
    }

    return NULL;
}

static PyObject* pyopencv_cv_UMat_queue_static(PyObject* self, PyObject* py_args, PyObject* kw)
{
    using namespace cv;

    void* retval;

    if(PyObject_Size(py_args) == 0 && (!kw || PyObject_Size(kw) == 0))
    {
        ERRWRAP2(retval = cv_UMat_queue());
        return pyopencv_from(retval);
    }

    return NULL;
}



// Tables (UMat)

static PyGetSetDef pyopencv_UMat_getseters[] =
{
    {(char*)"offset", (getter)pyopencv_UMat_get_offset, (setter)pyopencv_UMat_set_offset, (char*)"offset", NULL},
    {NULL}  /* Sentinel */
};

static PyMethodDef pyopencv_UMat_methods[] =
{
    {"context", CV_PY_FN_WITH_KW_(pyopencv_cv_UMat_context_static, METH_STATIC), "context() -> retval\n."},
    {"get", CV_PY_FN_WITH_KW_(pyopencv_cv_UMat_get, 0), "get() -> retval\n."},
    {"handle", CV_PY_FN_WITH_KW_(pyopencv_cv_UMat_handle, 0), "handle(accessFlags) -> retval\n."},
    {"isContinuous", CV_PY_FN_WITH_KW_(pyopencv_cv_UMat_isContinuous, 0), "isContinuous() -> retval\n."},
    {"isSubmatrix", CV_PY_FN_WITH_KW_(pyopencv_cv_UMat_isSubmatrix, 0), "isSubmatrix() -> retval\n."},
    {"queue", CV_PY_FN_WITH_KW_(pyopencv_cv_UMat_queue_static, METH_STATIC), "queue() -> retval\n."},

    {NULL,          NULL}
};

// Converter (UMat)

template<>
struct PyOpenCV_Converter< Ptr<cv::UMat> >
{
    static PyObject